// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: hw_drv.h,v 1.13 2001/08/07 00:44:05 hurdler Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: hw_drv.h,v $
// Revision 1.13  2001/08/07 00:44:05  hurdler
// MD2 implementation is getting better but still need lots of work
//
// Revision 1.12  2001/02/24 13:35:22  bpereira
// no message
//
// Revision 1.11  2001/02/13 20:37:27  metzgermeister
// *** empty log message ***
//
// Revision 1.10  2001/01/05 18:18:39  hurdler
// add renderer version checking
//
// Revision 1.9  2000/11/04 16:23:44  bpereira
// no message
//
// Revision 1.8  2000/10/04 16:21:57  hurdler
// small clean-up
//
// Revision 1.7  2000/08/21 21:13:26  metzgermeister
// SDL support
//
// Revision 1.6  2000/08/10 14:16:25  hurdler
// no message
//
// Revision 1.5  2000/04/14 16:34:26  hurdler
// some nice changes for coronas
//
// Revision 1.4  2000/04/12 19:32:28  metzgermeister
// added GetRenderer function
//
// Revision 1.3  2000/04/07 23:10:15  metzgermeister
// fullscreen support under X in Linux
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      imports/exports for the 3D hardware low-level interface API
//
//-----------------------------------------------------------------------------


#ifndef __HWR_DRV_H__
#define __HWR_DRV_H__

// this must be here 19991024 by Kin
#include "screen.h"
#include "hw_data.h"
#include "hw_defs.h"
#include "hw_md2.h"

// Function declaration for exports from the DLL :
// <return-type> HWRAPI(<function-name>) ( <arguments> ) ;
// If _CREATE_DLL_ is defined the above declaration translates to :
// __declspec(dllexport) <return-type> WINAPI <function-name> ( <arguments> ) ;
// If _CREATE_DLL_ is NOT DEFINED the above declaration translates to :
// __declspec(dllexport) <return->type> (WINAPI *<function-name>) ( <arguments> ) ;

// ==========================================================================
//                                                       STANDARD DLL EXPORTS
// ==========================================================================

typedef void (*I_Error_t) (char *error, ...);

boolean Init(I_Error_t ErrorFunction);
void Shutdown(void) ;
void    SetPalette(RGBA_t* pal, RGBA_t *gamma) ;
#if defined( PURESDL) || defined(__MACOS__)
void SetPalette(int*, RGBA_t *gamma);
#endif
void FinishUpdate( int waitvbl ) ;
void Draw2DLine( F2DCoord * v1, F2DCoord * v2, RGBA_t Color );
void DrawPolygon( FSurfaceInfo  *pSurf,
                                    //FTextureInfo  *pTexInfo,
                                    FOutVector    *pOutVerts,
                                    FUINT         iNumPts,
                                    FBITFIELD     PolyFlags );

void SetBlend( FBITFIELD PolyFlags );

void ClearBuffer( FBOOLEAN ColorMask,
                                    FBOOLEAN DepthMask,
                                    FRGBAFloat *ClearColor );
void SetTexture( FTextureInfo *TexInfo );
void ReadRect(int x, int y, int width, int height, unsigned short * dst_data) ;
void GClipRect(int minx, int miny, int maxx, int maxy, float nearclip) ;
void ClearMipMapCache(void) ;

//Hurdler: added for backward compatibility
void SetSpecialState(hwdspecialstate_t IdState, int Value) ;

//Hurdler: added for new development
void DrawMD2(int *gl_cmd_buffer, md2_frame_t *frame, FTransform *pos, float scale);
void SetTransform(FTransform *transform);
int  GetTextureUsed(void);
int  GetRenderVersion(void);

#ifdef VID_X11 // ifdef to be removed as soon as windoze supports that as well
// metzgermeister: added for Voodoo detection
char *HWRAPI( GetRenderer(void);
#endif

// ==========================================================================
//                                      HWR DRIVER OBJECT, FOR CLIENT PROGRAM
// ==========================================================================

#define pfnInit		Init
#define pfnShutdown	Shutdown
#define pfnGetModeList	GetModeList
#define pfnHookXwin	HookXwin
#define pfnSetPalette	SetPalette
#define pfnFinishUpdate	FinishUpdate
#define pfnDraw2DLine	Draw2DLine
#define pfnDrawPolygon	DrawPolygon
#define pfnSetBlend	SetBlend
#define pfnClearBuffer	ClearBuffer
#define pfnSetTexture	SetTexture
#define pfnReadRect	ReadRect
#define pfnGClipRect	GClipRect
#define pfnClearMipMapCache	ClearMipMapCache
#define pfnSetSpecialState	SetSpecialState
#define pfnDrawMD2	DrawMD2
#define pfnSetTransform	SetTransform
#define pfnGetTextureUsed	GetTextureUsed
#define pfnGetRenderVersion	GetRenderVersion
#define pfnGetRenderer	GetRenderer

#endif __HWR_DRV_H__
