// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id: hw_draw.c,v 1.20 2001/08/09 21:35:23 hurdler Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: hw_draw.c,v $
// Revision 1.20  2001/08/09 21:35:23  hurdler
// Add translucent 3D water in hw mode
//
// Revision 1.19  2001/05/16 21:21:15  bpereira
// no message
//
// Revision 1.18  2001/04/01 17:35:07  bpereira
// no message
//
// Revision 1.17  2001/02/28 17:50:56  bpereira
// no message
//
// Revision 1.16  2001/02/24 13:35:22  bpereira
// no message
//
// Revision 1.15  2001/01/31 17:15:09  hurdler
// Add cv_scalestatusbar in hardware mode
//
// Revision 1.14  2001/01/25 18:56:27  bpereira
// no message
//
// Revision 1.13  2000/11/02 19:49:39  bpereira
// no message
//
// Revision 1.12  2000/10/04 16:21:57  hurdler
// small clean-up
//
// Revision 1.11  2000/09/14 10:42:47  hurdler
// Fix compiling problem under win32
//
// Revision 1.10  2000/09/10 10:48:13  metzgermeister
// *** empty log message ***
//
// Revision 1.9  2000/08/31 14:30:57  bpereira
// no message
//
// Revision 1.8  2000/08/11 19:11:57  metzgermeister
// *** empty log message ***
//
// Revision 1.7  2000/04/27 17:48:47  hurdler
// colormap code in hardware mode is now the default
//
// Revision 1.6  2000/04/24 15:22:47  hurdler
// Support colormap for text
//
// Revision 1.5  2000/04/23 00:30:47  hurdler
// fix a small bug in skin color
//
// Revision 1.4  2000/04/22 21:08:23  hurdler
// I like it better like that
//
// Revision 1.3  2000/04/14 16:34:26  hurdler
// some nice changes for coronas
//
// Revision 1.2  2000/02/27 00:42:11  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:33  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      miscellaneous drawing (mainly 2d)
//
//-----------------------------------------------------------------------------

#include "doomdef.h"

#include "hw_glob.h"
#include "hw_drv.h"

#include "m_misc.h"      //FIL_WriteFile()
#include "r_draw.h"      //viewborderlump
#include "r_main.h"
#include "w_wad.h"
#include "z_zone.h"
#include "v_video.h"

#define O_BINARY 0
#include <fcntl.h>
#include "i_video.h"  // for rendermode != render_glide
#include "r_gu.h"

float   gr_patch_scalex;
float   gr_patch_scaley;

#ifdef WIN32
#pragma pack(1)
#endif
typedef struct {  // sizeof() = 18
  char  id_field_length;
  char  color_map_type;
  char  image_type;
  char  dummy[5];
/*short c_map_origin;
  short c_map_length;
  char  c_map_size;*/
  short x_origin;
  short y_origin;
  short width;
  short height;
  char  image_pix_size;
  char  image_descriptor;
} TGAHeader, *PTGAHeader;
#ifdef WIN32
#pragma pack()
#endif
typedef unsigned char GLRGB[3];
void saveTGA(char *file_name, int width, int height, GLRGB *buffer);

#define BLENDMODE PF_Translucent

// 
// -----------------+
// HWR_DrawPatch    : Draw a 'tile' graphic
// Notes            : x,y : positions relative to the original Doom resolution
//                  : textes(console+score) + menus + status bar
// -----------------+

patch_vertex_t __attribute__((aligned(32))) pv[2];

void HWR_DrawPatch (GlidePatch_t* gpatch, int x, int y, int option)
{
	HWR_GetPatch(gpatch);

	pv[0].x = (float)(x - gpatch->leftoffset);
	pv[0].y = (float)(y - gpatch->topoffset);
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width;
	pv[1].y = pv[0].y + (float)gpatch->height;
	pv[1].z = 0.0f;
	pv[1].u = gpatch->width * 1.0f;
	pv[1].v = gpatch->height * 1.0f;

	GU_DrawPatch(&pv, NULL, 0);
}

void HWR_DrawTransPatch (GlidePatch_t* gpatch, int x, int y, int option)
{
	FSurfaceInfo pSurf;
	pSurf.FlatColor.rgba = 0x80FFFFFF;

	HWR_GetPatch(gpatch);

	pv[0].x = (float)(x - gpatch->leftoffset);
	pv[0].y = (float)(y - gpatch->topoffset);
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width;
	pv[1].y = pv[0].y + (float)gpatch->height;
	pv[1].z = 0.0f;
	pv[1].u = gpatch->width * 1.0f;
	pv[1].v = gpatch->height * 1.0f;

	GU_DrawPatch(&pv, &pSurf, PF_Modulated | PF_Translucent);
}

void HWR_DrawScaledPatch (GlidePatch_t* gpatch, int x, int y, int option)
{
	HWR_GetPatch(gpatch);

	pv[0].x = (float)(x - gpatch->leftoffset);
	pv[0].y = (float)(y - gpatch->topoffset);
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width * vid.fdupx;
	pv[1].y = pv[0].y + (float)gpatch->height * vid.fdupy;
	pv[1].z = 0.0f;
//	pv[1].u = gpatch->width * gpatch->max_t;
	// Begin Duke code modification
	// Fixes full screen patches scaling beyond screen width
//	pv[1].u = 255.0f;
	pv[1].u = gpatch->width * 0.8;
	// End Duke code modification
	pv[1].v = gpatch->height * gpatch->max_s;

	sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	GU_DrawPatch(&pv, NULL, 0);
	sceGuTexFilter(GU_NEAREST,GU_NEAREST);
}

// Begin Duke code modification
// Ugh. This function fixes the end of level animations. If you can replace it with something better,
// 44 virgins will appear and firmly plant themselves on your phallus.
void HWR_DrawScaledEndLevelAnims (GlidePatch_t* gpatch, int x, int y, int option, int animnum)
{
	HWR_GetPatch(gpatch);

	pv[0].x = (float)(x - gpatch->leftoffset);
	pv[0].y = (float)(y - gpatch->topoffset);
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width * vid.fdupx;
	pv[1].y = pv[0].y + (float)gpatch->height * vid.fdupy;
	pv[1].z = 0.0f;

	extern byte gameepisode, gamemap;

	if(gameepisode == 1)
	{
		if(animnum == 0)
		{
			pv[1].x = pv[0].x + (float)gpatch->width * 0.9;
			pv[1].y = pv[0].y + (float)gpatch->height * 0.8;
			pv[1].u = gpatch->width * gpatch->max_t * 0.6;
			pv[1].v = gpatch->height * gpatch->max_s;
		}
		else 	if(animnum == 1)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+1);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.5;
			pv[1].y = pv[0].y + (float)gpatch->height * 0.9;
			pv[1].u = gpatch->width * gpatch->max_t * 1.00001;
			pv[1].v = gpatch->height * gpatch->max_s;
		}
		else 	if(animnum == 2)
		{
			pv[0].x = (float)(x - gpatch->leftoffset);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.49;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.35;
			pv[1].u = gpatch->width * gpatch->max_t * 0.9;
			pv[1].v = gpatch->height * gpatch->max_s * 2;
		}
		else 	if(animnum == 3)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+2);
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.99;
		}
		else 	if(animnum == 4)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+2);
			pv[0].y = (float)(y - gpatch->topoffset);
			pv[1].u = gpatch->width * 0.95;
			pv[1].v = gpatch->height * 0.9;
		}
		else 	if(animnum == 5)
		{
			pv[1].u = gpatch->width * 0.97;
			pv[1].v = gpatch->height * 0.97;
		}
		else 	if(animnum == 6)
	{
			pv[0].x = (float)(x - gpatch->leftoffset+1);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].u = gpatch->width * 0.9;
			pv[1].v = gpatch->height * 0.99;
		}
		else 	if(animnum == 7)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+2);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.95;
		}
		else 	if(animnum == 8)
		{
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.95;
		}
		else 	if(animnum == 9)
	{
			pv[0].x = (float)(x - gpatch->leftoffset+1);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.92;
		}
	}
	else if(gameepisode == 2)
	{
		if(animnum == 7)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset+0.7);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.46;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.3;
			pv[1].u = gpatch->width * gpatch->max_t * 1.3;
			pv[1].v = gpatch->height * gpatch->max_s * 1.1;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset+0.7);
			pv[1].x = pv[0].x + (float)gpatch->width * 0.94;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.2;
			pv[1].u = gpatch->width * gpatch->max_t * 1.0;
			pv[1].v = gpatch->height * gpatch->max_s * 1.0;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
	}
	else if(gameepisode == 3)
	{
		if(animnum == 0)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.75);
			pv[0].y = (float)(y - gpatch->topoffset+0.7);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.498;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.31;
			pv[1].u = gpatch->width * gpatch->max_t * 1.0;
			pv[1].v = gpatch->height * gpatch->max_s * 1.11;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else if(animnum == 1)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.51;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.36;
			pv[1].u = gpatch->width * gpatch->max_t * 1.0;
			pv[1].v = gpatch->height * gpatch->max_s * 1.0;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else if(animnum == 2)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+1);
			pv[0].y = (float)(y - gpatch->topoffset+0.9);
			pv[1].x = pv[0].x + (float)gpatch->width * vid.fdupx * 0.99;
			pv[1].y = pv[0].y + (float)gpatch->height * vid.fdupy * 0.96;
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.97;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else if(animnum == 3)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset+1);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.528;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.35;
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.99;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else if(animnum == 4)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset+0.7);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.48;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.34;
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.99;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
		else if(animnum == 5)
		{
			pv[0].x = (float)(x - gpatch->leftoffset+0.7);
			pv[0].y = (float)(y - gpatch->topoffset);
			pv[1].x = pv[0].x + (float)gpatch->width * 1.485;
			pv[1].y = pv[0].y + (float)gpatch->height * 1.34;
			pv[1].u = gpatch->width * 0.99;
			pv[1].v = gpatch->height * 0.99;
			sceGuTexFilter(GU_LINEAR,GU_LINEAR);
		}
	}
	else
	{
		pv[1].u = gpatch->width * 0.99;
		pv[1].v = gpatch->height * 0.99;
	}
	
	//sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	GU_DrawPatch(&pv, NULL, 0);
	sceGuTexFilter(GU_NEAREST,GU_NEAREST);
}
// End Duke code modification

// 
// HWR_DrawMappedPatch(): Like HWR_DrawPatch but with translated color
//
void HWR_DrawMappedPatch (GlidePatch_t* gpatch, int x, int y, int option, byte *colormap)
{
	HWR_GetMappedPatch (gpatch, colormap);

	pv[0].x = (float)(x - gpatch->leftoffset);
	pv[0].y = (float)(y - gpatch->topoffset);
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width;
	pv[1].y = pv[0].y + (float)gpatch->height;
	pv[1].z = 0.0f;
	pv[1].u = gpatch->width * 1.0f;
	pv[1].v = gpatch->height * 1.0f;

	GU_DrawPatch(&pv, NULL, 0);
}

void HWR_DrawPic(int x, int y, int lumpnum)
{
	GlidePatch_t    *gpatch;
	// make pic ready in hardware cache
	gpatch = HWR_GetPic( lumpnum );

	pv[0].x = (float)x;
	pv[0].y = (float)y;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width;
	pv[1].y = pv[0].y + (float)gpatch->height;
	pv[1].z = 0.0f;
	pv[1].u = (float)gpatch->width * gpatch->max_s;
	pv[1].v = (float)gpatch->height * gpatch->max_t;

	GU_DrawPatch(&pv, NULL, 0); 
}

void HWR_DrawScaledPic(int x, int y, int lumpnum)
{
	GlidePatch_t    *gpatch;
	// make pic ready in hardware cache
	gpatch = HWR_GetPic( lumpnum );

	pv[0].x = (float)x;
	pv[0].y = (float)y;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)gpatch->width * vid.fdupx;
	pv[1].y = pv[0].y + (float)gpatch->height * vid.fdupy;
	pv[1].z = 0.0f;
//	pv[1].u = (float)gpatch->width * gpatch->max_t;
	pv[1].u = 255.0f;
	pv[1].v = (float)gpatch->height * gpatch->max_s;

	sceGuTexFilter(GU_LINEAR,GU_LINEAR);
	GU_DrawPatch(&pv, NULL, 0);
	sceGuTexFilter(GU_NEAREST,GU_NEAREST);
}

// ==========================================================================
//                                                            V_VIDEO.C STUFF
// ==========================================================================


// --------------------------------------------------------------------------
// Fills a box of pixels using a flat texture as a pattern
// --------------------------------------------------------------------------
void HWR_DrawFlatFill (int x, int y, int w, int h, int flatlumpnum)
{
	HWR_GetFlat (flatlumpnum);

	pv[0].x = (float)x;
	pv[0].y = (float)y;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = pv[0].x + (float)w;
	pv[1].y = pv[0].y + (float)h;
	pv[1].z = 0.0f;
	pv[1].u = (float)w;
	pv[1].v = (float)h;

	GU_DrawPatch(&pv, NULL, 0); 
}

void HWR_FadeInvulnerability()
{
	FSurfaceInfo Surf;

	Surf.FlatColor.rgba = 0xFFFFFFFF;

	pv[0].x = 0.0f;
	pv[0].y = 0.0f;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = (float)vid.width;
	pv[1].y = (float)vid.height;
	pv[1].z = 0.0f;

	sceGuBlendFunc(GU_ABS, GU_FIX, GU_FIX, 0, 0);
	GU_DrawPatch(&pv, &Surf, PF_Modulated|PF_NoTexture|PF_Translucent);
	sceGuBlendFunc(GU_ADD, GU_SRC_ALPHA, GU_ONE_MINUS_SRC_ALPHA, 0, 0);
}

// --------------------------------------------------------------------------
// Fade down the screen so that the menu drawn on top of it looks brighter
// --------------------------------------------------------------------------
void HWR_FadeScreenMenuBack(unsigned int color, int height )
{
	FSurfaceInfo Surf;

	Surf.FlatColor.rgba = color;
	if (!height) { //cool hack 0 height is full height
		height = vid.height;
	} else 	Surf.FlatColor.s.alpha = (0xff/2) * ((float)height / vid.height);    //calum: varies console alpha

	pv[0].x = 0.0f;
	pv[0].y = 0.0f;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = (float)vid.width;
	pv[1].y = (float)height;
	pv[1].z = 0.0f;

	GU_DrawPatch(&pv, &Surf, PF_Modulated|PF_NoTexture|PF_Translucent);
}

// ==========================================================================
//                                                     AM_MAP.C DRAWING STUFF
// ==========================================================================

// Clear the automap part of the screen
void HWR_clearAutomap( void )
{
    FRGBAFloat fColor = { 0,0,0,1 };

    //FIXTHIS faB - optimize by clearing only colors ?
    //pfnSetBlend ( PF_NoOcclude );

    // minx,miny,maxx,maxy
//    pfnGClipRect( 0, 0, vid.width , vid.height - stbarheight, 0.9f );
    pfnClearBuffer( true, true, &fColor );
//    pfnGClipRect( 0, 0, vid.width, vid.height, 0.9f );
}


// -----------------+
// HWR_drawAMline   : draw a line of the automap (the clipping is already done in automap code)
// Arg              : color is a RGB 888 value
// -----------------+
void HWR_drawAMline(fline_t* fl, int color )
{
    F2DCoord  v1, v2;
    RGBA_t    color_rgba;

    color_rgba = V_GetColor(color);

    v1.x = fl->a.x * 1.0f;
    v1.y = fl->a.y * 1.0f;
    v2.x = fl->b.x * 1.0f;
    v2.y = fl->b.y * 1.0f;

	GU_DrawLine(&v1, &v2, color_rgba);
}


// -----------------+
// HWR_DrawFill     : draw flat coloured rectangle, with no texture
// -----------------+
void HWR_DrawFill( int x, int y, int w, int h, int color )
{
	FSurfaceInfo Surf;
    
	Surf.FlatColor = V_GetColor(color);
	pv[0].x = (x - 160.0f)/160.0f;
	pv[0].y = -(y - 100.0f)/100.0f;
	pv[0].z = 0.0f;
	pv[0].u = 0.0f;
	pv[0].v = 0.0f;
	pv[1].x = ((x+w) - 160.0f)/160.0f;
	pv[1].y = -((y+h) - 100.0f)/100.0f;
	pv[1].z = 0.0f;
	GU_DrawPatch(&pv, &Surf, PF_Modulated|PF_NoTexture|PF_Translucent);
}


// --------------------------------------------------------------------------
// screen shot
// --------------------------------------------------------------------------
boolean HWR_Screenshot (char *lbmname)
{
    int         i;

    byte*   bufw;
    unsigned short* bufr;
    byte*   dest;
    unsigned short   rgb565;

    bufr = malloc(vid.width*vid.height*2);
    if (!bufr)
        return false;
    bufw = malloc(vid.width*vid.height*3);
    if (!bufw)
    {
        free(bufr);
        return false;
    }

    //returns 16bit 565 RGB
    pfnReadRect (0, 0, vid.width, vid.height, bufr);

    for (dest = bufw,i=0; i<vid.width*vid.height; i++)
    {
        rgb565 = bufr[i];
        *(dest++) = (rgb565 & 31) <<3;
        *(dest++) = ((rgb565 >> 5) & 63) <<2;
        *(dest++) = ((rgb565 >> 11) & 31) <<3;
    }
    free(bufr);
    
    // find a file name to save it to
    strcpy(lbmname,"DOOM000.tga");

    for (i=0 ; i<=999 ; i++)
    {
            lbmname[4] = i/100 + '0';
            lbmname[5] = i/10  + '0';
            lbmname[6] = i%10  + '0';
            if (access(lbmname,0) == -1)
                break;  // file doesn't exist
    }
    if (i<1000)
    {
        // save the file
        saveTGA(lbmname, vid.width, vid.height, (GLRGB *)bufw);
        free(bufw);
        return true;
    }

    free(bufw);
    return false;
}


// --------------------------------------------------------------------------
// save screenshots with TGA format
// --------------------------------------------------------------------------
void saveTGA(char *file_name, int width, int height, GLRGB *buffer)
{
    int fd;
    long size;
    TGAHeader tga_hdr;

    fd = open(file_name, O_WRONLY | O_CREAT | O_TRUNC | O_BINARY, 0666);
    if (fd < 0)
        return;

    memset(&tga_hdr, 0, sizeof(tga_hdr));
    tga_hdr.width = SHORT(width);
    tga_hdr.height = SHORT(height);
    tga_hdr.image_pix_size = 24;
    tga_hdr.image_type = 2;
    tga_hdr.image_descriptor = 32;
    size = (long)width * (long)height * 3L;

    write(fd, &tga_hdr, sizeof(TGAHeader));
    write(fd, buffer, size);
    close(fd);
}

