// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: g_input.c,v 1.12 2002/08/24 22:42:02 hurdler Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: g_input.c,v $
// Revision 1.12  2002/08/24 22:42:02  hurdler
// Apply Robert Hogberg patches
//
// Revision 1.11  2002/07/01 19:59:58  metzgermeister
// *** empty log message ***
//
// Revision 1.10  2001/03/30 17:12:49  bpereira
// no message
//
// Revision 1.9  2001/02/24 13:35:19  bpereira
// no message
//
// Revision 1.8  2001/02/10 12:27:13  bpereira
// no message
//
// Revision 1.7  2001/01/25 22:15:42  bpereira
// added heretic support
//
// Revision 1.6  2000/11/26 00:46:31  hurdler
// small bug fixes
//
// Revision 1.5  2000/10/04 17:03:57  hurdler
// This is the formule I propose for mouse sensitivity
//
// Revision 1.4  2000/04/16 18:38:07  bpereira
// no message
//
// Revision 1.3  2000/04/04 00:32:45  stroggonmeth
// Initial Boom compatability plus few misc changes all around.
//
// Revision 1.2  2000/02/27 00:42:10  hurdler
// fix CR+LF problem
//
// Revision 1.1.1.1  2000/02/22 20:32:32  hurdler
// Initial import into CVS (v1.29 pr3)
//
//
// DESCRIPTION:
//      handle mouse/keyboard/joystick inputs,
//      maps inputs to game controls (forward,use,open...)
//
//-----------------------------------------------------------------------------


#include "doomdef.h"
#include "doomstat.h"
#include "g_input.h"
#include "keys.h"
#include "hu_stuff.h"   //need HUFONT start & end
#include "keys.h"
#include "d_net.h"
#include "console.h"

CV_PossibleValue_t mousesens_cons_t[]={{1,"MIN"},{MAXMOUSESENSITIVITY,"MAXCURSOR"},{MAXINT,"MAX"},{0,NULL}};
CV_PossibleValue_t onecontrolperkey_cons_t[]={{1,"One"},{2,"Several"},{0,NULL}};

// mouse values are used once
consvar_t  cv_analogsensx    = {"analogsensx","18",CV_SAVE,mousesens_cons_t};
consvar_t  cv_analogsensy    = {"analogsensy","16",CV_SAVE,mousesens_cons_t};
consvar_t  cv_mousesensy    = {"analogsens","20",CV_SAVE,mousesens_cons_t};
consvar_t  cv_mlooksens    = {"alooksens","19",CV_SAVE,mousesens_cons_t};
consvar_t  cv_mousesens2   = {"mousesens2","10",0,mousesens_cons_t};
consvar_t  cv_mlooksens2   = {"mlooksens2","10",0,mousesens_cons_t};
consvar_t  cv_allowjump    = {"allowjump","1",CV_NETVAR,CV_YesNo};
consvar_t  cv_allowautoaim = {"allowautoaim","1",CV_NETVAR,CV_YesNo};
consvar_t  cv_controlperkey = {"controlperkey","1",0,onecontrolperkey_cons_t};
//SoM: 3/28/2000: Working rocket jumping.
consvar_t  cv_allowrocketjump = {"allowrocketjump","1",CV_NETVAR,CV_YesNo};


int             mousex;
int             mousey;
int             mlooky;         //like mousey but with a custom sensitivity
                                //for mlook
int             mouse2x;
int             mouse2y;
int             mlook2y;

// joystick values are repeated
int             joyxmove;
int             joyymove;

// current state of the keys : true if pushed
byte    gamekeydown[NUMINPUTS];

// two key codes (or virtual key) per game control
int     gamecontrol[num_gamecontrols][2];
int     gamecontrolbis[num_gamecontrols][2];        // secondary splitscreen player


typedef struct {
    int time;
    int state;
    int clicks;
} dclick_t;
static  dclick_t  mousedclicks[MOUSEBUTTONS];
static  dclick_t  joydclicks[JOYBUTTONS];



// protos
static boolean G_CheckDoubleClick (int state, dclick_t *dt);


//
//  Remaps the inputs to game controls.
//
//  A game control can be triggered by one or more keys/buttons.
//
//  Each key/mousebutton/joybutton triggers ONLY ONE game control.
//
//
void  G_MapEventsToControls (event_t *ev)
{
    int    i,flag;

    switch (ev->type)
    {
      case ev_keydown:
        if (ev->data1 <NUMINPUTS)
            gamekeydown[ev->data1] = 1;
        break;

      case ev_keyup:
        if (ev->data1 <NUMINPUTS)
            gamekeydown[ev->data1] = 0;
        break;

      case ev_mouse:           // buttons hare virtual keys
        mousex = ev->data2*((cv_analogsensx.value)/5.5f + 0.1f);
        mousey = ev->data3*((cv_analogsensy.value)/5.5f + 0.1f);

        //added:10-02-98:
        // for now I use the mlook sensitivity just for mlook,
        // instead of having a general mouse y sensitivity.
        mlooky = ev->data3*((cv_mlooksens.value*cv_mlooksens.value)/110.0f + 0.1f);
        break;

      case ev_joystick:        // buttons are virtual keys
        joyxmove = ev->data2;
        joyymove = ev->data3;
        break;

      case ev_mouse2:           // buttons hare virtual keys
        mouse2x = ev->data2*((cv_mousesens2.value*cv_mousesens2.value)/110.0f + 0.1);
        mouse2y = ev->data3*((cv_mousesens2.value*cv_mousesens2.value)/110.0f + 0.1);

        //added:10-02-98:
        // for now I use the mlook sensitivity just for mlook,
        // instead of having a general mouse y sensitivity.
        mlook2y = ev->data3*((cv_mlooksens.value*cv_mlooksens.value)/110.0f + 0.1);
        break;

      default:
        break;

    }

    // ALWAYS check for mouse & joystick double-clicks
    // even if no mouse event
    for (i=0;i<MOUSEBUTTONS;i++)
    {
        flag = G_CheckDoubleClick (gamekeydown[KEY_MOUSE1+i], &mousedclicks[i]);
        gamekeydown[KEY_DBLMOUSE1+i] = flag;
    }

    for (i=0;i<JOYBUTTONS;i++)
    {
        flag = G_CheckDoubleClick (gamekeydown[KEY_JOY1+i], &joydclicks[i]);
        gamekeydown[KEY_DBLJOY1+i] = flag;
    }
}


//
//  General double-click detection routine for any kind of input.
//
static boolean G_CheckDoubleClick (int state, dclick_t *dt)
{
    if (state != dt->state && dt->time > 1 )
    {
        dt->state = state;
        if (state)
            dt->clicks++;
        if (dt->clicks == 2)
        {
            dt->clicks = 0;
            return true;
        }
        else
            dt->time = 0;
    }
    else
    {
        dt->time ++;
        if (dt->time > 20)
        {
            dt->clicks = 0;
            dt->state = 0;
        }
    }
    return false;
}


typedef struct {
    int  keynum;
    char name[15];
} keyname_t;

static keyname_t keynames[] = {
    {KEY_UPARROW, "UP"},
    {KEY_DOWNARROW, "DOWN"},
    {KEY_LEFTARROW, "LEFT"},
    {KEY_RIGHTARROW, "RIGHT"},
    {KEY_TRIANGLE, "TRIANGLE"},
    {KEY_SQUARE, "SQUARE"},
    {KEY_CIRCLE, "CIRCLE"},
    {KEY_CROSS, "CROSS"},
    {KEY_L, "*L*"},
    {KEY_R, "*R*"},
    {KEY_START,"START"}
};

char *gamecontrolname[num_gamecontrols] =
{
    "nothing",        //a key/button mapped to gc_null has no effect
    "forward",
    "backward",
    "strafe",
    "straferight",
    "strafeleft",
    "speed",
    "turnleft",
    "turnright",
    "fire",
    "use",
    "lookup",
    "lookdown",
    "centerview",
    "mouseaiming",
    "weapon1",
    "weapon2",
    "weapon3",
    "weapon4",
    "weapon5",
    "weapon6",
    "weapon7",
    "weapon8",
    "talkkey",
    "scores",
    "jump",
    "console",
    "nextweapon",
    "prevweapon",
    "bestweapon",
    "inventorynext",
    "inventoryprev",
    "inventoryuse",
    "down"
};

#define NUMKEYNAMES (sizeof(keynames)/sizeof(keyname_t))

//
//  Detach any keys associated to the given game control
//  - pass the pointer to the gamecontrol table for the player being edited
void  G_ClearControlKeys (int (*setupcontrols)[2], int control)
{
    setupcontrols[control][0] = KEY_NULL;
    setupcontrols[control][1] = KEY_NULL;
}

//
//  Returns the name of a key (or virtual key for mouse and joy)
//  the input value being an keynum
//
char* G_KeynumToString (int keynum)
{
static char keynamestr[8];

    int    j;

    // return a string with the ascii char if displayable
    if (keynum>' ' && keynum<='z')
    {
        keynamestr[0] = keynum;
        keynamestr[1] = '\0';
        return keynamestr;
    }

    // find a description for special keys
    for (j=0;j<NUMKEYNAMES;j++)
        if (keynames[j].keynum==keynum)
            return keynames[j].name;

    // create a name for Unknown key
    sprintf (keynamestr,"KEY%d",keynum);
    return keynamestr;
}


int G_KeyStringtoNum(char *keystr)
{
    int j;

//    strupr(keystr);

    if(keystr[1]==0 && keystr[0]>' ' && keystr[0]<='z')
        return keystr[0];

    for (j=0;j<NUMKEYNAMES;j++)
        if (stricmp(keynames[j].name,keystr)==0)
            return keynames[j].keynum;

    if(strlen(keystr)>3)
        return atoi(&keystr[3]);

    return 0;
}

void G_Controldefault(void)
{
    gamecontrol[gc_forward    ][0]=KEY_TRIANGLE;
    gamecontrol[gc_backward   ][0]=KEY_CROSS;
    gamecontrol[gc_straferight][0]=KEY_CIRCLE;
    gamecontrol[gc_strafeleft ][0]=KEY_SQUARE;
    gamecontrol[gc_fire       ][0]=KEY_R;
    gamecontrol[gc_use        ][0]=KEY_L;
//    gamecontrol[gc_scores     ][0]='f';
//    gamecontrol[gc_console    ][0]=KEY_CONSOLE;
    gamecontrol[gc_nextweapon ][0]=KEY_RIGHTARROW;
    gamecontrol[gc_prevweapon ][0]=KEY_LEFTARROW;

    if( gamemode == heretic ) {
        gamecontrol[gc_invnext    ][0] = KEY_UPARROW;
        gamecontrol[gc_invprev    ][0] = KEY_DOWNARROW;
        gamecontrol[gc_invuse     ][0] = KEY_START;
    } else {
        gamecontrol[gc_jump       ][0] = KEY_UPARROW;
        gamecontrol[gc_console    ][0] = KEY_DOWNARROW;
    }
}

void G_SaveKeySetting(FILE *f)
{
    int i;

    for(i=1;i<num_gamecontrols;i++)
       {
           fprintf(f,"setcontrol \"%s\" \"%s\""
                    ,gamecontrolname[i]
                    ,G_KeynumToString(gamecontrol[i][0]));

           if(gamecontrol[i][1])
               fprintf(f," \"%s\"\n"
                        ,G_KeynumToString(gamecontrol[i][1]));
           else
               fprintf(f,"\n");
       }

/*    for(i=1;i<num_gamecontrols;i++)
       {
           fprintf(f,"setcontrol2 \"%s\" \"%s\""
                    ,gamecontrolname[i]
                    ,G_KeynumToString(gamecontrolbis[i][0]));

           if(gamecontrolbis[i][1])
               fprintf(f," \"%s\"\n"
                        ,G_KeynumToString(gamecontrolbis[i][1]));
           else
               fprintf(f,"\n");
       }*/
}

void G_CheckDoubleUsage(int keynum)
{
    if( cv_controlperkey.value==1 )
    {
        int i;
        for(i=0;i<num_gamecontrols;i++)
        {
            if( gamecontrol[i][0]==keynum )
                gamecontrol[i][0]= KEY_NULL;
            if( gamecontrol[i][1]==keynum )
                gamecontrol[i][1]= KEY_NULL;
            if( gamecontrolbis[i][0]==keynum )
                gamecontrolbis[i][0]= KEY_NULL;
            if( gamecontrolbis[i][1]==keynum )
                gamecontrolbis[i][1]= KEY_NULL;
        }
    }
}

void setcontrol(int (*gc)[2],int na)
{
    int numctrl;
    char *namectrl;
    int keynum;

    namectrl=COM_Argv(1);
    for(numctrl=0;numctrl<num_gamecontrols
                  && stricmp(namectrl,gamecontrolname[numctrl])
                 ;numctrl++);
    if(numctrl==num_gamecontrols)
    {
        CONS_Printf("Control '%s' unknown\n",namectrl);
        return;
    }
    keynum=G_KeyStringtoNum(COM_Argv(2));
    G_CheckDoubleUsage(keynum);
    gc[numctrl][0]=keynum;

    if(na==4)
        gc[numctrl][1]=G_KeyStringtoNum(COM_Argv(3));
    else
        gc[numctrl][1]=0;
}

void Command_Setcontrol_f(void)
{
    int na;

    na= COM_Argc();

    if ( na!= 3 && na!=4)
    {
        CONS_Printf ("setcontrol <controlname> <keyname> [<2nd keyname>]\n");
        return;
    }

    setcontrol(gamecontrol,na);
}

void Command_Setcontrol2_f(void)
{
    int na;

    na= COM_Argc();

    if ( na!= 3 && na!=4)
    {
        CONS_Printf ("setcontrol2 <controlname> <keyname> [<2nd keyname>]\n");
        return;
    }

    setcontrol(gamecontrolbis,na);
}
