// Emacs style mode select   -*- C++ -*-
//-----------------------------------------------------------------------------
//
// $Id: byteptr.h,v 1.5 2000/10/21 08:43:28 bpereira Exp $
//
// Copyright (C) 1998-2000 by DooM Legacy Team.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
//
// $Log: byteptr.h,v $
// Revision 1.5  2000/10/21 08:43:28  bpereira
// no message
//
// Revision 1.4  2000/04/16 18:38:06  bpereira
// no message
//
//
// DESCRIPTION:
//    Macro to read/write from/to a char*, used for packet cration and such...
//
//-----------------------------------------------------------------------------

#define WRITEBYTE(p,b)      {writebyte(p,b); p += sizeof(byte);}
#define WRITECHAR(p,b)      {writechar(p,b); p += sizeof(char);}
#define WRITESHORT(p,b)     {writeshort(p,b); p += sizeof(short);}
#define WRITEUSHORT(p,b)    {writeushort(p,b); p += sizeof(USHORT);}
#define WRITELONG(p,b)      {writelong(p,b); p += sizeof(long);}
#define WRITEULONG(p,b)     {writeulong(p,b); p += sizeof(ULONG);}
#define WRITEFIXED(p,b)     {writefixed(p,b); p += sizeof(fixed_t);}
#define WRITEANGLE(p,b)     {writeangle(p,b); p += sizeof(angle_t);}
#define WRITESTRING(p,b)    { int tmp_i=0; do { WRITECHAR(p,b[tmp_i]); } while(b[tmp_i++]); }
#define WRITESTRINGN(p,b,n) { int tmp_i=0; do { WRITECHAR(p,b[tmp_i]); if(!b[tmp_i]) break;tmp_i++; } while(tmp_i<n); }
#define WRITEMEM(p,s,n)     memcpy(p, s, n);p+=n

#define READBYTE(p)         readbyte(p);p += sizeof(byte);
#define READCHAR(p)         readchar(p);p += sizeof(char);
#define READSHORT(p)        readshort(p);p += sizeof(short);
#define READUSHORT(p)       readushort(p);p += sizeof(USHORT);
#define READLONG(p)         readlong(p);p += sizeof(long);
#define READULONG(p)        readulong(p);p += sizeof(ULONG);
#define READFIXED(p)        readfixed(p);p += sizeof(fixed_t);
#define READANGLE(p)        readangle(p);p += sizeof(angle_t);
#define READSTRING(p,s)     { int tmp_i=0; do { s[tmp_i]=READBYTE(p);  } while(s[tmp_i++]); }
#define SKIPSTRING(p)       p+=strlen(p)+1;//while(READBYTE(p))
#define READMEM(p,s,n)      memcpy(s, p, n);p+=n

