/*	NEW STYLE 2.60~PRESENT ENCRYPTION (16 byte key, single layer of scrambling)
*
*	0x10 byte keys from mesg_led.prx
*/

/* kernel modules 2.60-2.71 */
u8 keys260_0[0x10] = {
	0xC3, 0x24, 0x89, 0xD3, 0x80, 0x87, 0xB2, 0x4E,
	0x4C, 0xD7, 0x49, 0xE4, 0x9D, 0x1D, 0x34, 0xD1

};

/* user modules 2.60-2.71 */
u8 keys260_1[0x10] = {
	0xF3, 0xAC, 0x6E, 0x7C, 0x04, 0x0A, 0x23, 0xE7,
	0x0D, 0x33, 0xD8, 0x24, 0x73, 0x39, 0x2B, 0x4A
};

/* vshmain 2.60-2.71 */
u8 keys260_2[0x10] = {
	0x72, 0xB4, 0x39, 0xFF, 0x34, 0x9B, 0xAE, 0x82,
	0x30, 0x34, 0x4A, 0x1D, 0xA2, 0xD8, 0xB4, 0x3C
};

/* kernel modules 2.80 */
u8 keys280_0[0x10] = {
	0xCA, 0xFB, 0xBF, 0xC7, 0x50, 0xEA, 0xB4, 0x40,
	0x8E, 0x44, 0x5C, 0x63, 0x53, 0xCE, 0x80, 0xB1
};

/* user modules 2.80 */
u8 keys280_1[0x10] = {
	0x40, 0x9B, 0xC6, 0x9B, 0xA9, 0xFB, 0x84, 0x7F,
	0x72, 0x21, 0xD2, 0x36, 0x96, 0x55, 0x09, 0x74
};

/* vshmain executable 2.80 */
u8 keys280_2[0x10] = {
	0x03, 0xA7, 0xCC, 0x4A, 0x5B, 0x91, 0xC2, 0x07,
	0xFF, 0xFC, 0x26, 0x25, 0x1E, 0x42, 0x4B, 0xB5
};

/* kernel modules 3.00 */
u8 keys300_0[0x10] = {
	0x9F, 0x67, 0x1A, 0x7A, 0x22, 0xF3, 0x59, 0x0B, 
    0xAA, 0x6D, 0xA4, 0xC6, 0x8B, 0xD0, 0x03, 0x77

};

/* user modules 3.00 */
u8 keys300_1[0x10] = {
	0x15, 0x07, 0x63, 0x26, 0xDB, 0xE2, 0x69, 0x34, 
   	0x56, 0x08, 0x2A, 0x93, 0x4E, 0x4B, 0x8A, 0xB2

};

/* vshmain 3.00 */
u8 keys300_2[0x10] = {
	0x56, 0x3B, 0x69, 0xF7, 0x29, 0x88, 0x2F, 0x4C, 
   	0xDB, 0xD5, 0xDE, 0x80, 0xC6, 0x5C, 0xC8, 0x73

};

/* kernel modules 3.00 */
u8 keys303_0[0x10] = {
	0x7b, 0xa1, 0xe2, 0x5a, 0x91, 0xb9, 0xd3, 0x13,
	0x77, 0x65, 0x4a, 0xb7, 0xc2, 0x8a, 0x10, 0xaf
};

/* kernel modules 3.10 */
u8 keys310_0[0x10] = {
	0xa2, 0x41, 0xe8, 0x39, 0x66, 0x5b, 0xfa, 0xbb,
	0x1b, 0x2d, 0x6e, 0x0e, 0x33, 0xe5, 0xd7, 0x3f
};

/* user modules 3.10 */
u8 keys310_1[0x10] = {
	0xA4, 0x60, 0x8F, 0xAB, 0xAB, 0xDE, 0xA5, 0x65,
	0x5D, 0x43, 0x3A, 0xD1, 0x5E, 0xC3, 0xFF, 0xEA
};

/* vshmain 3.10 */
u8 keys310_2[0x10] = {
	0xE7, 0x5C, 0x85, 0x7A, 0x59, 0xB4, 0xE3, 0x1D,
	0xD0, 0x9E, 0xCE, 0xC2, 0xD6, 0xD4, 0xBD, 0x2B
};

/* reboot.bin 3.10 */
u8 keys310_3[0x10] = {
   	0x2E, 0x00, 0xF6, 0xF7, 0x52, 0xCF, 0x95, 0x5A,
   	0xA1, 0x26, 0xB4, 0x84, 0x9B, 0x58, 0x76, 0x2F
};

/* kernel modules 3.30 */ 
u8 keys330_0[0x10] = { 
	0x3B, 0x9B, 0x1A, 0x56, 0x21, 0x80, 0x14, 0xED,
	0x8E, 0x8B, 0x08, 0x42, 0xFA, 0x2C, 0xDC, 0x3A
};

/* user modules 3.30 */ 
u8 keys330_1[0x10] = { 
   	0xE8, 0xBE, 0x2F, 0x06, 0xB1, 0x05, 0x2A, 0xB9, 
   	0x18, 0x18, 0x03, 0xE3, 0xEB, 0x64, 0x7D, 0x26 
}; 

/* vshmain 3.30 */ 
u8 keys330_2[0x10] = { 
   	0xAB, 0x82, 0x25, 0xD7, 0x43, 0x6F, 0x6C, 0xC1, 
   	0x95, 0xC5, 0xF7, 0xF0, 0x63, 0x73, 0x3F, 0xE7 
}; 

/* reboot.bin 3.30 */ 
u8 keys330_3[0x10] = { 
   	0xA8, 0xB1, 0x47, 0x77, 0xDC, 0x49, 0x6A, 0x6F, 
   	0x38, 0x4C, 0x4D, 0x96, 0xBD, 0x49, 0xEC, 0x9B 
}; 

/* stdio.prx 3.30 */
u8 keys330_4[0x10] = {
	0xEC, 0x3B, 0xD2, 0xC0, 0xFA, 0xC1, 0xEE, 0xB9,
	0x9A, 0xBC, 0xFF, 0xA3, 0x89, 0xF2, 0x60, 0x1F
};

/* demo data.psp 2.80 */
u8 demokeys_280[0x10] = {
	0x12, 0x99, 0x70, 0x5E, 0x24, 0x07, 0x6C, 0xD0,
	0x2D, 0x06, 0xFE, 0x7E, 0xB3, 0x0C, 0x11, 0x26
};

/* demo data.psp 3.XX */
u8 demokeys_3XX_1[0x10] = {
	0x47, 0x05, 0xD5, 0xE3, 0x56, 0x1E, 0x81, 0x9B,
	0x09, 0x2F, 0x06, 0xDB, 0x6B, 0x12, 0x92, 0xE0
};

/* demo data.psp 3.XX */
u8 demokeys_3XX_2[0x10] = {
	0xF6, 0x62, 0x39, 0x6E, 0x26, 0x22, 0x4D, 0xCA,
	0x02, 0x64, 0x16, 0x99, 0x7B, 0x9A, 0xE7, 0xB8
};

/* new 2.7X eboot.bin */
u8 ebootbin_271_new[0x10] = {
	0xF4, 0xAE, 0xF4, 0xE1, 0x86, 0xDD, 0xD2, 0x9C,
	0x7C, 0xC5, 0x42, 0xA6, 0x95, 0xA0, 0x83, 0x88
};

/* new 2.8X eboot.bin */
u8 ebootbin_280_new[0x10] = {
	0xB8, 0x8C, 0x45, 0x8B, 0xB6, 0xE7, 0x6E, 0xB8,
	0x51, 0x59, 0xA6, 0x53, 0x7C, 0x5E, 0x86, 0x31
};

/* new 3.XX eboot.bin */
u8 ebootbin_300_new[0x10] = {
	0xED, 0x10, 0xE0, 0x36, 0xC4, 0xFE, 0x83, 0xF3,
	0x75, 0x70, 0x5E, 0xF6, 0xA4, 0x40, 0x05, 0xF7
};

/* new 3.XX eboot.bin */
u8 ebootbin_310_new[0x10] = {
	0x5C, 0x77, 0x0C, 0xBB, 0xB4, 0xC2, 0x4F, 0xA2,
	0x7E, 0x3B, 0x4E, 0xB4, 0xB4, 0xC8, 0x70, 0xAF
};

/* 2.60-2.71 gameshare */
u8 gameshare_260_271[0x10] = {
	0xF9, 0x48, 0x38, 0x0C, 0x96, 0x88, 0xA7, 0x74,
	0x4F, 0x65, 0xA0, 0x54, 0xC2, 0x76, 0xD9, 0xB8
};

/* 2.80 gameshare */
u8 gameshare_280[0x10] = {
	0x2D, 0x86, 0x77, 0x3A, 0x56, 0xA4, 0x4F, 0xDD,
	0x3C, 0x16, 0x71, 0x93, 0xAA, 0x8E, 0x11, 0x43
};

/* 3.00 gameshare */
u8 gameshare_300[0x10] = {
	0x78, 0x1A, 0xD2, 0x87, 0x24, 0xBD, 0xA2, 0x96,
	0x18, 0x3F, 0x89, 0x36, 0x72, 0x90, 0x92, 0x85
};

/* 3.10 gameshare */
u8 gameshare_310[0x10] = {
	0xC9, 0x7D, 0x3E, 0x0A, 0x54, 0x81, 0x6E, 0xC7,
	0x13, 0x74, 0x99, 0x74, 0x62, 0x18, 0xE7, 0xDD
};

/* 3.60 common kernel modules */
u8 keys360_0[0x10] = {
	0x3C, 0x2B, 0x51, 0xD4, 0x2D, 0x85, 0x47, 0xDA, 
	0x2D, 0xCA, 0x18, 0xDF, 0xFE, 0x54, 0x09, 0xED
};

/* 3.60 specific slim kernel modules */
u8 keys360_1[0x10] = {
	0x31, 0x1F, 0x98, 0xD5, 0x7B, 0x58, 0x95, 0x45, 
	0x32, 0xAB, 0x3A, 0xE3, 0x89, 0x32, 0x4B, 0x34
};

/* 3.70 common and fat kernel modules */
u8 keys370_0[0x10] = {
	0x26, 0x38, 0x0A, 0xAC, 0xA5, 0xD8, 0x74, 0xD1, 
	0x32, 0xB7, 0x2A, 0xBF, 0x79, 0x9E, 0x6D, 0xDB
};

/* 3.70 slim specific kernel modules */
u8 keys370_1[0x10] = {
	0x53, 0xE7, 0xAB, 0xB9, 0xC6, 0x4A, 0x4B, 0x77, 
	0x92, 0x17, 0xB5, 0x74, 0x0A, 0xDA, 0xA9, 0xEA
};

/* some 3.70 slim user modules */
u8 keys370_2[0x10] = {
	0x71, 0x10, 0xF0, 0xA4, 0x16, 0x14, 0xD5, 0x93, 
	0x12, 0xFF, 0x74, 0x96, 0xDF, 0x1F, 0xDA, 0x89
};

/* 1SEG.PBP keys */
u8 oneseg_310[0x10] = {
    0xC7, 0x27, 0x72, 0x85, 0xAB, 0xA7, 0xF7, 0xF0,
    0x4C, 0xC1, 0x86, 0xCC, 0xE3, 0x7F, 0x17, 0xCA
};

u8 oneseg_300[0x10] = {
    0x76, 0x40, 0x9E, 0x08, 0xDB, 0x9B, 0x3B, 0xA1,
    0x47, 0x8A, 0x96, 0x8E, 0xF3, 0xF7, 0x62, 0x92
};
 
u8 oneseg_280[0x10] = {
    0x23, 0xDC, 0x3B, 0xB5, 0xA9, 0x82, 0xD6, 0xEA,
    0x63, 0xA3, 0x6E, 0x2B, 0x2B, 0xE9, 0xE1, 0x54
};
 
u8 oneseg_260_271[0x10] = {
    0x22, 0x43, 0x57, 0x68, 0x2F, 0x41, 0xCE, 0x65,
    0x4C, 0xA3, 0x7C, 0xC6, 0xC4, 0xAC, 0xF3, 0x60
};

u8 oneseg_slim[0x10] ={
	0x12, 0x57, 0x0D, 0x8A, 0x16, 0x6D, 0x87, 0x06,
	0x03, 0x7D, 0xC8, 0x8B, 0x62, 0xA3, 0x32, 0xA9
};

u8 ms_app_main[0x10] ={
	0x1E, 0x2E, 0x38, 0x49, 0xDA, 0xD4, 0x16, 0x08,
	0x27, 0x2E, 0xF3, 0xBC, 0x37, 0x75, 0x80, 0x93
};

/* 3.90 kernel */
u8 keys390_0[0x10] = {
	0x45, 0xEF, 0x5C, 0x5D, 0xED, 0x81, 0x99, 0x84,
	0x12, 0x94, 0x8F, 0xAB, 0xE8, 0x05, 0x6D, 0x7D
};

/* 3.90 slim */
u8 keys390_1[0x10] = {
	0x70, 0x1B, 0x08, 0x25, 0x22, 0xA1, 0x4D, 0x3B, 
	0x69, 0x21, 0xF9, 0x71, 0x0A, 0xA8, 0x41, 0xA9
};

/* 5.00 kernel */
u8 keys500_0[0x10] = {
	0xEB, 0x1B, 0x53, 0x0B, 0x62, 0x49, 0x32, 0x58, 
	0x1F, 0x83, 0x0A, 0xF4, 0x99, 0x3D, 0x75, 0xD0
};

/* 5.00 kernel 2000 specific */
u8 keys500_1[0x10] = {
	0xBA, 0xE2, 0xA3, 0x12, 0x07, 0xFF, 0x04, 0x1B, 
	0x64, 0xA5, 0x11, 0x85, 0xF7, 0x2F, 0x99, 0x5B
};

/* 5.00 kernel 3000 specific */
u8 keys500_2[0x10] = {
	0x2C, 0x8E, 0xAF, 0x1D, 0xFF, 0x79, 0x73, 0x1A, 
 	0xAD, 0x96, 0xAB, 0x09, 0xEA, 0x35, 0x59, 0x8B
};

u8 keys500_c[16] = {
	0xA3, 0x5D, 0x51, 0xE6, 0x56, 0xC8, 0x01, 0xCA,
	0xE3, 0x77, 0xBF, 0xCD, 0xFF, 0x24, 0xDA, 0x4D
};

/* 5.05 kernel specific */
u8 keys505_a[16] ={
	0x7B, 0x94, 0x72, 0x27, 0x4C, 0xCC, 0x54, 0x3B,
	0xAE, 0xDF, 0x46, 0x37, 0xAC, 0x01, 0x4D, 0x87
};

u8 keys505_0[16] ={
	0x2E, 0x8E, 0x97, 0xA2, 0x85, 0x42, 0x70, 0x73,
	0x18, 0xDA, 0xA0, 0x8A, 0xF8, 0x62, 0xA2, 0xB0
};

u8 keys505_1[16] ={
	0x58, 0x2A, 0x4C, 0x69, 0x19, 0x7B, 0x83, 0x3D,
	0xD2, 0x61, 0x61, 0xFE, 0x14, 0xEE, 0xAA, 0x11
};

/* for psp 2000 file table and ipl pre-decryption */
u8 keys02G_E[0x10] = {
	0x9D, 0x09, 0xFD, 0x20, 0xF3, 0x8F, 0x10, 0x69, 
	0x0D, 0xB2, 0x6F, 0x00, 0xCC, 0xC5, 0x51, 0x2E
};

/* for psp 3000 file table and ipl pre-decryption */
u8 keys03G_E[0x10] = 
{
	0x4F, 0x44, 0x5C, 0x62, 0xB3, 0x53, 0xC4, 0x30, 
 	0xFC, 0x3A, 0xA4, 0x5B, 0xEC, 0xFE, 0x51, 0xEA
};

u8 key_D91609F0[0x10] =
{
	0xD0, 0x36, 0x12, 0x75, 0x80, 0x56, 0x20, 0x43,
	0xC4, 0x30, 0x94, 0x3E, 0x1C, 0x75, 0xD1, 0xBF
};
u8 key_D9160AF0[0x10] =
{
	0x10, 0xA9, 0xAC, 0x16, 0xAE, 0x19, 0xC0, 0x7E,
	0x3B, 0x60, 0x77, 0x86, 0x01, 0x6F, 0xF2, 0x63
};
u8 key_D9160BF0[0x10] =
{
	0x83, 0x83, 0xF1, 0x37, 0x53, 0xD0, 0xBE, 0xFC,
	0x8D, 0xA7, 0x32, 0x52, 0x46, 0x0A, 0xC2, 0xC2
};
u8 key_D91611F0[0x10] =
{
	0x61, 0xB0, 0xC0, 0x58, 0x71, 0x57, 0xD9, 0xFA,
	0x74, 0x67, 0x0E, 0x5C, 0x7E, 0x6E, 0x95, 0xB9
};

u8 key_D91612F0[0x10] = /* UMD EBOOT.BIN (OPNSSMP.BIN) */
{
	0x9E, 0x20, 0xE1, 0xCD, 0xD7, 0x88, 0xDE, 0xC0,
	0x31, 0x9B, 0x10, 0xAF, 0xC5, 0xB8, 0x73, 0x23
};

u8 key_D91613F0[0x10] = 
{
	0xEB, 0xFF, 0x40, 0xD8, 0xB4, 0x1A, 0xE1, 0x66,
	0x91, 0x3B, 0x8F, 0x64, 0xB6, 0xFC, 0xB7, 0x12
};

u8 key_D91614F0[0x10] =
{
        0xFD, 0xF7, 0xB7, 0x3C, 0x9F, 0xD1, 0x33, 0x95,
        0x11, 0xB8, 0xB5, 0xBB, 0x54, 0x23, 0x73, 0x85
};

u8 key_2E5E10F0[0x10] = /* UMD EBOOT.BIN 2 (OPNSSMP.BIN) */
{
	0x9D, 0x5C, 0x5B, 0xAF, 0x8C, 0xD8, 0x69, 0x7E,
	0x51, 0x9F, 0x70, 0x96, 0xE6, 0xD5, 0xC4, 0xE8
};

u8 key_2E5E12F0[0x10] = /* UMD EBOOT.BIN 3 (OPNSSMP.BIN) */
{
	0x8A, 0x7B, 0xC9, 0xD6, 0x52, 0x58, 0x88, 0xEA,
	0x51, 0x83, 0x60, 0xCA, 0x16, 0x79, 0xE2, 0x07
};

u8 key_2E5E13F0[0x10] =
{
	0xFF, 0xA4, 0x68, 0xC3, 0x31, 0xCA, 0xB7, 0x4C,
	0xF1, 0x23, 0xFF, 0x01, 0x65, 0x3D, 0x26, 0x36
};

u8 keys600_u1_457B0BF0[0x10] = 
{
	0x7B, 0x94, 0x72, 0x27, 0x4C, 0xCC, 0x54, 0x3B,
	0xAE, 0xDF, 0x46, 0x37, 0xAC, 0x01, 0x4D, 0x87
};

u8 keys600_u1_457B0CF0[0x10] = 
{
	0xAC, 0x34, 0xBA, 0xB1, 0x97, 0x8D, 0xAE, 0x6F,
	0xBA, 0xE8, 0xB1, 0xD6, 0xDF, 0xDF, 0xF1, 0xA2
};

/* for psp go file table and ipl pre-decryption */
u8 keys05G_E[0x10] = {
	0x5D, 0xAA, 0x72, 0xF2, 0x26, 0x60, 0x4D, 0x1C,
	0xE7, 0x2D, 0xC8, 0xA3, 0x2F, 0x79, 0xC5, 0x54
};

/* 5.70 PSPgo kernel*/
u8 keys570_5k[0x10] = {
	0x6D, 0x72, 0xA4, 0xBA, 0x7F, 0xBF, 0xD1, 0xF1,
	0xA9, 0xF3, 0xBB, 0x07, 0x1B, 0xC0, 0xB3, 0x66
};

/* 6.00-6.20 kernel and phat */
u8 keys620_0[0x10] = {
	0xD6, 0xBD, 0xCE, 0x1E, 0x12, 0xAF, 0x9A, 0xE6,
	0x69, 0x30, 0xDE, 0xDA, 0x88, 0xB8, 0xFF, 0xFB
};

/* 6.00-6.20 slim kernel */
u8 keys620_1[0x10] = {
	0x1D, 0x13, 0xE9, 0x50, 0x04, 0x73, 0x3D, 0xD2,
	0xE1, 0xDA, 0xB9, 0xC1, 0xE6, 0x7B, 0x25, 0xA7
};

u8 keys620_3[0x10] ={
	0xA3, 0x5D, 0x51, 0xE6, 0x56, 0xC8, 0x01, 0xCA,
	0xE3, 0x77, 0xBF, 0xCD, 0xFF, 0x24, 0xDA, 0x4D
};

u8 keys620_e[0x10] = {
	0xB1, 0xB3, 0x7F, 0x76, 0xC3, 0xFB, 0x88, 0xE6,
	0xF8, 0x60, 0xD3, 0x35, 0x3C, 0xA3, 0x4E, 0xF3
};

/* PSPgo internal */
u8 keys620_5[0x10] ={
	0xF1, 0xBC, 0x17, 0x07, 0xAE, 0xB7, 0xC8, 0x30,
	0xD8, 0x34, 0x9D, 0x40, 0x6A, 0x8E, 0xDF, 0x4E
};

/* 6.XX PSPgo kernel */
u8 keys620_5k[0x10] ={
	0x41, 0x8A, 0x35, 0x4F, 0x69, 0x3A, 0xDF, 0x04,
	0xFD, 0x39, 0x46, 0xA2, 0x5C, 0x2D, 0xF2, 0x21
};

u8 keys620_5v[0x10] ={
	0xF2, 0x8F, 0x75, 0xA7, 0x31, 0x91, 0xCE, 0x9E,
	0x75, 0xBD, 0x27, 0x26, 0xB4, 0xB4, 0x0C, 0x32
};

/* unknown... */
u8 key_21C0[16] = {
	0x6A, 0x19, 0x71, 0xF3, 0x18, 0xDE, 0xD3, 0xA2,
	0x6D, 0x3B, 0xDE, 0xC7, 0xBE, 0x98, 0xE2, 0x4C
};

u8 key_2250[16] = {
	0x50, 0xCC, 0x03, 0xAC, 0x3F, 0x53, 0x1A, 0xFA,
	0x0A, 0xA4, 0x34, 0x23, 0x86, 0x61, 0x7F, 0x97
};

u8 key_22E0[16] = {
	0x66, 0x0F, 0xCB, 0x3B, 0x30, 0x75, 0xE3, 0x10,
	0x0A, 0x95, 0x65, 0xC7, 0x3C, 0x93, 0x87, 0x22
};

u8 key_2D80[16] = {
	0x40, 0x02, 0xC0, 0xBF, 0x20, 0x02, 0xC0, 0xBF,
	0x5C, 0x68, 0x2B, 0x95, 0x5F, 0x40, 0x7B, 0xB8
};

u8 key_2D90[16] = {
	0x55, 0x19, 0x35, 0x10, 0x48, 0xD8, 0x2E, 0x46,
	0xA8, 0xB1, 0x47, 0x77, 0xDC, 0x49, 0x6A, 0x6F
};

u8 key_2DA8[16] = {
	0x80, 0x02, 0xC0, 0xBF, 0x00, 0x0A, 0xC0, 0xBF,
	0x40, 0x03, 0xC0, 0xBF, 0x40, 0x00, 0x00, 0x00
};

u8 key_2DB8[16] = {
	0x4C, 0x2D, 0x00, 0x00, 0x00, 0xFF, 0xFF, 0x00,
	0xB8, 0x15, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00
};

/* 6.30 phat kernel */ 
u8 key_4c9484f0[16] = {
	0x36, 0xB0, 0xDC, 0xFC, 0x59, 0x2A, 0x95, 0x1D, 
	0x80, 0x2D, 0x80, 0x3F, 0xCD, 0x30, 0xA0, 0x1B,
};

/* 6.30 phat kernel-2 */
u8 key_457b80f0[16] = {
	0xd4, 0x35, 0x18, 0x02, 0x29, 0x68, 0xfb, 0xa0, 
	0x6a, 0xa9, 0xa5, 0xed, 0x78, 0xfd, 0x2e, 0x9d
};

u8 key_380280f0[16] = {
	0x97, 0x09, 0x12, 0xD3, 0xDB, 0x02, 0xBD, 0xD8, 
	0xE7, 0x74, 0x51, 0xFE, 0xF0, 0xEA, 0x6C, 0x5C,
};

typedef struct {
	u32 tag; // 4 byte value at offset 0xD0 in the PRX file
	u8  *key; // 16 bytes keys
	u8 code; // code for scramble
} TAG_INFO2;

static TAG_INFO2 g_tagInfo2[] = {
	// 6.30 ?
	{ 0x380280f0, key_380280f0, 0x5A},
	{ 0x4C9484F0, key_4c9484f0, 0x43},
	{ 0x457b80f0, key_457b80f0, 0x5B},
	{ 0x4C940FF0, key_2DA8, 0x43},
	{ 0x4467415D, key_22E0, 0x59},
	{ 0x00000000, key_21C0, 0x42},
	{ 0x01000000, key_2250, 0x43},

	// PSPgo
	{ 0x380228F0, keys620_5v, 0x5A }, // PSPgo 6.XX vshmain
	{ 0x4C942AF0, keys620_5k, 0x43 }, // PSPgo 6.XX
	{ 0x4C9428F0, keys620_5 , 0x43 }, // PSPgo
	{ 0x4C9429F0, keys570_5k, 0x43 }, // PSPgo 5.70

	// 6.00-6.20
	{ 0x4C941DF0, keys620_1, 0x43 },
	{ 0x4C941CF0, keys620_0, 0x43 },
	{ 0x457B1EF0, keys620_3, 0x5B }, // pops_04g.prx

	// 5.55 user modules
	{ 0x457B0BF0, keys600_u1_457B0BF0, 0x5B },
	{ 0x457B0CF0, keys600_u1_457B0CF0, 0x5B },

	// 5.00 - 5.50
	{ 0x4C9419F0, keys500_1, 0x43 },
	
	{ 0x4C9418F0, keys500_0, 0x43 },
	{ 0x4C941FF0, keys500_2, 0x43 },
	{ 0x4C9417F0, keys500_1, 0x43 },
	{ 0x4C9416F0, keys500_0, 0x43 },

	// 3.90 keys
	{ 0x4C9414F0, keys390_0, 0x43 },
	{ 0x4C9415F0, keys390_1, 0x43 },

	// ipl and file tables
	{ 0xD82310F0, keys02G_E, 0x51 }, 
 	{ 0xD8231EF0, keys03G_E, 0x51 },
	{ 0xD82328F0, keys05G_E, 0x51 },

	// 3.60-3.7X keys
	{ 0x4C9412F0, keys370_0, 0x43 },
	{ 0x4C9413F0, keys370_1, 0x43 },
	{ 0x457B10F0, keys370_2, 0x5B },
	{ 0x4C940DF0, keys360_0, 0x43 },
	{ 0x4C9410F0, keys360_1, 0x43 },

	// 3.30-3.51
	{ 0x4C940BF0, keys330_0, 0x43 }, 
	{ 0x457B0AF0, keys330_1, 0x5B }, 
	{ 0x38020AF0, keys330_2, 0x5A }, 
	{ 0x4C940AF0, keys330_3, 0x43 }, 
	{ 0x4C940CF0, keys330_4, 0x43 }, 

	// 3.10
	{ 0xcfef09f0, keys310_0, 0x62 },
	{ 0x457b08f0, keys310_1, 0x5B },
	{ 0x380208F0, keys310_2, 0x5A },
	{ 0xcfef08f0, keys310_3, 0x62 },

	// 2.60-3.03
	{ 0xCFEF07F0, keys303_0, 0x62 },
	{ 0xCFEF06F0, keys300_0, 0x62 },
	{ 0x457B06F0, keys300_1, 0x5B },
	{ 0x380206F0, keys300_2, 0x5A },
	{ 0xCFEF05F0, keys280_0, 0x62 },
	{ 0x457B05F0, keys280_1, 0x5B },
	{ 0x380205F0, keys280_2, 0x5A },
	{ 0x16D59E03, keys260_0, 0x62 },
	{ 0x76202403, keys260_1, 0x5B },
	{ 0x0F037303, keys260_2, 0x5A },

	// misc
	{ 0x457B28F0, keys620_e, 0x5B },	// ?
	{ 0xADF305F0, demokeys_280, 0x60 }, 	// 2.80 demos data.psp
	{ 0xADF306F0, demokeys_3XX_1, 0x60 },	// 3.XX demos 1
	{ 0xADF308F0, demokeys_3XX_2, 0x60 },	// 3.XX demos 2

	{ 0x8004FD03, ebootbin_271_new, 0x5D },	// 2.71 eboot.bin
	{ 0xD91605F0, ebootbin_280_new, 0x5D },	// 2.80 eboot.bin
	{ 0xD91606F0, ebootbin_300_new, 0x5D },	// 3.00 eboot.bin
	{ 0xD91608F0, ebootbin_310_new, 0x5D },	// 3.10 eboot.bin
	{ 0xD91609F0, key_D91609F0, 0x5D },	// 5.00 eboot.bin
	{ 0x2E5E10F0, key_2E5E10F0, 0x48 },	// 6.XX eboot.bin
	{ 0x2E5E12F0, key_2E5E12F0, 0x48 },	// 6.XX eboot.bin
	{ 0x2E5E12F0, key_2E5E13F0, 0x48 },	// 6.XX eboot.bin

	{ 0xD9160AF0, key_D9160AF0, 0x5D },
	{ 0xD9160BF0, key_D9160BF0, 0x5D },
	{ 0xD91611F0, key_D91611F0, 0x5D },	
	{ 0xD91612F0, key_D91612F0, 0x5D },	
	{ 0xD91613F0, key_D91613F0, 0x5D },
        { 0xD91614F0, key_D91614F0, 0x5D },
	
	{ 0x0A35EA03, gameshare_260_271, 0x5E }, // 2.60-2.71 gameshare
	{ 0x7B0505F0, gameshare_280, 0x5E },	 // 2.80 gameshare
	{ 0x7B0506F0, gameshare_300, 0x5E },	 // 3.00 gameshare
	{ 0x7B0508F0, gameshare_310, 0x5E },	 // 3.10+ gameshare
	{ 0x279D08F0, oneseg_310, 0x61 },	 // 3.10 1SEG
	{ 0x279D06F0, oneseg_300, 0x61 },	 // 3.00 1SEG
	{ 0x279D05F0, oneseg_280, 0x61 },	 // 2.80 1SEG
	{ 0xD66DF703, oneseg_260_271, 0x61 },	 // 2.60-2.71 1SEG
	{ 0x279D10F0, oneseg_slim, 0x61 },	 // 02g 1SEG
	{ 0x3C2A08F0, ms_app_main, 0x67 }	 // 1seg ms_application_main.prx
};
