// open source nand dumper  3.xx port api access, cory1492
// give some user mode accessible nand functions
#include <pspsdk.h>
#include <pspkernel.h>
#include <pspsysmem.h>
#include <pspnand_driver.h>

PSP_MODULE_INFO("Nand", 0x1006, 1, 2);
PSP_MAIN_THREAD_ATTR(0);

int sceNandReadExtraOnly(u32 ppn, void *buf, u32 count); // not in the sdk
int sceNandReadAccess(u32 ppn, void *buf, void *buf2, u32 count, u32 unk); // not in the sdk

// globals
int flashLocked = 0; // keep track of whether the flash is currently locked from changes
int ret = 0;
u32 k1;

// returns 0 on bad block (bad block is tracked via the first two pages of each block, data from spare page)
int nandIsBadBlock(u32 ppn)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandIsBadBlock(ppn);
	pspSdkSetK1(k1);
	return ret;
}	

// returns the number of pages per block (32/64M nands use 32 pages per block)
int nandGetPagesPerBlock(void)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandGetPagesPerBlock();
	pspSdkSetK1(k1);
	return ret;
}

// returns the total number of blocks on the NAND (2048 for old psp, 4096 for slim)
int nandGetTotalBlocks(void)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandGetTotalBlocks();
	pspSdkSetK1(k1);
	return ret;
}

// returns the size of each user page
int nandGetPageSize(void)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandGetPageSize();
	pspSdkSetK1(k1);
	return ret;
}

// read the spare data without corrections
int nandReadExtraOnly(u32 page, void* buffer)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandReadExtraOnly(page, buffer, 1);
	pspSdkSetK1(k1);
	return ret;
}

// read the user data without corrections
int nandReadAccess (u32 page, void* buffer)
{
	k1 = pspSdkSetK1(0);
	ret = sceNandReadAccess(page, buffer, NULL, 1, 49);
	pspSdkSetK1(k1);
	return ret;
}

// Disable system-wide flash write access
void LockFlash(void) 
{
	k1 = pspSdkSetK1(0);
	if (!flashLocked)
		sceNandLock(0);
	flashLocked = 1;
	pspSdkSetK1(k1);
}

// Enable system-wide flash write access
void UnlockFlash(void) 
{
	k1 = pspSdkSetK1(0);
	if (flashLocked)
		sceNandUnlock();
	flashLocked = 0;
	pspSdkSetK1(k1);
}

int module_start(SceSize args, void *argp)
{
	return 0;
}

int module_stop()
{
	return 0;
}
