/*
	Open Source Nand Dumper - port of "UP open source nand dumper" by dark alex and mathieulh
	cory1492
*/
#include <pspsdk.h>
#include <pspkernel.h>
#include <pspiofilemgr.h>
#include <pspdebug.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Nandprx.h" // prototypes of functions in the kernel module

#define printf pspDebugScreenPrintf
#define setc pspDebugScreenSetXY

PSP_MODULE_INFO("NandDump", 0, 1, 0);
PSP_MAIN_THREAD_ATTR(PSP_THREAD_ATTR_USER);

// globals
u8 block[32*32*528];
u32 ppb;

void errorExit(const char* st)
{
	pspDebugScreenSetTextColor(0x000000ff);
	printf("Error: %s\n\n", st);
	pspDebugScreenSetTextColor(0x00ffffff);
	printf("exiting now...");
	sceKernelDelayThread(5*1000*1000);
	sceKernelExitGame();
}

void readNand(u32 page, u8 *buffer)
{
	u32 i, j;

	for (i = 0; i < ppb; i++)
	{
		for (j = 0; j < 4; j++)
		{
			nandReadAccess(page, buffer);
			nandReadExtraOnly(page, buffer+512);
		}

		page++;
		buffer += 528;
	}
}

int main(int argc, char **argv) 
{
	int n, bytes;

	pspDebugScreenInit();
	pspDebugScreenSetBackColor(0x00000000);
	pspDebugScreenSetTextColor(0x00ffffff);
	pspDebugScreenClear();

	// load the kernel module up
	SceUID mod = pspSdkLoadStartModule("nand.prx", PSP_MEMORY_PARTITION_KERNEL);
	if (mod < 0)
	{
		printf("  Error 0x%08X\n", mod);
		errorExit("Could not start module nand.prx");
	}

	ppb = nandGetPagesPerBlock();
	n = nandGetTotalBlocks();

    printf("OPEN NAND DUMPER BY DARK_ALEX AND MATHIEULH\n");
    printf("3.xx version port by cory1492\n");
	printf("dumping...\n");
	
	SceUID fd = sceIoOpen("ms0:/nand-dump.bin", PSP_O_WRONLY | PSP_O_CREAT | PSP_O_TRUNC, 0777);
	if (fd < 0)
		errorExit("Unable to open file nand-dump.bin");
	
	u32 i, j;
	for (i = 0; i < (n*ppb);)
	{
		u8 *p;
		memset(block, 0xff, sizeof(block));
		setc(0, 3);
		printf("block: %04d of %d\n", (i/32), n);

		p = block;
		
		for (j = 0; j < 32; j++)
		{
			LockFlash();
			if (!nandIsBadBlock(i))
			{
				readNand(i, p);
			}
			else
			{
				printf("bad block at page %d block %d\n", i, i/32);
			}
			UnlockFlash();

			i += ppb;
			p += (528*ppb);
		}

		bytes = sceIoWrite(fd, block, sizeof(block));
		if(bytes != sizeof(block))
		{
			sceIoClose(fd);
			errorExit("Write error! Your card may be full!");
		}

	}
	setc(0, 3);
	printf("block: %04d of %d\n",n , n);

	sceIoClose(fd);

	printf("Done. Exiting now.\n");

	sceKernelDelayThread(5*1000*1000);
	sceKernelExitGame();

	return 0;
}
