/*
 * Nicky - Nicky Boum engine rewrite
 * Copyright (C) 2006-2007 Gregory Montoir
 */

#include "game.h"
#include "globals.h"
#include "sound.h"
#include "sequence.h"

anim_frame_t nicky_anim_frames_table__v1[52] = {
	/* 0 */
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 0, 0, &nicky_anim_frames_table__v1[1], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 1, 0, &nicky_anim_frames_table__v1[2], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 2, 0, &nicky_anim_frames_table__v1[3], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 3, 0, &nicky_anim_frames_table__v1[4], 0, 2, 13, 12, 5, 0, 0 },
	/* 4 */
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 4, 0, &nicky_anim_frames_table__v1[5], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 5, 0, &nicky_anim_frames_table__v1[6], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 6, 0, &nicky_anim_frames_table__v1[7], 0, 2, 13, 12, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 7, 0, &nicky_anim_frames_table__v1[0], 0, 2, 13, 12, 5, 0, 0 },
	/* 8 */
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 8, 0, &nicky_anim_frames_table__v1[9], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 9, 0, &nicky_anim_frames_table__v1[10], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 10, 0, &nicky_anim_frames_table__v1[11], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 11, 0, &nicky_anim_frames_table__v1[12], 0, 0, 13, 0, 5, 0, 0 },
	/* 12 */
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 12, 0, &nicky_anim_frames_table__v1[13], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 13, 0, &nicky_anim_frames_table__v1[14], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 14, 0, &nicky_anim_frames_table__v1[15], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 29, 124, 0, 16, 1, 29, 15, 0, &nicky_anim_frames_table__v1[8], 0, 0, 13, 0, 5, 0, 0 },
	/* 16 */
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 19, 0, &nicky_anim_frames_table__v1[17], 0, 2, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 18, 0, &nicky_anim_frames_table__v1[18], 0, 2, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 17, 0, &nicky_anim_frames_table__v1[19], 0, 2, 13, 0, 0, 0, 0 },
	{ 0, 0, 16, 29, 124, 0, 16, 1, 29, 16, 0, 0, 0, 2, 13, 12, 5, 0, 0 },
	/* 20 */
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 16, 0, &nicky_anim_frames_table__v1[21], 0, 0, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 17, 0, &nicky_anim_frames_table__v1[22], 0, 0, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 1, 29, 18, 0, &nicky_anim_frames_table__v1[23], 0, 0, 13, 0, 0, 0, 0 },
	{ 0, 0, 16, 29, 124, 0, 16, 1, 29, 19, 0, 0, 0, 0, 13, 0, 5, 0, 0 },
	/* 24 */
	{ 0, 0, 16, 29, 124, 0, 16, 1, 29, 20, 0, 0, 0, 2, 0, 12, 5, 0, 0 }, /* jump/fall right side */
	{ 0, 0, 16, 29, 124, 0, 16, 1, 29, 21, 0, 0, 0, 2, 0, 0, 5, 0, 0 }, /* jump/fall left side */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 22, 0, &nicky_anim_frames_table__v1[27], 0, 0, 0, 0, 0, 0, 0 }, /* stairs */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 23, 0, &nicky_anim_frames_table__v1[28], 0, 0, 0, 0, 0, 0, 0 }, /* stairs */
	/* 28 */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 24, 0, &nicky_anim_frames_table__v1[29], 0, 0, 0, 0, 0, 0, 0 }, /* stairs */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 25, 0, &nicky_anim_frames_table__v1[26], 0, 0, 0, 0, 0, 0, 0 }, /* stairs */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 25, 0, &nicky_anim_frames_table__v1[31], 0, 2, 0, 0, 0, 0, 0 }, /* stairs */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 24, 0, &nicky_anim_frames_table__v1[32], 0, 2, 0, 0, 0, 0, 0 }, /* stairs */
	/* 32 */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 23, 0, &nicky_anim_frames_table__v1[33], 0, 2, 0, 0, 0, 0, 0 }, /* stairs */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 22, 0, &nicky_anim_frames_table__v1[30], 0, 2, 0, 0, 0, 0, 0 }, /* stairs */
	{ 2, 0, 16, 29, 124, 0, 16, 5, 29, 26, 0, &nicky_anim_frames_table__v1[35], 0, 2, 13, 12, 8, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 8, 29, 27, 0, &nicky_anim_frames_table__v1[36], 0, 2, 13, 12, 8, 0, 0 },
	/* 36 */
	{ 0, 0, 16, 29, 124, 0, 16, 11, 29, 28, 0, 0, 0, 2, 13, 12, 13, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 5, 29, 29, 0, &nicky_anim_frames_table__v1[38], 0, 0, 13, 0, 8, 0, 0 },
	{ 2, 0, 16, 29, 124, 0, 16, 8, 29, 30, 0, &nicky_anim_frames_table__v1[39], 0, 0, 13, 0, 8, 0, 0 },
	{ 0, 0, 16, 29, 124, 0, 16, 11, 29, 31, 0, 0, 0, 0, 13, 0, 13, 0, 0 },
	/* 40 */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 19, 0, &nicky_anim_frames_table__v1[41], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 18, 0, &nicky_anim_frames_table__v1[42], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 32, 0, &nicky_anim_frames_table__v1[43], 0, 2, 13, 0, 0, 0, 0 }, /* use megabomb */
	{ 4, 1, 16, 29, 124, 0, 16, 1, 29, 33, 0, &nicky_anim_frames_table__v1[44], 0, 2, 13, 0, 0, 0, 0 }, /* use megabomb */
	/* 44 */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 32, 0, &nicky_anim_frames_table__v1[45], 0, 2, 13, 0, 0, 0, 0 }, /* use megabomb */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 18, 0, &nicky_anim_frames_table__v1[23], 0, 0, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 16, 0, &nicky_anim_frames_table__v1[47], 0, 0, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 17, 0, &nicky_anim_frames_table__v1[48], 0, 0, 13, 0, 0, 0, 0 },
	/* 48 */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 32, 0, &nicky_anim_frames_table__v1[49], 0, 2, 13, 0, 0, 0, 0 }, /* use megabomb */
	{ 4, 1, 16, 29, 124, 0, 16, 1, 29, 33, 0, &nicky_anim_frames_table__v1[50], 0, 2, 13, 0, 0, 0, 0 }, /* use megabomb */
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 32, 0, &nicky_anim_frames_table__v1[51], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 29, 124, 0, 16, 1, 29, 17, 0, &nicky_anim_frames_table__v1[19], 0, 2, 13, 0, 0, 0, 0 }
};

anim_frame_t nicky_anim_frames_table__v2[147] = {
	/* 0 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 0, 0, &nicky_anim_frames_table__v2[1], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 1, 0, &nicky_anim_frames_table__v2[2], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 2, 0, &nicky_anim_frames_table__v2[3], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 3, 0, &nicky_anim_frames_table__v2[4], 0, 2, 13, 16, 5, 0, 0 },
	/* 4 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 4, 0, &nicky_anim_frames_table__v2[5], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 5, 0, &nicky_anim_frames_table__v2[6], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 6, 0, &nicky_anim_frames_table__v2[7], 0, 2, 13, 16, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 7, 0, &nicky_anim_frames_table__v2[0], 0, 2, 13, 16, 5, 0, 0 },
	/* 8 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 8, 0, &nicky_anim_frames_table__v2[9], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 9, 0, &nicky_anim_frames_table__v2[10], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 10, 0, &nicky_anim_frames_table__v2[11], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 11, 0, &nicky_anim_frames_table__v2[12], 0, 0, 13, 0, 5, 0, 0 },
	/* 12 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 12, 0, &nicky_anim_frames_table__v2[13], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 13, 0, &nicky_anim_frames_table__v2[14], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 14, 0, &nicky_anim_frames_table__v2[15], 0, 0, 13, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 15, 0, &nicky_anim_frames_table__v2[8], 0, 0, 13, 0, 5, 0, 0 },
	/* 16 */
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 19, 0, &nicky_anim_frames_table__v2[17], 0, 2, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 18, 0, &nicky_anim_frames_table__v2[18], 0, 2, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 17, 0, &nicky_anim_frames_table__v2[19], 0, 2, 13, 0, 0, 0, 0 },
	{ 0, 0, 16, 27, 0, 0, 16, 1, 27, 16, 0, 0, 0, 2, 13, 16, 5, 0, 0 },
	/* 20 */
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 41, 0, &nicky_anim_frames_table__v2[21], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 42, 0, &nicky_anim_frames_table__v2[22], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 43, 0, &nicky_anim_frames_table__v2[23], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 44, 0, &nicky_anim_frames_table__v2[24], 0, 2, 13, 24, 5, 0, -8 },
	/* 24 */
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 45, 0, &nicky_anim_frames_table__v2[25], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 46, 0, &nicky_anim_frames_table__v2[26], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 47, 0, &nicky_anim_frames_table__v2[27], 0, 2, 13, 24, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 48, 0, &nicky_anim_frames_table__v2[20], 0, 2, 13, 24, 5, 0, -8 },
	/* 28 */
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 16, 0, &nicky_anim_frames_table__v2[29], 0, 0, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 17, 0, &nicky_anim_frames_table__v2[30], 0, 0, 13, 0, 0, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 1, 27, 18, 0, &nicky_anim_frames_table__v2[31], 0, 0, 13, 0, 0, 0, 0 },
	{ 0, 0, 16, 27, 0, 0, 16, 1, 27, 19, 0, 0, 0, 0, 13, 0, 5, 0, 0 },
	/* 32 */
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 49, 0, &nicky_anim_frames_table__v2[33], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 50, 0, &nicky_anim_frames_table__v2[34], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 51, 0, &nicky_anim_frames_table__v2[35], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 52, 0, &nicky_anim_frames_table__v2[36], 0, 2, 13, 8, 5, 0, -8 },
	/* 36 */
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 53, 0, &nicky_anim_frames_table__v2[37], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 54, 0, &nicky_anim_frames_table__v2[38], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 55, 0, &nicky_anim_frames_table__v2[39], 0, 2, 13, 8, 5, 0, -8 },
	{ 2, 0, 16, 27, 8, 0, 24, 1, 27, 56, 0, &nicky_anim_frames_table__v2[32], 0, 2, 13, 8, 5, 0, -8 },
	/* 40 */
	{ 0, 0, 16, 27, 0, 0, 16, 1, 27, 20, 0, 0, 0, 2, 0, 16, 5, 0, 0 },
	{ 0, 0, 16, 27, 0, 0, 16, 1, 27, 21, 0, 0, 0, 2, 0, 0, 5, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 22, 0, &nicky_anim_frames_table__v2[43], 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 23, 0, &nicky_anim_frames_table__v2[44], 0, 0, 0, 0, 0, 0, 0 },
	/* 44 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 24, 0, &nicky_anim_frames_table__v2[45], 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 25, 0, &nicky_anim_frames_table__v2[46], 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 24, 0, &nicky_anim_frames_table__v2[47], 0, 0, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 23, 0, &nicky_anim_frames_table__v2[42], 0, 0, 0, 0, 0, 0, 0 },
	/* 48 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 22, 0, &nicky_anim_frames_table__v2[49], 0, 2, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 23, 0, &nicky_anim_frames_table__v2[50], 0, 2, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 24, 0, &nicky_anim_frames_table__v2[51], 0, 2, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 25, 0, &nicky_anim_frames_table__v2[52], 0, 2, 0, 0, 0, 0, 0 },
	/* 52 */
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 24, 0, &nicky_anim_frames_table__v2[53], 0, 2, 0, 0, 0, 0, 0 },
	{ 1, 0, 16, 27, 0, 0, 16, 1, 27, 23, 0, &nicky_anim_frames_table__v2[48], 0, 2, 0, 0, 0, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 5, 27, 26, 0, &nicky_anim_frames_table__v2[55], 0, 2, 13, 16, 8, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 8, 27, 27, 0, &nicky_anim_frames_table__v2[56], 0, 2, 13, 16, 8, 0, 0 },
	/* 56 */
	{ 0, 0, 16, 27, 0, 0, 16, 11, 27, 28, 0, 0, 0, 2, 13, 16, 13, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 5, 27, 29, 0, &nicky_anim_frames_table__v2[58], 0, 0, 13, 0, 8, 0, 0 },
	{ 2, 0, 16, 27, 0, 0, 16, 8, 27, 30, 0, &nicky_anim_frames_table__v2[59], 0, 0, 13, 0, 8, 0, 0 },
	{ 0, 0, 16, 27, 0, 0, 16, 11, 27, 31, 0, 0, 0, 0, 13, 0, 13, 0, 0 },
	/* 60 */
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 19, 0, &nicky_anim_frames_table__v2[61], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 18, 0, &nicky_anim_frames_table__v2[62], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 32, 0, &nicky_anim_frames_table__v2[63], 0, 2, 13, 0, 0, 0, 0 },
	{ 4, 1, 16, 27, 0, 0, 16, 1, 27, 33, 0, &nicky_anim_frames_table__v2[64], 0, 2, 13, 0, 0, 0, 0 },
	/* 64 */
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 32, 0, &nicky_anim_frames_table__v2[65], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 18, 0, &nicky_anim_frames_table__v2[31], 0, 0, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 16, 0, &nicky_anim_frames_table__v2[67], 0, 0, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 17, 0, &nicky_anim_frames_table__v2[68], 0, 0, 13, 0, 0, 0, 0 },
	/* 68 */
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 32, 0, &nicky_anim_frames_table__v2[69], 0, 2, 13, 0, 0, 0, 0 },
	{ 4, 1, 16, 27, 0, 0, 16, 1, 27, 33, 0, &nicky_anim_frames_table__v2[70], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 32, 0, &nicky_anim_frames_table__v2[71], 0, 2, 13, 0, 0, 0, 0 },
	{ 3, 0, 16, 27, 0, 0, 16, 1, 27, 17, 0, &nicky_anim_frames_table__v2[19], 0, 2, 13, 0, 0, 0, 0 },
	/* 72 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[73], 0, 0, 13, 40, 9, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 59, 0, &nicky_anim_frames_table__v2[74], 0, 0, 13, 40, 9, -3, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 58, 0, &nicky_anim_frames_table__v2[75], 0, 0, 13, 40, 9, -2, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 61, 0, &nicky_anim_frames_table__v2[76], 0, 0, 13, 40, 9, -4, -4 },
	/* 76 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 60, 0, &nicky_anim_frames_table__v2[77], 0, 0, 13, 40, 9, -4, -4 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 58, 0, &nicky_anim_frames_table__v2[78], 0, 0, 13, 40, 9, -2, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 59, 0, &nicky_anim_frames_table__v2[79], 0, 0, 13, 40, 9, -3, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[72], 0, 0, 13, 40, 9, 0, 0 },
	/* 80 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[81], 0, 0, 13, 12, 9, 0, -16 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 66, 0, &nicky_anim_frames_table__v2[82], 0, 0, 13, 12, 9, -3, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 65, 0, &nicky_anim_frames_table__v2[83], 0, 0, 13, 12, 9, -2, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 68, 0, &nicky_anim_frames_table__v2[84], 0, 0, 13, 12, 9, -4, -12 },
	/* 84 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 67, 0, &nicky_anim_frames_table__v2[85], 0, 0, 13, 12, 9, -4, -12 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 65, 0, &nicky_anim_frames_table__v2[86], 0, 0, 13, 12, 9, -2, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 66, 0, &nicky_anim_frames_table__v2[87], 0, 0, 13, 12, 9, -3, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[80], 0, 0, 13, 12, 9, 0, -16 },
	/* 88 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[89], 0, 0, 13, 40, 9, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 58, 0, &nicky_anim_frames_table__v2[90], 0, 0, 13, 40, 9, -2, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 59, 0, &nicky_anim_frames_table__v2[91], 0, 0, 13, 40, 9, -3, -3 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 58, 0, &nicky_anim_frames_table__v2[88], 0, 0, 13, 40, 9, -2, -3 },
	/* 92 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[89], 0, 0, 13, 40, 9, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[89], 0, 0, 13, 40, 9, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[89], 0, 0, 13, 40, 9, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 57, 0, &nicky_anim_frames_table__v2[89], 0, 0, 13, 40, 9, 0, 0 },
	/* 96 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[97], 0, 0, 13, 12, 9, 0, -16 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 65, 0, &nicky_anim_frames_table__v2[98], 0, 0, 13, 12, 9, -2, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 66, 0, &nicky_anim_frames_table__v2[99], 0, 0, 13, 12, 9, -3, -13 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 65, 0, &nicky_anim_frames_table__v2[96], 0, 0, 13, 12, 9, -2, -13 },
	/* 100 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[97], 0, 0, 13, 12, 9, 0, -16 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[97], 0, 0, 13, 12, 9, 0, -16 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[97], 0, 0, 13, 12, 9, 0, -16 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 64, 0, &nicky_anim_frames_table__v2[97], 0, 0, 13, 12, 9, 0, -16 },
	/* 104 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 71, 0, &nicky_anim_frames_table__v2[105], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 71, 0, &nicky_anim_frames_table__v2[106], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 72, 0, &nicky_anim_frames_table__v2[107], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 73, 0, &nicky_anim_frames_table__v2[108], 0, 0, 13, 0, 0, 0, 0 },
	/* 108 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 71, 0, &nicky_anim_frames_table__v2[109], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 74, 0, &nicky_anim_frames_table__v2[110], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 75, 0, &nicky_anim_frames_table__v2[104], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 82, 0, &nicky_anim_frames_table__v2[112], 0, 0, 13, 0, 0, 0, 0 },
	/* 112 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 83, 0, &nicky_anim_frames_table__v2[113], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 84, 0, &nicky_anim_frames_table__v2[114], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 82, 0, &nicky_anim_frames_table__v2[115], 0, 0, 13, 0, 0, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 85, 0, &nicky_anim_frames_table__v2[116], 0, 0, 13, 0, 0, 0, 0 },
	/* 116 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 86, 0, &nicky_anim_frames_table__v2[111], 0, 0, 13, 0, 0, 0, 0 },
	{ 4, 0, 48, 41, 0, 0, 48, 1, 41, 76, 0, &nicky_anim_frames_table__v2[118], 0, 0, 13, 21, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 77, 0, &nicky_anim_frames_table__v2[119], 0, 0, 13, 21, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 78, 0, &nicky_anim_frames_table__v2[120], 0, 0, 13, 21, 7, 0, 0 },
	/* 120 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 79, 0, &nicky_anim_frames_table__v2[118], 0, 0, 13, 21, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 77, 0, &nicky_anim_frames_table__v2[122], 0, 0, 13, 21, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 80, 0, &nicky_anim_frames_table__v2[123], 0, 0, 13, 21, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 81, 0, &nicky_anim_frames_table__v2[118], 0, 0, 13, 21, 7, 0, 0 },
	/* 124 */
	{ 4, 0, 48, 41, 0, 0, 48, 1, 41, 87, 0, &nicky_anim_frames_table__v2[125], 0, 0, 13, 8, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 88, 0, &nicky_anim_frames_table__v2[126], 0, 0, 13, 8, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 89, 0, &nicky_anim_frames_table__v2[127], 0, 0, 13, 8, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 90, 0, &nicky_anim_frames_table__v2[128], 0, 0, 13, 8, 7, 0, 0 },
	/* 128 */
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 88, 0, &nicky_anim_frames_table__v2[129], 0, 0, 13, 8, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 91, 0, &nicky_anim_frames_table__v2[130], 0, 0, 13, 8, 7, 0, 0 },
	{ 1, 0, 48, 41, 0, 0, 48, 1, 41, 92, 0, &nicky_anim_frames_table__v2[125], 0, 0, 13, 8, 7, 0, 0 },
	{ 0, 0, 48, 41, 0, 0, 48, 1, 41, 71, 0, 0, 0, 0, 13, 21, 7, 0, 0 },
	/* 132 */
	{ 0, 0, 48, 41, 0, 0, 48, 1, 41, 82, 0, 0, 0, 0, 13, 7, 8, 0, 0 },
	{ 0, 0, 48, 41, 0, 0, 48, 1, 41, 77, 0, 0, 0, 0, 13, 21, 7, 0, 0 },
	{ 0, 0, 48, 41, 0, 0, 48, 1, 41, 88, 0, 0, 0, 0, 13, 8, 7, 0, 0 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 62, 0, &nicky_anim_frames_table__v2[136], 0, 0, 13, 21, 9, -2, -4 },
	/* 136 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 70, 0, &nicky_anim_frames_table__v2[137], 0, 0, 13, 21, 9, -2, -8 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 69, 0, &nicky_anim_frames_table__v2[80], 0, 0, 13, 21, 9, -2, -12 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 69, 0, &nicky_anim_frames_table__v2[139], 0, 0, 13, 21, 9, -2, -12 },
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 63, 0, &nicky_anim_frames_table__v2[140], 0, 0, 13, 21, 9, -2, -8 },
	/* 140 */
	{ 2, 0, 48, 37, 0, 0, 48, 1, 37, 62, 0, &nicky_anim_frames_table__v2[72], 0, 0, 13, 21, 9, -2, -4 },
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 93, 0, &nicky_anim_frames_table__v2[142], 0, 0, 13, 13, 7, 0, 0 },
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 94, 0, &nicky_anim_frames_table__v2[143], 0, 0, 13, 13, 7, 0, 0 },
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 95, 0, &nicky_anim_frames_table__v2[125], 0, 0, 13, 13, 7, 0, 0 },
	/* 144 */
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 95, 0, &nicky_anim_frames_table__v2[145], 0, 0, 13, 13, 7, 0, 0 },
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 96, 0, &nicky_anim_frames_table__v2[146], 0, 0, 13, 13, 7, 0, 0 },
	{ 3, 0, 48, 41, 0, 0, 48, 1, 41, 93, 0, &nicky_anim_frames_table__v2[118], 0, 0, 13, 13, 7, 0, 0 }
};

const uint16 nicky_move_offsets_table__v1[58] = {
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFB,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFB, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 0xFFFF,
	0x0000, 0x0001, 0x0001, 0x0002, 0x0002, 0x0003, 0x0004, 0x7777
};

const uint16 nicky_move_offsets_table__v2[102] = {
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFA, 0xFFFB, 0xFFFA, 0xFFFA, 0xFFFA,
	0xFFFB, 0xFFFB, 0xFFFC, 0xFFFD, 0xFFFE, 0xFFFF, 0xFFFF, 0x0000, 0x0001, 0x0001,
	0x0002, 0x0002, 0x0003, 0x0004, 0x7777, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFB, 0xFFFC,
	0xFFFC, 0xFFFC, 0xFFFC, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFD, 0xFFFE, 0xFFFE, 0xFFFE,
	0xFFFE, 0xFFFE, 0xFFFE, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0x0000, 0xFFFF, 0x0000,
	0xFFFF, 0x0000, 0x0001, 0x0001, 0x0001, 0x0002, 0x0002, 0x0002, 0x0003, 0x0003,
	0x0004, 0x7777
};

/* death movement */
const uint16 nicky_move_offsets_table5[126] = {
	0x0000, 0xFFFC, 0x0000, 0xFFFC, 0x0000, 0xFFFD, 0x0000, 0xFFFD, 0x0000, 0xFFFD,
	0x0000, 0xFFFD, 0x0000, 0xFFFD, 0x0000, 0xFFFE, 0x0000, 0xFFFE, 0x0000, 0xFFFF,
	0x0000, 0xFFFE, 0x0000, 0xFFFF, 0x0000, 0x0000, 0x0000, 0xFFFF, 0x0000, 0x0000,
	0x0000, 0x0000, 0x0000, 0x0001, 0x0000, 0x0001, 0x0000, 0x0001, 0x0000, 0x0001,
	0x0000, 0x0002, 0x0000, 0x0002, 0x0000, 0x0002, 0x0000, 0x0003, 0x0000, 0x0003,
	0x0000, 0x0003, 0x0000, 0x0003, 0x0000, 0x0004, 0x0000, 0x0004, 0x0000, 0x0004,
	0x0000, 0x0004, 0x0000, 0x0005, 0x0000, 0x0004, 0x0000, 0x0005, 0x0000, 0x0005,
	0x0000, 0x0005, 0x0000, 0x0005, 0x0000, 0x0005, 0x0000, 0x0005, 0x0000, 0x0005,
	0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006,
	0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006,
	0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006,
	0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006, 0x0000, 0x0006,
	0x0000, 0x0006, 0x0000, 0x0006, 0x8888, 0x8888
};

const uint16 cos_table[512] = {
	0x0100, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FE, 0x00FE, 0x00FE,
	0x00FD, 0x00FD, 0x00FC, 0x00FC, 0x00FB, 0x00FB, 0x00FA, 0x00F9, 0x00F9, 0x00F8, 0x00F7,
	0x00F6, 0x00F5, 0x00F4, 0x00F4, 0x00F3, 0x00F2, 0x00F1, 0x00EF, 0x00EE, 0x00ED, 0x00EC,
	0x00EB, 0x00EA, 0x00E8, 0x00E7, 0x00E6, 0x00E4, 0x00E3, 0x00E1, 0x00E0, 0x00DE, 0x00DD,
	0x00DB, 0x00D9, 0x00D8, 0x00D6, 0x00D4, 0x00D3, 0x00D1, 0x00CF, 0x00CD, 0x00CB, 0x00C9,
	0x00C7, 0x00C5, 0x00C3, 0x00C1, 0x00BF, 0x00BD, 0x00BB, 0x00B9, 0x00B7, 0x00B5, 0x00B2,
	0x00B0, 0x00AE, 0x00AB, 0x00A9, 0x00A7, 0x00A4, 0x00A2, 0x009F, 0x009D, 0x009B, 0x0098,
	0x0095, 0x0093, 0x0090, 0x008E, 0x008B, 0x0088, 0x0086, 0x0083, 0x0080, 0x007E, 0x007B,
	0x0078, 0x0075, 0x0073, 0x0070, 0x006D, 0x006A, 0x0067, 0x0064, 0x0061, 0x005F, 0x005C,
	0x0059, 0x0056, 0x0053, 0x0050, 0x004D, 0x004A, 0x0047, 0x0044, 0x0041, 0x003E, 0x003B,
	0x0038, 0x0035, 0x0031, 0x002E, 0x002B, 0x0028, 0x0025, 0x0022, 0x001F, 0x001C, 0x0019,
	0x0015, 0x0012, 0x000F, 0x000C, 0x0009, 0x0006, 0x0003, 0x0000, 0xFFFD, 0xFFFA, 0xFFF7,
	0xFFF4, 0xFFF1, 0xFFEE, 0xFFEB, 0xFFE7, 0xFFE4, 0xFFE1, 0xFFDE, 0xFFDB, 0xFFD8, 0xFFD5,
	0xFFD2, 0xFFCF, 0xFFCB, 0xFFC8, 0xFFC5, 0xFFC2, 0xFFBF, 0xFFBC, 0xFFB9, 0xFFB6, 0xFFB3,
	0xFFB0, 0xFFAD, 0xFFAA, 0xFFA7, 0xFFA4, 0xFFA1, 0xFF9F, 0xFF9C, 0xFF99, 0xFF96, 0xFF93,
	0xFF90, 0xFF8D, 0xFF8B, 0xFF88, 0xFF85, 0xFF82, 0xFF80, 0xFF7D, 0xFF7A, 0xFF78, 0xFF75,
	0xFF72, 0xFF70, 0xFF6D, 0xFF6B, 0xFF68, 0xFF65, 0xFF63, 0xFF61, 0xFF5E, 0xFF5C, 0xFF59,
	0xFF57, 0xFF55, 0xFF52, 0xFF50, 0xFF4E, 0xFF4B, 0xFF49, 0xFF47, 0xFF45, 0xFF43, 0xFF41,
	0xFF3F, 0xFF3D, 0xFF3B, 0xFF39, 0xFF37, 0xFF35, 0xFF33, 0xFF31, 0xFF2F, 0xFF2D, 0xFF2C,
	0xFF2A, 0xFF28, 0xFF27, 0xFF25, 0xFF23, 0xFF22, 0xFF20, 0xFF1F, 0xFF1D, 0xFF1C, 0xFF1A,
	0xFF19, 0xFF18, 0xFF16, 0xFF15, 0xFF14, 0xFF13, 0xFF12, 0xFF11, 0xFF0F, 0xFF0E, 0xFF0D,
	0xFF0C, 0xFF0C, 0xFF0B, 0xFF0A, 0xFF09, 0xFF08, 0xFF07, 0xFF07, 0xFF06, 0xFF05, 0xFF05,
	0xFF04, 0xFF04, 0xFF03, 0xFF03, 0xFF02, 0xFF02, 0xFF02, 0xFF01, 0xFF01, 0xFF01, 0xFF01,
	0xFF01, 0xFF01, 0xFF01, 0xFF00, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01,
	0xFF02, 0xFF02, 0xFF02, 0xFF03, 0xFF03, 0xFF04, 0xFF04, 0xFF05, 0xFF05, 0xFF06, 0xFF07,
	0xFF07, 0xFF08, 0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF11,
	0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF18, 0xFF19, 0xFF1A, 0xFF1C, 0xFF1D, 0xFF1F,
	0xFF20, 0xFF22, 0xFF23, 0xFF25, 0xFF27, 0xFF28, 0xFF2A, 0xFF2C, 0xFF2D, 0xFF2F, 0xFF31,
	0xFF33, 0xFF35, 0xFF37, 0xFF39, 0xFF3B, 0xFF3D, 0xFF3F, 0xFF41, 0xFF43, 0xFF45, 0xFF47,
	0xFF49, 0xFF4B, 0xFF4E, 0xFF50, 0xFF52, 0xFF55, 0xFF57, 0xFF59, 0xFF5C, 0xFF5E, 0xFF61,
	0xFF63, 0xFF65, 0xFF68, 0xFF6B, 0xFF6D, 0xFF70, 0xFF72, 0xFF75, 0xFF78, 0xFF7A, 0xFF7D,
	0xFF80, 0xFF82, 0xFF85, 0xFF88, 0xFF8B, 0xFF8D, 0xFF90, 0xFF93, 0xFF96, 0xFF99, 0xFF9C,
	0xFF9F, 0xFFA1, 0xFFA4, 0xFFA7, 0xFFAA, 0xFFAD, 0xFFB0, 0xFFB3, 0xFFB6, 0xFFB9, 0xFFBC,
	0xFFBF, 0xFFC2, 0xFFC5, 0xFFC8, 0xFFCB, 0xFFCF, 0xFFD2, 0xFFD5, 0xFFD8, 0xFFDB, 0xFFDE,
	0xFFE1, 0xFFE4, 0xFFE7, 0xFFEB, 0xFFEE, 0xFFF1, 0xFFF4, 0xFFF7, 0xFFFA, 0xFFFD, 0x0000,
	0x0003, 0x0006, 0x0009, 0x000C, 0x000F, 0x0012, 0x0015, 0x0019, 0x001C, 0x001F, 0x0022,
	0x0025, 0x0028, 0x002B, 0x002E, 0x0031, 0x0035, 0x0038, 0x003B, 0x003E, 0x0041, 0x0044,
	0x0047, 0x004A, 0x004D, 0x0050, 0x0053, 0x0056, 0x0059, 0x005C, 0x005F, 0x0061, 0x0064,
	0x0067, 0x006A, 0x006D, 0x0070, 0x0073, 0x0075, 0x0078, 0x007B, 0x007E, 0x0080, 0x0083,
	0x0086, 0x0088, 0x008B, 0x008E, 0x0090, 0x0093, 0x0095, 0x0098, 0x009B, 0x009D, 0x009F,
	0x00A2, 0x00A4, 0x00A7, 0x00A9, 0x00AB, 0x00AE, 0x00B0, 0x00B2, 0x00B5, 0x00B7, 0x00B9,
	0x00BB, 0x00BD, 0x00BF, 0x00C1, 0x00C3, 0x00C5, 0x00C7, 0x00C9, 0x00CB, 0x00CD, 0x00CF,
	0x00D1, 0x00D3, 0x00D4, 0x00D6, 0x00D8, 0x00D9, 0x00DB, 0x00DD, 0x00DE, 0x00E0, 0x00E1,
	0x00E3, 0x00E4, 0x00E6, 0x00E7, 0x00E8, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE, 0x00EF,
	0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9, 0x00F9,
	0x00FA, 0x00FB, 0x00FB, 0x00FC, 0x00FC, 0x00FD, 0x00FD, 0x00FE, 0x00FE, 0x00FE, 0x00FF,
	0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF
};

const uint16 sin_table[512] = {
	0x0000, 0x0003, 0x0006, 0x0009, 0x000C, 0x000F, 0x0012, 0x0015, 0x0019, 0x001C, 0x001F,
	0x0022, 0x0025, 0x0028, 0x002B, 0x002E, 0x0031, 0x0035, 0x0038, 0x003B, 0x003E, 0x0041,
	0x0044, 0x0047, 0x004A, 0x004D, 0x0050, 0x0053, 0x0056, 0x0059, 0x005C, 0x005F, 0x0061,
	0x0064, 0x0067, 0x006A, 0x006D, 0x0070, 0x0073, 0x0075, 0x0078, 0x007B, 0x007E, 0x0080,
	0x0083, 0x0086, 0x0088, 0x008B, 0x008E, 0x0090, 0x0093, 0x0095, 0x0098, 0x009B, 0x009D,
	0x009F, 0x00A2, 0x00A4, 0x00A7, 0x00A9, 0x00AB, 0x00AE, 0x00B0, 0x00B2, 0x00B5, 0x00B7,
	0x00B9, 0x00BB, 0x00BD, 0x00BF, 0x00C1, 0x00C3, 0x00C5, 0x00C7, 0x00C9, 0x00CB, 0x00CD,
	0x00CF, 0x00D1, 0x00D3, 0x00D4, 0x00D6, 0x00D8, 0x00D9, 0x00DB, 0x00DD, 0x00DE, 0x00E0,
	0x00E1, 0x00E3, 0x00E4, 0x00E6, 0x00E7, 0x00E8, 0x00EA, 0x00EB, 0x00EC, 0x00ED, 0x00EE,
	0x00EF, 0x00F1, 0x00F2, 0x00F3, 0x00F4, 0x00F4, 0x00F5, 0x00F6, 0x00F7, 0x00F8, 0x00F9,
	0x00F9, 0x00FA, 0x00FB, 0x00FB, 0x00FC, 0x00FC, 0x00FD, 0x00FD, 0x00FE, 0x00FE, 0x00FE,
	0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x0100, 0x00FF, 0x00FF, 0x00FF,
	0x00FF, 0x00FF, 0x00FF, 0x00FF, 0x00FE, 0x00FE, 0x00FE, 0x00FD, 0x00FD, 0x00FC, 0x00FC,
	0x00FB, 0x00FB, 0x00FA, 0x00F9, 0x00F9, 0x00F8, 0x00F7, 0x00F6, 0x00F5, 0x00F4, 0x00F4,
	0x00F3, 0x00F2, 0x00F1, 0x00EF, 0x00EE, 0x00ED, 0x00EC, 0x00EB, 0x00EA, 0x00E8, 0x00E7,
	0x00E6, 0x00E4, 0x00E3, 0x00E1, 0x00E0, 0x00DE, 0x00DD, 0x00DB, 0x00D9, 0x00D8, 0x00D6,
	0x00D4, 0x00D3, 0x00D1, 0x00CF, 0x00CD, 0x00CB, 0x00C9, 0x00C7, 0x00C5, 0x00C3, 0x00C1,
	0x00BF, 0x00BD, 0x00BB, 0x00B9, 0x00B7, 0x00B5, 0x00B2, 0x00B0, 0x00AE, 0x00AB, 0x00A9,
	0x00A7, 0x00A4, 0x00A2, 0x009F, 0x009D, 0x009B, 0x0098, 0x0095, 0x0093, 0x0090, 0x008E,
	0x008B, 0x0088, 0x0086, 0x0083, 0x0080, 0x007E, 0x007B, 0x0078, 0x0075, 0x0073, 0x0070,
	0x006D, 0x006A, 0x0067, 0x0064, 0x0061, 0x005F, 0x005C, 0x0059, 0x0056, 0x0053, 0x0050,
	0x004D, 0x004A, 0x0047, 0x0044, 0x0041, 0x003E, 0x003B, 0x0038, 0x0035, 0x0031, 0x002E,
	0x002B, 0x0028, 0x0025, 0x0022, 0x001F, 0x001C, 0x0019, 0x0015, 0x0012, 0x000F, 0x000C,
	0x0009, 0x0006, 0x0003, 0x0000, 0xFFFD, 0xFFFA, 0xFFF7, 0xFFF4, 0xFFF1, 0xFFEE, 0xFFEB,
	0xFFE7, 0xFFE4, 0xFFE1, 0xFFDE, 0xFFDB, 0xFFD8, 0xFFD5, 0xFFD2, 0xFFCF, 0xFFCB, 0xFFC8,
	0xFFC5, 0xFFC2, 0xFFBF, 0xFFBC, 0xFFB9, 0xFFB6, 0xFFB3, 0xFFB0, 0xFFAD, 0xFFAA, 0xFFA7,
	0xFFA4, 0xFFA1, 0xFF9F, 0xFF9C, 0xFF99, 0xFF96, 0xFF93, 0xFF90, 0xFF8D, 0xFF8B, 0xFF88,
	0xFF85, 0xFF82, 0xFF80, 0xFF7D, 0xFF7A, 0xFF78, 0xFF75, 0xFF72, 0xFF70, 0xFF6D, 0xFF6B,
	0xFF68, 0xFF65, 0xFF63, 0xFF61, 0xFF5E, 0xFF5C, 0xFF59, 0xFF57, 0xFF55, 0xFF52, 0xFF50,
	0xFF4E, 0xFF4B, 0xFF49, 0xFF47, 0xFF45, 0xFF43, 0xFF41, 0xFF3F, 0xFF3D, 0xFF3B, 0xFF39,
	0xFF37, 0xFF35, 0xFF33, 0xFF31, 0xFF2F, 0xFF2D, 0xFF2C, 0xFF2A, 0xFF28, 0xFF27, 0xFF25,
	0xFF23, 0xFF22, 0xFF20, 0xFF1F, 0xFF1D, 0xFF1C, 0xFF1A, 0xFF19, 0xFF18, 0xFF16, 0xFF15,
	0xFF14, 0xFF13, 0xFF12, 0xFF11, 0xFF0F, 0xFF0E, 0xFF0D, 0xFF0C, 0xFF0C, 0xFF0B, 0xFF0A,
	0xFF09, 0xFF08, 0xFF07, 0xFF07, 0xFF06, 0xFF05, 0xFF05, 0xFF04, 0xFF04, 0xFF03, 0xFF03,
	0xFF02, 0xFF02, 0xFF02, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF00,
	0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF01, 0xFF02, 0xFF02, 0xFF02, 0xFF03,
	0xFF03, 0xFF04, 0xFF04, 0xFF05, 0xFF05, 0xFF06, 0xFF07, 0xFF07, 0xFF08, 0xFF09, 0xFF0A,
	0xFF0B, 0xFF0C, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15,
	0xFF16, 0xFF18, 0xFF19, 0xFF1A, 0xFF1C, 0xFF1D, 0xFF1F, 0xFF20, 0xFF22, 0xFF23, 0xFF25,
	0xFF27, 0xFF28, 0xFF2A, 0xFF2C, 0xFF2D, 0xFF2F, 0xFF31, 0xFF33, 0xFF35, 0xFF37, 0xFF39,
	0xFF3B, 0xFF3D, 0xFF3F, 0xFF41, 0xFF43, 0xFF45, 0xFF47, 0xFF49, 0xFF4B, 0xFF4E, 0xFF50,
	0xFF52, 0xFF55, 0xFF57, 0xFF59, 0xFF5C, 0xFF5E, 0xFF61, 0xFF63, 0xFF65, 0xFF68, 0xFF6B,
	0xFF6D, 0xFF70, 0xFF72, 0xFF75, 0xFF78, 0xFF7A, 0xFF7D, 0xFF80, 0xFF82, 0xFF85, 0xFF88,
	0xFF8B, 0xFF8D, 0xFF90, 0xFF93, 0xFF96, 0xFF99, 0xFF9C, 0xFF9F, 0xFFA1, 0xFFA4, 0xFFA7,
	0xFFAA, 0xFFAD, 0xFFB0, 0xFFB3, 0xFFB6, 0xFFB9, 0xFFBC, 0xFFBF, 0xFFC2, 0xFFC5, 0xFFC8,
	0xFFCB, 0xFFCF, 0xFFD2, 0xFFD5, 0xFFD8, 0xFFDB, 0xFFDE, 0xFFE1, 0xFFE4, 0xFFE7, 0xFFEB,
	0xFFEE, 0xFFF1, 0xFFF4, 0xFFF7, 0xFFFA, 0xFFFD
};

const int move_delta_offsets_table[15] = {
	0, 88, 92, 180, 236, 292, 374, 462, 518, 570, 682, 768, 854, 898, 942
};

const uint8 move_delta_table[942] = {
	0x00, 0xF8, 0x00, 0xF9, 0x00, 0xFB, 0x00, 0xFB, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0xFF, 0x00, 0xFF,
	0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03, 0x00, 0x05, 0x00, 0x05, 0x00, 0x07, 0x00, 0x08,
	0x00, 0x09, 0x00, 0x09, 0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E,
	0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E,
	0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E,
	0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x88, 0x88, 0x00, 0xFB, 0x00, 0xFC, 0x00, 0xFD, 0x00, 0xFD,
	0x00, 0xFE, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03,
	0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0A,
	0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0C, 0x00, 0x0C, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D,
	0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D,
	0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D, 0x00, 0x0D,
	0x00, 0x0D, 0x88, 0x88, 0x00, 0xF4, 0x00, 0xF4, 0x00, 0xF4, 0x00, 0xF5, 0x00, 0xF6, 0x00, 0xF6,
	0x00, 0xF8, 0x00, 0xF9, 0x00, 0xFB, 0x00, 0xFB, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0x01, 0x00, 0x02,
	0x00, 0x04, 0x00, 0x05, 0x00, 0x07, 0x00, 0x08, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0C,
	0x00, 0x0C, 0x00, 0x0C, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0xF6, 0xFF, 0xF7,
	0xFF, 0xF6, 0xFF, 0xF8, 0xFF, 0xF8, 0xFE, 0xF8, 0xFE, 0xFA, 0xFE, 0xFA, 0xFE, 0xFC, 0xFD, 0xFD,
	0xFE, 0xFE, 0xFD, 0xFF, 0xFE, 0x01, 0xFD, 0x01, 0xFE, 0x03, 0xFD, 0x05, 0xFE, 0x05, 0xFE, 0x06,
	0xFE, 0x07, 0xFF, 0x08, 0xFF, 0x09, 0xFF, 0x09, 0xFF, 0x0A, 0x00, 0x09, 0x00, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x88, 0x88, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF6,
	0x00, 0xF7, 0x00, 0xF6, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF9, 0x00, 0xFA, 0x00, 0xFB,
	0x00, 0xFC, 0x00, 0xFC, 0x00, 0xFD, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x03, 0x00, 0x03, 0x00, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x08,
	0x00, 0x09, 0x00, 0x09, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0B,
	0x00, 0x0B, 0x00, 0x03, 0x88, 0x88, 0x00, 0xF5, 0x00, 0xF7, 0x00, 0xF7, 0x00, 0xF8, 0x00, 0xF9,
	0x00, 0xFB, 0x00, 0xFB, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0xFF, 0x00, 0xFF, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x03, 0x00, 0x03, 0x00, 0x05, 0x00, 0x05, 0x00, 0x07, 0x00, 0x08, 0x00, 0x09, 0x00, 0x09,
	0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E,
	0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E,
	0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x00, 0x0E, 0x88, 0x88, 0x00, 0xF6,
	0xFE, 0xF7, 0xFF, 0xF6, 0xFD, 0xF8, 0xFD, 0xF8, 0xFC, 0xF8, 0xFC, 0xFA, 0xFB, 0xFA, 0xFB, 0xFC,
	0xFA, 0xFD, 0xFA, 0xFE, 0xFA, 0xFF, 0xFB, 0x01, 0xFA, 0x01, 0xFA, 0x03, 0xFB, 0x05, 0xFB, 0x05,
	0xFC, 0x06, 0xFC, 0x07, 0xFC, 0x08, 0xFE, 0x09, 0xFE, 0x09, 0xFF, 0x0A, 0xFF, 0x09, 0x00, 0x02,
	0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF9, 0x00, 0xFA, 0x00, 0xFA,
	0x00, 0xFB, 0x00, 0xFC, 0x00, 0xFD, 0x00, 0xFD, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x07, 0x00, 0x08, 0x00, 0x08, 0x00, 0x0A, 0x88, 0x88, 0x00, 0xFC, 0x01, 0xFD, 0x00, 0xFC,
	0x01, 0xFD, 0x02, 0xFC, 0x01, 0xFD, 0x02, 0xFD, 0x02, 0xFC, 0x02, 0xFD, 0x03, 0xFD, 0x03, 0xFD,
	0x03, 0xFD, 0x03, 0xFE, 0x04, 0xFD, 0x03, 0xFE, 0x04, 0xFE, 0x04, 0xFE, 0x04, 0xFE, 0x05, 0xFE,
	0x04, 0xFF, 0x05, 0xFF, 0x04, 0xFF, 0x05, 0xFF, 0x05, 0x00, 0x04, 0xFF, 0x05, 0x00, 0x05, 0x00,
	0x05, 0x00, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x04, 0x02, 0x05, 0x01, 0x04, 0x01, 0x04, 0x02,
	0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x03, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x03, 0x03,
	0x02, 0x03, 0x02, 0x03, 0x02, 0x04, 0x02, 0x03, 0x01, 0x03, 0x01, 0x04, 0x01, 0x04, 0x01, 0x03,
	0x00, 0x04, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0xFD, 0xFF, 0xFD, 0x00, 0xFC,
	0xFE, 0xFD, 0xFF, 0xFD, 0xFE, 0xFE, 0xFE, 0xFD, 0xFE, 0xFD, 0xFE, 0xFE, 0xFD, 0xFD, 0xFD, 0xFE,
	0xFD, 0xFE, 0xFC, 0xFF, 0xFD, 0xFE, 0xFC, 0xFF, 0xFC, 0xFF, 0xFC, 0xFF, 0xFD, 0xFF, 0xFC, 0x00,
	0xFC, 0x00, 0xFC, 0x00, 0xFC, 0x01, 0xFC, 0x00, 0xFC, 0x01, 0xFC, 0x02, 0xFD, 0x01, 0xFC, 0x02,
	0xFD, 0x02, 0xFD, 0x02, 0xFD, 0x02, 0xFE, 0x02, 0xFD, 0x03, 0xFE, 0x03, 0xFE, 0x03, 0xFF, 0x03,
	0xFF, 0x03, 0xFF, 0x03, 0xFF, 0x03, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x88, 0x88,
	0x00, 0xFD, 0x01, 0xFD, 0x00, 0xFC, 0x02, 0xFD, 0x01, 0xFD, 0x02, 0xFE, 0x02, 0xFD, 0x02, 0xFD,
	0x02, 0xFE, 0x03, 0xFD, 0x03, 0xFE, 0x03, 0xFE, 0x04, 0xFF, 0x03, 0xFE, 0x04, 0xFF, 0x04, 0xFF,
	0x04, 0xFF, 0x03, 0xFF, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x01, 0x04, 0x00, 0x04, 0x01,
	0x04, 0x02, 0x03, 0x01, 0x04, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03, 0x02, 0x02, 0x02, 0x03, 0x03,
	0x02, 0x03, 0x02, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x00, 0x03, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x00, 0x88, 0x88, 0x00, 0x01, 0x00, 0x01, 0x00, 0x03, 0x00, 0x03, 0x00, 0x05,
	0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x08, 0x00, 0x09, 0x00, 0x09, 0x00, 0x0A,
	0x00, 0x0A, 0x00, 0x0A, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0B, 0x00, 0x0C, 0x00, 0x0C,
	0x00, 0x03, 0x00, 0xF4, 0x00, 0xF4, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5, 0x00, 0xF5,
	0x00, 0xF6, 0x00, 0xF7, 0x00, 0xF6, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF8, 0x00, 0xF9, 0x00, 0xFA,
	0x00, 0xFB, 0x00, 0xFC, 0x00, 0xFC, 0x00, 0xFD, 0x00, 0xFE, 0x00, 0xFF, 0x00, 0x00
};

const uint8 move_delta_table2[204] = {
	0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFE, 0x00, 0x00, 0xFF, 0xFF, 0x00, 0x00, 0xFF, 0xFF,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01,
	0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03,
	0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x05,
	0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x06,
	0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x08,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A,
	0x00, 0x00, 0x00, 0x0A, 0x00, 0x00, 0x00, 0x0A, 0x88, 0x88, 0x88, 0x88
};

/*const uint16 move_delta_table3[8] = { 0, 1, 1, 2, 2, 3, 4, 0x7777 };*/

const uint16 bird_move_dy_table[15] = { 0, 1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 4, 4, 0x7777, 0x7777 };

const char *snd_module_table__v1[MAX_SND_MODULES] = {
	"SONGDEAD.MOD",
	"SONGMON.MOD",
	"SONGPRES.MOD",
	"SONGWIN.MOD",
	"SONG1.MOD",
	"SONG2.MOD",
	"SONG3.MOD",
	"SONG4.MOD"
};

const char *snd_module_table__v2[MAX_SND_MODULES] = {
	0,
	0,
	"MUSIC0.SNG",
	0,
	"MUSIC1.SNG",
	"MUSIC2.SNG",
	"MUSIC3.SNG",
	"MUSIC4.SNG"
};

const sample_data_t snd_sample_data_table__v1[MAX_SND_SAMPLES] = {
	/* 0 */
	{ 0x0000, 0x0136, 0x190 },
	{ 0x0136, 0x21DC, 0x1AC },
	{ 0x2312, 0x0174, 0x1AC },
	{ 0x2486, 0x0200, 0x1AC },
	/* 4 */
	{ 0x2686, 0x06A0, 0x1AC },
	{ 0x2D26, 0x0710, 0x1AC },
	{ 0x3436, 0x19A0, 0x0CE },
	{ 0x4DD6, 0x044C, 0x1AC },
	/* 8 */
	{ 0x5222, 0x07E8, 0x1AC },
	{ 0x5A0A, 0x03B2, 0x1AC },
	{ 0x5DBC, 0x11F6, 0x1AC },
	{ 0x6FB2, 0x0B54, 0x1AC },
	/* 12 */
	{ 0x7B06, 0x2A82, 0x1F4 },
	{ 0xA588, 0x031C, 0x1AC },
	{ 0xA8A4, 0x1C24, 0x0CE },
	{ 0xC4C8, 0x1DD4, 0x0F0 },
	/* 16 */
	{ 0xE29C, 0x0CCE, 0x1AC },
	{ 0x0136, 0x21DC, 0x320 },
	{ 0x0136, 0x21DC, 0x118 },
	{ 0x0136, 0x21DC, 0x44C }
};

const sample_data_t snd_sample_data_table__v2[MAX_SND_SAMPLES] = {
	/* 0 */
	{ 0x0000, 0x0136, 0x190 },
	{ 0x0136, 0x21DC, 0x1AC },
	{ 0x2312, 0x0174, 0x1AC },
	{ 0x2486, 0x0200, 0x1AC },
	/* 4 */
	{ 0x2686, 0x06A0, 0x1AC },
	{ 0x2D26, 0x0710, 0x1AC },
	{ 0x3436, 0x19A0, 0x0CE },
	{ 0x4DD6, 0x044C, 0x1AC },
	/* 8 */
	{ 0x5222, 0x07E8, 0x1AC },
	{ 0x5A0A, 0x03B2, 0x1AC },
	{ 0x5DBC, 0x11F6, 0x1AC },
	{ 0x6FB2, 0x0B54, 0x1AC },
	/* 12 */
	{ 0x7B06, 0x2A82, 0x1F4 },
	{ 0xA588, 0x031C, 0x1AC },
	{ 0xA8A4, 0x1C24, 0x0CE },
	{ 0xC4C8, 0x1DD4, 0x0F0 },
	/* 16 */
	{ 0xE29C, 0x0B6A, 0x1AC },
	{ 0x0136, 0x21DC, 0x320 },
	{ 0x0136, 0x21DC, 0x118 },
	{ 0x0136, 0x21DC, 0x44C }
};

const uint8 snd_sample_priority_table[MAX_SND_SAMPLES] = {
	3, 8, 8, 3, 5, 4, 5, 5, 10, 3, 7, 8, 10, 1, 9, 10, 6, 9, 9, 9
};

const uint16 mpl_period_table[576] = {
	856, 808, 762, 720, 678, 640, 604, 570, 538, 508, 480, 453,
	428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240, 226,
	214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120, 113,
	850, 802, 757, 715, 674, 637, 601, 567, 535, 505, 477, 450,
	425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 239, 225,
	213, 201, 189, 179, 169, 159, 150, 142, 134, 126, 119, 113,
	844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474, 447,
	422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237, 224,
	211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118, 112,
	838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470, 444,
	419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235, 222,
	209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118, 111,
	832, 785, 741, 699, 660, 623, 588, 555, 524, 495, 467, 441,
	416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233, 220,
	208, 196, 185, 175, 165, 156, 147, 139, 131, 124, 117, 110,
	826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463, 437,
	413, 390, 368, 347, 328, 309, 292, 276, 260, 245, 232, 219,
	206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116, 109,
	820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460, 434,
	410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230, 217,
	205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115, 109,
	814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457, 431,
	407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228, 216,
	204, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114, 108,
	907, 856, 808, 762, 720, 678, 640, 604, 570, 538, 504, 480,
	453, 428, 404, 381, 360, 339, 320, 302, 285, 269, 254, 240,
	226, 214, 202, 190, 180, 170, 160, 151, 143, 135, 127, 120,
	900, 850, 802, 757, 715, 675, 636, 601, 567, 535, 505, 477,
	450, 425, 401, 379, 357, 337, 318, 300, 284, 268, 253, 238,
	225, 212, 200, 189, 179, 169, 159, 150, 142, 134, 126, 119,
	894, 844, 796, 752, 709, 670, 632, 597, 563, 532, 502, 474,
	447, 422, 398, 376, 355, 335, 316, 298, 282, 266, 251, 237,
	223, 211, 199, 188, 177, 167, 158, 149, 141, 133, 125, 118,
	887, 838, 791, 746, 704, 665, 628, 592, 559, 528, 498, 470,
	444, 419, 395, 373, 352, 332, 314, 296, 280, 264, 249, 235,
	222, 209, 198, 187, 176, 166, 157, 148, 140, 132, 125, 118,
	881, 832, 785, 741, 699, 660, 623, 588, 555, 524, 494, 467,
	441, 416, 392, 370, 350, 330, 312, 294, 278, 262, 247, 233,
	220, 208, 196, 185, 175, 165, 156, 147, 139, 131, 123, 117,
	875, 826, 779, 736, 694, 655, 619, 584, 551, 520, 491, 463,
	437, 413, 390, 368, 347, 338, 309, 292, 276, 260, 245, 232,
	219, 206, 195, 184, 174, 164, 155, 146, 138, 130, 123, 116,
	868, 820, 774, 730, 689, 651, 614, 580, 547, 516, 487, 460,
	434, 410, 387, 365, 345, 325, 307, 290, 274, 258, 244, 230,
	217, 205, 193, 183, 172, 163, 154, 145, 137, 129, 122, 115,
	862, 814, 768, 725, 684, 646, 610, 575, 543, 513, 484, 457,
	431, 407, 384, 363, 342, 323, 305, 288, 272, 256, 242, 228,
	216, 203, 192, 181, 171, 161, 152, 144, 136, 128, 121, 114
};
