/**
 * Youtube plugin for showtime version 0.4  by facanferff (Fábio Canada / facanferff@hotmail.com)
 *
 *  Copyright (C) 2011 facanferff (Fábio Canada / facanferff@hotmail.com)
 *
 * 	ChangeLog:
 *	0.4:
 *	- Start work
 * 
 * 
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


(function(plugin) {

    var PREFIX = 'youtube';

    var service = plugin.createService("Youtube", PREFIX + ":start", "video", true,
	plugin.path + "logo.png");
        
    var settings = plugin.createSettings("Youtube", plugin.path + "logo.png", 
        "Youtube: Video Sharing Service");

    settings.createBool("safeSearch", "Enable safeSearch", true, function(v) {
        if (v == '1')
            service.safeSearch = 'strict';
        else
            service.safeSearch = 'none';
    }); 
    
    settings.createBool("background", "Enable background", false, function(v) {
        service.background = v;
    }); 

    settings.createDivider('Advanced Settings');
    
    settings.createInt("entries", "Maximum number of entries per request (default: 150)", 150, 5, 1000, 5, '', function(v) {
        service.entries = v;
    }); 
    
    settings.createBool("mode", "Advanced Youtube (Extra video features)", false, function(v) {
        if (v == '1')
            service.mode = 'advanced';
        else
            service.mode = 'simple';
    }); 
    
    settings.createBool("debug", "Enable Debugging (trace messages)", false, function(v) {
        service.debug = v;
    }); 
    
    var api = new Youtube_API();

    

function startPage(page) {
    page.appendItem(PREFIX + ':mixfeeds:'+ 'standard_feeds', 'directory', {title: 'Standard Feeds'})
    page.appendItem(PREFIX + ':mixfeeds:'+ 'channel_feeds', 'directory', {title: 'Channel Feeds'})
    page.appendItem(PREFIX + ':mixfeeds:'+ 'movie_feeds', 'directory', {title: 'Movie Feeds'})
    page.appendItem(PREFIX + ':mixfeeds:'+ 'trailer_feeds', 'directory', {title: 'Trailer Feeds'})
    page.appendItem(PREFIX + ':user:default', 'directory', {title: 'User Profile'})
    
    page.type = "directory";
    page.contents = "items";
    page.loading = false;

    page.metadata.logo = plugin.path + "logo.png";
    page.metadata.title = "Youtube - Home Page";
  }
  
  plugin.addURI(PREFIX + ":mixfeeds:(.*)", function(page, type) {
    page.metadata.title = 'Youtube';
    page.metadata.logo = plugin.path + "logo.png";
    
    for each (var entry in api[type])
        page.appendItem(PREFIX + ':feed:' + escape(entry[1]),"directory", {title: entry[0]});
    
    page.type = "directory";
    page.contents = "items"
    page.loading = false;
  });
  
  function pageController(page, loader) {
    var offset = 1;
    function paginator() {      
        var num = 0;      
        while(1) {	
            var doc = loader(offset + num).feed;
            page.entries = doc.openSearch$totalResults.$t;
            if (page.entries > service.entries)
                page.entries = service.entries;
            var c = 0;
            for each (var entry in doc.entry) {	
                try {
                    c++;
                    var id, metadata = {}, meta, url;
                    
                    if (entry.title.$t.toString().indexOf('has added a friend') != -1) {
                        entry.category[0].term = 'http://gdata.youtube.com/schemas/2007#friend'
                    }
                    
                    if (entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#video' ||
                        entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#favorite' ||
                        entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#playlist' ||
                        entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#userEvent') {
                        id = entry.id.$t.toString().slice(entry.id.$t.toString().lastIndexOf(':')+1)
                        if (id.length > 11) {
                            if (entry.yt$videoid)
                                id = entry.yt$videoid.$t;
                            else if (entry.content) {
                                id = entry.content.src.toString().slice(entry.content.src.toString().lastIndexOf('/')+1, 
                                    (entry.content.src.toString().lastIndexOf('?')!=-1)?entry.content.src.toString().lastIndexOf('?'):entry.content.src.toString().length)
                            }
                            else {
                                id = entry.link[1].href.replace('https://gdata.youtube.com/feeds/api/videos/','').replace('?v=2',''); 
                                id = id.slice(0, (id.indexOf('/')!=-1)?id.indexOf('/'):id.length)
                            }
                        }
                
                        for (meta in api.metadata_fields) {
                            try {
                                metadata[meta] = eval(api.metadata_fields[meta])
                            }
                            catch(err) {
                                if (service.debug)
                                    showtime.trace('Video '+id+' doesn\'t contain a tag '+meta+'!');
                            }
                        }
                    
                        page.appendItem(PREFIX + ':video:' + service.mode + ':' + metadata.title + ':' + id,"video", metadata);
                    }
                    else if (entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#friend' ||
                        entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#subscription') {
                        page.appendItem(PREFIX + ':user:' + entry.yt$username.$t,"directory", {
                            title: new showtime.RichText(entry.title.$t)
                        });
                    }
                    else if (entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#playlistLink') {
                        url = entry.content.src;
                        page.appendItem(PREFIX + ':feed:' + escape(url),"video", {
                            title: new showtime.RichText(entry.title.$t)
                        });
                    }
                    else if (entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#channel') {
                        page.appendItem(PREFIX + ':feed:' + escape(entry.gd$feedLink[0].href),"video", {
                            title: new showtime.RichText(entry.title.$t)
                        });
                    }
                    else if (entry.category[0].term == 'http://gdata.youtube.com/schemas/2007#channelstandard') {
                        page.appendItem(PREFIX + ':user:' + entry.id.$t.toString().slice(entry.id.$t.toString().lastIndexOf(':')+1),"video", {
                            title: new showtime.RichText(entry.title.$t)
                        });
                    }
                    
                    if (metadata.icon)
                        page.contents = 'items'
                }
                catch(err) {
                    if (service.debug)
                        showtime.trace(err)
                }
            }
            page.loading = false;	
            num += c;
            if(c == 0 || offset > api.args_common['max-results'] || num > parseInt(service.entries))	  
                break;
        }  
        // Reset arguments for HTTP requests
        api.reset_args();
        offset += num;
        
        return offset < page.entries;    
    }
    
    page.type = "directory";
    paginator();    
    page.paginator = paginator;
  }
  
  plugin.addURI(PREFIX + ":feed:(.*)", function(page, url) {
    if (service.background == '1')
        page.metadata.background = 'http://www.deviantart.com/download/130776987/Dark___Youtube_Background_by_billalovesyou.jpg'
    try {
        page.metadata.logo = plugin.path + "logo.png";
        api.reset_args();
        pageController(page, function(offset) { 
            api.args_common['start-index']=offset
            url=unescape(url)
            if (url.indexOf('?')!=-1) {
                var args = url.slice(url.indexOf('?')+1);            
                args=args.split('&')

                for each (var arg in args) {
                    var arg_tmp = arg.split('=')
                    api.args_common[arg_tmp[0]]=arg_tmp[1]
                }
                url=url.slice(0, url.indexOf('?'))
            }
            var doc = showtime.JSONDecode(showtime.httpGet(unescape(url), 
                api.args_common, api.headers_common).toString()); 
            page.metadata.title = doc.feed.title.$t;
            return doc;
        });
        page.type = "directory";
    }
    catch (err) {
        if (err == 'Error: HTTP error: 400') {
            var args = '';
            for (var arg in api.args_common)
                args += '\n' + arg + ': ' + api.args_common[arg]
            showtime.message('The request for the feed contains incompatible args. Please contact facanferff with the following information:\n'+
                err + args, true, false);
        }
        else if (err == 'Error: HTTP error: 404')
            showtime.message('This feed was deleted or is not available at the moment.\nPlease return to the previous page.', true, false);
        else
            showtime.message(err + '\nContact facanferff (the developer)', true, false);
    }
    page.loading = false;
  });
  
  plugin.addURI(PREFIX + ":user:(.*)", function(page, user) {
    if (api.headers_common.Authorization == undefined && user == 'default') {
        if (api.login()==-1)  {
            if(service.debug)
                showtime.trace('User must be authenticated to see this profile!');
            page.loading = false;
            return;
        }
    }

    try {
        api.reset_args();
        var data = showtime.JSONDecode(showtime.httpGet('https://gdata.youtube.com/feeds/api/users/'+user, 
            {alt:'json'}, api.headers_common).toString()).entry;
    
        page.metadata.title = data.title.$t;    
        page.metadata.icon = data.media$thumbnail.url;        
    
        for (var tag in api.user_profile_settings) {
            try {
                if (tag == 'About me')
                    page.appendPassiveItem("bodytext", new showtime.RichText(eval(api.user_profile_settings[tag])));
                else
                    page.appendPassiveItem("label", eval(api.user_profile_settings[tag]), {title: tag});
            }
            catch(err) {
                if (service.debug)
                    showtime.trace('Feed doesn\'t contain a tag '+tag+'!');
            }
        }
      
          for each(var link in data.gd$feedLink) {
              if (((link.rel == 'http://gdata.youtube.com/schemas/2007#user.contacts' ||
                  link.rel == 'http://gdata.youtube.com/schemas/2007#user.subscriptions' ||
                  link.rel == 'http://gdata.youtube.com/schemas/2007#user.newsubscriptionvideos' ||
                  link.rel == 'http://gdata.youtube.com/schemas/2007#user.friendsactivity') &&
                  user != 'default') || link.rel == 'http://gdata.youtube.com/schemas/2007#user.liveevent')
                  continue;
              
              if (link.rel != 'http://gdata.youtube.com/schemas/2007#user.inbox') {
                  var title = link.rel.valueOf().slice(link.rel.valueOf().indexOf('#')+1).replace(/\./g,' ');
                  title = title.slice(title.indexOf(' ')+1)
                  title = title.charAt(0).toUpperCase() + title.slice(1)
                  
                  page.appendAction("navopen", PREFIX + ':feed:'+escape(link.href), true, {                  
                      title: title
                  });
              }
          }
    
        page.type = "item";
    
    }
    catch(err) {
        if (err == 'Error: HTTP error: 404')
            showtime.message('The user specified does not exist. \nReturn to the previous page please.', true, false)
        else
            showtime.message(err + '\nContact facanferff (the developer)', true, false);
    }
    
    page.loading = false;
    page.metadata.title = 'Youtube - User Screen';
  });
  
  plugin.addURI(PREFIX + ":video:simple:(.*):(.*)", function(page, title, id) {
    try {
        var videos = '';
        var data = showtime.httpGet('http://www.youtube.com/watch?v='+id, null, api.headers_common).toString();
        videos = unescape(data.slice(data.indexOf('"url_encoded_fmt_stream_map": "url=')+35,
            data.indexOf('",', data.indexOf('"url_encoded_fmt_stream_map": "url=')))).split(',url=');
    
        // Get first video link available (Best resolution available)
        var video_url = videos[0].slice(0, videos[0].indexOf('\\u0026quality'));
        page.loading = false;
    
        page.source = "videoparams:" + showtime.JSONEncode({      
            title: unescape(title),     
            sources: [{	
                url: unescape(video_url)      
            }]    
        });
    
        page.type = "video";
    }
    catch (err) {
        if (err == 'Error: HTTP error: 404')
            showtime.message('This video was deleted or is not available for your country. \nReturn to the previous page please.', true, false)
        else
            showtime.message(err + '\nContact facanferff (the developer)', true, false);
        page.loading = false;
    }
  });
  
  plugin.addURI(PREFIX + ":video:advanced:(.*):(.*)", function(page, title, id) {
    var data = showtime.JSONDecode(showtime.httpGet('https://gdata.youtube.com/feeds/api/videos/' + id, {
        'alt' : 'json'
    }, api.headers_common).toString()).entry;
    page.metadata.title = title;
    page.metadata.icon = data.media$group.media$thumbnail[0].url;
    
    page.appendPassiveItem("label", data.media$group.media$category[0].$t);	
    
    // Try to get rating of a video
    try {
        page.appendPassiveItem("rating", parseFloat(data.gd$rating.average/5)); 
    }
    catch(err) {
        if (service.debug)
            showtime.trace("This videos doesn't have a rating!");
    }
    
    page.appendPassiveItem("divider");  
    
    for each (var element in api.video_settings) {
        try {
            page.appendPassiveItem("label", eval(element[1]), {title: element[0]}); 
        }
        catch(err) {
            if (service.debug)
                showtime.trace('Video '+id+' doesn\'t have a '+element[0]+' tag!');
        }
    }
    
    page.appendPassiveItem("divider");  
    
    page.appendPassiveItem("bodytext", new showtime.RichText(data.media$group.media$description.$t));
    
    var author = data.author[0].name.$t;
    page.appendAction("navopen", PREFIX + ':user:'+author, true, {                  
        title: author     
    });
    
    data = unescape(showtime.httpGet('http://www.youtube.com/get_video_info', {
        'video_id' : id
    }, api.headers_common).toString());
    
    var urls_start = -1;
    var videos = '';
    var mode = 'non-embedded';
    // Video is not embeddable
    if (data.indexOf('errorcode=150')!=-1){
        data = showtime.httpGet('http://www.youtube.com/watch?v='+id, null, api.headers_common).toString();
        videos = unescape(data.slice(data.indexOf('"url_encoded_fmt_stream_map": "url=')+35,
            data.indexOf('",', data.indexOf('"url_encoded_fmt_stream_map": "url=')))).split(',url=');
    }
    // Video is embeddable
    else {
        urls_start = data.indexOf('url_encoded_fmt_stream_map=url=')
        videos = unescape(data.slice(urls_start+31)).split(',url=');
        mode = 'embedded'
    }
    
    var quality_added = [];
    
    // Get each video link available
    for each (var video in videos) {
        var url;
        if (mode == 'non-embedded')
            url = video.slice(0, video.indexOf('\\u0026quality'))
        else
            url = video.slice(0, video.indexOf('quality'))
        
        var quality;
        if (mode == 'non-embedded')
            quality = video.slice(video.indexOf('quality=')+8, video.indexOf('\\u0026', video.indexOf('quality=')))
        else
            quality = video.slice(video.indexOf('quality=')+8, video.indexOf('&', video.indexOf('quality=')))
        
        if (quality_added.indexOf(quality)!=-1)
            continue;
        
        page.appendAction("navopen", PREFIX + ':video:stream:'+escape(title)+':'+escape(url), true, {      
            title: quality    
        });
        quality_added.push(quality)
    }
    
    page.appendAction("navopen", PREFIX + ':feed:'+escape('https://gdata.youtube.com/feeds/api/videos/'+id+'/related'), true, {                  
        title: 'Related videos'          
    });
    
    page.appendAction("navopen", PREFIX + ':feed:'+escape('https://gdata.youtube.com/feeds/api/videos/'+id+'/responses'), true, {                  
        title: 'Responses videos'          
    });
    
    page.metadata.logo = plugin.path + "logo.png";
    page.type = "item";
    
    page.loading = false;
  });
  
  // We need to use this function so we can pass the correct title of video
  plugin.addURI(PREFIX + ":video:stream:(.*):(.*)", function(page, title, url) {
    page.loading = false;    
    page.source = "videoparams:" + showtime.JSONEncode({      
        title: unescape(title), 
        sources: [{	
            url: unescape(url)   
        }]    
    });    
    page.type = "video";
  });
  
  
  
/*------------------------------------------------------------------------------
 * Functions for Youtube API
 -----------------------------------------------------------------------------*/
function Youtube_API() {
    // Login variables
    this.credentials = {};
    this.SID = '';
    this.login = Youtube_API_login;
    
    this.metadata_fields = {
        'rating': 'parseFloat(entry.gd$rating.average) / 5.0',
        'title': 'entry.title.$t',
        'icon': 'entry.media$group.media$thumbnail[0].url',
        'description': 'new showtime.RichText(entry.media$group.media$description.$t)',
        'duration': 'showtime.durationToString(entry.media$group.yt$duration.seconds)'
    }
    
    // Standard feeds
    this.standard_feeds = [
        ['Top Rated', 'https://gdata.youtube.com/feeds/api/standardfeeds/top_rated'],
        ['Top Favorites', 'https://gdata.youtube.com/feeds/api/standardfeeds/top_favorites'],
        ['Most Viewed', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_viewed'],
        ['Most Shared', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_shared'], // Experimental feature
        ['Most Popular', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_popular'],
        ['Most Recent', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_recent'],
        ['Most Discussed', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_discussed'],
        ['Most Responded', 'https://gdata.youtube.com/feeds/api/standardfeeds/most_responded'],
        ['Recently Featured', 'https://gdata.youtube.com/feeds/api/standardfeeds/recently_featured'],
        ['Trending videos', 'https://gdata.youtube.com/feeds/api/standardfeeds/on_the_web'] // Experimental feature
    ];
    
    // Channel feeds
    this.channel_feeds = [
        ['Most viewed', 'https://gdata.youtube.com/feeds/api/channelstandardfeeds/most_viewed'],
        ['Most subscribed', 'https://gdata.youtube.com/feeds/api/channelstandardfeeds/most_subscribed']
    ];
    
    // Movie feeds
    this.movie_feeds = [
        ['Most Popular Movies', 'https://gdata.youtube.com/feeds/api/charts/movies/most_popular'],
        ['Most Recent Movies', 'https://gdata.youtube.com/feeds/api/charts/movies/most_recent'],
        ['Trending movies', 'https://gdata.youtube.com/feeds/api/charts/movies/trending']
    ];
    
    // Trailer feeds
    this.trailer_feeds = [
        ['Most Popular', 'https://gdata.youtube.com/feeds/api/charts/trailers/most_popular'],
        ['Most Recent', 'https://gdata.youtube.com/feeds/api/charts/trailers/most_recent']
    ];
    
    this.user_profile_settings = {
        'Username':'data.yt$username.$t',
        'First name':'data.yt$firstName.$t',
        'Last name':'data.yt$lastName.$t',
        'Age':'data.yt$age.$t',
        'Gender':'data.yt$gender.$t',
        'Location':'data.yt$location.$t',
        'Hometown':'data.yt$hometown.$t',
        'Company':'data.yt$company.$t',
        'Occupation':'data.yt$occupation.$t',
        'School':'data.yt$school.$t',
        'About me':'data.yt$aboutMe.$t',
        'Hobbies':'data.yt$hobbies.$t',
        'Movies':'data.yt$movies.$t',
        'Music':'data.yt$music.$t',
        'Books':'data.yt$books.$t',
        'Videos uploaded':'data.yt$channelStatistics.videoCount.$t',
        'Channel viewed':'data.yt$channelStatistics.viewCount.$t',
        'Subscribers':'data.yt$statistics.subscriberCount.$t'
    };
    
    this.video_settings = [
        ['Views', 'data.yt$statistics.viewCount'],
        ['Duration', 'showtime.durationToString(data.media$group.yt$duration.seconds)']
    ];
    
    this.reset_args = Youtube_API_reset_args;
    this.reset_args();
    
    // Headers for HTTP requests
    this.headers_common = {
        'GData-Version' : '2',
        'X-GData-Key' : 'key=AI39si7gfa8PEGC6qMb5Kk04aPInFlZVRIPZio6fNE9-0uwS4Qvo9dbhGxzeWIEQ8J4hMHGMtw2xOHuDGn3ped2EktTAVqCU9w' //Don't steal API key
    }
}

/*
 * Login user to Youtube
 * Returns:
 *  0 : Success 
 *  -1 : Fail
 */
function Youtube_API_login() {
    if(this.credentials.username)      
        return true;
        
    var reason = "Login to Youtube account";    
    var do_query = false;    
    while(1) {      
        this.credentials = plugin.getAuthCredentials("Youtube - Video sharing service",	
            reason, do_query, null, false);          
        
        if(!this.credentials) {	
            if(!do_query) {	  
                do_query = true;	  
                continue;	
            }	
            return -1;      
        }
        if (this.credentials.rejected)
            return -1;
        try {
            var v = showtime.httpPost("https://www.google.com/accounts/ClientLogin", {	
                'Email' : this.credentials.username,	
                'Passwd' : this.credentials.password,
                'source' : 'showtime'
            }, {
                'service' : 'youtube'
            }, this.headers_common);
            v = v.toString().split('\n')
            if (service.debug)
                showtime.trace('Logged in to Youtube as user: ' + this.credentials.username);
            this.headers_common.Authorization = 'GoogleLogin ' + v[2]
        }
        catch(err) {
            reason = 'Login failed! Try again.'
            continue;
        }
        return true;    
    }
}
function Youtube_API_reset_args() {
    this.args_common = {
        'alt' : 'json',
        'max-results' : 25,
        'safeSearch' : service.safeSearch
    }
}
  
plugin.addURI(PREFIX+":start", startPage);

plugin.addSearcher("Youtube - Videos", plugin.path + "logo.png",    
    function(page, query) { 
        try {
            pageController(page, function(offset) {	
                api.args_common['start-index'] = offset;
                api.args_common.q = query;
                
                return showtime.JSONDecode(showtime.httpGet("https://gdata.youtube.com/feeds/api/videos", 
                    api.args_common, api.headers_common).toString());
            });
        }
        catch(err){
            if (service.debug)
                showtime.trace('Search Youtube - Videos: '+err)
        }
});

plugin.addSearcher("Youtube - Playlists", plugin.path + "logo.png",    
    function(page, query) { 
        try {
            pageController(page, function(offset) {	
                api.args_common['start-index'] = offset;
                api.args_common.q = query;
                return showtime.JSONDecode(showtime.httpGet("https://gdata.youtube.com/feeds/api/playlists/snippets",
                    api.args_common, api.headers_common).toString());
            });
        }
        catch(err){
            if (service.debug)
                showtime.trace('Search Youtube - Playlists: '+err)
        }
});

plugin.addSearcher("Youtube - Channels", plugin.path + "logo.png",    
    function(page, query) { 
        try {
            pageController(page, function(offset) {	
                api.args_common['start-index'] = offset;
                api.args_common.q = query;
                return showtime.JSONDecode(showtime.httpGet("https://gdata.youtube.com/feeds/api/channels",
                    api.args_common, api.headers_common).toString());
            });
        }
        catch(err){
            if (service.debug)
                showtime.trace('Search Youtube - Channels: '+err)
        }
});

})(this);
