/*
 * translate_table.h - Translation table.
 *
 * Autogenerated by gentranslatetable.sh, DO NOT EDIT !!!
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

/* GLOBAL STRING ID TRANSLATION TABLE */

static int translate_text_table[][countof(language_table)] = {
/* GLOBAL STRING ID DEFINITIONS */

/* autostart.c */
/* en */ {IDGS_CANNOT_LOAD_SNAPSHOT_FILE,
/* de */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DA,
/* de */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DE,
/* fr */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_FR,
/* hu */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_HU,
/* it */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_IT,
/* nl */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_NL,
/* pl */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_PL,
/* sv */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_SV,
/* tr */  IDGS_CANNOT_LOAD_SNAPSHOT_FILE_TR},

/* debug.c */
/* en */ {IDGS_PLAYBACK_ERROR_DIFFERENT,
/* de */  IDGS_PLAYBACK_ERROR_DIFFERENT_DA,
/* de */  IDGS_PLAYBACK_ERROR_DIFFERENT_DE,
/* fr */  IDGS_PLAYBACK_ERROR_DIFFERENT_FR,
/* hu */  IDGS_PLAYBACK_ERROR_DIFFERENT_HU,
/* it */  IDGS_PLAYBACK_ERROR_DIFFERENT_IT,
/* nl */  IDGS_PLAYBACK_ERROR_DIFFERENT_NL,
/* pl */  IDGS_PLAYBACK_ERROR_DIFFERENT_PL,
/* sv */  IDGS_PLAYBACK_ERROR_DIFFERENT_SV,
/* tr */  IDGS_PLAYBACK_ERROR_DIFFERENT_TR},

/* event.c */
/* en */ {IDGS_CANNOT_CREATE_IMAGE,
/* de */  IDGS_CANNOT_CREATE_IMAGE_DA,
/* de */  IDGS_CANNOT_CREATE_IMAGE_DE,
/* fr */  IDGS_CANNOT_CREATE_IMAGE_FR,
/* hu */  IDGS_CANNOT_CREATE_IMAGE_HU,
/* it */  IDGS_CANNOT_CREATE_IMAGE_IT,
/* nl */  IDGS_CANNOT_CREATE_IMAGE_NL,
/* pl */  IDGS_CANNOT_CREATE_IMAGE_PL,
/* sv */  IDGS_CANNOT_CREATE_IMAGE_SV,
/* tr */  IDGS_CANNOT_CREATE_IMAGE_TR},

/* event.c */
/* en */ {IDGS_CANNOT_WRITE_IMAGE_FILE_S,
/* de */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_DA,
/* de */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_DE,
/* fr */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_FR,
/* hu */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_HU,
/* it */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_IT,
/* nl */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_NL,
/* pl */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_PL,
/* sv */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_SV,
/* tr */  IDGS_CANNOT_WRITE_IMAGE_FILE_S_TR},

/* event.c */
/* en */ {IDGS_CANNOT_FIND_MAPPED_NAME_S,
/* de */  IDGS_CANNOT_FIND_MAPPED_NAME_S_DA,
/* de */  IDGS_CANNOT_FIND_MAPPED_NAME_S_DE,
/* fr */  IDGS_CANNOT_FIND_MAPPED_NAME_S_FR,
/* hu */  IDGS_CANNOT_FIND_MAPPED_NAME_S_HU,
/* it */  IDGS_CANNOT_FIND_MAPPED_NAME_S_IT,
/* nl */  IDGS_CANNOT_FIND_MAPPED_NAME_S_NL,
/* pl */  IDGS_CANNOT_FIND_MAPPED_NAME_S_PL,
/* sv */  IDGS_CANNOT_FIND_MAPPED_NAME_S_SV,
/* tr */  IDGS_CANNOT_FIND_MAPPED_NAME_S_TR},

/* event.c */
/* en */ {IDGS_CANT_CREATE_START_SNAP_S,
/* de */  IDGS_CANT_CREATE_START_SNAP_S_DA,
/* de */  IDGS_CANT_CREATE_START_SNAP_S_DE,
/* fr */  IDGS_CANT_CREATE_START_SNAP_S_FR,
/* hu */  IDGS_CANT_CREATE_START_SNAP_S_HU,
/* it */  IDGS_CANT_CREATE_START_SNAP_S_IT,
/* nl */  IDGS_CANT_CREATE_START_SNAP_S_NL,
/* pl */  IDGS_CANT_CREATE_START_SNAP_S_PL,
/* sv */  IDGS_CANT_CREATE_START_SNAP_S_SV,
/* tr */  IDGS_CANT_CREATE_START_SNAP_S_TR},

/* event.c */
/* en */ {IDGS_ERROR_READING_END_SNAP_S,
/* de */  IDGS_ERROR_READING_END_SNAP_S_DA,
/* de */  IDGS_ERROR_READING_END_SNAP_S_DE,
/* fr */  IDGS_ERROR_READING_END_SNAP_S_FR,
/* hu */  IDGS_ERROR_READING_END_SNAP_S_HU,
/* it */  IDGS_ERROR_READING_END_SNAP_S_IT,
/* nl */  IDGS_ERROR_READING_END_SNAP_S_NL,
/* pl */  IDGS_ERROR_READING_END_SNAP_S_PL,
/* sv */  IDGS_ERROR_READING_END_SNAP_S_SV,
/* tr */  IDGS_ERROR_READING_END_SNAP_S_TR},

/* event.c */
/* en */ {IDGS_CANT_CREATE_END_SNAP_S,
/* de */  IDGS_CANT_CREATE_END_SNAP_S_DA,
/* de */  IDGS_CANT_CREATE_END_SNAP_S_DE,
/* fr */  IDGS_CANT_CREATE_END_SNAP_S_FR,
/* hu */  IDGS_CANT_CREATE_END_SNAP_S_HU,
/* it */  IDGS_CANT_CREATE_END_SNAP_S_IT,
/* nl */  IDGS_CANT_CREATE_END_SNAP_S_NL,
/* pl */  IDGS_CANT_CREATE_END_SNAP_S_PL,
/* sv */  IDGS_CANT_CREATE_END_SNAP_S_SV,
/* tr */  IDGS_CANT_CREATE_END_SNAP_S_TR},

/* event.c */
/* en */ {IDGS_CANT_OPEN_END_SNAP_S,
/* de */  IDGS_CANT_OPEN_END_SNAP_S_DA,
/* de */  IDGS_CANT_OPEN_END_SNAP_S_DE,
/* fr */  IDGS_CANT_OPEN_END_SNAP_S_FR,
/* hu */  IDGS_CANT_OPEN_END_SNAP_S_HU,
/* it */  IDGS_CANT_OPEN_END_SNAP_S_IT,
/* nl */  IDGS_CANT_OPEN_END_SNAP_S_NL,
/* pl */  IDGS_CANT_OPEN_END_SNAP_S_PL,
/* sv */  IDGS_CANT_OPEN_END_SNAP_S_SV,
/* tr */  IDGS_CANT_OPEN_END_SNAP_S_TR},

/* event.c */
/* en */ {IDGS_CANT_FIND_SECTION_END_SNAP,
/* de */  IDGS_CANT_FIND_SECTION_END_SNAP_DA,
/* de */  IDGS_CANT_FIND_SECTION_END_SNAP_DE,
/* fr */  IDGS_CANT_FIND_SECTION_END_SNAP_FR,
/* hu */  IDGS_CANT_FIND_SECTION_END_SNAP_HU,
/* it */  IDGS_CANT_FIND_SECTION_END_SNAP_IT,
/* nl */  IDGS_CANT_FIND_SECTION_END_SNAP_NL,
/* pl */  IDGS_CANT_FIND_SECTION_END_SNAP_PL,
/* sv */  IDGS_CANT_FIND_SECTION_END_SNAP_SV,
/* tr */  IDGS_CANT_FIND_SECTION_END_SNAP_TR},

/* event.c */
/* en */ {IDGS_ERROR_READING_START_SNAP_TRIED,
/* de */  IDGS_ERROR_READING_START_SNAP_TRIED_DA,
/* de */  IDGS_ERROR_READING_START_SNAP_TRIED_DE,
/* fr */  IDGS_ERROR_READING_START_SNAP_TRIED_FR,
/* hu */  IDGS_ERROR_READING_START_SNAP_TRIED_HU,
/* it */  IDGS_ERROR_READING_START_SNAP_TRIED_IT,
/* nl */  IDGS_ERROR_READING_START_SNAP_TRIED_NL,
/* pl */  IDGS_ERROR_READING_START_SNAP_TRIED_PL,
/* sv */  IDGS_ERROR_READING_START_SNAP_TRIED_SV,
/* tr */  IDGS_ERROR_READING_START_SNAP_TRIED_TR},

/* event.c */
/* en */ {IDGS_ERROR_READING_START_SNAP,
/* de */  IDGS_ERROR_READING_START_SNAP_DA,
/* de */  IDGS_ERROR_READING_START_SNAP_DE,
/* fr */  IDGS_ERROR_READING_START_SNAP_FR,
/* hu */  IDGS_ERROR_READING_START_SNAP_HU,
/* it */  IDGS_ERROR_READING_START_SNAP_IT,
/* nl */  IDGS_ERROR_READING_START_SNAP_NL,
/* pl */  IDGS_ERROR_READING_START_SNAP_PL,
/* sv */  IDGS_ERROR_READING_START_SNAP_SV,
/* tr */  IDGS_ERROR_READING_START_SNAP_TR},

/* screenshot.c */
/* en */ {IDGS_SORRY_NO_MULTI_RECORDING,
/* de */  IDGS_SORRY_NO_MULTI_RECORDING_DA,
/* de */  IDGS_SORRY_NO_MULTI_RECORDING_DE,
/* fr */  IDGS_SORRY_NO_MULTI_RECORDING_FR,
/* hu */  IDGS_SORRY_NO_MULTI_RECORDING_HU,
/* it */  IDGS_SORRY_NO_MULTI_RECORDING_IT,
/* nl */  IDGS_SORRY_NO_MULTI_RECORDING_NL,
/* pl */  IDGS_SORRY_NO_MULTI_RECORDING_PL,
/* sv */  IDGS_SORRY_NO_MULTI_RECORDING_SV,
/* tr */  IDGS_SORRY_NO_MULTI_RECORDING_TR},

/* sound.c */
/* en */ {IDGS_RECORD_DEVICE_S_NOT_EXIST,
/* de */  IDGS_RECORD_DEVICE_S_NOT_EXIST_DA,
/* de */  IDGS_RECORD_DEVICE_S_NOT_EXIST_DE,
/* fr */  IDGS_RECORD_DEVICE_S_NOT_EXIST_FR,
/* hu */  IDGS_RECORD_DEVICE_S_NOT_EXIST_HU,
/* it */  IDGS_RECORD_DEVICE_S_NOT_EXIST_IT,
/* nl */  IDGS_RECORD_DEVICE_S_NOT_EXIST_NL,
/* pl */  IDGS_RECORD_DEVICE_S_NOT_EXIST_PL,
/* sv */  IDGS_RECORD_DEVICE_S_NOT_EXIST_SV,
/* tr */  IDGS_RECORD_DEVICE_S_NOT_EXIST_TR},

/* sound.c */
/* en */ {IDGS_RECORD_DIFFERENT_PLAYBACK,
/* de */  IDGS_RECORD_DIFFERENT_PLAYBACK_DA,
/* de */  IDGS_RECORD_DIFFERENT_PLAYBACK_DE,
/* fr */  IDGS_RECORD_DIFFERENT_PLAYBACK_FR,
/* hu */  IDGS_RECORD_DIFFERENT_PLAYBACK_HU,
/* it */  IDGS_RECORD_DIFFERENT_PLAYBACK_IT,
/* nl */  IDGS_RECORD_DIFFERENT_PLAYBACK_NL,
/* pl */  IDGS_RECORD_DIFFERENT_PLAYBACK_PL,
/* sv */  IDGS_RECORD_DIFFERENT_PLAYBACK_SV,
/* tr */  IDGS_RECORD_DIFFERENT_PLAYBACK_TR},

/* sound.c */
/* en */ {IDGS_WARNING_RECORDING_REALTIME,
/* de */  IDGS_WARNING_RECORDING_REALTIME_DA,
/* de */  IDGS_WARNING_RECORDING_REALTIME_DE,
/* fr */  IDGS_WARNING_RECORDING_REALTIME_FR,
/* hu */  IDGS_WARNING_RECORDING_REALTIME_HU,
/* it */  IDGS_WARNING_RECORDING_REALTIME_IT,
/* nl */  IDGS_WARNING_RECORDING_REALTIME_NL,
/* pl */  IDGS_WARNING_RECORDING_REALTIME_PL,
/* sv */  IDGS_WARNING_RECORDING_REALTIME_SV,
/* tr */  IDGS_WARNING_RECORDING_REALTIME_TR},

/* sound.c */
/* en */ {IDGS_INIT_FAILED_FOR_DEVICE_S,
/* de */  IDGS_INIT_FAILED_FOR_DEVICE_S_DA,
/* de */  IDGS_INIT_FAILED_FOR_DEVICE_S_DE,
/* fr */  IDGS_INIT_FAILED_FOR_DEVICE_S_FR,
/* hu */  IDGS_INIT_FAILED_FOR_DEVICE_S_HU,
/* it */  IDGS_INIT_FAILED_FOR_DEVICE_S_IT,
/* nl */  IDGS_INIT_FAILED_FOR_DEVICE_S_NL,
/* pl */  IDGS_INIT_FAILED_FOR_DEVICE_S_PL,
/* sv */  IDGS_INIT_FAILED_FOR_DEVICE_S_SV,
/* tr */  IDGS_INIT_FAILED_FOR_DEVICE_S_TR},

/* sound.c */
/* en */ {IDGS_RECORD_NOT_SUPPORT_SOUND_PAR,
/* de */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DA,
/* de */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DE,
/* fr */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_FR,
/* hu */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_HU,
/* it */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_IT,
/* nl */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_NL,
/* pl */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_PL,
/* sv */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_SV,
/* tr */  IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_TR},

/* sound.c */
/* en */ {IDGS_WRITE_TO_SOUND_DEVICE_FAILED,
/* de */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DA,
/* de */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DE,
/* fr */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_FR,
/* hu */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_HU,
/* it */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_IT,
/* nl */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_NL,
/* pl */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_PL,
/* sv */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_SV,
/* tr */  IDGS_WRITE_TO_SOUND_DEVICE_FAILED_TR},

/* sound.c */
/* en */ {IDGS_CANNOT_OPEN_SID_ENGINE,
/* de */  IDGS_CANNOT_OPEN_SID_ENGINE_DA,
/* de */  IDGS_CANNOT_OPEN_SID_ENGINE_DE,
/* fr */  IDGS_CANNOT_OPEN_SID_ENGINE_FR,
/* hu */  IDGS_CANNOT_OPEN_SID_ENGINE_HU,
/* it */  IDGS_CANNOT_OPEN_SID_ENGINE_IT,
/* nl */  IDGS_CANNOT_OPEN_SID_ENGINE_NL,
/* pl */  IDGS_CANNOT_OPEN_SID_ENGINE_PL,
/* sv */  IDGS_CANNOT_OPEN_SID_ENGINE_SV,
/* tr */  IDGS_CANNOT_OPEN_SID_ENGINE_TR},

/* sound.c */
/* en */ {IDGS_CANNOT_INIT_SID_ENGINE,
/* de */  IDGS_CANNOT_INIT_SID_ENGINE_DA,
/* de */  IDGS_CANNOT_INIT_SID_ENGINE_DE,
/* fr */  IDGS_CANNOT_INIT_SID_ENGINE_FR,
/* hu */  IDGS_CANNOT_INIT_SID_ENGINE_HU,
/* it */  IDGS_CANNOT_INIT_SID_ENGINE_IT,
/* nl */  IDGS_CANNOT_INIT_SID_ENGINE_NL,
/* pl */  IDGS_CANNOT_INIT_SID_ENGINE_PL,
/* sv */  IDGS_CANNOT_INIT_SID_ENGINE_SV,
/* tr */  IDGS_CANNOT_INIT_SID_ENGINE_TR},

/* sound.c */
/* en */ {IDGS_DEVICE_S_NOT_FOUND_SUPPORT,
/* de */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DA,
/* de */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DE,
/* fr */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_FR,
/* hu */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_HU,
/* it */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_IT,
/* nl */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_NL,
/* pl */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_PL,
/* sv */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_SV,
/* tr */  IDGS_DEVICE_S_NOT_FOUND_SUPPORT_TR},

/* sound.c */
/* en */ {IDGS_SOUND_BUFFER_OVERFLOW_CYCLE,
/* de */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DA,
/* de */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DE,
/* fr */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_FR,
/* hu */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_HU,
/* it */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_IT,
/* nl */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_NL,
/* pl */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_PL,
/* sv */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_SV,
/* tr */  IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_TR},

/* sound.c */
/* en */ {IDGS_SOUND_BUFFER_OVERFLOW,
/* de */  IDGS_SOUND_BUFFER_OVERFLOW_DA,
/* de */  IDGS_SOUND_BUFFER_OVERFLOW_DE,
/* fr */  IDGS_SOUND_BUFFER_OVERFLOW_FR,
/* hu */  IDGS_SOUND_BUFFER_OVERFLOW_HU,
/* it */  IDGS_SOUND_BUFFER_OVERFLOW_IT,
/* nl */  IDGS_SOUND_BUFFER_OVERFLOW_NL,
/* pl */  IDGS_SOUND_BUFFER_OVERFLOW_PL,
/* sv */  IDGS_SOUND_BUFFER_OVERFLOW_SV,
/* tr */  IDGS_SOUND_BUFFER_OVERFLOW_TR},

/* sound.c */
/* en */ {IDGS_CANNOT_FLUSH,
/* de */  IDGS_CANNOT_FLUSH_DA,
/* de */  IDGS_CANNOT_FLUSH_DE,
/* fr */  IDGS_CANNOT_FLUSH_FR,
/* hu */  IDGS_CANNOT_FLUSH_HU,
/* it */  IDGS_CANNOT_FLUSH_IT,
/* nl */  IDGS_CANNOT_FLUSH_NL,
/* pl */  IDGS_CANNOT_FLUSH_PL,
/* sv */  IDGS_CANNOT_FLUSH_SV,
/* tr */  IDGS_CANNOT_FLUSH_TR},

/* sound.c */
/* en */ {IDGS_FRAGMENT_PROBLEMS,
/* de */  IDGS_FRAGMENT_PROBLEMS_DA,
/* de */  IDGS_FRAGMENT_PROBLEMS_DE,
/* fr */  IDGS_FRAGMENT_PROBLEMS_FR,
/* hu */  IDGS_FRAGMENT_PROBLEMS_HU,
/* it */  IDGS_FRAGMENT_PROBLEMS_IT,
/* nl */  IDGS_FRAGMENT_PROBLEMS_NL,
/* pl */  IDGS_FRAGMENT_PROBLEMS_PL,
/* sv */  IDGS_FRAGMENT_PROBLEMS_SV,
/* tr */  IDGS_FRAGMENT_PROBLEMS_TR},

/* sound.c */
/* en */ {IDGS_RUNNING_TOO_SLOW,
/* de */  IDGS_RUNNING_TOO_SLOW_DA,
/* de */  IDGS_RUNNING_TOO_SLOW_DE,
/* fr */  IDGS_RUNNING_TOO_SLOW_FR,
/* hu */  IDGS_RUNNING_TOO_SLOW_HU,
/* it */  IDGS_RUNNING_TOO_SLOW_IT,
/* nl */  IDGS_RUNNING_TOO_SLOW_NL,
/* pl */  IDGS_RUNNING_TOO_SLOW_PL,
/* sv */  IDGS_RUNNING_TOO_SLOW_SV,
/* tr */  IDGS_RUNNING_TOO_SLOW_TR},

/* sound.c */
/* en */ {IDGS_STORE_SOUNDDEVICE_FAILED,
/* de */  IDGS_STORE_SOUNDDEVICE_FAILED_DA,
/* de */  IDGS_STORE_SOUNDDEVICE_FAILED_DE,
/* fr */  IDGS_STORE_SOUNDDEVICE_FAILED_FR,
/* hu */  IDGS_STORE_SOUNDDEVICE_FAILED_HU,
/* it */  IDGS_STORE_SOUNDDEVICE_FAILED_IT,
/* nl */  IDGS_STORE_SOUNDDEVICE_FAILED_NL,
/* pl */  IDGS_STORE_SOUNDDEVICE_FAILED_PL,
/* sv */  IDGS_STORE_SOUNDDEVICE_FAILED_SV,
/* tr */  IDGS_STORE_SOUNDDEVICE_FAILED_TR},

/* c64/c64export.c */
/* en */ {IDGS_RESOURCE_S_BLOCKED_BY_S,
/* de */  IDGS_RESOURCE_S_BLOCKED_BY_S_DA,
/* de */  IDGS_RESOURCE_S_BLOCKED_BY_S_DE,
/* fr */  IDGS_RESOURCE_S_BLOCKED_BY_S_FR,
/* hu */  IDGS_RESOURCE_S_BLOCKED_BY_S_HU,
/* it */  IDGS_RESOURCE_S_BLOCKED_BY_S_IT,
/* nl */  IDGS_RESOURCE_S_BLOCKED_BY_S_NL,
/* pl */  IDGS_RESOURCE_S_BLOCKED_BY_S_PL,
/* sv */  IDGS_RESOURCE_S_BLOCKED_BY_S_SV,
/* tr */  IDGS_RESOURCE_S_BLOCKED_BY_S_TR},

#ifdef HAVE_NETWORK
/* network.c */
/* en */ {IDGS_TESTING_BEST_FRAME_DELAY,
/* de */  IDGS_TESTING_BEST_FRAME_DELAY_DA,
/* de */  IDGS_TESTING_BEST_FRAME_DELAY_DE,
/* fr */  IDGS_TESTING_BEST_FRAME_DELAY_FR,
/* hu */  IDGS_TESTING_BEST_FRAME_DELAY_HU,
/* it */  IDGS_TESTING_BEST_FRAME_DELAY_IT,
/* nl */  IDGS_TESTING_BEST_FRAME_DELAY_NL,
/* pl */  IDGS_TESTING_BEST_FRAME_DELAY_PL,
/* sv */  IDGS_TESTING_BEST_FRAME_DELAY_SV,
/* tr */  IDGS_TESTING_BEST_FRAME_DELAY_TR},

/* network.c */
/* en */ {IDGS_USING_D_FRAMES_DELAY,
/* de */  IDGS_USING_D_FRAMES_DELAY_DA,
/* de */  IDGS_USING_D_FRAMES_DELAY_DE,
/* fr */  IDGS_USING_D_FRAMES_DELAY_FR,
/* hu */  IDGS_USING_D_FRAMES_DELAY_HU,
/* it */  IDGS_USING_D_FRAMES_DELAY_IT,
/* nl */  IDGS_USING_D_FRAMES_DELAY_NL,
/* pl */  IDGS_USING_D_FRAMES_DELAY_PL,
/* sv */  IDGS_USING_D_FRAMES_DELAY_SV,
/* tr */  IDGS_USING_D_FRAMES_DELAY_TR},

/* network.c */
/* en */ {IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER,
/* de */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DA,
/* de */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DE,
/* fr */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_FR,
/* hu */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_HU,
/* it */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_IT,
/* nl */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_NL,
/* pl */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_PL,
/* sv */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_SV,
/* tr */  IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_TR},

/* network.c */
/* en */ {IDGS_SENDING_SNAPSHOT_TO_CLIENT,
/* de */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_DA,
/* de */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_DE,
/* fr */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_FR,
/* hu */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_HU,
/* it */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_IT,
/* nl */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_NL,
/* pl */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_PL,
/* sv */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_SV,
/* tr */  IDGS_SENDING_SNAPSHOT_TO_CLIENT_TR},

/* network.c */
/* en */ {IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT,
/* de */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DA,
/* de */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DE,
/* fr */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_FR,
/* hu */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_HU,
/* it */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_IT,
/* nl */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_NL,
/* pl */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_PL,
/* sv */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_SV,
/* tr */  IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_TR},

/* network.c */
/* en */ {IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S,
/* de */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DA,
/* de */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DE,
/* fr */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_FR,
/* hu */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_HU,
/* it */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_IT,
/* nl */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_NL,
/* pl */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_PL,
/* sv */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_SV,
/* tr */  IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_TR},

/* network.c */
/* en */ {IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S,
/* de */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DA,
/* de */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DE,
/* fr */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_FR,
/* hu */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_HU,
/* it */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_IT,
/* nl */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_NL,
/* pl */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_PL,
/* sv */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_SV,
/* tr */  IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_TR},

/* network.c */
/* en */ {IDGS_SERVER_IS_WAITING_FOR_CLIENT,
/* de */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_DA,
/* de */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_DE,
/* fr */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_FR,
/* hu */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_HU,
/* it */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_IT,
/* nl */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_NL,
/* pl */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_PL,
/* sv */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_SV,
/* tr */  IDGS_SERVER_IS_WAITING_FOR_CLIENT_TR},

/* network.c */
/* en */ {IDGS_CANNOT_RESOLVE_S,
/* de */  IDGS_CANNOT_RESOLVE_S_DA,
/* de */  IDGS_CANNOT_RESOLVE_S_DE,
/* fr */  IDGS_CANNOT_RESOLVE_S_FR,
/* hu */  IDGS_CANNOT_RESOLVE_S_HU,
/* it */  IDGS_CANNOT_RESOLVE_S_IT,
/* nl */  IDGS_CANNOT_RESOLVE_S_NL,
/* pl */  IDGS_CANNOT_RESOLVE_S_PL,
/* sv */  IDGS_CANNOT_RESOLVE_S_SV,
/* tr */  IDGS_CANNOT_RESOLVE_S_TR},

/* network.c */
/* en */ {IDGS_CANNOT_CONNECT_TO_S,
/* de */  IDGS_CANNOT_CONNECT_TO_S_DA,
/* de */  IDGS_CANNOT_CONNECT_TO_S_DE,
/* fr */  IDGS_CANNOT_CONNECT_TO_S_FR,
/* hu */  IDGS_CANNOT_CONNECT_TO_S_HU,
/* it */  IDGS_CANNOT_CONNECT_TO_S_IT,
/* nl */  IDGS_CANNOT_CONNECT_TO_S_NL,
/* pl */  IDGS_CANNOT_CONNECT_TO_S_PL,
/* sv */  IDGS_CANNOT_CONNECT_TO_S_SV,
/* tr */  IDGS_CANNOT_CONNECT_TO_S_TR},

/* network.c */
/* en */ {IDGS_RECEIVING_SNAPSHOT_SERVER,
/* de */  IDGS_RECEIVING_SNAPSHOT_SERVER_DA,
/* de */  IDGS_RECEIVING_SNAPSHOT_SERVER_DE,
/* fr */  IDGS_RECEIVING_SNAPSHOT_SERVER_FR,
/* hu */  IDGS_RECEIVING_SNAPSHOT_SERVER_HU,
/* it */  IDGS_RECEIVING_SNAPSHOT_SERVER_IT,
/* nl */  IDGS_RECEIVING_SNAPSHOT_SERVER_NL,
/* pl */  IDGS_RECEIVING_SNAPSHOT_SERVER_PL,
/* sv */  IDGS_RECEIVING_SNAPSHOT_SERVER_SV,
/* tr */  IDGS_RECEIVING_SNAPSHOT_SERVER_TR},

/* network.c */
/* en */ {IDGS_NETWORK_OUT_OF_SYNC,
/* de */  IDGS_NETWORK_OUT_OF_SYNC_DA,
/* de */  IDGS_NETWORK_OUT_OF_SYNC_DE,
/* fr */  IDGS_NETWORK_OUT_OF_SYNC_FR,
/* hu */  IDGS_NETWORK_OUT_OF_SYNC_HU,
/* it */  IDGS_NETWORK_OUT_OF_SYNC_IT,
/* nl */  IDGS_NETWORK_OUT_OF_SYNC_NL,
/* pl */  IDGS_NETWORK_OUT_OF_SYNC_PL,
/* sv */  IDGS_NETWORK_OUT_OF_SYNC_SV,
/* tr */  IDGS_NETWORK_OUT_OF_SYNC_TR},

/* network.c */
/* en */ {IDGS_REMOTE_HOST_DISCONNECTED,
/* de */  IDGS_REMOTE_HOST_DISCONNECTED_DA,
/* de */  IDGS_REMOTE_HOST_DISCONNECTED_DE,
/* fr */  IDGS_REMOTE_HOST_DISCONNECTED_FR,
/* hu */  IDGS_REMOTE_HOST_DISCONNECTED_HU,
/* it */  IDGS_REMOTE_HOST_DISCONNECTED_IT,
/* nl */  IDGS_REMOTE_HOST_DISCONNECTED_NL,
/* pl */  IDGS_REMOTE_HOST_DISCONNECTED_PL,
/* sv */  IDGS_REMOTE_HOST_DISCONNECTED_SV,
/* tr */  IDGS_REMOTE_HOST_DISCONNECTED_TR},

/* network.c */
/* en */ {IDGS_REMOTE_HOST_SUSPENDING,
/* de */  IDGS_REMOTE_HOST_SUSPENDING_DA,
/* de */  IDGS_REMOTE_HOST_SUSPENDING_DE,
/* fr */  IDGS_REMOTE_HOST_SUSPENDING_FR,
/* hu */  IDGS_REMOTE_HOST_SUSPENDING_HU,
/* it */  IDGS_REMOTE_HOST_SUSPENDING_IT,
/* nl */  IDGS_REMOTE_HOST_SUSPENDING_NL,
/* pl */  IDGS_REMOTE_HOST_SUSPENDING_PL,
/* sv */  IDGS_REMOTE_HOST_SUSPENDING_SV,
/* tr */  IDGS_REMOTE_HOST_SUSPENDING_TR},

#ifdef HAVE_IPV6
/* network.c */
/* en */ {IDGS_CANNOT_SWITCH_IPV4_IPV6,
/* de */  IDGS_CANNOT_SWITCH_IPV4_IPV6_DA,
/* de */  IDGS_CANNOT_SWITCH_IPV4_IPV6_DE,
/* fr */  IDGS_CANNOT_SWITCH_IPV4_IPV6_FR,
/* hu */  IDGS_CANNOT_SWITCH_IPV4_IPV6_HU,
/* it */  IDGS_CANNOT_SWITCH_IPV4_IPV6_IT,
/* nl */  IDGS_CANNOT_SWITCH_IPV4_IPV6_NL,
/* pl */  IDGS_CANNOT_SWITCH_IPV4_IPV6_PL,
/* sv */  IDGS_CANNOT_SWITCH_IPV4_IPV6_SV,
/* tr */  IDGS_CANNOT_SWITCH_IPV4_IPV6_TR},
#endif   /* HAVE_IPV6 */

/* network.c */
/* en */ {IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT,
/* de */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DA,
/* de */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DE,
/* fr */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_FR,
/* hu */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_HU,
/* it */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_IT,
/* nl */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_NL,
/* pl */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_PL,
/* sv */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_SV,
/* tr */  IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_TR},
#endif   /* HAVE_NETWORK */

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_VSTREAM,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DA,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DE,
/* fr */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_FR,
/* hu */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_HU,
/* it */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_IT,
/* nl */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_NL,
/* pl */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_PL,
/* sv */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_SV,
/* tr */  IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_TR},

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_ASTREAM,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DA,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DE,
/* fr */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_FR,
/* hu */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_HU,
/* it */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_IT,
/* nl */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_NL,
/* pl */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_PL,
/* sv */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_SV,
/* tr */  IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_TR},

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDGS_FFMPEG_CANNOT_OPEN_S,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_S_DA,
/* de */  IDGS_FFMPEG_CANNOT_OPEN_S_DE,
/* fr */  IDGS_FFMPEG_CANNOT_OPEN_S_FR,
/* hu */  IDGS_FFMPEG_CANNOT_OPEN_S_HU,
/* it */  IDGS_FFMPEG_CANNOT_OPEN_S_IT,
/* nl */  IDGS_FFMPEG_CANNOT_OPEN_S_NL,
/* pl */  IDGS_FFMPEG_CANNOT_OPEN_S_PL,
/* sv */  IDGS_FFMPEG_CANNOT_OPEN_S_SV,
/* tr */  IDGS_FFMPEG_CANNOT_OPEN_S_TR},

/* c64/c64io.c */
/* en */ {IDGS_IO_READ_COLL_AT_X_FROM,
/* de */  IDGS_IO_READ_COLL_AT_X_FROM_DA,
/* de */  IDGS_IO_READ_COLL_AT_X_FROM_DE,
/* fr */  IDGS_IO_READ_COLL_AT_X_FROM_FR,
/* hu */  IDGS_IO_READ_COLL_AT_X_FROM_HU,
/* it */  IDGS_IO_READ_COLL_AT_X_FROM_IT,
/* nl */  IDGS_IO_READ_COLL_AT_X_FROM_NL,
/* pl */  IDGS_IO_READ_COLL_AT_X_FROM_PL,
/* sv */  IDGS_IO_READ_COLL_AT_X_FROM_SV,
/* tr */  IDGS_IO_READ_COLL_AT_X_FROM_TR},

/* c64/c64io.c */
/* en */ {IDGS_AND,
/* de */  IDGS_AND_DA,
/* de */  IDGS_AND_DE,
/* fr */  IDGS_AND_FR,
/* hu */  IDGS_AND_HU,
/* it */  IDGS_AND_IT,
/* nl */  IDGS_AND_NL,
/* pl */  IDGS_AND_PL,
/* sv */  IDGS_AND_SV,
/* tr */  IDGS_AND_TR},

/* c64/c64io.c */
/* en */ {IDGS_ALL_DEVICES_DETACHED,
/* de */  IDGS_ALL_DEVICES_DETACHED_DA,
/* de */  IDGS_ALL_DEVICES_DETACHED_DE,
/* fr */  IDGS_ALL_DEVICES_DETACHED_FR,
/* hu */  IDGS_ALL_DEVICES_DETACHED_HU,
/* it */  IDGS_ALL_DEVICES_DETACHED_IT,
/* nl */  IDGS_ALL_DEVICES_DETACHED_NL,
/* pl */  IDGS_ALL_DEVICES_DETACHED_PL,
/* sv */  IDGS_ALL_DEVICES_DETACHED_SV,
/* tr */  IDGS_ALL_DEVICES_DETACHED_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_NO_FILENAME,
/* de */  IDGS_NO_FILENAME_DA,
/* de */  IDGS_NO_FILENAME_DE,
/* fr */  IDGS_NO_FILENAME_FR,
/* hu */  IDGS_NO_FILENAME_HU,
/* it */  IDGS_NO_FILENAME_IT,
/* nl */  IDGS_NO_FILENAME_NL,
/* pl */  IDGS_NO_FILENAME_PL,
/* sv */  IDGS_NO_FILENAME_SV,
/* tr */  IDGS_NO_FILENAME_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ILLEGAL_FILENAME,
/* de */  IDGS_ILLEGAL_FILENAME_DA,
/* de */  IDGS_ILLEGAL_FILENAME_DE,
/* fr */  IDGS_ILLEGAL_FILENAME_FR,
/* hu */  IDGS_ILLEGAL_FILENAME_HU,
/* it */  IDGS_ILLEGAL_FILENAME_IT,
/* nl */  IDGS_ILLEGAL_FILENAME_NL,
/* pl */  IDGS_ILLEGAL_FILENAME_PL,
/* sv */  IDGS_ILLEGAL_FILENAME_SV,
/* tr */  IDGS_ILLEGAL_FILENAME_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ERROR_CREATING_FILE_S,
/* de */  IDGS_ERROR_CREATING_FILE_S_DA,
/* de */  IDGS_ERROR_CREATING_FILE_S_DE,
/* fr */  IDGS_ERROR_CREATING_FILE_S_FR,
/* hu */  IDGS_ERROR_CREATING_FILE_S_HU,
/* it */  IDGS_ERROR_CREATING_FILE_S_IT,
/* nl */  IDGS_ERROR_CREATING_FILE_S_NL,
/* pl */  IDGS_ERROR_CREATING_FILE_S_PL,
/* sv */  IDGS_ERROR_CREATING_FILE_S_SV,
/* tr */  IDGS_ERROR_CREATING_FILE_S_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_ERROR_WRITING_TO_FILE_S,
/* de */  IDGS_ERROR_WRITING_TO_FILE_S_DA,
/* de */  IDGS_ERROR_WRITING_TO_FILE_S_DE,
/* fr */  IDGS_ERROR_WRITING_TO_FILE_S_FR,
/* hu */  IDGS_ERROR_WRITING_TO_FILE_S_HU,
/* it */  IDGS_ERROR_WRITING_TO_FILE_S_IT,
/* nl */  IDGS_ERROR_WRITING_TO_FILE_S_NL,
/* pl */  IDGS_ERROR_WRITING_TO_FILE_S_PL,
/* sv */  IDGS_ERROR_WRITING_TO_FILE_S_SV,
/* tr */  IDGS_ERROR_WRITING_TO_FILE_S_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDCLS_ENABLE_DTV_FLASH_LOG,
/* de */  IDCLS_ENABLE_DTV_FLASH_LOG_DA,
/* de */  IDCLS_ENABLE_DTV_FLASH_LOG_DE,
/* fr */  IDCLS_ENABLE_DTV_FLASH_LOG_FR,
/* hu */  IDCLS_ENABLE_DTV_FLASH_LOG_HU,
/* it */  IDCLS_ENABLE_DTV_FLASH_LOG_IT,
/* nl */  IDCLS_ENABLE_DTV_FLASH_LOG_NL,
/* pl */  IDCLS_ENABLE_DTV_FLASH_LOG_PL,
/* sv */  IDCLS_ENABLE_DTV_FLASH_LOG_SV,
/* tr */  IDCLS_ENABLE_DTV_FLASH_LOG_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDCLS_DISABLE_DTV_FLASH_LOG,
/* de */  IDCLS_DISABLE_DTV_FLASH_LOG_DA,
/* de */  IDCLS_DISABLE_DTV_FLASH_LOG_DE,
/* fr */  IDCLS_DISABLE_DTV_FLASH_LOG_FR,
/* hu */  IDCLS_DISABLE_DTV_FLASH_LOG_HU,
/* it */  IDCLS_DISABLE_DTV_FLASH_LOG_IT,
/* nl */  IDCLS_DISABLE_DTV_FLASH_LOG_NL,
/* pl */  IDCLS_DISABLE_DTV_FLASH_LOG_PL,
/* sv */  IDCLS_DISABLE_DTV_FLASH_LOG_SV,
/* tr */  IDCLS_DISABLE_DTV_FLASH_LOG_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDGS_DTV_ROM_CREATED,
/* de */  IDGS_DTV_ROM_CREATED_DA,
/* de */  IDGS_DTV_ROM_CREATED_DE,
/* fr */  IDGS_DTV_ROM_CREATED_FR,
/* hu */  IDGS_DTV_ROM_CREATED_HU,
/* it */  IDGS_DTV_ROM_CREATED_IT,
/* nl */  IDGS_DTV_ROM_CREATED_NL,
/* pl */  IDGS_DTV_ROM_CREATED_PL,
/* sv */  IDGS_DTV_ROM_CREATED_SV,
/* tr */  IDGS_DTV_ROM_CREATED_TR},


/* COMMAND-LINE STRING ID DEFINITIONS */
/* autostart.c */
/* en */ {IDCLS_AUTOSTART_LOAD_TO_BASIC_START,
/* de */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DA,
/* de */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DE,
/* fr */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_FR,
/* hu */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_HU,
/* it */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_IT,
/* nl */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_NL,
/* pl */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_PL,
/* sv */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_SV,
/* tr */  IDCLS_AUTOSTART_LOAD_TO_BASIC_START_TR},

/* autostart.c */
/* en */ {IDCLS_AUTOSTART_LOAD_WITH_1,
/* de */  IDCLS_AUTOSTART_LOAD_WITH_1_DA,
/* de */  IDCLS_AUTOSTART_LOAD_WITH_1_DE,
/* fr */  IDCLS_AUTOSTART_LOAD_WITH_1_FR,
/* hu */  IDCLS_AUTOSTART_LOAD_WITH_1_HU,
/* it */  IDCLS_AUTOSTART_LOAD_WITH_1_IT,
/* nl */  IDCLS_AUTOSTART_LOAD_WITH_1_NL,
/* pl */  IDCLS_AUTOSTART_LOAD_WITH_1_PL,
/* sv */  IDCLS_AUTOSTART_LOAD_WITH_1_SV,
/* tr */  IDCLS_AUTOSTART_LOAD_WITH_1_TR},

/* autostart.c */
/* en */ {IDCLS_ENABLE_AUTOSTARTWITHCOLON,
/* de */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_DA,
/* de */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_DE,
/* fr */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_FR,
/* hu */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_HU,
/* it */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_IT,
/* nl */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_NL,
/* pl */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_PL,
/* sv */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_SV,
/* tr */  IDCLS_ENABLE_AUTOSTARTWITHCOLON_TR},

/* autostart.c */
/* en */ {IDCLS_DISABLE_AUTOSTARTWITHCOLON,
/* de */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_DA,
/* de */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_DE,
/* fr */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_FR,
/* hu */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_HU,
/* it */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_IT,
/* nl */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_NL,
/* pl */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_PL,
/* sv */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_SV,
/* tr */  IDCLS_DISABLE_AUTOSTARTWITHCOLON_TR},

/* autostart.c */
/* en */ {IDCLS_ENABLE_AUTOSTART_HANDLE_TDE,
/* de */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DA,
/* de */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DE,
/* fr */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_FR,
/* hu */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_HU,
/* it */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_IT,
/* nl */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_NL,
/* pl */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_PL,
/* sv */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_SV,
/* tr */  IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_TR},

/* autostart.c */
/* en */ {IDCLS_DISABLE_AUTOSTART_HANDLE_TDE,
/* de */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DA,
/* de */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DE,
/* fr */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_FR,
/* hu */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_HU,
/* it */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_IT,
/* nl */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_NL,
/* pl */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_PL,
/* sv */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_SV,
/* tr */  IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_TR},

/* autostart.c */
/* en */ {IDCLS_ENABLE_WARP_MODE_AUTOSTART,
/* de */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_DA,
/* de */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_DE,
/* fr */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_FR,
/* hu */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_HU,
/* it */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_IT,
/* nl */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_NL,
/* pl */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_PL,
/* sv */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_SV,
/* tr */  IDCLS_ENABLE_WARP_MODE_AUTOSTART_TR},

/* autostart.c */
/* en */ {IDCLS_DISABLE_WARP_MODE_AUTOSTART,
/* de */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_DA,
/* de */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_DE,
/* fr */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_FR,
/* hu */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_HU,
/* it */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_IT,
/* nl */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_NL,
/* pl */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_PL,
/* sv */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_SV,
/* tr */  IDCLS_DISABLE_WARP_MODE_AUTOSTART_TR},

/* autostart.c */
/* en */ {IDCLS_SET_AUTOSTART_MODE_FOR_PRG,
/* de */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DA,
/* de */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DE,
/* fr */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_FR,
/* hu */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_HU,
/* it */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_IT,
/* nl */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_NL,
/* pl */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_PL,
/* sv */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_SV,
/* tr */  IDCLS_SET_AUTOSTART_MODE_FOR_PRG_TR},

/* autostart.c */
/* en */ {IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG,
/* de */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DA,
/* de */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DE,
/* fr */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_FR,
/* hu */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_HU,
/* it */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_IT,
/* nl */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_NL,
/* pl */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_PL,
/* sv */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_SV,
/* tr */  IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_USE_PAL_SYNC_FACTOR,
/* de */  IDCLS_USE_PAL_SYNC_FACTOR_DA,
/* de */  IDCLS_USE_PAL_SYNC_FACTOR_DE,
/* fr */  IDCLS_USE_PAL_SYNC_FACTOR_FR,
/* hu */  IDCLS_USE_PAL_SYNC_FACTOR_HU,
/* it */  IDCLS_USE_PAL_SYNC_FACTOR_IT,
/* nl */  IDCLS_USE_PAL_SYNC_FACTOR_NL,
/* pl */  IDCLS_USE_PAL_SYNC_FACTOR_PL,
/* sv */  IDCLS_USE_PAL_SYNC_FACTOR_SV,
/* tr */  IDCLS_USE_PAL_SYNC_FACTOR_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_USE_NTSC_SYNC_FACTOR,
/* de */  IDCLS_USE_NTSC_SYNC_FACTOR_DA,
/* de */  IDCLS_USE_NTSC_SYNC_FACTOR_DE,
/* fr */  IDCLS_USE_NTSC_SYNC_FACTOR_FR,
/* hu */  IDCLS_USE_NTSC_SYNC_FACTOR_HU,
/* it */  IDCLS_USE_NTSC_SYNC_FACTOR_IT,
/* nl */  IDCLS_USE_NTSC_SYNC_FACTOR_NL,
/* pl */  IDCLS_USE_NTSC_SYNC_FACTOR_PL,
/* sv */  IDCLS_USE_NTSC_SYNC_FACTOR_SV,
/* tr */  IDCLS_USE_NTSC_SYNC_FACTOR_TR},

/* c128/c128-cmdline-options.c, c128/functionrom.c,
c64/c64-cmdline-options.c, c64/cart/georam.c,
c64/cart/ramcart.c, c64/cart/reu.c, c64/cart/c64cart.c,
c64/cart/ide64.c, cbm2/cbm2-cmdline-options.c,
drive/iec/iec-cmdline-options.c, drive/iec128dcr/iec128dcr-cmdline-options.c,
drive/ieee/ieee-cmdline-options.c, drive/tcbm/tcbm-cmdline-options.c,
fsdevice/fsdevice-cmdline-options.c, pet/pet-cmdline-options.c,
plus4/plus4-cmdline-options.c, printerdrv/driver-select.c,
printerdrv/output-select.c, printerdrv/output-text.c,
rs232drv/rs232drv.c, vic20/vic20-cmdline-options.c,
vic20/vic20cartridge.c, video/video-cmdline-options.c,
fliplist.c, initcmdline.c, log.c, sound.c, c64/plus60k.c,
c64/c64_256k.c, pet/petreu.c, c64/plus256k.c,
c64/cart/mmc64.c */
/* en */ {IDCLS_P_NAME,
/* de */  IDCLS_P_NAME_DA,
/* de */  IDCLS_P_NAME_DE,
/* fr */  IDCLS_P_NAME_FR,
/* hu */  IDCLS_P_NAME_HU,
/* it */  IDCLS_P_NAME_IT,
/* nl */  IDCLS_P_NAME_NL,
/* pl */  IDCLS_P_NAME_PL,
/* sv */  IDCLS_P_NAME_SV,
/* tr */  IDCLS_P_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INT_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_INT_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_INT_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_INT_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_INT_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_INT_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_INT_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_INT_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_INT_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_INT_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_DE_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_DE_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_DE_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_DE_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_DE_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_DE_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_DE_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_DE_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_DE_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_DE_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FI_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_FI_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_FI_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_FI_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_FI_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_FI_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_FI_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_FI_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_FI_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_FI_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FR_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_FR_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_FR_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_FR_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_FR_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_FR_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_FR_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_FR_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_FR_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_FR_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_IT_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_IT_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_IT_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_IT_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_IT_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_IT_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_IT_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_IT_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_IT_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_IT_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_NO_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_NO_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_NO_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_NO_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_NO_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_NO_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_NO_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_NO_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_NO_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_NO_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SV_KERNEL_NAME,
/* de */  IDCLS_SPECIFY_SV_KERNEL_NAME_DA,
/* de */  IDCLS_SPECIFY_SV_KERNEL_NAME_DE,
/* fr */  IDCLS_SPECIFY_SV_KERNEL_NAME_FR,
/* hu */  IDCLS_SPECIFY_SV_KERNEL_NAME_HU,
/* it */  IDCLS_SPECIFY_SV_KERNEL_NAME_IT,
/* nl */  IDCLS_SPECIFY_SV_KERNEL_NAME_NL,
/* pl */  IDCLS_SPECIFY_SV_KERNEL_NAME_PL,
/* sv */  IDCLS_SPECIFY_SV_KERNEL_NAME_SV,
/* tr */  IDCLS_SPECIFY_SV_KERNEL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME_LOW,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DA,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DE,
/* fr */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_FR,
/* hu */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_HU,
/* it */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_IT,
/* nl */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_NL,
/* pl */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_PL,
/* sv */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_SV,
/* tr */  IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DA,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DE,
/* fr */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_FR,
/* hu */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_HU,
/* it */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_IT,
/* nl */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_NL,
/* pl */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_PL,
/* sv */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_SV,
/* tr */  IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME,
/* de */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME,
/* de */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME,
/* de */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME,
/* de */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_C64_MODE_KERNAL_NAME,
/* de */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DA,
/* de */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DE,
/* fr */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_FR,
/* hu */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_HU,
/* it */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_IT,
/* nl */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_NL,
/* pl */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_PL,
/* sv */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_SV,
/* tr */  IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_C64_MODE_BASIC_NAME,
/* de */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DA,
/* de */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DE,
/* fr */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_FR,
/* hu */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_HU,
/* it */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_IT,
/* nl */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_NL,
/* pl */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_PL,
/* sv */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_SV,
/* tr */  IDCLS_SPECIFY_C64_MODE_BASIC_NAME_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_ENABLE_EMULATOR_ID,
/* de */  IDCLS_ENABLE_EMULATOR_ID_DA,
/* de */  IDCLS_ENABLE_EMULATOR_ID_DE,
/* fr */  IDCLS_ENABLE_EMULATOR_ID_FR,
/* hu */  IDCLS_ENABLE_EMULATOR_ID_HU,
/* it */  IDCLS_ENABLE_EMULATOR_ID_IT,
/* nl */  IDCLS_ENABLE_EMULATOR_ID_NL,
/* pl */  IDCLS_ENABLE_EMULATOR_ID_PL,
/* sv */  IDCLS_ENABLE_EMULATOR_ID_SV,
/* tr */  IDCLS_ENABLE_EMULATOR_ID_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_DISABLE_EMULATOR_ID,
/* de */  IDCLS_DISABLE_EMULATOR_ID_DA,
/* de */  IDCLS_DISABLE_EMULATOR_ID_DE,
/* fr */  IDCLS_DISABLE_EMULATOR_ID_FR,
/* hu */  IDCLS_DISABLE_EMULATOR_ID_HU,
/* it */  IDCLS_DISABLE_EMULATOR_ID_IT,
/* nl */  IDCLS_DISABLE_EMULATOR_ID_NL,
/* pl */  IDCLS_DISABLE_EMULATOR_ID_PL,
/* sv */  IDCLS_DISABLE_EMULATOR_ID_SV,
/* tr */  IDCLS_DISABLE_EMULATOR_ID_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_ENABLE_OEM_JOY,
/* de */  IDCLS_ENABLE_OEM_JOY_DA,
/* de */  IDCLS_ENABLE_OEM_JOY_DE,
/* fr */  IDCLS_ENABLE_OEM_JOY_FR,
/* hu */  IDCLS_ENABLE_OEM_JOY_HU,
/* it */  IDCLS_ENABLE_OEM_JOY_IT,
/* nl */  IDCLS_ENABLE_OEM_JOY_NL,
/* pl */  IDCLS_ENABLE_OEM_JOY_PL,
/* sv */  IDCLS_ENABLE_OEM_JOY_SV,
/* tr */  IDCLS_ENABLE_OEM_JOY_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_DISABLE_OEM_JOY,
/* de */  IDCLS_DISABLE_OEM_JOY_DA,
/* de */  IDCLS_DISABLE_OEM_JOY_DE,
/* fr */  IDCLS_DISABLE_OEM_JOY_FR,
/* hu */  IDCLS_DISABLE_OEM_JOY_HU,
/* it */  IDCLS_DISABLE_OEM_JOY_IT,
/* nl */  IDCLS_DISABLE_OEM_JOY_NL,
/* pl */  IDCLS_DISABLE_OEM_JOY_PL,
/* sv */  IDCLS_DISABLE_OEM_JOY_SV,
/* tr */  IDCLS_DISABLE_OEM_JOY_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_ENABLE_IEE488,
/* de */  IDCLS_ENABLE_IEE488_DA,
/* de */  IDCLS_ENABLE_IEE488_DE,
/* fr */  IDCLS_ENABLE_IEE488_FR,
/* hu */  IDCLS_ENABLE_IEE488_HU,
/* it */  IDCLS_ENABLE_IEE488_IT,
/* nl */  IDCLS_ENABLE_IEE488_NL,
/* pl */  IDCLS_ENABLE_IEE488_PL,
/* sv */  IDCLS_ENABLE_IEE488_SV,
/* tr */  IDCLS_ENABLE_IEE488_TR},

/* c128/c128-cmdline-options.c */
/* en */ {IDCLS_DISABLE_IEE488,
/* de */  IDCLS_DISABLE_IEE488_DA,
/* de */  IDCLS_DISABLE_IEE488_DE,
/* fr */  IDCLS_DISABLE_IEE488_FR,
/* hu */  IDCLS_DISABLE_IEE488_HU,
/* it */  IDCLS_DISABLE_IEE488_IT,
/* nl */  IDCLS_DISABLE_IEE488_NL,
/* pl */  IDCLS_DISABLE_IEE488_PL,
/* sv */  IDCLS_DISABLE_IEE488_SV,
/* tr */  IDCLS_DISABLE_IEE488_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_P_REVISION,
/* de */  IDCLS_P_REVISION_DA,
/* de */  IDCLS_P_REVISION_DE,
/* fr */  IDCLS_P_REVISION_FR,
/* hu */  IDCLS_P_REVISION_HU,
/* it */  IDCLS_P_REVISION_IT,
/* nl */  IDCLS_P_REVISION_NL,
/* pl */  IDCLS_P_REVISION_PL,
/* sv */  IDCLS_P_REVISION_SV,
/* tr */  IDCLS_P_REVISION_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_PATCH_KERNAL_TO_REVISION,
/* de */  IDCLS_PATCH_KERNAL_TO_REVISION_DA,
/* de */  IDCLS_PATCH_KERNAL_TO_REVISION_DE,
/* fr */  IDCLS_PATCH_KERNAL_TO_REVISION_FR,
/* hu */  IDCLS_PATCH_KERNAL_TO_REVISION_HU,
/* it */  IDCLS_PATCH_KERNAL_TO_REVISION_IT,
/* nl */  IDCLS_PATCH_KERNAL_TO_REVISION_NL,
/* pl */  IDCLS_PATCH_KERNAL_TO_REVISION_PL,
/* sv */  IDCLS_PATCH_KERNAL_TO_REVISION_SV,
/* tr */  IDCLS_PATCH_KERNAL_TO_REVISION_TR},

#ifdef HAVE_RS232
/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DEXX_ACIA_RS232_EMU,
/* de */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DA,
/* de */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DE,
/* fr */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_FR,
/* hu */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_HU,
/* it */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_IT,
/* nl */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_NL,
/* pl */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_PL,
/* sv */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_SV,
/* tr */  IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DEXX_ACIA_RS232_EMU,
/* de */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DA,
/* de */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DE,
/* fr */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_FR,
/* hu */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_HU,
/* it */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_IT,
/* nl */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_NL,
/* pl */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_PL,
/* sv */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_SV,
/* tr */  IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_TR},
#endif   /* HAVE_RS232 */

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vdc/vdc-cmdline-options.c, vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_P_NUMBER,
/* de */  IDCLS_P_NUMBER_DA,
/* de */  IDCLS_P_NUMBER_DE,
/* fr */  IDCLS_P_NUMBER_FR,
/* hu */  IDCLS_P_NUMBER_HU,
/* it */  IDCLS_P_NUMBER_IT,
/* nl */  IDCLS_P_NUMBER_NL,
/* pl */  IDCLS_P_NUMBER_PL,
/* sv */  IDCLS_P_NUMBER_SV,
/* tr */  IDCLS_P_NUMBER_TR},

#ifdef COMMON_KBD
/* c128/c128-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_KEYMAP_FILE_INDEX,
/* de */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DA,
/* de */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DE,
/* fr */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_FR,
/* hu */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_HU,
/* it */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_IT,
/* nl */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_NL,
/* pl */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_PL,
/* sv */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_SV,
/* tr */  IDCLS_SPECIFY_KEYMAP_FILE_INDEX_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME,
/* de */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DA,
/* de */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DE,
/* fr */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_FR,
/* hu */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_HU,
/* it */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_IT,
/* nl */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_NL,
/* pl */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_PL,
/* sv */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_SV,
/* tr */  IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_TR},

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME,
/* de */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DA,
/* de */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DE,
/* fr */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_FR,
/* hu */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_HU,
/* it */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_IT,
/* nl */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_NL,
/* pl */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_PL,
/* sv */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_SV,
/* tr */  IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_TR},
#endif  /* COMMON_KBD */

/* c128/c128mmu.c */
/* en */ {IDCLS_ACTIVATE_40_COL_MODE,
/* de */  IDCLS_ACTIVATE_40_COL_MODE_DA,
/* de */  IDCLS_ACTIVATE_40_COL_MODE_DE,
/* fr */  IDCLS_ACTIVATE_40_COL_MODE_FR,
/* hu */  IDCLS_ACTIVATE_40_COL_MODE_HU,
/* it */  IDCLS_ACTIVATE_40_COL_MODE_IT,
/* nl */  IDCLS_ACTIVATE_40_COL_MODE_NL,
/* pl */  IDCLS_ACTIVATE_40_COL_MODE_PL,
/* sv */  IDCLS_ACTIVATE_40_COL_MODE_SV,
/* tr */  IDCLS_ACTIVATE_40_COL_MODE_TR},

/* c128/c128mmu.c */
/* en */ {IDCLS_ACTIVATE_80_COL_MODE,
/* de */  IDCLS_ACTIVATE_80_COL_MODE_DA,
/* de */  IDCLS_ACTIVATE_80_COL_MODE_DE,
/* fr */  IDCLS_ACTIVATE_80_COL_MODE_FR,
/* hu */  IDCLS_ACTIVATE_80_COL_MODE_HU,
/* it */  IDCLS_ACTIVATE_80_COL_MODE_IT,
/* nl */  IDCLS_ACTIVATE_80_COL_MODE_NL,
/* pl */  IDCLS_ACTIVATE_80_COL_MODE_PL,
/* sv */  IDCLS_ACTIVATE_80_COL_MODE_SV,
/* tr */  IDCLS_ACTIVATE_80_COL_MODE_TR},

/* c128/c128mmu.c */
/* en */ {IDCLS_GO64_MODE,
/* de */  IDCLS_GO64_MODE_DA,
/* de */  IDCLS_GO64_MODE_DE,
/* fr */  IDCLS_GO64_MODE_FR,
/* hu */  IDCLS_GO64_MODE_HU,
/* it */  IDCLS_GO64_MODE_IT,
/* nl */  IDCLS_GO64_MODE_NL,
/* pl */  IDCLS_GO64_MODE_PL,
/* sv */  IDCLS_GO64_MODE_SV,
/* tr */  IDCLS_GO64_MODE_TR},

/* c128/c128mmu.c */
/* en */ {IDCLS_GO128_MODE,
/* de */  IDCLS_GO128_MODE_DA,
/* de */  IDCLS_GO128_MODE_DE,
/* fr */  IDCLS_GO128_MODE_FR,
/* hu */  IDCLS_GO128_MODE_HU,
/* it */  IDCLS_GO128_MODE_IT,
/* nl */  IDCLS_GO128_MODE_NL,
/* pl */  IDCLS_GO128_MODE_PL,
/* sv */  IDCLS_GO128_MODE_SV,
/* tr */  IDCLS_GO128_MODE_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_SPECIFY_INT_FUNC_ROM_NAME,
/* de */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_INT_FUNC_ROM_NAME_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_SPECIFY_EXT_FUNC_ROM_NAME,
/* de */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_INT_FUNC_ROM,
/* de */  IDCLS_ENABLE_INT_FUNC_ROM_DA,
/* de */  IDCLS_ENABLE_INT_FUNC_ROM_DE,
/* fr */  IDCLS_ENABLE_INT_FUNC_ROM_FR,
/* hu */  IDCLS_ENABLE_INT_FUNC_ROM_HU,
/* it */  IDCLS_ENABLE_INT_FUNC_ROM_IT,
/* nl */  IDCLS_ENABLE_INT_FUNC_ROM_NL,
/* pl */  IDCLS_ENABLE_INT_FUNC_ROM_PL,
/* sv */  IDCLS_ENABLE_INT_FUNC_ROM_SV,
/* tr */  IDCLS_ENABLE_INT_FUNC_ROM_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_DISABLE_INT_FUNC_ROM,
/* de */  IDCLS_DISABLE_INT_FUNC_ROM_DA,
/* de */  IDCLS_DISABLE_INT_FUNC_ROM_DE,
/* fr */  IDCLS_DISABLE_INT_FUNC_ROM_FR,
/* hu */  IDCLS_DISABLE_INT_FUNC_ROM_HU,
/* it */  IDCLS_DISABLE_INT_FUNC_ROM_IT,
/* nl */  IDCLS_DISABLE_INT_FUNC_ROM_NL,
/* pl */  IDCLS_DISABLE_INT_FUNC_ROM_PL,
/* sv */  IDCLS_DISABLE_INT_FUNC_ROM_SV,
/* tr */  IDCLS_DISABLE_INT_FUNC_ROM_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_ENABLE_EXT_FUNC_ROM,
/* de */  IDCLS_ENABLE_EXT_FUNC_ROM_DA,
/* de */  IDCLS_ENABLE_EXT_FUNC_ROM_DE,
/* fr */  IDCLS_ENABLE_EXT_FUNC_ROM_FR,
/* hu */  IDCLS_ENABLE_EXT_FUNC_ROM_HU,
/* it */  IDCLS_ENABLE_EXT_FUNC_ROM_IT,
/* nl */  IDCLS_ENABLE_EXT_FUNC_ROM_NL,
/* pl */  IDCLS_ENABLE_EXT_FUNC_ROM_PL,
/* sv */  IDCLS_ENABLE_EXT_FUNC_ROM_SV,
/* tr */  IDCLS_ENABLE_EXT_FUNC_ROM_TR},

/* c128/functionrom.c */
/* en */ {IDCLS_DISABLE_EXT_FUNC_ROM,
/* de */  IDCLS_DISABLE_EXT_FUNC_ROM_DA,
/* de */  IDCLS_DISABLE_EXT_FUNC_ROM_DE,
/* fr */  IDCLS_DISABLE_EXT_FUNC_ROM_FR,
/* hu */  IDCLS_DISABLE_EXT_FUNC_ROM_HU,
/* it */  IDCLS_DISABLE_EXT_FUNC_ROM_IT,
/* nl */  IDCLS_DISABLE_EXT_FUNC_ROM_NL,
/* pl */  IDCLS_DISABLE_EXT_FUNC_ROM_PL,
/* sv */  IDCLS_DISABLE_EXT_FUNC_ROM_SV,
/* tr */  IDCLS_DISABLE_EXT_FUNC_ROM_TR},

/* c64/c64-cmdline-options.c, c64/psid.c */
/* en */ {IDCLS_USE_OLD_NTSC_SYNC_FACTOR,
/* de */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DA,
/* de */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DE,
/* fr */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_FR,
/* hu */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_HU,
/* it */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_IT,
/* nl */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_NL,
/* pl */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_PL,
/* sv */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_SV,
/* tr */  IDCLS_USE_OLD_NTSC_SYNC_FACTOR_TR},

/* c64/c64-cmdline-options.c, viciisc/vicii-cmdline-options.c */
/* en */ {IDCLS_P_MODEL,
/* de */  IDCLS_P_MODEL_DA,
/* de */  IDCLS_P_MODEL_DE,
/* fr */  IDCLS_P_MODEL_FR,
/* hu */  IDCLS_P_MODEL_HU,
/* it */  IDCLS_P_MODEL_IT,
/* nl */  IDCLS_P_MODEL_NL,
/* pl */  IDCLS_P_MODEL_PL,
/* sv */  IDCLS_P_MODEL_SV,
/* tr */  IDCLS_P_MODEL_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SET_BOTH_CIA_MODELS,
/* de */  IDCLS_SET_BOTH_CIA_MODELS_DA,
/* de */  IDCLS_SET_BOTH_CIA_MODELS_DE,
/* fr */  IDCLS_SET_BOTH_CIA_MODELS_FR,
/* hu */  IDCLS_SET_BOTH_CIA_MODELS_HU,
/* it */  IDCLS_SET_BOTH_CIA_MODELS_IT,
/* nl */  IDCLS_SET_BOTH_CIA_MODELS_NL,
/* pl */  IDCLS_SET_BOTH_CIA_MODELS_PL,
/* sv */  IDCLS_SET_BOTH_CIA_MODELS_SV,
/* tr */  IDCLS_SET_BOTH_CIA_MODELS_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SET_CIA1_MODEL,
/* de */  IDCLS_SET_CIA1_MODEL_DA,
/* de */  IDCLS_SET_CIA1_MODEL_DE,
/* fr */  IDCLS_SET_CIA1_MODEL_FR,
/* hu */  IDCLS_SET_CIA1_MODEL_HU,
/* it */  IDCLS_SET_CIA1_MODEL_IT,
/* nl */  IDCLS_SET_CIA1_MODEL_NL,
/* pl */  IDCLS_SET_CIA1_MODEL_PL,
/* sv */  IDCLS_SET_CIA1_MODEL_SV,
/* tr */  IDCLS_SET_CIA1_MODEL_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SET_CIA2_MODEL,
/* de */  IDCLS_SET_CIA2_MODEL_DA,
/* de */  IDCLS_SET_CIA2_MODEL_DE,
/* fr */  IDCLS_SET_CIA2_MODEL_FR,
/* hu */  IDCLS_SET_CIA2_MODEL_HU,
/* it */  IDCLS_SET_CIA2_MODEL_IT,
/* nl */  IDCLS_SET_CIA2_MODEL_NL,
/* pl */  IDCLS_SET_CIA2_MODEL_PL,
/* sv */  IDCLS_SET_CIA2_MODEL_SV,
/* tr */  IDCLS_SET_CIA2_MODEL_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SET_C64_MODEL,
/* de */  IDCLS_SET_C64_MODEL_DA,
/* de */  IDCLS_SET_C64_MODEL_DE,
/* fr */  IDCLS_SET_C64_MODEL_FR,
/* hu */  IDCLS_SET_C64_MODEL_HU,
/* it */  IDCLS_SET_C64_MODEL_IT,
/* nl */  IDCLS_SET_C64_MODEL_NL,
/* pl */  IDCLS_SET_C64_MODEL_PL,
/* sv */  IDCLS_SET_C64_MODEL_SV,
/* tr */  IDCLS_SET_C64_MODEL_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_USE_PALN_SYNC_FACTOR,
/* de */  IDCLS_USE_PALN_SYNC_FACTOR_DA,
/* de */  IDCLS_USE_PALN_SYNC_FACTOR_DE,
/* fr */  IDCLS_USE_PALN_SYNC_FACTOR_FR,
/* hu */  IDCLS_USE_PALN_SYNC_FACTOR_HU,
/* it */  IDCLS_USE_PALN_SYNC_FACTOR_IT,
/* nl */  IDCLS_USE_PALN_SYNC_FACTOR_NL,
/* pl */  IDCLS_USE_PALN_SYNC_FACTOR_PL,
/* sv */  IDCLS_USE_PALN_SYNC_FACTOR_SV,
/* tr */  IDCLS_USE_PALN_SYNC_FACTOR_TR},

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_KERNAL_ROM_NAME,
/* de */  IDCLS_SPECIFY_KERNAL_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_KERNAL_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_KERNAL_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_KERNAL_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_KERNAL_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_KERNAL_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_KERNAL_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_KERNAL_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_KERNAL_ROM_NAME_TR},

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BASIC_ROM_NAME,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_BASIC_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_BASIC_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_BASIC_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_BASIC_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_BASIC_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_BASIC_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_BASIC_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_BASIC_ROM_NAME_TR},

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CHARGEN_ROM_NAME,
/* de */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_CHARGEN_ROM_NAME_TR},

#ifdef COMMON_KBD
/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2,
/* de */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DA,
/* de */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DE,
/* fr */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_FR,
/* hu */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_HU,
/* it */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_IT,
/* nl */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_NL,
/* pl */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_PL,
/* sv */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_SV,
/* tr */  IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_TR},

/* c64/c64-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP,
/* de */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DA,
/* de */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DE,
/* fr */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_FR,
/* hu */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_HU,
/* it */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_IT,
/* nl */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_NL,
/* pl */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_PL,
/* sv */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_SV,
/* tr */  IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_TR},
#endif   /* COMMON_KBD */

/* c64/c64gluelogic.c */
/* en */ {IDCLS_SET_GLUE_LOGIC_TYPE,
/* de */  IDCLS_SET_GLUE_LOGIC_TYPE_DA,
/* de */  IDCLS_SET_GLUE_LOGIC_TYPE_DE,
/* fr */  IDCLS_SET_GLUE_LOGIC_TYPE_FR,
/* hu */  IDCLS_SET_GLUE_LOGIC_TYPE_HU,
/* it */  IDCLS_SET_GLUE_LOGIC_TYPE_IT,
/* nl */  IDCLS_SET_GLUE_LOGIC_TYPE_NL,
/* pl */  IDCLS_SET_GLUE_LOGIC_TYPE_PL,
/* sv */  IDCLS_SET_GLUE_LOGIC_TYPE_SV,
/* tr */  IDCLS_SET_GLUE_LOGIC_TYPE_TR},

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_ENABLE_HUMMER_ADC,
/* de */  IDCLS_ENABLE_HUMMER_ADC_DA,
/* de */  IDCLS_ENABLE_HUMMER_ADC_DE,
/* fr */  IDCLS_ENABLE_HUMMER_ADC_FR,
/* hu */  IDCLS_ENABLE_HUMMER_ADC_HU,
/* it */  IDCLS_ENABLE_HUMMER_ADC_IT,
/* nl */  IDCLS_ENABLE_HUMMER_ADC_NL,
/* pl */  IDCLS_ENABLE_HUMMER_ADC_PL,
/* sv */  IDCLS_ENABLE_HUMMER_ADC_SV,
/* tr */  IDCLS_ENABLE_HUMMER_ADC_TR},

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_DISABLE_HUMMER_ADC,
/* de */  IDCLS_DISABLE_HUMMER_ADC_DA,
/* de */  IDCLS_DISABLE_HUMMER_ADC_DE,
/* fr */  IDCLS_DISABLE_HUMMER_ADC_FR,
/* hu */  IDCLS_DISABLE_HUMMER_ADC_HU,
/* it */  IDCLS_DISABLE_HUMMER_ADC_IT,
/* nl */  IDCLS_DISABLE_HUMMER_ADC_NL,
/* pl */  IDCLS_DISABLE_HUMMER_ADC_PL,
/* sv */  IDCLS_DISABLE_HUMMER_ADC_SV,
/* tr */  IDCLS_DISABLE_HUMMER_ADC_TR},

/* c64/cart/georam.c */
/* en */ {IDCLS_ENABLE_GEORAM,
/* de */  IDCLS_ENABLE_GEORAM_DA,
/* de */  IDCLS_ENABLE_GEORAM_DE,
/* fr */  IDCLS_ENABLE_GEORAM_FR,
/* hu */  IDCLS_ENABLE_GEORAM_HU,
/* it */  IDCLS_ENABLE_GEORAM_IT,
/* nl */  IDCLS_ENABLE_GEORAM_NL,
/* pl */  IDCLS_ENABLE_GEORAM_PL,
/* sv */  IDCLS_ENABLE_GEORAM_SV,
/* tr */  IDCLS_ENABLE_GEORAM_TR},

/* c64/cart/georam.c */
/* en */ {IDCLS_DISABLE_GEORAM,
/* de */  IDCLS_DISABLE_GEORAM_DA,
/* de */  IDCLS_DISABLE_GEORAM_DE,
/* fr */  IDCLS_DISABLE_GEORAM_FR,
/* hu */  IDCLS_DISABLE_GEORAM_HU,
/* it */  IDCLS_DISABLE_GEORAM_IT,
/* nl */  IDCLS_DISABLE_GEORAM_NL,
/* pl */  IDCLS_DISABLE_GEORAM_PL,
/* sv */  IDCLS_DISABLE_GEORAM_SV,
/* tr */  IDCLS_DISABLE_GEORAM_TR},

/* c64/cart/georam.c */
/* en */ {IDCLS_SPECIFY_GEORAM_NAME,
/* de */  IDCLS_SPECIFY_GEORAM_NAME_DA,
/* de */  IDCLS_SPECIFY_GEORAM_NAME_DE,
/* fr */  IDCLS_SPECIFY_GEORAM_NAME_FR,
/* hu */  IDCLS_SPECIFY_GEORAM_NAME_HU,
/* it */  IDCLS_SPECIFY_GEORAM_NAME_IT,
/* nl */  IDCLS_SPECIFY_GEORAM_NAME_NL,
/* pl */  IDCLS_SPECIFY_GEORAM_NAME_PL,
/* sv */  IDCLS_SPECIFY_GEORAM_NAME_SV,
/* tr */  IDCLS_SPECIFY_GEORAM_NAME_TR},

/* c64/cart/georam.c */
/* en */ {IDCLS_P_SIZE_IN_KB,
/* de */  IDCLS_P_SIZE_IN_KB_DA,
/* de */  IDCLS_P_SIZE_IN_KB_DE,
/* fr */  IDCLS_P_SIZE_IN_KB_FR,
/* hu */  IDCLS_P_SIZE_IN_KB_HU,
/* it */  IDCLS_P_SIZE_IN_KB_IT,
/* nl */  IDCLS_P_SIZE_IN_KB_NL,
/* pl */  IDCLS_P_SIZE_IN_KB_PL,
/* sv */  IDCLS_P_SIZE_IN_KB_SV,
/* tr */  IDCLS_P_SIZE_IN_KB_TR},

/* c64/cart/georam.c */
/* en */ {IDCLS_GEORAM_SIZE,
/* de */  IDCLS_GEORAM_SIZE_DA,
/* de */  IDCLS_GEORAM_SIZE_DE,
/* fr */  IDCLS_GEORAM_SIZE_FR,
/* hu */  IDCLS_GEORAM_SIZE_HU,
/* it */  IDCLS_GEORAM_SIZE_IT,
/* nl */  IDCLS_GEORAM_SIZE_NL,
/* pl */  IDCLS_GEORAM_SIZE_PL,
/* sv */  IDCLS_GEORAM_SIZE_SV,
/* tr */  IDCLS_GEORAM_SIZE_TR},

/* c64/psid.c */
/* en */ {IDCLS_SID_PLAYER_MODE,
/* de */  IDCLS_SID_PLAYER_MODE_DA,
/* de */  IDCLS_SID_PLAYER_MODE_DE,
/* fr */  IDCLS_SID_PLAYER_MODE_FR,
/* hu */  IDCLS_SID_PLAYER_MODE_HU,
/* it */  IDCLS_SID_PLAYER_MODE_IT,
/* nl */  IDCLS_SID_PLAYER_MODE_NL,
/* pl */  IDCLS_SID_PLAYER_MODE_PL,
/* sv */  IDCLS_SID_PLAYER_MODE_SV,
/* tr */  IDCLS_SID_PLAYER_MODE_TR},

/* c64/psid.c */
/* en */ {IDCLS_OVERWRITE_PSID_SETTINGS,
/* de */  IDCLS_OVERWRITE_PSID_SETTINGS_DA,
/* de */  IDCLS_OVERWRITE_PSID_SETTINGS_DE,
/* fr */  IDCLS_OVERWRITE_PSID_SETTINGS_FR,
/* hu */  IDCLS_OVERWRITE_PSID_SETTINGS_HU,
/* it */  IDCLS_OVERWRITE_PSID_SETTINGS_IT,
/* nl */  IDCLS_OVERWRITE_PSID_SETTINGS_NL,
/* pl */  IDCLS_OVERWRITE_PSID_SETTINGS_PL,
/* sv */  IDCLS_OVERWRITE_PSID_SETTINGS_SV,
/* tr */  IDCLS_OVERWRITE_PSID_SETTINGS_TR},

/* c64/psid.c */
/* en */ {IDCLS_SPECIFY_PSID_TUNE_NUMBER,
/* de */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_DA,
/* de */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_DE,
/* fr */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_FR,
/* hu */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_HU,
/* it */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_IT,
/* nl */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_NL,
/* pl */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_PL,
/* sv */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_SV,
/* tr */  IDCLS_SPECIFY_PSID_TUNE_NUMBER_TR},

/* c64/cart/ramcart.c */
/* en */ {IDCLS_ENABLE_RAMCART,
/* de */  IDCLS_ENABLE_RAMCART_DA,
/* de */  IDCLS_ENABLE_RAMCART_DE,
/* fr */  IDCLS_ENABLE_RAMCART_FR,
/* hu */  IDCLS_ENABLE_RAMCART_HU,
/* it */  IDCLS_ENABLE_RAMCART_IT,
/* nl */  IDCLS_ENABLE_RAMCART_NL,
/* pl */  IDCLS_ENABLE_RAMCART_PL,
/* sv */  IDCLS_ENABLE_RAMCART_SV,
/* tr */  IDCLS_ENABLE_RAMCART_TR},

/* c64/cart/ramcart.c */
/* en */ {IDCLS_DISABLE_RAMCART,
/* de */  IDCLS_DISABLE_RAMCART_DA,
/* de */  IDCLS_DISABLE_RAMCART_DE,
/* fr */  IDCLS_DISABLE_RAMCART_FR,
/* hu */  IDCLS_DISABLE_RAMCART_HU,
/* it */  IDCLS_DISABLE_RAMCART_IT,
/* nl */  IDCLS_DISABLE_RAMCART_NL,
/* pl */  IDCLS_DISABLE_RAMCART_PL,
/* sv */  IDCLS_DISABLE_RAMCART_SV,
/* tr */  IDCLS_DISABLE_RAMCART_TR},

/* c64/cart/ramcart.c */
/* en */ {IDCLS_SPECIFY_RAMCART_NAME,
/* de */  IDCLS_SPECIFY_RAMCART_NAME_DA,
/* de */  IDCLS_SPECIFY_RAMCART_NAME_DE,
/* fr */  IDCLS_SPECIFY_RAMCART_NAME_FR,
/* hu */  IDCLS_SPECIFY_RAMCART_NAME_HU,
/* it */  IDCLS_SPECIFY_RAMCART_NAME_IT,
/* nl */  IDCLS_SPECIFY_RAMCART_NAME_NL,
/* pl */  IDCLS_SPECIFY_RAMCART_NAME_PL,
/* sv */  IDCLS_SPECIFY_RAMCART_NAME_SV,
/* tr */  IDCLS_SPECIFY_RAMCART_NAME_TR},

/* c64/cart/ramcart.c */
/* en */ {IDCLS_RAMCART_SIZE,
/* de */  IDCLS_RAMCART_SIZE_DA,
/* de */  IDCLS_RAMCART_SIZE_DE,
/* fr */  IDCLS_RAMCART_SIZE_FR,
/* hu */  IDCLS_RAMCART_SIZE_HU,
/* it */  IDCLS_RAMCART_SIZE_IT,
/* nl */  IDCLS_RAMCART_SIZE_NL,
/* pl */  IDCLS_RAMCART_SIZE_PL,
/* sv */  IDCLS_RAMCART_SIZE_SV,
/* tr */  IDCLS_RAMCART_SIZE_TR},

/* c64/cart/dqbb.c */
/* en */ {IDCLS_ENABLE_DQBB,
/* de */  IDCLS_ENABLE_DQBB_DA,
/* de */  IDCLS_ENABLE_DQBB_DE,
/* fr */  IDCLS_ENABLE_DQBB_FR,
/* hu */  IDCLS_ENABLE_DQBB_HU,
/* it */  IDCLS_ENABLE_DQBB_IT,
/* nl */  IDCLS_ENABLE_DQBB_NL,
/* pl */  IDCLS_ENABLE_DQBB_PL,
/* sv */  IDCLS_ENABLE_DQBB_SV,
/* tr */  IDCLS_ENABLE_DQBB_TR},

/* c64/cart/dqbb.c */
/* en */ {IDCLS_DISABLE_DQBB,
/* de */  IDCLS_DISABLE_DQBB_DA,
/* de */  IDCLS_DISABLE_DQBB_DE,
/* fr */  IDCLS_DISABLE_DQBB_FR,
/* hu */  IDCLS_DISABLE_DQBB_HU,
/* it */  IDCLS_DISABLE_DQBB_IT,
/* nl */  IDCLS_DISABLE_DQBB_NL,
/* pl */  IDCLS_DISABLE_DQBB_PL,
/* sv */  IDCLS_DISABLE_DQBB_SV,
/* tr */  IDCLS_DISABLE_DQBB_TR},

/* c64/cart/dqbb.c */
/* en */ {IDCLS_SPECIFY_DQBB_NAME,
/* de */  IDCLS_SPECIFY_DQBB_NAME_DA,
/* de */  IDCLS_SPECIFY_DQBB_NAME_DE,
/* fr */  IDCLS_SPECIFY_DQBB_NAME_FR,
/* hu */  IDCLS_SPECIFY_DQBB_NAME_HU,
/* it */  IDCLS_SPECIFY_DQBB_NAME_IT,
/* nl */  IDCLS_SPECIFY_DQBB_NAME_NL,
/* pl */  IDCLS_SPECIFY_DQBB_NAME_PL,
/* sv */  IDCLS_SPECIFY_DQBB_NAME_SV,
/* tr */  IDCLS_SPECIFY_DQBB_NAME_TR},

/* c64/cart/isepic.c */
/* en */ {IDCLS_ENABLE_ISEPIC,
/* de */  IDCLS_ENABLE_ISEPIC_DA,
/* de */  IDCLS_ENABLE_ISEPIC_DE,
/* fr */  IDCLS_ENABLE_ISEPIC_FR,
/* hu */  IDCLS_ENABLE_ISEPIC_HU,
/* it */  IDCLS_ENABLE_ISEPIC_IT,
/* nl */  IDCLS_ENABLE_ISEPIC_NL,
/* pl */  IDCLS_ENABLE_ISEPIC_PL,
/* sv */  IDCLS_ENABLE_ISEPIC_SV,
/* tr */  IDCLS_ENABLE_ISEPIC_TR},

/* c64/cart/isepic.c */
/* en */ {IDCLS_DISABLE_ISEPIC,
/* de */  IDCLS_DISABLE_ISEPIC_DA,
/* de */  IDCLS_DISABLE_ISEPIC_DE,
/* fr */  IDCLS_DISABLE_ISEPIC_FR,
/* hu */  IDCLS_DISABLE_ISEPIC_HU,
/* it */  IDCLS_DISABLE_ISEPIC_IT,
/* nl */  IDCLS_DISABLE_ISEPIC_NL,
/* pl */  IDCLS_DISABLE_ISEPIC_PL,
/* sv */  IDCLS_DISABLE_ISEPIC_SV,
/* tr */  IDCLS_DISABLE_ISEPIC_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_ENABLE_MMC64,
/* de */  IDCLS_ENABLE_MMC64_DA,
/* de */  IDCLS_ENABLE_MMC64_DE,
/* fr */  IDCLS_ENABLE_MMC64_FR,
/* hu */  IDCLS_ENABLE_MMC64_HU,
/* it */  IDCLS_ENABLE_MMC64_IT,
/* nl */  IDCLS_ENABLE_MMC64_NL,
/* pl */  IDCLS_ENABLE_MMC64_PL,
/* sv */  IDCLS_ENABLE_MMC64_SV,
/* tr */  IDCLS_ENABLE_MMC64_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_DISABLE_MMC64,
/* de */  IDCLS_DISABLE_MMC64_DA,
/* de */  IDCLS_DISABLE_MMC64_DE,
/* fr */  IDCLS_DISABLE_MMC64_FR,
/* hu */  IDCLS_DISABLE_MMC64_HU,
/* it */  IDCLS_DISABLE_MMC64_IT,
/* nl */  IDCLS_DISABLE_MMC64_NL,
/* pl */  IDCLS_DISABLE_MMC64_PL,
/* sv */  IDCLS_DISABLE_MMC64_SV,
/* tr */  IDCLS_DISABLE_MMC64_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_BIOS_NAME,
/* de */  IDCLS_SPECIFY_MMC64_BIOS_NAME_DA,
/* de */  IDCLS_SPECIFY_MMC64_BIOS_NAME_DE,
/* fr */  IDCLS_SPECIFY_MMC64_BIOS_NAME_FR,
/* hu */  IDCLS_SPECIFY_MMC64_BIOS_NAME_HU,
/* it */  IDCLS_SPECIFY_MMC64_BIOS_NAME_IT,
/* nl */  IDCLS_SPECIFY_MMC64_BIOS_NAME_NL,
/* pl */  IDCLS_SPECIFY_MMC64_BIOS_NAME_PL,
/* sv */  IDCLS_SPECIFY_MMC64_BIOS_NAME_SV,
/* tr */  IDCLS_SPECIFY_MMC64_BIOS_NAME_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_SPECIFY_MMC64_IMAGE_NAME,
/* de */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_DA,
/* de */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_DE,
/* fr */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_FR,
/* hu */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_HU,
/* it */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_IT,
/* nl */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_NL,
/* pl */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_PL,
/* sv */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_SV,
/* tr */  IDCLS_SPECIFY_MMC64_IMAGE_NAME_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_READONLY,
/* de */  IDCLS_MMC64_READONLY_DA,
/* de */  IDCLS_MMC64_READONLY_DE,
/* fr */  IDCLS_MMC64_READONLY_FR,
/* hu */  IDCLS_MMC64_READONLY_HU,
/* it */  IDCLS_MMC64_READONLY_IT,
/* nl */  IDCLS_MMC64_READONLY_NL,
/* pl */  IDCLS_MMC64_READONLY_PL,
/* sv */  IDCLS_MMC64_READONLY_SV,
/* tr */  IDCLS_MMC64_READONLY_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_READWRITE,
/* de */  IDCLS_MMC64_READWRITE_DA,
/* de */  IDCLS_MMC64_READWRITE_DE,
/* fr */  IDCLS_MMC64_READWRITE_FR,
/* hu */  IDCLS_MMC64_READWRITE_HU,
/* it */  IDCLS_MMC64_READWRITE_IT,
/* nl */  IDCLS_MMC64_READWRITE_NL,
/* pl */  IDCLS_MMC64_READWRITE_PL,
/* sv */  IDCLS_MMC64_READWRITE_SV,
/* tr */  IDCLS_MMC64_READWRITE_TR},

/* c64/cart/mmc64.c */
/* en */ {IDCLS_MMC64_BIOS_WRITE,
/* de */  IDCLS_MMC64_BIOS_WRITE_DA,
/* de */  IDCLS_MMC64_BIOS_WRITE_DE,
/* fr */  IDCLS_MMC64_BIOS_WRITE_FR,
/* hu */  IDCLS_MMC64_BIOS_WRITE_HU,
/* it */  IDCLS_MMC64_BIOS_WRITE_IT,
/* nl */  IDCLS_MMC64_BIOS_WRITE_NL,
/* pl */  IDCLS_MMC64_BIOS_WRITE_PL,
/* sv */  IDCLS_MMC64_BIOS_WRITE_SV,
/* tr */  IDCLS_MMC64_BIOS_WRITE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME,
/* de */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DA,
/* de */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DE,
/* fr */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_FR,
/* hu */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_HU,
/* it */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_IT,
/* nl */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_NL,
/* pl */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_PL,
/* sv */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_SV,
/* tr */  IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE,
/* de */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DA,
/* de */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_HU,
/* it */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE,
/* de */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DA,
/* de */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_HU,
/* it */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE,
/* de */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DA,
/* de */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DE,
/* fr */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_FR,
/* hu */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_HU,
/* it */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_IT,
/* nl */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_NL,
/* pl */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_PL,
/* sv */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_SV,
/* tr */  IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE,
/* de */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DA,
/* de */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_HU,
/* it */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE,
/* de */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DA,
/* de */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_HU,
/* it */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE,
/* de */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DA,
/* de */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_HU,
/* it */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_TR},

/* c64/cart/mmcreplay.c */
/* en */ {IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE,
/* de */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DA,
/* de */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DE,
/* fr */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_FR,
/* hu */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_HU,
/* it */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_IT,
/* nl */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_NL,
/* pl */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_PL,
/* sv */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_SV,
/* tr */  IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT,
/* de */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DA,
/* de */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DE,
/* fr */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_FR,
/* hu */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_HU,
/* it */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_IT,
/* nl */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_NL,
/* pl */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_PL,
/* sv */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_SV,
/* tr */  IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT,
/* de */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DA,
/* de */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DE,
/* fr */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_FR,
/* hu */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_HU,
/* it */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_IT,
/* nl */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_NL,
/* pl */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_PL,
/* sv */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_SV,
/* tr */  IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_SET_RR_BANK_JUMPER,
/* de */  IDCLS_SET_RR_BANK_JUMPER_DA,
/* de */  IDCLS_SET_RR_BANK_JUMPER_DE,
/* fr */  IDCLS_SET_RR_BANK_JUMPER_FR,
/* hu */  IDCLS_SET_RR_BANK_JUMPER_HU,
/* it */  IDCLS_SET_RR_BANK_JUMPER_IT,
/* nl */  IDCLS_SET_RR_BANK_JUMPER_NL,
/* pl */  IDCLS_SET_RR_BANK_JUMPER_PL,
/* sv */  IDCLS_SET_RR_BANK_JUMPER_SV,
/* tr */  IDCLS_SET_RR_BANK_JUMPER_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_UNSET_RR_BANK_JUMPER,
/* de */  IDCLS_UNSET_RR_BANK_JUMPER_DA,
/* de */  IDCLS_UNSET_RR_BANK_JUMPER_DE,
/* fr */  IDCLS_UNSET_RR_BANK_JUMPER_FR,
/* hu */  IDCLS_UNSET_RR_BANK_JUMPER_HU,
/* it */  IDCLS_UNSET_RR_BANK_JUMPER_IT,
/* nl */  IDCLS_UNSET_RR_BANK_JUMPER_NL,
/* pl */  IDCLS_UNSET_RR_BANK_JUMPER_PL,
/* sv */  IDCLS_UNSET_RR_BANK_JUMPER_SV,
/* tr */  IDCLS_UNSET_RR_BANK_JUMPER_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_SET_RR_FLASH_JUMPER,
/* de */  IDCLS_SET_RR_FLASH_JUMPER_DA,
/* de */  IDCLS_SET_RR_FLASH_JUMPER_DE,
/* fr */  IDCLS_SET_RR_FLASH_JUMPER_FR,
/* hu */  IDCLS_SET_RR_FLASH_JUMPER_HU,
/* it */  IDCLS_SET_RR_FLASH_JUMPER_IT,
/* nl */  IDCLS_SET_RR_FLASH_JUMPER_NL,
/* pl */  IDCLS_SET_RR_FLASH_JUMPER_PL,
/* sv */  IDCLS_SET_RR_FLASH_JUMPER_SV,
/* tr */  IDCLS_SET_RR_FLASH_JUMPER_TR},

/* c64/cart/retroplay.c */
/* en */ {IDCLS_UNSET_RR_FLASH_JUMPER,
/* de */  IDCLS_UNSET_RR_FLASH_JUMPER_DA,
/* de */  IDCLS_UNSET_RR_FLASH_JUMPER_DE,
/* fr */  IDCLS_UNSET_RR_FLASH_JUMPER_FR,
/* hu */  IDCLS_UNSET_RR_FLASH_JUMPER_HU,
/* it */  IDCLS_UNSET_RR_FLASH_JUMPER_IT,
/* nl */  IDCLS_UNSET_RR_FLASH_JUMPER_NL,
/* pl */  IDCLS_UNSET_RR_FLASH_JUMPER_PL,
/* sv */  IDCLS_UNSET_RR_FLASH_JUMPER_SV,
/* tr */  IDCLS_UNSET_RR_FLASH_JUMPER_TR},

/* c64/cart/reu.c */
/* en */ {IDCLS_ENABLE_REU,
/* de */  IDCLS_ENABLE_REU_DA,
/* de */  IDCLS_ENABLE_REU_DE,
/* fr */  IDCLS_ENABLE_REU_FR,
/* hu */  IDCLS_ENABLE_REU_HU,
/* it */  IDCLS_ENABLE_REU_IT,
/* nl */  IDCLS_ENABLE_REU_NL,
/* pl */  IDCLS_ENABLE_REU_PL,
/* sv */  IDCLS_ENABLE_REU_SV,
/* tr */  IDCLS_ENABLE_REU_TR},

/* c64/cart/reu.c */
/* en */ {IDCLS_DISABLE_REU,
/* de */  IDCLS_DISABLE_REU_DA,
/* de */  IDCLS_DISABLE_REU_DE,
/* fr */  IDCLS_DISABLE_REU_FR,
/* hu */  IDCLS_DISABLE_REU_HU,
/* it */  IDCLS_DISABLE_REU_IT,
/* nl */  IDCLS_DISABLE_REU_NL,
/* pl */  IDCLS_DISABLE_REU_PL,
/* sv */  IDCLS_DISABLE_REU_SV,
/* tr */  IDCLS_DISABLE_REU_TR},

/* c64/cart/reu.c */
/* en */ {IDCLS_SPECIFY_REU_NAME,
/* de */  IDCLS_SPECIFY_REU_NAME_DA,
/* de */  IDCLS_SPECIFY_REU_NAME_DE,
/* fr */  IDCLS_SPECIFY_REU_NAME_FR,
/* hu */  IDCLS_SPECIFY_REU_NAME_HU,
/* it */  IDCLS_SPECIFY_REU_NAME_IT,
/* nl */  IDCLS_SPECIFY_REU_NAME_NL,
/* pl */  IDCLS_SPECIFY_REU_NAME_PL,
/* sv */  IDCLS_SPECIFY_REU_NAME_SV,
/* tr */  IDCLS_SPECIFY_REU_NAME_TR},

/* c64/cart/reu.c */
/* en */ {IDCLS_REU_SIZE,
/* de */  IDCLS_REU_SIZE_DA,
/* de */  IDCLS_REU_SIZE_DE,
/* fr */  IDCLS_REU_SIZE_FR,
/* hu */  IDCLS_REU_SIZE_HU,
/* it */  IDCLS_REU_SIZE_IT,
/* nl */  IDCLS_REU_SIZE_NL,
/* pl */  IDCLS_REU_SIZE_PL,
/* sv */  IDCLS_REU_SIZE_SV,
/* tr */  IDCLS_REU_SIZE_TR},

#ifdef HAVE_TFE
/* c64/cart/tfe.c */
/* en */ {IDCLS_ENABLE_TFE,
/* de */  IDCLS_ENABLE_TFE_DA,
/* de */  IDCLS_ENABLE_TFE_DE,
/* fr */  IDCLS_ENABLE_TFE_FR,
/* hu */  IDCLS_ENABLE_TFE_HU,
/* it */  IDCLS_ENABLE_TFE_IT,
/* nl */  IDCLS_ENABLE_TFE_NL,
/* pl */  IDCLS_ENABLE_TFE_PL,
/* sv */  IDCLS_ENABLE_TFE_SV,
/* tr */  IDCLS_ENABLE_TFE_TR},

/* c64/cart/tfe.c */
/* en */ {IDCLS_DISABLE_TFE,
/* de */  IDCLS_DISABLE_TFE_DA,
/* de */  IDCLS_DISABLE_TFE_DE,
/* fr */  IDCLS_DISABLE_TFE_FR,
/* hu */  IDCLS_DISABLE_TFE_HU,
/* it */  IDCLS_DISABLE_TFE_IT,
/* nl */  IDCLS_DISABLE_TFE_NL,
/* pl */  IDCLS_DISABLE_TFE_PL,
/* sv */  IDCLS_DISABLE_TFE_SV,
/* tr */  IDCLS_DISABLE_TFE_TR},

/* c64/cart/tfe.c */
/* en */ {IDCLS_TFE_INTERFACE,
/* de */  IDCLS_TFE_INTERFACE_DA,
/* de */  IDCLS_TFE_INTERFACE_DE,
/* fr */  IDCLS_TFE_INTERFACE_FR,
/* hu */  IDCLS_TFE_INTERFACE_HU,
/* it */  IDCLS_TFE_INTERFACE_IT,
/* nl */  IDCLS_TFE_INTERFACE_NL,
/* pl */  IDCLS_TFE_INTERFACE_PL,
/* sv */  IDCLS_TFE_INTERFACE_SV,
/* tr */  IDCLS_TFE_INTERFACE_TR},

/* c64/cart/tfe.c */
/* en */ {IDCLS_ENABLE_TFE_AS_RRNET,
/* de */  IDCLS_ENABLE_TFE_AS_RRNET_DA,
/* de */  IDCLS_ENABLE_TFE_AS_RRNET_DE,
/* fr */  IDCLS_ENABLE_TFE_AS_RRNET_FR,
/* hu */  IDCLS_ENABLE_TFE_AS_RRNET_HU,
/* it */  IDCLS_ENABLE_TFE_AS_RRNET_IT,
/* nl */  IDCLS_ENABLE_TFE_AS_RRNET_NL,
/* pl */  IDCLS_ENABLE_TFE_AS_RRNET_PL,
/* sv */  IDCLS_ENABLE_TFE_AS_RRNET_SV,
/* tr */  IDCLS_ENABLE_TFE_AS_RRNET_TR},

/* c64/cart/tfe.c */
/* en */ {IDCLS_DISABLE_TFE_AS_RRNET,
/* de */  IDCLS_DISABLE_TFE_AS_RRNET_DA,
/* de */  IDCLS_DISABLE_TFE_AS_RRNET_DE,
/* fr */  IDCLS_DISABLE_TFE_AS_RRNET_FR,
/* hu */  IDCLS_DISABLE_TFE_AS_RRNET_HU,
/* it */  IDCLS_DISABLE_TFE_AS_RRNET_IT,
/* nl */  IDCLS_DISABLE_TFE_AS_RRNET_NL,
/* pl */  IDCLS_DISABLE_TFE_AS_RRNET_PL,
/* sv */  IDCLS_DISABLE_TFE_AS_RRNET_SV,
/* tr */  IDCLS_DISABLE_TFE_AS_RRNET_TR},
#endif   /* HAVE_TFE */

/* c64/cart/c64cart.c */
/* en */ {IDCLS_CART_ATTACH_DETACH_RESET,
/* de */  IDCLS_CART_ATTACH_DETACH_RESET_DA,
/* de */  IDCLS_CART_ATTACH_DETACH_RESET_DE,
/* fr */  IDCLS_CART_ATTACH_DETACH_RESET_FR,
/* hu */  IDCLS_CART_ATTACH_DETACH_RESET_HU,
/* it */  IDCLS_CART_ATTACH_DETACH_RESET_IT,
/* nl */  IDCLS_CART_ATTACH_DETACH_RESET_NL,
/* pl */  IDCLS_CART_ATTACH_DETACH_RESET_PL,
/* sv */  IDCLS_CART_ATTACH_DETACH_RESET_SV,
/* tr */  IDCLS_CART_ATTACH_DETACH_RESET_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_CART_ATTACH_DETACH_NO_RESET,
/* de */  IDCLS_CART_ATTACH_DETACH_NO_RESET_DA,
/* de */  IDCLS_CART_ATTACH_DETACH_NO_RESET_DE,
/* fr */  IDCLS_CART_ATTACH_DETACH_NO_RESET_FR,
/* hu */  IDCLS_CART_ATTACH_DETACH_NO_RESET_HU,
/* it */  IDCLS_CART_ATTACH_DETACH_NO_RESET_IT,
/* nl */  IDCLS_CART_ATTACH_DETACH_NO_RESET_NL,
/* pl */  IDCLS_CART_ATTACH_DETACH_NO_RESET_PL,
/* sv */  IDCLS_CART_ATTACH_DETACH_NO_RESET_SV,
/* tr */  IDCLS_CART_ATTACH_DETACH_NO_RESET_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_CRT_CART,
/* de */  IDCLS_ATTACH_CRT_CART_DA,
/* de */  IDCLS_ATTACH_CRT_CART_DE,
/* fr */  IDCLS_ATTACH_CRT_CART_FR,
/* hu */  IDCLS_ATTACH_CRT_CART_HU,
/* it */  IDCLS_ATTACH_CRT_CART_IT,
/* nl */  IDCLS_ATTACH_CRT_CART_NL,
/* pl */  IDCLS_ATTACH_CRT_CART_PL,
/* sv */  IDCLS_ATTACH_CRT_CART_SV,
/* tr */  IDCLS_ATTACH_CRT_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_GENERIC_8KB_CART,
/* de */  IDCLS_ATTACH_GENERIC_8KB_CART_DA,
/* de */  IDCLS_ATTACH_GENERIC_8KB_CART_DE,
/* fr */  IDCLS_ATTACH_GENERIC_8KB_CART_FR,
/* hu */  IDCLS_ATTACH_GENERIC_8KB_CART_HU,
/* it */  IDCLS_ATTACH_GENERIC_8KB_CART_IT,
/* nl */  IDCLS_ATTACH_GENERIC_8KB_CART_NL,
/* pl */  IDCLS_ATTACH_GENERIC_8KB_CART_PL,
/* sv */  IDCLS_ATTACH_GENERIC_8KB_CART_SV,
/* tr */  IDCLS_ATTACH_GENERIC_8KB_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_GENERIC_16KB_CART,
/* de */  IDCLS_ATTACH_GENERIC_16KB_CART_DA,
/* de */  IDCLS_ATTACH_GENERIC_16KB_CART_DE,
/* fr */  IDCLS_ATTACH_GENERIC_16KB_CART_FR,
/* hu */  IDCLS_ATTACH_GENERIC_16KB_CART_HU,
/* it */  IDCLS_ATTACH_GENERIC_16KB_CART_IT,
/* nl */  IDCLS_ATTACH_GENERIC_16KB_CART_NL,
/* pl */  IDCLS_ATTACH_GENERIC_16KB_CART_PL,
/* sv */  IDCLS_ATTACH_GENERIC_16KB_CART_SV,
/* tr */  IDCLS_ATTACH_GENERIC_16KB_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_STARDOS_CART,
/* de */  IDCLS_ATTACH_RAW_STARDOS_CART_DA,
/* de */  IDCLS_ATTACH_RAW_STARDOS_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_STARDOS_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_STARDOS_CART_HU,
/* it */  IDCLS_ATTACH_RAW_STARDOS_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_STARDOS_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_STARDOS_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_STARDOS_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_STARDOS_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DA,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_HU,
/* it */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DA,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_HU,
/* it */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ACTION_REPLAY_CART,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DA,
/* de */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_HU,
/* it */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_RETRO_REPLAY_CART,
/* de */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DA,
/* de */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_HU,
/* it */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_IDE64_CART,
/* de */  IDCLS_ATTACH_RAW_IDE64_CART_DA,
/* de */  IDCLS_ATTACH_RAW_IDE64_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_IDE64_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_IDE64_CART_HU,
/* it */  IDCLS_ATTACH_RAW_IDE64_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_IDE64_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_IDE64_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_IDE64_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_IDE64_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_ATOMIC_POWER_CART,
/* de */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DA,
/* de */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_HU,
/* it */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART,
/* de */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DA,
/* de */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_HU,
/* it */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_SS4_CART,
/* de */  IDCLS_ATTACH_RAW_SS4_CART_DA,
/* de */  IDCLS_ATTACH_RAW_SS4_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_SS4_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_SS4_CART_HU,
/* it */  IDCLS_ATTACH_RAW_SS4_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_SS4_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_SS4_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_SS4_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_SS4_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_SS5_CART,
/* de */  IDCLS_ATTACH_RAW_SS5_CART_DA,
/* de */  IDCLS_ATTACH_RAW_SS5_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_SS5_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_SS5_CART_HU,
/* it */  IDCLS_ATTACH_RAW_SS5_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_SS5_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_SS5_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_SS5_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_SS5_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_CBM_IEEE488_CART,
/* de */  IDCLS_ATTACH_CBM_IEEE488_CART_DA,
/* de */  IDCLS_ATTACH_CBM_IEEE488_CART_DE,
/* fr */  IDCLS_ATTACH_CBM_IEEE488_CART_FR,
/* hu */  IDCLS_ATTACH_CBM_IEEE488_CART_HU,
/* it */  IDCLS_ATTACH_CBM_IEEE488_CART_IT,
/* nl */  IDCLS_ATTACH_CBM_IEEE488_CART_NL,
/* pl */  IDCLS_ATTACH_CBM_IEEE488_CART_PL,
/* sv */  IDCLS_ATTACH_CBM_IEEE488_CART_SV,
/* tr */  IDCLS_ATTACH_CBM_IEEE488_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_WESTERMANN_CART,
/* de */  IDCLS_ATTACH_RAW_WESTERMANN_CART_DA,
/* de */  IDCLS_ATTACH_RAW_WESTERMANN_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_WESTERMANN_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_WESTERMANN_CART_HU,
/* it */  IDCLS_ATTACH_RAW_WESTERMANN_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_WESTERMANN_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_WESTERMANN_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_WESTERMANN_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_WESTERMANN_CART_TR},

/* c64/cart/c64cart.c, c64/cart/expert.c */
/* en */ {IDCLS_ENABLE_EXPERT_CART,
/* de */  IDCLS_ENABLE_EXPERT_CART_DA,
/* de */  IDCLS_ENABLE_EXPERT_CART_DE,
/* fr */  IDCLS_ENABLE_EXPERT_CART_FR,
/* hu */  IDCLS_ENABLE_EXPERT_CART_HU,
/* it */  IDCLS_ENABLE_EXPERT_CART_IT,
/* nl */  IDCLS_ENABLE_EXPERT_CART_NL,
/* pl */  IDCLS_ENABLE_EXPERT_CART_PL,
/* sv */  IDCLS_ENABLE_EXPERT_CART_SV,
/* tr */  IDCLS_ENABLE_EXPERT_CART_TR},

/* c64/cart/expert.c */
/* en */ {IDCLS_DISABLE_EXPERT_CART,
/* de */  IDCLS_DISABLE_EXPERT_CART_DA,
/* de */  IDCLS_DISABLE_EXPERT_CART_DE,
/* fr */  IDCLS_DISABLE_EXPERT_CART_FR,
/* hu */  IDCLS_DISABLE_EXPERT_CART_HU,
/* it */  IDCLS_DISABLE_EXPERT_CART_IT,
/* nl */  IDCLS_DISABLE_EXPERT_CART_NL,
/* pl */  IDCLS_DISABLE_EXPERT_CART_PL,
/* sv */  IDCLS_DISABLE_EXPERT_CART_SV,
/* tr */  IDCLS_DISABLE_EXPERT_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_P64_CART,
/* de */  IDCLS_ATTACH_RAW_P64_CART_DA,
/* de */  IDCLS_ATTACH_RAW_P64_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_P64_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_P64_CART_HU,
/* it */  IDCLS_ATTACH_RAW_P64_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_P64_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_P64_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_P64_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_P64_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_GAME_KILLER_CART,
/* de */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_DA,
/* de */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_HU,
/* it */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_GAME_KILLER_CART_TR},

/* c64/cart/c64cart.c */
/* en */ {IDCLS_DISABLE_CART,
/* de */  IDCLS_DISABLE_CART_DA,
/* de */  IDCLS_DISABLE_CART_DE,
/* fr */  IDCLS_DISABLE_CART_FR,
/* hu */  IDCLS_DISABLE_CART_HU,
/* it */  IDCLS_DISABLE_CART_IT,
/* nl */  IDCLS_DISABLE_CART_NL,
/* pl */  IDCLS_DISABLE_CART_PL,
/* sv */  IDCLS_DISABLE_CART_SV,
/* tr */  IDCLS_DISABLE_CART_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_SPECIFY_IDE64_NAME,
/* de */  IDCLS_SPECIFY_IDE64_NAME_DA,
/* de */  IDCLS_SPECIFY_IDE64_NAME_DE,
/* fr */  IDCLS_SPECIFY_IDE64_NAME_FR,
/* hu */  IDCLS_SPECIFY_IDE64_NAME_HU,
/* it */  IDCLS_SPECIFY_IDE64_NAME_IT,
/* nl */  IDCLS_SPECIFY_IDE64_NAME_NL,
/* pl */  IDCLS_SPECIFY_IDE64_NAME_PL,
/* sv */  IDCLS_SPECIFY_IDE64_NAME_SV,
/* tr */  IDCLS_SPECIFY_IDE64_NAME_TR},

/* c64/cart/ide64.c, gfxoutputdrv/ffmpegdrv.c, datasette.c,
debug.c, mouse.c, ram.c, sound.c, vsync.c */
/* en */ {IDCLS_P_VALUE,
/* de */  IDCLS_P_VALUE_DA,
/* de */  IDCLS_P_VALUE_DE,
/* fr */  IDCLS_P_VALUE_FR,
/* hu */  IDCLS_P_VALUE_HU,
/* it */  IDCLS_P_VALUE_IT,
/* nl */  IDCLS_P_VALUE_NL,
/* pl */  IDCLS_P_VALUE_PL,
/* sv */  IDCLS_P_VALUE_SV,
/* tr */  IDCLS_P_VALUE_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_CYLINDERS_IDE64,
/* de */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DA,
/* de */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DE,
/* fr */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_FR,
/* hu */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_HU,
/* it */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_IT,
/* nl */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_NL,
/* pl */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_PL,
/* sv */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_SV,
/* tr */  IDCLS_SET_AMOUNT_CYLINDERS_IDE64_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_HEADS_IDE64,
/* de */  IDCLS_SET_AMOUNT_HEADS_IDE64_DA,
/* de */  IDCLS_SET_AMOUNT_HEADS_IDE64_DE,
/* fr */  IDCLS_SET_AMOUNT_HEADS_IDE64_FR,
/* hu */  IDCLS_SET_AMOUNT_HEADS_IDE64_HU,
/* it */  IDCLS_SET_AMOUNT_HEADS_IDE64_IT,
/* nl */  IDCLS_SET_AMOUNT_HEADS_IDE64_NL,
/* pl */  IDCLS_SET_AMOUNT_HEADS_IDE64_PL,
/* sv */  IDCLS_SET_AMOUNT_HEADS_IDE64_SV,
/* tr */  IDCLS_SET_AMOUNT_HEADS_IDE64_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_SET_AMOUNT_SECTORS_IDE64,
/* de */  IDCLS_SET_AMOUNT_SECTORS_IDE64_DA,
/* de */  IDCLS_SET_AMOUNT_SECTORS_IDE64_DE,
/* fr */  IDCLS_SET_AMOUNT_SECTORS_IDE64_FR,
/* hu */  IDCLS_SET_AMOUNT_SECTORS_IDE64_HU,
/* it */  IDCLS_SET_AMOUNT_SECTORS_IDE64_IT,
/* nl */  IDCLS_SET_AMOUNT_SECTORS_IDE64_NL,
/* pl */  IDCLS_SET_AMOUNT_SECTORS_IDE64_PL,
/* sv */  IDCLS_SET_AMOUNT_SECTORS_IDE64_SV,
/* tr */  IDCLS_SET_AMOUNT_SECTORS_IDE64_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_AUTODETECT_IDE64_GEOMETRY,
/* de */  IDCLS_AUTODETECT_IDE64_GEOMETRY_DA,
/* de */  IDCLS_AUTODETECT_IDE64_GEOMETRY_DE,
/* fr */  IDCLS_AUTODETECT_IDE64_GEOMETRY_FR,
/* hu */  IDCLS_AUTODETECT_IDE64_GEOMETRY_HU,
/* it */  IDCLS_AUTODETECT_IDE64_GEOMETRY_IT,
/* nl */  IDCLS_AUTODETECT_IDE64_GEOMETRY_NL,
/* pl */  IDCLS_AUTODETECT_IDE64_GEOMETRY_PL,
/* sv */  IDCLS_AUTODETECT_IDE64_GEOMETRY_SV,
/* tr */  IDCLS_AUTODETECT_IDE64_GEOMETRY_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_NO_AUTODETECT_IDE64_GEOMETRY,
/* de */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DA,
/* de */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DE,
/* fr */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_FR,
/* hu */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_HU,
/* it */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_IT,
/* nl */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_NL,
/* pl */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_PL,
/* sv */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_SV,
/* tr */  IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_TR},

/* c64/cart/ide64.c */
/* en */ {IDCLS_IDE64_VERSION4,
/* de */  IDCLS_IDE64_VERSION4_DA,
/* de */  IDCLS_IDE64_VERSION4_DE,
/* fr */  IDCLS_IDE64_VERSION4_FR,
/* hu */  IDCLS_IDE64_VERSION4_HU,
/* it */  IDCLS_IDE64_VERSION4_IT,
/* nl */  IDCLS_IDE64_VERSION4_NL,
/* pl */  IDCLS_IDE64_VERSION4_PL,
/* sv */  IDCLS_IDE64_VERSION4_SV,
/* tr */  IDCLS_IDE64_VERSION4_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_P_MODELNUMBER,
/* de */  IDCLS_P_MODELNUMBER_DA,
/* de */  IDCLS_P_MODELNUMBER_DE,
/* fr */  IDCLS_P_MODELNUMBER_FR,
/* hu */  IDCLS_P_MODELNUMBER_HU,
/* it */  IDCLS_P_MODELNUMBER_IT,
/* nl */  IDCLS_P_MODELNUMBER_NL,
/* pl */  IDCLS_P_MODELNUMBER_PL,
/* sv */  IDCLS_P_MODELNUMBER_SV,
/* tr */  IDCLS_P_MODELNUMBER_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CBM2_MODEL,
/* de */  IDCLS_SPECIFY_CBM2_MODEL_DA,
/* de */  IDCLS_SPECIFY_CBM2_MODEL_DE,
/* fr */  IDCLS_SPECIFY_CBM2_MODEL_FR,
/* hu */  IDCLS_SPECIFY_CBM2_MODEL_HU,
/* it */  IDCLS_SPECIFY_CBM2_MODEL_IT,
/* nl */  IDCLS_SPECIFY_CBM2_MODEL_NL,
/* pl */  IDCLS_SPECIFY_CBM2_MODEL_PL,
/* sv */  IDCLS_SPECIFY_CBM2_MODEL_SV,
/* tr */  IDCLS_SPECIFY_CBM2_MODEL_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_TO_USE_VIC_II,
/* de */  IDCLS_SPECIFY_TO_USE_VIC_II_DA,
/* de */  IDCLS_SPECIFY_TO_USE_VIC_II_DE,
/* fr */  IDCLS_SPECIFY_TO_USE_VIC_II_FR,
/* hu */  IDCLS_SPECIFY_TO_USE_VIC_II_HU,
/* it */  IDCLS_SPECIFY_TO_USE_VIC_II_IT,
/* nl */  IDCLS_SPECIFY_TO_USE_VIC_II_NL,
/* pl */  IDCLS_SPECIFY_TO_USE_VIC_II_PL,
/* sv */  IDCLS_SPECIFY_TO_USE_VIC_II_SV,
/* tr */  IDCLS_SPECIFY_TO_USE_VIC_II_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_TO_USE_CRTC,
/* de */  IDCLS_SPECIFY_TO_USE_CRTC_DA,
/* de */  IDCLS_SPECIFY_TO_USE_CRTC_DE,
/* fr */  IDCLS_SPECIFY_TO_USE_CRTC_FR,
/* hu */  IDCLS_SPECIFY_TO_USE_CRTC_HU,
/* it */  IDCLS_SPECIFY_TO_USE_CRTC_IT,
/* nl */  IDCLS_SPECIFY_TO_USE_CRTC_NL,
/* pl */  IDCLS_SPECIFY_TO_USE_CRTC_PL,
/* sv */  IDCLS_SPECIFY_TO_USE_CRTC_SV,
/* tr */  IDCLS_SPECIFY_TO_USE_CRTC_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_P_LINENUMBER,
/* de */  IDCLS_P_LINENUMBER_DA,
/* de */  IDCLS_P_LINENUMBER_DE,
/* fr */  IDCLS_P_LINENUMBER_FR,
/* hu */  IDCLS_P_LINENUMBER_HU,
/* it */  IDCLS_P_LINENUMBER_IT,
/* nl */  IDCLS_P_LINENUMBER_NL,
/* pl */  IDCLS_P_LINENUMBER_PL,
/* sv */  IDCLS_P_LINENUMBER_SV,
/* tr */  IDCLS_P_LINENUMBER_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CBM2_MODEL_HARDWARE,
/* de */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DA,
/* de */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DE,
/* fr */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_FR,
/* hu */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_HU,
/* it */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_IT,
/* nl */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_NL,
/* pl */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_PL,
/* sv */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_SV,
/* tr */  IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_TR},

/* cbm2/cbm2-cmdline-options.c, plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_P_RAMSIZE,
/* de */  IDCLS_P_RAMSIZE_DA,
/* de */  IDCLS_P_RAMSIZE_DE,
/* fr */  IDCLS_P_RAMSIZE_FR,
/* hu */  IDCLS_P_RAMSIZE_HU,
/* it */  IDCLS_P_RAMSIZE_IT,
/* nl */  IDCLS_P_RAMSIZE_NL,
/* pl */  IDCLS_P_RAMSIZE_PL,
/* sv */  IDCLS_P_RAMSIZE_SV,
/* tr */  IDCLS_P_RAMSIZE_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SIZE_OF_RAM,
/* de */  IDCLS_SPECIFY_SIZE_OF_RAM_DA,
/* de */  IDCLS_SPECIFY_SIZE_OF_RAM_DE,
/* fr */  IDCLS_SPECIFY_SIZE_OF_RAM_FR,
/* hu */  IDCLS_SPECIFY_SIZE_OF_RAM_HU,
/* it */  IDCLS_SPECIFY_SIZE_OF_RAM_IT,
/* nl */  IDCLS_SPECIFY_SIZE_OF_RAM_NL,
/* pl */  IDCLS_SPECIFY_SIZE_OF_RAM_PL,
/* sv */  IDCLS_SPECIFY_SIZE_OF_RAM_SV,
/* tr */  IDCLS_SPECIFY_SIZE_OF_RAM_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_1000_NAME,
/* de */  IDCLS_SPECIFY_CART_ROM_1000_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_ROM_1000_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_ROM_1000_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_ROM_1000_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_ROM_1000_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_ROM_1000_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_ROM_1000_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_ROM_1000_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_ROM_1000_NAME_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_2000_NAME,
/* de */  IDCLS_SPECIFY_CART_ROM_2000_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_ROM_2000_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_ROM_2000_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_ROM_2000_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_ROM_2000_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_ROM_2000_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_ROM_2000_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_ROM_2000_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_ROM_2000_NAME_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_4000_NAME,
/* de */  IDCLS_SPECIFY_CART_ROM_4000_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_ROM_4000_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_ROM_4000_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_ROM_4000_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_ROM_4000_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_ROM_4000_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_ROM_4000_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_ROM_4000_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_ROM_4000_NAME_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_ROM_6000_NAME,
/* de */  IDCLS_SPECIFY_CART_ROM_6000_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_ROM_6000_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_ROM_6000_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_ROM_6000_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_ROM_6000_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_ROM_6000_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_ROM_6000_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_ROM_6000_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_ROM_6000_NAME_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_0800,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_0800_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_0800,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_0800_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_1000,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_1000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_1000,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_1000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_2000,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_2000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_2000,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_2000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_4000,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_4000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_4000,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_4000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_6000,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_6000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_6000,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_6000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_ENABLE_RAM_MAPPING_IN_C000,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_DA,
/* de */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_DE,
/* fr */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_FR,
/* hu */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_HU,
/* it */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_IT,
/* nl */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_NL,
/* pl */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_PL,
/* sv */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_SV,
/* tr */  IDCLS_ENABLE_RAM_MAPPING_IN_C000_TR},

/* cbm2/cbm2-cmdline-options.c */
/* en */ {IDCLS_DISABLE_RAM_MAPPING_IN_C000,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_DA,
/* de */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_DE,
/* fr */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_FR,
/* hu */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_HU,
/* it */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_IT,
/* nl */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_NL,
/* pl */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_PL,
/* sv */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_SV,
/* tr */  IDCLS_DISABLE_RAM_MAPPING_IN_C000_TR},

#ifdef COMMON_KBD
/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_KEYMAP_INDEX,
/* de */  IDCLS_SPECIFY_KEYMAP_INDEX_DA,
/* de */  IDCLS_SPECIFY_KEYMAP_INDEX_DE,
/* fr */  IDCLS_SPECIFY_KEYMAP_INDEX_FR,
/* hu */  IDCLS_SPECIFY_KEYMAP_INDEX_HU,
/* it */  IDCLS_SPECIFY_KEYMAP_INDEX_IT,
/* nl */  IDCLS_SPECIFY_KEYMAP_INDEX_NL,
/* pl */  IDCLS_SPECIFY_KEYMAP_INDEX_PL,
/* sv */  IDCLS_SPECIFY_KEYMAP_INDEX_SV,
/* tr */  IDCLS_SPECIFY_KEYMAP_INDEX_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_TR},

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME,
/* de */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DA,
/* de */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DE,
/* fr */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_FR,
/* hu */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_HU,
/* it */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_IT,
/* nl */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_NL,
/* pl */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_PL,
/* sv */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_SV,
/* tr */  IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_TR},
#endif   /* COMMON_KBD */

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_ENABLE_TRUE_DRIVE,
/* de */  IDCLS_ENABLE_TRUE_DRIVE_DA,
/* de */  IDCLS_ENABLE_TRUE_DRIVE_DE,
/* fr */  IDCLS_ENABLE_TRUE_DRIVE_FR,
/* hu */  IDCLS_ENABLE_TRUE_DRIVE_HU,
/* it */  IDCLS_ENABLE_TRUE_DRIVE_IT,
/* nl */  IDCLS_ENABLE_TRUE_DRIVE_NL,
/* pl */  IDCLS_ENABLE_TRUE_DRIVE_PL,
/* sv */  IDCLS_ENABLE_TRUE_DRIVE_SV,
/* tr */  IDCLS_ENABLE_TRUE_DRIVE_TR},

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_DISABLE_TRUE_DRIVE,
/* de */  IDCLS_DISABLE_TRUE_DRIVE_DA,
/* de */  IDCLS_DISABLE_TRUE_DRIVE_DE,
/* fr */  IDCLS_DISABLE_TRUE_DRIVE_FR,
/* hu */  IDCLS_DISABLE_TRUE_DRIVE_HU,
/* it */  IDCLS_DISABLE_TRUE_DRIVE_IT,
/* nl */  IDCLS_DISABLE_TRUE_DRIVE_NL,
/* pl */  IDCLS_DISABLE_TRUE_DRIVE_PL,
/* sv */  IDCLS_DISABLE_TRUE_DRIVE_SV,
/* tr */  IDCLS_DISABLE_TRUE_DRIVE_TR},

/* drive/drive-cmdline-options.c, printerdrv/interface-serial.c,
attach.c, drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_P_TYPE,
/* de */  IDCLS_P_TYPE_DA,
/* de */  IDCLS_P_TYPE_DE,
/* fr */  IDCLS_P_TYPE_FR,
/* hu */  IDCLS_P_TYPE_HU,
/* it */  IDCLS_P_TYPE_IT,
/* nl */  IDCLS_P_TYPE_NL,
/* pl */  IDCLS_P_TYPE_PL,
/* sv */  IDCLS_P_TYPE_SV,
/* tr */  IDCLS_P_TYPE_TR},

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_TYPE,
/* de */  IDCLS_SET_DRIVE_TYPE_DA,
/* de */  IDCLS_SET_DRIVE_TYPE_DE,
/* fr */  IDCLS_SET_DRIVE_TYPE_FR,
/* hu */  IDCLS_SET_DRIVE_TYPE_HU,
/* it */  IDCLS_SET_DRIVE_TYPE_IT,
/* nl */  IDCLS_SET_DRIVE_TYPE_NL,
/* pl */  IDCLS_SET_DRIVE_TYPE_PL,
/* sv */  IDCLS_SET_DRIVE_TYPE_SV,
/* tr */  IDCLS_SET_DRIVE_TYPE_TR},

/* drive/drive-cmdline-options.c, gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_P_METHOD,
/* de */  IDCLS_P_METHOD_DA,
/* de */  IDCLS_P_METHOD_DE,
/* fr */  IDCLS_P_METHOD_FR,
/* hu */  IDCLS_P_METHOD_HU,
/* it */  IDCLS_P_METHOD_IT,
/* nl */  IDCLS_P_METHOD_NL,
/* pl */  IDCLS_P_METHOD_PL,
/* sv */  IDCLS_P_METHOD_SV,
/* tr */  IDCLS_P_METHOD_TR},

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_P_COLOR,
/* de */  IDCLS_P_COLOR_DA,
/* de */  IDCLS_P_COLOR_DE,
/* fr */  IDCLS_P_COLOR_FR,
/* hu */  IDCLS_P_COLOR_HU,
/* it */  IDCLS_P_COLOR_IT,
/* nl */  IDCLS_P_COLOR_NL,
/* pl */  IDCLS_P_COLOR_PL,
/* sv */  IDCLS_P_COLOR_SV,
/* tr */  IDCLS_P_COLOR_TR},

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_OVERSIZED_HANDLING,
/* de */  IDCLS_OVERSIZED_HANDLING_DA,
/* de */  IDCLS_OVERSIZED_HANDLING_DE,
/* fr */  IDCLS_OVERSIZED_HANDLING_FR,
/* hu */  IDCLS_OVERSIZED_HANDLING_HU,
/* it */  IDCLS_OVERSIZED_HANDLING_IT,
/* nl */  IDCLS_OVERSIZED_HANDLING_NL,
/* pl */  IDCLS_OVERSIZED_HANDLING_PL,
/* sv */  IDCLS_OVERSIZED_HANDLING_SV,
/* tr */  IDCLS_OVERSIZED_HANDLING_TR},

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_MULTICOLOR_HANDLING,
/* de */  IDCLS_MULTICOLOR_HANDLING_DA,
/* de */  IDCLS_MULTICOLOR_HANDLING_DE,
/* fr */  IDCLS_MULTICOLOR_HANDLING_FR,
/* hu */  IDCLS_MULTICOLOR_HANDLING_HU,
/* it */  IDCLS_MULTICOLOR_HANDLING_IT,
/* nl */  IDCLS_MULTICOLOR_HANDLING_NL,
/* pl */  IDCLS_MULTICOLOR_HANDLING_PL,
/* sv */  IDCLS_MULTICOLOR_HANDLING_SV,
/* tr */  IDCLS_MULTICOLOR_HANDLING_TR},

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_TED_LUM_HANDLING,
/* de */  IDCLS_TED_LUM_HANDLING_DA,
/* de */  IDCLS_TED_LUM_HANDLING_DE,
/* fr */  IDCLS_TED_LUM_HANDLING_FR,
/* hu */  IDCLS_TED_LUM_HANDLING_HU,
/* it */  IDCLS_TED_LUM_HANDLING_IT,
/* nl */  IDCLS_TED_LUM_HANDLING_NL,
/* pl */  IDCLS_TED_LUM_HANDLING_PL,
/* sv */  IDCLS_TED_LUM_HANDLING_SV,
/* tr */  IDCLS_TED_LUM_HANDLING_TR},

/* gfxoutputdrv/doodledrv.c */
/* en */ {IDCLS_CRTC_TEXT_COLOR,
/* de */  IDCLS_CRTC_TEXT_COLOR_DA,
/* de */  IDCLS_CRTC_TEXT_COLOR_DE,
/* fr */  IDCLS_CRTC_TEXT_COLOR_FR,
/* hu */  IDCLS_CRTC_TEXT_COLOR_HU,
/* it */  IDCLS_CRTC_TEXT_COLOR_IT,
/* nl */  IDCLS_CRTC_TEXT_COLOR_NL,
/* pl */  IDCLS_CRTC_TEXT_COLOR_PL,
/* sv */  IDCLS_CRTC_TEXT_COLOR_SV,
/* tr */  IDCLS_CRTC_TEXT_COLOR_TR},

/* drive/drive-cmdline-options.c */
/* en */ {IDCLS_SET_DRIVE_EXTENSION_POLICY,
/* de */  IDCLS_SET_DRIVE_EXTENSION_POLICY_DA,
/* de */  IDCLS_SET_DRIVE_EXTENSION_POLICY_DE,
/* fr */  IDCLS_SET_DRIVE_EXTENSION_POLICY_FR,
/* hu */  IDCLS_SET_DRIVE_EXTENSION_POLICY_HU,
/* it */  IDCLS_SET_DRIVE_EXTENSION_POLICY_IT,
/* nl */  IDCLS_SET_DRIVE_EXTENSION_POLICY_NL,
/* pl */  IDCLS_SET_DRIVE_EXTENSION_POLICY_PL,
/* sv */  IDCLS_SET_DRIVE_EXTENSION_POLICY_SV,
/* tr */  IDCLS_SET_DRIVE_EXTENSION_POLICY_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1541_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1541_DOS_ROM_NAME_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1541_II_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1570_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1570_DOS_ROM_NAME_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1571_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1571_DOS_ROM_NAME_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1581_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1581_DOS_ROM_NAME_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_SET_IDLE_METHOD,
/* de */  IDCLS_SET_IDLE_METHOD_DA,
/* de */  IDCLS_SET_IDLE_METHOD_DE,
/* fr */  IDCLS_SET_IDLE_METHOD_FR,
/* hu */  IDCLS_SET_IDLE_METHOD_HU,
/* it */  IDCLS_SET_IDLE_METHOD_IT,
/* nl */  IDCLS_SET_IDLE_METHOD_NL,
/* pl */  IDCLS_SET_IDLE_METHOD_PL,
/* sv */  IDCLS_SET_IDLE_METHOD_SV,
/* tr */  IDCLS_SET_IDLE_METHOD_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_2000,
/* de */  IDCLS_ENABLE_DRIVE_RAM_2000_DA,
/* de */  IDCLS_ENABLE_DRIVE_RAM_2000_DE,
/* fr */  IDCLS_ENABLE_DRIVE_RAM_2000_FR,
/* hu */  IDCLS_ENABLE_DRIVE_RAM_2000_HU,
/* it */  IDCLS_ENABLE_DRIVE_RAM_2000_IT,
/* nl */  IDCLS_ENABLE_DRIVE_RAM_2000_NL,
/* pl */  IDCLS_ENABLE_DRIVE_RAM_2000_PL,
/* sv */  IDCLS_ENABLE_DRIVE_RAM_2000_SV,
/* tr */  IDCLS_ENABLE_DRIVE_RAM_2000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_2000,
/* de */  IDCLS_DISABLE_DRIVE_RAM_2000_DA,
/* de */  IDCLS_DISABLE_DRIVE_RAM_2000_DE,
/* fr */  IDCLS_DISABLE_DRIVE_RAM_2000_FR,
/* hu */  IDCLS_DISABLE_DRIVE_RAM_2000_HU,
/* it */  IDCLS_DISABLE_DRIVE_RAM_2000_IT,
/* nl */  IDCLS_DISABLE_DRIVE_RAM_2000_NL,
/* pl */  IDCLS_DISABLE_DRIVE_RAM_2000_PL,
/* sv */  IDCLS_DISABLE_DRIVE_RAM_2000_SV,
/* tr */  IDCLS_DISABLE_DRIVE_RAM_2000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_4000,
/* de */  IDCLS_ENABLE_DRIVE_RAM_4000_DA,
/* de */  IDCLS_ENABLE_DRIVE_RAM_4000_DE,
/* fr */  IDCLS_ENABLE_DRIVE_RAM_4000_FR,
/* hu */  IDCLS_ENABLE_DRIVE_RAM_4000_HU,
/* it */  IDCLS_ENABLE_DRIVE_RAM_4000_IT,
/* nl */  IDCLS_ENABLE_DRIVE_RAM_4000_NL,
/* pl */  IDCLS_ENABLE_DRIVE_RAM_4000_PL,
/* sv */  IDCLS_ENABLE_DRIVE_RAM_4000_SV,
/* tr */  IDCLS_ENABLE_DRIVE_RAM_4000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_4000,
/* de */  IDCLS_DISABLE_DRIVE_RAM_4000_DA,
/* de */  IDCLS_DISABLE_DRIVE_RAM_4000_DE,
/* fr */  IDCLS_DISABLE_DRIVE_RAM_4000_FR,
/* hu */  IDCLS_DISABLE_DRIVE_RAM_4000_HU,
/* it */  IDCLS_DISABLE_DRIVE_RAM_4000_IT,
/* nl */  IDCLS_DISABLE_DRIVE_RAM_4000_NL,
/* pl */  IDCLS_DISABLE_DRIVE_RAM_4000_PL,
/* sv */  IDCLS_DISABLE_DRIVE_RAM_4000_SV,
/* tr */  IDCLS_DISABLE_DRIVE_RAM_4000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_6000,
/* de */  IDCLS_ENABLE_DRIVE_RAM_6000_DA,
/* de */  IDCLS_ENABLE_DRIVE_RAM_6000_DE,
/* fr */  IDCLS_ENABLE_DRIVE_RAM_6000_FR,
/* hu */  IDCLS_ENABLE_DRIVE_RAM_6000_HU,
/* it */  IDCLS_ENABLE_DRIVE_RAM_6000_IT,
/* nl */  IDCLS_ENABLE_DRIVE_RAM_6000_NL,
/* pl */  IDCLS_ENABLE_DRIVE_RAM_6000_PL,
/* sv */  IDCLS_ENABLE_DRIVE_RAM_6000_SV,
/* tr */  IDCLS_ENABLE_DRIVE_RAM_6000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_6000,
/* de */  IDCLS_DISABLE_DRIVE_RAM_6000_DA,
/* de */  IDCLS_DISABLE_DRIVE_RAM_6000_DE,
/* fr */  IDCLS_DISABLE_DRIVE_RAM_6000_FR,
/* hu */  IDCLS_DISABLE_DRIVE_RAM_6000_HU,
/* it */  IDCLS_DISABLE_DRIVE_RAM_6000_IT,
/* nl */  IDCLS_DISABLE_DRIVE_RAM_6000_NL,
/* pl */  IDCLS_DISABLE_DRIVE_RAM_6000_PL,
/* sv */  IDCLS_DISABLE_DRIVE_RAM_6000_SV,
/* tr */  IDCLS_DISABLE_DRIVE_RAM_6000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_8000,
/* de */  IDCLS_ENABLE_DRIVE_RAM_8000_DA,
/* de */  IDCLS_ENABLE_DRIVE_RAM_8000_DE,
/* fr */  IDCLS_ENABLE_DRIVE_RAM_8000_FR,
/* hu */  IDCLS_ENABLE_DRIVE_RAM_8000_HU,
/* it */  IDCLS_ENABLE_DRIVE_RAM_8000_IT,
/* nl */  IDCLS_ENABLE_DRIVE_RAM_8000_NL,
/* pl */  IDCLS_ENABLE_DRIVE_RAM_8000_PL,
/* sv */  IDCLS_ENABLE_DRIVE_RAM_8000_SV,
/* tr */  IDCLS_ENABLE_DRIVE_RAM_8000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_8000,
/* de */  IDCLS_DISABLE_DRIVE_RAM_8000_DA,
/* de */  IDCLS_DISABLE_DRIVE_RAM_8000_DE,
/* fr */  IDCLS_DISABLE_DRIVE_RAM_8000_FR,
/* hu */  IDCLS_DISABLE_DRIVE_RAM_8000_HU,
/* it */  IDCLS_DISABLE_DRIVE_RAM_8000_IT,
/* nl */  IDCLS_DISABLE_DRIVE_RAM_8000_NL,
/* pl */  IDCLS_DISABLE_DRIVE_RAM_8000_PL,
/* sv */  IDCLS_DISABLE_DRIVE_RAM_8000_SV,
/* tr */  IDCLS_DISABLE_DRIVE_RAM_8000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DRIVE_RAM_A000,
/* de */  IDCLS_ENABLE_DRIVE_RAM_A000_DA,
/* de */  IDCLS_ENABLE_DRIVE_RAM_A000_DE,
/* fr */  IDCLS_ENABLE_DRIVE_RAM_A000_FR,
/* hu */  IDCLS_ENABLE_DRIVE_RAM_A000_HU,
/* it */  IDCLS_ENABLE_DRIVE_RAM_A000_IT,
/* nl */  IDCLS_ENABLE_DRIVE_RAM_A000_NL,
/* pl */  IDCLS_ENABLE_DRIVE_RAM_A000_PL,
/* sv */  IDCLS_ENABLE_DRIVE_RAM_A000_SV,
/* tr */  IDCLS_ENABLE_DRIVE_RAM_A000_TR},

/* drive/iec/iec-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DRIVE_RAM_A000,
/* de */  IDCLS_DISABLE_DRIVE_RAM_A000_DA,
/* de */  IDCLS_DISABLE_DRIVE_RAM_A000_DE,
/* fr */  IDCLS_DISABLE_DRIVE_RAM_A000_FR,
/* hu */  IDCLS_DISABLE_DRIVE_RAM_A000_HU,
/* it */  IDCLS_DISABLE_DRIVE_RAM_A000_IT,
/* nl */  IDCLS_DISABLE_DRIVE_RAM_A000_NL,
/* pl */  IDCLS_DISABLE_DRIVE_RAM_A000_PL,
/* sv */  IDCLS_DISABLE_DRIVE_RAM_A000_SV,
/* tr */  IDCLS_DISABLE_DRIVE_RAM_A000_TR},

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_PAR_CABLE_C64EXP_TYPE,
/* de */  IDCLS_PAR_CABLE_C64EXP_TYPE_DA,
/* de */  IDCLS_PAR_CABLE_C64EXP_TYPE_DE,
/* fr */  IDCLS_PAR_CABLE_C64EXP_TYPE_FR,
/* hu */  IDCLS_PAR_CABLE_C64EXP_TYPE_HU,
/* it */  IDCLS_PAR_CABLE_C64EXP_TYPE_IT,
/* nl */  IDCLS_PAR_CABLE_C64EXP_TYPE_NL,
/* pl */  IDCLS_PAR_CABLE_C64EXP_TYPE_PL,
/* sv */  IDCLS_PAR_CABLE_C64EXP_TYPE_SV,
/* tr */  IDCLS_PAR_CABLE_C64EXP_TYPE_TR},

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_ENABLE_PROFDOS,
/* de */  IDCLS_ENABLE_PROFDOS_DA,
/* de */  IDCLS_ENABLE_PROFDOS_DE,
/* fr */  IDCLS_ENABLE_PROFDOS_FR,
/* hu */  IDCLS_ENABLE_PROFDOS_HU,
/* it */  IDCLS_ENABLE_PROFDOS_IT,
/* nl */  IDCLS_ENABLE_PROFDOS_NL,
/* pl */  IDCLS_ENABLE_PROFDOS_PL,
/* sv */  IDCLS_ENABLE_PROFDOS_SV,
/* tr */  IDCLS_ENABLE_PROFDOS_TR},

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_DISABLE_PROFDOS,
/* de */  IDCLS_DISABLE_PROFDOS_DA,
/* de */  IDCLS_DISABLE_PROFDOS_DE,
/* fr */  IDCLS_DISABLE_PROFDOS_FR,
/* hu */  IDCLS_DISABLE_PROFDOS_HU,
/* it */  IDCLS_DISABLE_PROFDOS_IT,
/* nl */  IDCLS_DISABLE_PROFDOS_NL,
/* pl */  IDCLS_DISABLE_PROFDOS_PL,
/* sv */  IDCLS_DISABLE_PROFDOS_SV,
/* tr */  IDCLS_DISABLE_PROFDOS_TR},

/* drive/iec/c64exp/c64exp-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME,
/* de */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_TR},

/* drive/iec/plus4exp/plus4exp-cmdline-options.c */
/* en */ {IDCLS_PAR_CABLE_PLUS4EXP_TYPE,
/* de */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DA,
/* de */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DE,
/* fr */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_FR,
/* hu */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_HU,
/* it */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_IT,
/* nl */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_NL,
/* pl */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_PL,
/* sv */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_SV,
/* tr */  IDCLS_PAR_CABLE_PLUS4EXP_TYPE_TR},

/* drive/iec128dcr/iec128dcr-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1571CR_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_TR},

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_2031_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_2031_DOS_ROM_NAME_TR},

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_2040_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_2040_DOS_ROM_NAME_TR},

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_3040_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_3040_DOS_ROM_NAME_TR},

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4040_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_4040_DOS_ROM_NAME_TR},

/* drive/ieee/ieee-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1001_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1001_DOS_ROM_NAME_TR},

/* drive/tcbm/tcbm-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_1551_DOS_ROM_NAME,
/* de */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_1551_DOS_ROM_NAME_TR},

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_8,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DA,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DE,
/* fr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_FR,
/* hu */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_HU,
/* it */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_IT,
/* nl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_NL,
/* pl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_PL,
/* sv */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_SV,
/* tr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_TR},

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_9,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DA,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DE,
/* fr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_FR,
/* hu */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_HU,
/* it */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_IT,
/* nl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_NL,
/* pl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_PL,
/* sv */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_SV,
/* tr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_TR},

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_10,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DA,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DE,
/* fr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_FR,
/* hu */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_HU,
/* it */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_IT,
/* nl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_NL,
/* pl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_PL,
/* sv */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_SV,
/* tr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_TR},

/* fsdevice/fsdevice-cmdline-options.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FSDEVICE_11,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DA,
/* de */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DE,
/* fr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_FR,
/* hu */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_HU,
/* it */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_IT,
/* nl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_NL,
/* pl */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_PL,
/* sv */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_SV,
/* tr */  IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_TR},

#ifdef HAVE_FFMPEG
/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDCLS_SET_AUDIO_STREAM_BITRATE,
/* de */  IDCLS_SET_AUDIO_STREAM_BITRATE_DA,
/* de */  IDCLS_SET_AUDIO_STREAM_BITRATE_DE,
/* fr */  IDCLS_SET_AUDIO_STREAM_BITRATE_FR,
/* hu */  IDCLS_SET_AUDIO_STREAM_BITRATE_HU,
/* it */  IDCLS_SET_AUDIO_STREAM_BITRATE_IT,
/* nl */  IDCLS_SET_AUDIO_STREAM_BITRATE_NL,
/* pl */  IDCLS_SET_AUDIO_STREAM_BITRATE_PL,
/* sv */  IDCLS_SET_AUDIO_STREAM_BITRATE_SV,
/* tr */  IDCLS_SET_AUDIO_STREAM_BITRATE_TR},

/* gfxoutputdrv/ffmpegdrv.c */
/* en */ {IDCLS_SET_VIDEO_STREAM_BITRATE,
/* de */  IDCLS_SET_VIDEO_STREAM_BITRATE_DA,
/* de */  IDCLS_SET_VIDEO_STREAM_BITRATE_DE,
/* fr */  IDCLS_SET_VIDEO_STREAM_BITRATE_FR,
/* hu */  IDCLS_SET_VIDEO_STREAM_BITRATE_HU,
/* it */  IDCLS_SET_VIDEO_STREAM_BITRATE_IT,
/* nl */  IDCLS_SET_VIDEO_STREAM_BITRATE_NL,
/* pl */  IDCLS_SET_VIDEO_STREAM_BITRATE_PL,
/* sv */  IDCLS_SET_VIDEO_STREAM_BITRATE_SV,
/* tr */  IDCLS_SET_VIDEO_STREAM_BITRATE_TR},
#endif   /* HAVE_FFMPEG */

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_PET_MODEL,
/* de */  IDCLS_SPECIFY_PET_MODEL_DA,
/* de */  IDCLS_SPECIFY_PET_MODEL_DE,
/* fr */  IDCLS_SPECIFY_PET_MODEL_FR,
/* hu */  IDCLS_SPECIFY_PET_MODEL_HU,
/* it */  IDCLS_SPECIFY_PET_MODEL_IT,
/* nl */  IDCLS_SPECIFY_PET_MODEL_NL,
/* pl */  IDCLS_SPECIFY_PET_MODEL_PL,
/* sv */  IDCLS_SPECIFY_PET_MODEL_SV,
/* tr */  IDCLS_SPECIFY_PET_MODEL_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_EDITOR_ROM_NAME,
/* de */  IDCLS_SPECIFY_EDITOR_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_EDITOR_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_EDITOR_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_EDITOR_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_EDITOR_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_EDITOR_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_EDITOR_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_EDITOR_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_EDITOR_ROM_NAME_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_9XXX_NAME,
/* de */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DA,
/* de */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DE,
/* fr */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_FR,
/* hu */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_HU,
/* it */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_IT,
/* nl */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_NL,
/* pl */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_PL,
/* sv */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_SV,
/* tr */  IDCLS_SPECIFY_4K_ROM_9XXX_NAME_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_AXXX_NAME,
/* de */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DA,
/* de */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DE,
/* fr */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_FR,
/* hu */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_HU,
/* it */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_IT,
/* nl */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_NL,
/* pl */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_PL,
/* sv */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_SV,
/* tr */  IDCLS_SPECIFY_4K_ROM_AXXX_NAME_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_4K_ROM_BXXX_NAME,
/* de */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DA,
/* de */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DE,
/* fr */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_FR,
/* hu */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_HU,
/* it */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_IT,
/* nl */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_NL,
/* pl */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_PL,
/* sv */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_SV,
/* tr */  IDCLS_SPECIFY_4K_ROM_BXXX_NAME_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_9000,
/* de */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DA,
/* de */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DE,
/* fr */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_FR,
/* hu */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_HU,
/* it */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_IT,
/* nl */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_NL,
/* pl */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_PL,
/* sv */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_SV,
/* tr */  IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_9000,
/* de */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DA,
/* de */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DE,
/* fr */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_FR,
/* hu */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_HU,
/* it */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_IT,
/* nl */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_NL,
/* pl */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_PL,
/* sv */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_SV,
/* tr */  IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_ENABLE_4K_RAM_AT_A000,
/* de */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DA,
/* de */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DE,
/* fr */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_FR,
/* hu */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_HU,
/* it */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_IT,
/* nl */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_NL,
/* pl */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_PL,
/* sv */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_SV,
/* tr */  IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_PET8296_DISABLE_4K_RAM_AT_A000,
/* de */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DA,
/* de */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DE,
/* fr */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_FR,
/* hu */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_HU,
/* it */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_IT,
/* nl */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_NL,
/* pl */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_PL,
/* sv */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_SV,
/* tr */  IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SUPERPET_IO,
/* de */  IDCLS_ENABLE_SUPERPET_IO_DA,
/* de */  IDCLS_ENABLE_SUPERPET_IO_DE,
/* fr */  IDCLS_ENABLE_SUPERPET_IO_FR,
/* hu */  IDCLS_ENABLE_SUPERPET_IO_HU,
/* it */  IDCLS_ENABLE_SUPERPET_IO_IT,
/* nl */  IDCLS_ENABLE_SUPERPET_IO_NL,
/* pl */  IDCLS_ENABLE_SUPERPET_IO_PL,
/* sv */  IDCLS_ENABLE_SUPERPET_IO_SV,
/* tr */  IDCLS_ENABLE_SUPERPET_IO_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SUPERPET_IO,
/* de */  IDCLS_DISABLE_SUPERPET_IO_DA,
/* de */  IDCLS_DISABLE_SUPERPET_IO_DE,
/* fr */  IDCLS_DISABLE_SUPERPET_IO_FR,
/* hu */  IDCLS_DISABLE_SUPERPET_IO_HU,
/* it */  IDCLS_DISABLE_SUPERPET_IO_IT,
/* nl */  IDCLS_DISABLE_SUPERPET_IO_NL,
/* pl */  IDCLS_DISABLE_SUPERPET_IO_PL,
/* sv */  IDCLS_DISABLE_SUPERPET_IO_SV,
/* tr */  IDCLS_DISABLE_SUPERPET_IO_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_ENABLE_ROM_1_KERNAL_PATCHES,
/* de */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DA,
/* de */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DE,
/* fr */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_FR,
/* hu */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_HU,
/* it */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_IT,
/* nl */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_NL,
/* pl */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_PL,
/* sv */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_SV,
/* tr */  IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_DISABLE_ROM_1_KERNAL_PATCHES,
/* de */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DA,
/* de */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DE,
/* fr */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_FR,
/* hu */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_HU,
/* it */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_IT,
/* nl */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_NL,
/* pl */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_PL,
/* sv */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_SV,
/* tr */  IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_SWITCH_UPPER_LOWER_CHARSET,
/* de */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_DA,
/* de */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_DE,
/* fr */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_FR,
/* hu */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_HU,
/* it */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_IT,
/* nl */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_NL,
/* pl */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_PL,
/* sv */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_SV,
/* tr */  IDCLS_SWITCH_UPPER_LOWER_CHARSET_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET,
/* de */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DA,
/* de */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DE,
/* fr */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_FR,
/* hu */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_HU,
/* it */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_IT,
/* nl */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_NL,
/* pl */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_PL,
/* sv */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_SV,
/* tr */  IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_EOI_BLANKS_SCREEN,
/* de */  IDCLS_EOI_BLANKS_SCREEN_DA,
/* de */  IDCLS_EOI_BLANKS_SCREEN_DE,
/* fr */  IDCLS_EOI_BLANKS_SCREEN_FR,
/* hu */  IDCLS_EOI_BLANKS_SCREEN_HU,
/* it */  IDCLS_EOI_BLANKS_SCREEN_IT,
/* nl */  IDCLS_EOI_BLANKS_SCREEN_NL,
/* pl */  IDCLS_EOI_BLANKS_SCREEN_PL,
/* sv */  IDCLS_EOI_BLANKS_SCREEN_SV,
/* tr */  IDCLS_EOI_BLANKS_SCREEN_TR},

/* pet/pet-cmdline-options.c */
/* en */ {IDCLS_EOI_DOES_NOT_BLANK_SCREEN,
/* de */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DA,
/* de */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DE,
/* fr */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_FR,
/* hu */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_HU,
/* it */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_IT,
/* nl */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_NL,
/* pl */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_PL,
/* sv */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_SV,
/* tr */  IDCLS_EOI_DOES_NOT_BLANK_SCREEN_TR},

/* pet/petpia1.c */
/* en */ {IDCLS_ENABLE_USERPORT_DIAG_PIN,
/* de */  IDCLS_ENABLE_USERPORT_DIAG_PIN_DA,
/* de */  IDCLS_ENABLE_USERPORT_DIAG_PIN_DE,
/* fr */  IDCLS_ENABLE_USERPORT_DIAG_PIN_FR,
/* hu */  IDCLS_ENABLE_USERPORT_DIAG_PIN_HU,
/* it */  IDCLS_ENABLE_USERPORT_DIAG_PIN_IT,
/* nl */  IDCLS_ENABLE_USERPORT_DIAG_PIN_NL,
/* pl */  IDCLS_ENABLE_USERPORT_DIAG_PIN_PL,
/* sv */  IDCLS_ENABLE_USERPORT_DIAG_PIN_SV,
/* tr */  IDCLS_ENABLE_USERPORT_DIAG_PIN_TR},

/* pet/petpia1.c */
/* en */ {IDCLS_DISABLE_USERPORT_DIAG_PIN,
/* de */  IDCLS_DISABLE_USERPORT_DIAG_PIN_DA,
/* de */  IDCLS_DISABLE_USERPORT_DIAG_PIN_DE,
/* fr */  IDCLS_DISABLE_USERPORT_DIAG_PIN_FR,
/* hu */  IDCLS_DISABLE_USERPORT_DIAG_PIN_HU,
/* it */  IDCLS_DISABLE_USERPORT_DIAG_PIN_IT,
/* nl */  IDCLS_DISABLE_USERPORT_DIAG_PIN_NL,
/* pl */  IDCLS_DISABLE_USERPORT_DIAG_PIN_PL,
/* sv */  IDCLS_DISABLE_USERPORT_DIAG_PIN_SV,
/* tr */  IDCLS_DISABLE_USERPORT_DIAG_PIN_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME,
/* de */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME,
/* de */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_1_LOW_ROM_NAME,
/* de */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME,
/* de */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_2_LOW_ROM_NAME,
/* de */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME,
/* de */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_TR},

/* plus4/plus4-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_RAM_INSTALLED,
/* de */  IDCLS_SPECIFY_RAM_INSTALLED_DA,
/* de */  IDCLS_SPECIFY_RAM_INSTALLED_DE,
/* fr */  IDCLS_SPECIFY_RAM_INSTALLED_FR,
/* hu */  IDCLS_SPECIFY_RAM_INSTALLED_HU,
/* it */  IDCLS_SPECIFY_RAM_INSTALLED_IT,
/* nl */  IDCLS_SPECIFY_RAM_INSTALLED_NL,
/* pl */  IDCLS_SPECIFY_RAM_INSTALLED_PL,
/* sv */  IDCLS_SPECIFY_RAM_INSTALLED_SV,
/* tr */  IDCLS_SPECIFY_RAM_INSTALLED_TR},

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_SATURATION,
/* de */  IDCLS_SET_SATURATION_DA,
/* de */  IDCLS_SET_SATURATION_DE,
/* fr */  IDCLS_SET_SATURATION_FR,
/* hu */  IDCLS_SET_SATURATION_HU,
/* it */  IDCLS_SET_SATURATION_IT,
/* nl */  IDCLS_SET_SATURATION_NL,
/* pl */  IDCLS_SET_SATURATION_PL,
/* sv */  IDCLS_SET_SATURATION_SV,
/* tr */  IDCLS_SET_SATURATION_TR},

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_CONTRAST,
/* de */  IDCLS_SET_CONTRAST_DA,
/* de */  IDCLS_SET_CONTRAST_DE,
/* fr */  IDCLS_SET_CONTRAST_FR,
/* hu */  IDCLS_SET_CONTRAST_HU,
/* it */  IDCLS_SET_CONTRAST_IT,
/* nl */  IDCLS_SET_CONTRAST_NL,
/* pl */  IDCLS_SET_CONTRAST_PL,
/* sv */  IDCLS_SET_CONTRAST_SV,
/* tr */  IDCLS_SET_CONTRAST_TR},

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_BRIGHTNESS,
/* de */  IDCLS_SET_BRIGHTNESS_DA,
/* de */  IDCLS_SET_BRIGHTNESS_DE,
/* fr */  IDCLS_SET_BRIGHTNESS_FR,
/* hu */  IDCLS_SET_BRIGHTNESS_HU,
/* it */  IDCLS_SET_BRIGHTNESS_IT,
/* nl */  IDCLS_SET_BRIGHTNESS_NL,
/* pl */  IDCLS_SET_BRIGHTNESS_PL,
/* sv */  IDCLS_SET_BRIGHTNESS_SV,
/* tr */  IDCLS_SET_BRIGHTNESS_TR},

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_GAMMA,
/* de */  IDCLS_SET_GAMMA_DA,
/* de */  IDCLS_SET_GAMMA_DE,
/* fr */  IDCLS_SET_GAMMA_FR,
/* hu */  IDCLS_SET_GAMMA_HU,
/* it */  IDCLS_SET_GAMMA_IT,
/* nl */  IDCLS_SET_GAMMA_NL,
/* pl */  IDCLS_SET_GAMMA_PL,
/* sv */  IDCLS_SET_GAMMA_SV,
/* tr */  IDCLS_SET_GAMMA_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_TINT,
/* de */  IDCLS_SET_TINT_DA,
/* de */  IDCLS_SET_TINT_DE,
/* fr */  IDCLS_SET_TINT_FR,
/* hu */  IDCLS_SET_TINT_HU,
/* it */  IDCLS_SET_TINT_IT,
/* nl */  IDCLS_SET_TINT_NL,
/* pl */  IDCLS_SET_TINT_PL,
/* sv */  IDCLS_SET_TINT_SV,
/* tr */  IDCLS_SET_TINT_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_ODDLINES_PHASE,
/* de */  IDCLS_SET_ODDLINES_PHASE_DA,
/* de */  IDCLS_SET_ODDLINES_PHASE_DE,
/* fr */  IDCLS_SET_ODDLINES_PHASE_FR,
/* hu */  IDCLS_SET_ODDLINES_PHASE_HU,
/* it */  IDCLS_SET_ODDLINES_PHASE_IT,
/* nl */  IDCLS_SET_ODDLINES_PHASE_NL,
/* pl */  IDCLS_SET_ODDLINES_PHASE_PL,
/* sv */  IDCLS_SET_ODDLINES_PHASE_SV,
/* tr */  IDCLS_SET_ODDLINES_PHASE_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_ODDLINES_OFFSET,
/* de */  IDCLS_SET_ODDLINES_OFFSET_DA,
/* de */  IDCLS_SET_ODDLINES_OFFSET_DE,
/* fr */  IDCLS_SET_ODDLINES_OFFSET_FR,
/* hu */  IDCLS_SET_ODDLINES_OFFSET_HU,
/* it */  IDCLS_SET_ODDLINES_OFFSET_IT,
/* nl */  IDCLS_SET_ODDLINES_OFFSET_NL,
/* pl */  IDCLS_SET_ODDLINES_OFFSET_PL,
/* sv */  IDCLS_SET_ODDLINES_OFFSET_SV,
/* tr */  IDCLS_SET_ODDLINES_OFFSET_TR},

/* viciisc/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_VICII_MODEL,
/* de */  IDCLS_SET_VICII_MODEL_DA,
/* de */  IDCLS_SET_VICII_MODEL_DE,
/* fr */  IDCLS_SET_VICII_MODEL_FR,
/* hu */  IDCLS_SET_VICII_MODEL_HU,
/* it */  IDCLS_SET_VICII_MODEL_IT,
/* nl */  IDCLS_SET_VICII_MODEL_NL,
/* pl */  IDCLS_SET_VICII_MODEL_PL,
/* sv */  IDCLS_SET_VICII_MODEL_SV,
/* tr */  IDCLS_SET_VICII_MODEL_TR},

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_4_NAME,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DA,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DE,
/* fr */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_FR,
/* hu */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_HU,
/* it */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_IT,
/* nl */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_NL,
/* pl */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_PL,
/* sv */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_SV,
/* tr */  IDCLS_SPECIFY_PRT_DRIVER_4_NAME_TR},

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_5_NAME,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DA,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DE,
/* fr */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_FR,
/* hu */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_HU,
/* it */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_IT,
/* nl */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_NL,
/* pl */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_PL,
/* sv */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_SV,
/* tr */  IDCLS_SPECIFY_PRT_DRIVER_5_NAME_TR},

/* printerdrv/driver-select.c */
/* en */ {IDCLS_SPECIFY_PRT_DRIVER_USR_NAME,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DA,
/* de */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DE,
/* fr */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_FR,
/* hu */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_HU,
/* it */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_IT,
/* nl */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_NL,
/* pl */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_PL,
/* sv */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_SV,
/* tr */  IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_TR},

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_4,
/* de */  IDCLS_SET_DEVICE_TYPE_4_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_4_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_4_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_4_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_4_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_4_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_4_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_4_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_4_TR},

/* printerdrv/interface-serial.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_5,
/* de */  IDCLS_SET_DEVICE_TYPE_5_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_5_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_5_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_5_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_5_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_5_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_5_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_5_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_5_TR},

/* printerdrv/interface-userport.c */
/* en */ {IDCLS_ENABLE_USERPORT_PRINTER,
/* de */  IDCLS_ENABLE_USERPORT_PRINTER_DA,
/* de */  IDCLS_ENABLE_USERPORT_PRINTER_DE,
/* fr */  IDCLS_ENABLE_USERPORT_PRINTER_FR,
/* hu */  IDCLS_ENABLE_USERPORT_PRINTER_HU,
/* it */  IDCLS_ENABLE_USERPORT_PRINTER_IT,
/* nl */  IDCLS_ENABLE_USERPORT_PRINTER_NL,
/* pl */  IDCLS_ENABLE_USERPORT_PRINTER_PL,
/* sv */  IDCLS_ENABLE_USERPORT_PRINTER_SV,
/* tr */  IDCLS_ENABLE_USERPORT_PRINTER_TR},

/* printerdrv/interface-userport.c */
/* en */ {IDCLS_DISABLE_USERPORT_PRINTER,
/* de */  IDCLS_DISABLE_USERPORT_PRINTER_DA,
/* de */  IDCLS_DISABLE_USERPORT_PRINTER_DE,
/* fr */  IDCLS_DISABLE_USERPORT_PRINTER_FR,
/* hu */  IDCLS_DISABLE_USERPORT_PRINTER_HU,
/* it */  IDCLS_DISABLE_USERPORT_PRINTER_IT,
/* nl */  IDCLS_DISABLE_USERPORT_PRINTER_NL,
/* pl */  IDCLS_DISABLE_USERPORT_PRINTER_PL,
/* sv */  IDCLS_DISABLE_USERPORT_PRINTER_SV,
/* tr */  IDCLS_DISABLE_USERPORT_PRINTER_TR},

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DA,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DE,
/* fr */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_FR,
/* hu */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_HU,
/* it */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_IT,
/* nl */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_NL,
/* pl */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_PL,
/* sv */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_SV,
/* tr */  IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_TR},

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DA,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DE,
/* fr */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_FR,
/* hu */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_HU,
/* it */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_IT,
/* nl */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_NL,
/* pl */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_PL,
/* sv */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_SV,
/* tr */  IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_TR},

/* printerdrv/output-select.c */
/* en */ {IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DA,
/* de */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DE,
/* fr */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_FR,
/* hu */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_HU,
/* it */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_IT,
/* nl */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_NL,
/* pl */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_PL,
/* sv */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_SV,
/* tr */  IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_TR},

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DA,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DE,
/* fr */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_FR,
/* hu */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_HU,
/* it */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_IT,
/* nl */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_NL,
/* pl */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_PL,
/* sv */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_SV,
/* tr */  IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_TR},

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_4,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_4_DA,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_4_DE,
/* fr */  IDCLS_SPECIFY_TEXT_DEVICE_4_FR,
/* hu */  IDCLS_SPECIFY_TEXT_DEVICE_4_HU,
/* it */  IDCLS_SPECIFY_TEXT_DEVICE_4_IT,
/* nl */  IDCLS_SPECIFY_TEXT_DEVICE_4_NL,
/* pl */  IDCLS_SPECIFY_TEXT_DEVICE_4_PL,
/* sv */  IDCLS_SPECIFY_TEXT_DEVICE_4_SV,
/* tr */  IDCLS_SPECIFY_TEXT_DEVICE_4_TR},

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_DEVICE_5,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_5_DA,
/* de */  IDCLS_SPECIFY_TEXT_DEVICE_5_DE,
/* fr */  IDCLS_SPECIFY_TEXT_DEVICE_5_FR,
/* hu */  IDCLS_SPECIFY_TEXT_DEVICE_5_HU,
/* it */  IDCLS_SPECIFY_TEXT_DEVICE_5_IT,
/* nl */  IDCLS_SPECIFY_TEXT_DEVICE_5_NL,
/* pl */  IDCLS_SPECIFY_TEXT_DEVICE_5_PL,
/* sv */  IDCLS_SPECIFY_TEXT_DEVICE_5_SV,
/* tr */  IDCLS_SPECIFY_TEXT_DEVICE_5_TR},

/* printerdrv/output-text.c */
/* en */ {IDCLS_SPECIFY_TEXT_USERPORT,
/* de */  IDCLS_SPECIFY_TEXT_USERPORT_DA,
/* de */  IDCLS_SPECIFY_TEXT_USERPORT_DE,
/* fr */  IDCLS_SPECIFY_TEXT_USERPORT_FR,
/* hu */  IDCLS_SPECIFY_TEXT_USERPORT_HU,
/* it */  IDCLS_SPECIFY_TEXT_USERPORT_IT,
/* nl */  IDCLS_SPECIFY_TEXT_USERPORT_NL,
/* pl */  IDCLS_SPECIFY_TEXT_USERPORT_PL,
/* sv */  IDCLS_SPECIFY_TEXT_USERPORT_SV,
/* tr */  IDCLS_SPECIFY_TEXT_USERPORT_TR},

/* raster/raster-cmdline-options.c */
/* en */ {IDCLS_ENABLE_VIDEO_CACHE,
/* de */  IDCLS_ENABLE_VIDEO_CACHE_DA,
/* de */  IDCLS_ENABLE_VIDEO_CACHE_DE,
/* fr */  IDCLS_ENABLE_VIDEO_CACHE_FR,
/* hu */  IDCLS_ENABLE_VIDEO_CACHE_HU,
/* it */  IDCLS_ENABLE_VIDEO_CACHE_IT,
/* nl */  IDCLS_ENABLE_VIDEO_CACHE_NL,
/* pl */  IDCLS_ENABLE_VIDEO_CACHE_PL,
/* sv */  IDCLS_ENABLE_VIDEO_CACHE_SV,
/* tr */  IDCLS_ENABLE_VIDEO_CACHE_TR},

/* raster/raster-cmdline-options.c */
/* en */ {IDCLS_DISABLE_VIDEO_CACHE,
/* de */  IDCLS_DISABLE_VIDEO_CACHE_DA,
/* de */  IDCLS_DISABLE_VIDEO_CACHE_DE,
/* fr */  IDCLS_DISABLE_VIDEO_CACHE_FR,
/* hu */  IDCLS_DISABLE_VIDEO_CACHE_HU,
/* it */  IDCLS_DISABLE_VIDEO_CACHE_IT,
/* nl */  IDCLS_DISABLE_VIDEO_CACHE_NL,
/* pl */  IDCLS_DISABLE_VIDEO_CACHE_PL,
/* sv */  IDCLS_DISABLE_VIDEO_CACHE_SV,
/* tr */  IDCLS_DISABLE_VIDEO_CACHE_TR},

#ifdef HAVE_RS232
/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_1_NAME,
/* de */  IDCLS_SPECIFY_RS232_1_NAME_DA,
/* de */  IDCLS_SPECIFY_RS232_1_NAME_DE,
/* fr */  IDCLS_SPECIFY_RS232_1_NAME_FR,
/* hu */  IDCLS_SPECIFY_RS232_1_NAME_HU,
/* it */  IDCLS_SPECIFY_RS232_1_NAME_IT,
/* nl */  IDCLS_SPECIFY_RS232_1_NAME_NL,
/* pl */  IDCLS_SPECIFY_RS232_1_NAME_PL,
/* sv */  IDCLS_SPECIFY_RS232_1_NAME_SV,
/* tr */  IDCLS_SPECIFY_RS232_1_NAME_TR},

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_2_NAME,
/* de */  IDCLS_SPECIFY_RS232_2_NAME_DA,
/* de */  IDCLS_SPECIFY_RS232_2_NAME_DE,
/* fr */  IDCLS_SPECIFY_RS232_2_NAME_FR,
/* hu */  IDCLS_SPECIFY_RS232_2_NAME_HU,
/* it */  IDCLS_SPECIFY_RS232_2_NAME_IT,
/* nl */  IDCLS_SPECIFY_RS232_2_NAME_NL,
/* pl */  IDCLS_SPECIFY_RS232_2_NAME_PL,
/* sv */  IDCLS_SPECIFY_RS232_2_NAME_SV,
/* tr */  IDCLS_SPECIFY_RS232_2_NAME_TR},

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_3_NAME,
/* de */  IDCLS_SPECIFY_RS232_3_NAME_DA,
/* de */  IDCLS_SPECIFY_RS232_3_NAME_DE,
/* fr */  IDCLS_SPECIFY_RS232_3_NAME_FR,
/* hu */  IDCLS_SPECIFY_RS232_3_NAME_HU,
/* it */  IDCLS_SPECIFY_RS232_3_NAME_IT,
/* nl */  IDCLS_SPECIFY_RS232_3_NAME_NL,
/* pl */  IDCLS_SPECIFY_RS232_3_NAME_PL,
/* sv */  IDCLS_SPECIFY_RS232_3_NAME_SV,
/* tr */  IDCLS_SPECIFY_RS232_3_NAME_TR},

/* rs232drv/rs232drv.c */
/* en */ {IDCLS_SPECIFY_RS232_4_NAME,
/* de */  IDCLS_SPECIFY_RS232_4_NAME_DA,
/* de */  IDCLS_SPECIFY_RS232_4_NAME_DE,
/* fr */  IDCLS_SPECIFY_RS232_4_NAME_FR,
/* hu */  IDCLS_SPECIFY_RS232_4_NAME_HU,
/* it */  IDCLS_SPECIFY_RS232_4_NAME_IT,
/* nl */  IDCLS_SPECIFY_RS232_4_NAME_NL,
/* pl */  IDCLS_SPECIFY_RS232_4_NAME_PL,
/* sv */  IDCLS_SPECIFY_RS232_4_NAME_SV,
/* tr */  IDCLS_SPECIFY_RS232_4_NAME_TR},
#endif   /* HAVE_RS232 */

/* rs232drv/rsuser.c */
/* en */ {IDCLS_ENABLE_RS232_USERPORT,
/* de */  IDCLS_ENABLE_RS232_USERPORT_DA,
/* de */  IDCLS_ENABLE_RS232_USERPORT_DE,
/* fr */  IDCLS_ENABLE_RS232_USERPORT_FR,
/* hu */  IDCLS_ENABLE_RS232_USERPORT_HU,
/* it */  IDCLS_ENABLE_RS232_USERPORT_IT,
/* nl */  IDCLS_ENABLE_RS232_USERPORT_NL,
/* pl */  IDCLS_ENABLE_RS232_USERPORT_PL,
/* sv */  IDCLS_ENABLE_RS232_USERPORT_SV,
/* tr */  IDCLS_ENABLE_RS232_USERPORT_TR},

/* rs232drv/rsuser.c */
/* en */ {IDCLS_DISABLE_RS232_USERPORT,
/* de */  IDCLS_DISABLE_RS232_USERPORT_DA,
/* de */  IDCLS_DISABLE_RS232_USERPORT_DE,
/* fr */  IDCLS_DISABLE_RS232_USERPORT_FR,
/* hu */  IDCLS_DISABLE_RS232_USERPORT_HU,
/* it */  IDCLS_DISABLE_RS232_USERPORT_IT,
/* nl */  IDCLS_DISABLE_RS232_USERPORT_NL,
/* pl */  IDCLS_DISABLE_RS232_USERPORT_PL,
/* sv */  IDCLS_DISABLE_RS232_USERPORT_SV,
/* tr */  IDCLS_DISABLE_RS232_USERPORT_TR},

/* rs232drv/rsuser.c */
/* en */ {IDCLS_P_BAUD,
/* de */  IDCLS_P_BAUD_DA,
/* de */  IDCLS_P_BAUD_DE,
/* fr */  IDCLS_P_BAUD_FR,
/* hu */  IDCLS_P_BAUD_HU,
/* it */  IDCLS_P_BAUD_IT,
/* nl */  IDCLS_P_BAUD_NL,
/* pl */  IDCLS_P_BAUD_PL,
/* sv */  IDCLS_P_BAUD_SV,
/* tr */  IDCLS_P_BAUD_TR},

/* rs232drv/rsuser.c */
/* en */ {IDCLS_SET_BAUD_RS232_USERPORT,
/* de */  IDCLS_SET_BAUD_RS232_USERPORT_DA,
/* de */  IDCLS_SET_BAUD_RS232_USERPORT_DE,
/* fr */  IDCLS_SET_BAUD_RS232_USERPORT_FR,
/* hu */  IDCLS_SET_BAUD_RS232_USERPORT_HU,
/* it */  IDCLS_SET_BAUD_RS232_USERPORT_IT,
/* nl */  IDCLS_SET_BAUD_RS232_USERPORT_NL,
/* pl */  IDCLS_SET_BAUD_RS232_USERPORT_PL,
/* sv */  IDCLS_SET_BAUD_RS232_USERPORT_SV,
/* tr */  IDCLS_SET_BAUD_RS232_USERPORT_TR},

/* rs232drv/rsuser.c */
/* en */ {IDCLS_SPECIFY_RS232_DEVICE_USERPORT,
/* de */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DA,
/* de */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DE,
/* fr */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_FR,
/* hu */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_HU,
/* it */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_IT,
/* nl */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_NL,
/* pl */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_PL,
/* sv */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_SV,
/* tr */  IDCLS_SPECIFY_RS232_DEVICE_USERPORT_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_4,
/* de */  IDCLS_ENABLE_IEC_4_DA,
/* de */  IDCLS_ENABLE_IEC_4_DE,
/* fr */  IDCLS_ENABLE_IEC_4_FR,
/* hu */  IDCLS_ENABLE_IEC_4_HU,
/* it */  IDCLS_ENABLE_IEC_4_IT,
/* nl */  IDCLS_ENABLE_IEC_4_NL,
/* pl */  IDCLS_ENABLE_IEC_4_PL,
/* sv */  IDCLS_ENABLE_IEC_4_SV,
/* tr */  IDCLS_ENABLE_IEC_4_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_4,
/* de */  IDCLS_DISABLE_IEC_4_DA,
/* de */  IDCLS_DISABLE_IEC_4_DE,
/* fr */  IDCLS_DISABLE_IEC_4_FR,
/* hu */  IDCLS_DISABLE_IEC_4_HU,
/* it */  IDCLS_DISABLE_IEC_4_IT,
/* nl */  IDCLS_DISABLE_IEC_4_NL,
/* pl */  IDCLS_DISABLE_IEC_4_PL,
/* sv */  IDCLS_DISABLE_IEC_4_SV,
/* tr */  IDCLS_DISABLE_IEC_4_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_5,
/* de */  IDCLS_ENABLE_IEC_5_DA,
/* de */  IDCLS_ENABLE_IEC_5_DE,
/* fr */  IDCLS_ENABLE_IEC_5_FR,
/* hu */  IDCLS_ENABLE_IEC_5_HU,
/* it */  IDCLS_ENABLE_IEC_5_IT,
/* nl */  IDCLS_ENABLE_IEC_5_NL,
/* pl */  IDCLS_ENABLE_IEC_5_PL,
/* sv */  IDCLS_ENABLE_IEC_5_SV,
/* tr */  IDCLS_ENABLE_IEC_5_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_5,
/* de */  IDCLS_DISABLE_IEC_5_DA,
/* de */  IDCLS_DISABLE_IEC_5_DE,
/* fr */  IDCLS_DISABLE_IEC_5_FR,
/* hu */  IDCLS_DISABLE_IEC_5_HU,
/* it */  IDCLS_DISABLE_IEC_5_IT,
/* nl */  IDCLS_DISABLE_IEC_5_NL,
/* pl */  IDCLS_DISABLE_IEC_5_PL,
/* sv */  IDCLS_DISABLE_IEC_5_SV,
/* tr */  IDCLS_DISABLE_IEC_5_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_8,
/* de */  IDCLS_ENABLE_IEC_8_DA,
/* de */  IDCLS_ENABLE_IEC_8_DE,
/* fr */  IDCLS_ENABLE_IEC_8_FR,
/* hu */  IDCLS_ENABLE_IEC_8_HU,
/* it */  IDCLS_ENABLE_IEC_8_IT,
/* nl */  IDCLS_ENABLE_IEC_8_NL,
/* pl */  IDCLS_ENABLE_IEC_8_PL,
/* sv */  IDCLS_ENABLE_IEC_8_SV,
/* tr */  IDCLS_ENABLE_IEC_8_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_8,
/* de */  IDCLS_DISABLE_IEC_8_DA,
/* de */  IDCLS_DISABLE_IEC_8_DE,
/* fr */  IDCLS_DISABLE_IEC_8_FR,
/* hu */  IDCLS_DISABLE_IEC_8_HU,
/* it */  IDCLS_DISABLE_IEC_8_IT,
/* nl */  IDCLS_DISABLE_IEC_8_NL,
/* pl */  IDCLS_DISABLE_IEC_8_PL,
/* sv */  IDCLS_DISABLE_IEC_8_SV,
/* tr */  IDCLS_DISABLE_IEC_8_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_9,
/* de */  IDCLS_ENABLE_IEC_9_DA,
/* de */  IDCLS_ENABLE_IEC_9_DE,
/* fr */  IDCLS_ENABLE_IEC_9_FR,
/* hu */  IDCLS_ENABLE_IEC_9_HU,
/* it */  IDCLS_ENABLE_IEC_9_IT,
/* nl */  IDCLS_ENABLE_IEC_9_NL,
/* pl */  IDCLS_ENABLE_IEC_9_PL,
/* sv */  IDCLS_ENABLE_IEC_9_SV,
/* tr */  IDCLS_ENABLE_IEC_9_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_9,
/* de */  IDCLS_DISABLE_IEC_9_DA,
/* de */  IDCLS_DISABLE_IEC_9_DE,
/* fr */  IDCLS_DISABLE_IEC_9_FR,
/* hu */  IDCLS_DISABLE_IEC_9_HU,
/* it */  IDCLS_DISABLE_IEC_9_IT,
/* nl */  IDCLS_DISABLE_IEC_9_NL,
/* pl */  IDCLS_DISABLE_IEC_9_PL,
/* sv */  IDCLS_DISABLE_IEC_9_SV,
/* tr */  IDCLS_DISABLE_IEC_9_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_10,
/* de */  IDCLS_ENABLE_IEC_10_DA,
/* de */  IDCLS_ENABLE_IEC_10_DE,
/* fr */  IDCLS_ENABLE_IEC_10_FR,
/* hu */  IDCLS_ENABLE_IEC_10_HU,
/* it */  IDCLS_ENABLE_IEC_10_IT,
/* nl */  IDCLS_ENABLE_IEC_10_NL,
/* pl */  IDCLS_ENABLE_IEC_10_PL,
/* sv */  IDCLS_ENABLE_IEC_10_SV,
/* tr */  IDCLS_ENABLE_IEC_10_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_10,
/* de */  IDCLS_DISABLE_IEC_10_DA,
/* de */  IDCLS_DISABLE_IEC_10_DE,
/* fr */  IDCLS_DISABLE_IEC_10_FR,
/* hu */  IDCLS_DISABLE_IEC_10_HU,
/* it */  IDCLS_DISABLE_IEC_10_IT,
/* nl */  IDCLS_DISABLE_IEC_10_NL,
/* pl */  IDCLS_DISABLE_IEC_10_PL,
/* sv */  IDCLS_DISABLE_IEC_10_SV,
/* tr */  IDCLS_DISABLE_IEC_10_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_ENABLE_IEC_11,
/* de */  IDCLS_ENABLE_IEC_11_DA,
/* de */  IDCLS_ENABLE_IEC_11_DE,
/* fr */  IDCLS_ENABLE_IEC_11_FR,
/* hu */  IDCLS_ENABLE_IEC_11_HU,
/* it */  IDCLS_ENABLE_IEC_11_IT,
/* nl */  IDCLS_ENABLE_IEC_11_NL,
/* pl */  IDCLS_ENABLE_IEC_11_PL,
/* sv */  IDCLS_ENABLE_IEC_11_SV,
/* tr */  IDCLS_ENABLE_IEC_11_TR},

/* serial/serial-iec-device.c */
/* en */ {IDCLS_DISABLE_IEC_11,
/* de */  IDCLS_DISABLE_IEC_11_DA,
/* de */  IDCLS_DISABLE_IEC_11_DE,
/* fr */  IDCLS_DISABLE_IEC_11_FR,
/* hu */  IDCLS_DISABLE_IEC_11_HU,
/* it */  IDCLS_DISABLE_IEC_11_IT,
/* nl */  IDCLS_DISABLE_IEC_11_NL,
/* pl */  IDCLS_DISABLE_IEC_11_PL,
/* sv */  IDCLS_DISABLE_IEC_11_SV,
/* tr */  IDCLS_DISABLE_IEC_11_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_P_ENGINE_MODEL,
/* de */  IDCLS_P_ENGINE_MODEL_DA,
/* de */  IDCLS_P_ENGINE_MODEL_DE,
/* fr */  IDCLS_P_ENGINE_MODEL_FR,
/* hu */  IDCLS_P_ENGINE_MODEL_HU,
/* it */  IDCLS_P_ENGINE_MODEL_IT,
/* nl */  IDCLS_P_ENGINE_MODEL_NL,
/* pl */  IDCLS_P_ENGINE_MODEL_PL,
/* sv */  IDCLS_P_ENGINE_MODEL_SV,
/* tr */  IDCLS_P_ENGINE_MODEL_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_FASTSID_ENGINE_MODEL,
/* de */  IDCLS_FASTSID_ENGINE_MODEL_DA,
/* de */  IDCLS_FASTSID_ENGINE_MODEL_DE,
/* fr */  IDCLS_FASTSID_ENGINE_MODEL_FR,
/* hu */  IDCLS_FASTSID_ENGINE_MODEL_HU,
/* it */  IDCLS_FASTSID_ENGINE_MODEL_IT,
/* nl */  IDCLS_FASTSID_ENGINE_MODEL_NL,
/* pl */  IDCLS_FASTSID_ENGINE_MODEL_PL,
/* sv */  IDCLS_FASTSID_ENGINE_MODEL_SV,
/* tr */  IDCLS_FASTSID_ENGINE_MODEL_TR},

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESID_ENGINE_MODEL,
/* de */  IDCLS_RESID_ENGINE_MODEL_DA,
/* de */  IDCLS_RESID_ENGINE_MODEL_DE,
/* fr */  IDCLS_RESID_ENGINE_MODEL_FR,
/* hu */  IDCLS_RESID_ENGINE_MODEL_HU,
/* it */  IDCLS_RESID_ENGINE_MODEL_IT,
/* nl */  IDCLS_RESID_ENGINE_MODEL_NL,
/* pl */  IDCLS_RESID_ENGINE_MODEL_PL,
/* sv */  IDCLS_RESID_ENGINE_MODEL_SV,
/* tr */  IDCLS_RESID_ENGINE_MODEL_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESIDDTV_ENGINE_MODEL,
/* de */  IDCLS_RESIDDTV_ENGINE_MODEL_DA,
/* de */  IDCLS_RESIDDTV_ENGINE_MODEL_DE,
/* fr */  IDCLS_RESIDDTV_ENGINE_MODEL_FR,
/* hu */  IDCLS_RESIDDTV_ENGINE_MODEL_HU,
/* it */  IDCLS_RESIDDTV_ENGINE_MODEL_IT,
/* nl */  IDCLS_RESIDDTV_ENGINE_MODEL_NL,
/* pl */  IDCLS_RESIDDTV_ENGINE_MODEL_PL,
/* sv */  IDCLS_RESIDDTV_ENGINE_MODEL_SV,
/* tr */  IDCLS_RESIDDTV_ENGINE_MODEL_TR},
#endif

#ifdef HAVE_CATWEASELMKIII
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_CATWEASELMKIII_ENGINE_MODEL,
/* de */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_DA,
/* de */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_DE,
/* fr */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_FR,
/* hu */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_HU,
/* it */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_IT,
/* nl */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_NL,
/* pl */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_PL,
/* sv */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_SV,
/* tr */  IDCLS_CATWEASELMKIII_ENGINE_MODEL_TR},
#endif

#ifdef HAVE_HARDSID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_HARDSID_ENGINE_MODEL,
/* de */  IDCLS_HARDSID_ENGINE_MODEL_DA,
/* de */  IDCLS_HARDSID_ENGINE_MODEL_DE,
/* fr */  IDCLS_HARDSID_ENGINE_MODEL_FR,
/* hu */  IDCLS_HARDSID_ENGINE_MODEL_HU,
/* it */  IDCLS_HARDSID_ENGINE_MODEL_IT,
/* nl */  IDCLS_HARDSID_ENGINE_MODEL_NL,
/* pl */  IDCLS_HARDSID_ENGINE_MODEL_PL,
/* sv */  IDCLS_HARDSID_ENGINE_MODEL_SV,
/* tr */  IDCLS_HARDSID_ENGINE_MODEL_TR},
#endif

#ifdef HAVE_PARSID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PARSID_ENGINE_MODEL,
/* de */  IDCLS_PARSID_ENGINE_MODEL_DA,
/* de */  IDCLS_PARSID_ENGINE_MODEL_DE,
/* fr */  IDCLS_PARSID_ENGINE_MODEL_FR,
/* hu */  IDCLS_PARSID_ENGINE_MODEL_HU,
/* it */  IDCLS_PARSID_ENGINE_MODEL_IT,
/* nl */  IDCLS_PARSID_ENGINE_MODEL_NL,
/* pl */  IDCLS_PARSID_ENGINE_MODEL_PL,
/* sv */  IDCLS_PARSID_ENGINE_MODEL_SV,
/* tr */  IDCLS_PARSID_ENGINE_MODEL_TR},
#endif

#ifdef HAVE_RESID_FP
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESIDFP_ENGINE_MODEL,
/* de */  IDCLS_RESIDFP_ENGINE_MODEL_DA,
/* de */  IDCLS_RESIDFP_ENGINE_MODEL_DE,
/* fr */  IDCLS_RESIDFP_ENGINE_MODEL_FR,
/* hu */  IDCLS_RESIDFP_ENGINE_MODEL_HU,
/* it */  IDCLS_RESIDFP_ENGINE_MODEL_IT,
/* nl */  IDCLS_RESIDFP_ENGINE_MODEL_NL,
/* pl */  IDCLS_RESIDFP_ENGINE_MODEL_PL,
/* sv */  IDCLS_RESIDFP_ENGINE_MODEL_SV,
/* tr */  IDCLS_RESIDFP_ENGINE_MODEL_TR},
#endif

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SECOND_SID,
/* de */  IDCLS_ENABLE_SECOND_SID_DA,
/* de */  IDCLS_ENABLE_SECOND_SID_DE,
/* fr */  IDCLS_ENABLE_SECOND_SID_FR,
/* hu */  IDCLS_ENABLE_SECOND_SID_HU,
/* it */  IDCLS_ENABLE_SECOND_SID_IT,
/* nl */  IDCLS_ENABLE_SECOND_SID_NL,
/* pl */  IDCLS_ENABLE_SECOND_SID_PL,
/* sv */  IDCLS_ENABLE_SECOND_SID_SV,
/* tr */  IDCLS_ENABLE_SECOND_SID_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SIDCART,
/* de */  IDCLS_ENABLE_SIDCART_DA,
/* de */  IDCLS_ENABLE_SIDCART_DE,
/* fr */  IDCLS_ENABLE_SIDCART_FR,
/* hu */  IDCLS_ENABLE_SIDCART_HU,
/* it */  IDCLS_ENABLE_SIDCART_IT,
/* nl */  IDCLS_ENABLE_SIDCART_NL,
/* pl */  IDCLS_ENABLE_SIDCART_PL,
/* sv */  IDCLS_ENABLE_SIDCART_SV,
/* tr */  IDCLS_ENABLE_SIDCART_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SIDCART,
/* de */  IDCLS_DISABLE_SIDCART_DA,
/* de */  IDCLS_DISABLE_SIDCART_DE,
/* fr */  IDCLS_DISABLE_SIDCART_FR,
/* hu */  IDCLS_DISABLE_SIDCART_HU,
/* it */  IDCLS_DISABLE_SIDCART_IT,
/* nl */  IDCLS_DISABLE_SIDCART_NL,
/* pl */  IDCLS_DISABLE_SIDCART_PL,
/* sv */  IDCLS_DISABLE_SIDCART_SV,
/* tr */  IDCLS_DISABLE_SIDCART_TR},

/* sid/sid-cmdline-options.c, c64/plus60k.c, c64/c64_256k.c c64/cart/digimax.c */
/* en */ {IDCLS_P_BASE_ADDRESS,
/* de */  IDCLS_P_BASE_ADDRESS_DA,
/* de */  IDCLS_P_BASE_ADDRESS_DE,
/* fr */  IDCLS_P_BASE_ADDRESS_FR,
/* hu */  IDCLS_P_BASE_ADDRESS_HU,
/* it */  IDCLS_P_BASE_ADDRESS_IT,
/* nl */  IDCLS_P_BASE_ADDRESS_NL,
/* pl */  IDCLS_P_BASE_ADDRESS_PL,
/* sv */  IDCLS_P_BASE_ADDRESS_SV,
/* tr */  IDCLS_P_BASE_ADDRESS_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_SID_2_ADDRESS,
/* de */  IDCLS_SPECIFY_SID_2_ADDRESS_DA,
/* de */  IDCLS_SPECIFY_SID_2_ADDRESS_DE,
/* fr */  IDCLS_SPECIFY_SID_2_ADDRESS_FR,
/* hu */  IDCLS_SPECIFY_SID_2_ADDRESS_HU,
/* it */  IDCLS_SPECIFY_SID_2_ADDRESS_IT,
/* nl */  IDCLS_SPECIFY_SID_2_ADDRESS_NL,
/* pl */  IDCLS_SPECIFY_SID_2_ADDRESS_PL,
/* sv */  IDCLS_SPECIFY_SID_2_ADDRESS_SV,
/* tr */  IDCLS_SPECIFY_SID_2_ADDRESS_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SID_FILTERS,
/* de */  IDCLS_ENABLE_SID_FILTERS_DA,
/* de */  IDCLS_ENABLE_SID_FILTERS_DE,
/* fr */  IDCLS_ENABLE_SID_FILTERS_FR,
/* hu */  IDCLS_ENABLE_SID_FILTERS_HU,
/* it */  IDCLS_ENABLE_SID_FILTERS_IT,
/* nl */  IDCLS_ENABLE_SID_FILTERS_NL,
/* pl */  IDCLS_ENABLE_SID_FILTERS_PL,
/* sv */  IDCLS_ENABLE_SID_FILTERS_SV,
/* tr */  IDCLS_ENABLE_SID_FILTERS_TR},

/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SID_FILTERS,
/* de */  IDCLS_DISABLE_SID_FILTERS_DA,
/* de */  IDCLS_DISABLE_SID_FILTERS_DE,
/* fr */  IDCLS_DISABLE_SID_FILTERS_FR,
/* hu */  IDCLS_DISABLE_SID_FILTERS_HU,
/* it */  IDCLS_DISABLE_SID_FILTERS_IT,
/* nl */  IDCLS_DISABLE_SID_FILTERS_NL,
/* pl */  IDCLS_DISABLE_SID_FILTERS_PL,
/* sv */  IDCLS_DISABLE_SID_FILTERS_SV,
/* tr */  IDCLS_DISABLE_SID_FILTERS_TR},

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESID_SAMPLING_METHOD,
/* de */  IDCLS_RESID_SAMPLING_METHOD_DA,
/* de */  IDCLS_RESID_SAMPLING_METHOD_DE,
/* fr */  IDCLS_RESID_SAMPLING_METHOD_FR,
/* hu */  IDCLS_RESID_SAMPLING_METHOD_HU,
/* it */  IDCLS_RESID_SAMPLING_METHOD_IT,
/* nl */  IDCLS_RESID_SAMPLING_METHOD_NL,
/* pl */  IDCLS_RESID_SAMPLING_METHOD_PL,
/* sv */  IDCLS_RESID_SAMPLING_METHOD_SV,
/* tr */  IDCLS_RESID_SAMPLING_METHOD_TR},
#endif   /* HAVE_RESID */

/* sid/sid-cmdline-options.c, vsync.c */
/* en */ {IDCLS_P_PERCENT,
/* de */  IDCLS_P_PERCENT_DA,
/* de */  IDCLS_P_PERCENT_DE,
/* fr */  IDCLS_P_PERCENT_FR,
/* hu */  IDCLS_P_PERCENT_HU,
/* it */  IDCLS_P_PERCENT_IT,
/* nl */  IDCLS_P_PERCENT_NL,
/* pl */  IDCLS_P_PERCENT_PL,
/* sv */  IDCLS_P_PERCENT_SV,
/* tr */  IDCLS_P_PERCENT_TR},

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_PASSBAND_PERCENTAGE,
/* de */  IDCLS_PASSBAND_PERCENTAGE_DA,
/* de */  IDCLS_PASSBAND_PERCENTAGE_DE,
/* fr */  IDCLS_PASSBAND_PERCENTAGE_FR,
/* hu */  IDCLS_PASSBAND_PERCENTAGE_HU,
/* it */  IDCLS_PASSBAND_PERCENTAGE_IT,
/* nl */  IDCLS_PASSBAND_PERCENTAGE_NL,
/* pl */  IDCLS_PASSBAND_PERCENTAGE_PL,
/* sv */  IDCLS_PASSBAND_PERCENTAGE_SV,
/* tr */  IDCLS_PASSBAND_PERCENTAGE_TR},
#endif   /* HAVE_RESID */

/* vdc/vdc-cmdline-options.c */
/* en */ {IDCLS_SET_VDC_MEMORY_16KB,
/* de */  IDCLS_SET_VDC_MEMORY_16KB_DA,
/* de */  IDCLS_SET_VDC_MEMORY_16KB_DE,
/* fr */  IDCLS_SET_VDC_MEMORY_16KB_FR,
/* hu */  IDCLS_SET_VDC_MEMORY_16KB_HU,
/* it */  IDCLS_SET_VDC_MEMORY_16KB_IT,
/* nl */  IDCLS_SET_VDC_MEMORY_16KB_NL,
/* pl */  IDCLS_SET_VDC_MEMORY_16KB_PL,
/* sv */  IDCLS_SET_VDC_MEMORY_16KB_SV,
/* tr */  IDCLS_SET_VDC_MEMORY_16KB_TR},

/* vdc/vdc-cmdline-options.c */
/* en */ {IDCLS_SET_VDC_MEMORY_64KB,
/* de */  IDCLS_SET_VDC_MEMORY_64KB_DA,
/* de */  IDCLS_SET_VDC_MEMORY_64KB_DE,
/* fr */  IDCLS_SET_VDC_MEMORY_64KB_FR,
/* hu */  IDCLS_SET_VDC_MEMORY_64KB_HU,
/* it */  IDCLS_SET_VDC_MEMORY_64KB_IT,
/* nl */  IDCLS_SET_VDC_MEMORY_64KB_NL,
/* pl */  IDCLS_SET_VDC_MEMORY_64KB_PL,
/* sv */  IDCLS_SET_VDC_MEMORY_64KB_SV,
/* tr */  IDCLS_SET_VDC_MEMORY_64KB_TR},

/* vdc/vdc-cmdline-options.c */
/* en */ {IDCLS_SET_VDC_REVISION,
/* de */  IDCLS_SET_VDC_REVISION_DA,
/* de */  IDCLS_SET_VDC_REVISION_DE,
/* fr */  IDCLS_SET_VDC_REVISION_FR,
/* hu */  IDCLS_SET_VDC_REVISION_HU,
/* it */  IDCLS_SET_VDC_REVISION_IT,
/* nl */  IDCLS_SET_VDC_REVISION_NL,
/* pl */  IDCLS_SET_VDC_REVISION_PL,
/* sv */  IDCLS_SET_VDC_REVISION_SV,
/* tr */  IDCLS_SET_VDC_REVISION_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_P_SPEC,
/* de */  IDCLS_P_SPEC_DA,
/* de */  IDCLS_P_SPEC_DE,
/* fr */  IDCLS_P_SPEC_FR,
/* hu */  IDCLS_P_SPEC_HU,
/* it */  IDCLS_P_SPEC_IT,
/* nl */  IDCLS_P_SPEC_NL,
/* pl */  IDCLS_P_SPEC_PL,
/* sv */  IDCLS_P_SPEC_SV,
/* tr */  IDCLS_P_SPEC_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_MEMORY_CONFIG,
/* de */  IDCLS_SPECIFY_MEMORY_CONFIG_DA,
/* de */  IDCLS_SPECIFY_MEMORY_CONFIG_DE,
/* fr */  IDCLS_SPECIFY_MEMORY_CONFIG_FR,
/* hu */  IDCLS_SPECIFY_MEMORY_CONFIG_HU,
/* it */  IDCLS_SPECIFY_MEMORY_CONFIG_IT,
/* nl */  IDCLS_SPECIFY_MEMORY_CONFIG_NL,
/* pl */  IDCLS_SPECIFY_MEMORY_CONFIG_PL,
/* sv */  IDCLS_SPECIFY_MEMORY_CONFIG_SV,
/* tr */  IDCLS_SPECIFY_MEMORY_CONFIG_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_ENABLE_VIC1112_IEEE488,
/* de */  IDCLS_ENABLE_VIC1112_IEEE488_DA,
/* de */  IDCLS_ENABLE_VIC1112_IEEE488_DE,
/* fr */  IDCLS_ENABLE_VIC1112_IEEE488_FR,
/* hu */  IDCLS_ENABLE_VIC1112_IEEE488_HU,
/* it */  IDCLS_ENABLE_VIC1112_IEEE488_IT,
/* nl */  IDCLS_ENABLE_VIC1112_IEEE488_NL,
/* pl */  IDCLS_ENABLE_VIC1112_IEEE488_PL,
/* sv */  IDCLS_ENABLE_VIC1112_IEEE488_SV,
/* tr */  IDCLS_ENABLE_VIC1112_IEEE488_TR},

/* vic20/vic20-cmdline-options.c */
/* en */ {IDCLS_DISABLE_VIC1112_IEEE488,
/* de */  IDCLS_DISABLE_VIC1112_IEEE488_DA,
/* de */  IDCLS_DISABLE_VIC1112_IEEE488_DE,
/* fr */  IDCLS_DISABLE_VIC1112_IEEE488_FR,
/* hu */  IDCLS_DISABLE_VIC1112_IEEE488_HU,
/* it */  IDCLS_DISABLE_VIC1112_IEEE488_IT,
/* nl */  IDCLS_DISABLE_VIC1112_IEEE488_NL,
/* pl */  IDCLS_DISABLE_VIC1112_IEEE488_PL,
/* sv */  IDCLS_DISABLE_VIC1112_IEEE488_SV,
/* tr */  IDCLS_DISABLE_VIC1112_IEEE488_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_EXT_ROM_2000_NAME,
/* de */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_ROM_2000_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_EXT_ROM_4000_NAME,
/* de */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_ROM_4000_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_EXT_ROM_6000_NAME,
/* de */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_ROM_6000_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_EXT_ROM_A000_NAME,
/* de */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_ROM_A000_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_EXT_ROM_B000_NAME,
/* de */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_DA,
/* de */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_HU,
/* it */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXT_ROM_B000_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_GENERIC_ROM_NAME,
/* de */  IDCLS_SPECIFY_GENERIC_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_GENERIC_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_GENERIC_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_GENERIC_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_GENERIC_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_GENERIC_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_GENERIC_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_GENERIC_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_GENERIC_ROM_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_MEGA_CART_ROM_NAME,
/* de */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_MEGA_CART_ROM_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME,
/* de */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_TR},

/* vic20/cart/vic20cart.c */
/* en */ {IDCLS_SPECIFY_VIC_FP_ROM_NAME,
/* de */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_DA,
/* de */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_HU,
/* it */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_VIC_FP_ROM_NAME_TR},

/* vic20/cart/finalexpansion.c */
/* en */ {IDCLS_ENABLE_FINALEXPANSION_WRITEBACK,
/* de */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_DA,
/* de */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_DE,
/* fr */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_FR,
/* hu */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_HU,
/* it */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_IT,
/* nl */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_NL,
/* pl */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_PL,
/* sv */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_SV,
/* tr */  IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_TR},

/* vic20/cart/finalexpansion.c */
/* en */ {IDCLS_DISABLE_FINALEXPANSION_WRITEBACK,
/* de */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_DA,
/* de */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_DE,
/* fr */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_FR,
/* hu */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_HU,
/* it */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_IT,
/* nl */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_NL,
/* pl */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_PL,
/* sv */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_SV,
/* tr */  IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_TR},

/* vic20/cart/megacart.c */
/* en */ {IDCLS_SET_MEGACART_NVRAM_NAME,
/* de */  IDCLS_SET_MEGACART_NVRAM_NAME_DA,
/* de */  IDCLS_SET_MEGACART_NVRAM_NAME_DE,
/* fr */  IDCLS_SET_MEGACART_NVRAM_NAME_FR,
/* hu */  IDCLS_SET_MEGACART_NVRAM_NAME_HU,
/* it */  IDCLS_SET_MEGACART_NVRAM_NAME_IT,
/* nl */  IDCLS_SET_MEGACART_NVRAM_NAME_NL,
/* pl */  IDCLS_SET_MEGACART_NVRAM_NAME_PL,
/* sv */  IDCLS_SET_MEGACART_NVRAM_NAME_SV,
/* tr */  IDCLS_SET_MEGACART_NVRAM_NAME_TR},

/* vic20/cart/megacart.c */
/* en */ {IDCLS_ENABLE_MEGACART_NVRAM_WRITE,
/* de */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_DA,
/* de */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_DE,
/* fr */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_FR,
/* hu */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_HU,
/* it */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_IT,
/* nl */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_NL,
/* pl */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_PL,
/* sv */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_SV,
/* tr */  IDCLS_ENABLE_MEGACART_NVRAM_WRITE_TR},

/* vic20/cart/megacart.c */
/* en */ {IDCLS_DISABLE_MEGACART_NVRAM_WRITE,
/* de */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_DA,
/* de */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_DE,
/* fr */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_FR,
/* hu */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_HU,
/* it */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_IT,
/* nl */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_NL,
/* pl */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_PL,
/* sv */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_SV,
/* tr */  IDCLS_DISABLE_MEGACART_NVRAM_WRITE_TR},

/* vic20/cart/vic-fp.c */
/* en */ {IDCLS_ENABLE_VICFP_ROM_WRITE,
/* de */  IDCLS_ENABLE_VICFP_ROM_WRITE_DA,
/* de */  IDCLS_ENABLE_VICFP_ROM_WRITE_DE,
/* fr */  IDCLS_ENABLE_VICFP_ROM_WRITE_FR,
/* hu */  IDCLS_ENABLE_VICFP_ROM_WRITE_HU,
/* it */  IDCLS_ENABLE_VICFP_ROM_WRITE_IT,
/* nl */  IDCLS_ENABLE_VICFP_ROM_WRITE_NL,
/* pl */  IDCLS_ENABLE_VICFP_ROM_WRITE_PL,
/* sv */  IDCLS_ENABLE_VICFP_ROM_WRITE_SV,
/* tr */  IDCLS_ENABLE_VICFP_ROM_WRITE_TR},

/* vic20/cart/vic-fp.c */
/* en */ {IDCLS_DISABLE_VICFP_ROM_WRITE,
/* de */  IDCLS_DISABLE_VICFP_ROM_WRITE_DA,
/* de */  IDCLS_DISABLE_VICFP_ROM_WRITE_DE,
/* fr */  IDCLS_DISABLE_VICFP_ROM_WRITE_FR,
/* hu */  IDCLS_DISABLE_VICFP_ROM_WRITE_HU,
/* it */  IDCLS_DISABLE_VICFP_ROM_WRITE_IT,
/* nl */  IDCLS_DISABLE_VICFP_ROM_WRITE_NL,
/* pl */  IDCLS_DISABLE_VICFP_ROM_WRITE_PL,
/* sv */  IDCLS_DISABLE_VICFP_ROM_WRITE_SV,
/* tr */  IDCLS_DISABLE_VICFP_ROM_WRITE_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_SET_BORDER_MODE,
/* de */  IDCLS_SET_BORDER_MODE_DA,
/* de */  IDCLS_SET_BORDER_MODE_DE,
/* fr */  IDCLS_SET_BORDER_MODE_FR,
/* hu */  IDCLS_SET_BORDER_MODE_HU,
/* it */  IDCLS_SET_BORDER_MODE_IT,
/* nl */  IDCLS_SET_BORDER_MODE_NL,
/* pl */  IDCLS_SET_BORDER_MODE_PL,
/* sv */  IDCLS_SET_BORDER_MODE_SV,
/* tr */  IDCLS_SET_BORDER_MODE_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SPRITE_BACKGROUND,
/* de */  IDCLS_ENABLE_SPRITE_BACKGROUND_DA,
/* de */  IDCLS_ENABLE_SPRITE_BACKGROUND_DE,
/* fr */  IDCLS_ENABLE_SPRITE_BACKGROUND_FR,
/* hu */  IDCLS_ENABLE_SPRITE_BACKGROUND_HU,
/* it */  IDCLS_ENABLE_SPRITE_BACKGROUND_IT,
/* nl */  IDCLS_ENABLE_SPRITE_BACKGROUND_NL,
/* pl */  IDCLS_ENABLE_SPRITE_BACKGROUND_PL,
/* sv */  IDCLS_ENABLE_SPRITE_BACKGROUND_SV,
/* tr */  IDCLS_ENABLE_SPRITE_BACKGROUND_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SPRITE_BACKGROUND,
/* de */  IDCLS_DISABLE_SPRITE_BACKGROUND_DA,
/* de */  IDCLS_DISABLE_SPRITE_BACKGROUND_DE,
/* fr */  IDCLS_DISABLE_SPRITE_BACKGROUND_FR,
/* hu */  IDCLS_DISABLE_SPRITE_BACKGROUND_HU,
/* it */  IDCLS_DISABLE_SPRITE_BACKGROUND_IT,
/* nl */  IDCLS_DISABLE_SPRITE_BACKGROUND_NL,
/* pl */  IDCLS_DISABLE_SPRITE_BACKGROUND_PL,
/* sv */  IDCLS_DISABLE_SPRITE_BACKGROUND_SV,
/* tr */  IDCLS_DISABLE_SPRITE_BACKGROUND_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SPRITE_SPRITE,
/* de */  IDCLS_ENABLE_SPRITE_SPRITE_DA,
/* de */  IDCLS_ENABLE_SPRITE_SPRITE_DE,
/* fr */  IDCLS_ENABLE_SPRITE_SPRITE_FR,
/* hu */  IDCLS_ENABLE_SPRITE_SPRITE_HU,
/* it */  IDCLS_ENABLE_SPRITE_SPRITE_IT,
/* nl */  IDCLS_ENABLE_SPRITE_SPRITE_NL,
/* pl */  IDCLS_ENABLE_SPRITE_SPRITE_PL,
/* sv */  IDCLS_ENABLE_SPRITE_SPRITE_SV,
/* tr */  IDCLS_ENABLE_SPRITE_SPRITE_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SPRITE_SPRITE,
/* de */  IDCLS_DISABLE_SPRITE_SPRITE_DA,
/* de */  IDCLS_DISABLE_SPRITE_SPRITE_DE,
/* fr */  IDCLS_DISABLE_SPRITE_SPRITE_FR,
/* hu */  IDCLS_DISABLE_SPRITE_SPRITE_HU,
/* it */  IDCLS_DISABLE_SPRITE_SPRITE_IT,
/* nl */  IDCLS_DISABLE_SPRITE_SPRITE_NL,
/* pl */  IDCLS_DISABLE_SPRITE_SPRITE_PL,
/* sv */  IDCLS_DISABLE_SPRITE_SPRITE_SV,
/* tr */  IDCLS_DISABLE_SPRITE_SPRITE_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_USE_NEW_LUMINANCES,
/* de */  IDCLS_USE_NEW_LUMINANCES_DA,
/* de */  IDCLS_USE_NEW_LUMINANCES_DE,
/* fr */  IDCLS_USE_NEW_LUMINANCES_FR,
/* hu */  IDCLS_USE_NEW_LUMINANCES_HU,
/* it */  IDCLS_USE_NEW_LUMINANCES_IT,
/* nl */  IDCLS_USE_NEW_LUMINANCES_NL,
/* pl */  IDCLS_USE_NEW_LUMINANCES_PL,
/* sv */  IDCLS_USE_NEW_LUMINANCES_SV,
/* tr */  IDCLS_USE_NEW_LUMINANCES_TR},

/* vicii/vicii-cmdline-options.c */
/* en */ {IDCLS_USE_OLD_LUMINANCES,
/* de */  IDCLS_USE_OLD_LUMINANCES_DA,
/* de */  IDCLS_USE_OLD_LUMINANCES_DE,
/* fr */  IDCLS_USE_OLD_LUMINANCES_FR,
/* hu */  IDCLS_USE_OLD_LUMINANCES_HU,
/* it */  IDCLS_USE_OLD_LUMINANCES_IT,
/* nl */  IDCLS_USE_OLD_LUMINANCES_NL,
/* pl */  IDCLS_USE_OLD_LUMINANCES_PL,
/* sv */  IDCLS_USE_OLD_LUMINANCES_SV,
/* tr */  IDCLS_USE_OLD_LUMINANCES_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DOUBLE_SIZE,
/* de */  IDCLS_ENABLE_DOUBLE_SIZE_DA,
/* de */  IDCLS_ENABLE_DOUBLE_SIZE_DE,
/* fr */  IDCLS_ENABLE_DOUBLE_SIZE_FR,
/* hu */  IDCLS_ENABLE_DOUBLE_SIZE_HU,
/* it */  IDCLS_ENABLE_DOUBLE_SIZE_IT,
/* nl */  IDCLS_ENABLE_DOUBLE_SIZE_NL,
/* pl */  IDCLS_ENABLE_DOUBLE_SIZE_PL,
/* sv */  IDCLS_ENABLE_DOUBLE_SIZE_SV,
/* tr */  IDCLS_ENABLE_DOUBLE_SIZE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DOUBLE_SIZE,
/* de */  IDCLS_DISABLE_DOUBLE_SIZE_DA,
/* de */  IDCLS_DISABLE_DOUBLE_SIZE_DE,
/* fr */  IDCLS_DISABLE_DOUBLE_SIZE_FR,
/* hu */  IDCLS_DISABLE_DOUBLE_SIZE_HU,
/* it */  IDCLS_DISABLE_DOUBLE_SIZE_IT,
/* nl */  IDCLS_DISABLE_DOUBLE_SIZE_NL,
/* pl */  IDCLS_DISABLE_DOUBLE_SIZE_PL,
/* sv */  IDCLS_DISABLE_DOUBLE_SIZE_SV,
/* tr */  IDCLS_DISABLE_DOUBLE_SIZE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DOUBLE_SCAN,
/* de */  IDCLS_ENABLE_DOUBLE_SCAN_DA,
/* de */  IDCLS_ENABLE_DOUBLE_SCAN_DE,
/* fr */  IDCLS_ENABLE_DOUBLE_SCAN_FR,
/* hu */  IDCLS_ENABLE_DOUBLE_SCAN_HU,
/* it */  IDCLS_ENABLE_DOUBLE_SCAN_IT,
/* nl */  IDCLS_ENABLE_DOUBLE_SCAN_NL,
/* pl */  IDCLS_ENABLE_DOUBLE_SCAN_PL,
/* sv */  IDCLS_ENABLE_DOUBLE_SCAN_SV,
/* tr */  IDCLS_ENABLE_DOUBLE_SCAN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DOUBLE_SCAN,
/* de */  IDCLS_DISABLE_DOUBLE_SCAN_DA,
/* de */  IDCLS_DISABLE_DOUBLE_SCAN_DE,
/* fr */  IDCLS_DISABLE_DOUBLE_SCAN_FR,
/* hu */  IDCLS_DISABLE_DOUBLE_SCAN_HU,
/* it */  IDCLS_DISABLE_DOUBLE_SCAN_IT,
/* nl */  IDCLS_DISABLE_DOUBLE_SCAN_NL,
/* pl */  IDCLS_DISABLE_DOUBLE_SCAN_PL,
/* sv */  IDCLS_DISABLE_DOUBLE_SCAN_SV,
/* tr */  IDCLS_DISABLE_DOUBLE_SCAN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_HARDWARE_SCALING,
/* de */  IDCLS_ENABLE_HARDWARE_SCALING_DA,
/* de */  IDCLS_ENABLE_HARDWARE_SCALING_DE,
/* fr */  IDCLS_ENABLE_HARDWARE_SCALING_FR,
/* hu */  IDCLS_ENABLE_HARDWARE_SCALING_HU,
/* it */  IDCLS_ENABLE_HARDWARE_SCALING_IT,
/* nl */  IDCLS_ENABLE_HARDWARE_SCALING_NL,
/* pl */  IDCLS_ENABLE_HARDWARE_SCALING_PL,
/* sv */  IDCLS_ENABLE_HARDWARE_SCALING_SV,
/* tr */  IDCLS_ENABLE_HARDWARE_SCALING_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_HARDWARE_SCALING,
/* de */  IDCLS_DISABLE_HARDWARE_SCALING_DA,
/* de */  IDCLS_DISABLE_HARDWARE_SCALING_DE,
/* fr */  IDCLS_DISABLE_HARDWARE_SCALING_FR,
/* hu */  IDCLS_DISABLE_HARDWARE_SCALING_HU,
/* it */  IDCLS_DISABLE_HARDWARE_SCALING_IT,
/* nl */  IDCLS_DISABLE_HARDWARE_SCALING_NL,
/* pl */  IDCLS_DISABLE_HARDWARE_SCALING_PL,
/* sv */  IDCLS_DISABLE_HARDWARE_SCALING_SV,
/* tr */  IDCLS_DISABLE_HARDWARE_SCALING_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_SCALE2X,
/* de */  IDCLS_ENABLE_SCALE2X_DA,
/* de */  IDCLS_ENABLE_SCALE2X_DE,
/* fr */  IDCLS_ENABLE_SCALE2X_FR,
/* hu */  IDCLS_ENABLE_SCALE2X_HU,
/* it */  IDCLS_ENABLE_SCALE2X_IT,
/* nl */  IDCLS_ENABLE_SCALE2X_NL,
/* pl */  IDCLS_ENABLE_SCALE2X_PL,
/* sv */  IDCLS_ENABLE_SCALE2X_SV,
/* tr */  IDCLS_ENABLE_SCALE2X_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_SCALE2X,
/* de */  IDCLS_DISABLE_SCALE2X_DA,
/* de */  IDCLS_DISABLE_SCALE2X_DE,
/* fr */  IDCLS_DISABLE_SCALE2X_FR,
/* hu */  IDCLS_DISABLE_SCALE2X_HU,
/* it */  IDCLS_DISABLE_SCALE2X_IT,
/* nl */  IDCLS_DISABLE_SCALE2X_NL,
/* pl */  IDCLS_DISABLE_SCALE2X_PL,
/* sv */  IDCLS_DISABLE_SCALE2X_SV,
/* tr */  IDCLS_DISABLE_SCALE2X_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_USE_INTERNAL_CALC_PALETTE,
/* de */  IDCLS_USE_INTERNAL_CALC_PALETTE_DA,
/* de */  IDCLS_USE_INTERNAL_CALC_PALETTE_DE,
/* fr */  IDCLS_USE_INTERNAL_CALC_PALETTE_FR,
/* hu */  IDCLS_USE_INTERNAL_CALC_PALETTE_HU,
/* it */  IDCLS_USE_INTERNAL_CALC_PALETTE_IT,
/* nl */  IDCLS_USE_INTERNAL_CALC_PALETTE_NL,
/* pl */  IDCLS_USE_INTERNAL_CALC_PALETTE_PL,
/* sv */  IDCLS_USE_INTERNAL_CALC_PALETTE_SV,
/* tr */  IDCLS_USE_INTERNAL_CALC_PALETTE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_USE_EXTERNAL_FILE_PALETTE,
/* de */  IDCLS_USE_EXTERNAL_FILE_PALETTE_DA,
/* de */  IDCLS_USE_EXTERNAL_FILE_PALETTE_DE,
/* fr */  IDCLS_USE_EXTERNAL_FILE_PALETTE_FR,
/* hu */  IDCLS_USE_EXTERNAL_FILE_PALETTE_HU,
/* it */  IDCLS_USE_EXTERNAL_FILE_PALETTE_IT,
/* nl */  IDCLS_USE_EXTERNAL_FILE_PALETTE_NL,
/* pl */  IDCLS_USE_EXTERNAL_FILE_PALETTE_PL,
/* sv */  IDCLS_USE_EXTERNAL_FILE_PALETTE_SV,
/* tr */  IDCLS_USE_EXTERNAL_FILE_PALETTE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME,
/* de */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_DA,
/* de */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_DE,
/* fr */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_FR,
/* hu */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_HU,
/* it */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_IT,
/* nl */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_NL,
/* pl */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_PL,
/* sv */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_SV,
/* tr */  IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_FULLSCREEN_MODE,
/* de */  IDCLS_ENABLE_FULLSCREEN_MODE_DA,
/* de */  IDCLS_ENABLE_FULLSCREEN_MODE_DE,
/* fr */  IDCLS_ENABLE_FULLSCREEN_MODE_FR,
/* hu */  IDCLS_ENABLE_FULLSCREEN_MODE_HU,
/* it */  IDCLS_ENABLE_FULLSCREEN_MODE_IT,
/* nl */  IDCLS_ENABLE_FULLSCREEN_MODE_NL,
/* pl */  IDCLS_ENABLE_FULLSCREEN_MODE_PL,
/* sv */  IDCLS_ENABLE_FULLSCREEN_MODE_SV,
/* tr */  IDCLS_ENABLE_FULLSCREEN_MODE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_FULLSCREEN_MODE,
/* de */  IDCLS_DISABLE_FULLSCREEN_MODE_DA,
/* de */  IDCLS_DISABLE_FULLSCREEN_MODE_DE,
/* fr */  IDCLS_DISABLE_FULLSCREEN_MODE_FR,
/* hu */  IDCLS_DISABLE_FULLSCREEN_MODE_HU,
/* it */  IDCLS_DISABLE_FULLSCREEN_MODE_IT,
/* nl */  IDCLS_DISABLE_FULLSCREEN_MODE_NL,
/* pl */  IDCLS_DISABLE_FULLSCREEN_MODE_PL,
/* sv */  IDCLS_DISABLE_FULLSCREEN_MODE_SV,
/* tr */  IDCLS_DISABLE_FULLSCREEN_MODE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_P_DEVICE,
/* de */  IDCLS_P_DEVICE_DA,
/* de */  IDCLS_P_DEVICE_DE,
/* fr */  IDCLS_P_DEVICE_FR,
/* hu */  IDCLS_P_DEVICE_HU,
/* it */  IDCLS_P_DEVICE_IT,
/* nl */  IDCLS_P_DEVICE_NL,
/* pl */  IDCLS_P_DEVICE_PL,
/* sv */  IDCLS_P_DEVICE_SV,
/* tr */  IDCLS_P_DEVICE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_SELECT_FULLSCREEN_DEVICE,
/* de */  IDCLS_SELECT_FULLSCREEN_DEVICE_DA,
/* de */  IDCLS_SELECT_FULLSCREEN_DEVICE_DE,
/* fr */  IDCLS_SELECT_FULLSCREEN_DEVICE_FR,
/* hu */  IDCLS_SELECT_FULLSCREEN_DEVICE_HU,
/* it */  IDCLS_SELECT_FULLSCREEN_DEVICE_IT,
/* nl */  IDCLS_SELECT_FULLSCREEN_DEVICE_NL,
/* pl */  IDCLS_SELECT_FULLSCREEN_DEVICE_PL,
/* sv */  IDCLS_SELECT_FULLSCREEN_DEVICE_SV,
/* tr */  IDCLS_SELECT_FULLSCREEN_DEVICE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN,
/* de */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_DA,
/* de */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_DE,
/* fr */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_FR,
/* hu */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_HU,
/* it */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_IT,
/* nl */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_NL,
/* pl */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_PL,
/* sv */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_SV,
/* tr */  IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN,
/* de */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_DA,
/* de */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_DE,
/* fr */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_FR,
/* hu */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_HU,
/* it */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_IT,
/* nl */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_NL,
/* pl */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_PL,
/* sv */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_SV,
/* tr */  IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN,
/* de */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_DA,
/* de */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_DE,
/* fr */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_FR,
/* hu */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_HU,
/* it */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_IT,
/* nl */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_NL,
/* pl */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_PL,
/* sv */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_SV,
/* tr */  IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN,
/* de */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_DA,
/* de */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_DE,
/* fr */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_FR,
/* hu */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_HU,
/* it */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_IT,
/* nl */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_NL,
/* pl */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_PL,
/* sv */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_SV,
/* tr */  IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_P_MODE,
/* de */  IDCLS_P_MODE_DA,
/* de */  IDCLS_P_MODE_DE,
/* fr */  IDCLS_P_MODE_FR,
/* hu */  IDCLS_P_MODE_HU,
/* it */  IDCLS_P_MODE_IT,
/* nl */  IDCLS_P_MODE_NL,
/* pl */  IDCLS_P_MODE_PL,
/* sv */  IDCLS_P_MODE_SV,
/* tr */  IDCLS_P_MODE_TR},

/* video/video-cmdline-options.c */
/* en */ {IDCLS_SELECT_FULLSCREEN_MODE,
/* de */  IDCLS_SELECT_FULLSCREEN_MODE_DA,
/* de */  IDCLS_SELECT_FULLSCREEN_MODE_DE,
/* fr */  IDCLS_SELECT_FULLSCREEN_MODE_FR,
/* hu */  IDCLS_SELECT_FULLSCREEN_MODE_HU,
/* it */  IDCLS_SELECT_FULLSCREEN_MODE_IT,
/* nl */  IDCLS_SELECT_FULLSCREEN_MODE_NL,
/* pl */  IDCLS_SELECT_FULLSCREEN_MODE_PL,
/* sv */  IDCLS_SELECT_FULLSCREEN_MODE_SV,
/* tr */  IDCLS_SELECT_FULLSCREEN_MODE_TR},

/* aciacore.c */
/* en */ {IDCLS_SPECIFY_ACIA_RS232_DEVICE,
/* de */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_DA,
/* de */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_DE,
/* fr */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_FR,
/* hu */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_HU,
/* it */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_IT,
/* nl */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_NL,
/* pl */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_PL,
/* sv */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_SV,
/* tr */  IDCLS_SPECIFY_ACIA_RS232_DEVICE_TR},

/* attach.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_8,
/* de */  IDCLS_SET_DEVICE_TYPE_8_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_8_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_8_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_8_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_8_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_8_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_8_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_8_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_8_TR},

/* attach.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_9,
/* de */  IDCLS_SET_DEVICE_TYPE_9_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_9_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_9_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_9_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_9_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_9_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_9_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_9_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_9_TR},

/* attach.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_10,
/* de */  IDCLS_SET_DEVICE_TYPE_10_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_10_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_10_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_10_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_10_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_10_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_10_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_10_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_10_TR},

/* attach.c */
/* en */ {IDCLS_SET_DEVICE_TYPE_11,
/* de */  IDCLS_SET_DEVICE_TYPE_11_DA,
/* de */  IDCLS_SET_DEVICE_TYPE_11_DE,
/* fr */  IDCLS_SET_DEVICE_TYPE_11_FR,
/* hu */  IDCLS_SET_DEVICE_TYPE_11_HU,
/* it */  IDCLS_SET_DEVICE_TYPE_11_IT,
/* nl */  IDCLS_SET_DEVICE_TYPE_11_NL,
/* pl */  IDCLS_SET_DEVICE_TYPE_11_PL,
/* sv */  IDCLS_SET_DEVICE_TYPE_11_SV,
/* tr */  IDCLS_SET_DEVICE_TYPE_11_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_ONLY_8,
/* de */  IDCLS_ATTACH_READ_ONLY_8_DA,
/* de */  IDCLS_ATTACH_READ_ONLY_8_DE,
/* fr */  IDCLS_ATTACH_READ_ONLY_8_FR,
/* hu */  IDCLS_ATTACH_READ_ONLY_8_HU,
/* it */  IDCLS_ATTACH_READ_ONLY_8_IT,
/* nl */  IDCLS_ATTACH_READ_ONLY_8_NL,
/* pl */  IDCLS_ATTACH_READ_ONLY_8_PL,
/* sv */  IDCLS_ATTACH_READ_ONLY_8_SV,
/* tr */  IDCLS_ATTACH_READ_ONLY_8_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_WRITE_8,
/* de */  IDCLS_ATTACH_READ_WRITE_8_DA,
/* de */  IDCLS_ATTACH_READ_WRITE_8_DE,
/* fr */  IDCLS_ATTACH_READ_WRITE_8_FR,
/* hu */  IDCLS_ATTACH_READ_WRITE_8_HU,
/* it */  IDCLS_ATTACH_READ_WRITE_8_IT,
/* nl */  IDCLS_ATTACH_READ_WRITE_8_NL,
/* pl */  IDCLS_ATTACH_READ_WRITE_8_PL,
/* sv */  IDCLS_ATTACH_READ_WRITE_8_SV,
/* tr */  IDCLS_ATTACH_READ_WRITE_8_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_ONLY_9,
/* de */  IDCLS_ATTACH_READ_ONLY_9_DA,
/* de */  IDCLS_ATTACH_READ_ONLY_9_DE,
/* fr */  IDCLS_ATTACH_READ_ONLY_9_FR,
/* hu */  IDCLS_ATTACH_READ_ONLY_9_HU,
/* it */  IDCLS_ATTACH_READ_ONLY_9_IT,
/* nl */  IDCLS_ATTACH_READ_ONLY_9_NL,
/* pl */  IDCLS_ATTACH_READ_ONLY_9_PL,
/* sv */  IDCLS_ATTACH_READ_ONLY_9_SV,
/* tr */  IDCLS_ATTACH_READ_ONLY_9_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_WRITE_9,
/* de */  IDCLS_ATTACH_READ_WRITE_9_DA,
/* de */  IDCLS_ATTACH_READ_WRITE_9_DE,
/* fr */  IDCLS_ATTACH_READ_WRITE_9_FR,
/* hu */  IDCLS_ATTACH_READ_WRITE_9_HU,
/* it */  IDCLS_ATTACH_READ_WRITE_9_IT,
/* nl */  IDCLS_ATTACH_READ_WRITE_9_NL,
/* pl */  IDCLS_ATTACH_READ_WRITE_9_PL,
/* sv */  IDCLS_ATTACH_READ_WRITE_9_SV,
/* tr */  IDCLS_ATTACH_READ_WRITE_9_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_ONLY_10,
/* de */  IDCLS_ATTACH_READ_ONLY_10_DA,
/* de */  IDCLS_ATTACH_READ_ONLY_10_DE,
/* fr */  IDCLS_ATTACH_READ_ONLY_10_FR,
/* hu */  IDCLS_ATTACH_READ_ONLY_10_HU,
/* it */  IDCLS_ATTACH_READ_ONLY_10_IT,
/* nl */  IDCLS_ATTACH_READ_ONLY_10_NL,
/* pl */  IDCLS_ATTACH_READ_ONLY_10_PL,
/* sv */  IDCLS_ATTACH_READ_ONLY_10_SV,
/* tr */  IDCLS_ATTACH_READ_ONLY_10_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_WRITE_10,
/* de */  IDCLS_ATTACH_READ_WRITE_10_DA,
/* de */  IDCLS_ATTACH_READ_WRITE_10_DE,
/* fr */  IDCLS_ATTACH_READ_WRITE_10_FR,
/* hu */  IDCLS_ATTACH_READ_WRITE_10_HU,
/* it */  IDCLS_ATTACH_READ_WRITE_10_IT,
/* nl */  IDCLS_ATTACH_READ_WRITE_10_NL,
/* pl */  IDCLS_ATTACH_READ_WRITE_10_PL,
/* sv */  IDCLS_ATTACH_READ_WRITE_10_SV,
/* tr */  IDCLS_ATTACH_READ_WRITE_10_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_ONLY_11,
/* de */  IDCLS_ATTACH_READ_ONLY_11_DA,
/* de */  IDCLS_ATTACH_READ_ONLY_11_DE,
/* fr */  IDCLS_ATTACH_READ_ONLY_11_FR,
/* hu */  IDCLS_ATTACH_READ_ONLY_11_HU,
/* it */  IDCLS_ATTACH_READ_ONLY_11_IT,
/* nl */  IDCLS_ATTACH_READ_ONLY_11_NL,
/* pl */  IDCLS_ATTACH_READ_ONLY_11_PL,
/* sv */  IDCLS_ATTACH_READ_ONLY_11_SV,
/* tr */  IDCLS_ATTACH_READ_ONLY_11_TR},

/* attach.c */
/* en */ {IDCLS_ATTACH_READ_WRITE_11,
/* de */  IDCLS_ATTACH_READ_WRITE_11_DA,
/* de */  IDCLS_ATTACH_READ_WRITE_11_DE,
/* fr */  IDCLS_ATTACH_READ_WRITE_11_FR,
/* hu */  IDCLS_ATTACH_READ_WRITE_11_HU,
/* it */  IDCLS_ATTACH_READ_WRITE_11_IT,
/* nl */  IDCLS_ATTACH_READ_WRITE_11_NL,
/* pl */  IDCLS_ATTACH_READ_WRITE_11_PL,
/* sv */  IDCLS_ATTACH_READ_WRITE_11_SV,
/* tr */  IDCLS_ATTACH_READ_WRITE_11_TR},

/* datasette.c */
/* en */ {IDCLS_ENABLE_AUTO_DATASETTE_RESET,
/* de */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_DA,
/* de */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_DE,
/* fr */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_FR,
/* hu */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_HU,
/* it */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_IT,
/* nl */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_NL,
/* pl */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_PL,
/* sv */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_SV,
/* tr */  IDCLS_ENABLE_AUTO_DATASETTE_RESET_TR},

/* datasette.c */
/* en */ {IDCLS_DISABLE_AUTO_DATASETTE_RESET,
/* de */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_DA,
/* de */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_DE,
/* fr */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_FR,
/* hu */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_HU,
/* it */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_IT,
/* nl */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_NL,
/* pl */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_PL,
/* sv */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_SV,
/* tr */  IDCLS_DISABLE_AUTO_DATASETTE_RESET_TR},

/* datasette.c */
/* en */ {IDCLS_SET_ZERO_TAP_DELAY,
/* de */  IDCLS_SET_ZERO_TAP_DELAY_DA,
/* de */  IDCLS_SET_ZERO_TAP_DELAY_DE,
/* fr */  IDCLS_SET_ZERO_TAP_DELAY_FR,
/* hu */  IDCLS_SET_ZERO_TAP_DELAY_HU,
/* it */  IDCLS_SET_ZERO_TAP_DELAY_IT,
/* nl */  IDCLS_SET_ZERO_TAP_DELAY_NL,
/* pl */  IDCLS_SET_ZERO_TAP_DELAY_PL,
/* sv */  IDCLS_SET_ZERO_TAP_DELAY_SV,
/* tr */  IDCLS_SET_ZERO_TAP_DELAY_TR},

/* datasette.c */
/* en */ {IDCLS_SET_CYCLES_ADDED_GAP_TAP,
/* de */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_DA,
/* de */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_DE,
/* fr */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_FR,
/* hu */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_HU,
/* it */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_IT,
/* nl */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_NL,
/* pl */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_PL,
/* sv */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_SV,
/* tr */  IDCLS_SET_CYCLES_ADDED_GAP_TAP_TR},

#ifdef DEBUG
/* debug.c */
/* en */ {IDCLS_TRACE_MAIN_CPU,
/* de */  IDCLS_TRACE_MAIN_CPU_DA,
/* de */  IDCLS_TRACE_MAIN_CPU_DE,
/* fr */  IDCLS_TRACE_MAIN_CPU_FR,
/* hu */  IDCLS_TRACE_MAIN_CPU_HU,
/* it */  IDCLS_TRACE_MAIN_CPU_IT,
/* nl */  IDCLS_TRACE_MAIN_CPU_NL,
/* pl */  IDCLS_TRACE_MAIN_CPU_PL,
/* sv */  IDCLS_TRACE_MAIN_CPU_SV,
/* tr */  IDCLS_TRACE_MAIN_CPU_TR},

/* debug.c */
/* en */ {IDCLS_DONT_TRACE_MAIN_CPU,
/* de */  IDCLS_DONT_TRACE_MAIN_CPU_DA,
/* de */  IDCLS_DONT_TRACE_MAIN_CPU_DE,
/* fr */  IDCLS_DONT_TRACE_MAIN_CPU_FR,
/* hu */  IDCLS_DONT_TRACE_MAIN_CPU_HU,
/* it */  IDCLS_DONT_TRACE_MAIN_CPU_IT,
/* nl */  IDCLS_DONT_TRACE_MAIN_CPU_NL,
/* pl */  IDCLS_DONT_TRACE_MAIN_CPU_PL,
/* sv */  IDCLS_DONT_TRACE_MAIN_CPU_SV,
/* tr */  IDCLS_DONT_TRACE_MAIN_CPU_TR},

/* debug.c */
/* en */ {IDCLS_TRACE_DRIVE0_CPU,
/* de */  IDCLS_TRACE_DRIVE0_CPU_DA,
/* de */  IDCLS_TRACE_DRIVE0_CPU_DE,
/* fr */  IDCLS_TRACE_DRIVE0_CPU_FR,
/* hu */  IDCLS_TRACE_DRIVE0_CPU_HU,
/* it */  IDCLS_TRACE_DRIVE0_CPU_IT,
/* nl */  IDCLS_TRACE_DRIVE0_CPU_NL,
/* pl */  IDCLS_TRACE_DRIVE0_CPU_PL,
/* sv */  IDCLS_TRACE_DRIVE0_CPU_SV,
/* tr */  IDCLS_TRACE_DRIVE0_CPU_TR},

/* debug.c */
/* en */ {IDCLS_DONT_TRACE_DRIVE0_CPU,
/* de */  IDCLS_DONT_TRACE_DRIVE0_CPU_DA,
/* de */  IDCLS_DONT_TRACE_DRIVE0_CPU_DE,
/* fr */  IDCLS_DONT_TRACE_DRIVE0_CPU_FR,
/* hu */  IDCLS_DONT_TRACE_DRIVE0_CPU_HU,
/* it */  IDCLS_DONT_TRACE_DRIVE0_CPU_IT,
/* nl */  IDCLS_DONT_TRACE_DRIVE0_CPU_NL,
/* pl */  IDCLS_DONT_TRACE_DRIVE0_CPU_PL,
/* sv */  IDCLS_DONT_TRACE_DRIVE0_CPU_SV,
/* tr */  IDCLS_DONT_TRACE_DRIVE0_CPU_TR},

/* debug.c */
/* en */ {IDCLS_TRACE_DRIVE1_CPU,
/* de */  IDCLS_TRACE_DRIVE1_CPU_DA,
/* de */  IDCLS_TRACE_DRIVE1_CPU_DE,
/* fr */  IDCLS_TRACE_DRIVE1_CPU_FR,
/* hu */  IDCLS_TRACE_DRIVE1_CPU_HU,
/* it */  IDCLS_TRACE_DRIVE1_CPU_IT,
/* nl */  IDCLS_TRACE_DRIVE1_CPU_NL,
/* pl */  IDCLS_TRACE_DRIVE1_CPU_PL,
/* sv */  IDCLS_TRACE_DRIVE1_CPU_SV,
/* tr */  IDCLS_TRACE_DRIVE1_CPU_TR},

/* debug.c */
/* en */ {IDCLS_DONT_TRACE_DRIVE1_CPU,
/* de */  IDCLS_DONT_TRACE_DRIVE1_CPU_DA,
/* de */  IDCLS_DONT_TRACE_DRIVE1_CPU_DE,
/* fr */  IDCLS_DONT_TRACE_DRIVE1_CPU_FR,
/* hu */  IDCLS_DONT_TRACE_DRIVE1_CPU_HU,
/* it */  IDCLS_DONT_TRACE_DRIVE1_CPU_IT,
/* nl */  IDCLS_DONT_TRACE_DRIVE1_CPU_NL,
/* pl */  IDCLS_DONT_TRACE_DRIVE1_CPU_PL,
/* sv */  IDCLS_DONT_TRACE_DRIVE1_CPU_SV,
/* tr */  IDCLS_DONT_TRACE_DRIVE1_CPU_TR},

#if DRIVE_NUM > 2
/* debug.c */
/* en */ {IDCLS_TRACE_DRIVE2_CPU,
/* de */  IDCLS_TRACE_DRIVE2_CPU_DA,
/* de */  IDCLS_TRACE_DRIVE2_CPU_DE,
/* fr */  IDCLS_TRACE_DRIVE2_CPU_FR,
/* hu */  IDCLS_TRACE_DRIVE2_CPU_HU,
/* it */  IDCLS_TRACE_DRIVE2_CPU_IT,
/* nl */  IDCLS_TRACE_DRIVE2_CPU_NL,
/* pl */  IDCLS_TRACE_DRIVE2_CPU_PL,
/* sv */  IDCLS_TRACE_DRIVE2_CPU_SV,
/* tr */  IDCLS_TRACE_DRIVE2_CPU_TR},

/* debug.c */
/* en */ {IDCLS_DONT_TRACE_DRIVE2_CPU,
/* de */  IDCLS_DONT_TRACE_DRIVE2_CPU_DA,
/* de */  IDCLS_DONT_TRACE_DRIVE2_CPU_DE,
/* fr */  IDCLS_DONT_TRACE_DRIVE2_CPU_FR,
/* hu */  IDCLS_DONT_TRACE_DRIVE2_CPU_HU,
/* it */  IDCLS_DONT_TRACE_DRIVE2_CPU_IT,
/* nl */  IDCLS_DONT_TRACE_DRIVE2_CPU_NL,
/* pl */  IDCLS_DONT_TRACE_DRIVE2_CPU_PL,
/* sv */  IDCLS_DONT_TRACE_DRIVE2_CPU_SV,
/* tr */  IDCLS_DONT_TRACE_DRIVE2_CPU_TR},
#endif   /* DRIVE_NUM > 2 */

#if DRIVE_NUM > 3
/* debug.c */
/* en */ {IDCLS_TRACE_DRIVE3_CPU,
/* de */  IDCLS_TRACE_DRIVE3_CPU_DA,
/* de */  IDCLS_TRACE_DRIVE3_CPU_DE,
/* fr */  IDCLS_TRACE_DRIVE3_CPU_FR,
/* hu */  IDCLS_TRACE_DRIVE3_CPU_HU,
/* it */  IDCLS_TRACE_DRIVE3_CPU_IT,
/* nl */  IDCLS_TRACE_DRIVE3_CPU_NL,
/* pl */  IDCLS_TRACE_DRIVE3_CPU_PL,
/* sv */  IDCLS_TRACE_DRIVE3_CPU_SV,
/* tr */  IDCLS_TRACE_DRIVE3_CPU_TR},

/* debug.c */
/* en */ {IDCLS_DONT_TRACE_DRIVE3_CPU,
/* de */  IDCLS_DONT_TRACE_DRIVE3_CPU_DA,
/* de */  IDCLS_DONT_TRACE_DRIVE3_CPU_DE,
/* fr */  IDCLS_DONT_TRACE_DRIVE3_CPU_FR,
/* hu */  IDCLS_DONT_TRACE_DRIVE3_CPU_HU,
/* it */  IDCLS_DONT_TRACE_DRIVE3_CPU_IT,
/* nl */  IDCLS_DONT_TRACE_DRIVE3_CPU_NL,
/* pl */  IDCLS_DONT_TRACE_DRIVE3_CPU_PL,
/* sv */  IDCLS_DONT_TRACE_DRIVE3_CPU_SV,
/* tr */  IDCLS_DONT_TRACE_DRIVE3_CPU_TR},
#endif   /* DRIVE_NUM > 3 */

/* debug.c */
/* en */ {IDCLS_TRACE_MODE,
/* de */  IDCLS_TRACE_MODE_DA,
/* de */  IDCLS_TRACE_MODE_DE,
/* fr */  IDCLS_TRACE_MODE_FR,
/* hu */  IDCLS_TRACE_MODE_HU,
/* it */  IDCLS_TRACE_MODE_IT,
/* nl */  IDCLS_TRACE_MODE_NL,
/* pl */  IDCLS_TRACE_MODE_PL,
/* sv */  IDCLS_TRACE_MODE_SV,
/* tr */  IDCLS_TRACE_MODE_TR},
#endif   /* DEBUG */

/* event.c */
/* en */ {IDCLS_PLAYBACK_RECORDED_EVENTS,
/* de */  IDCLS_PLAYBACK_RECORDED_EVENTS_DA,
/* de */  IDCLS_PLAYBACK_RECORDED_EVENTS_DE,
/* fr */  IDCLS_PLAYBACK_RECORDED_EVENTS_FR,
/* hu */  IDCLS_PLAYBACK_RECORDED_EVENTS_HU,
/* it */  IDCLS_PLAYBACK_RECORDED_EVENTS_IT,
/* nl */  IDCLS_PLAYBACK_RECORDED_EVENTS_NL,
/* pl */  IDCLS_PLAYBACK_RECORDED_EVENTS_PL,
/* sv */  IDCLS_PLAYBACK_RECORDED_EVENTS_SV,
/* tr */  IDCLS_PLAYBACK_RECORDED_EVENTS_TR},

/* monitor.c */
/* en */ {IDCLS_EXECUTE_MONITOR_FROM_FILE,
/* de */  IDCLS_EXECUTE_MONITOR_FROM_FILE_DA,
/* de */  IDCLS_EXECUTE_MONITOR_FROM_FILE_DE,
/* fr */  IDCLS_EXECUTE_MONITOR_FROM_FILE_FR,
/* hu */  IDCLS_EXECUTE_MONITOR_FROM_FILE_HU,
/* it */  IDCLS_EXECUTE_MONITOR_FROM_FILE_IT,
/* nl */  IDCLS_EXECUTE_MONITOR_FROM_FILE_NL,
/* pl */  IDCLS_EXECUTE_MONITOR_FROM_FILE_PL,
/* sv */  IDCLS_EXECUTE_MONITOR_FROM_FILE_SV,
/* tr */  IDCLS_EXECUTE_MONITOR_FROM_FILE_TR},

/* monitor.c */
/* en */ {IDCLS_SET_INITIAL_BREAKPOINT,
/* de */  IDCLS_SET_INITIAL_BREAKPOINT_DA,
/* de */  IDCLS_SET_INITIAL_BREAKPOINT_DE,
/* fr */  IDCLS_SET_INITIAL_BREAKPOINT_FR,
/* hu */  IDCLS_SET_INITIAL_BREAKPOINT_HU,
/* it */  IDCLS_SET_INITIAL_BREAKPOINT_IT,
/* nl */  IDCLS_SET_INITIAL_BREAKPOINT_NL,
/* pl */  IDCLS_SET_INITIAL_BREAKPOINT_PL,
/* sv */  IDCLS_SET_INITIAL_BREAKPOINT_SV,
/* tr */  IDCLS_SET_INITIAL_BREAKPOINT_TR},

/* monitor_network.c */
/* en */ {IDCLS_ENABLE_REMOTE_MONITOR,
/* de */  IDCLS_ENABLE_REMOTE_MONITOR_DA,
/* de */  IDCLS_ENABLE_REMOTE_MONITOR_DE,
/* fr */  IDCLS_ENABLE_REMOTE_MONITOR_FR,
/* hu */  IDCLS_ENABLE_REMOTE_MONITOR_HU,
/* it */  IDCLS_ENABLE_REMOTE_MONITOR_IT,
/* nl */  IDCLS_ENABLE_REMOTE_MONITOR_NL,
/* pl */  IDCLS_ENABLE_REMOTE_MONITOR_PL,
/* sv */  IDCLS_ENABLE_REMOTE_MONITOR_SV,
/* tr */  IDCLS_ENABLE_REMOTE_MONITOR_TR},

/* monitor_network.c */
/* en */ {IDCLS_DISABLE_REMOTE_MONITOR,
/* de */  IDCLS_DISABLE_REMOTE_MONITOR_DA,
/* de */  IDCLS_DISABLE_REMOTE_MONITOR_DE,
/* fr */  IDCLS_DISABLE_REMOTE_MONITOR_FR,
/* hu */  IDCLS_DISABLE_REMOTE_MONITOR_HU,
/* it */  IDCLS_DISABLE_REMOTE_MONITOR_IT,
/* nl */  IDCLS_DISABLE_REMOTE_MONITOR_NL,
/* pl */  IDCLS_DISABLE_REMOTE_MONITOR_PL,
/* sv */  IDCLS_DISABLE_REMOTE_MONITOR_SV,
/* tr */  IDCLS_DISABLE_REMOTE_MONITOR_TR},

/* monitor_network.c */
/* en */ {IDCLS_REMOTE_MONITOR_ADDRESS,
/* de */  IDCLS_REMOTE_MONITOR_ADDRESS_DA,
/* de */  IDCLS_REMOTE_MONITOR_ADDRESS_DE,
/* fr */  IDCLS_REMOTE_MONITOR_ADDRESS_FR,
/* hu */  IDCLS_REMOTE_MONITOR_ADDRESS_HU,
/* it */  IDCLS_REMOTE_MONITOR_ADDRESS_IT,
/* nl */  IDCLS_REMOTE_MONITOR_ADDRESS_NL,
/* pl */  IDCLS_REMOTE_MONITOR_ADDRESS_PL,
/* sv */  IDCLS_REMOTE_MONITOR_ADDRESS_SV,
/* tr */  IDCLS_REMOTE_MONITOR_ADDRESS_TR},

/* fliplist.c */
/* en */ {IDCLS_SPECIFY_FLIP_LIST_NAME,
/* de */  IDCLS_SPECIFY_FLIP_LIST_NAME_DA,
/* de */  IDCLS_SPECIFY_FLIP_LIST_NAME_DE,
/* fr */  IDCLS_SPECIFY_FLIP_LIST_NAME_FR,
/* hu */  IDCLS_SPECIFY_FLIP_LIST_NAME_HU,
/* it */  IDCLS_SPECIFY_FLIP_LIST_NAME_IT,
/* nl */  IDCLS_SPECIFY_FLIP_LIST_NAME_NL,
/* pl */  IDCLS_SPECIFY_FLIP_LIST_NAME_PL,
/* sv */  IDCLS_SPECIFY_FLIP_LIST_NAME_SV,
/* tr */  IDCLS_SPECIFY_FLIP_LIST_NAME_TR},

/* initcmdline.c */
/* en */ {IDCLS_SHOW_COMMAND_LINE_OPTIONS,
/* de */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_DA,
/* de */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_DE,
/* fr */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_FR,
/* hu */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_HU,
/* it */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_IT,
/* nl */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_NL,
/* pl */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_PL,
/* sv */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_SV,
/* tr */  IDCLS_SHOW_COMMAND_LINE_OPTIONS_TR},

#if (!defined  __OS2__ && !defined __BEOS__)
/* initcmdline.c */
/* en */ {IDCLS_CONSOLE_MODE,
/* de */  IDCLS_CONSOLE_MODE_DA,
/* de */  IDCLS_CONSOLE_MODE_DE,
/* fr */  IDCLS_CONSOLE_MODE_FR,
/* hu */  IDCLS_CONSOLE_MODE_HU,
/* it */  IDCLS_CONSOLE_MODE_IT,
/* nl */  IDCLS_CONSOLE_MODE_NL,
/* pl */  IDCLS_CONSOLE_MODE_PL,
/* sv */  IDCLS_CONSOLE_MODE_SV,
/* tr */  IDCLS_CONSOLE_MODE_TR},

/* initcmdline.c */
/* en */ {IDCLS_ALLOW_CORE_DUMPS,
/* de */  IDCLS_ALLOW_CORE_DUMPS_DA,
/* de */  IDCLS_ALLOW_CORE_DUMPS_DE,
/* fr */  IDCLS_ALLOW_CORE_DUMPS_FR,
/* hu */  IDCLS_ALLOW_CORE_DUMPS_HU,
/* it */  IDCLS_ALLOW_CORE_DUMPS_IT,
/* nl */  IDCLS_ALLOW_CORE_DUMPS_NL,
/* pl */  IDCLS_ALLOW_CORE_DUMPS_PL,
/* sv */  IDCLS_ALLOW_CORE_DUMPS_SV,
/* tr */  IDCLS_ALLOW_CORE_DUMPS_TR},

/* initcmdline.c */
/* en */ {IDCLS_DONT_ALLOW_CORE_DUMPS,
/* de */  IDCLS_DONT_ALLOW_CORE_DUMPS_DA,
/* de */  IDCLS_DONT_ALLOW_CORE_DUMPS_DE,
/* fr */  IDCLS_DONT_ALLOW_CORE_DUMPS_FR,
/* hu */  IDCLS_DONT_ALLOW_CORE_DUMPS_HU,
/* it */  IDCLS_DONT_ALLOW_CORE_DUMPS_IT,
/* nl */  IDCLS_DONT_ALLOW_CORE_DUMPS_NL,
/* pl */  IDCLS_DONT_ALLOW_CORE_DUMPS_PL,
/* sv */  IDCLS_DONT_ALLOW_CORE_DUMPS_SV,
/* tr */  IDCLS_DONT_ALLOW_CORE_DUMPS_TR},
#else
/* initcmdline.c */
/* en */ {IDCLS_DONT_CALL_EXCEPTION_HANDLER,
/* de */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_DA,
/* de */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_DE,
/* fr */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_FR,
/* hu */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_HU,
/* it */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_IT,
/* nl */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_NL,
/* pl */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_PL,
/* sv */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_SV,
/* tr */  IDCLS_DONT_CALL_EXCEPTION_HANDLER_TR},

/* initcmdline.c */
/* en */ {IDCLS_CALL_EXCEPTION_HANDLER,
/* de */  IDCLS_CALL_EXCEPTION_HANDLER_DA,
/* de */  IDCLS_CALL_EXCEPTION_HANDLER_DE,
/* fr */  IDCLS_CALL_EXCEPTION_HANDLER_FR,
/* hu */  IDCLS_CALL_EXCEPTION_HANDLER_HU,
/* it */  IDCLS_CALL_EXCEPTION_HANDLER_IT,
/* nl */  IDCLS_CALL_EXCEPTION_HANDLER_NL,
/* pl */  IDCLS_CALL_EXCEPTION_HANDLER_PL,
/* sv */  IDCLS_CALL_EXCEPTION_HANDLER_SV,
/* tr */  IDCLS_CALL_EXCEPTION_HANDLER_TR},
#endif  /* __OS2__ __BEOS__ */

/* initcmdline.c */
/* en */ {IDCLS_USE_VSID_MODE,
/* de */  IDCLS_USE_VSID_MODE_DA,
/* de */  IDCLS_USE_VSID_MODE_DE,
/* fr */  IDCLS_USE_VSID_MODE_FR,
/* hu */  IDCLS_USE_VSID_MODE_HU,
/* it */  IDCLS_USE_VSID_MODE_IT,
/* nl */  IDCLS_USE_VSID_MODE_NL,
/* pl */  IDCLS_USE_VSID_MODE_PL,
/* sv */  IDCLS_USE_VSID_MODE_SV,
/* tr */  IDCLS_USE_VSID_MODE_TR},

/* initcmdline.c */
/* en */ {IDCLS_RESTORE_DEFAULT_SETTINGS,
/* de */  IDCLS_RESTORE_DEFAULT_SETTINGS_DA,
/* de */  IDCLS_RESTORE_DEFAULT_SETTINGS_DE,
/* fr */  IDCLS_RESTORE_DEFAULT_SETTINGS_FR,
/* hu */  IDCLS_RESTORE_DEFAULT_SETTINGS_HU,
/* it */  IDCLS_RESTORE_DEFAULT_SETTINGS_IT,
/* nl */  IDCLS_RESTORE_DEFAULT_SETTINGS_NL,
/* pl */  IDCLS_RESTORE_DEFAULT_SETTINGS_PL,
/* sv */  IDCLS_RESTORE_DEFAULT_SETTINGS_SV,
/* tr */  IDCLS_RESTORE_DEFAULT_SETTINGS_TR},

/* initcmdline.c, c64/cart/mmcreplay.c */
/* en */ {IDCLS_P_FILE,
/* de */  IDCLS_P_FILE_DA,
/* de */  IDCLS_P_FILE_DE,
/* fr */  IDCLS_P_FILE_FR,
/* hu */  IDCLS_P_FILE_HU,
/* it */  IDCLS_P_FILE_IT,
/* nl */  IDCLS_P_FILE_NL,
/* pl */  IDCLS_P_FILE_PL,
/* sv */  IDCLS_P_FILE_SV,
/* tr */  IDCLS_P_FILE_TR},

/* initcmdline.c */
/* en */ {IDCLS_SPECIFY_CONFIG_FILE,
/* de */  IDCLS_SPECIFY_CONFIG_FILE_DA,
/* de */  IDCLS_SPECIFY_CONFIG_FILE_DE,
/* fr */  IDCLS_SPECIFY_CONFIG_FILE_FR,
/* hu */  IDCLS_SPECIFY_CONFIG_FILE_HU,
/* it */  IDCLS_SPECIFY_CONFIG_FILE_IT,
/* nl */  IDCLS_SPECIFY_CONFIG_FILE_NL,
/* pl */  IDCLS_SPECIFY_CONFIG_FILE_PL,
/* sv */  IDCLS_SPECIFY_CONFIG_FILE_SV,
/* tr */  IDCLS_SPECIFY_CONFIG_FILE_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AND_AUTOSTART,
/* de */  IDCLS_ATTACH_AND_AUTOSTART_DA,
/* de */  IDCLS_ATTACH_AND_AUTOSTART_DE,
/* fr */  IDCLS_ATTACH_AND_AUTOSTART_FR,
/* hu */  IDCLS_ATTACH_AND_AUTOSTART_HU,
/* it */  IDCLS_ATTACH_AND_AUTOSTART_IT,
/* nl */  IDCLS_ATTACH_AND_AUTOSTART_NL,
/* pl */  IDCLS_ATTACH_AND_AUTOSTART_PL,
/* sv */  IDCLS_ATTACH_AND_AUTOSTART_SV,
/* tr */  IDCLS_ATTACH_AND_AUTOSTART_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AND_AUTOLOAD,
/* de */  IDCLS_ATTACH_AND_AUTOLOAD_DA,
/* de */  IDCLS_ATTACH_AND_AUTOLOAD_DE,
/* fr */  IDCLS_ATTACH_AND_AUTOLOAD_FR,
/* hu */  IDCLS_ATTACH_AND_AUTOLOAD_HU,
/* it */  IDCLS_ATTACH_AND_AUTOLOAD_IT,
/* nl */  IDCLS_ATTACH_AND_AUTOLOAD_NL,
/* pl */  IDCLS_ATTACH_AND_AUTOLOAD_PL,
/* sv */  IDCLS_ATTACH_AND_AUTOLOAD_SV,
/* tr */  IDCLS_ATTACH_AND_AUTOLOAD_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AS_TAPE,
/* de */  IDCLS_ATTACH_AS_TAPE_DA,
/* de */  IDCLS_ATTACH_AS_TAPE_DE,
/* fr */  IDCLS_ATTACH_AS_TAPE_FR,
/* hu */  IDCLS_ATTACH_AS_TAPE_HU,
/* it */  IDCLS_ATTACH_AS_TAPE_IT,
/* nl */  IDCLS_ATTACH_AS_TAPE_NL,
/* pl */  IDCLS_ATTACH_AS_TAPE_PL,
/* sv */  IDCLS_ATTACH_AS_TAPE_SV,
/* tr */  IDCLS_ATTACH_AS_TAPE_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AS_DISK_8,
/* de */  IDCLS_ATTACH_AS_DISK_8_DA,
/* de */  IDCLS_ATTACH_AS_DISK_8_DE,
/* fr */  IDCLS_ATTACH_AS_DISK_8_FR,
/* hu */  IDCLS_ATTACH_AS_DISK_8_HU,
/* it */  IDCLS_ATTACH_AS_DISK_8_IT,
/* nl */  IDCLS_ATTACH_AS_DISK_8_NL,
/* pl */  IDCLS_ATTACH_AS_DISK_8_PL,
/* sv */  IDCLS_ATTACH_AS_DISK_8_SV,
/* tr */  IDCLS_ATTACH_AS_DISK_8_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AS_DISK_9,
/* de */  IDCLS_ATTACH_AS_DISK_9_DA,
/* de */  IDCLS_ATTACH_AS_DISK_9_DE,
/* fr */  IDCLS_ATTACH_AS_DISK_9_FR,
/* hu */  IDCLS_ATTACH_AS_DISK_9_HU,
/* it */  IDCLS_ATTACH_AS_DISK_9_IT,
/* nl */  IDCLS_ATTACH_AS_DISK_9_NL,
/* pl */  IDCLS_ATTACH_AS_DISK_9_PL,
/* sv */  IDCLS_ATTACH_AS_DISK_9_SV,
/* tr */  IDCLS_ATTACH_AS_DISK_9_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AS_DISK_10,
/* de */  IDCLS_ATTACH_AS_DISK_10_DA,
/* de */  IDCLS_ATTACH_AS_DISK_10_DE,
/* fr */  IDCLS_ATTACH_AS_DISK_10_FR,
/* hu */  IDCLS_ATTACH_AS_DISK_10_HU,
/* it */  IDCLS_ATTACH_AS_DISK_10_IT,
/* nl */  IDCLS_ATTACH_AS_DISK_10_NL,
/* pl */  IDCLS_ATTACH_AS_DISK_10_PL,
/* sv */  IDCLS_ATTACH_AS_DISK_10_SV,
/* tr */  IDCLS_ATTACH_AS_DISK_10_TR},

/* initcmdline.c */
/* en */ {IDCLS_ATTACH_AS_DISK_11,
/* de */  IDCLS_ATTACH_AS_DISK_11_DA,
/* de */  IDCLS_ATTACH_AS_DISK_11_DE,
/* fr */  IDCLS_ATTACH_AS_DISK_11_FR,
/* hu */  IDCLS_ATTACH_AS_DISK_11_HU,
/* it */  IDCLS_ATTACH_AS_DISK_11_IT,
/* nl */  IDCLS_ATTACH_AS_DISK_11_NL,
/* pl */  IDCLS_ATTACH_AS_DISK_11_PL,
/* sv */  IDCLS_ATTACH_AS_DISK_11_SV,
/* tr */  IDCLS_ATTACH_AS_DISK_11_TR},

/* kbdbuf.c */
/* en */ {IDCLS_P_STRING,
/* de */  IDCLS_P_STRING_DA,
/* de */  IDCLS_P_STRING_DE,
/* fr */  IDCLS_P_STRING_FR,
/* hu */  IDCLS_P_STRING_HU,
/* it */  IDCLS_P_STRING_IT,
/* nl */  IDCLS_P_STRING_NL,
/* pl */  IDCLS_P_STRING_PL,
/* sv */  IDCLS_P_STRING_SV,
/* tr */  IDCLS_P_STRING_TR},

/* kbdbuf.c */
/* en */ {IDCLS_PUT_STRING_INTO_KEYBUF,
/* de */  IDCLS_PUT_STRING_INTO_KEYBUF_DA,
/* de */  IDCLS_PUT_STRING_INTO_KEYBUF_DE,
/* fr */  IDCLS_PUT_STRING_INTO_KEYBUF_FR,
/* hu */  IDCLS_PUT_STRING_INTO_KEYBUF_HU,
/* it */  IDCLS_PUT_STRING_INTO_KEYBUF_IT,
/* nl */  IDCLS_PUT_STRING_INTO_KEYBUF_NL,
/* pl */  IDCLS_PUT_STRING_INTO_KEYBUF_PL,
/* sv */  IDCLS_PUT_STRING_INTO_KEYBUF_SV,
/* tr */  IDCLS_PUT_STRING_INTO_KEYBUF_TR},

/* log.c */
/* en */ {IDCLS_SPECIFY_LOG_FILE_NAME,
/* de */  IDCLS_SPECIFY_LOG_FILE_NAME_DA,
/* de */  IDCLS_SPECIFY_LOG_FILE_NAME_DE,
/* fr */  IDCLS_SPECIFY_LOG_FILE_NAME_FR,
/* hu */  IDCLS_SPECIFY_LOG_FILE_NAME_HU,
/* it */  IDCLS_SPECIFY_LOG_FILE_NAME_IT,
/* nl */  IDCLS_SPECIFY_LOG_FILE_NAME_NL,
/* pl */  IDCLS_SPECIFY_LOG_FILE_NAME_PL,
/* sv */  IDCLS_SPECIFY_LOG_FILE_NAME_SV,
/* tr */  IDCLS_SPECIFY_LOG_FILE_NAME_TR},

/* mouse.c */
/* en */ {IDCLS_ENABLE_MOUSE_GRAB,
/* de */  IDCLS_ENABLE_MOUSE_GRAB_DA,
/* de */  IDCLS_ENABLE_MOUSE_GRAB_DE,
/* fr */  IDCLS_ENABLE_MOUSE_GRAB_FR,
/* hu */  IDCLS_ENABLE_MOUSE_GRAB_HU,
/* it */  IDCLS_ENABLE_MOUSE_GRAB_IT,
/* nl */  IDCLS_ENABLE_MOUSE_GRAB_NL,
/* pl */  IDCLS_ENABLE_MOUSE_GRAB_PL,
/* sv */  IDCLS_ENABLE_MOUSE_GRAB_SV,
/* tr */  IDCLS_ENABLE_MOUSE_GRAB_TR},

/* mouse.c */
/* en */ {IDCLS_DISABLE_MOUSE_GRAB,
/* de */  IDCLS_DISABLE_MOUSE_GRAB_DA,
/* de */  IDCLS_DISABLE_MOUSE_GRAB_DE,
/* fr */  IDCLS_DISABLE_MOUSE_GRAB_FR,
/* hu */  IDCLS_DISABLE_MOUSE_GRAB_HU,
/* it */  IDCLS_DISABLE_MOUSE_GRAB_IT,
/* nl */  IDCLS_DISABLE_MOUSE_GRAB_NL,
/* pl */  IDCLS_DISABLE_MOUSE_GRAB_PL,
/* sv */  IDCLS_DISABLE_MOUSE_GRAB_SV,
/* tr */  IDCLS_DISABLE_MOUSE_GRAB_TR},

/* mouse.c */
/* en */ {IDCLS_SELECT_MOUSE_JOY_PORT,
/* de */  IDCLS_SELECT_MOUSE_JOY_PORT_DA,
/* de */  IDCLS_SELECT_MOUSE_JOY_PORT_DE,
/* fr */  IDCLS_SELECT_MOUSE_JOY_PORT_FR,
/* hu */  IDCLS_SELECT_MOUSE_JOY_PORT_HU,
/* it */  IDCLS_SELECT_MOUSE_JOY_PORT_IT,
/* nl */  IDCLS_SELECT_MOUSE_JOY_PORT_NL,
/* pl */  IDCLS_SELECT_MOUSE_JOY_PORT_PL,
/* sv */  IDCLS_SELECT_MOUSE_JOY_PORT_SV,
/* tr */  IDCLS_SELECT_MOUSE_JOY_PORT_TR},

/* ps2mouse.c */
/* en */ {IDCLS_ENABLE_PS2MOUSE,
/* de */  IDCLS_ENABLE_PS2MOUSE_DA,
/* de */  IDCLS_ENABLE_PS2MOUSE_DE,
/* fr */  IDCLS_ENABLE_PS2MOUSE_FR,
/* hu */  IDCLS_ENABLE_PS2MOUSE_HU,
/* it */  IDCLS_ENABLE_PS2MOUSE_IT,
/* nl */  IDCLS_ENABLE_PS2MOUSE_NL,
/* pl */  IDCLS_ENABLE_PS2MOUSE_PL,
/* sv */  IDCLS_ENABLE_PS2MOUSE_SV,
/* tr */  IDCLS_ENABLE_PS2MOUSE_TR},

/* ps2mouse.c */
/* en */ {IDCLS_DISABLE_PS2MOUSE,
/* de */  IDCLS_DISABLE_PS2MOUSE_DA,
/* de */  IDCLS_DISABLE_PS2MOUSE_DE,
/* fr */  IDCLS_DISABLE_PS2MOUSE_FR,
/* hu */  IDCLS_DISABLE_PS2MOUSE_HU,
/* it */  IDCLS_DISABLE_PS2MOUSE_IT,
/* nl */  IDCLS_DISABLE_PS2MOUSE_NL,
/* pl */  IDCLS_DISABLE_PS2MOUSE_PL,
/* sv */  IDCLS_DISABLE_PS2MOUSE_SV,
/* tr */  IDCLS_DISABLE_PS2MOUSE_TR},

/* ram.c */
/* en */ {IDCLS_SET_FIRST_RAM_ADDRESS_VALUE,
/* de */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_DA,
/* de */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_DE,
/* fr */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_FR,
/* hu */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_HU,
/* it */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_IT,
/* nl */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_NL,
/* pl */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_PL,
/* sv */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_SV,
/* tr */  IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_TR},

/* mouse.c */
/* en */ {IDCLS_SELECT_MOUSE_TYPE,
/* de */  IDCLS_SELECT_MOUSE_TYPE_DA,
/* de */  IDCLS_SELECT_MOUSE_TYPE_DE,
/* fr */  IDCLS_SELECT_MOUSE_TYPE_FR,
/* hu */  IDCLS_SELECT_MOUSE_TYPE_HU,
/* it */  IDCLS_SELECT_MOUSE_TYPE_IT,
/* nl */  IDCLS_SELECT_MOUSE_TYPE_NL,
/* pl */  IDCLS_SELECT_MOUSE_TYPE_PL,
/* sv */  IDCLS_SELECT_MOUSE_TYPE_SV,
/* tr */  IDCLS_SELECT_MOUSE_TYPE_TR},

/* ram.c */
/* en */ {IDCLS_P_NUM_OF_BYTES,
/* de */  IDCLS_P_NUM_OF_BYTES_DA,
/* de */  IDCLS_P_NUM_OF_BYTES_DE,
/* fr */  IDCLS_P_NUM_OF_BYTES_FR,
/* hu */  IDCLS_P_NUM_OF_BYTES_HU,
/* it */  IDCLS_P_NUM_OF_BYTES_IT,
/* nl */  IDCLS_P_NUM_OF_BYTES_NL,
/* pl */  IDCLS_P_NUM_OF_BYTES_PL,
/* sv */  IDCLS_P_NUM_OF_BYTES_SV,
/* tr */  IDCLS_P_NUM_OF_BYTES_TR},

/* ram.c */
/* en */ {IDCLS_LENGTH_BLOCK_SAME_VALUE,
/* de */  IDCLS_LENGTH_BLOCK_SAME_VALUE_DA,
/* de */  IDCLS_LENGTH_BLOCK_SAME_VALUE_DE,
/* fr */  IDCLS_LENGTH_BLOCK_SAME_VALUE_FR,
/* hu */  IDCLS_LENGTH_BLOCK_SAME_VALUE_HU,
/* it */  IDCLS_LENGTH_BLOCK_SAME_VALUE_IT,
/* nl */  IDCLS_LENGTH_BLOCK_SAME_VALUE_NL,
/* pl */  IDCLS_LENGTH_BLOCK_SAME_VALUE_PL,
/* sv */  IDCLS_LENGTH_BLOCK_SAME_VALUE_SV,
/* tr */  IDCLS_LENGTH_BLOCK_SAME_VALUE_TR},

/* ram.c */
/* en */ {IDCLS_LENGTH_BLOCK_SAME_PATTERN,
/* de */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_DA,
/* de */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_DE,
/* fr */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_FR,
/* hu */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_HU,
/* it */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_IT,
/* nl */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_NL,
/* pl */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_PL,
/* sv */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_SV,
/* tr */  IDCLS_LENGTH_BLOCK_SAME_PATTERN_TR},

/* sound.c */
/* en */ {IDCLS_ENABLE_SOUND_PLAYBACK,
/* de */  IDCLS_ENABLE_SOUND_PLAYBACK_DA,
/* de */  IDCLS_ENABLE_SOUND_PLAYBACK_DE,
/* fr */  IDCLS_ENABLE_SOUND_PLAYBACK_FR,
/* hu */  IDCLS_ENABLE_SOUND_PLAYBACK_HU,
/* it */  IDCLS_ENABLE_SOUND_PLAYBACK_IT,
/* nl */  IDCLS_ENABLE_SOUND_PLAYBACK_NL,
/* pl */  IDCLS_ENABLE_SOUND_PLAYBACK_PL,
/* sv */  IDCLS_ENABLE_SOUND_PLAYBACK_SV,
/* tr */  IDCLS_ENABLE_SOUND_PLAYBACK_TR},

/* sound.c */
/* en */ {IDCLS_DISABLE_SOUND_PLAYBACK,
/* de */  IDCLS_DISABLE_SOUND_PLAYBACK_DA,
/* de */  IDCLS_DISABLE_SOUND_PLAYBACK_DE,
/* fr */  IDCLS_DISABLE_SOUND_PLAYBACK_FR,
/* hu */  IDCLS_DISABLE_SOUND_PLAYBACK_HU,
/* it */  IDCLS_DISABLE_SOUND_PLAYBACK_IT,
/* nl */  IDCLS_DISABLE_SOUND_PLAYBACK_NL,
/* pl */  IDCLS_DISABLE_SOUND_PLAYBACK_PL,
/* sv */  IDCLS_DISABLE_SOUND_PLAYBACK_SV,
/* tr */  IDCLS_DISABLE_SOUND_PLAYBACK_TR},

/* sound.c */
/* en */ {IDCLS_SET_SAMPLE_RATE_VALUE_HZ,
/* de */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_DA,
/* de */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_DE,
/* fr */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_FR,
/* hu */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_HU,
/* it */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_IT,
/* nl */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_NL,
/* pl */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_PL,
/* sv */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_SV,
/* tr */  IDCLS_SET_SAMPLE_RATE_VALUE_HZ_TR},

/* sound.c */
/* en */ {IDCLS_SET_SOUND_BUFFER_SIZE_MSEC,
/* de */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_DA,
/* de */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_DE,
/* fr */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_FR,
/* hu */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_HU,
/* it */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_IT,
/* nl */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_NL,
/* pl */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_PL,
/* sv */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_SV,
/* tr */  IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_TR},

/* sound.c */
/* en */ {IDCLS_SET_SOUND_FRAGMENT_SIZE,
/* de */  IDCLS_SET_SOUND_FRAGMENT_SIZE_DA,
/* de */  IDCLS_SET_SOUND_FRAGMENT_SIZE_DE,
/* fr */  IDCLS_SET_SOUND_FRAGMENT_SIZE_FR,
/* hu */  IDCLS_SET_SOUND_FRAGMENT_SIZE_HU,
/* it */  IDCLS_SET_SOUND_FRAGMENT_SIZE_IT,
/* nl */  IDCLS_SET_SOUND_FRAGMENT_SIZE_NL,
/* pl */  IDCLS_SET_SOUND_FRAGMENT_SIZE_PL,
/* sv */  IDCLS_SET_SOUND_FRAGMENT_SIZE_SV,
/* tr */  IDCLS_SET_SOUND_FRAGMENT_SIZE_TR},

/* sound.c */
/* en */ {IDCLS_SPECIFY_SOUND_DRIVER,
/* de */  IDCLS_SPECIFY_SOUND_DRIVER_DA,
/* de */  IDCLS_SPECIFY_SOUND_DRIVER_DE,
/* fr */  IDCLS_SPECIFY_SOUND_DRIVER_FR,
/* hu */  IDCLS_SPECIFY_SOUND_DRIVER_HU,
/* it */  IDCLS_SPECIFY_SOUND_DRIVER_IT,
/* nl */  IDCLS_SPECIFY_SOUND_DRIVER_NL,
/* pl */  IDCLS_SPECIFY_SOUND_DRIVER_PL,
/* sv */  IDCLS_SPECIFY_SOUND_DRIVER_SV,
/* tr */  IDCLS_SPECIFY_SOUND_DRIVER_TR},

/* sound.c */
/* en */ {IDCLS_P_ARGS,
/* de */  IDCLS_P_ARGS_DA,
/* de */  IDCLS_P_ARGS_DE,
/* fr */  IDCLS_P_ARGS_FR,
/* hu */  IDCLS_P_ARGS_HU,
/* it */  IDCLS_P_ARGS_IT,
/* nl */  IDCLS_P_ARGS_NL,
/* pl */  IDCLS_P_ARGS_PL,
/* sv */  IDCLS_P_ARGS_SV,
/* tr */  IDCLS_P_ARGS_TR},

/* sound.c */
/* en */ {IDCLS_SPECIFY_SOUND_DRIVER_PARAM,
/* de */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_DA,
/* de */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_DE,
/* fr */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_FR,
/* hu */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_HU,
/* it */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_IT,
/* nl */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_NL,
/* pl */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_PL,
/* sv */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_SV,
/* tr */  IDCLS_SPECIFY_SOUND_DRIVER_PARAM_TR},

/* sound.c */
/* en */ {IDCLS_SPECIFY_RECORDING_SOUND_DRIVER,
/* de */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_DA,
/* de */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_DE,
/* fr */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_FR,
/* hu */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_HU,
/* it */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_IT,
/* nl */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_NL,
/* pl */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_PL,
/* sv */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_SV,
/* tr */  IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_TR},

/* sound.c */
/* en */ {IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM,
/* de */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_DA,
/* de */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_DE,
/* fr */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_FR,
/* hu */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_HU,
/* it */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_IT,
/* nl */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_NL,
/* pl */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_PL,
/* sv */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_SV,
/* tr */  IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_TR},

/* sound.c */
/* en */ {IDCLS_P_SYNC,
/* de */  IDCLS_P_SYNC_DA,
/* de */  IDCLS_P_SYNC_DE,
/* fr */  IDCLS_P_SYNC_FR,
/* hu */  IDCLS_P_SYNC_HU,
/* it */  IDCLS_P_SYNC_IT,
/* nl */  IDCLS_P_SYNC_NL,
/* pl */  IDCLS_P_SYNC_PL,
/* sv */  IDCLS_P_SYNC_SV,
/* tr */  IDCLS_P_SYNC_TR},

/* sound.c */
/* en */ {IDCLS_SET_SOUND_SPEED_ADJUST,
/* de */  IDCLS_SET_SOUND_SPEED_ADJUST_DA,
/* de */  IDCLS_SET_SOUND_SPEED_ADJUST_DE,
/* fr */  IDCLS_SET_SOUND_SPEED_ADJUST_FR,
/* hu */  IDCLS_SET_SOUND_SPEED_ADJUST_HU,
/* it */  IDCLS_SET_SOUND_SPEED_ADJUST_IT,
/* nl */  IDCLS_SET_SOUND_SPEED_ADJUST_NL,
/* pl */  IDCLS_SET_SOUND_SPEED_ADJUST_PL,
/* sv */  IDCLS_SET_SOUND_SPEED_ADJUST_SV,
/* tr */  IDCLS_SET_SOUND_SPEED_ADJUST_TR},

/* sysfile.c */
/* en */ {IDCLS_P_PATH,
/* de */  IDCLS_P_PATH_DA,
/* de */  IDCLS_P_PATH_DE,
/* fr */  IDCLS_P_PATH_FR,
/* hu */  IDCLS_P_PATH_HU,
/* it */  IDCLS_P_PATH_IT,
/* nl */  IDCLS_P_PATH_NL,
/* pl */  IDCLS_P_PATH_PL,
/* sv */  IDCLS_P_PATH_SV,
/* tr */  IDCLS_P_PATH_TR},

/* sysfile.c */
/* en */ {IDCLS_DEFINE_SYSTEM_FILES_PATH,
/* de */  IDCLS_DEFINE_SYSTEM_FILES_PATH_DA,
/* de */  IDCLS_DEFINE_SYSTEM_FILES_PATH_DE,
/* fr */  IDCLS_DEFINE_SYSTEM_FILES_PATH_FR,
/* hu */  IDCLS_DEFINE_SYSTEM_FILES_PATH_HU,
/* it */  IDCLS_DEFINE_SYSTEM_FILES_PATH_IT,
/* nl */  IDCLS_DEFINE_SYSTEM_FILES_PATH_NL,
/* pl */  IDCLS_DEFINE_SYSTEM_FILES_PATH_PL,
/* sv */  IDCLS_DEFINE_SYSTEM_FILES_PATH_SV,
/* tr */  IDCLS_DEFINE_SYSTEM_FILES_PATH_TR},

/* traps.c */
/* en */ {IDCLS_ENABLE_TRAPS_FAST_EMULATION,
/* de */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_DA,
/* de */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_DE,
/* fr */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_FR,
/* hu */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_HU,
/* it */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_IT,
/* nl */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_NL,
/* pl */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_PL,
/* sv */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_SV,
/* tr */  IDCLS_ENABLE_TRAPS_FAST_EMULATION_TR},

/* traps.c */
/* en */ {IDCLS_DISABLE_TRAPS_FAST_EMULATION,
/* de */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_DA,
/* de */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_DE,
/* fr */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_FR,
/* hu */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_HU,
/* it */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_IT,
/* nl */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_NL,
/* pl */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_PL,
/* sv */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_SV,
/* tr */  IDCLS_DISABLE_TRAPS_FAST_EMULATION_TR},

/* vsync.c */
/* en */ {IDCLS_LIMIT_SPEED_TO_VALUE,
/* de */  IDCLS_LIMIT_SPEED_TO_VALUE_DA,
/* de */  IDCLS_LIMIT_SPEED_TO_VALUE_DE,
/* fr */  IDCLS_LIMIT_SPEED_TO_VALUE_FR,
/* hu */  IDCLS_LIMIT_SPEED_TO_VALUE_HU,
/* it */  IDCLS_LIMIT_SPEED_TO_VALUE_IT,
/* nl */  IDCLS_LIMIT_SPEED_TO_VALUE_NL,
/* pl */  IDCLS_LIMIT_SPEED_TO_VALUE_PL,
/* sv */  IDCLS_LIMIT_SPEED_TO_VALUE_SV,
/* tr */  IDCLS_LIMIT_SPEED_TO_VALUE_TR},

/* vsync.c */
/* en */ {IDCLS_UPDATE_EVERY_VALUE_FRAMES,
/* de */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_DA,
/* de */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_DE,
/* fr */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_FR,
/* hu */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_HU,
/* it */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_IT,
/* nl */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_NL,
/* pl */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_PL,
/* sv */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_SV,
/* tr */  IDCLS_UPDATE_EVERY_VALUE_FRAMES_TR},

/* vsync.c */
/* en */ {IDCLS_ENABLE_WARP_MODE,
/* de */  IDCLS_ENABLE_WARP_MODE_DA,
/* de */  IDCLS_ENABLE_WARP_MODE_DE,
/* fr */  IDCLS_ENABLE_WARP_MODE_FR,
/* hu */  IDCLS_ENABLE_WARP_MODE_HU,
/* it */  IDCLS_ENABLE_WARP_MODE_IT,
/* nl */  IDCLS_ENABLE_WARP_MODE_NL,
/* pl */  IDCLS_ENABLE_WARP_MODE_PL,
/* sv */  IDCLS_ENABLE_WARP_MODE_SV,
/* tr */  IDCLS_ENABLE_WARP_MODE_TR},

/* vsync.c */
/* en */ {IDCLS_DISABLE_WARP_MODE,
/* de */  IDCLS_DISABLE_WARP_MODE_DA,
/* de */  IDCLS_DISABLE_WARP_MODE_DE,
/* fr */  IDCLS_DISABLE_WARP_MODE_FR,
/* hu */  IDCLS_DISABLE_WARP_MODE_HU,
/* it */  IDCLS_DISABLE_WARP_MODE_IT,
/* nl */  IDCLS_DISABLE_WARP_MODE_NL,
/* pl */  IDCLS_DISABLE_WARP_MODE_PL,
/* sv */  IDCLS_DISABLE_WARP_MODE_SV,
/* tr */  IDCLS_DISABLE_WARP_MODE_TR},

/* translate.c */
/* en */ {IDCLS_P_ISO_LANGUAGE_CODE,
/* de */  IDCLS_P_ISO_LANGUAGE_CODE_DA,
/* de */  IDCLS_P_ISO_LANGUAGE_CODE_DE,
/* fr */  IDCLS_P_ISO_LANGUAGE_CODE_FR,
/* hu */  IDCLS_P_ISO_LANGUAGE_CODE_HU,
/* it */  IDCLS_P_ISO_LANGUAGE_CODE_IT,
/* nl */  IDCLS_P_ISO_LANGUAGE_CODE_NL,
/* pl */  IDCLS_P_ISO_LANGUAGE_CODE_PL,
/* sv */  IDCLS_P_ISO_LANGUAGE_CODE_SV,
/* tr */  IDCLS_P_ISO_LANGUAGE_CODE_TR},

/* translate.c */
/* en */ {IDCLS_SPECIFY_ISO_LANG_CODE,
/* de */  IDCLS_SPECIFY_ISO_LANG_CODE_DA,
/* de */  IDCLS_SPECIFY_ISO_LANG_CODE_DE,
/* fr */  IDCLS_SPECIFY_ISO_LANG_CODE_FR,
/* hu */  IDCLS_SPECIFY_ISO_LANG_CODE_HU,
/* it */  IDCLS_SPECIFY_ISO_LANG_CODE_IT,
/* nl */  IDCLS_SPECIFY_ISO_LANG_CODE_NL,
/* pl */  IDCLS_SPECIFY_ISO_LANG_CODE_PL,
/* sv */  IDCLS_SPECIFY_ISO_LANG_CODE_SV,
/* tr */  IDCLS_SPECIFY_ISO_LANG_CODE_TR},

/* c64/plus60k.c */
/* en */ {IDCLS_ENABLE_PLUS60K_EXPANSION,
/* de */  IDCLS_ENABLE_PLUS60K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_PLUS60K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_PLUS60K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_PLUS60K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_PLUS60K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_PLUS60K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_PLUS60K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_PLUS60K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_PLUS60K_EXPANSION_TR},

/* c64/plus60k.c */
/* en */ {IDCLS_DISABLE_PLUS60K_EXPANSION,
/* de */  IDCLS_DISABLE_PLUS60K_EXPANSION_DA,
/* de */  IDCLS_DISABLE_PLUS60K_EXPANSION_DE,
/* fr */  IDCLS_DISABLE_PLUS60K_EXPANSION_FR,
/* hu */  IDCLS_DISABLE_PLUS60K_EXPANSION_HU,
/* it */  IDCLS_DISABLE_PLUS60K_EXPANSION_IT,
/* nl */  IDCLS_DISABLE_PLUS60K_EXPANSION_NL,
/* pl */  IDCLS_DISABLE_PLUS60K_EXPANSION_PL,
/* sv */  IDCLS_DISABLE_PLUS60K_EXPANSION_SV,
/* tr */  IDCLS_DISABLE_PLUS60K_EXPANSION_TR},

/* c64/plus60k.c */
/* en */ {IDCLS_SPECIFY_PLUS60K_NAME,
/* de */  IDCLS_SPECIFY_PLUS60K_NAME_DA,
/* de */  IDCLS_SPECIFY_PLUS60K_NAME_DE,
/* fr */  IDCLS_SPECIFY_PLUS60K_NAME_FR,
/* hu */  IDCLS_SPECIFY_PLUS60K_NAME_HU,
/* it */  IDCLS_SPECIFY_PLUS60K_NAME_IT,
/* nl */  IDCLS_SPECIFY_PLUS60K_NAME_NL,
/* pl */  IDCLS_SPECIFY_PLUS60K_NAME_PL,
/* sv */  IDCLS_SPECIFY_PLUS60K_NAME_SV,
/* tr */  IDCLS_SPECIFY_PLUS60K_NAME_TR},

/* sid/sid-cmdline-options.c */
#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
/* en */ {IDCLS_RESID_GAIN_PERCENTAGE,
/* de */  IDCLS_RESID_GAIN_PERCENTAGE_DA,
/* de */  IDCLS_RESID_GAIN_PERCENTAGE_DE,
/* fr */  IDCLS_RESID_GAIN_PERCENTAGE_FR,
/* hu */  IDCLS_RESID_GAIN_PERCENTAGE_HU,
/* it */  IDCLS_RESID_GAIN_PERCENTAGE_IT,
/* nl */  IDCLS_RESID_GAIN_PERCENTAGE_NL,
/* pl */  IDCLS_RESID_GAIN_PERCENTAGE_PL,
/* sv */  IDCLS_RESID_GAIN_PERCENTAGE_SV,
/* tr */  IDCLS_RESID_GAIN_PERCENTAGE_TR},
#endif   /* HAVE_RESID */

/* c64/cart/c64cart.c */
/* en */ {IDCLS_ATTACH_RAW_STB_CART,
/* de */  IDCLS_ATTACH_RAW_STB_CART_DA,
/* de */  IDCLS_ATTACH_RAW_STB_CART_DE,
/* fr */  IDCLS_ATTACH_RAW_STB_CART_FR,
/* hu */  IDCLS_ATTACH_RAW_STB_CART_HU,
/* it */  IDCLS_ATTACH_RAW_STB_CART_IT,
/* nl */  IDCLS_ATTACH_RAW_STB_CART_NL,
/* pl */  IDCLS_ATTACH_RAW_STB_CART_PL,
/* sv */  IDCLS_ATTACH_RAW_STB_CART_SV,
/* tr */  IDCLS_ATTACH_RAW_STB_CART_TR},

/* c64/plus60k.c */
/* en */ {IDCLS_PLUS60K_BASE,
/* de */  IDCLS_PLUS60K_BASE_DA,
/* de */  IDCLS_PLUS60K_BASE_DE,
/* fr */  IDCLS_PLUS60K_BASE_FR,
/* hu */  IDCLS_PLUS60K_BASE_HU,
/* it */  IDCLS_PLUS60K_BASE_IT,
/* nl */  IDCLS_PLUS60K_BASE_NL,
/* pl */  IDCLS_PLUS60K_BASE_PL,
/* sv */  IDCLS_PLUS60K_BASE_SV,
/* tr */  IDCLS_PLUS60K_BASE_TR},

/* c64/c64_256k.c */
/* en */ {IDCLS_ENABLE_C64_256K_EXPANSION,
/* de */  IDCLS_ENABLE_C64_256K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_C64_256K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_C64_256K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_C64_256K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_C64_256K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_C64_256K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_C64_256K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_C64_256K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_C64_256K_EXPANSION_TR},

/* c64/c64_256k.c */
/* en */ {IDCLS_DISABLE_C64_256K_EXPANSION,
/* de */  IDCLS_DISABLE_C64_256K_EXPANSION_DA,
/* de */  IDCLS_DISABLE_C64_256K_EXPANSION_DE,
/* fr */  IDCLS_DISABLE_C64_256K_EXPANSION_FR,
/* hu */  IDCLS_DISABLE_C64_256K_EXPANSION_HU,
/* it */  IDCLS_DISABLE_C64_256K_EXPANSION_IT,
/* nl */  IDCLS_DISABLE_C64_256K_EXPANSION_NL,
/* pl */  IDCLS_DISABLE_C64_256K_EXPANSION_PL,
/* sv */  IDCLS_DISABLE_C64_256K_EXPANSION_SV,
/* tr */  IDCLS_DISABLE_C64_256K_EXPANSION_TR},

/* c64/c64_256k.c */
/* en */ {IDCLS_SPECIFY_C64_256K_NAME,
/* de */  IDCLS_SPECIFY_C64_256K_NAME_DA,
/* de */  IDCLS_SPECIFY_C64_256K_NAME_DE,
/* fr */  IDCLS_SPECIFY_C64_256K_NAME_FR,
/* hu */  IDCLS_SPECIFY_C64_256K_NAME_HU,
/* it */  IDCLS_SPECIFY_C64_256K_NAME_IT,
/* nl */  IDCLS_SPECIFY_C64_256K_NAME_NL,
/* pl */  IDCLS_SPECIFY_C64_256K_NAME_PL,
/* sv */  IDCLS_SPECIFY_C64_256K_NAME_SV,
/* tr */  IDCLS_SPECIFY_C64_256K_NAME_TR},

/* c64/c64_256k.c */
/* en */ {IDCLS_C64_256K_BASE,
/* de */  IDCLS_C64_256K_BASE_DA,
/* de */  IDCLS_C64_256K_BASE_DE,
/* fr */  IDCLS_C64_256K_BASE_FR,
/* hu */  IDCLS_C64_256K_BASE_HU,
/* it */  IDCLS_C64_256K_BASE_IT,
/* nl */  IDCLS_C64_256K_BASE_NL,
/* pl */  IDCLS_C64_256K_BASE_PL,
/* sv */  IDCLS_C64_256K_BASE_SV,
/* tr */  IDCLS_C64_256K_BASE_TR},

/* pet/petreu.c */
/* en */ {IDCLS_ENABLE_PETREU,
/* de */  IDCLS_ENABLE_PETREU_DA,
/* de */  IDCLS_ENABLE_PETREU_DE,
/* fr */  IDCLS_ENABLE_PETREU_FR,
/* hu */  IDCLS_ENABLE_PETREU_HU,
/* it */  IDCLS_ENABLE_PETREU_IT,
/* nl */  IDCLS_ENABLE_PETREU_NL,
/* pl */  IDCLS_ENABLE_PETREU_PL,
/* sv */  IDCLS_ENABLE_PETREU_SV,
/* tr */  IDCLS_ENABLE_PETREU_TR},

/* pet/petreu.c */
/* en */ {IDCLS_DISABLE_PETREU,
/* de */  IDCLS_DISABLE_PETREU_DA,
/* de */  IDCLS_DISABLE_PETREU_DE,
/* fr */  IDCLS_DISABLE_PETREU_FR,
/* hu */  IDCLS_DISABLE_PETREU_HU,
/* it */  IDCLS_DISABLE_PETREU_IT,
/* nl */  IDCLS_DISABLE_PETREU_NL,
/* pl */  IDCLS_DISABLE_PETREU_PL,
/* sv */  IDCLS_DISABLE_PETREU_SV,
/* tr */  IDCLS_DISABLE_PETREU_TR},

/* pet/petreu.c */
/* en */ {IDCLS_SPECIFY_PETREU_NAME,
/* de */  IDCLS_SPECIFY_PETREU_NAME_DA,
/* de */  IDCLS_SPECIFY_PETREU_NAME_DE,
/* fr */  IDCLS_SPECIFY_PETREU_NAME_FR,
/* hu */  IDCLS_SPECIFY_PETREU_NAME_HU,
/* it */  IDCLS_SPECIFY_PETREU_NAME_IT,
/* nl */  IDCLS_SPECIFY_PETREU_NAME_NL,
/* pl */  IDCLS_SPECIFY_PETREU_NAME_PL,
/* sv */  IDCLS_SPECIFY_PETREU_NAME_SV,
/* tr */  IDCLS_SPECIFY_PETREU_NAME_TR},

/* pet/petreu.c */
/* en */ {IDCLS_PETREU_SIZE,
/* de */  IDCLS_PETREU_SIZE_DA,
/* de */  IDCLS_PETREU_SIZE_DE,
/* fr */  IDCLS_PETREU_SIZE_FR,
/* hu */  IDCLS_PETREU_SIZE_HU,
/* it */  IDCLS_PETREU_SIZE_IT,
/* nl */  IDCLS_PETREU_SIZE_NL,
/* pl */  IDCLS_PETREU_SIZE_PL,
/* sv */  IDCLS_PETREU_SIZE_SV,
/* tr */  IDCLS_PETREU_SIZE_TR},

/* pet/petdww.c */
/* en */ {IDCLS_ENABLE_PETDWW,
/* de */  IDCLS_ENABLE_PETDWW_DA,
/* de */  IDCLS_ENABLE_PETDWW_DE,
/* fr */  IDCLS_ENABLE_PETDWW_FR,
/* hu */  IDCLS_ENABLE_PETDWW_HU,
/* it */  IDCLS_ENABLE_PETDWW_IT,
/* nl */  IDCLS_ENABLE_PETDWW_NL,
/* pl */  IDCLS_ENABLE_PETDWW_PL,
/* sv */  IDCLS_ENABLE_PETDWW_SV,
/* tr */  IDCLS_ENABLE_PETDWW_TR},

/* pet/petdww.c */
/* en */ {IDCLS_DISABLE_PETDWW,
/* de */  IDCLS_DISABLE_PETDWW_DA,
/* de */  IDCLS_DISABLE_PETDWW_DE,
/* fr */  IDCLS_DISABLE_PETDWW_FR,
/* hu */  IDCLS_DISABLE_PETDWW_HU,
/* it */  IDCLS_DISABLE_PETDWW_IT,
/* nl */  IDCLS_DISABLE_PETDWW_NL,
/* pl */  IDCLS_DISABLE_PETDWW_PL,
/* sv */  IDCLS_DISABLE_PETDWW_SV,
/* tr */  IDCLS_DISABLE_PETDWW_TR},

/* pet/petdww.c */
/* en */ {IDCLS_SPECIFY_PETDWW_NAME,
/* de */  IDCLS_SPECIFY_PETDWW_NAME_DA,
/* de */  IDCLS_SPECIFY_PETDWW_NAME_DE,
/* fr */  IDCLS_SPECIFY_PETDWW_NAME_FR,
/* hu */  IDCLS_SPECIFY_PETDWW_NAME_HU,
/* it */  IDCLS_SPECIFY_PETDWW_NAME_IT,
/* nl */  IDCLS_SPECIFY_PETDWW_NAME_NL,
/* pl */  IDCLS_SPECIFY_PETDWW_NAME_PL,
/* sv */  IDCLS_SPECIFY_PETDWW_NAME_SV,
/* tr */  IDCLS_SPECIFY_PETDWW_NAME_TR},

/* c64/plus256k.c */
/* en */ {IDCLS_ENABLE_PLUS256K_EXPANSION,
/* de */  IDCLS_ENABLE_PLUS256K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_PLUS256K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_PLUS256K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_PLUS256K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_PLUS256K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_PLUS256K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_PLUS256K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_PLUS256K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_PLUS256K_EXPANSION_TR},

/* c64/plus256k.c */
/* en */ {IDCLS_DISABLE_PLUS256K_EXPANSION,
/* de */  IDCLS_DISABLE_PLUS256K_EXPANSION_DA,
/* de */  IDCLS_DISABLE_PLUS256K_EXPANSION_DE,
/* fr */  IDCLS_DISABLE_PLUS256K_EXPANSION_FR,
/* hu */  IDCLS_DISABLE_PLUS256K_EXPANSION_HU,
/* it */  IDCLS_DISABLE_PLUS256K_EXPANSION_IT,
/* nl */  IDCLS_DISABLE_PLUS256K_EXPANSION_NL,
/* pl */  IDCLS_DISABLE_PLUS256K_EXPANSION_PL,
/* sv */  IDCLS_DISABLE_PLUS256K_EXPANSION_SV,
/* tr */  IDCLS_DISABLE_PLUS256K_EXPANSION_TR},

/* c64/plus256k.c */
/* en */ {IDCLS_SPECIFY_PLUS256K_NAME,
/* de */  IDCLS_SPECIFY_PLUS256K_NAME_DA,
/* de */  IDCLS_SPECIFY_PLUS256K_NAME_DE,
/* fr */  IDCLS_SPECIFY_PLUS256K_NAME_FR,
/* hu */  IDCLS_SPECIFY_PLUS256K_NAME_HU,
/* it */  IDCLS_SPECIFY_PLUS256K_NAME_IT,
/* nl */  IDCLS_SPECIFY_PLUS256K_NAME_NL,
/* pl */  IDCLS_SPECIFY_PLUS256K_NAME_PL,
/* sv */  IDCLS_SPECIFY_PLUS256K_NAME_SV,
/* tr */  IDCLS_SPECIFY_PLUS256K_NAME_TR},

/* plus4/plus4memcsory256k.c */
/* en */ {IDCLS_ENABLE_CS256K_EXPANSION,
/* de */  IDCLS_ENABLE_CS256K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_CS256K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_CS256K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_CS256K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_CS256K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_CS256K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_CS256K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_CS256K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_CS256K_EXPANSION_TR},

/* plus4/plus4memhannes256k.c */
/* en */ {IDCLS_ENABLE_H256K_EXPANSION,
/* de */  IDCLS_ENABLE_H256K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_H256K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_H256K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_H256K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_H256K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_H256K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_H256K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_H256K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_H256K_EXPANSION_TR},

/* plus4/plus4memhannes256k.c */
/* en */ {IDCLS_ENABLE_H1024K_EXPANSION,
/* de */  IDCLS_ENABLE_H1024K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_H1024K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_H1024K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_H1024K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_H1024K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_H1024K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_H1024K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_H1024K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_H1024K_EXPANSION_TR},

/* plus4/plus4memhannes256k.c */
/* en */ {IDCLS_ENABLE_H4096K_EXPANSION,
/* de */  IDCLS_ENABLE_H4096K_EXPANSION_DA,
/* de */  IDCLS_ENABLE_H4096K_EXPANSION_DE,
/* fr */  IDCLS_ENABLE_H4096K_EXPANSION_FR,
/* hu */  IDCLS_ENABLE_H4096K_EXPANSION_HU,
/* it */  IDCLS_ENABLE_H4096K_EXPANSION_IT,
/* nl */  IDCLS_ENABLE_H4096K_EXPANSION_NL,
/* pl */  IDCLS_ENABLE_H4096K_EXPANSION_PL,
/* sv */  IDCLS_ENABLE_H4096K_EXPANSION_SV,
/* tr */  IDCLS_ENABLE_H4096K_EXPANSION_TR},

/* plus4/digiblaster.c */
/* en */ {IDCLS_ENABLE_DIGIBLASTER,
/* de */  IDCLS_ENABLE_DIGIBLASTER_DA,
/* de */  IDCLS_ENABLE_DIGIBLASTER_DE,
/* fr */  IDCLS_ENABLE_DIGIBLASTER_FR,
/* hu */  IDCLS_ENABLE_DIGIBLASTER_HU,
/* it */  IDCLS_ENABLE_DIGIBLASTER_IT,
/* nl */  IDCLS_ENABLE_DIGIBLASTER_NL,
/* pl */  IDCLS_ENABLE_DIGIBLASTER_PL,
/* sv */  IDCLS_ENABLE_DIGIBLASTER_SV,
/* tr */  IDCLS_ENABLE_DIGIBLASTER_TR},

/* plus4/digiblaster.c */
/* en */ {IDCLS_DISABLE_DIGIBLASTER,
/* de */  IDCLS_DISABLE_DIGIBLASTER_DA,
/* de */  IDCLS_DISABLE_DIGIBLASTER_DE,
/* fr */  IDCLS_DISABLE_DIGIBLASTER_FR,
/* hu */  IDCLS_DISABLE_DIGIBLASTER_HU,
/* it */  IDCLS_DISABLE_DIGIBLASTER_IT,
/* nl */  IDCLS_DISABLE_DIGIBLASTER_NL,
/* pl */  IDCLS_DISABLE_DIGIBLASTER_PL,
/* sv */  IDCLS_DISABLE_DIGIBLASTER_SV,
/* tr */  IDCLS_DISABLE_DIGIBLASTER_TR},

/* plus4/sidcartjoy.c */
/* en */ {IDCLS_ENABLE_SIDCARTJOY,
/* de */  IDCLS_ENABLE_SIDCARTJOY_DA,
/* de */  IDCLS_ENABLE_SIDCARTJOY_DE,
/* fr */  IDCLS_ENABLE_SIDCARTJOY_FR,
/* hu */  IDCLS_ENABLE_SIDCARTJOY_HU,
/* it */  IDCLS_ENABLE_SIDCARTJOY_IT,
/* nl */  IDCLS_ENABLE_SIDCARTJOY_NL,
/* pl */  IDCLS_ENABLE_SIDCARTJOY_PL,
/* sv */  IDCLS_ENABLE_SIDCARTJOY_SV,
/* tr */  IDCLS_ENABLE_SIDCARTJOY_TR},

/* plus4/sidcartjoy.c */
/* en */ {IDCLS_DISABLE_SIDCARTJOY,
/* de */  IDCLS_DISABLE_SIDCARTJOY_DA,
/* de */  IDCLS_DISABLE_SIDCARTJOY_DE,
/* fr */  IDCLS_DISABLE_SIDCARTJOY_FR,
/* hu */  IDCLS_DISABLE_SIDCARTJOY_HU,
/* it */  IDCLS_DISABLE_SIDCARTJOY_IT,
/* nl */  IDCLS_DISABLE_SIDCARTJOY_NL,
/* pl */  IDCLS_DISABLE_SIDCARTJOY_PL,
/* sv */  IDCLS_DISABLE_SIDCARTJOY_SV,
/* tr */  IDCLS_DISABLE_SIDCARTJOY_TR},

/* plus4/plus4speech.c */
/* en */ {IDCLS_ENABLE_PLUS4SPEECH,
/* de */  IDCLS_ENABLE_PLUS4SPEECH_DA,
/* de */  IDCLS_ENABLE_PLUS4SPEECH_DE,
/* fr */  IDCLS_ENABLE_PLUS4SPEECH_FR,
/* hu */  IDCLS_ENABLE_PLUS4SPEECH_HU,
/* it */  IDCLS_ENABLE_PLUS4SPEECH_IT,
/* nl */  IDCLS_ENABLE_PLUS4SPEECH_NL,
/* pl */  IDCLS_ENABLE_PLUS4SPEECH_PL,
/* sv */  IDCLS_ENABLE_PLUS4SPEECH_SV,
/* tr */  IDCLS_ENABLE_PLUS4SPEECH_TR},

/* plus4/plus4speech.c */
/* en */ {IDCLS_DISABLE_PLUS4SPEECH,
/* de */  IDCLS_DISABLE_PLUS4SPEECH_DA,
/* de */  IDCLS_DISABLE_PLUS4SPEECH_DE,
/* fr */  IDCLS_DISABLE_PLUS4SPEECH_FR,
/* hu */  IDCLS_DISABLE_PLUS4SPEECH_HU,
/* it */  IDCLS_DISABLE_PLUS4SPEECH_IT,
/* nl */  IDCLS_DISABLE_PLUS4SPEECH_NL,
/* pl */  IDCLS_DISABLE_PLUS4SPEECH_PL,
/* sv */  IDCLS_DISABLE_PLUS4SPEECH_SV,
/* tr */  IDCLS_DISABLE_PLUS4SPEECH_TR},

/* plus4/plus4speech.c */
/* en */ {IDCLS_ATTACH_SPEECH_ROM_IMAGE,
/* de */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_DA,
/* de */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_DE,
/* fr */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_FR,
/* hu */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_HU,
/* it */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_IT,
/* nl */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_NL,
/* pl */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_PL,
/* sv */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_SV,
/* tr */  IDCLS_ATTACH_SPEECH_ROM_IMAGE_TR},

/* c64/cart/digimax.c */
/* en */ {IDCLS_ENABLE_DIGIMAX,
/* de */  IDCLS_ENABLE_DIGIMAX_DA,
/* de */  IDCLS_ENABLE_DIGIMAX_DE,
/* fr */  IDCLS_ENABLE_DIGIMAX_FR,
/* hu */  IDCLS_ENABLE_DIGIMAX_HU,
/* it */  IDCLS_ENABLE_DIGIMAX_IT,
/* nl */  IDCLS_ENABLE_DIGIMAX_NL,
/* pl */  IDCLS_ENABLE_DIGIMAX_PL,
/* sv */  IDCLS_ENABLE_DIGIMAX_SV,
/* tr */  IDCLS_ENABLE_DIGIMAX_TR},

/* c64/cart/digimax.c */
/* en */ {IDCLS_DISABLE_DIGIMAX,
/* de */  IDCLS_DISABLE_DIGIMAX_DA,
/* de */  IDCLS_DISABLE_DIGIMAX_DE,
/* fr */  IDCLS_DISABLE_DIGIMAX_FR,
/* hu */  IDCLS_DISABLE_DIGIMAX_HU,
/* it */  IDCLS_DISABLE_DIGIMAX_IT,
/* nl */  IDCLS_DISABLE_DIGIMAX_NL,
/* pl */  IDCLS_DISABLE_DIGIMAX_PL,
/* sv */  IDCLS_DISABLE_DIGIMAX_SV,
/* tr */  IDCLS_DISABLE_DIGIMAX_TR},

/* c64/cart/digimax.c */
/* en */ {IDCLS_DIGIMAX_BASE,
/* de */  IDCLS_DIGIMAX_BASE_DA,
/* de */  IDCLS_DIGIMAX_BASE_DE,
/* fr */  IDCLS_DIGIMAX_BASE_FR,
/* hu */  IDCLS_DIGIMAX_BASE_HU,
/* it */  IDCLS_DIGIMAX_BASE_IT,
/* nl */  IDCLS_DIGIMAX_BASE_NL,
/* pl */  IDCLS_DIGIMAX_BASE_PL,
/* sv */  IDCLS_DIGIMAX_BASE_SV,
/* tr */  IDCLS_DIGIMAX_BASE_TR},

/* c64/cart/sfx_soundexpander.c */
/* en */ {IDCLS_ENABLE_SFX_SE,
/* de */  IDCLS_ENABLE_SFX_SE_DA,
/* de */  IDCLS_ENABLE_SFX_SE_DE,
/* fr */  IDCLS_ENABLE_SFX_SE_FR,
/* hu */  IDCLS_ENABLE_SFX_SE_HU,
/* it */  IDCLS_ENABLE_SFX_SE_IT,
/* nl */  IDCLS_ENABLE_SFX_SE_NL,
/* pl */  IDCLS_ENABLE_SFX_SE_PL,
/* sv */  IDCLS_ENABLE_SFX_SE_SV,
/* tr */  IDCLS_ENABLE_SFX_SE_TR},

/* c64/cart/sfx_soundexpander.c */
/* en */ {IDCLS_DISABLE_SFX_SE,
/* de */  IDCLS_DISABLE_SFX_SE_DA,
/* de */  IDCLS_DISABLE_SFX_SE_DE,
/* fr */  IDCLS_DISABLE_SFX_SE_FR,
/* hu */  IDCLS_DISABLE_SFX_SE_HU,
/* it */  IDCLS_DISABLE_SFX_SE_IT,
/* nl */  IDCLS_DISABLE_SFX_SE_NL,
/* pl */  IDCLS_DISABLE_SFX_SE_PL,
/* sv */  IDCLS_DISABLE_SFX_SE_SV,
/* tr */  IDCLS_DISABLE_SFX_SE_TR},

/* c64/cart/sfx_soundexpander.c */
/* en */ {IDCLS_SET_YM_CHIP_TYPE,
/* de */  IDCLS_SET_YM_CHIP_TYPE_DA,
/* de */  IDCLS_SET_YM_CHIP_TYPE_DE,
/* fr */  IDCLS_SET_YM_CHIP_TYPE_FR,
/* hu */  IDCLS_SET_YM_CHIP_TYPE_HU,
/* it */  IDCLS_SET_YM_CHIP_TYPE_IT,
/* nl */  IDCLS_SET_YM_CHIP_TYPE_NL,
/* pl */  IDCLS_SET_YM_CHIP_TYPE_PL,
/* sv */  IDCLS_SET_YM_CHIP_TYPE_SV,
/* tr */  IDCLS_SET_YM_CHIP_TYPE_TR},

/* c64/cart/sfx_soundsampler.c */
/* en */ {IDCLS_ENABLE_SFX_SS,
/* de */  IDCLS_ENABLE_SFX_SS_DA,
/* de */  IDCLS_ENABLE_SFX_SS_DE,
/* fr */  IDCLS_ENABLE_SFX_SS_FR,
/* hu */  IDCLS_ENABLE_SFX_SS_HU,
/* it */  IDCLS_ENABLE_SFX_SS_IT,
/* nl */  IDCLS_ENABLE_SFX_SS_NL,
/* pl */  IDCLS_ENABLE_SFX_SS_PL,
/* sv */  IDCLS_ENABLE_SFX_SS_SV,
/* tr */  IDCLS_ENABLE_SFX_SS_TR},

/* c64/cart/sfx_soundsampler.c */
/* en */ {IDCLS_DISABLE_SFX_SS,
/* de */  IDCLS_DISABLE_SFX_SS_DA,
/* de */  IDCLS_DISABLE_SFX_SS_DE,
/* fr */  IDCLS_DISABLE_SFX_SS_FR,
/* hu */  IDCLS_DISABLE_SFX_SS_HU,
/* it */  IDCLS_DISABLE_SFX_SS_IT,
/* nl */  IDCLS_DISABLE_SFX_SS_NL,
/* pl */  IDCLS_DISABLE_SFX_SS_PL,
/* sv */  IDCLS_DISABLE_SFX_SS_SV,
/* tr */  IDCLS_DISABLE_SFX_SS_TR},

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_SELECT_HUMMER_USERPORT_DEVICE,
/* de */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_DA,
/* de */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_DE,
/* fr */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_FR,
/* hu */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_HU,
/* it */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_IT,
/* nl */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_NL,
/* pl */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_PL,
/* sv */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_SV,
/* tr */  IDCLS_SELECT_HUMMER_USERPORT_DEVICE_TR},

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_P_PORT,
/* de */  IDCLS_P_PORT_DA,
/* de */  IDCLS_P_PORT_DE,
/* fr */  IDCLS_P_PORT_FR,
/* hu */  IDCLS_P_PORT_HU,
/* it */  IDCLS_P_PORT_IT,
/* nl */  IDCLS_P_PORT_NL,
/* pl */  IDCLS_P_PORT_PL,
/* sv */  IDCLS_P_PORT_SV,
/* tr */  IDCLS_P_PORT_TR},

/* c64dtv/c64dtv-cmdline-options.c */
/* en */ {IDCLS_HUMMER_JOY_PORT,
/* de */  IDCLS_HUMMER_JOY_PORT_DA,
/* de */  IDCLS_HUMMER_JOY_PORT_DE,
/* fr */  IDCLS_HUMMER_JOY_PORT_FR,
/* hu */  IDCLS_HUMMER_JOY_PORT_HU,
/* it */  IDCLS_HUMMER_JOY_PORT_IT,
/* nl */  IDCLS_HUMMER_JOY_PORT_NL,
/* pl */  IDCLS_HUMMER_JOY_PORT_PL,
/* sv */  IDCLS_HUMMER_JOY_PORT_SV,
/* tr */  IDCLS_HUMMER_JOY_PORT_TR},

/* c64dtv/c64dtvblitter.c */
/* en */ {IDCLS_SPECIFY_DTV_REVISION,
/* de */  IDCLS_SPECIFY_DTV_REVISION_DA,
/* de */  IDCLS_SPECIFY_DTV_REVISION_DE,
/* fr */  IDCLS_SPECIFY_DTV_REVISION_FR,
/* hu */  IDCLS_SPECIFY_DTV_REVISION_HU,
/* it */  IDCLS_SPECIFY_DTV_REVISION_IT,
/* nl */  IDCLS_SPECIFY_DTV_REVISION_NL,
/* pl */  IDCLS_SPECIFY_DTV_REVISION_PL,
/* sv */  IDCLS_SPECIFY_DTV_REVISION_SV,
/* tr */  IDCLS_SPECIFY_DTV_REVISION_TR},

/* c64dtv/c64dtvblitter.c */
/* en */ {IDCLS_ENABLE_DTV_BLITTER_LOG,
/* de */  IDCLS_ENABLE_DTV_BLITTER_LOG_DA,
/* de */  IDCLS_ENABLE_DTV_BLITTER_LOG_DE,
/* fr */  IDCLS_ENABLE_DTV_BLITTER_LOG_FR,
/* hu */  IDCLS_ENABLE_DTV_BLITTER_LOG_HU,
/* it */  IDCLS_ENABLE_DTV_BLITTER_LOG_IT,
/* nl */  IDCLS_ENABLE_DTV_BLITTER_LOG_NL,
/* pl */  IDCLS_ENABLE_DTV_BLITTER_LOG_PL,
/* sv */  IDCLS_ENABLE_DTV_BLITTER_LOG_SV,
/* tr */  IDCLS_ENABLE_DTV_BLITTER_LOG_TR},

/* c64dtv/c64dtvblitter.c */
/* en */ {IDCLS_DISABLE_DTV_BLITTER_LOG,
/* de */  IDCLS_DISABLE_DTV_BLITTER_LOG_DA,
/* de */  IDCLS_DISABLE_DTV_BLITTER_LOG_DE,
/* fr */  IDCLS_DISABLE_DTV_BLITTER_LOG_FR,
/* hu */  IDCLS_DISABLE_DTV_BLITTER_LOG_HU,
/* it */  IDCLS_DISABLE_DTV_BLITTER_LOG_IT,
/* nl */  IDCLS_DISABLE_DTV_BLITTER_LOG_NL,
/* pl */  IDCLS_DISABLE_DTV_BLITTER_LOG_PL,
/* sv */  IDCLS_DISABLE_DTV_BLITTER_LOG_SV,
/* tr */  IDCLS_DISABLE_DTV_BLITTER_LOG_TR},

/* c64dtv/c64dtvdma.c */
/* en */ {IDCLS_ENABLE_DTV_DMA_LOG,
/* de */  IDCLS_ENABLE_DTV_DMA_LOG_DA,
/* de */  IDCLS_ENABLE_DTV_DMA_LOG_DE,
/* fr */  IDCLS_ENABLE_DTV_DMA_LOG_FR,
/* hu */  IDCLS_ENABLE_DTV_DMA_LOG_HU,
/* it */  IDCLS_ENABLE_DTV_DMA_LOG_IT,
/* nl */  IDCLS_ENABLE_DTV_DMA_LOG_NL,
/* pl */  IDCLS_ENABLE_DTV_DMA_LOG_PL,
/* sv */  IDCLS_ENABLE_DTV_DMA_LOG_SV,
/* tr */  IDCLS_ENABLE_DTV_DMA_LOG_TR},

/* c64dtv/c64dtvdma.c */
/* en */ {IDCLS_DISABLE_DTV_DMA_LOG,
/* de */  IDCLS_DISABLE_DTV_DMA_LOG_DA,
/* de */  IDCLS_DISABLE_DTV_DMA_LOG_DE,
/* fr */  IDCLS_DISABLE_DTV_DMA_LOG_FR,
/* hu */  IDCLS_DISABLE_DTV_DMA_LOG_HU,
/* it */  IDCLS_DISABLE_DTV_DMA_LOG_IT,
/* nl */  IDCLS_DISABLE_DTV_DMA_LOG_NL,
/* pl */  IDCLS_DISABLE_DTV_DMA_LOG_PL,
/* sv */  IDCLS_DISABLE_DTV_DMA_LOG_SV,
/* tr */  IDCLS_DISABLE_DTV_DMA_LOG_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDCLS_SPECIFY_C64DTVROM_NAME,
/* de */  IDCLS_SPECIFY_C64DTVROM_NAME_DA,
/* de */  IDCLS_SPECIFY_C64DTVROM_NAME_DE,
/* fr */  IDCLS_SPECIFY_C64DTVROM_NAME_FR,
/* hu */  IDCLS_SPECIFY_C64DTVROM_NAME_HU,
/* it */  IDCLS_SPECIFY_C64DTVROM_NAME_IT,
/* nl */  IDCLS_SPECIFY_C64DTVROM_NAME_NL,
/* pl */  IDCLS_SPECIFY_C64DTVROM_NAME_PL,
/* sv */  IDCLS_SPECIFY_C64DTVROM_NAME_SV,
/* tr */  IDCLS_SPECIFY_C64DTVROM_NAME_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDCLS_ENABLE_C64DTVROM_RW,
/* de */  IDCLS_ENABLE_C64DTVROM_RW_DA,
/* de */  IDCLS_ENABLE_C64DTVROM_RW_DE,
/* fr */  IDCLS_ENABLE_C64DTVROM_RW_FR,
/* hu */  IDCLS_ENABLE_C64DTVROM_RW_HU,
/* it */  IDCLS_ENABLE_C64DTVROM_RW_IT,
/* nl */  IDCLS_ENABLE_C64DTVROM_RW_NL,
/* pl */  IDCLS_ENABLE_C64DTVROM_RW_PL,
/* sv */  IDCLS_ENABLE_C64DTVROM_RW_SV,
/* tr */  IDCLS_ENABLE_C64DTVROM_RW_TR},

/* c64dtv/c64dtvflash.c */
/* en */ {IDCLS_DISABLE_C64DTVROM_RW,
/* de */  IDCLS_DISABLE_C64DTVROM_RW_DA,
/* de */  IDCLS_DISABLE_C64DTVROM_RW_DE,
/* fr */  IDCLS_DISABLE_C64DTVROM_RW_FR,
/* hu */  IDCLS_DISABLE_C64DTVROM_RW_HU,
/* it */  IDCLS_DISABLE_C64DTVROM_RW_IT,
/* nl */  IDCLS_DISABLE_C64DTVROM_RW_NL,
/* pl */  IDCLS_DISABLE_C64DTVROM_RW_PL,
/* sv */  IDCLS_DISABLE_C64DTVROM_RW_SV,
/* tr */  IDCLS_DISABLE_C64DTVROM_RW_TR},

/* c64dtv/flash-trap.c */
/* en */ {IDCLS_USE_AS_DIRECTORY_FLASH_FS,
/* de */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_DA,
/* de */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_DE,
/* fr */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_FR,
/* hu */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_HU,
/* it */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_IT,
/* nl */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_NL,
/* pl */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_PL,
/* sv */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_SV,
/* tr */  IDCLS_USE_AS_DIRECTORY_FLASH_FS_TR},

/* c64dtv/flash-trap.c */
/* en */ {IDCLS_ENABLE_TRUE_FLASH_FS,
/* de */  IDCLS_ENABLE_TRUE_FLASH_FS_DA,
/* de */  IDCLS_ENABLE_TRUE_FLASH_FS_DE,
/* fr */  IDCLS_ENABLE_TRUE_FLASH_FS_FR,
/* hu */  IDCLS_ENABLE_TRUE_FLASH_FS_HU,
/* it */  IDCLS_ENABLE_TRUE_FLASH_FS_IT,
/* nl */  IDCLS_ENABLE_TRUE_FLASH_FS_NL,
/* pl */  IDCLS_ENABLE_TRUE_FLASH_FS_PL,
/* sv */  IDCLS_ENABLE_TRUE_FLASH_FS_SV,
/* tr */  IDCLS_ENABLE_TRUE_FLASH_FS_TR},

/* c64dtv/flash-trap.c */
/* en */ {IDCLS_DISABLE_TRUE_FLASH_FS,
/* de */  IDCLS_DISABLE_TRUE_FLASH_FS_DA,
/* de */  IDCLS_DISABLE_TRUE_FLASH_FS_DE,
/* fr */  IDCLS_DISABLE_TRUE_FLASH_FS_FR,
/* hu */  IDCLS_DISABLE_TRUE_FLASH_FS_HU,
/* it */  IDCLS_DISABLE_TRUE_FLASH_FS_IT,
/* nl */  IDCLS_DISABLE_TRUE_FLASH_FS_NL,
/* pl */  IDCLS_DISABLE_TRUE_FLASH_FS_PL,
/* sv */  IDCLS_DISABLE_TRUE_FLASH_FS_SV,
/* tr */  IDCLS_DISABLE_TRUE_FLASH_FS_TR},

/* midi.c */
/* en */ {IDCLS_ENABLE_MIDI_EMU,
/* de */  IDCLS_ENABLE_MIDI_EMU_DA,
/* de */  IDCLS_ENABLE_MIDI_EMU_DE,
/* fr */  IDCLS_ENABLE_MIDI_EMU_FR,
/* hu */  IDCLS_ENABLE_MIDI_EMU_HU,
/* it */  IDCLS_ENABLE_MIDI_EMU_IT,
/* nl */  IDCLS_ENABLE_MIDI_EMU_NL,
/* pl */  IDCLS_ENABLE_MIDI_EMU_PL,
/* sv */  IDCLS_ENABLE_MIDI_EMU_SV,
/* tr */  IDCLS_ENABLE_MIDI_EMU_TR},

/* midi.c */
/* en */ {IDCLS_DISABLE_MIDI_EMU,
/* de */  IDCLS_DISABLE_MIDI_EMU_DA,
/* de */  IDCLS_DISABLE_MIDI_EMU_DE,
/* fr */  IDCLS_DISABLE_MIDI_EMU_FR,
/* hu */  IDCLS_DISABLE_MIDI_EMU_HU,
/* it */  IDCLS_DISABLE_MIDI_EMU_IT,
/* nl */  IDCLS_DISABLE_MIDI_EMU_NL,
/* pl */  IDCLS_DISABLE_MIDI_EMU_PL,
/* sv */  IDCLS_DISABLE_MIDI_EMU_SV,
/* tr */  IDCLS_DISABLE_MIDI_EMU_TR},

/* c64/cart/c64-midi.c */
/* en */ {IDCLS_SPECIFY_C64_MIDI_TYPE,
/* de */  IDCLS_SPECIFY_C64_MIDI_TYPE_DA,
/* de */  IDCLS_SPECIFY_C64_MIDI_TYPE_DE,
/* fr */  IDCLS_SPECIFY_C64_MIDI_TYPE_FR,
/* hu */  IDCLS_SPECIFY_C64_MIDI_TYPE_HU,
/* it */  IDCLS_SPECIFY_C64_MIDI_TYPE_IT,
/* nl */  IDCLS_SPECIFY_C64_MIDI_TYPE_NL,
/* pl */  IDCLS_SPECIFY_C64_MIDI_TYPE_PL,
/* sv */  IDCLS_SPECIFY_C64_MIDI_TYPE_SV,
/* tr */  IDCLS_SPECIFY_C64_MIDI_TYPE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_COMMAND_S_UNKNOWN,
/* de */  IDGS_COMMAND_S_UNKNOWN_DA,
/* de */  IDGS_COMMAND_S_UNKNOWN_DE,
/* fr */  IDGS_COMMAND_S_UNKNOWN_FR,
/* hu */  IDGS_COMMAND_S_UNKNOWN_HU,
/* it */  IDGS_COMMAND_S_UNKNOWN_IT,
/* nl */  IDGS_COMMAND_S_UNKNOWN_NL,
/* pl */  IDGS_COMMAND_S_UNKNOWN_PL,
/* sv */  IDGS_COMMAND_S_UNKNOWN_SV,
/* tr */  IDGS_COMMAND_S_UNKNOWN_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_NO_HELP_AVAILABLE_FOR_S,
/* de */  IDGS_NO_HELP_AVAILABLE_FOR_S_DA,
/* de */  IDGS_NO_HELP_AVAILABLE_FOR_S_DE,
/* fr */  IDGS_NO_HELP_AVAILABLE_FOR_S_FR,
/* hu */  IDGS_NO_HELP_AVAILABLE_FOR_S_HU,
/* it */  IDGS_NO_HELP_AVAILABLE_FOR_S_IT,
/* nl */  IDGS_NO_HELP_AVAILABLE_FOR_S_NL,
/* pl */  IDGS_NO_HELP_AVAILABLE_FOR_S_PL,
/* sv */  IDGS_NO_HELP_AVAILABLE_FOR_S_SV,
/* tr */  IDGS_NO_HELP_AVAILABLE_FOR_S_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_SYNTAX_S_S,
/* de */  IDGS_SYNTAX_S_S_DA,
/* de */  IDGS_SYNTAX_S_S_DE,
/* fr */  IDGS_SYNTAX_S_S_FR,
/* hu */  IDGS_SYNTAX_S_S_HU,
/* it */  IDGS_SYNTAX_S_S_IT,
/* nl */  IDGS_SYNTAX_S_S_NL,
/* pl */  IDGS_SYNTAX_S_S_PL,
/* sv */  IDGS_SYNTAX_S_S_SV,
/* tr */  IDGS_SYNTAX_S_S_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_ABBREVIATION_S,
/* de */  IDGS_ABBREVIATION_S_DA,
/* de */  IDGS_ABBREVIATION_S_DE,
/* fr */  IDGS_ABBREVIATION_S_FR,
/* hu */  IDGS_ABBREVIATION_S_HU,
/* it */  IDGS_ABBREVIATION_S_IT,
/* nl */  IDGS_ABBREVIATION_S_NL,
/* pl */  IDGS_ABBREVIATION_S_PL,
/* sv */  IDGS_ABBREVIATION_S_SV,
/* tr */  IDGS_ABBREVIATION_S_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_AVAILABLE_COMMANDS_ARE,
/* de */  IDGS_AVAILABLE_COMMANDS_ARE_DA,
/* de */  IDGS_AVAILABLE_COMMANDS_ARE_DE,
/* fr */  IDGS_AVAILABLE_COMMANDS_ARE_FR,
/* hu */  IDGS_AVAILABLE_COMMANDS_ARE_HU,
/* it */  IDGS_AVAILABLE_COMMANDS_ARE_IT,
/* nl */  IDGS_AVAILABLE_COMMANDS_ARE_NL,
/* pl */  IDGS_AVAILABLE_COMMANDS_ARE_PL,
/* sv */  IDGS_AVAILABLE_COMMANDS_ARE_SV,
/* tr */  IDGS_AVAILABLE_COMMANDS_ARE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MACHINE_STATE_COMMANDS,
/* de */  IDGS_MACHINE_STATE_COMMANDS_DA,
/* de */  IDGS_MACHINE_STATE_COMMANDS_DE,
/* fr */  IDGS_MACHINE_STATE_COMMANDS_FR,
/* hu */  IDGS_MACHINE_STATE_COMMANDS_HU,
/* it */  IDGS_MACHINE_STATE_COMMANDS_IT,
/* nl */  IDGS_MACHINE_STATE_COMMANDS_NL,
/* pl */  IDGS_MACHINE_STATE_COMMANDS_PL,
/* sv */  IDGS_MACHINE_STATE_COMMANDS_SV,
/* tr */  IDGS_MACHINE_STATE_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MEMSPACE_R_BANKNAME,
/* de */  IDGS_RP_MEMSPACE_R_BANKNAME_DA,
/* de */  IDGS_RP_MEMSPACE_R_BANKNAME_DE,
/* fr */  IDGS_RP_MEMSPACE_R_BANKNAME_FR,
/* hu */  IDGS_RP_MEMSPACE_R_BANKNAME_HU,
/* it */  IDGS_RP_MEMSPACE_R_BANKNAME_IT,
/* nl */  IDGS_RP_MEMSPACE_R_BANKNAME_NL,
/* pl */  IDGS_RP_MEMSPACE_R_BANKNAME_PL,
/* sv */  IDGS_RP_MEMSPACE_R_BANKNAME_SV,
/* tr */  IDGS_RP_MEMSPACE_R_BANKNAME_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BANK_DESCRIPTION,
/* de */  IDGS_MON_BANK_DESCRIPTION_DA,
/* de */  IDGS_MON_BANK_DESCRIPTION_DE,
/* fr */  IDGS_MON_BANK_DESCRIPTION_FR,
/* hu */  IDGS_MON_BANK_DESCRIPTION_HU,
/* it */  IDGS_MON_BANK_DESCRIPTION_IT,
/* nl */  IDGS_MON_BANK_DESCRIPTION_NL,
/* pl */  IDGS_MON_BANK_DESCRIPTION_PL,
/* sv */  IDGS_MON_BANK_DESCRIPTION_SV,
/* tr */  IDGS_MON_BANK_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BACKTRACE_DESCRIPTION,
/* de */  IDGS_MON_BACKTRACE_DESCRIPTION_DA,
/* de */  IDGS_MON_BACKTRACE_DESCRIPTION_DE,
/* fr */  IDGS_MON_BACKTRACE_DESCRIPTION_FR,
/* hu */  IDGS_MON_BACKTRACE_DESCRIPTION_HU,
/* it */  IDGS_MON_BACKTRACE_DESCRIPTION_IT,
/* nl */  IDGS_MON_BACKTRACE_DESCRIPTION_NL,
/* pl */  IDGS_MON_BACKTRACE_DESCRIPTION_PL,
/* sv */  IDGS_MON_BACKTRACE_DESCRIPTION_SV,
/* tr */  IDGS_MON_BACKTRACE_DESCRIPTION_TR},

/* en */ {IDGS_MON_CPU_DESCRIPTION,
/* de */  IDGS_MON_CPU_DESCRIPTION_DA,
/* de */  IDGS_MON_CPU_DESCRIPTION_DE,
/* fr */  IDGS_MON_CPU_DESCRIPTION_FR,
/* hu */  IDGS_MON_CPU_DESCRIPTION_HU,
/* it */  IDGS_MON_CPU_DESCRIPTION_IT,
/* nl */  IDGS_MON_CPU_DESCRIPTION_NL,
/* pl */  IDGS_MON_CPU_DESCRIPTION_PL,
/* sv */  IDGS_MON_CPU_DESCRIPTION_SV,
/* tr */  IDGS_MON_CPU_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_COUNT,
/* de */  IDGS_RP_COUNT_DA,
/* de */  IDGS_RP_COUNT_DE,
/* fr */  IDGS_RP_COUNT_FR,
/* hu */  IDGS_RP_COUNT_HU,
/* it */  IDGS_RP_COUNT_IT,
/* nl */  IDGS_RP_COUNT_NL,
/* pl */  IDGS_RP_COUNT_PL,
/* sv */  IDGS_RP_COUNT_SV,
/* tr */  IDGS_RP_COUNT_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CPUHISTORY_DESCRIPTION,
/* de */  IDGS_MON_CPUHISTORY_DESCRIPTION_DA,
/* de */  IDGS_MON_CPUHISTORY_DESCRIPTION_DE,
/* fr */  IDGS_MON_CPUHISTORY_DESCRIPTION_FR,
/* hu */  IDGS_MON_CPUHISTORY_DESCRIPTION_HU,
/* it */  IDGS_MON_CPUHISTORY_DESCRIPTION_IT,
/* nl */  IDGS_MON_CPUHISTORY_DESCRIPTION_NL,
/* pl */  IDGS_MON_CPUHISTORY_DESCRIPTION_PL,
/* sv */  IDGS_MON_CPUHISTORY_DESCRIPTION_SV,
/* tr */  IDGS_MON_CPUHISTORY_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME,
/* de */  IDGS_QP_FILENAME_DA,
/* de */  IDGS_QP_FILENAME_DE,
/* fr */  IDGS_QP_FILENAME_FR,
/* hu */  IDGS_QP_FILENAME_HU,
/* it */  IDGS_QP_FILENAME_IT,
/* nl */  IDGS_QP_FILENAME_NL,
/* pl */  IDGS_QP_FILENAME_PL,
/* sv */  IDGS_QP_FILENAME_SV,
/* tr */  IDGS_QP_FILENAME_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DUMP_DESCRIPTION,
/* de */  IDGS_MON_DUMP_DESCRIPTION_DA,
/* de */  IDGS_MON_DUMP_DESCRIPTION_DE,
/* fr */  IDGS_MON_DUMP_DESCRIPTION_FR,
/* hu */  IDGS_MON_DUMP_DESCRIPTION_HU,
/* it */  IDGS_MON_DUMP_DESCRIPTION_IT,
/* nl */  IDGS_MON_DUMP_DESCRIPTION_NL,
/* pl */  IDGS_MON_DUMP_DESCRIPTION_PL,
/* sv */  IDGS_MON_DUMP_DESCRIPTION_SV,
/* tr */  IDGS_MON_DUMP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_ADDRESS,
/* de */  IDGS_P_ADDRESS_DA,
/* de */  IDGS_P_ADDRESS_DE,
/* fr */  IDGS_P_ADDRESS_FR,
/* hu */  IDGS_P_ADDRESS_HU,
/* it */  IDGS_P_ADDRESS_IT,
/* nl */  IDGS_P_ADDRESS_NL,
/* pl */  IDGS_P_ADDRESS_PL,
/* sv */  IDGS_P_ADDRESS_SV,
/* tr */  IDGS_P_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_GOTO_DESCRIPTION,
/* de */  IDGS_MON_GOTO_DESCRIPTION_DA,
/* de */  IDGS_MON_GOTO_DESCRIPTION_DE,
/* fr */  IDGS_MON_GOTO_DESCRIPTION_FR,
/* hu */  IDGS_MON_GOTO_DESCRIPTION_HU,
/* it */  IDGS_MON_GOTO_DESCRIPTION_IT,
/* nl */  IDGS_MON_GOTO_DESCRIPTION_NL,
/* pl */  IDGS_MON_GOTO_DESCRIPTION_PL,
/* sv */  IDGS_MON_GOTO_DESCRIPTION_SV,
/* tr */  IDGS_MON_GOTO_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_IO_DESCRIPTION,
/* de */  IDGS_MON_IO_DESCRIPTION_DA,
/* de */  IDGS_MON_IO_DESCRIPTION_DE,
/* fr */  IDGS_MON_IO_DESCRIPTION_FR,
/* hu */  IDGS_MON_IO_DESCRIPTION_HU,
/* it */  IDGS_MON_IO_DESCRIPTION_IT,
/* nl */  IDGS_MON_IO_DESCRIPTION_NL,
/* pl */  IDGS_MON_IO_DESCRIPTION_PL,
/* sv */  IDGS_MON_IO_DESCRIPTION_SV,
/* tr */  IDGS_MON_IO_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_EXPORT_DESCRIPTION,
/* de */  IDGS_MON_EXPORT_DESCRIPTION_DA,
/* de */  IDGS_MON_EXPORT_DESCRIPTION_DE,
/* fr */  IDGS_MON_EXPORT_DESCRIPTION_FR,
/* hu */  IDGS_MON_EXPORT_DESCRIPTION_HU,
/* it */  IDGS_MON_EXPORT_DESCRIPTION_IT,
/* nl */  IDGS_MON_EXPORT_DESCRIPTION_NL,
/* pl */  IDGS_MON_EXPORT_DESCRIPTION_PL,
/* sv */  IDGS_MON_EXPORT_DESCRIPTION_SV,
/* tr */  IDGS_MON_EXPORT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_NEXT_DESCRIPTION,
/* de */  IDGS_MON_NEXT_DESCRIPTION_DA,
/* de */  IDGS_MON_NEXT_DESCRIPTION_DE,
/* fr */  IDGS_MON_NEXT_DESCRIPTION_FR,
/* hu */  IDGS_MON_NEXT_DESCRIPTION_HU,
/* it */  IDGS_MON_NEXT_DESCRIPTION_IT,
/* nl */  IDGS_MON_NEXT_DESCRIPTION_NL,
/* pl */  IDGS_MON_NEXT_DESCRIPTION_PL,
/* sv */  IDGS_MON_NEXT_DESCRIPTION_SV,
/* tr */  IDGS_MON_NEXT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_REG_NAME_P_NUMBER,
/* de */  IDGS_RP_REG_NAME_P_NUMBER_DA,
/* de */  IDGS_RP_REG_NAME_P_NUMBER_DE,
/* fr */  IDGS_RP_REG_NAME_P_NUMBER_FR,
/* hu */  IDGS_RP_REG_NAME_P_NUMBER_HU,
/* it */  IDGS_RP_REG_NAME_P_NUMBER_IT,
/* nl */  IDGS_RP_REG_NAME_P_NUMBER_NL,
/* pl */  IDGS_RP_REG_NAME_P_NUMBER_PL,
/* sv */  IDGS_RP_REG_NAME_P_NUMBER_SV,
/* tr */  IDGS_RP_REG_NAME_P_NUMBER_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_REGISTERS_DESCRIPTION,
/* de */  IDGS_MON_REGISTERS_DESCRIPTION_DA,
/* de */  IDGS_MON_REGISTERS_DESCRIPTION_DE,
/* fr */  IDGS_MON_REGISTERS_DESCRIPTION_FR,
/* hu */  IDGS_MON_REGISTERS_DESCRIPTION_HU,
/* it */  IDGS_MON_REGISTERS_DESCRIPTION_IT,
/* nl */  IDGS_MON_REGISTERS_DESCRIPTION_NL,
/* pl */  IDGS_MON_REGISTERS_DESCRIPTION_PL,
/* sv */  IDGS_MON_REGISTERS_DESCRIPTION_SV,
/* tr */  IDGS_MON_REGISTERS_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_TYPE,
/* de */  IDGS_RP_TYPE_DA,
/* de */  IDGS_RP_TYPE_DE,
/* fr */  IDGS_RP_TYPE_FR,
/* hu */  IDGS_RP_TYPE_HU,
/* it */  IDGS_RP_TYPE_IT,
/* nl */  IDGS_RP_TYPE_NL,
/* pl */  IDGS_RP_TYPE_PL,
/* sv */  IDGS_RP_TYPE_SV,
/* tr */  IDGS_RP_TYPE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESET_DESCRIPTION,
/* de */  IDGS_MON_RESET_DESCRIPTION_DA,
/* de */  IDGS_MON_RESET_DESCRIPTION_DE,
/* fr */  IDGS_MON_RESET_DESCRIPTION_FR,
/* hu */  IDGS_MON_RESET_DESCRIPTION_HU,
/* it */  IDGS_MON_RESET_DESCRIPTION_IT,
/* nl */  IDGS_MON_RESET_DESCRIPTION_NL,
/* pl */  IDGS_MON_RESET_DESCRIPTION_PL,
/* sv */  IDGS_MON_RESET_DESCRIPTION_SV,
/* tr */  IDGS_MON_RESET_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RETURN_DESCRIPTION,
/* de */  IDGS_MON_RETURN_DESCRIPTION_DA,
/* de */  IDGS_MON_RETURN_DESCRIPTION_DE,
/* fr */  IDGS_MON_RETURN_DESCRIPTION_FR,
/* hu */  IDGS_MON_RETURN_DESCRIPTION_HU,
/* it */  IDGS_MON_RETURN_DESCRIPTION_IT,
/* nl */  IDGS_MON_RETURN_DESCRIPTION_NL,
/* pl */  IDGS_MON_RETURN_DESCRIPTION_PL,
/* sv */  IDGS_MON_RETURN_DESCRIPTION_SV,
/* tr */  IDGS_MON_RETURN_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SCREEN_DESCRIPTION,
/* de */  IDGS_MON_SCREEN_DESCRIPTION_DA,
/* de */  IDGS_MON_SCREEN_DESCRIPTION_DE,
/* fr */  IDGS_MON_SCREEN_DESCRIPTION_FR,
/* hu */  IDGS_MON_SCREEN_DESCRIPTION_HU,
/* it */  IDGS_MON_SCREEN_DESCRIPTION_IT,
/* nl */  IDGS_MON_SCREEN_DESCRIPTION_NL,
/* pl */  IDGS_MON_SCREEN_DESCRIPTION_PL,
/* sv */  IDGS_MON_SCREEN_DESCRIPTION_SV,
/* tr */  IDGS_MON_SCREEN_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_STEP_DESCRIPTION,
/* de */  IDGS_MON_STEP_DESCRIPTION_DA,
/* de */  IDGS_MON_STEP_DESCRIPTION_DE,
/* fr */  IDGS_MON_STEP_DESCRIPTION_FR,
/* hu */  IDGS_MON_STEP_DESCRIPTION_HU,
/* it */  IDGS_MON_STEP_DESCRIPTION_IT,
/* nl */  IDGS_MON_STEP_DESCRIPTION_NL,
/* pl */  IDGS_MON_STEP_DESCRIPTION_PL,
/* sv */  IDGS_MON_STEP_DESCRIPTION_SV,
/* tr */  IDGS_MON_STEP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_UNDUMP_DESCRIPTION,
/* de */  IDGS_MON_UNDUMP_DESCRIPTION_DA,
/* de */  IDGS_MON_UNDUMP_DESCRIPTION_DE,
/* fr */  IDGS_MON_UNDUMP_DESCRIPTION_FR,
/* hu */  IDGS_MON_UNDUMP_DESCRIPTION_HU,
/* it */  IDGS_MON_UNDUMP_DESCRIPTION_IT,
/* nl */  IDGS_MON_UNDUMP_DESCRIPTION_NL,
/* pl */  IDGS_MON_UNDUMP_DESCRIPTION_PL,
/* sv */  IDGS_MON_UNDUMP_DESCRIPTION_SV,
/* tr */  IDGS_MON_UNDUMP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_SYMBOL_TABLE_COMMANDS,
/* de */  IDGS_SYMBOL_TABLE_COMMANDS_DA,
/* de */  IDGS_SYMBOL_TABLE_COMMANDS_DE,
/* fr */  IDGS_SYMBOL_TABLE_COMMANDS_FR,
/* hu */  IDGS_SYMBOL_TABLE_COMMANDS_HU,
/* it */  IDGS_SYMBOL_TABLE_COMMANDS_IT,
/* nl */  IDGS_SYMBOL_TABLE_COMMANDS_NL,
/* pl */  IDGS_SYMBOL_TABLE_COMMANDS_PL,
/* sv */  IDGS_SYMBOL_TABLE_COMMANDS_SV,
/* tr */  IDGS_SYMBOL_TABLE_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL,
/* de */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_DA,
/* de */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_DE,
/* fr */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_FR,
/* hu */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_HU,
/* it */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_IT,
/* nl */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_NL,
/* pl */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_PL,
/* sv */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_SV,
/* tr */  IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ADD_LABEL_DESCRIPTION,
/* de */  IDGS_MON_ADD_LABEL_DESCRIPTION_DA,
/* de */  IDGS_MON_ADD_LABEL_DESCRIPTION_DE,
/* fr */  IDGS_MON_ADD_LABEL_DESCRIPTION_FR,
/* hu */  IDGS_MON_ADD_LABEL_DESCRIPTION_HU,
/* it */  IDGS_MON_ADD_LABEL_DESCRIPTION_IT,
/* nl */  IDGS_MON_ADD_LABEL_DESCRIPTION_NL,
/* pl */  IDGS_MON_ADD_LABEL_DESCRIPTION_PL,
/* sv */  IDGS_MON_ADD_LABEL_DESCRIPTION_SV,
/* tr */  IDGS_MON_ADD_LABEL_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MEMSPACE_P_LABEL,
/* de */  IDGS_RP_MEMSPACE_P_LABEL_DA,
/* de */  IDGS_RP_MEMSPACE_P_LABEL_DE,
/* fr */  IDGS_RP_MEMSPACE_P_LABEL_FR,
/* hu */  IDGS_RP_MEMSPACE_P_LABEL_HU,
/* it */  IDGS_RP_MEMSPACE_P_LABEL_IT,
/* nl */  IDGS_RP_MEMSPACE_P_LABEL_NL,
/* pl */  IDGS_RP_MEMSPACE_P_LABEL_PL,
/* sv */  IDGS_RP_MEMSPACE_P_LABEL_SV,
/* tr */  IDGS_RP_MEMSPACE_P_LABEL_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DELETE_LABEL_DESCRIPTION,
/* de */  IDGS_MON_DELETE_LABEL_DESCRIPTION_DA,
/* de */  IDGS_MON_DELETE_LABEL_DESCRIPTION_DE,
/* fr */  IDGS_MON_DELETE_LABEL_DESCRIPTION_FR,
/* hu */  IDGS_MON_DELETE_LABEL_DESCRIPTION_HU,
/* it */  IDGS_MON_DELETE_LABEL_DESCRIPTION_IT,
/* nl */  IDGS_MON_DELETE_LABEL_DESCRIPTION_NL,
/* pl */  IDGS_MON_DELETE_LABEL_DESCRIPTION_PL,
/* sv */  IDGS_MON_DELETE_LABEL_DESCRIPTION_SV,
/* tr */  IDGS_MON_DELETE_LABEL_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MEMSPACE_QP_FILENAME,
/* de */  IDGS_RP_MEMSPACE_QP_FILENAME_DA,
/* de */  IDGS_RP_MEMSPACE_QP_FILENAME_DE,
/* fr */  IDGS_RP_MEMSPACE_QP_FILENAME_FR,
/* hu */  IDGS_RP_MEMSPACE_QP_FILENAME_HU,
/* it */  IDGS_RP_MEMSPACE_QP_FILENAME_IT,
/* nl */  IDGS_RP_MEMSPACE_QP_FILENAME_NL,
/* pl */  IDGS_RP_MEMSPACE_QP_FILENAME_PL,
/* sv */  IDGS_RP_MEMSPACE_QP_FILENAME_SV,
/* tr */  IDGS_RP_MEMSPACE_QP_FILENAME_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LOAD_LABELS_DESCRIPTION,
/* de */  IDGS_MON_LOAD_LABELS_DESCRIPTION_DA,
/* de */  IDGS_MON_LOAD_LABELS_DESCRIPTION_DE,
/* fr */  IDGS_MON_LOAD_LABELS_DESCRIPTION_FR,
/* hu */  IDGS_MON_LOAD_LABELS_DESCRIPTION_HU,
/* it */  IDGS_MON_LOAD_LABELS_DESCRIPTION_IT,
/* nl */  IDGS_MON_LOAD_LABELS_DESCRIPTION_NL,
/* pl */  IDGS_MON_LOAD_LABELS_DESCRIPTION_PL,
/* sv */  IDGS_MON_LOAD_LABELS_DESCRIPTION_SV,
/* tr */  IDGS_MON_LOAD_LABELS_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SAVE_LABELS_DESCRIPTION,
/* de */  IDGS_MON_SAVE_LABELS_DESCRIPTION_DA,
/* de */  IDGS_MON_SAVE_LABELS_DESCRIPTION_DE,
/* fr */  IDGS_MON_SAVE_LABELS_DESCRIPTION_FR,
/* hu */  IDGS_MON_SAVE_LABELS_DESCRIPTION_HU,
/* it */  IDGS_MON_SAVE_LABELS_DESCRIPTION_IT,
/* nl */  IDGS_MON_SAVE_LABELS_DESCRIPTION_NL,
/* pl */  IDGS_MON_SAVE_LABELS_DESCRIPTION_PL,
/* sv */  IDGS_MON_SAVE_LABELS_DESCRIPTION_SV,
/* tr */  IDGS_MON_SAVE_LABELS_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MEMSPACE,
/* de */  IDGS_RP_MEMSPACE_DA,
/* de */  IDGS_RP_MEMSPACE_DE,
/* fr */  IDGS_RP_MEMSPACE_FR,
/* hu */  IDGS_RP_MEMSPACE_HU,
/* it */  IDGS_RP_MEMSPACE_IT,
/* nl */  IDGS_RP_MEMSPACE_NL,
/* pl */  IDGS_RP_MEMSPACE_PL,
/* sv */  IDGS_RP_MEMSPACE_SV,
/* tr */  IDGS_RP_MEMSPACE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SHOW_LABELS_DESCRIPTION,
/* de */  IDGS_MON_SHOW_LABELS_DESCRIPTION_DA,
/* de */  IDGS_MON_SHOW_LABELS_DESCRIPTION_DE,
/* fr */  IDGS_MON_SHOW_LABELS_DESCRIPTION_FR,
/* hu */  IDGS_MON_SHOW_LABELS_DESCRIPTION_HU,
/* it */  IDGS_MON_SHOW_LABELS_DESCRIPTION_IT,
/* nl */  IDGS_MON_SHOW_LABELS_DESCRIPTION_NL,
/* pl */  IDGS_MON_SHOW_LABELS_DESCRIPTION_PL,
/* sv */  IDGS_MON_SHOW_LABELS_DESCRIPTION_SV,
/* tr */  IDGS_MON_SHOW_LABELS_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_ASSEMBLER_AND_MEMORY_COMMANDS,
/* de */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DA,
/* de */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DE,
/* fr */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_FR,
/* hu */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_HU,
/* it */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_IT,
/* nl */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_NL,
/* pl */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_PL,
/* sv */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_SV,
/* tr */  IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_ADDRESS_P_DATA_LIST,
/* de */  IDGS_RP_ADDRESS_P_DATA_LIST_DA,
/* de */  IDGS_RP_ADDRESS_P_DATA_LIST_DE,
/* fr */  IDGS_RP_ADDRESS_P_DATA_LIST_FR,
/* hu */  IDGS_RP_ADDRESS_P_DATA_LIST_HU,
/* it */  IDGS_RP_ADDRESS_P_DATA_LIST_IT,
/* nl */  IDGS_RP_ADDRESS_P_DATA_LIST_NL,
/* pl */  IDGS_RP_ADDRESS_P_DATA_LIST_PL,
/* sv */  IDGS_RP_ADDRESS_P_DATA_LIST_SV,
/* tr */  IDGS_RP_ADDRESS_P_DATA_LIST_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_WRITE_DESCRIPTION,
/* de */  IDGS_MON_WRITE_DESCRIPTION_DA,
/* de */  IDGS_MON_WRITE_DESCRIPTION_DE,
/* fr */  IDGS_MON_WRITE_DESCRIPTION_FR,
/* hu */  IDGS_MON_WRITE_DESCRIPTION_HU,
/* it */  IDGS_MON_WRITE_DESCRIPTION_IT,
/* nl */  IDGS_MON_WRITE_DESCRIPTION_NL,
/* pl */  IDGS_MON_WRITE_DESCRIPTION_PL,
/* sv */  IDGS_MON_WRITE_DESCRIPTION_SV,
/* tr */  IDGS_MON_WRITE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_ADDRESS_RP_INSTRUCTION,
/* de */  IDGS_P_ADDRESS_RP_INSTRUCTION_DA,
/* de */  IDGS_P_ADDRESS_RP_INSTRUCTION_DE,
/* fr */  IDGS_P_ADDRESS_RP_INSTRUCTION_FR,
/* hu */  IDGS_P_ADDRESS_RP_INSTRUCTION_HU,
/* it */  IDGS_P_ADDRESS_RP_INSTRUCTION_IT,
/* nl */  IDGS_P_ADDRESS_RP_INSTRUCTION_NL,
/* pl */  IDGS_P_ADDRESS_RP_INSTRUCTION_PL,
/* sv */  IDGS_P_ADDRESS_RP_INSTRUCTION_SV,
/* tr */  IDGS_P_ADDRESS_RP_INSTRUCTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ASSEMBLE_DESCRIPTION,
/* de */  IDGS_MON_ASSEMBLE_DESCRIPTION_DA,
/* de */  IDGS_MON_ASSEMBLE_DESCRIPTION_DE,
/* fr */  IDGS_MON_ASSEMBLE_DESCRIPTION_FR,
/* hu */  IDGS_MON_ASSEMBLE_DESCRIPTION_HU,
/* it */  IDGS_MON_ASSEMBLE_DESCRIPTION_IT,
/* nl */  IDGS_MON_ASSEMBLE_DESCRIPTION_NL,
/* pl */  IDGS_MON_ASSEMBLE_DESCRIPTION_PL,
/* sv */  IDGS_MON_ASSEMBLE_DESCRIPTION_SV,
/* tr */  IDGS_MON_ASSEMBLE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_ADDRESS_RANGE_P_ADDRESS,
/* de */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_DA,
/* de */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_DE,
/* fr */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_FR,
/* hu */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_HU,
/* it */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_IT,
/* nl */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_NL,
/* pl */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_PL,
/* sv */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_SV,
/* tr */  IDGS_P_ADDRESS_RANGE_P_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_COMPARE_DESCRIPTION,
/* de */  IDGS_MON_COMPARE_DESCRIPTION_DA,
/* de */  IDGS_MON_COMPARE_DESCRIPTION_DE,
/* fr */  IDGS_MON_COMPARE_DESCRIPTION_FR,
/* hu */  IDGS_MON_COMPARE_DESCRIPTION_HU,
/* it */  IDGS_MON_COMPARE_DESCRIPTION_IT,
/* nl */  IDGS_MON_COMPARE_DESCRIPTION_NL,
/* pl */  IDGS_MON_COMPARE_DESCRIPTION_PL,
/* sv */  IDGS_MON_COMPARE_DESCRIPTION_SV,
/* tr */  IDGS_MON_COMPARE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_CHECKNUM,
/* de */  IDGS_P_CHECKNUM_DA,
/* de */  IDGS_P_CHECKNUM_DE,
/* fr */  IDGS_P_CHECKNUM_FR,
/* hu */  IDGS_P_CHECKNUM_HU,
/* it */  IDGS_P_CHECKNUM_IT,
/* nl */  IDGS_P_CHECKNUM_NL,
/* pl */  IDGS_P_CHECKNUM_PL,
/* sv */  IDGS_P_CHECKNUM_SV,
/* tr */  IDGS_P_CHECKNUM_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DELETE_DESCRIPTION,
/* de */  IDGS_MON_DELETE_DESCRIPTION_DA,
/* de */  IDGS_MON_DELETE_DESCRIPTION_DE,
/* fr */  IDGS_MON_DELETE_DESCRIPTION_FR,
/* hu */  IDGS_MON_DELETE_DESCRIPTION_HU,
/* it */  IDGS_MON_DELETE_DESCRIPTION_IT,
/* nl */  IDGS_MON_DELETE_DESCRIPTION_NL,
/* pl */  IDGS_MON_DELETE_DESCRIPTION_PL,
/* sv */  IDGS_MON_DELETE_DESCRIPTION_SV,
/* tr */  IDGS_MON_DELETE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_ADDRESS_RP_ADDRESS,
/* de */  IDGS_RP_ADDRESS_RP_ADDRESS_DA,
/* de */  IDGS_RP_ADDRESS_RP_ADDRESS_DE,
/* fr */  IDGS_RP_ADDRESS_RP_ADDRESS_FR,
/* hu */  IDGS_RP_ADDRESS_RP_ADDRESS_HU,
/* it */  IDGS_RP_ADDRESS_RP_ADDRESS_IT,
/* nl */  IDGS_RP_ADDRESS_RP_ADDRESS_NL,
/* pl */  IDGS_RP_ADDRESS_RP_ADDRESS_PL,
/* sv */  IDGS_RP_ADDRESS_RP_ADDRESS_SV,
/* tr */  IDGS_RP_ADDRESS_RP_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISASS_DESCRIPTION,
/* de */  IDGS_MON_DISASS_DESCRIPTION_DA,
/* de */  IDGS_MON_DISASS_DESCRIPTION_DE,
/* fr */  IDGS_MON_DISASS_DESCRIPTION_FR,
/* hu */  IDGS_MON_DISASS_DESCRIPTION_HU,
/* it */  IDGS_MON_DISASS_DESCRIPTION_IT,
/* nl */  IDGS_MON_DISASS_DESCRIPTION_NL,
/* pl */  IDGS_MON_DISASS_DESCRIPTION_PL,
/* sv */  IDGS_MON_DISASS_DESCRIPTION_SV,
/* tr */  IDGS_MON_DISASS_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_ADDRESS_RANGE_P_DATA_LIST,
/* de */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_DA,
/* de */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_DE,
/* fr */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_FR,
/* hu */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_HU,
/* it */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_IT,
/* nl */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_NL,
/* pl */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_PL,
/* sv */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_SV,
/* tr */  IDGS_P_ADDRESS_RANGE_P_DATA_LIST_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_FILL_DESCRIPTION,
/* de */  IDGS_MON_FILL_DESCRIPTION_DA,
/* de */  IDGS_MON_FILL_DESCRIPTION_DE,
/* fr */  IDGS_MON_FILL_DESCRIPTION_FR,
/* hu */  IDGS_MON_FILL_DESCRIPTION_HU,
/* it */  IDGS_MON_FILL_DESCRIPTION_IT,
/* nl */  IDGS_MON_FILL_DESCRIPTION_NL,
/* pl */  IDGS_MON_FILL_DESCRIPTION_PL,
/* sv */  IDGS_MON_FILL_DESCRIPTION_SV,
/* tr */  IDGS_MON_FILL_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_HUNT_DESCRIPTION,
/* de */  IDGS_MON_HUNT_DESCRIPTION_DA,
/* de */  IDGS_MON_HUNT_DESCRIPTION_DE,
/* fr */  IDGS_MON_HUNT_DESCRIPTION_FR,
/* hu */  IDGS_MON_HUNT_DESCRIPTION_HU,
/* it */  IDGS_MON_HUNT_DESCRIPTION_IT,
/* nl */  IDGS_MON_HUNT_DESCRIPTION_NL,
/* pl */  IDGS_MON_HUNT_DESCRIPTION_PL,
/* sv */  IDGS_MON_HUNT_DESCRIPTION_SV,
/* tr */  IDGS_MON_HUNT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_ADDRESS_OPT_RANGE,
/* de */  IDGS_P_ADDRESS_OPT_RANGE_DA,
/* de */  IDGS_P_ADDRESS_OPT_RANGE_DE,
/* fr */  IDGS_P_ADDRESS_OPT_RANGE_FR,
/* hu */  IDGS_P_ADDRESS_OPT_RANGE_HU,
/* it */  IDGS_P_ADDRESS_OPT_RANGE_IT,
/* nl */  IDGS_P_ADDRESS_OPT_RANGE_NL,
/* pl */  IDGS_P_ADDRESS_OPT_RANGE_PL,
/* sv */  IDGS_P_ADDRESS_OPT_RANGE_SV,
/* tr */  IDGS_P_ADDRESS_OPT_RANGE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_I_DESCRIPTION,
/* de */  IDGS_MON_I_DESCRIPTION_DA,
/* de */  IDGS_MON_I_DESCRIPTION_DE,
/* fr */  IDGS_MON_I_DESCRIPTION_FR,
/* hu */  IDGS_MON_I_DESCRIPTION_HU,
/* it */  IDGS_MON_I_DESCRIPTION_IT,
/* nl */  IDGS_MON_I_DESCRIPTION_NL,
/* pl */  IDGS_MON_I_DESCRIPTION_PL,
/* sv */  IDGS_MON_I_DESCRIPTION_SV,
/* tr */  IDGS_MON_I_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_II_DESCRIPTION,
/* de */  IDGS_MON_II_DESCRIPTION_DA,
/* de */  IDGS_MON_II_DESCRIPTION_DE,
/* fr */  IDGS_MON_II_DESCRIPTION_FR,
/* hu */  IDGS_MON_II_DESCRIPTION_HU,
/* it */  IDGS_MON_II_DESCRIPTION_IT,
/* nl */  IDGS_MON_II_DESCRIPTION_NL,
/* pl */  IDGS_MON_II_DESCRIPTION_PL,
/* sv */  IDGS_MON_II_DESCRIPTION_SV,
/* tr */  IDGS_MON_II_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE,
/* de */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_DA,
/* de */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_DE,
/* fr */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_FR,
/* hu */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_HU,
/* it */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_IT,
/* nl */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_NL,
/* pl */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_PL,
/* sv */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_SV,
/* tr */  IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEM_DESCRIPTION,
/* de */  IDGS_MON_MEM_DESCRIPTION_DA,
/* de */  IDGS_MON_MEM_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEM_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEM_DESCRIPTION_HU,
/* it */  IDGS_MON_MEM_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEM_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEM_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEM_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEM_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMCHAR_DESCRIPTION,
/* de */  IDGS_MON_MEMCHAR_DESCRIPTION_DA,
/* de */  IDGS_MON_MEMCHAR_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEMCHAR_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEMCHAR_DESCRIPTION_HU,
/* it */  IDGS_MON_MEMCHAR_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEMCHAR_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEMCHAR_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEMCHAR_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEMCHAR_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME_P_FORMAT,
/* de */  IDGS_QP_FILENAME_P_FORMAT_DA,
/* de */  IDGS_QP_FILENAME_P_FORMAT_DE,
/* fr */  IDGS_QP_FILENAME_P_FORMAT_FR,
/* hu */  IDGS_QP_FILENAME_P_FORMAT_HU,
/* it */  IDGS_QP_FILENAME_P_FORMAT_IT,
/* nl */  IDGS_QP_FILENAME_P_FORMAT_NL,
/* pl */  IDGS_QP_FILENAME_P_FORMAT_PL,
/* sv */  IDGS_QP_FILENAME_P_FORMAT_SV,
/* tr */  IDGS_QP_FILENAME_P_FORMAT_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPSAVE_DESCRIPTION,
/* de */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_DA,
/* de */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_HU,
/* it */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEMMAPSAVE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE,
/* de */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_DA,
/* de */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_DE,
/* fr */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_FR,
/* hu */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_HU,
/* it */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_IT,
/* nl */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_NL,
/* pl */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_PL,
/* sv */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_SV,
/* tr */  IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPSHOW_DESCRIPTION,
/* de */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_DA,
/* de */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_HU,
/* it */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEMMAPSHOW_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMMAPZAP_DESCRIPTION,
/* de */  IDGS_MON_MEMMAPZAP_DESCRIPTION_DA,
/* de */  IDGS_MON_MEMMAPZAP_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEMMAPZAP_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEMMAPZAP_DESCRIPTION_HU,
/* it */  IDGS_MON_MEMMAPZAP_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEMMAPZAP_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEMMAPZAP_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEMMAPZAP_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEMMAPZAP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MEMSPRITE_DESCRIPTION,
/* de */  IDGS_MON_MEMSPRITE_DESCRIPTION_DA,
/* de */  IDGS_MON_MEMSPRITE_DESCRIPTION_DE,
/* fr */  IDGS_MON_MEMSPRITE_DESCRIPTION_FR,
/* hu */  IDGS_MON_MEMSPRITE_DESCRIPTION_HU,
/* it */  IDGS_MON_MEMSPRITE_DESCRIPTION_IT,
/* nl */  IDGS_MON_MEMSPRITE_DESCRIPTION_NL,
/* pl */  IDGS_MON_MEMSPRITE_DESCRIPTION_PL,
/* sv */  IDGS_MON_MEMSPRITE_DESCRIPTION_SV,
/* tr */  IDGS_MON_MEMSPRITE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_MOVE_DESCRIPTION,
/* de */  IDGS_MON_MOVE_DESCRIPTION_DA,
/* de */  IDGS_MON_MOVE_DESCRIPTION_DE,
/* fr */  IDGS_MON_MOVE_DESCRIPTION_FR,
/* hu */  IDGS_MON_MOVE_DESCRIPTION_HU,
/* it */  IDGS_MON_MOVE_DESCRIPTION_IT,
/* nl */  IDGS_MON_MOVE_DESCRIPTION_NL,
/* pl */  IDGS_MON_MOVE_DESCRIPTION_PL,
/* sv */  IDGS_MON_MOVE_DESCRIPTION_SV,
/* tr */  IDGS_MON_MOVE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_CHECKPOINT_COMMANDS,
/* de */  IDGS_CHECKPOINT_COMMANDS_DA,
/* de */  IDGS_CHECKPOINT_COMMANDS_DE,
/* fr */  IDGS_CHECKPOINT_COMMANDS_FR,
/* hu */  IDGS_CHECKPOINT_COMMANDS_HU,
/* it */  IDGS_CHECKPOINT_COMMANDS_IT,
/* nl */  IDGS_CHECKPOINT_COMMANDS_NL,
/* pl */  IDGS_CHECKPOINT_COMMANDS_PL,
/* sv */  IDGS_CHECKPOINT_COMMANDS_SV,
/* tr */  IDGS_CHECKPOINT_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_ADDRESS_RP_COND_EXPR,
/* de */  IDGS_RP_ADDRESS_RP_COND_EXPR_DA,
/* de */  IDGS_RP_ADDRESS_RP_COND_EXPR_DE,
/* fr */  IDGS_RP_ADDRESS_RP_COND_EXPR_FR,
/* hu */  IDGS_RP_ADDRESS_RP_COND_EXPR_HU,
/* it */  IDGS_RP_ADDRESS_RP_COND_EXPR_IT,
/* nl */  IDGS_RP_ADDRESS_RP_COND_EXPR_NL,
/* pl */  IDGS_RP_ADDRESS_RP_COND_EXPR_PL,
/* sv */  IDGS_RP_ADDRESS_RP_COND_EXPR_SV,
/* tr */  IDGS_RP_ADDRESS_RP_COND_EXPR_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BREAK_DESCRIPTION,
/* de */  IDGS_MON_BREAK_DESCRIPTION_DA,
/* de */  IDGS_MON_BREAK_DESCRIPTION_DE,
/* fr */  IDGS_MON_BREAK_DESCRIPTION_FR,
/* hu */  IDGS_MON_BREAK_DESCRIPTION_HU,
/* it */  IDGS_MON_BREAK_DESCRIPTION_IT,
/* nl */  IDGS_MON_BREAK_DESCRIPTION_NL,
/* pl */  IDGS_MON_BREAK_DESCRIPTION_PL,
/* sv */  IDGS_MON_BREAK_DESCRIPTION_SV,
/* tr */  IDGS_MON_BREAK_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_CHECKNUM_QP_COMMAND,
/* de */  IDGS_P_CHECKNUM_QP_COMMAND_DA,
/* de */  IDGS_P_CHECKNUM_QP_COMMAND_DE,
/* fr */  IDGS_P_CHECKNUM_QP_COMMAND_FR,
/* hu */  IDGS_P_CHECKNUM_QP_COMMAND_HU,
/* it */  IDGS_P_CHECKNUM_QP_COMMAND_IT,
/* nl */  IDGS_P_CHECKNUM_QP_COMMAND_NL,
/* pl */  IDGS_P_CHECKNUM_QP_COMMAND_PL,
/* sv */  IDGS_P_CHECKNUM_QP_COMMAND_SV,
/* tr */  IDGS_P_CHECKNUM_QP_COMMAND_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_COMMAND_DESCRIPTION,
/* de */  IDGS_MON_COMMAND_DESCRIPTION_DA,
/* de */  IDGS_MON_COMMAND_DESCRIPTION_DE,
/* fr */  IDGS_MON_COMMAND_DESCRIPTION_FR,
/* hu */  IDGS_MON_COMMAND_DESCRIPTION_HU,
/* it */  IDGS_MON_COMMAND_DESCRIPTION_IT,
/* nl */  IDGS_MON_COMMAND_DESCRIPTION_NL,
/* pl */  IDGS_MON_COMMAND_DESCRIPTION_PL,
/* sv */  IDGS_MON_COMMAND_DESCRIPTION_SV,
/* tr */  IDGS_MON_COMMAND_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_CHECKNUM_IF_P_COND_EXPR,
/* de */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_DA,
/* de */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_DE,
/* fr */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_FR,
/* hu */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_HU,
/* it */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_IT,
/* nl */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_NL,
/* pl */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_PL,
/* sv */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_SV,
/* tr */  IDGS_P_CHECKNUM_IF_P_COND_EXPR_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CONDITION_DESCRIPTION,
/* de */  IDGS_MON_CONDITION_DESCRIPTION_DA,
/* de */  IDGS_MON_CONDITION_DESCRIPTION_DE,
/* fr */  IDGS_MON_CONDITION_DESCRIPTION_FR,
/* hu */  IDGS_MON_CONDITION_DESCRIPTION_HU,
/* it */  IDGS_MON_CONDITION_DESCRIPTION_IT,
/* nl */  IDGS_MON_CONDITION_DESCRIPTION_NL,
/* pl */  IDGS_MON_CONDITION_DESCRIPTION_PL,
/* sv */  IDGS_MON_CONDITION_DESCRIPTION_SV,
/* tr */  IDGS_MON_CONDITION_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISABLE_DESCRIPTION,
/* de */  IDGS_MON_DISABLE_DESCRIPTION_DA,
/* de */  IDGS_MON_DISABLE_DESCRIPTION_DE,
/* fr */  IDGS_MON_DISABLE_DESCRIPTION_FR,
/* hu */  IDGS_MON_DISABLE_DESCRIPTION_HU,
/* it */  IDGS_MON_DISABLE_DESCRIPTION_IT,
/* nl */  IDGS_MON_DISABLE_DESCRIPTION_NL,
/* pl */  IDGS_MON_DISABLE_DESCRIPTION_PL,
/* sv */  IDGS_MON_DISABLE_DESCRIPTION_SV,
/* tr */  IDGS_MON_DISABLE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ENABLE_DESCRIPTION,
/* de */  IDGS_MON_ENABLE_DESCRIPTION_DA,
/* de */  IDGS_MON_ENABLE_DESCRIPTION_DE,
/* fr */  IDGS_MON_ENABLE_DESCRIPTION_FR,
/* hu */  IDGS_MON_ENABLE_DESCRIPTION_HU,
/* it */  IDGS_MON_ENABLE_DESCRIPTION_IT,
/* nl */  IDGS_MON_ENABLE_DESCRIPTION_NL,
/* pl */  IDGS_MON_ENABLE_DESCRIPTION_PL,
/* sv */  IDGS_MON_ENABLE_DESCRIPTION_SV,
/* tr */  IDGS_MON_ENABLE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_CHECKNUM_RP_COUNT,
/* de */  IDGS_P_CHECKNUM_RP_COUNT_DA,
/* de */  IDGS_P_CHECKNUM_RP_COUNT_DE,
/* fr */  IDGS_P_CHECKNUM_RP_COUNT_FR,
/* hu */  IDGS_P_CHECKNUM_RP_COUNT_HU,
/* it */  IDGS_P_CHECKNUM_RP_COUNT_IT,
/* nl */  IDGS_P_CHECKNUM_RP_COUNT_NL,
/* pl */  IDGS_P_CHECKNUM_RP_COUNT_PL,
/* sv */  IDGS_P_CHECKNUM_RP_COUNT_SV,
/* tr */  IDGS_P_CHECKNUM_RP_COUNT_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_IGNORE_DESCRIPTION,
/* de */  IDGS_MON_IGNORE_DESCRIPTION_DA,
/* de */  IDGS_MON_IGNORE_DESCRIPTION_DE,
/* fr */  IDGS_MON_IGNORE_DESCRIPTION_FR,
/* hu */  IDGS_MON_IGNORE_DESCRIPTION_HU,
/* it */  IDGS_MON_IGNORE_DESCRIPTION_IT,
/* nl */  IDGS_MON_IGNORE_DESCRIPTION_NL,
/* pl */  IDGS_MON_IGNORE_DESCRIPTION_PL,
/* sv */  IDGS_MON_IGNORE_DESCRIPTION_SV,
/* tr */  IDGS_MON_IGNORE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_ADDRESS,
/* de */  IDGS_RP_ADDRESS_DA,
/* de */  IDGS_RP_ADDRESS_DE,
/* fr */  IDGS_RP_ADDRESS_FR,
/* hu */  IDGS_RP_ADDRESS_HU,
/* it */  IDGS_RP_ADDRESS_IT,
/* nl */  IDGS_RP_ADDRESS_NL,
/* pl */  IDGS_RP_ADDRESS_PL,
/* sv */  IDGS_RP_ADDRESS_SV,
/* tr */  IDGS_RP_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_UNTIL_DESCRIPTION,
/* de */  IDGS_MON_UNTIL_DESCRIPTION_DA,
/* de */  IDGS_MON_UNTIL_DESCRIPTION_DE,
/* fr */  IDGS_MON_UNTIL_DESCRIPTION_FR,
/* hu */  IDGS_MON_UNTIL_DESCRIPTION_HU,
/* it */  IDGS_MON_UNTIL_DESCRIPTION_IT,
/* nl */  IDGS_MON_UNTIL_DESCRIPTION_NL,
/* pl */  IDGS_MON_UNTIL_DESCRIPTION_PL,
/* sv */  IDGS_MON_UNTIL_DESCRIPTION_SV,
/* tr */  IDGS_MON_UNTIL_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS,
/* de */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_DA,
/* de */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_DE,
/* fr */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_FR,
/* hu */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_HU,
/* it */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_IT,
/* nl */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_NL,
/* pl */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_PL,
/* sv */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_SV,
/* tr */  IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_WATCH_DESCRIPTION,
/* de */  IDGS_MON_WATCH_DESCRIPTION_DA,
/* de */  IDGS_MON_WATCH_DESCRIPTION_DE,
/* fr */  IDGS_MON_WATCH_DESCRIPTION_FR,
/* hu */  IDGS_MON_WATCH_DESCRIPTION_HU,
/* it */  IDGS_MON_WATCH_DESCRIPTION_IT,
/* nl */  IDGS_MON_WATCH_DESCRIPTION_NL,
/* pl */  IDGS_MON_WATCH_DESCRIPTION_PL,
/* sv */  IDGS_MON_WATCH_DESCRIPTION_SV,
/* tr */  IDGS_MON_WATCH_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_R_ADDRESS_R_ADDRESS,
/* de */  IDGS_R_ADDRESS_R_ADDRESS_DA,
/* de */  IDGS_R_ADDRESS_R_ADDRESS_DE,
/* fr */  IDGS_R_ADDRESS_R_ADDRESS_FR,
/* hu */  IDGS_R_ADDRESS_R_ADDRESS_HU,
/* it */  IDGS_R_ADDRESS_R_ADDRESS_IT,
/* nl */  IDGS_R_ADDRESS_R_ADDRESS_NL,
/* pl */  IDGS_R_ADDRESS_R_ADDRESS_PL,
/* sv */  IDGS_R_ADDRESS_R_ADDRESS_SV,
/* tr */  IDGS_R_ADDRESS_R_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_TRACE_DESCRIPTION,
/* de */  IDGS_MON_TRACE_DESCRIPTION_DA,
/* de */  IDGS_MON_TRACE_DESCRIPTION_DE,
/* fr */  IDGS_MON_TRACE_DESCRIPTION_FR,
/* hu */  IDGS_MON_TRACE_DESCRIPTION_HU,
/* it */  IDGS_MON_TRACE_DESCRIPTION_IT,
/* nl */  IDGS_MON_TRACE_DESCRIPTION_NL,
/* pl */  IDGS_MON_TRACE_DESCRIPTION_PL,
/* sv */  IDGS_MON_TRACE_DESCRIPTION_SV,
/* tr */  IDGS_MON_TRACE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MONITOR_STATE_COMMANDS,
/* de */  IDGS_MONITOR_STATE_COMMANDS_DA,
/* de */  IDGS_MONITOR_STATE_COMMANDS_DE,
/* fr */  IDGS_MONITOR_STATE_COMMANDS_FR,
/* hu */  IDGS_MONITOR_STATE_COMMANDS_HU,
/* it */  IDGS_MONITOR_STATE_COMMANDS_IT,
/* nl */  IDGS_MONITOR_STATE_COMMANDS_NL,
/* pl */  IDGS_MONITOR_STATE_COMMANDS_PL,
/* sv */  IDGS_MONITOR_STATE_COMMANDS_SV,
/* tr */  IDGS_MONITOR_STATE_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DEVICE_DESCRIPTION,
/* de */  IDGS_MON_DEVICE_DESCRIPTION_DA,
/* de */  IDGS_MON_DEVICE_DESCRIPTION_DE,
/* fr */  IDGS_MON_DEVICE_DESCRIPTION_FR,
/* hu */  IDGS_MON_DEVICE_DESCRIPTION_HU,
/* it */  IDGS_MON_DEVICE_DESCRIPTION_IT,
/* nl */  IDGS_MON_DEVICE_DESCRIPTION_NL,
/* pl */  IDGS_MON_DEVICE_DESCRIPTION_PL,
/* sv */  IDGS_MON_DEVICE_DESCRIPTION_SV,
/* tr */  IDGS_MON_DEVICE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_EXIT_DESCRIPTION,
/* de */  IDGS_MON_EXIT_DESCRIPTION_DA,
/* de */  IDGS_MON_EXIT_DESCRIPTION_DE,
/* fr */  IDGS_MON_EXIT_DESCRIPTION_FR,
/* hu */  IDGS_MON_EXIT_DESCRIPTION_HU,
/* it */  IDGS_MON_EXIT_DESCRIPTION_IT,
/* nl */  IDGS_MON_EXIT_DESCRIPTION_NL,
/* pl */  IDGS_MON_EXIT_DESCRIPTION_PL,
/* sv */  IDGS_MON_EXIT_DESCRIPTION_SV,
/* tr */  IDGS_MON_EXIT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_QUIT_DESCRIPTION,
/* de */  IDGS_MON_QUIT_DESCRIPTION_DA,
/* de */  IDGS_MON_QUIT_DESCRIPTION_DE,
/* fr */  IDGS_MON_QUIT_DESCRIPTION_FR,
/* hu */  IDGS_MON_QUIT_DESCRIPTION_HU,
/* it */  IDGS_MON_QUIT_DESCRIPTION_IT,
/* nl */  IDGS_MON_QUIT_DESCRIPTION_NL,
/* pl */  IDGS_MON_QUIT_DESCRIPTION_PL,
/* sv */  IDGS_MON_QUIT_DESCRIPTION_SV,
/* tr */  IDGS_MON_QUIT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RADIX_DESCRIPTION,
/* de */  IDGS_MON_RADIX_DESCRIPTION_DA,
/* de */  IDGS_MON_RADIX_DESCRIPTION_DE,
/* fr */  IDGS_MON_RADIX_DESCRIPTION_FR,
/* hu */  IDGS_MON_RADIX_DESCRIPTION_HU,
/* it */  IDGS_MON_RADIX_DESCRIPTION_IT,
/* nl */  IDGS_MON_RADIX_DESCRIPTION_NL,
/* pl */  IDGS_MON_RADIX_DESCRIPTION_PL,
/* sv */  IDGS_MON_RADIX_DESCRIPTION_SV,
/* tr */  IDGS_MON_RADIX_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_R_ON_R_OFF_R_TOGGLE,
/* de */  IDGS_R_ON_R_OFF_R_TOGGLE_DA,
/* de */  IDGS_R_ON_R_OFF_R_TOGGLE_DE,
/* fr */  IDGS_R_ON_R_OFF_R_TOGGLE_FR,
/* hu */  IDGS_R_ON_R_OFF_R_TOGGLE_HU,
/* it */  IDGS_R_ON_R_OFF_R_TOGGLE_IT,
/* nl */  IDGS_R_ON_R_OFF_R_TOGGLE_NL,
/* pl */  IDGS_R_ON_R_OFF_R_TOGGLE_PL,
/* sv */  IDGS_R_ON_R_OFF_R_TOGGLE_SV,
/* tr */  IDGS_R_ON_R_OFF_R_TOGGLE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SIDEFX_DESCRIPTION,
/* de */  IDGS_MON_SIDEFX_DESCRIPTION_DA,
/* de */  IDGS_MON_SIDEFX_DESCRIPTION_DE,
/* fr */  IDGS_MON_SIDEFX_DESCRIPTION_FR,
/* hu */  IDGS_MON_SIDEFX_DESCRIPTION_HU,
/* it */  IDGS_MON_SIDEFX_DESCRIPTION_IT,
/* nl */  IDGS_MON_SIDEFX_DESCRIPTION_NL,
/* pl */  IDGS_MON_SIDEFX_DESCRIPTION_PL,
/* sv */  IDGS_MON_SIDEFX_DESCRIPTION_SV,
/* tr */  IDGS_MON_SIDEFX_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_DISK_COMMANDS,
/* de */  IDGS_DISK_COMMANDS_DA,
/* de */  IDGS_DISK_COMMANDS_DE,
/* fr */  IDGS_DISK_COMMANDS_FR,
/* hu */  IDGS_DISK_COMMANDS_HU,
/* it */  IDGS_DISK_COMMANDS_IT,
/* nl */  IDGS_DISK_COMMANDS_NL,
/* pl */  IDGS_DISK_COMMANDS_PL,
/* sv */  IDGS_DISK_COMMANDS_SV,
/* tr */  IDGS_DISK_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_DISK_COMMAND,
/* de */  IDGS_P_DISK_COMMAND_DA,
/* de */  IDGS_P_DISK_COMMAND_DE,
/* fr */  IDGS_P_DISK_COMMAND_FR,
/* hu */  IDGS_P_DISK_COMMAND_HU,
/* it */  IDGS_P_DISK_COMMAND_IT,
/* nl */  IDGS_P_DISK_COMMAND_NL,
/* pl */  IDGS_P_DISK_COMMAND_PL,
/* sv */  IDGS_P_DISK_COMMAND_SV,
/* tr */  IDGS_P_DISK_COMMAND_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_AT_DESCRIPTION,
/* de */  IDGS_MON_AT_DESCRIPTION_DA,
/* de */  IDGS_MON_AT_DESCRIPTION_DE,
/* fr */  IDGS_MON_AT_DESCRIPTION_FR,
/* hu */  IDGS_MON_AT_DESCRIPTION_HU,
/* it */  IDGS_MON_AT_DESCRIPTION_IT,
/* nl */  IDGS_MON_AT_DESCRIPTION_NL,
/* pl */  IDGS_MON_AT_DESCRIPTION_PL,
/* sv */  IDGS_MON_AT_DESCRIPTION_SV,
/* tr */  IDGS_MON_AT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_FILENAME_P_DEVICE,
/* de */  IDGS_P_FILENAME_P_DEVICE_DA,
/* de */  IDGS_P_FILENAME_P_DEVICE_DE,
/* fr */  IDGS_P_FILENAME_P_DEVICE_FR,
/* hu */  IDGS_P_FILENAME_P_DEVICE_HU,
/* it */  IDGS_P_FILENAME_P_DEVICE_IT,
/* nl */  IDGS_P_FILENAME_P_DEVICE_NL,
/* pl */  IDGS_P_FILENAME_P_DEVICE_PL,
/* sv */  IDGS_P_FILENAME_P_DEVICE_SV,
/* tr */  IDGS_P_FILENAME_P_DEVICE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_ATTACH_DESCRIPTION,
/* de */  IDGS_MON_ATTACH_DESCRIPTION_DA,
/* de */  IDGS_MON_ATTACH_DESCRIPTION_DE,
/* fr */  IDGS_MON_ATTACH_DESCRIPTION_FR,
/* hu */  IDGS_MON_ATTACH_DESCRIPTION_HU,
/* it */  IDGS_MON_ATTACH_DESCRIPTION_IT,
/* nl */  IDGS_MON_ATTACH_DESCRIPTION_NL,
/* pl */  IDGS_MON_ATTACH_DESCRIPTION_PL,
/* sv */  IDGS_MON_ATTACH_DESCRIPTION_SV,
/* tr */  IDGS_MON_ATTACH_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS,
/* de */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_DA,
/* de */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_DE,
/* fr */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_FR,
/* hu */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_HU,
/* it */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_IT,
/* nl */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_NL,
/* pl */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_PL,
/* sv */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_SV,
/* tr */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOAD_DESCRIPTION,
/* de */  IDGS_MON_BLOAD_DESCRIPTION_DA,
/* de */  IDGS_MON_BLOAD_DESCRIPTION_DE,
/* fr */  IDGS_MON_BLOAD_DESCRIPTION_FR,
/* hu */  IDGS_MON_BLOAD_DESCRIPTION_HU,
/* it */  IDGS_MON_BLOAD_DESCRIPTION_IT,
/* nl */  IDGS_MON_BLOAD_DESCRIPTION_NL,
/* pl */  IDGS_MON_BLOAD_DESCRIPTION_PL,
/* sv */  IDGS_MON_BLOAD_DESCRIPTION_SV,
/* tr */  IDGS_MON_BLOAD_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_TRACK_P_SECTOR_RP_ADDRESS,
/* de */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_DA,
/* de */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_DE,
/* fr */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_FR,
/* hu */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_HU,
/* it */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_IT,
/* nl */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_NL,
/* pl */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_PL,
/* sv */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_SV,
/* tr */  IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOCK_READ_DESCRIPTION,
/* de */  IDGS_MON_BLOCK_READ_DESCRIPTION_DA,
/* de */  IDGS_MON_BLOCK_READ_DESCRIPTION_DE,
/* fr */  IDGS_MON_BLOCK_READ_DESCRIPTION_FR,
/* hu */  IDGS_MON_BLOCK_READ_DESCRIPTION_HU,
/* it */  IDGS_MON_BLOCK_READ_DESCRIPTION_IT,
/* nl */  IDGS_MON_BLOCK_READ_DESCRIPTION_NL,
/* pl */  IDGS_MON_BLOCK_READ_DESCRIPTION_PL,
/* sv */  IDGS_MON_BLOCK_READ_DESCRIPTION_SV,
/* tr */  IDGS_MON_BLOCK_READ_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2,
/* de */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_DA,
/* de */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_DE,
/* fr */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_FR,
/* hu */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_HU,
/* it */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_IT,
/* nl */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_NL,
/* pl */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_PL,
/* sv */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_SV,
/* tr */  IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BSAVE_DESCRIPTION,
/* de */  IDGS_MON_BSAVE_DESCRIPTION_DA,
/* de */  IDGS_MON_BSAVE_DESCRIPTION_DE,
/* fr */  IDGS_MON_BSAVE_DESCRIPTION_FR,
/* hu */  IDGS_MON_BSAVE_DESCRIPTION_HU,
/* it */  IDGS_MON_BSAVE_DESCRIPTION_IT,
/* nl */  IDGS_MON_BSAVE_DESCRIPTION_NL,
/* pl */  IDGS_MON_BSAVE_DESCRIPTION_PL,
/* sv */  IDGS_MON_BSAVE_DESCRIPTION_SV,
/* tr */  IDGS_MON_BSAVE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_TRACK_P_SECTOR_P_ADDRESS,
/* de */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_DA,
/* de */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_DE,
/* fr */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_FR,
/* hu */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_HU,
/* it */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_IT,
/* nl */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_NL,
/* pl */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_PL,
/* sv */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_SV,
/* tr */  IDGS_P_TRACK_P_SECTOR_P_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_BLOCK_WRITE_DESCRIPTION,
/* de */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_DA,
/* de */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_DE,
/* fr */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_FR,
/* hu */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_HU,
/* it */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_IT,
/* nl */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_NL,
/* pl */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_PL,
/* sv */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_SV,
/* tr */  IDGS_MON_BLOCK_WRITE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_DIRECTORY,
/* de */  IDGS_P_DIRECTORY_DA,
/* de */  IDGS_P_DIRECTORY_DE,
/* fr */  IDGS_P_DIRECTORY_FR,
/* hu */  IDGS_P_DIRECTORY_HU,
/* it */  IDGS_P_DIRECTORY_IT,
/* nl */  IDGS_P_DIRECTORY_NL,
/* pl */  IDGS_P_DIRECTORY_PL,
/* sv */  IDGS_P_DIRECTORY_SV,
/* tr */  IDGS_P_DIRECTORY_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CD_DESCRIPTION,
/* de */  IDGS_MON_CD_DESCRIPTION_DA,
/* de */  IDGS_MON_CD_DESCRIPTION_DE,
/* fr */  IDGS_MON_CD_DESCRIPTION_FR,
/* hu */  IDGS_MON_CD_DESCRIPTION_HU,
/* it */  IDGS_MON_CD_DESCRIPTION_IT,
/* nl */  IDGS_MON_CD_DESCRIPTION_NL,
/* pl */  IDGS_MON_CD_DESCRIPTION_PL,
/* sv */  IDGS_MON_CD_DESCRIPTION_SV,
/* tr */  IDGS_MON_CD_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DETACH_DESCRIPTION,
/* de */  IDGS_MON_DETACH_DESCRIPTION_DA,
/* de */  IDGS_MON_DETACH_DESCRIPTION_DE,
/* fr */  IDGS_MON_DETACH_DESCRIPTION_FR,
/* hu */  IDGS_MON_DETACH_DESCRIPTION_HU,
/* it */  IDGS_MON_DETACH_DESCRIPTION_IT,
/* nl */  IDGS_MON_DETACH_DESCRIPTION_NL,
/* pl */  IDGS_MON_DETACH_DESCRIPTION_PL,
/* sv */  IDGS_MON_DETACH_DESCRIPTION_SV,
/* tr */  IDGS_MON_DETACH_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_DIRECTORY,
/* de */  IDGS_RP_DIRECTORY_DA,
/* de */  IDGS_RP_DIRECTORY_DE,
/* fr */  IDGS_RP_DIRECTORY_FR,
/* hu */  IDGS_RP_DIRECTORY_HU,
/* it */  IDGS_RP_DIRECTORY_IT,
/* nl */  IDGS_RP_DIRECTORY_NL,
/* pl */  IDGS_RP_DIRECTORY_PL,
/* sv */  IDGS_RP_DIRECTORY_SV,
/* tr */  IDGS_RP_DIRECTORY_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_DEVICE,
/* de */  IDGS_RP_DEVICE_DA,
/* de */  IDGS_RP_DEVICE_DE,
/* fr */  IDGS_RP_DEVICE_FR,
/* hu */  IDGS_RP_DEVICE_HU,
/* it */  IDGS_RP_DEVICE_IT,
/* nl */  IDGS_RP_DEVICE_NL,
/* pl */  IDGS_RP_DEVICE_PL,
/* sv */  IDGS_RP_DEVICE_SV,
/* tr */  IDGS_RP_DEVICE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DIR_DESCRIPTION,
/* de */  IDGS_MON_DIR_DESCRIPTION_DA,
/* de */  IDGS_MON_DIR_DESCRIPTION_DE,
/* fr */  IDGS_MON_DIR_DESCRIPTION_FR,
/* hu */  IDGS_MON_DIR_DESCRIPTION_HU,
/* it */  IDGS_MON_DIR_DESCRIPTION_IT,
/* nl */  IDGS_MON_DIR_DESCRIPTION_NL,
/* pl */  IDGS_MON_DIR_DESCRIPTION_PL,
/* sv */  IDGS_MON_DIR_DESCRIPTION_SV,
/* tr */  IDGS_MON_DIR_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LIST_DESCRIPTION,
/* de */  IDGS_MON_LIST_DESCRIPTION_DA,
/* de */  IDGS_MON_LIST_DESCRIPTION_DE,
/* fr */  IDGS_MON_LIST_DESCRIPTION_FR,
/* hu */  IDGS_MON_LIST_DESCRIPTION_HU,
/* it */  IDGS_MON_LIST_DESCRIPTION_IT,
/* nl */  IDGS_MON_LIST_DESCRIPTION_NL,
/* pl */  IDGS_MON_LIST_DESCRIPTION_PL,
/* sv */  IDGS_MON_LIST_DESCRIPTION_SV,
/* tr */  IDGS_MON_LIST_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS,
/* de */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_DA,
/* de */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_DE,
/* fr */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_FR,
/* hu */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_HU,
/* it */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_IT,
/* nl */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_NL,
/* pl */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_PL,
/* sv */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_SV,
/* tr */  IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_LOAD_DESCRIPTION,
/* de */  IDGS_MON_LOAD_DESCRIPTION_DA,
/* de */  IDGS_MON_LOAD_DESCRIPTION_DE,
/* fr */  IDGS_MON_LOAD_DESCRIPTION_FR,
/* hu */  IDGS_MON_LOAD_DESCRIPTION_HU,
/* it */  IDGS_MON_LOAD_DESCRIPTION_IT,
/* nl */  IDGS_MON_LOAD_DESCRIPTION_NL,
/* pl */  IDGS_MON_LOAD_DESCRIPTION_PL,
/* sv */  IDGS_MON_LOAD_DESCRIPTION_SV,
/* tr */  IDGS_MON_LOAD_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PWD_DESCRIPTION,
/* de */  IDGS_MON_PWD_DESCRIPTION_DA,
/* de */  IDGS_MON_PWD_DESCRIPTION_DE,
/* fr */  IDGS_MON_PWD_DESCRIPTION_FR,
/* hu */  IDGS_MON_PWD_DESCRIPTION_HU,
/* it */  IDGS_MON_PWD_DESCRIPTION_IT,
/* nl */  IDGS_MON_PWD_DESCRIPTION_NL,
/* pl */  IDGS_MON_PWD_DESCRIPTION_PL,
/* sv */  IDGS_MON_PWD_DESCRIPTION_SV,
/* tr */  IDGS_MON_PWD_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SAVE_DESCRIPTION,
/* de */  IDGS_MON_SAVE_DESCRIPTION_DA,
/* de */  IDGS_MON_SAVE_DESCRIPTION_DE,
/* fr */  IDGS_MON_SAVE_DESCRIPTION_FR,
/* hu */  IDGS_MON_SAVE_DESCRIPTION_HU,
/* it */  IDGS_MON_SAVE_DESCRIPTION_IT,
/* nl */  IDGS_MON_SAVE_DESCRIPTION_NL,
/* pl */  IDGS_MON_SAVE_DESCRIPTION_PL,
/* sv */  IDGS_MON_SAVE_DESCRIPTION_SV,
/* tr */  IDGS_MON_SAVE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_OTHER_COMMANDS,
/* de */  IDGS_OTHER_COMMANDS_DA,
/* de */  IDGS_OTHER_COMMANDS_DE,
/* fr */  IDGS_OTHER_COMMANDS_FR,
/* hu */  IDGS_OTHER_COMMANDS_HU,
/* it */  IDGS_OTHER_COMMANDS_IT,
/* nl */  IDGS_OTHER_COMMANDS_NL,
/* pl */  IDGS_OTHER_COMMANDS_PL,
/* sv */  IDGS_OTHER_COMMANDS_SV,
/* tr */  IDGS_OTHER_COMMANDS_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_DISPLAY_NUMBER_DESCRIPTION,
/* de */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DA,
/* de */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DE,
/* fr */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_FR,
/* hu */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_HU,
/* it */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_IT,
/* nl */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_NL,
/* pl */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_PL,
/* sv */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_SV,
/* tr */  IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_CARTFREEZE_DESCRIPTION,
/* de */  IDGS_MON_CARTFREEZE_DESCRIPTION_DA,
/* de */  IDGS_MON_CARTFREEZE_DESCRIPTION_DE,
/* fr */  IDGS_MON_CARTFREEZE_DESCRIPTION_FR,
/* hu */  IDGS_MON_CARTFREEZE_DESCRIPTION_HU,
/* it */  IDGS_MON_CARTFREEZE_DESCRIPTION_IT,
/* nl */  IDGS_MON_CARTFREEZE_DESCRIPTION_NL,
/* pl */  IDGS_MON_CARTFREEZE_DESCRIPTION_PL,
/* sv */  IDGS_MON_CARTFREEZE_DESCRIPTION_SV,
/* tr */  IDGS_MON_CARTFREEZE_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_RP_COMMAND,
/* de */  IDGS_RP_COMMAND_DA,
/* de */  IDGS_RP_COMMAND_DE,
/* fr */  IDGS_RP_COMMAND_FR,
/* hu */  IDGS_RP_COMMAND_HU,
/* it */  IDGS_RP_COMMAND_IT,
/* nl */  IDGS_RP_COMMAND_NL,
/* pl */  IDGS_RP_COMMAND_PL,
/* sv */  IDGS_RP_COMMAND_SV,
/* tr */  IDGS_RP_COMMAND_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_HELP_DESCRIPTION,
/* de */  IDGS_MON_HELP_DESCRIPTION_DA,
/* de */  IDGS_MON_HELP_DESCRIPTION_DE,
/* fr */  IDGS_MON_HELP_DESCRIPTION_FR,
/* hu */  IDGS_MON_HELP_DESCRIPTION_HU,
/* it */  IDGS_MON_HELP_DESCRIPTION_IT,
/* nl */  IDGS_MON_HELP_DESCRIPTION_NL,
/* pl */  IDGS_MON_HELP_DESCRIPTION_PL,
/* sv */  IDGS_MON_HELP_DESCRIPTION_SV,
/* tr */  IDGS_MON_HELP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_STRING,
/* de */  IDGS_QP_STRING_DA,
/* de */  IDGS_QP_STRING_DE,
/* fr */  IDGS_QP_STRING_FR,
/* hu */  IDGS_QP_STRING_HU,
/* it */  IDGS_QP_STRING_IT,
/* nl */  IDGS_QP_STRING_NL,
/* pl */  IDGS_QP_STRING_PL,
/* sv */  IDGS_QP_STRING_SV,
/* tr */  IDGS_QP_STRING_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_KEYBUF_DESCRIPTION,
/* de */  IDGS_MON_KEYBUF_DESCRIPTION_DA,
/* de */  IDGS_MON_KEYBUF_DESCRIPTION_DE,
/* fr */  IDGS_MON_KEYBUF_DESCRIPTION_FR,
/* hu */  IDGS_MON_KEYBUF_DESCRIPTION_HU,
/* it */  IDGS_MON_KEYBUF_DESCRIPTION_IT,
/* nl */  IDGS_MON_KEYBUF_DESCRIPTION_NL,
/* pl */  IDGS_MON_KEYBUF_DESCRIPTION_PL,
/* sv */  IDGS_MON_KEYBUF_DESCRIPTION_SV,
/* tr */  IDGS_MON_KEYBUF_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PLAYBACK_DESCRIPTION,
/* de */  IDGS_MON_PLAYBACK_DESCRIPTION_DA,
/* de */  IDGS_MON_PLAYBACK_DESCRIPTION_DE,
/* fr */  IDGS_MON_PLAYBACK_DESCRIPTION_FR,
/* hu */  IDGS_MON_PLAYBACK_DESCRIPTION_HU,
/* it */  IDGS_MON_PLAYBACK_DESCRIPTION_IT,
/* nl */  IDGS_MON_PLAYBACK_DESCRIPTION_NL,
/* pl */  IDGS_MON_PLAYBACK_DESCRIPTION_PL,
/* sv */  IDGS_MON_PLAYBACK_DESCRIPTION_SV,
/* tr */  IDGS_MON_PLAYBACK_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_EXPRESSION,
/* de */  IDGS_P_EXPRESSION_DA,
/* de */  IDGS_P_EXPRESSION_DE,
/* fr */  IDGS_P_EXPRESSION_FR,
/* hu */  IDGS_P_EXPRESSION_HU,
/* it */  IDGS_P_EXPRESSION_IT,
/* nl */  IDGS_P_EXPRESSION_NL,
/* pl */  IDGS_P_EXPRESSION_PL,
/* sv */  IDGS_P_EXPRESSION_SV,
/* tr */  IDGS_P_EXPRESSION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_PRINT_DESCRIPTION,
/* de */  IDGS_MON_PRINT_DESCRIPTION_DA,
/* de */  IDGS_MON_PRINT_DESCRIPTION_DE,
/* fr */  IDGS_MON_PRINT_DESCRIPTION_FR,
/* hu */  IDGS_MON_PRINT_DESCRIPTION_HU,
/* it */  IDGS_MON_PRINT_DESCRIPTION_IT,
/* nl */  IDGS_MON_PRINT_DESCRIPTION_NL,
/* pl */  IDGS_MON_PRINT_DESCRIPTION_PL,
/* sv */  IDGS_MON_PRINT_DESCRIPTION_SV,
/* tr */  IDGS_MON_PRINT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RECORD_DESCRIPTION,
/* de */  IDGS_MON_RECORD_DESCRIPTION_DA,
/* de */  IDGS_MON_RECORD_DESCRIPTION_DE,
/* fr */  IDGS_MON_RECORD_DESCRIPTION_FR,
/* hu */  IDGS_MON_RECORD_DESCRIPTION_HU,
/* it */  IDGS_MON_RECORD_DESCRIPTION_IT,
/* nl */  IDGS_MON_RECORD_DESCRIPTION_NL,
/* pl */  IDGS_MON_RECORD_DESCRIPTION_PL,
/* sv */  IDGS_MON_RECORD_DESCRIPTION_SV,
/* tr */  IDGS_MON_RECORD_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_RESOURCE,
/* de */  IDGS_QP_RESOURCE_DA,
/* de */  IDGS_QP_RESOURCE_DE,
/* fr */  IDGS_QP_RESOURCE_FR,
/* hu */  IDGS_QP_RESOURCE_HU,
/* it */  IDGS_QP_RESOURCE_IT,
/* nl */  IDGS_QP_RESOURCE_NL,
/* pl */  IDGS_QP_RESOURCE_PL,
/* sv */  IDGS_QP_RESOURCE_SV,
/* tr */  IDGS_QP_RESOURCE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESOURCEGET_DESCRIPTION,
/* de */  IDGS_MON_RESOURCEGET_DESCRIPTION_DA,
/* de */  IDGS_MON_RESOURCEGET_DESCRIPTION_DE,
/* fr */  IDGS_MON_RESOURCEGET_DESCRIPTION_FR,
/* hu */  IDGS_MON_RESOURCEGET_DESCRIPTION_HU,
/* it */  IDGS_MON_RESOURCEGET_DESCRIPTION_IT,
/* nl */  IDGS_MON_RESOURCEGET_DESCRIPTION_NL,
/* pl */  IDGS_MON_RESOURCEGET_DESCRIPTION_PL,
/* sv */  IDGS_MON_RESOURCEGET_DESCRIPTION_SV,
/* tr */  IDGS_MON_RESOURCEGET_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_RESOURCE_QP_VALUE,
/* de */  IDGS_QP_RESOURCE_QP_VALUE_DA,
/* de */  IDGS_QP_RESOURCE_QP_VALUE_DE,
/* fr */  IDGS_QP_RESOURCE_QP_VALUE_FR,
/* hu */  IDGS_QP_RESOURCE_QP_VALUE_HU,
/* it */  IDGS_QP_RESOURCE_QP_VALUE_IT,
/* nl */  IDGS_QP_RESOURCE_QP_VALUE_NL,
/* pl */  IDGS_QP_RESOURCE_QP_VALUE_PL,
/* sv */  IDGS_QP_RESOURCE_QP_VALUE_SV,
/* tr */  IDGS_QP_RESOURCE_QP_VALUE_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_RESOURCESET_DESCRIPTION,
/* de */  IDGS_MON_RESOURCESET_DESCRIPTION_DA,
/* de */  IDGS_MON_RESOURCESET_DESCRIPTION_DE,
/* fr */  IDGS_MON_RESOURCESET_DESCRIPTION_FR,
/* hu */  IDGS_MON_RESOURCESET_DESCRIPTION_HU,
/* it */  IDGS_MON_RESOURCESET_DESCRIPTION_IT,
/* nl */  IDGS_MON_RESOURCESET_DESCRIPTION_NL,
/* pl */  IDGS_MON_RESOURCESET_DESCRIPTION_PL,
/* sv */  IDGS_MON_RESOURCESET_DESCRIPTION_SV,
/* tr */  IDGS_MON_RESOURCESET_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_STOP_DESCRIPTION,
/* de */  IDGS_MON_STOP_DESCRIPTION_DA,
/* de */  IDGS_MON_STOP_DESCRIPTION_DE,
/* fr */  IDGS_MON_STOP_DESCRIPTION_FR,
/* hu */  IDGS_MON_STOP_DESCRIPTION_HU,
/* it */  IDGS_MON_STOP_DESCRIPTION_IT,
/* nl */  IDGS_MON_STOP_DESCRIPTION_NL,
/* pl */  IDGS_MON_STOP_DESCRIPTION_PL,
/* sv */  IDGS_MON_STOP_DESCRIPTION_SV,
/* tr */  IDGS_MON_STOP_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_QP_FILENAME_RP_FORMAT,
/* de */  IDGS_QP_FILENAME_RP_FORMAT_DA,
/* de */  IDGS_QP_FILENAME_RP_FORMAT_DE,
/* fr */  IDGS_QP_FILENAME_RP_FORMAT_FR,
/* hu */  IDGS_QP_FILENAME_RP_FORMAT_HU,
/* it */  IDGS_QP_FILENAME_RP_FORMAT_IT,
/* nl */  IDGS_QP_FILENAME_RP_FORMAT_NL,
/* pl */  IDGS_QP_FILENAME_RP_FORMAT_PL,
/* sv */  IDGS_QP_FILENAME_RP_FORMAT_SV,
/* tr */  IDGS_QP_FILENAME_RP_FORMAT_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_SCREENSHOT_DESCRIPTION,
/* de */  IDGS_MON_SCREENSHOT_DESCRIPTION_DA,
/* de */  IDGS_MON_SCREENSHOT_DESCRIPTION_DE,
/* fr */  IDGS_MON_SCREENSHOT_DESCRIPTION_FR,
/* hu */  IDGS_MON_SCREENSHOT_DESCRIPTION_HU,
/* it */  IDGS_MON_SCREENSHOT_DESCRIPTION_IT,
/* nl */  IDGS_MON_SCREENSHOT_DESCRIPTION_NL,
/* pl */  IDGS_MON_SCREENSHOT_DESCRIPTION_PL,
/* sv */  IDGS_MON_SCREENSHOT_DESCRIPTION_SV,
/* tr */  IDGS_MON_SCREENSHOT_DESCRIPTION_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_P_COMMAND,
/* de */  IDGS_P_COMMAND_DA,
/* de */  IDGS_P_COMMAND_DE,
/* fr */  IDGS_P_COMMAND_FR,
/* hu */  IDGS_P_COMMAND_HU,
/* it */  IDGS_P_COMMAND_IT,
/* nl */  IDGS_P_COMMAND_NL,
/* pl */  IDGS_P_COMMAND_PL,
/* sv */  IDGS_P_COMMAND_SV,
/* tr */  IDGS_P_COMMAND_TR},

/* monitor/mon_command.c */
/* en */ {IDGS_MON_TAPECTRL_DESCRIPTION,
/* de */  IDGS_MON_TAPECTRL_DESCRIPTION_DA,
/* de */  IDGS_MON_TAPECTRL_DESCRIPTION_DE,
/* fr */  IDGS_MON_TAPECTRL_DESCRIPTION_FR,
/* hu */  IDGS_MON_TAPECTRL_DESCRIPTION_HU,
/* it */  IDGS_MON_TAPECTRL_DESCRIPTION_IT,
/* nl */  IDGS_MON_TAPECTRL_DESCRIPTION_NL,
/* pl */  IDGS_MON_TAPECTRL_DESCRIPTION_PL,
/* sv */  IDGS_MON_TAPECTRL_DESCRIPTION_SV,
/* tr */  IDGS_MON_TAPECTRL_DESCRIPTION_TR},

/* lightpen.c */
/* en */ {IDCLS_ENABLE_LIGHTPEN_EMULATION,
/* de */  IDCLS_ENABLE_LIGHTPEN_EMULATION_DA,
/* de */  IDCLS_ENABLE_LIGHTPEN_EMULATION_DE,
/* fr */  IDCLS_ENABLE_LIGHTPEN_EMULATION_FR,
/* hu */  IDCLS_ENABLE_LIGHTPEN_EMULATION_HU,
/* it */  IDCLS_ENABLE_LIGHTPEN_EMULATION_IT,
/* nl */  IDCLS_ENABLE_LIGHTPEN_EMULATION_NL,
/* pl */  IDCLS_ENABLE_LIGHTPEN_EMULATION_PL,
/* sv */  IDCLS_ENABLE_LIGHTPEN_EMULATION_SV,
/* tr */  IDCLS_ENABLE_LIGHTPEN_EMULATION_TR},

/* lightpen.c */
/* en */ {IDCLS_DISABLE_LIGHTPEN_EMULATION,
/* de */  IDCLS_DISABLE_LIGHTPEN_EMULATION_DA,
/* de */  IDCLS_DISABLE_LIGHTPEN_EMULATION_DE,
/* fr */  IDCLS_DISABLE_LIGHTPEN_EMULATION_FR,
/* hu */  IDCLS_DISABLE_LIGHTPEN_EMULATION_HU,
/* it */  IDCLS_DISABLE_LIGHTPEN_EMULATION_IT,
/* nl */  IDCLS_DISABLE_LIGHTPEN_EMULATION_NL,
/* pl */  IDCLS_DISABLE_LIGHTPEN_EMULATION_PL,
/* sv */  IDCLS_DISABLE_LIGHTPEN_EMULATION_SV,
/* tr */  IDCLS_DISABLE_LIGHTPEN_EMULATION_TR},

/* lightpen.c */
/* en */ {IDCLS_SET_LIGHTPEN_TYPE,
/* de */  IDCLS_SET_LIGHTPEN_TYPE_DA,
/* de */  IDCLS_SET_LIGHTPEN_TYPE_DE,
/* fr */  IDCLS_SET_LIGHTPEN_TYPE_FR,
/* hu */  IDCLS_SET_LIGHTPEN_TYPE_HU,
/* it */  IDCLS_SET_LIGHTPEN_TYPE_IT,
/* nl */  IDCLS_SET_LIGHTPEN_TYPE_NL,
/* pl */  IDCLS_SET_LIGHTPEN_TYPE_PL,
/* sv */  IDCLS_SET_LIGHTPEN_TYPE_SV,
/* tr */  IDCLS_SET_LIGHTPEN_TYPE_TR},

/* c64/cart/easyflash.c */
/* en */ {IDCLS_ENABLE_EASYFLASH_JUMPER,
/* de */  IDCLS_ENABLE_EASYFLASH_JUMPER_DA,
/* de */  IDCLS_ENABLE_EASYFLASH_JUMPER_DE,
/* fr */  IDCLS_ENABLE_EASYFLASH_JUMPER_FR,
/* hu */  IDCLS_ENABLE_EASYFLASH_JUMPER_HU,
/* it */  IDCLS_ENABLE_EASYFLASH_JUMPER_IT,
/* nl */  IDCLS_ENABLE_EASYFLASH_JUMPER_NL,
/* pl */  IDCLS_ENABLE_EASYFLASH_JUMPER_PL,
/* sv */  IDCLS_ENABLE_EASYFLASH_JUMPER_SV,
/* tr */  IDCLS_ENABLE_EASYFLASH_JUMPER_TR},

/* c64/cart/easyflash.c */
/* en */ {IDCLS_DISABLE_EASYFLASH_JUMPER,
/* de */  IDCLS_DISABLE_EASYFLASH_JUMPER_DA,
/* de */  IDCLS_DISABLE_EASYFLASH_JUMPER_DE,
/* fr */  IDCLS_DISABLE_EASYFLASH_JUMPER_FR,
/* hu */  IDCLS_DISABLE_EASYFLASH_JUMPER_HU,
/* it */  IDCLS_DISABLE_EASYFLASH_JUMPER_IT,
/* nl */  IDCLS_DISABLE_EASYFLASH_JUMPER_NL,
/* pl */  IDCLS_DISABLE_EASYFLASH_JUMPER_PL,
/* sv */  IDCLS_DISABLE_EASYFLASH_JUMPER_SV,
/* tr */  IDCLS_DISABLE_EASYFLASH_JUMPER_TR},

/* c64/cart/easyflash.c */
/* en */ {IDCLS_ENABLE_EASYFLASH_CRT_WRITING,
/* de */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_DA,
/* de */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_DE,
/* fr */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_FR,
/* hu */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_HU,
/* it */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_IT,
/* nl */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_NL,
/* pl */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_PL,
/* sv */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_SV,
/* tr */  IDCLS_ENABLE_EASYFLASH_CRT_WRITING_TR},

/* c64/cart/lash.c */
/* en */ {IDCLS_DISABLE_EASYFLASH_CRT_WRITING,
/* de */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_DA,
/* de */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_DE,
/* fr */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_FR,
/* hu */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_HU,
/* it */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_IT,
/* nl */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_NL,
/* pl */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_PL,
/* sv */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_SV,
/* tr */  IDCLS_DISABLE_EASYFLASH_CRT_WRITING_TR},
};
