/*
 * translate.h - Global internationalization routines.
 *
 * Autogenerated by gentranslate_h.sh, DO NOT EDIT !!!
 *
 * Written by
 *  Marco van den Heuvel <blackystardust68@yahoo.com>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#ifndef VICE_TRANSLATE_H
#define VICE_TRANSLATE_H

#include "translate_funcs.h"

#define USE_PARAM_STRING   0
#define USE_PARAM_ID       1

#define USE_DESCRIPTION_STRING   0
#define USE_DESCRIPTION_ID       1

#define IDGS_UNUSED IDCLS_UNUSED

#define IDCLS_SPECIFY_SIDCART_ENGINE_MODEL   0xffffff /* special case translation */
#define IDCLS_SPECIFY_SID_ENGINE_MODEL       0xfffffe /* special case translation */
#define IDCLS_SPECIFY_SIDDTV_ENGINE_MODEL    0xfffffd /* special case translation */

enum { ID_START_65536=65536,
IDCLS_UNUSED,

/* GLOBAL STRING ID DEFINITIONS */

/* autostart.c */
IDGS_CANNOT_LOAD_SNAPSHOT_FILE,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DA,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_DE,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_FR,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_HU,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_IT,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_NL,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_PL,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_SV,
IDGS_CANNOT_LOAD_SNAPSHOT_FILE_TR,

/* debug.c */
IDGS_PLAYBACK_ERROR_DIFFERENT,
IDGS_PLAYBACK_ERROR_DIFFERENT_DA,
IDGS_PLAYBACK_ERROR_DIFFERENT_DE,
IDGS_PLAYBACK_ERROR_DIFFERENT_FR,
IDGS_PLAYBACK_ERROR_DIFFERENT_HU,
IDGS_PLAYBACK_ERROR_DIFFERENT_IT,
IDGS_PLAYBACK_ERROR_DIFFERENT_NL,
IDGS_PLAYBACK_ERROR_DIFFERENT_PL,
IDGS_PLAYBACK_ERROR_DIFFERENT_SV,
IDGS_PLAYBACK_ERROR_DIFFERENT_TR,

/* event.c */
IDGS_CANNOT_CREATE_IMAGE,
IDGS_CANNOT_CREATE_IMAGE_DA,
IDGS_CANNOT_CREATE_IMAGE_DE,
IDGS_CANNOT_CREATE_IMAGE_FR,
IDGS_CANNOT_CREATE_IMAGE_HU,
IDGS_CANNOT_CREATE_IMAGE_IT,
IDGS_CANNOT_CREATE_IMAGE_NL,
IDGS_CANNOT_CREATE_IMAGE_PL,
IDGS_CANNOT_CREATE_IMAGE_SV,
IDGS_CANNOT_CREATE_IMAGE_TR,

/* event.c */
IDGS_CANNOT_WRITE_IMAGE_FILE_S,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_DA,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_DE,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_FR,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_HU,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_IT,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_NL,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_PL,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_SV,
IDGS_CANNOT_WRITE_IMAGE_FILE_S_TR,

/* event.c */
IDGS_CANNOT_FIND_MAPPED_NAME_S,
IDGS_CANNOT_FIND_MAPPED_NAME_S_DA,
IDGS_CANNOT_FIND_MAPPED_NAME_S_DE,
IDGS_CANNOT_FIND_MAPPED_NAME_S_FR,
IDGS_CANNOT_FIND_MAPPED_NAME_S_HU,
IDGS_CANNOT_FIND_MAPPED_NAME_S_IT,
IDGS_CANNOT_FIND_MAPPED_NAME_S_NL,
IDGS_CANNOT_FIND_MAPPED_NAME_S_PL,
IDGS_CANNOT_FIND_MAPPED_NAME_S_SV,
IDGS_CANNOT_FIND_MAPPED_NAME_S_TR,

/* event.c */
IDGS_CANT_CREATE_START_SNAP_S,
IDGS_CANT_CREATE_START_SNAP_S_DA,
IDGS_CANT_CREATE_START_SNAP_S_DE,
IDGS_CANT_CREATE_START_SNAP_S_FR,
IDGS_CANT_CREATE_START_SNAP_S_HU,
IDGS_CANT_CREATE_START_SNAP_S_IT,
IDGS_CANT_CREATE_START_SNAP_S_NL,
IDGS_CANT_CREATE_START_SNAP_S_PL,
IDGS_CANT_CREATE_START_SNAP_S_SV,
IDGS_CANT_CREATE_START_SNAP_S_TR,

/* event.c */
IDGS_ERROR_READING_END_SNAP_S,
IDGS_ERROR_READING_END_SNAP_S_DA,
IDGS_ERROR_READING_END_SNAP_S_DE,
IDGS_ERROR_READING_END_SNAP_S_FR,
IDGS_ERROR_READING_END_SNAP_S_HU,
IDGS_ERROR_READING_END_SNAP_S_IT,
IDGS_ERROR_READING_END_SNAP_S_NL,
IDGS_ERROR_READING_END_SNAP_S_PL,
IDGS_ERROR_READING_END_SNAP_S_SV,
IDGS_ERROR_READING_END_SNAP_S_TR,

/* event.c */
IDGS_CANT_CREATE_END_SNAP_S,
IDGS_CANT_CREATE_END_SNAP_S_DA,
IDGS_CANT_CREATE_END_SNAP_S_DE,
IDGS_CANT_CREATE_END_SNAP_S_FR,
IDGS_CANT_CREATE_END_SNAP_S_HU,
IDGS_CANT_CREATE_END_SNAP_S_IT,
IDGS_CANT_CREATE_END_SNAP_S_NL,
IDGS_CANT_CREATE_END_SNAP_S_PL,
IDGS_CANT_CREATE_END_SNAP_S_SV,
IDGS_CANT_CREATE_END_SNAP_S_TR,

/* event.c */
IDGS_CANT_OPEN_END_SNAP_S,
IDGS_CANT_OPEN_END_SNAP_S_DA,
IDGS_CANT_OPEN_END_SNAP_S_DE,
IDGS_CANT_OPEN_END_SNAP_S_FR,
IDGS_CANT_OPEN_END_SNAP_S_HU,
IDGS_CANT_OPEN_END_SNAP_S_IT,
IDGS_CANT_OPEN_END_SNAP_S_NL,
IDGS_CANT_OPEN_END_SNAP_S_PL,
IDGS_CANT_OPEN_END_SNAP_S_SV,
IDGS_CANT_OPEN_END_SNAP_S_TR,

/* event.c */
IDGS_CANT_FIND_SECTION_END_SNAP,
IDGS_CANT_FIND_SECTION_END_SNAP_DA,
IDGS_CANT_FIND_SECTION_END_SNAP_DE,
IDGS_CANT_FIND_SECTION_END_SNAP_FR,
IDGS_CANT_FIND_SECTION_END_SNAP_HU,
IDGS_CANT_FIND_SECTION_END_SNAP_IT,
IDGS_CANT_FIND_SECTION_END_SNAP_NL,
IDGS_CANT_FIND_SECTION_END_SNAP_PL,
IDGS_CANT_FIND_SECTION_END_SNAP_SV,
IDGS_CANT_FIND_SECTION_END_SNAP_TR,

/* event.c */
IDGS_ERROR_READING_START_SNAP_TRIED,
IDGS_ERROR_READING_START_SNAP_TRIED_DA,
IDGS_ERROR_READING_START_SNAP_TRIED_DE,
IDGS_ERROR_READING_START_SNAP_TRIED_FR,
IDGS_ERROR_READING_START_SNAP_TRIED_HU,
IDGS_ERROR_READING_START_SNAP_TRIED_IT,
IDGS_ERROR_READING_START_SNAP_TRIED_NL,
IDGS_ERROR_READING_START_SNAP_TRIED_PL,
IDGS_ERROR_READING_START_SNAP_TRIED_SV,
IDGS_ERROR_READING_START_SNAP_TRIED_TR,

/* event.c */
IDGS_ERROR_READING_START_SNAP,
IDGS_ERROR_READING_START_SNAP_DA,
IDGS_ERROR_READING_START_SNAP_DE,
IDGS_ERROR_READING_START_SNAP_FR,
IDGS_ERROR_READING_START_SNAP_HU,
IDGS_ERROR_READING_START_SNAP_IT,
IDGS_ERROR_READING_START_SNAP_NL,
IDGS_ERROR_READING_START_SNAP_PL,
IDGS_ERROR_READING_START_SNAP_SV,
IDGS_ERROR_READING_START_SNAP_TR,

/* screenshot.c */
IDGS_SORRY_NO_MULTI_RECORDING,
IDGS_SORRY_NO_MULTI_RECORDING_DA,
IDGS_SORRY_NO_MULTI_RECORDING_DE,
IDGS_SORRY_NO_MULTI_RECORDING_FR,
IDGS_SORRY_NO_MULTI_RECORDING_HU,
IDGS_SORRY_NO_MULTI_RECORDING_IT,
IDGS_SORRY_NO_MULTI_RECORDING_NL,
IDGS_SORRY_NO_MULTI_RECORDING_PL,
IDGS_SORRY_NO_MULTI_RECORDING_SV,
IDGS_SORRY_NO_MULTI_RECORDING_TR,

/* sound.c */
IDGS_RECORD_DEVICE_S_NOT_EXIST,
IDGS_RECORD_DEVICE_S_NOT_EXIST_DA,
IDGS_RECORD_DEVICE_S_NOT_EXIST_DE,
IDGS_RECORD_DEVICE_S_NOT_EXIST_FR,
IDGS_RECORD_DEVICE_S_NOT_EXIST_HU,
IDGS_RECORD_DEVICE_S_NOT_EXIST_IT,
IDGS_RECORD_DEVICE_S_NOT_EXIST_NL,
IDGS_RECORD_DEVICE_S_NOT_EXIST_PL,
IDGS_RECORD_DEVICE_S_NOT_EXIST_SV,
IDGS_RECORD_DEVICE_S_NOT_EXIST_TR,

/* sound.c */
IDGS_RECORD_DIFFERENT_PLAYBACK,
IDGS_RECORD_DIFFERENT_PLAYBACK_DA,
IDGS_RECORD_DIFFERENT_PLAYBACK_DE,
IDGS_RECORD_DIFFERENT_PLAYBACK_FR,
IDGS_RECORD_DIFFERENT_PLAYBACK_HU,
IDGS_RECORD_DIFFERENT_PLAYBACK_IT,
IDGS_RECORD_DIFFERENT_PLAYBACK_NL,
IDGS_RECORD_DIFFERENT_PLAYBACK_PL,
IDGS_RECORD_DIFFERENT_PLAYBACK_SV,
IDGS_RECORD_DIFFERENT_PLAYBACK_TR,

/* sound.c */
IDGS_WARNING_RECORDING_REALTIME,
IDGS_WARNING_RECORDING_REALTIME_DA,
IDGS_WARNING_RECORDING_REALTIME_DE,
IDGS_WARNING_RECORDING_REALTIME_FR,
IDGS_WARNING_RECORDING_REALTIME_HU,
IDGS_WARNING_RECORDING_REALTIME_IT,
IDGS_WARNING_RECORDING_REALTIME_NL,
IDGS_WARNING_RECORDING_REALTIME_PL,
IDGS_WARNING_RECORDING_REALTIME_SV,
IDGS_WARNING_RECORDING_REALTIME_TR,

/* sound.c */
IDGS_INIT_FAILED_FOR_DEVICE_S,
IDGS_INIT_FAILED_FOR_DEVICE_S_DA,
IDGS_INIT_FAILED_FOR_DEVICE_S_DE,
IDGS_INIT_FAILED_FOR_DEVICE_S_FR,
IDGS_INIT_FAILED_FOR_DEVICE_S_HU,
IDGS_INIT_FAILED_FOR_DEVICE_S_IT,
IDGS_INIT_FAILED_FOR_DEVICE_S_NL,
IDGS_INIT_FAILED_FOR_DEVICE_S_PL,
IDGS_INIT_FAILED_FOR_DEVICE_S_SV,
IDGS_INIT_FAILED_FOR_DEVICE_S_TR,

/* sound.c */
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DA,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_DE,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_FR,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_HU,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_IT,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_NL,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_PL,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_SV,
IDGS_RECORD_NOT_SUPPORT_SOUND_PAR_TR,

/* sound.c */
IDGS_WRITE_TO_SOUND_DEVICE_FAILED,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DA,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_DE,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_FR,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_HU,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_IT,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_NL,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_PL,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_SV,
IDGS_WRITE_TO_SOUND_DEVICE_FAILED_TR,

/* sound.c */
IDGS_CANNOT_OPEN_SID_ENGINE,
IDGS_CANNOT_OPEN_SID_ENGINE_DA,
IDGS_CANNOT_OPEN_SID_ENGINE_DE,
IDGS_CANNOT_OPEN_SID_ENGINE_FR,
IDGS_CANNOT_OPEN_SID_ENGINE_HU,
IDGS_CANNOT_OPEN_SID_ENGINE_IT,
IDGS_CANNOT_OPEN_SID_ENGINE_NL,
IDGS_CANNOT_OPEN_SID_ENGINE_PL,
IDGS_CANNOT_OPEN_SID_ENGINE_SV,
IDGS_CANNOT_OPEN_SID_ENGINE_TR,

/* sound.c */
IDGS_CANNOT_INIT_SID_ENGINE,
IDGS_CANNOT_INIT_SID_ENGINE_DA,
IDGS_CANNOT_INIT_SID_ENGINE_DE,
IDGS_CANNOT_INIT_SID_ENGINE_FR,
IDGS_CANNOT_INIT_SID_ENGINE_HU,
IDGS_CANNOT_INIT_SID_ENGINE_IT,
IDGS_CANNOT_INIT_SID_ENGINE_NL,
IDGS_CANNOT_INIT_SID_ENGINE_PL,
IDGS_CANNOT_INIT_SID_ENGINE_SV,
IDGS_CANNOT_INIT_SID_ENGINE_TR,

/* sound.c */
IDGS_DEVICE_S_NOT_FOUND_SUPPORT,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DA,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_DE,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_FR,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_HU,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_IT,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_NL,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_PL,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_SV,
IDGS_DEVICE_S_NOT_FOUND_SUPPORT_TR,

/* sound.c */
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DA,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_DE,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_FR,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_HU,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_IT,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_NL,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_PL,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_SV,
IDGS_SOUND_BUFFER_OVERFLOW_CYCLE_TR,

/* sound.c */
IDGS_SOUND_BUFFER_OVERFLOW,
IDGS_SOUND_BUFFER_OVERFLOW_DA,
IDGS_SOUND_BUFFER_OVERFLOW_DE,
IDGS_SOUND_BUFFER_OVERFLOW_FR,
IDGS_SOUND_BUFFER_OVERFLOW_HU,
IDGS_SOUND_BUFFER_OVERFLOW_IT,
IDGS_SOUND_BUFFER_OVERFLOW_NL,
IDGS_SOUND_BUFFER_OVERFLOW_PL,
IDGS_SOUND_BUFFER_OVERFLOW_SV,
IDGS_SOUND_BUFFER_OVERFLOW_TR,

/* sound.c */
IDGS_CANNOT_FLUSH,
IDGS_CANNOT_FLUSH_DA,
IDGS_CANNOT_FLUSH_DE,
IDGS_CANNOT_FLUSH_FR,
IDGS_CANNOT_FLUSH_HU,
IDGS_CANNOT_FLUSH_IT,
IDGS_CANNOT_FLUSH_NL,
IDGS_CANNOT_FLUSH_PL,
IDGS_CANNOT_FLUSH_SV,
IDGS_CANNOT_FLUSH_TR,

/* sound.c */
IDGS_FRAGMENT_PROBLEMS,
IDGS_FRAGMENT_PROBLEMS_DA,
IDGS_FRAGMENT_PROBLEMS_DE,
IDGS_FRAGMENT_PROBLEMS_FR,
IDGS_FRAGMENT_PROBLEMS_HU,
IDGS_FRAGMENT_PROBLEMS_IT,
IDGS_FRAGMENT_PROBLEMS_NL,
IDGS_FRAGMENT_PROBLEMS_PL,
IDGS_FRAGMENT_PROBLEMS_SV,
IDGS_FRAGMENT_PROBLEMS_TR,

/* sound.c */
IDGS_RUNNING_TOO_SLOW,
IDGS_RUNNING_TOO_SLOW_DA,
IDGS_RUNNING_TOO_SLOW_DE,
IDGS_RUNNING_TOO_SLOW_FR,
IDGS_RUNNING_TOO_SLOW_HU,
IDGS_RUNNING_TOO_SLOW_IT,
IDGS_RUNNING_TOO_SLOW_NL,
IDGS_RUNNING_TOO_SLOW_PL,
IDGS_RUNNING_TOO_SLOW_SV,
IDGS_RUNNING_TOO_SLOW_TR,

/* sound.c */
IDGS_STORE_SOUNDDEVICE_FAILED,
IDGS_STORE_SOUNDDEVICE_FAILED_DA,
IDGS_STORE_SOUNDDEVICE_FAILED_DE,
IDGS_STORE_SOUNDDEVICE_FAILED_FR,
IDGS_STORE_SOUNDDEVICE_FAILED_HU,
IDGS_STORE_SOUNDDEVICE_FAILED_IT,
IDGS_STORE_SOUNDDEVICE_FAILED_NL,
IDGS_STORE_SOUNDDEVICE_FAILED_PL,
IDGS_STORE_SOUNDDEVICE_FAILED_SV,
IDGS_STORE_SOUNDDEVICE_FAILED_TR,

/* c64/c64export.c */
IDGS_RESOURCE_S_BLOCKED_BY_S,
IDGS_RESOURCE_S_BLOCKED_BY_S_DA,
IDGS_RESOURCE_S_BLOCKED_BY_S_DE,
IDGS_RESOURCE_S_BLOCKED_BY_S_FR,
IDGS_RESOURCE_S_BLOCKED_BY_S_HU,
IDGS_RESOURCE_S_BLOCKED_BY_S_IT,
IDGS_RESOURCE_S_BLOCKED_BY_S_NL,
IDGS_RESOURCE_S_BLOCKED_BY_S_PL,
IDGS_RESOURCE_S_BLOCKED_BY_S_SV,
IDGS_RESOURCE_S_BLOCKED_BY_S_TR,

#ifdef HAVE_NETWORK
/* network.c */
IDGS_TESTING_BEST_FRAME_DELAY,
IDGS_TESTING_BEST_FRAME_DELAY_DA,
IDGS_TESTING_BEST_FRAME_DELAY_DE,
IDGS_TESTING_BEST_FRAME_DELAY_FR,
IDGS_TESTING_BEST_FRAME_DELAY_HU,
IDGS_TESTING_BEST_FRAME_DELAY_IT,
IDGS_TESTING_BEST_FRAME_DELAY_NL,
IDGS_TESTING_BEST_FRAME_DELAY_PL,
IDGS_TESTING_BEST_FRAME_DELAY_SV,
IDGS_TESTING_BEST_FRAME_DELAY_TR,

/* network.c */
IDGS_USING_D_FRAMES_DELAY,
IDGS_USING_D_FRAMES_DELAY_DA,
IDGS_USING_D_FRAMES_DELAY_DE,
IDGS_USING_D_FRAMES_DELAY_FR,
IDGS_USING_D_FRAMES_DELAY_HU,
IDGS_USING_D_FRAMES_DELAY_IT,
IDGS_USING_D_FRAMES_DELAY_NL,
IDGS_USING_D_FRAMES_DELAY_PL,
IDGS_USING_D_FRAMES_DELAY_SV,
IDGS_USING_D_FRAMES_DELAY_TR,

/* network.c */
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DA,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_DE,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_FR,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_HU,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_IT,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_NL,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_PL,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_SV,
IDGS_CANNOT_LOAD_SNAPSHOT_TRANSFER_TR,

/* network.c */
IDGS_SENDING_SNAPSHOT_TO_CLIENT,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_DA,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_DE,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_FR,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_HU,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_IT,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_NL,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_PL,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_SV,
IDGS_SENDING_SNAPSHOT_TO_CLIENT_TR,

/* network.c */
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DA,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_DE,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_FR,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_HU,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_IT,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_NL,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_PL,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_SV,
IDGS_CANNOT_SEND_SNAPSHOT_TO_CLIENT_TR,

/* network.c */
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DA,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_DE,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_FR,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_HU,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_IT,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_NL,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_PL,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_SV,
IDGS_CANNOT_CREATE_SNAPSHOT_FILE_S_TR,

/* network.c */
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DA,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_DE,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_FR,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_HU,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_IT,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_NL,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_PL,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_SV,
IDGS_CANNOT_OPEN_SNAPSHOT_FILE_S_TR,

/* network.c */
IDGS_SERVER_IS_WAITING_FOR_CLIENT,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_DA,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_DE,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_FR,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_HU,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_IT,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_NL,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_PL,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_SV,
IDGS_SERVER_IS_WAITING_FOR_CLIENT_TR,

/* network.c */
IDGS_CANNOT_RESOLVE_S,
IDGS_CANNOT_RESOLVE_S_DA,
IDGS_CANNOT_RESOLVE_S_DE,
IDGS_CANNOT_RESOLVE_S_FR,
IDGS_CANNOT_RESOLVE_S_HU,
IDGS_CANNOT_RESOLVE_S_IT,
IDGS_CANNOT_RESOLVE_S_NL,
IDGS_CANNOT_RESOLVE_S_PL,
IDGS_CANNOT_RESOLVE_S_SV,
IDGS_CANNOT_RESOLVE_S_TR,

/* network.c */
IDGS_CANNOT_CONNECT_TO_S,
IDGS_CANNOT_CONNECT_TO_S_DA,
IDGS_CANNOT_CONNECT_TO_S_DE,
IDGS_CANNOT_CONNECT_TO_S_FR,
IDGS_CANNOT_CONNECT_TO_S_HU,
IDGS_CANNOT_CONNECT_TO_S_IT,
IDGS_CANNOT_CONNECT_TO_S_NL,
IDGS_CANNOT_CONNECT_TO_S_PL,
IDGS_CANNOT_CONNECT_TO_S_SV,
IDGS_CANNOT_CONNECT_TO_S_TR,

/* network.c */
IDGS_RECEIVING_SNAPSHOT_SERVER,
IDGS_RECEIVING_SNAPSHOT_SERVER_DA,
IDGS_RECEIVING_SNAPSHOT_SERVER_DE,
IDGS_RECEIVING_SNAPSHOT_SERVER_FR,
IDGS_RECEIVING_SNAPSHOT_SERVER_HU,
IDGS_RECEIVING_SNAPSHOT_SERVER_IT,
IDGS_RECEIVING_SNAPSHOT_SERVER_NL,
IDGS_RECEIVING_SNAPSHOT_SERVER_PL,
IDGS_RECEIVING_SNAPSHOT_SERVER_SV,
IDGS_RECEIVING_SNAPSHOT_SERVER_TR,

/* network.c */
IDGS_NETWORK_OUT_OF_SYNC,
IDGS_NETWORK_OUT_OF_SYNC_DA,
IDGS_NETWORK_OUT_OF_SYNC_DE,
IDGS_NETWORK_OUT_OF_SYNC_FR,
IDGS_NETWORK_OUT_OF_SYNC_HU,
IDGS_NETWORK_OUT_OF_SYNC_IT,
IDGS_NETWORK_OUT_OF_SYNC_NL,
IDGS_NETWORK_OUT_OF_SYNC_PL,
IDGS_NETWORK_OUT_OF_SYNC_SV,
IDGS_NETWORK_OUT_OF_SYNC_TR,

/* network.c */
IDGS_REMOTE_HOST_DISCONNECTED,
IDGS_REMOTE_HOST_DISCONNECTED_DA,
IDGS_REMOTE_HOST_DISCONNECTED_DE,
IDGS_REMOTE_HOST_DISCONNECTED_FR,
IDGS_REMOTE_HOST_DISCONNECTED_HU,
IDGS_REMOTE_HOST_DISCONNECTED_IT,
IDGS_REMOTE_HOST_DISCONNECTED_NL,
IDGS_REMOTE_HOST_DISCONNECTED_PL,
IDGS_REMOTE_HOST_DISCONNECTED_SV,
IDGS_REMOTE_HOST_DISCONNECTED_TR,

/* network.c */
IDGS_REMOTE_HOST_SUSPENDING,
IDGS_REMOTE_HOST_SUSPENDING_DA,
IDGS_REMOTE_HOST_SUSPENDING_DE,
IDGS_REMOTE_HOST_SUSPENDING_FR,
IDGS_REMOTE_HOST_SUSPENDING_HU,
IDGS_REMOTE_HOST_SUSPENDING_IT,
IDGS_REMOTE_HOST_SUSPENDING_NL,
IDGS_REMOTE_HOST_SUSPENDING_PL,
IDGS_REMOTE_HOST_SUSPENDING_SV,
IDGS_REMOTE_HOST_SUSPENDING_TR,

#ifdef HAVE_IPV6
/* network.c */
IDGS_CANNOT_SWITCH_IPV4_IPV6,
IDGS_CANNOT_SWITCH_IPV4_IPV6_DA,
IDGS_CANNOT_SWITCH_IPV4_IPV6_DE,
IDGS_CANNOT_SWITCH_IPV4_IPV6_FR,
IDGS_CANNOT_SWITCH_IPV4_IPV6_HU,
IDGS_CANNOT_SWITCH_IPV4_IPV6_IT,
IDGS_CANNOT_SWITCH_IPV4_IPV6_NL,
IDGS_CANNOT_SWITCH_IPV4_IPV6_PL,
IDGS_CANNOT_SWITCH_IPV4_IPV6_SV,
IDGS_CANNOT_SWITCH_IPV4_IPV6_TR,
#endif   /* HAVE_IPV6 */

/* network.c */
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DA,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_DE,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_FR,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_HU,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_IT,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_NL,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_PL,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_SV,
IDGS_CANNOT_CREATE_SNAPSHOT_S_SELECT_TR,
#endif   /* HAVE_NETWORK */

/* gfxoutputdrv/ffmpegdrv.c */
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DA,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_DE,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_FR,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_HU,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_IT,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_NL,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_PL,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_SV,
IDGS_FFMPEG_CANNOT_OPEN_VSTREAM_TR,

/* gfxoutputdrv/ffmpegdrv.c */
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DA,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_DE,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_FR,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_HU,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_IT,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_NL,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_PL,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_SV,
IDGS_FFMPEG_CANNOT_OPEN_ASTREAM_TR,

/* gfxoutputdrv/ffmpegdrv.c */
IDGS_FFMPEG_CANNOT_OPEN_S,
IDGS_FFMPEG_CANNOT_OPEN_S_DA,
IDGS_FFMPEG_CANNOT_OPEN_S_DE,
IDGS_FFMPEG_CANNOT_OPEN_S_FR,
IDGS_FFMPEG_CANNOT_OPEN_S_HU,
IDGS_FFMPEG_CANNOT_OPEN_S_IT,
IDGS_FFMPEG_CANNOT_OPEN_S_NL,
IDGS_FFMPEG_CANNOT_OPEN_S_PL,
IDGS_FFMPEG_CANNOT_OPEN_S_SV,
IDGS_FFMPEG_CANNOT_OPEN_S_TR,

/* c64/c64io.c */
IDGS_IO_READ_COLL_AT_X_FROM,
IDGS_IO_READ_COLL_AT_X_FROM_DA,
IDGS_IO_READ_COLL_AT_X_FROM_DE,
IDGS_IO_READ_COLL_AT_X_FROM_FR,
IDGS_IO_READ_COLL_AT_X_FROM_HU,
IDGS_IO_READ_COLL_AT_X_FROM_IT,
IDGS_IO_READ_COLL_AT_X_FROM_NL,
IDGS_IO_READ_COLL_AT_X_FROM_PL,
IDGS_IO_READ_COLL_AT_X_FROM_SV,
IDGS_IO_READ_COLL_AT_X_FROM_TR,

/* c64/c64io.c */
IDGS_AND,
IDGS_AND_DA,
IDGS_AND_DE,
IDGS_AND_FR,
IDGS_AND_HU,
IDGS_AND_IT,
IDGS_AND_NL,
IDGS_AND_PL,
IDGS_AND_SV,
IDGS_AND_TR,

/* c64/c64io.c */
IDGS_ALL_DEVICES_DETACHED,
IDGS_ALL_DEVICES_DETACHED_DA,
IDGS_ALL_DEVICES_DETACHED_DE,
IDGS_ALL_DEVICES_DETACHED_FR,
IDGS_ALL_DEVICES_DETACHED_HU,
IDGS_ALL_DEVICES_DETACHED_IT,
IDGS_ALL_DEVICES_DETACHED_NL,
IDGS_ALL_DEVICES_DETACHED_PL,
IDGS_ALL_DEVICES_DETACHED_SV,
IDGS_ALL_DEVICES_DETACHED_TR,

/* c64dtv/c64dtvflash.c */
IDGS_NO_FILENAME,
IDGS_NO_FILENAME_DA,
IDGS_NO_FILENAME_DE,
IDGS_NO_FILENAME_FR,
IDGS_NO_FILENAME_HU,
IDGS_NO_FILENAME_IT,
IDGS_NO_FILENAME_NL,
IDGS_NO_FILENAME_PL,
IDGS_NO_FILENAME_SV,
IDGS_NO_FILENAME_TR,

/* c64dtv/c64dtvflash.c */
IDGS_ILLEGAL_FILENAME,
IDGS_ILLEGAL_FILENAME_DA,
IDGS_ILLEGAL_FILENAME_DE,
IDGS_ILLEGAL_FILENAME_FR,
IDGS_ILLEGAL_FILENAME_HU,
IDGS_ILLEGAL_FILENAME_IT,
IDGS_ILLEGAL_FILENAME_NL,
IDGS_ILLEGAL_FILENAME_PL,
IDGS_ILLEGAL_FILENAME_SV,
IDGS_ILLEGAL_FILENAME_TR,

/* c64dtv/c64dtvflash.c */
IDGS_ERROR_CREATING_FILE_S,
IDGS_ERROR_CREATING_FILE_S_DA,
IDGS_ERROR_CREATING_FILE_S_DE,
IDGS_ERROR_CREATING_FILE_S_FR,
IDGS_ERROR_CREATING_FILE_S_HU,
IDGS_ERROR_CREATING_FILE_S_IT,
IDGS_ERROR_CREATING_FILE_S_NL,
IDGS_ERROR_CREATING_FILE_S_PL,
IDGS_ERROR_CREATING_FILE_S_SV,
IDGS_ERROR_CREATING_FILE_S_TR,

/* c64dtv/c64dtvflash.c */
IDGS_ERROR_WRITING_TO_FILE_S,
IDGS_ERROR_WRITING_TO_FILE_S_DA,
IDGS_ERROR_WRITING_TO_FILE_S_DE,
IDGS_ERROR_WRITING_TO_FILE_S_FR,
IDGS_ERROR_WRITING_TO_FILE_S_HU,
IDGS_ERROR_WRITING_TO_FILE_S_IT,
IDGS_ERROR_WRITING_TO_FILE_S_NL,
IDGS_ERROR_WRITING_TO_FILE_S_PL,
IDGS_ERROR_WRITING_TO_FILE_S_SV,
IDGS_ERROR_WRITING_TO_FILE_S_TR,

/* c64dtv/c64dtvflash.c */
IDCLS_ENABLE_DTV_FLASH_LOG,
IDCLS_ENABLE_DTV_FLASH_LOG_DA,
IDCLS_ENABLE_DTV_FLASH_LOG_DE,
IDCLS_ENABLE_DTV_FLASH_LOG_FR,
IDCLS_ENABLE_DTV_FLASH_LOG_HU,
IDCLS_ENABLE_DTV_FLASH_LOG_IT,
IDCLS_ENABLE_DTV_FLASH_LOG_NL,
IDCLS_ENABLE_DTV_FLASH_LOG_PL,
IDCLS_ENABLE_DTV_FLASH_LOG_SV,
IDCLS_ENABLE_DTV_FLASH_LOG_TR,

/* c64dtv/c64dtvflash.c */
IDCLS_DISABLE_DTV_FLASH_LOG,
IDCLS_DISABLE_DTV_FLASH_LOG_DA,
IDCLS_DISABLE_DTV_FLASH_LOG_DE,
IDCLS_DISABLE_DTV_FLASH_LOG_FR,
IDCLS_DISABLE_DTV_FLASH_LOG_HU,
IDCLS_DISABLE_DTV_FLASH_LOG_IT,
IDCLS_DISABLE_DTV_FLASH_LOG_NL,
IDCLS_DISABLE_DTV_FLASH_LOG_PL,
IDCLS_DISABLE_DTV_FLASH_LOG_SV,
IDCLS_DISABLE_DTV_FLASH_LOG_TR,

/* c64dtv/c64dtvflash.c */
IDGS_DTV_ROM_CREATED,
IDGS_DTV_ROM_CREATED_DA,
IDGS_DTV_ROM_CREATED_DE,
IDGS_DTV_ROM_CREATED_FR,
IDGS_DTV_ROM_CREATED_HU,
IDGS_DTV_ROM_CREATED_IT,
IDGS_DTV_ROM_CREATED_NL,
IDGS_DTV_ROM_CREATED_PL,
IDGS_DTV_ROM_CREATED_SV,
IDGS_DTV_ROM_CREATED_TR,


/* COMMAND-LINE STRING ID DEFINITIONS */
/* autostart.c */
IDCLS_AUTOSTART_LOAD_TO_BASIC_START,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DA,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_DE,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_FR,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_HU,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_IT,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_NL,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_PL,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_SV,
IDCLS_AUTOSTART_LOAD_TO_BASIC_START_TR,

/* autostart.c */
IDCLS_AUTOSTART_LOAD_WITH_1,
IDCLS_AUTOSTART_LOAD_WITH_1_DA,
IDCLS_AUTOSTART_LOAD_WITH_1_DE,
IDCLS_AUTOSTART_LOAD_WITH_1_FR,
IDCLS_AUTOSTART_LOAD_WITH_1_HU,
IDCLS_AUTOSTART_LOAD_WITH_1_IT,
IDCLS_AUTOSTART_LOAD_WITH_1_NL,
IDCLS_AUTOSTART_LOAD_WITH_1_PL,
IDCLS_AUTOSTART_LOAD_WITH_1_SV,
IDCLS_AUTOSTART_LOAD_WITH_1_TR,

/* autostart.c */
IDCLS_ENABLE_AUTOSTARTWITHCOLON,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_DA,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_DE,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_FR,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_HU,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_IT,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_NL,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_PL,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_SV,
IDCLS_ENABLE_AUTOSTARTWITHCOLON_TR,

/* autostart.c */
IDCLS_DISABLE_AUTOSTARTWITHCOLON,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_DA,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_DE,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_FR,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_HU,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_IT,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_NL,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_PL,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_SV,
IDCLS_DISABLE_AUTOSTARTWITHCOLON_TR,

/* autostart.c */
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DA,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_DE,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_FR,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_HU,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_IT,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_NL,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_PL,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_SV,
IDCLS_ENABLE_AUTOSTART_HANDLE_TDE_TR,

/* autostart.c */
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DA,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_DE,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_FR,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_HU,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_IT,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_NL,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_PL,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_SV,
IDCLS_DISABLE_AUTOSTART_HANDLE_TDE_TR,

/* autostart.c */
IDCLS_ENABLE_WARP_MODE_AUTOSTART,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_DA,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_DE,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_FR,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_HU,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_IT,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_NL,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_PL,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_SV,
IDCLS_ENABLE_WARP_MODE_AUTOSTART_TR,

/* autostart.c */
IDCLS_DISABLE_WARP_MODE_AUTOSTART,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_DA,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_DE,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_FR,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_HU,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_IT,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_NL,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_PL,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_SV,
IDCLS_DISABLE_WARP_MODE_AUTOSTART_TR,

/* autostart.c */
IDCLS_SET_AUTOSTART_MODE_FOR_PRG,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DA,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_DE,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_FR,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_HU,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_IT,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_NL,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_PL,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_SV,
IDCLS_SET_AUTOSTART_MODE_FOR_PRG_TR,

/* autostart.c */
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DA,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_DE,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_FR,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_HU,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_IT,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_NL,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_PL,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_SV,
IDCLS_SET_DISK_IMAGE_FOR_AUTOSTART_PRG_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_USE_PAL_SYNC_FACTOR,
IDCLS_USE_PAL_SYNC_FACTOR_DA,
IDCLS_USE_PAL_SYNC_FACTOR_DE,
IDCLS_USE_PAL_SYNC_FACTOR_FR,
IDCLS_USE_PAL_SYNC_FACTOR_HU,
IDCLS_USE_PAL_SYNC_FACTOR_IT,
IDCLS_USE_PAL_SYNC_FACTOR_NL,
IDCLS_USE_PAL_SYNC_FACTOR_PL,
IDCLS_USE_PAL_SYNC_FACTOR_SV,
IDCLS_USE_PAL_SYNC_FACTOR_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_USE_NTSC_SYNC_FACTOR,
IDCLS_USE_NTSC_SYNC_FACTOR_DA,
IDCLS_USE_NTSC_SYNC_FACTOR_DE,
IDCLS_USE_NTSC_SYNC_FACTOR_FR,
IDCLS_USE_NTSC_SYNC_FACTOR_HU,
IDCLS_USE_NTSC_SYNC_FACTOR_IT,
IDCLS_USE_NTSC_SYNC_FACTOR_NL,
IDCLS_USE_NTSC_SYNC_FACTOR_PL,
IDCLS_USE_NTSC_SYNC_FACTOR_SV,
IDCLS_USE_NTSC_SYNC_FACTOR_TR,

/* c128/c128-cmdline-options.c, c128/functionrom.c,
c64/c64-cmdline-options.c, c64/cart/georam.c,
c64/cart/ramcart.c, c64/cart/reu.c, c64/cart/c64cart.c,
c64/cart/ide64.c, cbm2/cbm2-cmdline-options.c,
drive/iec/iec-cmdline-options.c, drive/iec128dcr/iec128dcr-cmdline-options.c,
drive/ieee/ieee-cmdline-options.c, drive/tcbm/tcbm-cmdline-options.c,
fsdevice/fsdevice-cmdline-options.c, pet/pet-cmdline-options.c,
plus4/plus4-cmdline-options.c, printerdrv/driver-select.c,
printerdrv/output-select.c, printerdrv/output-text.c,
rs232drv/rs232drv.c, vic20/vic20-cmdline-options.c,
vic20/vic20cartridge.c, video/video-cmdline-options.c,
fliplist.c, initcmdline.c, log.c, sound.c, c64/plus60k.c,
c64/c64_256k.c, pet/petreu.c, c64/plus256k.c,
c64/cart/mmc64.c */
IDCLS_P_NAME,
IDCLS_P_NAME_DA,
IDCLS_P_NAME_DE,
IDCLS_P_NAME_FR,
IDCLS_P_NAME_HU,
IDCLS_P_NAME_IT,
IDCLS_P_NAME_NL,
IDCLS_P_NAME_PL,
IDCLS_P_NAME_SV,
IDCLS_P_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_INT_KERNEL_NAME,
IDCLS_SPECIFY_INT_KERNEL_NAME_DA,
IDCLS_SPECIFY_INT_KERNEL_NAME_DE,
IDCLS_SPECIFY_INT_KERNEL_NAME_FR,
IDCLS_SPECIFY_INT_KERNEL_NAME_HU,
IDCLS_SPECIFY_INT_KERNEL_NAME_IT,
IDCLS_SPECIFY_INT_KERNEL_NAME_NL,
IDCLS_SPECIFY_INT_KERNEL_NAME_PL,
IDCLS_SPECIFY_INT_KERNEL_NAME_SV,
IDCLS_SPECIFY_INT_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_DE_KERNEL_NAME,
IDCLS_SPECIFY_DE_KERNEL_NAME_DA,
IDCLS_SPECIFY_DE_KERNEL_NAME_DE,
IDCLS_SPECIFY_DE_KERNEL_NAME_FR,
IDCLS_SPECIFY_DE_KERNEL_NAME_HU,
IDCLS_SPECIFY_DE_KERNEL_NAME_IT,
IDCLS_SPECIFY_DE_KERNEL_NAME_NL,
IDCLS_SPECIFY_DE_KERNEL_NAME_PL,
IDCLS_SPECIFY_DE_KERNEL_NAME_SV,
IDCLS_SPECIFY_DE_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_FI_KERNEL_NAME,
IDCLS_SPECIFY_FI_KERNEL_NAME_DA,
IDCLS_SPECIFY_FI_KERNEL_NAME_DE,
IDCLS_SPECIFY_FI_KERNEL_NAME_FR,
IDCLS_SPECIFY_FI_KERNEL_NAME_HU,
IDCLS_SPECIFY_FI_KERNEL_NAME_IT,
IDCLS_SPECIFY_FI_KERNEL_NAME_NL,
IDCLS_SPECIFY_FI_KERNEL_NAME_PL,
IDCLS_SPECIFY_FI_KERNEL_NAME_SV,
IDCLS_SPECIFY_FI_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_FR_KERNEL_NAME,
IDCLS_SPECIFY_FR_KERNEL_NAME_DA,
IDCLS_SPECIFY_FR_KERNEL_NAME_DE,
IDCLS_SPECIFY_FR_KERNEL_NAME_FR,
IDCLS_SPECIFY_FR_KERNEL_NAME_HU,
IDCLS_SPECIFY_FR_KERNEL_NAME_IT,
IDCLS_SPECIFY_FR_KERNEL_NAME_NL,
IDCLS_SPECIFY_FR_KERNEL_NAME_PL,
IDCLS_SPECIFY_FR_KERNEL_NAME_SV,
IDCLS_SPECIFY_FR_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_IT_KERNEL_NAME,
IDCLS_SPECIFY_IT_KERNEL_NAME_DA,
IDCLS_SPECIFY_IT_KERNEL_NAME_DE,
IDCLS_SPECIFY_IT_KERNEL_NAME_FR,
IDCLS_SPECIFY_IT_KERNEL_NAME_HU,
IDCLS_SPECIFY_IT_KERNEL_NAME_IT,
IDCLS_SPECIFY_IT_KERNEL_NAME_NL,
IDCLS_SPECIFY_IT_KERNEL_NAME_PL,
IDCLS_SPECIFY_IT_KERNEL_NAME_SV,
IDCLS_SPECIFY_IT_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_NO_KERNEL_NAME,
IDCLS_SPECIFY_NO_KERNEL_NAME_DA,
IDCLS_SPECIFY_NO_KERNEL_NAME_DE,
IDCLS_SPECIFY_NO_KERNEL_NAME_FR,
IDCLS_SPECIFY_NO_KERNEL_NAME_HU,
IDCLS_SPECIFY_NO_KERNEL_NAME_IT,
IDCLS_SPECIFY_NO_KERNEL_NAME_NL,
IDCLS_SPECIFY_NO_KERNEL_NAME_PL,
IDCLS_SPECIFY_NO_KERNEL_NAME_SV,
IDCLS_SPECIFY_NO_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_SV_KERNEL_NAME,
IDCLS_SPECIFY_SV_KERNEL_NAME_DA,
IDCLS_SPECIFY_SV_KERNEL_NAME_DE,
IDCLS_SPECIFY_SV_KERNEL_NAME_FR,
IDCLS_SPECIFY_SV_KERNEL_NAME_HU,
IDCLS_SPECIFY_SV_KERNEL_NAME_IT,
IDCLS_SPECIFY_SV_KERNEL_NAME_NL,
IDCLS_SPECIFY_SV_KERNEL_NAME_PL,
IDCLS_SPECIFY_SV_KERNEL_NAME_SV,
IDCLS_SPECIFY_SV_KERNEL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DA,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_DE,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_FR,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_HU,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_IT,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_NL,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_PL,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_SV,
IDCLS_SPECIFY_BASIC_ROM_NAME_LOW_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DA,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_DE,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_FR,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_HU,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_IT,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_NL,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_PL,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_SV,
IDCLS_SPECIFY_BASIC_ROM_NAME_HIGH_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DA,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_DE,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_FR,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_HU,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_IT,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_NL,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_PL,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_SV,
IDCLS_SPECIFY_INT_CHARGEN_ROM_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DA,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_DE,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_FR,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_HU,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_IT,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_NL,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_PL,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_SV,
IDCLS_SPECIFY_DE_CHARGEN_ROM_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DA,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_DE,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_FR,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_HU,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_IT,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_NL,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_PL,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_SV,
IDCLS_SPECIFY_FR_CHARGEN_ROM_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DA,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_DE,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_FR,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_HU,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_IT,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_NL,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_PL,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_SV,
IDCLS_SPECIFY_SV_CHARGEN_ROM_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DA,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_DE,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_FR,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_HU,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_IT,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_NL,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_PL,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_SV,
IDCLS_SPECIFY_C64_MODE_KERNAL_NAME_TR,

/* c128/c128-cmdline-options.c */
IDCLS_SPECIFY_C64_MODE_BASIC_NAME,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DA,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_DE,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_FR,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_HU,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_IT,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_NL,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_PL,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_SV,
IDCLS_SPECIFY_C64_MODE_BASIC_NAME_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_ENABLE_EMULATOR_ID,
IDCLS_ENABLE_EMULATOR_ID_DA,
IDCLS_ENABLE_EMULATOR_ID_DE,
IDCLS_ENABLE_EMULATOR_ID_FR,
IDCLS_ENABLE_EMULATOR_ID_HU,
IDCLS_ENABLE_EMULATOR_ID_IT,
IDCLS_ENABLE_EMULATOR_ID_NL,
IDCLS_ENABLE_EMULATOR_ID_PL,
IDCLS_ENABLE_EMULATOR_ID_SV,
IDCLS_ENABLE_EMULATOR_ID_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_DISABLE_EMULATOR_ID,
IDCLS_DISABLE_EMULATOR_ID_DA,
IDCLS_DISABLE_EMULATOR_ID_DE,
IDCLS_DISABLE_EMULATOR_ID_FR,
IDCLS_DISABLE_EMULATOR_ID_HU,
IDCLS_DISABLE_EMULATOR_ID_IT,
IDCLS_DISABLE_EMULATOR_ID_NL,
IDCLS_DISABLE_EMULATOR_ID_PL,
IDCLS_DISABLE_EMULATOR_ID_SV,
IDCLS_DISABLE_EMULATOR_ID_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_ENABLE_OEM_JOY,
IDCLS_ENABLE_OEM_JOY_DA,
IDCLS_ENABLE_OEM_JOY_DE,
IDCLS_ENABLE_OEM_JOY_FR,
IDCLS_ENABLE_OEM_JOY_HU,
IDCLS_ENABLE_OEM_JOY_IT,
IDCLS_ENABLE_OEM_JOY_NL,
IDCLS_ENABLE_OEM_JOY_PL,
IDCLS_ENABLE_OEM_JOY_SV,
IDCLS_ENABLE_OEM_JOY_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_DISABLE_OEM_JOY,
IDCLS_DISABLE_OEM_JOY_DA,
IDCLS_DISABLE_OEM_JOY_DE,
IDCLS_DISABLE_OEM_JOY_FR,
IDCLS_DISABLE_OEM_JOY_HU,
IDCLS_DISABLE_OEM_JOY_IT,
IDCLS_DISABLE_OEM_JOY_NL,
IDCLS_DISABLE_OEM_JOY_PL,
IDCLS_DISABLE_OEM_JOY_SV,
IDCLS_DISABLE_OEM_JOY_TR,

/* c128/c128-cmdline-options.c */
IDCLS_ENABLE_IEE488,
IDCLS_ENABLE_IEE488_DA,
IDCLS_ENABLE_IEE488_DE,
IDCLS_ENABLE_IEE488_FR,
IDCLS_ENABLE_IEE488_HU,
IDCLS_ENABLE_IEE488_IT,
IDCLS_ENABLE_IEE488_NL,
IDCLS_ENABLE_IEE488_PL,
IDCLS_ENABLE_IEE488_SV,
IDCLS_ENABLE_IEE488_TR,

/* c128/c128-cmdline-options.c */
IDCLS_DISABLE_IEE488,
IDCLS_DISABLE_IEE488_DA,
IDCLS_DISABLE_IEE488_DE,
IDCLS_DISABLE_IEE488_FR,
IDCLS_DISABLE_IEE488_HU,
IDCLS_DISABLE_IEE488_IT,
IDCLS_DISABLE_IEE488_NL,
IDCLS_DISABLE_IEE488_PL,
IDCLS_DISABLE_IEE488_SV,
IDCLS_DISABLE_IEE488_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
IDCLS_P_REVISION,
IDCLS_P_REVISION_DA,
IDCLS_P_REVISION_DE,
IDCLS_P_REVISION_FR,
IDCLS_P_REVISION_HU,
IDCLS_P_REVISION_IT,
IDCLS_P_REVISION_NL,
IDCLS_P_REVISION_PL,
IDCLS_P_REVISION_SV,
IDCLS_P_REVISION_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
IDCLS_PATCH_KERNAL_TO_REVISION,
IDCLS_PATCH_KERNAL_TO_REVISION_DA,
IDCLS_PATCH_KERNAL_TO_REVISION_DE,
IDCLS_PATCH_KERNAL_TO_REVISION_FR,
IDCLS_PATCH_KERNAL_TO_REVISION_HU,
IDCLS_PATCH_KERNAL_TO_REVISION_IT,
IDCLS_PATCH_KERNAL_TO_REVISION_NL,
IDCLS_PATCH_KERNAL_TO_REVISION_PL,
IDCLS_PATCH_KERNAL_TO_REVISION_SV,
IDCLS_PATCH_KERNAL_TO_REVISION_TR,

#ifdef HAVE_RS232
/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DA,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_DE,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_FR,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_HU,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_IT,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_NL,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_PL,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_SV,
IDCLS_ENABLE_DEXX_ACIA_RS232_EMU_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c */
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DA,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_DE,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_FR,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_HU,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_IT,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_NL,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_PL,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_SV,
IDCLS_DISABLE_DEXX_ACIA_RS232_EMU_TR,
#endif   /* HAVE_RS232 */

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
c64/psid.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vdc/vdc-cmdline-options.c, vic20/vic20-cmdline-options.c */
IDCLS_P_NUMBER,
IDCLS_P_NUMBER_DA,
IDCLS_P_NUMBER_DE,
IDCLS_P_NUMBER_FR,
IDCLS_P_NUMBER_HU,
IDCLS_P_NUMBER_IT,
IDCLS_P_NUMBER_NL,
IDCLS_P_NUMBER_PL,
IDCLS_P_NUMBER_SV,
IDCLS_P_NUMBER_TR,

#ifdef COMMON_KBD
/* c128/c128-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_KEYMAP_FILE_INDEX,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DA,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_DE,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_FR,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_HU,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_IT,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_NL,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_PL,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_SV,
IDCLS_SPECIFY_KEYMAP_FILE_INDEX_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DA,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_DE,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_FR,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_HU,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_IT,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_NL,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_PL,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_SV,
IDCLS_SPECIFY_SYM_KEYMAP_FILE_NAME_TR,

/* c128/c128-cmdline-options.c, c64/c64-cmdline-options.c,
plus4/plus4-cmdline-options.c, vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DA,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_DE,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_FR,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_HU,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_IT,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_NL,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_PL,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_SV,
IDCLS_SPECIFY_POS_KEYMAP_FILE_NAME_TR,
#endif  /* COMMON_KBD */

/* c128/c128mmu.c */
IDCLS_ACTIVATE_40_COL_MODE,
IDCLS_ACTIVATE_40_COL_MODE_DA,
IDCLS_ACTIVATE_40_COL_MODE_DE,
IDCLS_ACTIVATE_40_COL_MODE_FR,
IDCLS_ACTIVATE_40_COL_MODE_HU,
IDCLS_ACTIVATE_40_COL_MODE_IT,
IDCLS_ACTIVATE_40_COL_MODE_NL,
IDCLS_ACTIVATE_40_COL_MODE_PL,
IDCLS_ACTIVATE_40_COL_MODE_SV,
IDCLS_ACTIVATE_40_COL_MODE_TR,

/* c128/c128mmu.c */
IDCLS_ACTIVATE_80_COL_MODE,
IDCLS_ACTIVATE_80_COL_MODE_DA,
IDCLS_ACTIVATE_80_COL_MODE_DE,
IDCLS_ACTIVATE_80_COL_MODE_FR,
IDCLS_ACTIVATE_80_COL_MODE_HU,
IDCLS_ACTIVATE_80_COL_MODE_IT,
IDCLS_ACTIVATE_80_COL_MODE_NL,
IDCLS_ACTIVATE_80_COL_MODE_PL,
IDCLS_ACTIVATE_80_COL_MODE_SV,
IDCLS_ACTIVATE_80_COL_MODE_TR,

/* c128/c128mmu.c */
IDCLS_GO64_MODE,
IDCLS_GO64_MODE_DA,
IDCLS_GO64_MODE_DE,
IDCLS_GO64_MODE_FR,
IDCLS_GO64_MODE_HU,
IDCLS_GO64_MODE_IT,
IDCLS_GO64_MODE_NL,
IDCLS_GO64_MODE_PL,
IDCLS_GO64_MODE_SV,
IDCLS_GO64_MODE_TR,

/* c128/c128mmu.c */
IDCLS_GO128_MODE,
IDCLS_GO128_MODE_DA,
IDCLS_GO128_MODE_DE,
IDCLS_GO128_MODE_FR,
IDCLS_GO128_MODE_HU,
IDCLS_GO128_MODE_IT,
IDCLS_GO128_MODE_NL,
IDCLS_GO128_MODE_PL,
IDCLS_GO128_MODE_SV,
IDCLS_GO128_MODE_TR,

/* c128/functionrom.c */
IDCLS_SPECIFY_INT_FUNC_ROM_NAME,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DA,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_DE,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_FR,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_HU,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_IT,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_NL,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_PL,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_SV,
IDCLS_SPECIFY_INT_FUNC_ROM_NAME_TR,

/* c128/functionrom.c */
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DA,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_DE,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_FR,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_HU,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_IT,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_NL,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_PL,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_SV,
IDCLS_SPECIFY_EXT_FUNC_ROM_NAME_TR,

/* c128/functionrom.c */
IDCLS_ENABLE_INT_FUNC_ROM,
IDCLS_ENABLE_INT_FUNC_ROM_DA,
IDCLS_ENABLE_INT_FUNC_ROM_DE,
IDCLS_ENABLE_INT_FUNC_ROM_FR,
IDCLS_ENABLE_INT_FUNC_ROM_HU,
IDCLS_ENABLE_INT_FUNC_ROM_IT,
IDCLS_ENABLE_INT_FUNC_ROM_NL,
IDCLS_ENABLE_INT_FUNC_ROM_PL,
IDCLS_ENABLE_INT_FUNC_ROM_SV,
IDCLS_ENABLE_INT_FUNC_ROM_TR,

/* c128/functionrom.c */
IDCLS_DISABLE_INT_FUNC_ROM,
IDCLS_DISABLE_INT_FUNC_ROM_DA,
IDCLS_DISABLE_INT_FUNC_ROM_DE,
IDCLS_DISABLE_INT_FUNC_ROM_FR,
IDCLS_DISABLE_INT_FUNC_ROM_HU,
IDCLS_DISABLE_INT_FUNC_ROM_IT,
IDCLS_DISABLE_INT_FUNC_ROM_NL,
IDCLS_DISABLE_INT_FUNC_ROM_PL,
IDCLS_DISABLE_INT_FUNC_ROM_SV,
IDCLS_DISABLE_INT_FUNC_ROM_TR,

/* c128/functionrom.c */
IDCLS_ENABLE_EXT_FUNC_ROM,
IDCLS_ENABLE_EXT_FUNC_ROM_DA,
IDCLS_ENABLE_EXT_FUNC_ROM_DE,
IDCLS_ENABLE_EXT_FUNC_ROM_FR,
IDCLS_ENABLE_EXT_FUNC_ROM_HU,
IDCLS_ENABLE_EXT_FUNC_ROM_IT,
IDCLS_ENABLE_EXT_FUNC_ROM_NL,
IDCLS_ENABLE_EXT_FUNC_ROM_PL,
IDCLS_ENABLE_EXT_FUNC_ROM_SV,
IDCLS_ENABLE_EXT_FUNC_ROM_TR,

/* c128/functionrom.c */
IDCLS_DISABLE_EXT_FUNC_ROM,
IDCLS_DISABLE_EXT_FUNC_ROM_DA,
IDCLS_DISABLE_EXT_FUNC_ROM_DE,
IDCLS_DISABLE_EXT_FUNC_ROM_FR,
IDCLS_DISABLE_EXT_FUNC_ROM_HU,
IDCLS_DISABLE_EXT_FUNC_ROM_IT,
IDCLS_DISABLE_EXT_FUNC_ROM_NL,
IDCLS_DISABLE_EXT_FUNC_ROM_PL,
IDCLS_DISABLE_EXT_FUNC_ROM_SV,
IDCLS_DISABLE_EXT_FUNC_ROM_TR,

/* c64/c64-cmdline-options.c, c64/psid.c */
IDCLS_USE_OLD_NTSC_SYNC_FACTOR,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DA,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_DE,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_FR,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_HU,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_IT,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_NL,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_PL,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_SV,
IDCLS_USE_OLD_NTSC_SYNC_FACTOR_TR,

/* c64/c64-cmdline-options.c, viciisc/vicii-cmdline-options.c */
IDCLS_P_MODEL,
IDCLS_P_MODEL_DA,
IDCLS_P_MODEL_DE,
IDCLS_P_MODEL_FR,
IDCLS_P_MODEL_HU,
IDCLS_P_MODEL_IT,
IDCLS_P_MODEL_NL,
IDCLS_P_MODEL_PL,
IDCLS_P_MODEL_SV,
IDCLS_P_MODEL_TR,

/* c64/c64-cmdline-options.c */
IDCLS_SET_BOTH_CIA_MODELS,
IDCLS_SET_BOTH_CIA_MODELS_DA,
IDCLS_SET_BOTH_CIA_MODELS_DE,
IDCLS_SET_BOTH_CIA_MODELS_FR,
IDCLS_SET_BOTH_CIA_MODELS_HU,
IDCLS_SET_BOTH_CIA_MODELS_IT,
IDCLS_SET_BOTH_CIA_MODELS_NL,
IDCLS_SET_BOTH_CIA_MODELS_PL,
IDCLS_SET_BOTH_CIA_MODELS_SV,
IDCLS_SET_BOTH_CIA_MODELS_TR,

/* c64/c64-cmdline-options.c */
IDCLS_SET_CIA1_MODEL,
IDCLS_SET_CIA1_MODEL_DA,
IDCLS_SET_CIA1_MODEL_DE,
IDCLS_SET_CIA1_MODEL_FR,
IDCLS_SET_CIA1_MODEL_HU,
IDCLS_SET_CIA1_MODEL_IT,
IDCLS_SET_CIA1_MODEL_NL,
IDCLS_SET_CIA1_MODEL_PL,
IDCLS_SET_CIA1_MODEL_SV,
IDCLS_SET_CIA1_MODEL_TR,

/* c64/c64-cmdline-options.c */
IDCLS_SET_CIA2_MODEL,
IDCLS_SET_CIA2_MODEL_DA,
IDCLS_SET_CIA2_MODEL_DE,
IDCLS_SET_CIA2_MODEL_FR,
IDCLS_SET_CIA2_MODEL_HU,
IDCLS_SET_CIA2_MODEL_IT,
IDCLS_SET_CIA2_MODEL_NL,
IDCLS_SET_CIA2_MODEL_PL,
IDCLS_SET_CIA2_MODEL_SV,
IDCLS_SET_CIA2_MODEL_TR,

/* c64/c64-cmdline-options.c */
IDCLS_SET_C64_MODEL,
IDCLS_SET_C64_MODEL_DA,
IDCLS_SET_C64_MODEL_DE,
IDCLS_SET_C64_MODEL_FR,
IDCLS_SET_C64_MODEL_HU,
IDCLS_SET_C64_MODEL_IT,
IDCLS_SET_C64_MODEL_NL,
IDCLS_SET_C64_MODEL_PL,
IDCLS_SET_C64_MODEL_SV,
IDCLS_SET_C64_MODEL_TR,

/* c64/c64-cmdline-options.c */
IDCLS_USE_PALN_SYNC_FACTOR,
IDCLS_USE_PALN_SYNC_FACTOR_DA,
IDCLS_USE_PALN_SYNC_FACTOR_DE,
IDCLS_USE_PALN_SYNC_FACTOR_FR,
IDCLS_USE_PALN_SYNC_FACTOR_HU,
IDCLS_USE_PALN_SYNC_FACTOR_IT,
IDCLS_USE_PALN_SYNC_FACTOR_NL,
IDCLS_USE_PALN_SYNC_FACTOR_PL,
IDCLS_USE_PALN_SYNC_FACTOR_SV,
IDCLS_USE_PALN_SYNC_FACTOR_TR,

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_KERNAL_ROM_NAME,
IDCLS_SPECIFY_KERNAL_ROM_NAME_DA,
IDCLS_SPECIFY_KERNAL_ROM_NAME_DE,
IDCLS_SPECIFY_KERNAL_ROM_NAME_FR,
IDCLS_SPECIFY_KERNAL_ROM_NAME_HU,
IDCLS_SPECIFY_KERNAL_ROM_NAME_IT,
IDCLS_SPECIFY_KERNAL_ROM_NAME_NL,
IDCLS_SPECIFY_KERNAL_ROM_NAME_PL,
IDCLS_SPECIFY_KERNAL_ROM_NAME_SV,
IDCLS_SPECIFY_KERNAL_ROM_NAME_TR,

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, plus4/plus4-cmdline-options.c,
vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_BASIC_ROM_NAME,
IDCLS_SPECIFY_BASIC_ROM_NAME_DA,
IDCLS_SPECIFY_BASIC_ROM_NAME_DE,
IDCLS_SPECIFY_BASIC_ROM_NAME_FR,
IDCLS_SPECIFY_BASIC_ROM_NAME_HU,
IDCLS_SPECIFY_BASIC_ROM_NAME_IT,
IDCLS_SPECIFY_BASIC_ROM_NAME_NL,
IDCLS_SPECIFY_BASIC_ROM_NAME_PL,
IDCLS_SPECIFY_BASIC_ROM_NAME_SV,
IDCLS_SPECIFY_BASIC_ROM_NAME_TR,

/* c64/c64-cmdline-options.c, cbm2/cbm2-cmdline-options.c,
pet/pet-cmdline-options.c, vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_CHARGEN_ROM_NAME,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_DA,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_DE,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_FR,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_HU,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_IT,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_NL,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_PL,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_SV,
IDCLS_SPECIFY_CHARGEN_ROM_NAME_TR,

#ifdef COMMON_KBD
/* c64/c64-cmdline-options.c */
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DA,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_DE,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_FR,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_HU,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_IT,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_NL,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_PL,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_SV,
IDCLS_SPECIFY_INDEX_KEYMAP_FILE_0_2_TR,

/* c64/c64-cmdline-options.c */
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DA,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_DE,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_FR,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_HU,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_IT,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_NL,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_PL,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_SV,
IDCLS_SPECIFY_NAME_SYM_DE_KEYMAP_TR,
#endif   /* COMMON_KBD */

/* c64/c64gluelogic.c */
IDCLS_SET_GLUE_LOGIC_TYPE,
IDCLS_SET_GLUE_LOGIC_TYPE_DA,
IDCLS_SET_GLUE_LOGIC_TYPE_DE,
IDCLS_SET_GLUE_LOGIC_TYPE_FR,
IDCLS_SET_GLUE_LOGIC_TYPE_HU,
IDCLS_SET_GLUE_LOGIC_TYPE_IT,
IDCLS_SET_GLUE_LOGIC_TYPE_NL,
IDCLS_SET_GLUE_LOGIC_TYPE_PL,
IDCLS_SET_GLUE_LOGIC_TYPE_SV,
IDCLS_SET_GLUE_LOGIC_TYPE_TR,

/* c64dtv/c64dtv-cmdline-options.c */
IDCLS_ENABLE_HUMMER_ADC,
IDCLS_ENABLE_HUMMER_ADC_DA,
IDCLS_ENABLE_HUMMER_ADC_DE,
IDCLS_ENABLE_HUMMER_ADC_FR,
IDCLS_ENABLE_HUMMER_ADC_HU,
IDCLS_ENABLE_HUMMER_ADC_IT,
IDCLS_ENABLE_HUMMER_ADC_NL,
IDCLS_ENABLE_HUMMER_ADC_PL,
IDCLS_ENABLE_HUMMER_ADC_SV,
IDCLS_ENABLE_HUMMER_ADC_TR,

/* c64dtv/c64dtv-cmdline-options.c */
IDCLS_DISABLE_HUMMER_ADC,
IDCLS_DISABLE_HUMMER_ADC_DA,
IDCLS_DISABLE_HUMMER_ADC_DE,
IDCLS_DISABLE_HUMMER_ADC_FR,
IDCLS_DISABLE_HUMMER_ADC_HU,
IDCLS_DISABLE_HUMMER_ADC_IT,
IDCLS_DISABLE_HUMMER_ADC_NL,
IDCLS_DISABLE_HUMMER_ADC_PL,
IDCLS_DISABLE_HUMMER_ADC_SV,
IDCLS_DISABLE_HUMMER_ADC_TR,

/* c64/cart/georam.c */
IDCLS_ENABLE_GEORAM,
IDCLS_ENABLE_GEORAM_DA,
IDCLS_ENABLE_GEORAM_DE,
IDCLS_ENABLE_GEORAM_FR,
IDCLS_ENABLE_GEORAM_HU,
IDCLS_ENABLE_GEORAM_IT,
IDCLS_ENABLE_GEORAM_NL,
IDCLS_ENABLE_GEORAM_PL,
IDCLS_ENABLE_GEORAM_SV,
IDCLS_ENABLE_GEORAM_TR,

/* c64/cart/georam.c */
IDCLS_DISABLE_GEORAM,
IDCLS_DISABLE_GEORAM_DA,
IDCLS_DISABLE_GEORAM_DE,
IDCLS_DISABLE_GEORAM_FR,
IDCLS_DISABLE_GEORAM_HU,
IDCLS_DISABLE_GEORAM_IT,
IDCLS_DISABLE_GEORAM_NL,
IDCLS_DISABLE_GEORAM_PL,
IDCLS_DISABLE_GEORAM_SV,
IDCLS_DISABLE_GEORAM_TR,

/* c64/cart/georam.c */
IDCLS_SPECIFY_GEORAM_NAME,
IDCLS_SPECIFY_GEORAM_NAME_DA,
IDCLS_SPECIFY_GEORAM_NAME_DE,
IDCLS_SPECIFY_GEORAM_NAME_FR,
IDCLS_SPECIFY_GEORAM_NAME_HU,
IDCLS_SPECIFY_GEORAM_NAME_IT,
IDCLS_SPECIFY_GEORAM_NAME_NL,
IDCLS_SPECIFY_GEORAM_NAME_PL,
IDCLS_SPECIFY_GEORAM_NAME_SV,
IDCLS_SPECIFY_GEORAM_NAME_TR,

/* c64/cart/georam.c */
IDCLS_P_SIZE_IN_KB,
IDCLS_P_SIZE_IN_KB_DA,
IDCLS_P_SIZE_IN_KB_DE,
IDCLS_P_SIZE_IN_KB_FR,
IDCLS_P_SIZE_IN_KB_HU,
IDCLS_P_SIZE_IN_KB_IT,
IDCLS_P_SIZE_IN_KB_NL,
IDCLS_P_SIZE_IN_KB_PL,
IDCLS_P_SIZE_IN_KB_SV,
IDCLS_P_SIZE_IN_KB_TR,

/* c64/cart/georam.c */
IDCLS_GEORAM_SIZE,
IDCLS_GEORAM_SIZE_DA,
IDCLS_GEORAM_SIZE_DE,
IDCLS_GEORAM_SIZE_FR,
IDCLS_GEORAM_SIZE_HU,
IDCLS_GEORAM_SIZE_IT,
IDCLS_GEORAM_SIZE_NL,
IDCLS_GEORAM_SIZE_PL,
IDCLS_GEORAM_SIZE_SV,
IDCLS_GEORAM_SIZE_TR,

/* c64/psid.c */
IDCLS_SID_PLAYER_MODE,
IDCLS_SID_PLAYER_MODE_DA,
IDCLS_SID_PLAYER_MODE_DE,
IDCLS_SID_PLAYER_MODE_FR,
IDCLS_SID_PLAYER_MODE_HU,
IDCLS_SID_PLAYER_MODE_IT,
IDCLS_SID_PLAYER_MODE_NL,
IDCLS_SID_PLAYER_MODE_PL,
IDCLS_SID_PLAYER_MODE_SV,
IDCLS_SID_PLAYER_MODE_TR,

/* c64/psid.c */
IDCLS_OVERWRITE_PSID_SETTINGS,
IDCLS_OVERWRITE_PSID_SETTINGS_DA,
IDCLS_OVERWRITE_PSID_SETTINGS_DE,
IDCLS_OVERWRITE_PSID_SETTINGS_FR,
IDCLS_OVERWRITE_PSID_SETTINGS_HU,
IDCLS_OVERWRITE_PSID_SETTINGS_IT,
IDCLS_OVERWRITE_PSID_SETTINGS_NL,
IDCLS_OVERWRITE_PSID_SETTINGS_PL,
IDCLS_OVERWRITE_PSID_SETTINGS_SV,
IDCLS_OVERWRITE_PSID_SETTINGS_TR,

/* c64/psid.c */
IDCLS_SPECIFY_PSID_TUNE_NUMBER,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_DA,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_DE,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_FR,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_HU,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_IT,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_NL,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_PL,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_SV,
IDCLS_SPECIFY_PSID_TUNE_NUMBER_TR,

/* c64/cart/ramcart.c */
IDCLS_ENABLE_RAMCART,
IDCLS_ENABLE_RAMCART_DA,
IDCLS_ENABLE_RAMCART_DE,
IDCLS_ENABLE_RAMCART_FR,
IDCLS_ENABLE_RAMCART_HU,
IDCLS_ENABLE_RAMCART_IT,
IDCLS_ENABLE_RAMCART_NL,
IDCLS_ENABLE_RAMCART_PL,
IDCLS_ENABLE_RAMCART_SV,
IDCLS_ENABLE_RAMCART_TR,

/* c64/cart/ramcart.c */
IDCLS_DISABLE_RAMCART,
IDCLS_DISABLE_RAMCART_DA,
IDCLS_DISABLE_RAMCART_DE,
IDCLS_DISABLE_RAMCART_FR,
IDCLS_DISABLE_RAMCART_HU,
IDCLS_DISABLE_RAMCART_IT,
IDCLS_DISABLE_RAMCART_NL,
IDCLS_DISABLE_RAMCART_PL,
IDCLS_DISABLE_RAMCART_SV,
IDCLS_DISABLE_RAMCART_TR,

/* c64/cart/ramcart.c */
IDCLS_SPECIFY_RAMCART_NAME,
IDCLS_SPECIFY_RAMCART_NAME_DA,
IDCLS_SPECIFY_RAMCART_NAME_DE,
IDCLS_SPECIFY_RAMCART_NAME_FR,
IDCLS_SPECIFY_RAMCART_NAME_HU,
IDCLS_SPECIFY_RAMCART_NAME_IT,
IDCLS_SPECIFY_RAMCART_NAME_NL,
IDCLS_SPECIFY_RAMCART_NAME_PL,
IDCLS_SPECIFY_RAMCART_NAME_SV,
IDCLS_SPECIFY_RAMCART_NAME_TR,

/* c64/cart/ramcart.c */
IDCLS_RAMCART_SIZE,
IDCLS_RAMCART_SIZE_DA,
IDCLS_RAMCART_SIZE_DE,
IDCLS_RAMCART_SIZE_FR,
IDCLS_RAMCART_SIZE_HU,
IDCLS_RAMCART_SIZE_IT,
IDCLS_RAMCART_SIZE_NL,
IDCLS_RAMCART_SIZE_PL,
IDCLS_RAMCART_SIZE_SV,
IDCLS_RAMCART_SIZE_TR,

/* c64/cart/dqbb.c */
IDCLS_ENABLE_DQBB,
IDCLS_ENABLE_DQBB_DA,
IDCLS_ENABLE_DQBB_DE,
IDCLS_ENABLE_DQBB_FR,
IDCLS_ENABLE_DQBB_HU,
IDCLS_ENABLE_DQBB_IT,
IDCLS_ENABLE_DQBB_NL,
IDCLS_ENABLE_DQBB_PL,
IDCLS_ENABLE_DQBB_SV,
IDCLS_ENABLE_DQBB_TR,

/* c64/cart/dqbb.c */
IDCLS_DISABLE_DQBB,
IDCLS_DISABLE_DQBB_DA,
IDCLS_DISABLE_DQBB_DE,
IDCLS_DISABLE_DQBB_FR,
IDCLS_DISABLE_DQBB_HU,
IDCLS_DISABLE_DQBB_IT,
IDCLS_DISABLE_DQBB_NL,
IDCLS_DISABLE_DQBB_PL,
IDCLS_DISABLE_DQBB_SV,
IDCLS_DISABLE_DQBB_TR,

/* c64/cart/dqbb.c */
IDCLS_SPECIFY_DQBB_NAME,
IDCLS_SPECIFY_DQBB_NAME_DA,
IDCLS_SPECIFY_DQBB_NAME_DE,
IDCLS_SPECIFY_DQBB_NAME_FR,
IDCLS_SPECIFY_DQBB_NAME_HU,
IDCLS_SPECIFY_DQBB_NAME_IT,
IDCLS_SPECIFY_DQBB_NAME_NL,
IDCLS_SPECIFY_DQBB_NAME_PL,
IDCLS_SPECIFY_DQBB_NAME_SV,
IDCLS_SPECIFY_DQBB_NAME_TR,

/* c64/cart/isepic.c */
IDCLS_ENABLE_ISEPIC,
IDCLS_ENABLE_ISEPIC_DA,
IDCLS_ENABLE_ISEPIC_DE,
IDCLS_ENABLE_ISEPIC_FR,
IDCLS_ENABLE_ISEPIC_HU,
IDCLS_ENABLE_ISEPIC_IT,
IDCLS_ENABLE_ISEPIC_NL,
IDCLS_ENABLE_ISEPIC_PL,
IDCLS_ENABLE_ISEPIC_SV,
IDCLS_ENABLE_ISEPIC_TR,

/* c64/cart/isepic.c */
IDCLS_DISABLE_ISEPIC,
IDCLS_DISABLE_ISEPIC_DA,
IDCLS_DISABLE_ISEPIC_DE,
IDCLS_DISABLE_ISEPIC_FR,
IDCLS_DISABLE_ISEPIC_HU,
IDCLS_DISABLE_ISEPIC_IT,
IDCLS_DISABLE_ISEPIC_NL,
IDCLS_DISABLE_ISEPIC_PL,
IDCLS_DISABLE_ISEPIC_SV,
IDCLS_DISABLE_ISEPIC_TR,

/* c64/cart/mmc64.c */
IDCLS_ENABLE_MMC64,
IDCLS_ENABLE_MMC64_DA,
IDCLS_ENABLE_MMC64_DE,
IDCLS_ENABLE_MMC64_FR,
IDCLS_ENABLE_MMC64_HU,
IDCLS_ENABLE_MMC64_IT,
IDCLS_ENABLE_MMC64_NL,
IDCLS_ENABLE_MMC64_PL,
IDCLS_ENABLE_MMC64_SV,
IDCLS_ENABLE_MMC64_TR,

/* c64/cart/mmc64.c */
IDCLS_DISABLE_MMC64,
IDCLS_DISABLE_MMC64_DA,
IDCLS_DISABLE_MMC64_DE,
IDCLS_DISABLE_MMC64_FR,
IDCLS_DISABLE_MMC64_HU,
IDCLS_DISABLE_MMC64_IT,
IDCLS_DISABLE_MMC64_NL,
IDCLS_DISABLE_MMC64_PL,
IDCLS_DISABLE_MMC64_SV,
IDCLS_DISABLE_MMC64_TR,

/* c64/cart/mmc64.c */
IDCLS_SPECIFY_MMC64_BIOS_NAME,
IDCLS_SPECIFY_MMC64_BIOS_NAME_DA,
IDCLS_SPECIFY_MMC64_BIOS_NAME_DE,
IDCLS_SPECIFY_MMC64_BIOS_NAME_FR,
IDCLS_SPECIFY_MMC64_BIOS_NAME_HU,
IDCLS_SPECIFY_MMC64_BIOS_NAME_IT,
IDCLS_SPECIFY_MMC64_BIOS_NAME_NL,
IDCLS_SPECIFY_MMC64_BIOS_NAME_PL,
IDCLS_SPECIFY_MMC64_BIOS_NAME_SV,
IDCLS_SPECIFY_MMC64_BIOS_NAME_TR,

/* c64/cart/mmc64.c */
IDCLS_SPECIFY_MMC64_IMAGE_NAME,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_DA,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_DE,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_FR,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_HU,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_IT,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_NL,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_PL,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_SV,
IDCLS_SPECIFY_MMC64_IMAGE_NAME_TR,

/* c64/cart/mmc64.c */
IDCLS_MMC64_READONLY,
IDCLS_MMC64_READONLY_DA,
IDCLS_MMC64_READONLY_DE,
IDCLS_MMC64_READONLY_FR,
IDCLS_MMC64_READONLY_HU,
IDCLS_MMC64_READONLY_IT,
IDCLS_MMC64_READONLY_NL,
IDCLS_MMC64_READONLY_PL,
IDCLS_MMC64_READONLY_SV,
IDCLS_MMC64_READONLY_TR,

/* c64/cart/mmc64.c */
IDCLS_MMC64_READWRITE,
IDCLS_MMC64_READWRITE_DA,
IDCLS_MMC64_READWRITE_DE,
IDCLS_MMC64_READWRITE_FR,
IDCLS_MMC64_READWRITE_HU,
IDCLS_MMC64_READWRITE_IT,
IDCLS_MMC64_READWRITE_NL,
IDCLS_MMC64_READWRITE_PL,
IDCLS_MMC64_READWRITE_SV,
IDCLS_MMC64_READWRITE_TR,

/* c64/cart/mmc64.c */
IDCLS_MMC64_BIOS_WRITE,
IDCLS_MMC64_BIOS_WRITE_DA,
IDCLS_MMC64_BIOS_WRITE_DE,
IDCLS_MMC64_BIOS_WRITE_FR,
IDCLS_MMC64_BIOS_WRITE_HU,
IDCLS_MMC64_BIOS_WRITE_IT,
IDCLS_MMC64_BIOS_WRITE_NL,
IDCLS_MMC64_BIOS_WRITE_PL,
IDCLS_MMC64_BIOS_WRITE_SV,
IDCLS_MMC64_BIOS_WRITE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DA,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_DE,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_FR,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_HU,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_IT,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_NL,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_PL,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_SV,
IDCLS_SELECT_MMC_REPLAY_CARD_IMAGE_FILENAME_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DA,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_DE,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_FR,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_HU,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_IT,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_NL,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_PL,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_SV,
IDCLS_MMC_REPLAY_CARD_WRITE_ENABLE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DA,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_DE,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_FR,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_HU,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_IT,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_NL,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_PL,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_SV,
IDCLS_MMC_REPLAY_CARD_WRITE_DISABLE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DA,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_DE,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_FR,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_HU,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_IT,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_NL,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_PL,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_SV,
IDCLS_SELECT_MMC_REPLAY_EEPROM_IMAGE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DA,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_DE,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_FR,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_HU,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_IT,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_NL,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_PL,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_SV,
IDCLS_MMC_REPLAY_EEPROM_WRITE_ENABLE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DA,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_DE,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_FR,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_HU,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_IT,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_NL,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_PL,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_SV,
IDCLS_MMC_REPLAY_EEPROM_WRITE_DISABLE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DA,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_DE,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_FR,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_HU,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_IT,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_NL,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_PL,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_SV,
IDCLS_MMC_REPLAY_RESCUE_MODE_ENABLE_TR,

/* c64/cart/mmcreplay.c */
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DA,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_DE,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_FR,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_HU,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_IT,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_NL,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_PL,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_SV,
IDCLS_MMC_REPLAY_RESCUE_MODE_DISABLE_TR,

/* c64/cart/retroplay.c */
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DA,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_DE,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_FR,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_HU,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_IT,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_NL,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_PL,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_SV,
IDCLS_ENABLE_SAVE_RR_ROM_AT_EXIT_TR,

/* c64/cart/retroplay.c */
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DA,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_DE,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_FR,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_HU,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_IT,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_NL,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_PL,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_SV,
IDCLS_DISABLE_SAVE_RR_ROM_AT_EXIT_TR,

/* c64/cart/retroplay.c */
IDCLS_SET_RR_BANK_JUMPER,
IDCLS_SET_RR_BANK_JUMPER_DA,
IDCLS_SET_RR_BANK_JUMPER_DE,
IDCLS_SET_RR_BANK_JUMPER_FR,
IDCLS_SET_RR_BANK_JUMPER_HU,
IDCLS_SET_RR_BANK_JUMPER_IT,
IDCLS_SET_RR_BANK_JUMPER_NL,
IDCLS_SET_RR_BANK_JUMPER_PL,
IDCLS_SET_RR_BANK_JUMPER_SV,
IDCLS_SET_RR_BANK_JUMPER_TR,

/* c64/cart/retroplay.c */
IDCLS_UNSET_RR_BANK_JUMPER,
IDCLS_UNSET_RR_BANK_JUMPER_DA,
IDCLS_UNSET_RR_BANK_JUMPER_DE,
IDCLS_UNSET_RR_BANK_JUMPER_FR,
IDCLS_UNSET_RR_BANK_JUMPER_HU,
IDCLS_UNSET_RR_BANK_JUMPER_IT,
IDCLS_UNSET_RR_BANK_JUMPER_NL,
IDCLS_UNSET_RR_BANK_JUMPER_PL,
IDCLS_UNSET_RR_BANK_JUMPER_SV,
IDCLS_UNSET_RR_BANK_JUMPER_TR,

/* c64/cart/retroplay.c */
IDCLS_SET_RR_FLASH_JUMPER,
IDCLS_SET_RR_FLASH_JUMPER_DA,
IDCLS_SET_RR_FLASH_JUMPER_DE,
IDCLS_SET_RR_FLASH_JUMPER_FR,
IDCLS_SET_RR_FLASH_JUMPER_HU,
IDCLS_SET_RR_FLASH_JUMPER_IT,
IDCLS_SET_RR_FLASH_JUMPER_NL,
IDCLS_SET_RR_FLASH_JUMPER_PL,
IDCLS_SET_RR_FLASH_JUMPER_SV,
IDCLS_SET_RR_FLASH_JUMPER_TR,

/* c64/cart/retroplay.c */
IDCLS_UNSET_RR_FLASH_JUMPER,
IDCLS_UNSET_RR_FLASH_JUMPER_DA,
IDCLS_UNSET_RR_FLASH_JUMPER_DE,
IDCLS_UNSET_RR_FLASH_JUMPER_FR,
IDCLS_UNSET_RR_FLASH_JUMPER_HU,
IDCLS_UNSET_RR_FLASH_JUMPER_IT,
IDCLS_UNSET_RR_FLASH_JUMPER_NL,
IDCLS_UNSET_RR_FLASH_JUMPER_PL,
IDCLS_UNSET_RR_FLASH_JUMPER_SV,
IDCLS_UNSET_RR_FLASH_JUMPER_TR,

/* c64/cart/reu.c */
IDCLS_ENABLE_REU,
IDCLS_ENABLE_REU_DA,
IDCLS_ENABLE_REU_DE,
IDCLS_ENABLE_REU_FR,
IDCLS_ENABLE_REU_HU,
IDCLS_ENABLE_REU_IT,
IDCLS_ENABLE_REU_NL,
IDCLS_ENABLE_REU_PL,
IDCLS_ENABLE_REU_SV,
IDCLS_ENABLE_REU_TR,

/* c64/cart/reu.c */
IDCLS_DISABLE_REU,
IDCLS_DISABLE_REU_DA,
IDCLS_DISABLE_REU_DE,
IDCLS_DISABLE_REU_FR,
IDCLS_DISABLE_REU_HU,
IDCLS_DISABLE_REU_IT,
IDCLS_DISABLE_REU_NL,
IDCLS_DISABLE_REU_PL,
IDCLS_DISABLE_REU_SV,
IDCLS_DISABLE_REU_TR,

/* c64/cart/reu.c */
IDCLS_SPECIFY_REU_NAME,
IDCLS_SPECIFY_REU_NAME_DA,
IDCLS_SPECIFY_REU_NAME_DE,
IDCLS_SPECIFY_REU_NAME_FR,
IDCLS_SPECIFY_REU_NAME_HU,
IDCLS_SPECIFY_REU_NAME_IT,
IDCLS_SPECIFY_REU_NAME_NL,
IDCLS_SPECIFY_REU_NAME_PL,
IDCLS_SPECIFY_REU_NAME_SV,
IDCLS_SPECIFY_REU_NAME_TR,

/* c64/cart/reu.c */
IDCLS_REU_SIZE,
IDCLS_REU_SIZE_DA,
IDCLS_REU_SIZE_DE,
IDCLS_REU_SIZE_FR,
IDCLS_REU_SIZE_HU,
IDCLS_REU_SIZE_IT,
IDCLS_REU_SIZE_NL,
IDCLS_REU_SIZE_PL,
IDCLS_REU_SIZE_SV,
IDCLS_REU_SIZE_TR,

#ifdef HAVE_TFE
/* c64/cart/tfe.c */
IDCLS_ENABLE_TFE,
IDCLS_ENABLE_TFE_DA,
IDCLS_ENABLE_TFE_DE,
IDCLS_ENABLE_TFE_FR,
IDCLS_ENABLE_TFE_HU,
IDCLS_ENABLE_TFE_IT,
IDCLS_ENABLE_TFE_NL,
IDCLS_ENABLE_TFE_PL,
IDCLS_ENABLE_TFE_SV,
IDCLS_ENABLE_TFE_TR,

/* c64/cart/tfe.c */
IDCLS_DISABLE_TFE,
IDCLS_DISABLE_TFE_DA,
IDCLS_DISABLE_TFE_DE,
IDCLS_DISABLE_TFE_FR,
IDCLS_DISABLE_TFE_HU,
IDCLS_DISABLE_TFE_IT,
IDCLS_DISABLE_TFE_NL,
IDCLS_DISABLE_TFE_PL,
IDCLS_DISABLE_TFE_SV,
IDCLS_DISABLE_TFE_TR,

/* c64/cart/tfe.c */
IDCLS_TFE_INTERFACE,
IDCLS_TFE_INTERFACE_DA,
IDCLS_TFE_INTERFACE_DE,
IDCLS_TFE_INTERFACE_FR,
IDCLS_TFE_INTERFACE_HU,
IDCLS_TFE_INTERFACE_IT,
IDCLS_TFE_INTERFACE_NL,
IDCLS_TFE_INTERFACE_PL,
IDCLS_TFE_INTERFACE_SV,
IDCLS_TFE_INTERFACE_TR,

/* c64/cart/tfe.c */
IDCLS_ENABLE_TFE_AS_RRNET,
IDCLS_ENABLE_TFE_AS_RRNET_DA,
IDCLS_ENABLE_TFE_AS_RRNET_DE,
IDCLS_ENABLE_TFE_AS_RRNET_FR,
IDCLS_ENABLE_TFE_AS_RRNET_HU,
IDCLS_ENABLE_TFE_AS_RRNET_IT,
IDCLS_ENABLE_TFE_AS_RRNET_NL,
IDCLS_ENABLE_TFE_AS_RRNET_PL,
IDCLS_ENABLE_TFE_AS_RRNET_SV,
IDCLS_ENABLE_TFE_AS_RRNET_TR,

/* c64/cart/tfe.c */
IDCLS_DISABLE_TFE_AS_RRNET,
IDCLS_DISABLE_TFE_AS_RRNET_DA,
IDCLS_DISABLE_TFE_AS_RRNET_DE,
IDCLS_DISABLE_TFE_AS_RRNET_FR,
IDCLS_DISABLE_TFE_AS_RRNET_HU,
IDCLS_DISABLE_TFE_AS_RRNET_IT,
IDCLS_DISABLE_TFE_AS_RRNET_NL,
IDCLS_DISABLE_TFE_AS_RRNET_PL,
IDCLS_DISABLE_TFE_AS_RRNET_SV,
IDCLS_DISABLE_TFE_AS_RRNET_TR,
#endif   /* HAVE_TFE */

/* c64/cart/c64cart.c */
IDCLS_CART_ATTACH_DETACH_RESET,
IDCLS_CART_ATTACH_DETACH_RESET_DA,
IDCLS_CART_ATTACH_DETACH_RESET_DE,
IDCLS_CART_ATTACH_DETACH_RESET_FR,
IDCLS_CART_ATTACH_DETACH_RESET_HU,
IDCLS_CART_ATTACH_DETACH_RESET_IT,
IDCLS_CART_ATTACH_DETACH_RESET_NL,
IDCLS_CART_ATTACH_DETACH_RESET_PL,
IDCLS_CART_ATTACH_DETACH_RESET_SV,
IDCLS_CART_ATTACH_DETACH_RESET_TR,

/* c64/cart/c64cart.c */
IDCLS_CART_ATTACH_DETACH_NO_RESET,
IDCLS_CART_ATTACH_DETACH_NO_RESET_DA,
IDCLS_CART_ATTACH_DETACH_NO_RESET_DE,
IDCLS_CART_ATTACH_DETACH_NO_RESET_FR,
IDCLS_CART_ATTACH_DETACH_NO_RESET_HU,
IDCLS_CART_ATTACH_DETACH_NO_RESET_IT,
IDCLS_CART_ATTACH_DETACH_NO_RESET_NL,
IDCLS_CART_ATTACH_DETACH_NO_RESET_PL,
IDCLS_CART_ATTACH_DETACH_NO_RESET_SV,
IDCLS_CART_ATTACH_DETACH_NO_RESET_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_CRT_CART,
IDCLS_ATTACH_CRT_CART_DA,
IDCLS_ATTACH_CRT_CART_DE,
IDCLS_ATTACH_CRT_CART_FR,
IDCLS_ATTACH_CRT_CART_HU,
IDCLS_ATTACH_CRT_CART_IT,
IDCLS_ATTACH_CRT_CART_NL,
IDCLS_ATTACH_CRT_CART_PL,
IDCLS_ATTACH_CRT_CART_SV,
IDCLS_ATTACH_CRT_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_GENERIC_8KB_CART,
IDCLS_ATTACH_GENERIC_8KB_CART_DA,
IDCLS_ATTACH_GENERIC_8KB_CART_DE,
IDCLS_ATTACH_GENERIC_8KB_CART_FR,
IDCLS_ATTACH_GENERIC_8KB_CART_HU,
IDCLS_ATTACH_GENERIC_8KB_CART_IT,
IDCLS_ATTACH_GENERIC_8KB_CART_NL,
IDCLS_ATTACH_GENERIC_8KB_CART_PL,
IDCLS_ATTACH_GENERIC_8KB_CART_SV,
IDCLS_ATTACH_GENERIC_8KB_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_GENERIC_16KB_CART,
IDCLS_ATTACH_GENERIC_16KB_CART_DA,
IDCLS_ATTACH_GENERIC_16KB_CART_DE,
IDCLS_ATTACH_GENERIC_16KB_CART_FR,
IDCLS_ATTACH_GENERIC_16KB_CART_HU,
IDCLS_ATTACH_GENERIC_16KB_CART_IT,
IDCLS_ATTACH_GENERIC_16KB_CART_NL,
IDCLS_ATTACH_GENERIC_16KB_CART_PL,
IDCLS_ATTACH_GENERIC_16KB_CART_SV,
IDCLS_ATTACH_GENERIC_16KB_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_STARDOS_CART,
IDCLS_ATTACH_RAW_STARDOS_CART_DA,
IDCLS_ATTACH_RAW_STARDOS_CART_DE,
IDCLS_ATTACH_RAW_STARDOS_CART_FR,
IDCLS_ATTACH_RAW_STARDOS_CART_HU,
IDCLS_ATTACH_RAW_STARDOS_CART_IT,
IDCLS_ATTACH_RAW_STARDOS_CART_NL,
IDCLS_ATTACH_RAW_STARDOS_CART_PL,
IDCLS_ATTACH_RAW_STARDOS_CART_SV,
IDCLS_ATTACH_RAW_STARDOS_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DA,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_DE,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_FR,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_HU,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_IT,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_NL,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_PL,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_SV,
IDCLS_ATTACH_RAW_ACTION_REPLAY3_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DA,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_DE,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_FR,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_HU,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_IT,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_NL,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_PL,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_SV,
IDCLS_ATTACH_RAW_ACTION_REPLAY4_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DA,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_DE,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_FR,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_HU,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_IT,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_NL,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_PL,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_SV,
IDCLS_ATTACH_RAW_ACTION_REPLAY_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DA,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_DE,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_FR,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_HU,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_IT,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_NL,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_PL,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_SV,
IDCLS_ATTACH_RAW_RETRO_REPLAY_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_IDE64_CART,
IDCLS_ATTACH_RAW_IDE64_CART_DA,
IDCLS_ATTACH_RAW_IDE64_CART_DE,
IDCLS_ATTACH_RAW_IDE64_CART_FR,
IDCLS_ATTACH_RAW_IDE64_CART_HU,
IDCLS_ATTACH_RAW_IDE64_CART_IT,
IDCLS_ATTACH_RAW_IDE64_CART_NL,
IDCLS_ATTACH_RAW_IDE64_CART_PL,
IDCLS_ATTACH_RAW_IDE64_CART_SV,
IDCLS_ATTACH_RAW_IDE64_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DA,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_DE,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_FR,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_HU,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_IT,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_NL,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_PL,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_SV,
IDCLS_ATTACH_RAW_ATOMIC_POWER_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DA,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_DE,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_FR,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_HU,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_IT,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_NL,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_PL,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_SV,
IDCLS_ATTACH_RAW_EPYX_FASTLOAD_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_SS4_CART,
IDCLS_ATTACH_RAW_SS4_CART_DA,
IDCLS_ATTACH_RAW_SS4_CART_DE,
IDCLS_ATTACH_RAW_SS4_CART_FR,
IDCLS_ATTACH_RAW_SS4_CART_HU,
IDCLS_ATTACH_RAW_SS4_CART_IT,
IDCLS_ATTACH_RAW_SS4_CART_NL,
IDCLS_ATTACH_RAW_SS4_CART_PL,
IDCLS_ATTACH_RAW_SS4_CART_SV,
IDCLS_ATTACH_RAW_SS4_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_SS5_CART,
IDCLS_ATTACH_RAW_SS5_CART_DA,
IDCLS_ATTACH_RAW_SS5_CART_DE,
IDCLS_ATTACH_RAW_SS5_CART_FR,
IDCLS_ATTACH_RAW_SS5_CART_HU,
IDCLS_ATTACH_RAW_SS5_CART_IT,
IDCLS_ATTACH_RAW_SS5_CART_NL,
IDCLS_ATTACH_RAW_SS5_CART_PL,
IDCLS_ATTACH_RAW_SS5_CART_SV,
IDCLS_ATTACH_RAW_SS5_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_CBM_IEEE488_CART,
IDCLS_ATTACH_CBM_IEEE488_CART_DA,
IDCLS_ATTACH_CBM_IEEE488_CART_DE,
IDCLS_ATTACH_CBM_IEEE488_CART_FR,
IDCLS_ATTACH_CBM_IEEE488_CART_HU,
IDCLS_ATTACH_CBM_IEEE488_CART_IT,
IDCLS_ATTACH_CBM_IEEE488_CART_NL,
IDCLS_ATTACH_CBM_IEEE488_CART_PL,
IDCLS_ATTACH_CBM_IEEE488_CART_SV,
IDCLS_ATTACH_CBM_IEEE488_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_WESTERMANN_CART,
IDCLS_ATTACH_RAW_WESTERMANN_CART_DA,
IDCLS_ATTACH_RAW_WESTERMANN_CART_DE,
IDCLS_ATTACH_RAW_WESTERMANN_CART_FR,
IDCLS_ATTACH_RAW_WESTERMANN_CART_HU,
IDCLS_ATTACH_RAW_WESTERMANN_CART_IT,
IDCLS_ATTACH_RAW_WESTERMANN_CART_NL,
IDCLS_ATTACH_RAW_WESTERMANN_CART_PL,
IDCLS_ATTACH_RAW_WESTERMANN_CART_SV,
IDCLS_ATTACH_RAW_WESTERMANN_CART_TR,

/* c64/cart/c64cart.c, c64/cart/expert.c */
IDCLS_ENABLE_EXPERT_CART,
IDCLS_ENABLE_EXPERT_CART_DA,
IDCLS_ENABLE_EXPERT_CART_DE,
IDCLS_ENABLE_EXPERT_CART_FR,
IDCLS_ENABLE_EXPERT_CART_HU,
IDCLS_ENABLE_EXPERT_CART_IT,
IDCLS_ENABLE_EXPERT_CART_NL,
IDCLS_ENABLE_EXPERT_CART_PL,
IDCLS_ENABLE_EXPERT_CART_SV,
IDCLS_ENABLE_EXPERT_CART_TR,

/* c64/cart/expert.c */
IDCLS_DISABLE_EXPERT_CART,
IDCLS_DISABLE_EXPERT_CART_DA,
IDCLS_DISABLE_EXPERT_CART_DE,
IDCLS_DISABLE_EXPERT_CART_FR,
IDCLS_DISABLE_EXPERT_CART_HU,
IDCLS_DISABLE_EXPERT_CART_IT,
IDCLS_DISABLE_EXPERT_CART_NL,
IDCLS_DISABLE_EXPERT_CART_PL,
IDCLS_DISABLE_EXPERT_CART_SV,
IDCLS_DISABLE_EXPERT_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_P64_CART,
IDCLS_ATTACH_RAW_P64_CART_DA,
IDCLS_ATTACH_RAW_P64_CART_DE,
IDCLS_ATTACH_RAW_P64_CART_FR,
IDCLS_ATTACH_RAW_P64_CART_HU,
IDCLS_ATTACH_RAW_P64_CART_IT,
IDCLS_ATTACH_RAW_P64_CART_NL,
IDCLS_ATTACH_RAW_P64_CART_PL,
IDCLS_ATTACH_RAW_P64_CART_SV,
IDCLS_ATTACH_RAW_P64_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_GAME_KILLER_CART,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_DA,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_DE,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_FR,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_HU,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_IT,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_NL,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_PL,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_SV,
IDCLS_ATTACH_RAW_GAME_KILLER_CART_TR,

/* c64/cart/c64cart.c */
IDCLS_DISABLE_CART,
IDCLS_DISABLE_CART_DA,
IDCLS_DISABLE_CART_DE,
IDCLS_DISABLE_CART_FR,
IDCLS_DISABLE_CART_HU,
IDCLS_DISABLE_CART_IT,
IDCLS_DISABLE_CART_NL,
IDCLS_DISABLE_CART_PL,
IDCLS_DISABLE_CART_SV,
IDCLS_DISABLE_CART_TR,

/* c64/cart/ide64.c */
IDCLS_SPECIFY_IDE64_NAME,
IDCLS_SPECIFY_IDE64_NAME_DA,
IDCLS_SPECIFY_IDE64_NAME_DE,
IDCLS_SPECIFY_IDE64_NAME_FR,
IDCLS_SPECIFY_IDE64_NAME_HU,
IDCLS_SPECIFY_IDE64_NAME_IT,
IDCLS_SPECIFY_IDE64_NAME_NL,
IDCLS_SPECIFY_IDE64_NAME_PL,
IDCLS_SPECIFY_IDE64_NAME_SV,
IDCLS_SPECIFY_IDE64_NAME_TR,

/* c64/cart/ide64.c, gfxoutputdrv/ffmpegdrv.c, datasette.c,
debug.c, mouse.c, ram.c, sound.c, vsync.c */
IDCLS_P_VALUE,
IDCLS_P_VALUE_DA,
IDCLS_P_VALUE_DE,
IDCLS_P_VALUE_FR,
IDCLS_P_VALUE_HU,
IDCLS_P_VALUE_IT,
IDCLS_P_VALUE_NL,
IDCLS_P_VALUE_PL,
IDCLS_P_VALUE_SV,
IDCLS_P_VALUE_TR,

/* c64/cart/ide64.c */
IDCLS_SET_AMOUNT_CYLINDERS_IDE64,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DA,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_DE,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_FR,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_HU,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_IT,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_NL,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_PL,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_SV,
IDCLS_SET_AMOUNT_CYLINDERS_IDE64_TR,

/* c64/cart/ide64.c */
IDCLS_SET_AMOUNT_HEADS_IDE64,
IDCLS_SET_AMOUNT_HEADS_IDE64_DA,
IDCLS_SET_AMOUNT_HEADS_IDE64_DE,
IDCLS_SET_AMOUNT_HEADS_IDE64_FR,
IDCLS_SET_AMOUNT_HEADS_IDE64_HU,
IDCLS_SET_AMOUNT_HEADS_IDE64_IT,
IDCLS_SET_AMOUNT_HEADS_IDE64_NL,
IDCLS_SET_AMOUNT_HEADS_IDE64_PL,
IDCLS_SET_AMOUNT_HEADS_IDE64_SV,
IDCLS_SET_AMOUNT_HEADS_IDE64_TR,

/* c64/cart/ide64.c */
IDCLS_SET_AMOUNT_SECTORS_IDE64,
IDCLS_SET_AMOUNT_SECTORS_IDE64_DA,
IDCLS_SET_AMOUNT_SECTORS_IDE64_DE,
IDCLS_SET_AMOUNT_SECTORS_IDE64_FR,
IDCLS_SET_AMOUNT_SECTORS_IDE64_HU,
IDCLS_SET_AMOUNT_SECTORS_IDE64_IT,
IDCLS_SET_AMOUNT_SECTORS_IDE64_NL,
IDCLS_SET_AMOUNT_SECTORS_IDE64_PL,
IDCLS_SET_AMOUNT_SECTORS_IDE64_SV,
IDCLS_SET_AMOUNT_SECTORS_IDE64_TR,

/* c64/cart/ide64.c */
IDCLS_AUTODETECT_IDE64_GEOMETRY,
IDCLS_AUTODETECT_IDE64_GEOMETRY_DA,
IDCLS_AUTODETECT_IDE64_GEOMETRY_DE,
IDCLS_AUTODETECT_IDE64_GEOMETRY_FR,
IDCLS_AUTODETECT_IDE64_GEOMETRY_HU,
IDCLS_AUTODETECT_IDE64_GEOMETRY_IT,
IDCLS_AUTODETECT_IDE64_GEOMETRY_NL,
IDCLS_AUTODETECT_IDE64_GEOMETRY_PL,
IDCLS_AUTODETECT_IDE64_GEOMETRY_SV,
IDCLS_AUTODETECT_IDE64_GEOMETRY_TR,

/* c64/cart/ide64.c */
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DA,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_DE,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_FR,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_HU,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_IT,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_NL,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_PL,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_SV,
IDCLS_NO_AUTODETECT_IDE64_GEOMETRY_TR,

/* c64/cart/ide64.c */
IDCLS_IDE64_VERSION4,
IDCLS_IDE64_VERSION4_DA,
IDCLS_IDE64_VERSION4_DE,
IDCLS_IDE64_VERSION4_FR,
IDCLS_IDE64_VERSION4_HU,
IDCLS_IDE64_VERSION4_IT,
IDCLS_IDE64_VERSION4_NL,
IDCLS_IDE64_VERSION4_PL,
IDCLS_IDE64_VERSION4_SV,
IDCLS_IDE64_VERSION4_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_P_MODELNUMBER,
IDCLS_P_MODELNUMBER_DA,
IDCLS_P_MODELNUMBER_DE,
IDCLS_P_MODELNUMBER_FR,
IDCLS_P_MODELNUMBER_HU,
IDCLS_P_MODELNUMBER_IT,
IDCLS_P_MODELNUMBER_NL,
IDCLS_P_MODELNUMBER_PL,
IDCLS_P_MODELNUMBER_SV,
IDCLS_P_MODELNUMBER_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CBM2_MODEL,
IDCLS_SPECIFY_CBM2_MODEL_DA,
IDCLS_SPECIFY_CBM2_MODEL_DE,
IDCLS_SPECIFY_CBM2_MODEL_FR,
IDCLS_SPECIFY_CBM2_MODEL_HU,
IDCLS_SPECIFY_CBM2_MODEL_IT,
IDCLS_SPECIFY_CBM2_MODEL_NL,
IDCLS_SPECIFY_CBM2_MODEL_PL,
IDCLS_SPECIFY_CBM2_MODEL_SV,
IDCLS_SPECIFY_CBM2_MODEL_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_TO_USE_VIC_II,
IDCLS_SPECIFY_TO_USE_VIC_II_DA,
IDCLS_SPECIFY_TO_USE_VIC_II_DE,
IDCLS_SPECIFY_TO_USE_VIC_II_FR,
IDCLS_SPECIFY_TO_USE_VIC_II_HU,
IDCLS_SPECIFY_TO_USE_VIC_II_IT,
IDCLS_SPECIFY_TO_USE_VIC_II_NL,
IDCLS_SPECIFY_TO_USE_VIC_II_PL,
IDCLS_SPECIFY_TO_USE_VIC_II_SV,
IDCLS_SPECIFY_TO_USE_VIC_II_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_TO_USE_CRTC,
IDCLS_SPECIFY_TO_USE_CRTC_DA,
IDCLS_SPECIFY_TO_USE_CRTC_DE,
IDCLS_SPECIFY_TO_USE_CRTC_FR,
IDCLS_SPECIFY_TO_USE_CRTC_HU,
IDCLS_SPECIFY_TO_USE_CRTC_IT,
IDCLS_SPECIFY_TO_USE_CRTC_NL,
IDCLS_SPECIFY_TO_USE_CRTC_PL,
IDCLS_SPECIFY_TO_USE_CRTC_SV,
IDCLS_SPECIFY_TO_USE_CRTC_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_P_LINENUMBER,
IDCLS_P_LINENUMBER_DA,
IDCLS_P_LINENUMBER_DE,
IDCLS_P_LINENUMBER_FR,
IDCLS_P_LINENUMBER_HU,
IDCLS_P_LINENUMBER_IT,
IDCLS_P_LINENUMBER_NL,
IDCLS_P_LINENUMBER_PL,
IDCLS_P_LINENUMBER_SV,
IDCLS_P_LINENUMBER_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DA,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_DE,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_FR,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_HU,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_IT,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_NL,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_PL,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_SV,
IDCLS_SPECIFY_CBM2_MODEL_HARDWARE_TR,

/* cbm2/cbm2-cmdline-options.c, plus4/plus4-cmdline-options.c */
IDCLS_P_RAMSIZE,
IDCLS_P_RAMSIZE_DA,
IDCLS_P_RAMSIZE_DE,
IDCLS_P_RAMSIZE_FR,
IDCLS_P_RAMSIZE_HU,
IDCLS_P_RAMSIZE_IT,
IDCLS_P_RAMSIZE_NL,
IDCLS_P_RAMSIZE_PL,
IDCLS_P_RAMSIZE_SV,
IDCLS_P_RAMSIZE_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_SIZE_OF_RAM,
IDCLS_SPECIFY_SIZE_OF_RAM_DA,
IDCLS_SPECIFY_SIZE_OF_RAM_DE,
IDCLS_SPECIFY_SIZE_OF_RAM_FR,
IDCLS_SPECIFY_SIZE_OF_RAM_HU,
IDCLS_SPECIFY_SIZE_OF_RAM_IT,
IDCLS_SPECIFY_SIZE_OF_RAM_NL,
IDCLS_SPECIFY_SIZE_OF_RAM_PL,
IDCLS_SPECIFY_SIZE_OF_RAM_SV,
IDCLS_SPECIFY_SIZE_OF_RAM_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CART_ROM_1000_NAME,
IDCLS_SPECIFY_CART_ROM_1000_NAME_DA,
IDCLS_SPECIFY_CART_ROM_1000_NAME_DE,
IDCLS_SPECIFY_CART_ROM_1000_NAME_FR,
IDCLS_SPECIFY_CART_ROM_1000_NAME_HU,
IDCLS_SPECIFY_CART_ROM_1000_NAME_IT,
IDCLS_SPECIFY_CART_ROM_1000_NAME_NL,
IDCLS_SPECIFY_CART_ROM_1000_NAME_PL,
IDCLS_SPECIFY_CART_ROM_1000_NAME_SV,
IDCLS_SPECIFY_CART_ROM_1000_NAME_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CART_ROM_2000_NAME,
IDCLS_SPECIFY_CART_ROM_2000_NAME_DA,
IDCLS_SPECIFY_CART_ROM_2000_NAME_DE,
IDCLS_SPECIFY_CART_ROM_2000_NAME_FR,
IDCLS_SPECIFY_CART_ROM_2000_NAME_HU,
IDCLS_SPECIFY_CART_ROM_2000_NAME_IT,
IDCLS_SPECIFY_CART_ROM_2000_NAME_NL,
IDCLS_SPECIFY_CART_ROM_2000_NAME_PL,
IDCLS_SPECIFY_CART_ROM_2000_NAME_SV,
IDCLS_SPECIFY_CART_ROM_2000_NAME_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CART_ROM_4000_NAME,
IDCLS_SPECIFY_CART_ROM_4000_NAME_DA,
IDCLS_SPECIFY_CART_ROM_4000_NAME_DE,
IDCLS_SPECIFY_CART_ROM_4000_NAME_FR,
IDCLS_SPECIFY_CART_ROM_4000_NAME_HU,
IDCLS_SPECIFY_CART_ROM_4000_NAME_IT,
IDCLS_SPECIFY_CART_ROM_4000_NAME_NL,
IDCLS_SPECIFY_CART_ROM_4000_NAME_PL,
IDCLS_SPECIFY_CART_ROM_4000_NAME_SV,
IDCLS_SPECIFY_CART_ROM_4000_NAME_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_SPECIFY_CART_ROM_6000_NAME,
IDCLS_SPECIFY_CART_ROM_6000_NAME_DA,
IDCLS_SPECIFY_CART_ROM_6000_NAME_DE,
IDCLS_SPECIFY_CART_ROM_6000_NAME_FR,
IDCLS_SPECIFY_CART_ROM_6000_NAME_HU,
IDCLS_SPECIFY_CART_ROM_6000_NAME_IT,
IDCLS_SPECIFY_CART_ROM_6000_NAME_NL,
IDCLS_SPECIFY_CART_ROM_6000_NAME_PL,
IDCLS_SPECIFY_CART_ROM_6000_NAME_SV,
IDCLS_SPECIFY_CART_ROM_6000_NAME_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_0800,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_0800_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_0800,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_0800_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_1000,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_1000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_1000,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_1000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_2000,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_2000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_2000,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_2000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_4000,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_4000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_4000,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_4000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_6000,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_6000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_6000,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_6000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_ENABLE_RAM_MAPPING_IN_C000,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_DA,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_DE,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_FR,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_HU,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_IT,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_NL,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_PL,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_SV,
IDCLS_ENABLE_RAM_MAPPING_IN_C000_TR,

/* cbm2/cbm2-cmdline-options.c */
IDCLS_DISABLE_RAM_MAPPING_IN_C000,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_DA,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_DE,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_FR,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_HU,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_IT,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_NL,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_PL,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_SV,
IDCLS_DISABLE_RAM_MAPPING_IN_C000_TR,

#ifdef COMMON_KBD
/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_KEYMAP_INDEX,
IDCLS_SPECIFY_KEYMAP_INDEX_DA,
IDCLS_SPECIFY_KEYMAP_INDEX_DE,
IDCLS_SPECIFY_KEYMAP_INDEX_FR,
IDCLS_SPECIFY_KEYMAP_INDEX_HU,
IDCLS_SPECIFY_KEYMAP_INDEX_IT,
IDCLS_SPECIFY_KEYMAP_INDEX_NL,
IDCLS_SPECIFY_KEYMAP_INDEX_PL,
IDCLS_SPECIFY_KEYMAP_INDEX_SV,
IDCLS_SPECIFY_KEYMAP_INDEX_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DA,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_DE,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_FR,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_HU,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_IT,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_NL,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_PL,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_SV,
IDCLS_SPECIFY_GFX_SYM_KEYMAP_NAME_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DA,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_DE,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_FR,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_HU,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_IT,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_NL,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_PL,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_SV,
IDCLS_SPECIFY_GFX_POS_KEYMAP_NAME_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DA,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_DE,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_FR,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_HU,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_IT,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_NL,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_PL,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_SV,
IDCLS_SPECIFY_BUK_SYM_KEYMAP_NAME_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DA,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_DE,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_FR,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_HU,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_IT,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_NL,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_PL,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_SV,
IDCLS_SPECIFY_BUK_POS_KEYMAP_NAME_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DA,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_DE,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_FR,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_HU,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_IT,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_NL,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_PL,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_SV,
IDCLS_SPECIFY_BDE_SYM_KEYMAP_NAME_TR,

/* cbm2/cbm2-cmdline-options.c, pet/pet-cmdline-options.c */
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DA,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_DE,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_FR,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_HU,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_IT,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_NL,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_PL,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_SV,
IDCLS_SPECIFY_BDE_POS_KEYMAP_NAME_TR,
#endif   /* COMMON_KBD */

/* drive/drive-cmdline-options.c */
IDCLS_ENABLE_TRUE_DRIVE,
IDCLS_ENABLE_TRUE_DRIVE_DA,
IDCLS_ENABLE_TRUE_DRIVE_DE,
IDCLS_ENABLE_TRUE_DRIVE_FR,
IDCLS_ENABLE_TRUE_DRIVE_HU,
IDCLS_ENABLE_TRUE_DRIVE_IT,
IDCLS_ENABLE_TRUE_DRIVE_NL,
IDCLS_ENABLE_TRUE_DRIVE_PL,
IDCLS_ENABLE_TRUE_DRIVE_SV,
IDCLS_ENABLE_TRUE_DRIVE_TR,

/* drive/drive-cmdline-options.c */
IDCLS_DISABLE_TRUE_DRIVE,
IDCLS_DISABLE_TRUE_DRIVE_DA,
IDCLS_DISABLE_TRUE_DRIVE_DE,
IDCLS_DISABLE_TRUE_DRIVE_FR,
IDCLS_DISABLE_TRUE_DRIVE_HU,
IDCLS_DISABLE_TRUE_DRIVE_IT,
IDCLS_DISABLE_TRUE_DRIVE_NL,
IDCLS_DISABLE_TRUE_DRIVE_PL,
IDCLS_DISABLE_TRUE_DRIVE_SV,
IDCLS_DISABLE_TRUE_DRIVE_TR,

/* drive/drive-cmdline-options.c, printerdrv/interface-serial.c,
attach.c, drive/iec/iec-cmdline-options.c */
IDCLS_P_TYPE,
IDCLS_P_TYPE_DA,
IDCLS_P_TYPE_DE,
IDCLS_P_TYPE_FR,
IDCLS_P_TYPE_HU,
IDCLS_P_TYPE_IT,
IDCLS_P_TYPE_NL,
IDCLS_P_TYPE_PL,
IDCLS_P_TYPE_SV,
IDCLS_P_TYPE_TR,

/* drive/drive-cmdline-options.c */
IDCLS_SET_DRIVE_TYPE,
IDCLS_SET_DRIVE_TYPE_DA,
IDCLS_SET_DRIVE_TYPE_DE,
IDCLS_SET_DRIVE_TYPE_FR,
IDCLS_SET_DRIVE_TYPE_HU,
IDCLS_SET_DRIVE_TYPE_IT,
IDCLS_SET_DRIVE_TYPE_NL,
IDCLS_SET_DRIVE_TYPE_PL,
IDCLS_SET_DRIVE_TYPE_SV,
IDCLS_SET_DRIVE_TYPE_TR,

/* drive/drive-cmdline-options.c, gfxoutputdrv/doodledrv.c */
IDCLS_P_METHOD,
IDCLS_P_METHOD_DA,
IDCLS_P_METHOD_DE,
IDCLS_P_METHOD_FR,
IDCLS_P_METHOD_HU,
IDCLS_P_METHOD_IT,
IDCLS_P_METHOD_NL,
IDCLS_P_METHOD_PL,
IDCLS_P_METHOD_SV,
IDCLS_P_METHOD_TR,

/* gfxoutputdrv/doodledrv.c */
IDCLS_P_COLOR,
IDCLS_P_COLOR_DA,
IDCLS_P_COLOR_DE,
IDCLS_P_COLOR_FR,
IDCLS_P_COLOR_HU,
IDCLS_P_COLOR_IT,
IDCLS_P_COLOR_NL,
IDCLS_P_COLOR_PL,
IDCLS_P_COLOR_SV,
IDCLS_P_COLOR_TR,

/* gfxoutputdrv/doodledrv.c */
IDCLS_OVERSIZED_HANDLING,
IDCLS_OVERSIZED_HANDLING_DA,
IDCLS_OVERSIZED_HANDLING_DE,
IDCLS_OVERSIZED_HANDLING_FR,
IDCLS_OVERSIZED_HANDLING_HU,
IDCLS_OVERSIZED_HANDLING_IT,
IDCLS_OVERSIZED_HANDLING_NL,
IDCLS_OVERSIZED_HANDLING_PL,
IDCLS_OVERSIZED_HANDLING_SV,
IDCLS_OVERSIZED_HANDLING_TR,

/* gfxoutputdrv/doodledrv.c */
IDCLS_MULTICOLOR_HANDLING,
IDCLS_MULTICOLOR_HANDLING_DA,
IDCLS_MULTICOLOR_HANDLING_DE,
IDCLS_MULTICOLOR_HANDLING_FR,
IDCLS_MULTICOLOR_HANDLING_HU,
IDCLS_MULTICOLOR_HANDLING_IT,
IDCLS_MULTICOLOR_HANDLING_NL,
IDCLS_MULTICOLOR_HANDLING_PL,
IDCLS_MULTICOLOR_HANDLING_SV,
IDCLS_MULTICOLOR_HANDLING_TR,

/* gfxoutputdrv/doodledrv.c */
IDCLS_TED_LUM_HANDLING,
IDCLS_TED_LUM_HANDLING_DA,
IDCLS_TED_LUM_HANDLING_DE,
IDCLS_TED_LUM_HANDLING_FR,
IDCLS_TED_LUM_HANDLING_HU,
IDCLS_TED_LUM_HANDLING_IT,
IDCLS_TED_LUM_HANDLING_NL,
IDCLS_TED_LUM_HANDLING_PL,
IDCLS_TED_LUM_HANDLING_SV,
IDCLS_TED_LUM_HANDLING_TR,

/* gfxoutputdrv/doodledrv.c */
IDCLS_CRTC_TEXT_COLOR,
IDCLS_CRTC_TEXT_COLOR_DA,
IDCLS_CRTC_TEXT_COLOR_DE,
IDCLS_CRTC_TEXT_COLOR_FR,
IDCLS_CRTC_TEXT_COLOR_HU,
IDCLS_CRTC_TEXT_COLOR_IT,
IDCLS_CRTC_TEXT_COLOR_NL,
IDCLS_CRTC_TEXT_COLOR_PL,
IDCLS_CRTC_TEXT_COLOR_SV,
IDCLS_CRTC_TEXT_COLOR_TR,

/* drive/drive-cmdline-options.c */
IDCLS_SET_DRIVE_EXTENSION_POLICY,
IDCLS_SET_DRIVE_EXTENSION_POLICY_DA,
IDCLS_SET_DRIVE_EXTENSION_POLICY_DE,
IDCLS_SET_DRIVE_EXTENSION_POLICY_FR,
IDCLS_SET_DRIVE_EXTENSION_POLICY_HU,
IDCLS_SET_DRIVE_EXTENSION_POLICY_IT,
IDCLS_SET_DRIVE_EXTENSION_POLICY_NL,
IDCLS_SET_DRIVE_EXTENSION_POLICY_PL,
IDCLS_SET_DRIVE_EXTENSION_POLICY_SV,
IDCLS_SET_DRIVE_EXTENSION_POLICY_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SPECIFY_1541_DOS_ROM_NAME,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1541_DOS_ROM_NAME_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1541_II_DOS_ROM_NAME_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SPECIFY_1570_DOS_ROM_NAME,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1570_DOS_ROM_NAME_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SPECIFY_1571_DOS_ROM_NAME,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1571_DOS_ROM_NAME_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SPECIFY_1581_DOS_ROM_NAME,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1581_DOS_ROM_NAME_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_SET_IDLE_METHOD,
IDCLS_SET_IDLE_METHOD_DA,
IDCLS_SET_IDLE_METHOD_DE,
IDCLS_SET_IDLE_METHOD_FR,
IDCLS_SET_IDLE_METHOD_HU,
IDCLS_SET_IDLE_METHOD_IT,
IDCLS_SET_IDLE_METHOD_NL,
IDCLS_SET_IDLE_METHOD_PL,
IDCLS_SET_IDLE_METHOD_SV,
IDCLS_SET_IDLE_METHOD_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_ENABLE_DRIVE_RAM_2000,
IDCLS_ENABLE_DRIVE_RAM_2000_DA,
IDCLS_ENABLE_DRIVE_RAM_2000_DE,
IDCLS_ENABLE_DRIVE_RAM_2000_FR,
IDCLS_ENABLE_DRIVE_RAM_2000_HU,
IDCLS_ENABLE_DRIVE_RAM_2000_IT,
IDCLS_ENABLE_DRIVE_RAM_2000_NL,
IDCLS_ENABLE_DRIVE_RAM_2000_PL,
IDCLS_ENABLE_DRIVE_RAM_2000_SV,
IDCLS_ENABLE_DRIVE_RAM_2000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_DISABLE_DRIVE_RAM_2000,
IDCLS_DISABLE_DRIVE_RAM_2000_DA,
IDCLS_DISABLE_DRIVE_RAM_2000_DE,
IDCLS_DISABLE_DRIVE_RAM_2000_FR,
IDCLS_DISABLE_DRIVE_RAM_2000_HU,
IDCLS_DISABLE_DRIVE_RAM_2000_IT,
IDCLS_DISABLE_DRIVE_RAM_2000_NL,
IDCLS_DISABLE_DRIVE_RAM_2000_PL,
IDCLS_DISABLE_DRIVE_RAM_2000_SV,
IDCLS_DISABLE_DRIVE_RAM_2000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_ENABLE_DRIVE_RAM_4000,
IDCLS_ENABLE_DRIVE_RAM_4000_DA,
IDCLS_ENABLE_DRIVE_RAM_4000_DE,
IDCLS_ENABLE_DRIVE_RAM_4000_FR,
IDCLS_ENABLE_DRIVE_RAM_4000_HU,
IDCLS_ENABLE_DRIVE_RAM_4000_IT,
IDCLS_ENABLE_DRIVE_RAM_4000_NL,
IDCLS_ENABLE_DRIVE_RAM_4000_PL,
IDCLS_ENABLE_DRIVE_RAM_4000_SV,
IDCLS_ENABLE_DRIVE_RAM_4000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_DISABLE_DRIVE_RAM_4000,
IDCLS_DISABLE_DRIVE_RAM_4000_DA,
IDCLS_DISABLE_DRIVE_RAM_4000_DE,
IDCLS_DISABLE_DRIVE_RAM_4000_FR,
IDCLS_DISABLE_DRIVE_RAM_4000_HU,
IDCLS_DISABLE_DRIVE_RAM_4000_IT,
IDCLS_DISABLE_DRIVE_RAM_4000_NL,
IDCLS_DISABLE_DRIVE_RAM_4000_PL,
IDCLS_DISABLE_DRIVE_RAM_4000_SV,
IDCLS_DISABLE_DRIVE_RAM_4000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_ENABLE_DRIVE_RAM_6000,
IDCLS_ENABLE_DRIVE_RAM_6000_DA,
IDCLS_ENABLE_DRIVE_RAM_6000_DE,
IDCLS_ENABLE_DRIVE_RAM_6000_FR,
IDCLS_ENABLE_DRIVE_RAM_6000_HU,
IDCLS_ENABLE_DRIVE_RAM_6000_IT,
IDCLS_ENABLE_DRIVE_RAM_6000_NL,
IDCLS_ENABLE_DRIVE_RAM_6000_PL,
IDCLS_ENABLE_DRIVE_RAM_6000_SV,
IDCLS_ENABLE_DRIVE_RAM_6000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_DISABLE_DRIVE_RAM_6000,
IDCLS_DISABLE_DRIVE_RAM_6000_DA,
IDCLS_DISABLE_DRIVE_RAM_6000_DE,
IDCLS_DISABLE_DRIVE_RAM_6000_FR,
IDCLS_DISABLE_DRIVE_RAM_6000_HU,
IDCLS_DISABLE_DRIVE_RAM_6000_IT,
IDCLS_DISABLE_DRIVE_RAM_6000_NL,
IDCLS_DISABLE_DRIVE_RAM_6000_PL,
IDCLS_DISABLE_DRIVE_RAM_6000_SV,
IDCLS_DISABLE_DRIVE_RAM_6000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_ENABLE_DRIVE_RAM_8000,
IDCLS_ENABLE_DRIVE_RAM_8000_DA,
IDCLS_ENABLE_DRIVE_RAM_8000_DE,
IDCLS_ENABLE_DRIVE_RAM_8000_FR,
IDCLS_ENABLE_DRIVE_RAM_8000_HU,
IDCLS_ENABLE_DRIVE_RAM_8000_IT,
IDCLS_ENABLE_DRIVE_RAM_8000_NL,
IDCLS_ENABLE_DRIVE_RAM_8000_PL,
IDCLS_ENABLE_DRIVE_RAM_8000_SV,
IDCLS_ENABLE_DRIVE_RAM_8000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_DISABLE_DRIVE_RAM_8000,
IDCLS_DISABLE_DRIVE_RAM_8000_DA,
IDCLS_DISABLE_DRIVE_RAM_8000_DE,
IDCLS_DISABLE_DRIVE_RAM_8000_FR,
IDCLS_DISABLE_DRIVE_RAM_8000_HU,
IDCLS_DISABLE_DRIVE_RAM_8000_IT,
IDCLS_DISABLE_DRIVE_RAM_8000_NL,
IDCLS_DISABLE_DRIVE_RAM_8000_PL,
IDCLS_DISABLE_DRIVE_RAM_8000_SV,
IDCLS_DISABLE_DRIVE_RAM_8000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_ENABLE_DRIVE_RAM_A000,
IDCLS_ENABLE_DRIVE_RAM_A000_DA,
IDCLS_ENABLE_DRIVE_RAM_A000_DE,
IDCLS_ENABLE_DRIVE_RAM_A000_FR,
IDCLS_ENABLE_DRIVE_RAM_A000_HU,
IDCLS_ENABLE_DRIVE_RAM_A000_IT,
IDCLS_ENABLE_DRIVE_RAM_A000_NL,
IDCLS_ENABLE_DRIVE_RAM_A000_PL,
IDCLS_ENABLE_DRIVE_RAM_A000_SV,
IDCLS_ENABLE_DRIVE_RAM_A000_TR,

/* drive/iec/iec-cmdline-options.c */
IDCLS_DISABLE_DRIVE_RAM_A000,
IDCLS_DISABLE_DRIVE_RAM_A000_DA,
IDCLS_DISABLE_DRIVE_RAM_A000_DE,
IDCLS_DISABLE_DRIVE_RAM_A000_FR,
IDCLS_DISABLE_DRIVE_RAM_A000_HU,
IDCLS_DISABLE_DRIVE_RAM_A000_IT,
IDCLS_DISABLE_DRIVE_RAM_A000_NL,
IDCLS_DISABLE_DRIVE_RAM_A000_PL,
IDCLS_DISABLE_DRIVE_RAM_A000_SV,
IDCLS_DISABLE_DRIVE_RAM_A000_TR,

/* drive/iec/c64exp/c64exp-cmdline-options.c */
IDCLS_PAR_CABLE_C64EXP_TYPE,
IDCLS_PAR_CABLE_C64EXP_TYPE_DA,
IDCLS_PAR_CABLE_C64EXP_TYPE_DE,
IDCLS_PAR_CABLE_C64EXP_TYPE_FR,
IDCLS_PAR_CABLE_C64EXP_TYPE_HU,
IDCLS_PAR_CABLE_C64EXP_TYPE_IT,
IDCLS_PAR_CABLE_C64EXP_TYPE_NL,
IDCLS_PAR_CABLE_C64EXP_TYPE_PL,
IDCLS_PAR_CABLE_C64EXP_TYPE_SV,
IDCLS_PAR_CABLE_C64EXP_TYPE_TR,

/* drive/iec/c64exp/c64exp-cmdline-options.c */
IDCLS_ENABLE_PROFDOS,
IDCLS_ENABLE_PROFDOS_DA,
IDCLS_ENABLE_PROFDOS_DE,
IDCLS_ENABLE_PROFDOS_FR,
IDCLS_ENABLE_PROFDOS_HU,
IDCLS_ENABLE_PROFDOS_IT,
IDCLS_ENABLE_PROFDOS_NL,
IDCLS_ENABLE_PROFDOS_PL,
IDCLS_ENABLE_PROFDOS_SV,
IDCLS_ENABLE_PROFDOS_TR,

/* drive/iec/c64exp/c64exp-cmdline-options.c */
IDCLS_DISABLE_PROFDOS,
IDCLS_DISABLE_PROFDOS_DA,
IDCLS_DISABLE_PROFDOS_DE,
IDCLS_DISABLE_PROFDOS_FR,
IDCLS_DISABLE_PROFDOS_HU,
IDCLS_DISABLE_PROFDOS_IT,
IDCLS_DISABLE_PROFDOS_NL,
IDCLS_DISABLE_PROFDOS_PL,
IDCLS_DISABLE_PROFDOS_SV,
IDCLS_DISABLE_PROFDOS_TR,

/* drive/iec/c64exp/c64exp-cmdline-options.c */
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DA,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_DE,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_FR,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_HU,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_IT,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_NL,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_PL,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_SV,
IDCLS_SPECIFY_PROFDOS_1571_ROM_NAME_TR,

/* drive/iec/plus4exp/plus4exp-cmdline-options.c */
IDCLS_PAR_CABLE_PLUS4EXP_TYPE,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DA,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_DE,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_FR,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_HU,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_IT,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_NL,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_PL,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_SV,
IDCLS_PAR_CABLE_PLUS4EXP_TYPE_TR,

/* drive/iec128dcr/iec128dcr-cmdline-options.c */
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1571CR_DOS_ROM_NAME_TR,

/* drive/ieee/ieee-cmdline-options.c */
IDCLS_SPECIFY_2031_DOS_ROM_NAME,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_2031_DOS_ROM_NAME_TR,

/* drive/ieee/ieee-cmdline-options.c */
IDCLS_SPECIFY_2040_DOS_ROM_NAME,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_2040_DOS_ROM_NAME_TR,

/* drive/ieee/ieee-cmdline-options.c */
IDCLS_SPECIFY_3040_DOS_ROM_NAME,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_3040_DOS_ROM_NAME_TR,

/* drive/ieee/ieee-cmdline-options.c */
IDCLS_SPECIFY_4040_DOS_ROM_NAME,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_4040_DOS_ROM_NAME_TR,

/* drive/ieee/ieee-cmdline-options.c */
IDCLS_SPECIFY_1001_DOS_ROM_NAME,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1001_DOS_ROM_NAME_TR,

/* drive/tcbm/tcbm-cmdline-options.c */
IDCLS_SPECIFY_1551_DOS_ROM_NAME,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_DA,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_DE,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_FR,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_HU,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_IT,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_NL,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_PL,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_SV,
IDCLS_SPECIFY_1551_DOS_ROM_NAME_TR,

/* fsdevice/fsdevice-cmdline-options.c */
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DA,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_DE,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_FR,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_HU,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_IT,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_NL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_PL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_SV,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_8_TR,

/* fsdevice/fsdevice-cmdline-options.c */
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DA,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_DE,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_FR,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_HU,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_IT,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_NL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_PL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_SV,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_9_TR,

/* fsdevice/fsdevice-cmdline-options.c */
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DA,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_DE,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_FR,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_HU,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_IT,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_NL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_PL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_SV,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_10_TR,

/* fsdevice/fsdevice-cmdline-options.c */
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DA,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_DE,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_FR,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_HU,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_IT,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_NL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_PL,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_SV,
IDCLS_USE_AS_DIRECTORY_FSDEVICE_11_TR,

#ifdef HAVE_FFMPEG
/* gfxoutputdrv/ffmpegdrv.c */
IDCLS_SET_AUDIO_STREAM_BITRATE,
IDCLS_SET_AUDIO_STREAM_BITRATE_DA,
IDCLS_SET_AUDIO_STREAM_BITRATE_DE,
IDCLS_SET_AUDIO_STREAM_BITRATE_FR,
IDCLS_SET_AUDIO_STREAM_BITRATE_HU,
IDCLS_SET_AUDIO_STREAM_BITRATE_IT,
IDCLS_SET_AUDIO_STREAM_BITRATE_NL,
IDCLS_SET_AUDIO_STREAM_BITRATE_PL,
IDCLS_SET_AUDIO_STREAM_BITRATE_SV,
IDCLS_SET_AUDIO_STREAM_BITRATE_TR,

/* gfxoutputdrv/ffmpegdrv.c */
IDCLS_SET_VIDEO_STREAM_BITRATE,
IDCLS_SET_VIDEO_STREAM_BITRATE_DA,
IDCLS_SET_VIDEO_STREAM_BITRATE_DE,
IDCLS_SET_VIDEO_STREAM_BITRATE_FR,
IDCLS_SET_VIDEO_STREAM_BITRATE_HU,
IDCLS_SET_VIDEO_STREAM_BITRATE_IT,
IDCLS_SET_VIDEO_STREAM_BITRATE_NL,
IDCLS_SET_VIDEO_STREAM_BITRATE_PL,
IDCLS_SET_VIDEO_STREAM_BITRATE_SV,
IDCLS_SET_VIDEO_STREAM_BITRATE_TR,
#endif   /* HAVE_FFMPEG */

/* pet/pet-cmdline-options.c */
IDCLS_SPECIFY_PET_MODEL,
IDCLS_SPECIFY_PET_MODEL_DA,
IDCLS_SPECIFY_PET_MODEL_DE,
IDCLS_SPECIFY_PET_MODEL_FR,
IDCLS_SPECIFY_PET_MODEL_HU,
IDCLS_SPECIFY_PET_MODEL_IT,
IDCLS_SPECIFY_PET_MODEL_NL,
IDCLS_SPECIFY_PET_MODEL_PL,
IDCLS_SPECIFY_PET_MODEL_SV,
IDCLS_SPECIFY_PET_MODEL_TR,

/* pet/pet-cmdline-options.c */
IDCLS_SPECIFY_EDITOR_ROM_NAME,
IDCLS_SPECIFY_EDITOR_ROM_NAME_DA,
IDCLS_SPECIFY_EDITOR_ROM_NAME_DE,
IDCLS_SPECIFY_EDITOR_ROM_NAME_FR,
IDCLS_SPECIFY_EDITOR_ROM_NAME_HU,
IDCLS_SPECIFY_EDITOR_ROM_NAME_IT,
IDCLS_SPECIFY_EDITOR_ROM_NAME_NL,
IDCLS_SPECIFY_EDITOR_ROM_NAME_PL,
IDCLS_SPECIFY_EDITOR_ROM_NAME_SV,
IDCLS_SPECIFY_EDITOR_ROM_NAME_TR,

/* pet/pet-cmdline-options.c */
IDCLS_SPECIFY_4K_ROM_9XXX_NAME,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DA,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_DE,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_FR,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_HU,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_IT,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_NL,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_PL,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_SV,
IDCLS_SPECIFY_4K_ROM_9XXX_NAME_TR,

/* pet/pet-cmdline-options.c */
IDCLS_SPECIFY_4K_ROM_AXXX_NAME,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DA,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_DE,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_FR,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_HU,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_IT,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_NL,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_PL,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_SV,
IDCLS_SPECIFY_4K_ROM_AXXX_NAME_TR,

/* pet/pet-cmdline-options.c */
IDCLS_SPECIFY_4K_ROM_BXXX_NAME,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DA,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_DE,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_FR,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_HU,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_IT,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_NL,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_PL,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_SV,
IDCLS_SPECIFY_4K_ROM_BXXX_NAME_TR,

/* pet/pet-cmdline-options.c */
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DA,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_DE,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_FR,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_HU,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_IT,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_NL,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_PL,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_SV,
IDCLS_PET8296_ENABLE_4K_RAM_AT_9000_TR,

/* pet/pet-cmdline-options.c */
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DA,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_DE,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_FR,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_HU,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_IT,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_NL,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_PL,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_SV,
IDCLS_PET8296_DISABLE_4K_RAM_AT_9000_TR,

/* pet/pet-cmdline-options.c */
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DA,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_DE,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_FR,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_HU,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_IT,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_NL,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_PL,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_SV,
IDCLS_PET8296_ENABLE_4K_RAM_AT_A000_TR,

/* pet/pet-cmdline-options.c */
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DA,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_DE,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_FR,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_HU,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_IT,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_NL,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_PL,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_SV,
IDCLS_PET8296_DISABLE_4K_RAM_AT_A000_TR,

/* pet/pet-cmdline-options.c */
IDCLS_ENABLE_SUPERPET_IO,
IDCLS_ENABLE_SUPERPET_IO_DA,
IDCLS_ENABLE_SUPERPET_IO_DE,
IDCLS_ENABLE_SUPERPET_IO_FR,
IDCLS_ENABLE_SUPERPET_IO_HU,
IDCLS_ENABLE_SUPERPET_IO_IT,
IDCLS_ENABLE_SUPERPET_IO_NL,
IDCLS_ENABLE_SUPERPET_IO_PL,
IDCLS_ENABLE_SUPERPET_IO_SV,
IDCLS_ENABLE_SUPERPET_IO_TR,

/* pet/pet-cmdline-options.c */
IDCLS_DISABLE_SUPERPET_IO,
IDCLS_DISABLE_SUPERPET_IO_DA,
IDCLS_DISABLE_SUPERPET_IO_DE,
IDCLS_DISABLE_SUPERPET_IO_FR,
IDCLS_DISABLE_SUPERPET_IO_HU,
IDCLS_DISABLE_SUPERPET_IO_IT,
IDCLS_DISABLE_SUPERPET_IO_NL,
IDCLS_DISABLE_SUPERPET_IO_PL,
IDCLS_DISABLE_SUPERPET_IO_SV,
IDCLS_DISABLE_SUPERPET_IO_TR,

/* pet/pet-cmdline-options.c */
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DA,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_DE,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_FR,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_HU,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_IT,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_NL,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_PL,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_SV,
IDCLS_ENABLE_ROM_1_KERNAL_PATCHES_TR,

/* pet/pet-cmdline-options.c */
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DA,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_DE,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_FR,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_HU,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_IT,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_NL,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_PL,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_SV,
IDCLS_DISABLE_ROM_1_KERNAL_PATCHES_TR,

/* pet/pet-cmdline-options.c */
IDCLS_SWITCH_UPPER_LOWER_CHARSET,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_DA,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_DE,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_FR,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_HU,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_IT,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_NL,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_PL,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_SV,
IDCLS_SWITCH_UPPER_LOWER_CHARSET_TR,

/* pet/pet-cmdline-options.c */
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DA,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_DE,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_FR,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_HU,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_IT,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_NL,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_PL,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_SV,
IDCLS_NO_SWITCH_UPPER_LOWER_CHARSET_TR,

/* pet/pet-cmdline-options.c */
IDCLS_EOI_BLANKS_SCREEN,
IDCLS_EOI_BLANKS_SCREEN_DA,
IDCLS_EOI_BLANKS_SCREEN_DE,
IDCLS_EOI_BLANKS_SCREEN_FR,
IDCLS_EOI_BLANKS_SCREEN_HU,
IDCLS_EOI_BLANKS_SCREEN_IT,
IDCLS_EOI_BLANKS_SCREEN_NL,
IDCLS_EOI_BLANKS_SCREEN_PL,
IDCLS_EOI_BLANKS_SCREEN_SV,
IDCLS_EOI_BLANKS_SCREEN_TR,

/* pet/pet-cmdline-options.c */
IDCLS_EOI_DOES_NOT_BLANK_SCREEN,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DA,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_DE,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_FR,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_HU,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_IT,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_NL,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_PL,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_SV,
IDCLS_EOI_DOES_NOT_BLANK_SCREEN_TR,

/* pet/petpia1.c */
IDCLS_ENABLE_USERPORT_DIAG_PIN,
IDCLS_ENABLE_USERPORT_DIAG_PIN_DA,
IDCLS_ENABLE_USERPORT_DIAG_PIN_DE,
IDCLS_ENABLE_USERPORT_DIAG_PIN_FR,
IDCLS_ENABLE_USERPORT_DIAG_PIN_HU,
IDCLS_ENABLE_USERPORT_DIAG_PIN_IT,
IDCLS_ENABLE_USERPORT_DIAG_PIN_NL,
IDCLS_ENABLE_USERPORT_DIAG_PIN_PL,
IDCLS_ENABLE_USERPORT_DIAG_PIN_SV,
IDCLS_ENABLE_USERPORT_DIAG_PIN_TR,

/* pet/petpia1.c */
IDCLS_DISABLE_USERPORT_DIAG_PIN,
IDCLS_DISABLE_USERPORT_DIAG_PIN_DA,
IDCLS_DISABLE_USERPORT_DIAG_PIN_DE,
IDCLS_DISABLE_USERPORT_DIAG_PIN_FR,
IDCLS_DISABLE_USERPORT_DIAG_PIN_HU,
IDCLS_DISABLE_USERPORT_DIAG_PIN_IT,
IDCLS_DISABLE_USERPORT_DIAG_PIN_NL,
IDCLS_DISABLE_USERPORT_DIAG_PIN_PL,
IDCLS_DISABLE_USERPORT_DIAG_PIN_SV,
IDCLS_DISABLE_USERPORT_DIAG_PIN_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DA,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_DE,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_FR,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_HU,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_IT,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_NL,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_PL,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_SV,
IDCLS_SPECIFY_FUNCTION_LOW_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DA,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_DE,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_FR,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_HU,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_IT,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_NL,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_PL,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_SV,
IDCLS_SPECIFY_FUNCTION_HIGH_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DA,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_DE,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_FR,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_HU,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_IT,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_NL,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_PL,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_SV,
IDCLS_SPECIFY_CART_1_LOW_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DA,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_DE,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_FR,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_HU,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_IT,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_NL,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_PL,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_SV,
IDCLS_SPECIFY_CART_1_HIGH_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DA,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_DE,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_FR,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_HU,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_IT,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_NL,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_PL,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_SV,
IDCLS_SPECIFY_CART_2_LOW_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DA,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_DE,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_FR,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_HU,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_IT,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_NL,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_PL,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_SV,
IDCLS_SPECIFY_CART_2_HIGH_ROM_NAME_TR,

/* plus4/plus4-cmdline-options.c */
IDCLS_SPECIFY_RAM_INSTALLED,
IDCLS_SPECIFY_RAM_INSTALLED_DA,
IDCLS_SPECIFY_RAM_INSTALLED_DE,
IDCLS_SPECIFY_RAM_INSTALLED_FR,
IDCLS_SPECIFY_RAM_INSTALLED_HU,
IDCLS_SPECIFY_RAM_INSTALLED_IT,
IDCLS_SPECIFY_RAM_INSTALLED_NL,
IDCLS_SPECIFY_RAM_INSTALLED_PL,
IDCLS_SPECIFY_RAM_INSTALLED_SV,
IDCLS_SPECIFY_RAM_INSTALLED_TR,

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
IDCLS_SET_SATURATION,
IDCLS_SET_SATURATION_DA,
IDCLS_SET_SATURATION_DE,
IDCLS_SET_SATURATION_FR,
IDCLS_SET_SATURATION_HU,
IDCLS_SET_SATURATION_IT,
IDCLS_SET_SATURATION_NL,
IDCLS_SET_SATURATION_PL,
IDCLS_SET_SATURATION_SV,
IDCLS_SET_SATURATION_TR,

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
IDCLS_SET_CONTRAST,
IDCLS_SET_CONTRAST_DA,
IDCLS_SET_CONTRAST_DE,
IDCLS_SET_CONTRAST_FR,
IDCLS_SET_CONTRAST_HU,
IDCLS_SET_CONTRAST_IT,
IDCLS_SET_CONTRAST_NL,
IDCLS_SET_CONTRAST_PL,
IDCLS_SET_CONTRAST_SV,
IDCLS_SET_CONTRAST_TR,

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
IDCLS_SET_BRIGHTNESS,
IDCLS_SET_BRIGHTNESS_DA,
IDCLS_SET_BRIGHTNESS_DE,
IDCLS_SET_BRIGHTNESS_FR,
IDCLS_SET_BRIGHTNESS_HU,
IDCLS_SET_BRIGHTNESS_IT,
IDCLS_SET_BRIGHTNESS_NL,
IDCLS_SET_BRIGHTNESS_PL,
IDCLS_SET_BRIGHTNESS_SV,
IDCLS_SET_BRIGHTNESS_TR,

/* plus4/ted-cmdline-options.c, vicii/vicii-cmdline-options.c */
IDCLS_SET_GAMMA,
IDCLS_SET_GAMMA_DA,
IDCLS_SET_GAMMA_DE,
IDCLS_SET_GAMMA_FR,
IDCLS_SET_GAMMA_HU,
IDCLS_SET_GAMMA_IT,
IDCLS_SET_GAMMA_NL,
IDCLS_SET_GAMMA_PL,
IDCLS_SET_GAMMA_SV,
IDCLS_SET_GAMMA_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_SET_TINT,
IDCLS_SET_TINT_DA,
IDCLS_SET_TINT_DE,
IDCLS_SET_TINT_FR,
IDCLS_SET_TINT_HU,
IDCLS_SET_TINT_IT,
IDCLS_SET_TINT_NL,
IDCLS_SET_TINT_PL,
IDCLS_SET_TINT_SV,
IDCLS_SET_TINT_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_SET_ODDLINES_PHASE,
IDCLS_SET_ODDLINES_PHASE_DA,
IDCLS_SET_ODDLINES_PHASE_DE,
IDCLS_SET_ODDLINES_PHASE_FR,
IDCLS_SET_ODDLINES_PHASE_HU,
IDCLS_SET_ODDLINES_PHASE_IT,
IDCLS_SET_ODDLINES_PHASE_NL,
IDCLS_SET_ODDLINES_PHASE_PL,
IDCLS_SET_ODDLINES_PHASE_SV,
IDCLS_SET_ODDLINES_PHASE_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_SET_ODDLINES_OFFSET,
IDCLS_SET_ODDLINES_OFFSET_DA,
IDCLS_SET_ODDLINES_OFFSET_DE,
IDCLS_SET_ODDLINES_OFFSET_FR,
IDCLS_SET_ODDLINES_OFFSET_HU,
IDCLS_SET_ODDLINES_OFFSET_IT,
IDCLS_SET_ODDLINES_OFFSET_NL,
IDCLS_SET_ODDLINES_OFFSET_PL,
IDCLS_SET_ODDLINES_OFFSET_SV,
IDCLS_SET_ODDLINES_OFFSET_TR,

/* viciisc/vicii-cmdline-options.c */
IDCLS_SET_VICII_MODEL,
IDCLS_SET_VICII_MODEL_DA,
IDCLS_SET_VICII_MODEL_DE,
IDCLS_SET_VICII_MODEL_FR,
IDCLS_SET_VICII_MODEL_HU,
IDCLS_SET_VICII_MODEL_IT,
IDCLS_SET_VICII_MODEL_NL,
IDCLS_SET_VICII_MODEL_PL,
IDCLS_SET_VICII_MODEL_SV,
IDCLS_SET_VICII_MODEL_TR,

/* printerdrv/driver-select.c */
IDCLS_SPECIFY_PRT_DRIVER_4_NAME,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DA,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_DE,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_FR,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_HU,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_IT,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_NL,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_PL,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_SV,
IDCLS_SPECIFY_PRT_DRIVER_4_NAME_TR,

/* printerdrv/driver-select.c */
IDCLS_SPECIFY_PRT_DRIVER_5_NAME,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DA,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_DE,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_FR,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_HU,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_IT,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_NL,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_PL,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_SV,
IDCLS_SPECIFY_PRT_DRIVER_5_NAME_TR,

/* printerdrv/driver-select.c */
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DA,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_DE,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_FR,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_HU,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_IT,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_NL,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_PL,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_SV,
IDCLS_SPECIFY_PRT_DRIVER_USR_NAME_TR,

/* printerdrv/interface-serial.c */
IDCLS_SET_DEVICE_TYPE_4,
IDCLS_SET_DEVICE_TYPE_4_DA,
IDCLS_SET_DEVICE_TYPE_4_DE,
IDCLS_SET_DEVICE_TYPE_4_FR,
IDCLS_SET_DEVICE_TYPE_4_HU,
IDCLS_SET_DEVICE_TYPE_4_IT,
IDCLS_SET_DEVICE_TYPE_4_NL,
IDCLS_SET_DEVICE_TYPE_4_PL,
IDCLS_SET_DEVICE_TYPE_4_SV,
IDCLS_SET_DEVICE_TYPE_4_TR,

/* printerdrv/interface-serial.c */
IDCLS_SET_DEVICE_TYPE_5,
IDCLS_SET_DEVICE_TYPE_5_DA,
IDCLS_SET_DEVICE_TYPE_5_DE,
IDCLS_SET_DEVICE_TYPE_5_FR,
IDCLS_SET_DEVICE_TYPE_5_HU,
IDCLS_SET_DEVICE_TYPE_5_IT,
IDCLS_SET_DEVICE_TYPE_5_NL,
IDCLS_SET_DEVICE_TYPE_5_PL,
IDCLS_SET_DEVICE_TYPE_5_SV,
IDCLS_SET_DEVICE_TYPE_5_TR,

/* printerdrv/interface-userport.c */
IDCLS_ENABLE_USERPORT_PRINTER,
IDCLS_ENABLE_USERPORT_PRINTER_DA,
IDCLS_ENABLE_USERPORT_PRINTER_DE,
IDCLS_ENABLE_USERPORT_PRINTER_FR,
IDCLS_ENABLE_USERPORT_PRINTER_HU,
IDCLS_ENABLE_USERPORT_PRINTER_IT,
IDCLS_ENABLE_USERPORT_PRINTER_NL,
IDCLS_ENABLE_USERPORT_PRINTER_PL,
IDCLS_ENABLE_USERPORT_PRINTER_SV,
IDCLS_ENABLE_USERPORT_PRINTER_TR,

/* printerdrv/interface-userport.c */
IDCLS_DISABLE_USERPORT_PRINTER,
IDCLS_DISABLE_USERPORT_PRINTER_DA,
IDCLS_DISABLE_USERPORT_PRINTER_DE,
IDCLS_DISABLE_USERPORT_PRINTER_FR,
IDCLS_DISABLE_USERPORT_PRINTER_HU,
IDCLS_DISABLE_USERPORT_PRINTER_IT,
IDCLS_DISABLE_USERPORT_PRINTER_NL,
IDCLS_DISABLE_USERPORT_PRINTER_PL,
IDCLS_DISABLE_USERPORT_PRINTER_SV,
IDCLS_DISABLE_USERPORT_PRINTER_TR,

/* printerdrv/output-select.c */
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DA,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_DE,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_FR,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_HU,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_IT,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_NL,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_PL,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_SV,
IDCLS_SPECIFY_OUTPUT_DEVICE_4_NAME_TR,

/* printerdrv/output-select.c */
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DA,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_DE,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_FR,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_HU,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_IT,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_NL,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_PL,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_SV,
IDCLS_SPECIFY_OUTPUT_DEVICE_5_NAME_TR,

/* printerdrv/output-select.c */
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DA,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_DE,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_FR,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_HU,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_IT,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_NL,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_PL,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_SV,
IDCLS_SPECIFY_OUTPUT_DEVICE_USR_NAME_TR,

/* printerdrv/output-text.c */
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DA,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_DE,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_FR,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_HU,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_IT,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_NL,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_PL,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_SV,
IDCLS_SPECIFY_TEXT_DEVICE_DUMP_NAME_TR,

/* printerdrv/output-text.c */
IDCLS_SPECIFY_TEXT_DEVICE_4,
IDCLS_SPECIFY_TEXT_DEVICE_4_DA,
IDCLS_SPECIFY_TEXT_DEVICE_4_DE,
IDCLS_SPECIFY_TEXT_DEVICE_4_FR,
IDCLS_SPECIFY_TEXT_DEVICE_4_HU,
IDCLS_SPECIFY_TEXT_DEVICE_4_IT,
IDCLS_SPECIFY_TEXT_DEVICE_4_NL,
IDCLS_SPECIFY_TEXT_DEVICE_4_PL,
IDCLS_SPECIFY_TEXT_DEVICE_4_SV,
IDCLS_SPECIFY_TEXT_DEVICE_4_TR,

/* printerdrv/output-text.c */
IDCLS_SPECIFY_TEXT_DEVICE_5,
IDCLS_SPECIFY_TEXT_DEVICE_5_DA,
IDCLS_SPECIFY_TEXT_DEVICE_5_DE,
IDCLS_SPECIFY_TEXT_DEVICE_5_FR,
IDCLS_SPECIFY_TEXT_DEVICE_5_HU,
IDCLS_SPECIFY_TEXT_DEVICE_5_IT,
IDCLS_SPECIFY_TEXT_DEVICE_5_NL,
IDCLS_SPECIFY_TEXT_DEVICE_5_PL,
IDCLS_SPECIFY_TEXT_DEVICE_5_SV,
IDCLS_SPECIFY_TEXT_DEVICE_5_TR,

/* printerdrv/output-text.c */
IDCLS_SPECIFY_TEXT_USERPORT,
IDCLS_SPECIFY_TEXT_USERPORT_DA,
IDCLS_SPECIFY_TEXT_USERPORT_DE,
IDCLS_SPECIFY_TEXT_USERPORT_FR,
IDCLS_SPECIFY_TEXT_USERPORT_HU,
IDCLS_SPECIFY_TEXT_USERPORT_IT,
IDCLS_SPECIFY_TEXT_USERPORT_NL,
IDCLS_SPECIFY_TEXT_USERPORT_PL,
IDCLS_SPECIFY_TEXT_USERPORT_SV,
IDCLS_SPECIFY_TEXT_USERPORT_TR,

/* raster/raster-cmdline-options.c */
IDCLS_ENABLE_VIDEO_CACHE,
IDCLS_ENABLE_VIDEO_CACHE_DA,
IDCLS_ENABLE_VIDEO_CACHE_DE,
IDCLS_ENABLE_VIDEO_CACHE_FR,
IDCLS_ENABLE_VIDEO_CACHE_HU,
IDCLS_ENABLE_VIDEO_CACHE_IT,
IDCLS_ENABLE_VIDEO_CACHE_NL,
IDCLS_ENABLE_VIDEO_CACHE_PL,
IDCLS_ENABLE_VIDEO_CACHE_SV,
IDCLS_ENABLE_VIDEO_CACHE_TR,

/* raster/raster-cmdline-options.c */
IDCLS_DISABLE_VIDEO_CACHE,
IDCLS_DISABLE_VIDEO_CACHE_DA,
IDCLS_DISABLE_VIDEO_CACHE_DE,
IDCLS_DISABLE_VIDEO_CACHE_FR,
IDCLS_DISABLE_VIDEO_CACHE_HU,
IDCLS_DISABLE_VIDEO_CACHE_IT,
IDCLS_DISABLE_VIDEO_CACHE_NL,
IDCLS_DISABLE_VIDEO_CACHE_PL,
IDCLS_DISABLE_VIDEO_CACHE_SV,
IDCLS_DISABLE_VIDEO_CACHE_TR,

#ifdef HAVE_RS232
/* rs232drv/rs232drv.c */
IDCLS_SPECIFY_RS232_1_NAME,
IDCLS_SPECIFY_RS232_1_NAME_DA,
IDCLS_SPECIFY_RS232_1_NAME_DE,
IDCLS_SPECIFY_RS232_1_NAME_FR,
IDCLS_SPECIFY_RS232_1_NAME_HU,
IDCLS_SPECIFY_RS232_1_NAME_IT,
IDCLS_SPECIFY_RS232_1_NAME_NL,
IDCLS_SPECIFY_RS232_1_NAME_PL,
IDCLS_SPECIFY_RS232_1_NAME_SV,
IDCLS_SPECIFY_RS232_1_NAME_TR,

/* rs232drv/rs232drv.c */
IDCLS_SPECIFY_RS232_2_NAME,
IDCLS_SPECIFY_RS232_2_NAME_DA,
IDCLS_SPECIFY_RS232_2_NAME_DE,
IDCLS_SPECIFY_RS232_2_NAME_FR,
IDCLS_SPECIFY_RS232_2_NAME_HU,
IDCLS_SPECIFY_RS232_2_NAME_IT,
IDCLS_SPECIFY_RS232_2_NAME_NL,
IDCLS_SPECIFY_RS232_2_NAME_PL,
IDCLS_SPECIFY_RS232_2_NAME_SV,
IDCLS_SPECIFY_RS232_2_NAME_TR,

/* rs232drv/rs232drv.c */
IDCLS_SPECIFY_RS232_3_NAME,
IDCLS_SPECIFY_RS232_3_NAME_DA,
IDCLS_SPECIFY_RS232_3_NAME_DE,
IDCLS_SPECIFY_RS232_3_NAME_FR,
IDCLS_SPECIFY_RS232_3_NAME_HU,
IDCLS_SPECIFY_RS232_3_NAME_IT,
IDCLS_SPECIFY_RS232_3_NAME_NL,
IDCLS_SPECIFY_RS232_3_NAME_PL,
IDCLS_SPECIFY_RS232_3_NAME_SV,
IDCLS_SPECIFY_RS232_3_NAME_TR,

/* rs232drv/rs232drv.c */
IDCLS_SPECIFY_RS232_4_NAME,
IDCLS_SPECIFY_RS232_4_NAME_DA,
IDCLS_SPECIFY_RS232_4_NAME_DE,
IDCLS_SPECIFY_RS232_4_NAME_FR,
IDCLS_SPECIFY_RS232_4_NAME_HU,
IDCLS_SPECIFY_RS232_4_NAME_IT,
IDCLS_SPECIFY_RS232_4_NAME_NL,
IDCLS_SPECIFY_RS232_4_NAME_PL,
IDCLS_SPECIFY_RS232_4_NAME_SV,
IDCLS_SPECIFY_RS232_4_NAME_TR,
#endif   /* HAVE_RS232 */

/* rs232drv/rsuser.c */
IDCLS_ENABLE_RS232_USERPORT,
IDCLS_ENABLE_RS232_USERPORT_DA,
IDCLS_ENABLE_RS232_USERPORT_DE,
IDCLS_ENABLE_RS232_USERPORT_FR,
IDCLS_ENABLE_RS232_USERPORT_HU,
IDCLS_ENABLE_RS232_USERPORT_IT,
IDCLS_ENABLE_RS232_USERPORT_NL,
IDCLS_ENABLE_RS232_USERPORT_PL,
IDCLS_ENABLE_RS232_USERPORT_SV,
IDCLS_ENABLE_RS232_USERPORT_TR,

/* rs232drv/rsuser.c */
IDCLS_DISABLE_RS232_USERPORT,
IDCLS_DISABLE_RS232_USERPORT_DA,
IDCLS_DISABLE_RS232_USERPORT_DE,
IDCLS_DISABLE_RS232_USERPORT_FR,
IDCLS_DISABLE_RS232_USERPORT_HU,
IDCLS_DISABLE_RS232_USERPORT_IT,
IDCLS_DISABLE_RS232_USERPORT_NL,
IDCLS_DISABLE_RS232_USERPORT_PL,
IDCLS_DISABLE_RS232_USERPORT_SV,
IDCLS_DISABLE_RS232_USERPORT_TR,

/* rs232drv/rsuser.c */
IDCLS_P_BAUD,
IDCLS_P_BAUD_DA,
IDCLS_P_BAUD_DE,
IDCLS_P_BAUD_FR,
IDCLS_P_BAUD_HU,
IDCLS_P_BAUD_IT,
IDCLS_P_BAUD_NL,
IDCLS_P_BAUD_PL,
IDCLS_P_BAUD_SV,
IDCLS_P_BAUD_TR,

/* rs232drv/rsuser.c */
IDCLS_SET_BAUD_RS232_USERPORT,
IDCLS_SET_BAUD_RS232_USERPORT_DA,
IDCLS_SET_BAUD_RS232_USERPORT_DE,
IDCLS_SET_BAUD_RS232_USERPORT_FR,
IDCLS_SET_BAUD_RS232_USERPORT_HU,
IDCLS_SET_BAUD_RS232_USERPORT_IT,
IDCLS_SET_BAUD_RS232_USERPORT_NL,
IDCLS_SET_BAUD_RS232_USERPORT_PL,
IDCLS_SET_BAUD_RS232_USERPORT_SV,
IDCLS_SET_BAUD_RS232_USERPORT_TR,

/* rs232drv/rsuser.c */
IDCLS_SPECIFY_RS232_DEVICE_USERPORT,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DA,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_DE,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_FR,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_HU,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_IT,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_NL,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_PL,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_SV,
IDCLS_SPECIFY_RS232_DEVICE_USERPORT_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_4,
IDCLS_ENABLE_IEC_4_DA,
IDCLS_ENABLE_IEC_4_DE,
IDCLS_ENABLE_IEC_4_FR,
IDCLS_ENABLE_IEC_4_HU,
IDCLS_ENABLE_IEC_4_IT,
IDCLS_ENABLE_IEC_4_NL,
IDCLS_ENABLE_IEC_4_PL,
IDCLS_ENABLE_IEC_4_SV,
IDCLS_ENABLE_IEC_4_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_4,
IDCLS_DISABLE_IEC_4_DA,
IDCLS_DISABLE_IEC_4_DE,
IDCLS_DISABLE_IEC_4_FR,
IDCLS_DISABLE_IEC_4_HU,
IDCLS_DISABLE_IEC_4_IT,
IDCLS_DISABLE_IEC_4_NL,
IDCLS_DISABLE_IEC_4_PL,
IDCLS_DISABLE_IEC_4_SV,
IDCLS_DISABLE_IEC_4_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_5,
IDCLS_ENABLE_IEC_5_DA,
IDCLS_ENABLE_IEC_5_DE,
IDCLS_ENABLE_IEC_5_FR,
IDCLS_ENABLE_IEC_5_HU,
IDCLS_ENABLE_IEC_5_IT,
IDCLS_ENABLE_IEC_5_NL,
IDCLS_ENABLE_IEC_5_PL,
IDCLS_ENABLE_IEC_5_SV,
IDCLS_ENABLE_IEC_5_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_5,
IDCLS_DISABLE_IEC_5_DA,
IDCLS_DISABLE_IEC_5_DE,
IDCLS_DISABLE_IEC_5_FR,
IDCLS_DISABLE_IEC_5_HU,
IDCLS_DISABLE_IEC_5_IT,
IDCLS_DISABLE_IEC_5_NL,
IDCLS_DISABLE_IEC_5_PL,
IDCLS_DISABLE_IEC_5_SV,
IDCLS_DISABLE_IEC_5_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_8,
IDCLS_ENABLE_IEC_8_DA,
IDCLS_ENABLE_IEC_8_DE,
IDCLS_ENABLE_IEC_8_FR,
IDCLS_ENABLE_IEC_8_HU,
IDCLS_ENABLE_IEC_8_IT,
IDCLS_ENABLE_IEC_8_NL,
IDCLS_ENABLE_IEC_8_PL,
IDCLS_ENABLE_IEC_8_SV,
IDCLS_ENABLE_IEC_8_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_8,
IDCLS_DISABLE_IEC_8_DA,
IDCLS_DISABLE_IEC_8_DE,
IDCLS_DISABLE_IEC_8_FR,
IDCLS_DISABLE_IEC_8_HU,
IDCLS_DISABLE_IEC_8_IT,
IDCLS_DISABLE_IEC_8_NL,
IDCLS_DISABLE_IEC_8_PL,
IDCLS_DISABLE_IEC_8_SV,
IDCLS_DISABLE_IEC_8_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_9,
IDCLS_ENABLE_IEC_9_DA,
IDCLS_ENABLE_IEC_9_DE,
IDCLS_ENABLE_IEC_9_FR,
IDCLS_ENABLE_IEC_9_HU,
IDCLS_ENABLE_IEC_9_IT,
IDCLS_ENABLE_IEC_9_NL,
IDCLS_ENABLE_IEC_9_PL,
IDCLS_ENABLE_IEC_9_SV,
IDCLS_ENABLE_IEC_9_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_9,
IDCLS_DISABLE_IEC_9_DA,
IDCLS_DISABLE_IEC_9_DE,
IDCLS_DISABLE_IEC_9_FR,
IDCLS_DISABLE_IEC_9_HU,
IDCLS_DISABLE_IEC_9_IT,
IDCLS_DISABLE_IEC_9_NL,
IDCLS_DISABLE_IEC_9_PL,
IDCLS_DISABLE_IEC_9_SV,
IDCLS_DISABLE_IEC_9_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_10,
IDCLS_ENABLE_IEC_10_DA,
IDCLS_ENABLE_IEC_10_DE,
IDCLS_ENABLE_IEC_10_FR,
IDCLS_ENABLE_IEC_10_HU,
IDCLS_ENABLE_IEC_10_IT,
IDCLS_ENABLE_IEC_10_NL,
IDCLS_ENABLE_IEC_10_PL,
IDCLS_ENABLE_IEC_10_SV,
IDCLS_ENABLE_IEC_10_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_10,
IDCLS_DISABLE_IEC_10_DA,
IDCLS_DISABLE_IEC_10_DE,
IDCLS_DISABLE_IEC_10_FR,
IDCLS_DISABLE_IEC_10_HU,
IDCLS_DISABLE_IEC_10_IT,
IDCLS_DISABLE_IEC_10_NL,
IDCLS_DISABLE_IEC_10_PL,
IDCLS_DISABLE_IEC_10_SV,
IDCLS_DISABLE_IEC_10_TR,

/* serial/serial-iec-device.c */
IDCLS_ENABLE_IEC_11,
IDCLS_ENABLE_IEC_11_DA,
IDCLS_ENABLE_IEC_11_DE,
IDCLS_ENABLE_IEC_11_FR,
IDCLS_ENABLE_IEC_11_HU,
IDCLS_ENABLE_IEC_11_IT,
IDCLS_ENABLE_IEC_11_NL,
IDCLS_ENABLE_IEC_11_PL,
IDCLS_ENABLE_IEC_11_SV,
IDCLS_ENABLE_IEC_11_TR,

/* serial/serial-iec-device.c */
IDCLS_DISABLE_IEC_11,
IDCLS_DISABLE_IEC_11_DA,
IDCLS_DISABLE_IEC_11_DE,
IDCLS_DISABLE_IEC_11_FR,
IDCLS_DISABLE_IEC_11_HU,
IDCLS_DISABLE_IEC_11_IT,
IDCLS_DISABLE_IEC_11_NL,
IDCLS_DISABLE_IEC_11_PL,
IDCLS_DISABLE_IEC_11_SV,
IDCLS_DISABLE_IEC_11_TR,

/* sid/sid-cmdline-options.c */
IDCLS_P_ENGINE_MODEL,
IDCLS_P_ENGINE_MODEL_DA,
IDCLS_P_ENGINE_MODEL_DE,
IDCLS_P_ENGINE_MODEL_FR,
IDCLS_P_ENGINE_MODEL_HU,
IDCLS_P_ENGINE_MODEL_IT,
IDCLS_P_ENGINE_MODEL_NL,
IDCLS_P_ENGINE_MODEL_PL,
IDCLS_P_ENGINE_MODEL_SV,
IDCLS_P_ENGINE_MODEL_TR,

/* sid/sid-cmdline-options.c */
IDCLS_FASTSID_ENGINE_MODEL,
IDCLS_FASTSID_ENGINE_MODEL_DA,
IDCLS_FASTSID_ENGINE_MODEL_DE,
IDCLS_FASTSID_ENGINE_MODEL_FR,
IDCLS_FASTSID_ENGINE_MODEL_HU,
IDCLS_FASTSID_ENGINE_MODEL_IT,
IDCLS_FASTSID_ENGINE_MODEL_NL,
IDCLS_FASTSID_ENGINE_MODEL_PL,
IDCLS_FASTSID_ENGINE_MODEL_SV,
IDCLS_FASTSID_ENGINE_MODEL_TR,

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
IDCLS_RESID_ENGINE_MODEL,
IDCLS_RESID_ENGINE_MODEL_DA,
IDCLS_RESID_ENGINE_MODEL_DE,
IDCLS_RESID_ENGINE_MODEL_FR,
IDCLS_RESID_ENGINE_MODEL_HU,
IDCLS_RESID_ENGINE_MODEL_IT,
IDCLS_RESID_ENGINE_MODEL_NL,
IDCLS_RESID_ENGINE_MODEL_PL,
IDCLS_RESID_ENGINE_MODEL_SV,
IDCLS_RESID_ENGINE_MODEL_TR,

/* sid/sid-cmdline-options.c */
IDCLS_RESIDDTV_ENGINE_MODEL,
IDCLS_RESIDDTV_ENGINE_MODEL_DA,
IDCLS_RESIDDTV_ENGINE_MODEL_DE,
IDCLS_RESIDDTV_ENGINE_MODEL_FR,
IDCLS_RESIDDTV_ENGINE_MODEL_HU,
IDCLS_RESIDDTV_ENGINE_MODEL_IT,
IDCLS_RESIDDTV_ENGINE_MODEL_NL,
IDCLS_RESIDDTV_ENGINE_MODEL_PL,
IDCLS_RESIDDTV_ENGINE_MODEL_SV,
IDCLS_RESIDDTV_ENGINE_MODEL_TR,
#endif

#ifdef HAVE_CATWEASELMKIII
/* sid/sid-cmdline-options.c */
IDCLS_CATWEASELMKIII_ENGINE_MODEL,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_DA,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_DE,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_FR,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_HU,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_IT,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_NL,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_PL,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_SV,
IDCLS_CATWEASELMKIII_ENGINE_MODEL_TR,
#endif

#ifdef HAVE_HARDSID
/* sid/sid-cmdline-options.c */
IDCLS_HARDSID_ENGINE_MODEL,
IDCLS_HARDSID_ENGINE_MODEL_DA,
IDCLS_HARDSID_ENGINE_MODEL_DE,
IDCLS_HARDSID_ENGINE_MODEL_FR,
IDCLS_HARDSID_ENGINE_MODEL_HU,
IDCLS_HARDSID_ENGINE_MODEL_IT,
IDCLS_HARDSID_ENGINE_MODEL_NL,
IDCLS_HARDSID_ENGINE_MODEL_PL,
IDCLS_HARDSID_ENGINE_MODEL_SV,
IDCLS_HARDSID_ENGINE_MODEL_TR,
#endif

#ifdef HAVE_PARSID
/* sid/sid-cmdline-options.c */
IDCLS_PARSID_ENGINE_MODEL,
IDCLS_PARSID_ENGINE_MODEL_DA,
IDCLS_PARSID_ENGINE_MODEL_DE,
IDCLS_PARSID_ENGINE_MODEL_FR,
IDCLS_PARSID_ENGINE_MODEL_HU,
IDCLS_PARSID_ENGINE_MODEL_IT,
IDCLS_PARSID_ENGINE_MODEL_NL,
IDCLS_PARSID_ENGINE_MODEL_PL,
IDCLS_PARSID_ENGINE_MODEL_SV,
IDCLS_PARSID_ENGINE_MODEL_TR,
#endif

#ifdef HAVE_RESID_FP
/* sid/sid-cmdline-options.c */
IDCLS_RESIDFP_ENGINE_MODEL,
IDCLS_RESIDFP_ENGINE_MODEL_DA,
IDCLS_RESIDFP_ENGINE_MODEL_DE,
IDCLS_RESIDFP_ENGINE_MODEL_FR,
IDCLS_RESIDFP_ENGINE_MODEL_HU,
IDCLS_RESIDFP_ENGINE_MODEL_IT,
IDCLS_RESIDFP_ENGINE_MODEL_NL,
IDCLS_RESIDFP_ENGINE_MODEL_PL,
IDCLS_RESIDFP_ENGINE_MODEL_SV,
IDCLS_RESIDFP_ENGINE_MODEL_TR,
#endif

/* sid/sid-cmdline-options.c */
IDCLS_ENABLE_SECOND_SID,
IDCLS_ENABLE_SECOND_SID_DA,
IDCLS_ENABLE_SECOND_SID_DE,
IDCLS_ENABLE_SECOND_SID_FR,
IDCLS_ENABLE_SECOND_SID_HU,
IDCLS_ENABLE_SECOND_SID_IT,
IDCLS_ENABLE_SECOND_SID_NL,
IDCLS_ENABLE_SECOND_SID_PL,
IDCLS_ENABLE_SECOND_SID_SV,
IDCLS_ENABLE_SECOND_SID_TR,

/* sid/sid-cmdline-options.c */
IDCLS_ENABLE_SIDCART,
IDCLS_ENABLE_SIDCART_DA,
IDCLS_ENABLE_SIDCART_DE,
IDCLS_ENABLE_SIDCART_FR,
IDCLS_ENABLE_SIDCART_HU,
IDCLS_ENABLE_SIDCART_IT,
IDCLS_ENABLE_SIDCART_NL,
IDCLS_ENABLE_SIDCART_PL,
IDCLS_ENABLE_SIDCART_SV,
IDCLS_ENABLE_SIDCART_TR,

/* sid/sid-cmdline-options.c */
IDCLS_DISABLE_SIDCART,
IDCLS_DISABLE_SIDCART_DA,
IDCLS_DISABLE_SIDCART_DE,
IDCLS_DISABLE_SIDCART_FR,
IDCLS_DISABLE_SIDCART_HU,
IDCLS_DISABLE_SIDCART_IT,
IDCLS_DISABLE_SIDCART_NL,
IDCLS_DISABLE_SIDCART_PL,
IDCLS_DISABLE_SIDCART_SV,
IDCLS_DISABLE_SIDCART_TR,

/* sid/sid-cmdline-options.c, c64/plus60k.c, c64/c64_256k.c c64/cart/digimax.c */
IDCLS_P_BASE_ADDRESS,
IDCLS_P_BASE_ADDRESS_DA,
IDCLS_P_BASE_ADDRESS_DE,
IDCLS_P_BASE_ADDRESS_FR,
IDCLS_P_BASE_ADDRESS_HU,
IDCLS_P_BASE_ADDRESS_IT,
IDCLS_P_BASE_ADDRESS_NL,
IDCLS_P_BASE_ADDRESS_PL,
IDCLS_P_BASE_ADDRESS_SV,
IDCLS_P_BASE_ADDRESS_TR,

/* sid/sid-cmdline-options.c */
IDCLS_SPECIFY_SID_2_ADDRESS,
IDCLS_SPECIFY_SID_2_ADDRESS_DA,
IDCLS_SPECIFY_SID_2_ADDRESS_DE,
IDCLS_SPECIFY_SID_2_ADDRESS_FR,
IDCLS_SPECIFY_SID_2_ADDRESS_HU,
IDCLS_SPECIFY_SID_2_ADDRESS_IT,
IDCLS_SPECIFY_SID_2_ADDRESS_NL,
IDCLS_SPECIFY_SID_2_ADDRESS_PL,
IDCLS_SPECIFY_SID_2_ADDRESS_SV,
IDCLS_SPECIFY_SID_2_ADDRESS_TR,

/* sid/sid-cmdline-options.c */
IDCLS_ENABLE_SID_FILTERS,
IDCLS_ENABLE_SID_FILTERS_DA,
IDCLS_ENABLE_SID_FILTERS_DE,
IDCLS_ENABLE_SID_FILTERS_FR,
IDCLS_ENABLE_SID_FILTERS_HU,
IDCLS_ENABLE_SID_FILTERS_IT,
IDCLS_ENABLE_SID_FILTERS_NL,
IDCLS_ENABLE_SID_FILTERS_PL,
IDCLS_ENABLE_SID_FILTERS_SV,
IDCLS_ENABLE_SID_FILTERS_TR,

/* sid/sid-cmdline-options.c */
IDCLS_DISABLE_SID_FILTERS,
IDCLS_DISABLE_SID_FILTERS_DA,
IDCLS_DISABLE_SID_FILTERS_DE,
IDCLS_DISABLE_SID_FILTERS_FR,
IDCLS_DISABLE_SID_FILTERS_HU,
IDCLS_DISABLE_SID_FILTERS_IT,
IDCLS_DISABLE_SID_FILTERS_NL,
IDCLS_DISABLE_SID_FILTERS_PL,
IDCLS_DISABLE_SID_FILTERS_SV,
IDCLS_DISABLE_SID_FILTERS_TR,

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
IDCLS_RESID_SAMPLING_METHOD,
IDCLS_RESID_SAMPLING_METHOD_DA,
IDCLS_RESID_SAMPLING_METHOD_DE,
IDCLS_RESID_SAMPLING_METHOD_FR,
IDCLS_RESID_SAMPLING_METHOD_HU,
IDCLS_RESID_SAMPLING_METHOD_IT,
IDCLS_RESID_SAMPLING_METHOD_NL,
IDCLS_RESID_SAMPLING_METHOD_PL,
IDCLS_RESID_SAMPLING_METHOD_SV,
IDCLS_RESID_SAMPLING_METHOD_TR,
#endif   /* HAVE_RESID */

/* sid/sid-cmdline-options.c, vsync.c */
IDCLS_P_PERCENT,
IDCLS_P_PERCENT_DA,
IDCLS_P_PERCENT_DE,
IDCLS_P_PERCENT_FR,
IDCLS_P_PERCENT_HU,
IDCLS_P_PERCENT_IT,
IDCLS_P_PERCENT_NL,
IDCLS_P_PERCENT_PL,
IDCLS_P_PERCENT_SV,
IDCLS_P_PERCENT_TR,

#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
IDCLS_PASSBAND_PERCENTAGE,
IDCLS_PASSBAND_PERCENTAGE_DA,
IDCLS_PASSBAND_PERCENTAGE_DE,
IDCLS_PASSBAND_PERCENTAGE_FR,
IDCLS_PASSBAND_PERCENTAGE_HU,
IDCLS_PASSBAND_PERCENTAGE_IT,
IDCLS_PASSBAND_PERCENTAGE_NL,
IDCLS_PASSBAND_PERCENTAGE_PL,
IDCLS_PASSBAND_PERCENTAGE_SV,
IDCLS_PASSBAND_PERCENTAGE_TR,
#endif   /* HAVE_RESID */

/* vdc/vdc-cmdline-options.c */
IDCLS_SET_VDC_MEMORY_16KB,
IDCLS_SET_VDC_MEMORY_16KB_DA,
IDCLS_SET_VDC_MEMORY_16KB_DE,
IDCLS_SET_VDC_MEMORY_16KB_FR,
IDCLS_SET_VDC_MEMORY_16KB_HU,
IDCLS_SET_VDC_MEMORY_16KB_IT,
IDCLS_SET_VDC_MEMORY_16KB_NL,
IDCLS_SET_VDC_MEMORY_16KB_PL,
IDCLS_SET_VDC_MEMORY_16KB_SV,
IDCLS_SET_VDC_MEMORY_16KB_TR,

/* vdc/vdc-cmdline-options.c */
IDCLS_SET_VDC_MEMORY_64KB,
IDCLS_SET_VDC_MEMORY_64KB_DA,
IDCLS_SET_VDC_MEMORY_64KB_DE,
IDCLS_SET_VDC_MEMORY_64KB_FR,
IDCLS_SET_VDC_MEMORY_64KB_HU,
IDCLS_SET_VDC_MEMORY_64KB_IT,
IDCLS_SET_VDC_MEMORY_64KB_NL,
IDCLS_SET_VDC_MEMORY_64KB_PL,
IDCLS_SET_VDC_MEMORY_64KB_SV,
IDCLS_SET_VDC_MEMORY_64KB_TR,

/* vdc/vdc-cmdline-options.c */
IDCLS_SET_VDC_REVISION,
IDCLS_SET_VDC_REVISION_DA,
IDCLS_SET_VDC_REVISION_DE,
IDCLS_SET_VDC_REVISION_FR,
IDCLS_SET_VDC_REVISION_HU,
IDCLS_SET_VDC_REVISION_IT,
IDCLS_SET_VDC_REVISION_NL,
IDCLS_SET_VDC_REVISION_PL,
IDCLS_SET_VDC_REVISION_SV,
IDCLS_SET_VDC_REVISION_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_P_SPEC,
IDCLS_P_SPEC_DA,
IDCLS_P_SPEC_DE,
IDCLS_P_SPEC_FR,
IDCLS_P_SPEC_HU,
IDCLS_P_SPEC_IT,
IDCLS_P_SPEC_NL,
IDCLS_P_SPEC_PL,
IDCLS_P_SPEC_SV,
IDCLS_P_SPEC_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_SPECIFY_MEMORY_CONFIG,
IDCLS_SPECIFY_MEMORY_CONFIG_DA,
IDCLS_SPECIFY_MEMORY_CONFIG_DE,
IDCLS_SPECIFY_MEMORY_CONFIG_FR,
IDCLS_SPECIFY_MEMORY_CONFIG_HU,
IDCLS_SPECIFY_MEMORY_CONFIG_IT,
IDCLS_SPECIFY_MEMORY_CONFIG_NL,
IDCLS_SPECIFY_MEMORY_CONFIG_PL,
IDCLS_SPECIFY_MEMORY_CONFIG_SV,
IDCLS_SPECIFY_MEMORY_CONFIG_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_ENABLE_VIC1112_IEEE488,
IDCLS_ENABLE_VIC1112_IEEE488_DA,
IDCLS_ENABLE_VIC1112_IEEE488_DE,
IDCLS_ENABLE_VIC1112_IEEE488_FR,
IDCLS_ENABLE_VIC1112_IEEE488_HU,
IDCLS_ENABLE_VIC1112_IEEE488_IT,
IDCLS_ENABLE_VIC1112_IEEE488_NL,
IDCLS_ENABLE_VIC1112_IEEE488_PL,
IDCLS_ENABLE_VIC1112_IEEE488_SV,
IDCLS_ENABLE_VIC1112_IEEE488_TR,

/* vic20/vic20-cmdline-options.c */
IDCLS_DISABLE_VIC1112_IEEE488,
IDCLS_DISABLE_VIC1112_IEEE488_DA,
IDCLS_DISABLE_VIC1112_IEEE488_DE,
IDCLS_DISABLE_VIC1112_IEEE488_FR,
IDCLS_DISABLE_VIC1112_IEEE488_HU,
IDCLS_DISABLE_VIC1112_IEEE488_IT,
IDCLS_DISABLE_VIC1112_IEEE488_NL,
IDCLS_DISABLE_VIC1112_IEEE488_PL,
IDCLS_DISABLE_VIC1112_IEEE488_SV,
IDCLS_DISABLE_VIC1112_IEEE488_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_EXT_ROM_2000_NAME,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_DA,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_DE,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_FR,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_HU,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_IT,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_NL,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_PL,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_SV,
IDCLS_SPECIFY_EXT_ROM_2000_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_EXT_ROM_4000_NAME,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_DA,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_DE,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_FR,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_HU,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_IT,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_NL,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_PL,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_SV,
IDCLS_SPECIFY_EXT_ROM_4000_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_EXT_ROM_6000_NAME,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_DA,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_DE,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_FR,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_HU,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_IT,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_NL,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_PL,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_SV,
IDCLS_SPECIFY_EXT_ROM_6000_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_EXT_ROM_A000_NAME,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_DA,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_DE,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_FR,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_HU,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_IT,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_NL,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_PL,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_SV,
IDCLS_SPECIFY_EXT_ROM_A000_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_EXT_ROM_B000_NAME,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_DA,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_DE,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_FR,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_HU,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_IT,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_NL,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_PL,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_SV,
IDCLS_SPECIFY_EXT_ROM_B000_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_GENERIC_ROM_NAME,
IDCLS_SPECIFY_GENERIC_ROM_NAME_DA,
IDCLS_SPECIFY_GENERIC_ROM_NAME_DE,
IDCLS_SPECIFY_GENERIC_ROM_NAME_FR,
IDCLS_SPECIFY_GENERIC_ROM_NAME_HU,
IDCLS_SPECIFY_GENERIC_ROM_NAME_IT,
IDCLS_SPECIFY_GENERIC_ROM_NAME_NL,
IDCLS_SPECIFY_GENERIC_ROM_NAME_PL,
IDCLS_SPECIFY_GENERIC_ROM_NAME_SV,
IDCLS_SPECIFY_GENERIC_ROM_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_MEGA_CART_ROM_NAME,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_DA,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_DE,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_FR,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_HU,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_IT,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_NL,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_PL,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_SV,
IDCLS_SPECIFY_MEGA_CART_ROM_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_DA,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_DE,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_FR,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_HU,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_IT,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_NL,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_PL,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_SV,
IDCLS_SPECIFY_FINAL_EXPANSION_ROM_NAME_TR,

/* vic20/cart/vic20cart.c */
IDCLS_SPECIFY_VIC_FP_ROM_NAME,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_DA,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_DE,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_FR,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_HU,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_IT,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_NL,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_PL,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_SV,
IDCLS_SPECIFY_VIC_FP_ROM_NAME_TR,

/* vic20/cart/finalexpansion.c */
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_DA,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_DE,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_FR,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_HU,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_IT,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_NL,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_PL,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_SV,
IDCLS_ENABLE_FINALEXPANSION_WRITEBACK_TR,

/* vic20/cart/finalexpansion.c */
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_DA,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_DE,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_FR,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_HU,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_IT,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_NL,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_PL,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_SV,
IDCLS_DISABLE_FINALEXPANSION_WRITEBACK_TR,

/* vic20/cart/megacart.c */
IDCLS_SET_MEGACART_NVRAM_NAME,
IDCLS_SET_MEGACART_NVRAM_NAME_DA,
IDCLS_SET_MEGACART_NVRAM_NAME_DE,
IDCLS_SET_MEGACART_NVRAM_NAME_FR,
IDCLS_SET_MEGACART_NVRAM_NAME_HU,
IDCLS_SET_MEGACART_NVRAM_NAME_IT,
IDCLS_SET_MEGACART_NVRAM_NAME_NL,
IDCLS_SET_MEGACART_NVRAM_NAME_PL,
IDCLS_SET_MEGACART_NVRAM_NAME_SV,
IDCLS_SET_MEGACART_NVRAM_NAME_TR,

/* vic20/cart/megacart.c */
IDCLS_ENABLE_MEGACART_NVRAM_WRITE,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_DA,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_DE,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_FR,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_HU,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_IT,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_NL,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_PL,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_SV,
IDCLS_ENABLE_MEGACART_NVRAM_WRITE_TR,

/* vic20/cart/megacart.c */
IDCLS_DISABLE_MEGACART_NVRAM_WRITE,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_DA,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_DE,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_FR,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_HU,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_IT,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_NL,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_PL,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_SV,
IDCLS_DISABLE_MEGACART_NVRAM_WRITE_TR,

/* vic20/cart/vic-fp.c */
IDCLS_ENABLE_VICFP_ROM_WRITE,
IDCLS_ENABLE_VICFP_ROM_WRITE_DA,
IDCLS_ENABLE_VICFP_ROM_WRITE_DE,
IDCLS_ENABLE_VICFP_ROM_WRITE_FR,
IDCLS_ENABLE_VICFP_ROM_WRITE_HU,
IDCLS_ENABLE_VICFP_ROM_WRITE_IT,
IDCLS_ENABLE_VICFP_ROM_WRITE_NL,
IDCLS_ENABLE_VICFP_ROM_WRITE_PL,
IDCLS_ENABLE_VICFP_ROM_WRITE_SV,
IDCLS_ENABLE_VICFP_ROM_WRITE_TR,

/* vic20/cart/vic-fp.c */
IDCLS_DISABLE_VICFP_ROM_WRITE,
IDCLS_DISABLE_VICFP_ROM_WRITE_DA,
IDCLS_DISABLE_VICFP_ROM_WRITE_DE,
IDCLS_DISABLE_VICFP_ROM_WRITE_FR,
IDCLS_DISABLE_VICFP_ROM_WRITE_HU,
IDCLS_DISABLE_VICFP_ROM_WRITE_IT,
IDCLS_DISABLE_VICFP_ROM_WRITE_NL,
IDCLS_DISABLE_VICFP_ROM_WRITE_PL,
IDCLS_DISABLE_VICFP_ROM_WRITE_SV,
IDCLS_DISABLE_VICFP_ROM_WRITE_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_SET_BORDER_MODE,
IDCLS_SET_BORDER_MODE_DA,
IDCLS_SET_BORDER_MODE_DE,
IDCLS_SET_BORDER_MODE_FR,
IDCLS_SET_BORDER_MODE_HU,
IDCLS_SET_BORDER_MODE_IT,
IDCLS_SET_BORDER_MODE_NL,
IDCLS_SET_BORDER_MODE_PL,
IDCLS_SET_BORDER_MODE_SV,
IDCLS_SET_BORDER_MODE_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_ENABLE_SPRITE_BACKGROUND,
IDCLS_ENABLE_SPRITE_BACKGROUND_DA,
IDCLS_ENABLE_SPRITE_BACKGROUND_DE,
IDCLS_ENABLE_SPRITE_BACKGROUND_FR,
IDCLS_ENABLE_SPRITE_BACKGROUND_HU,
IDCLS_ENABLE_SPRITE_BACKGROUND_IT,
IDCLS_ENABLE_SPRITE_BACKGROUND_NL,
IDCLS_ENABLE_SPRITE_BACKGROUND_PL,
IDCLS_ENABLE_SPRITE_BACKGROUND_SV,
IDCLS_ENABLE_SPRITE_BACKGROUND_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_DISABLE_SPRITE_BACKGROUND,
IDCLS_DISABLE_SPRITE_BACKGROUND_DA,
IDCLS_DISABLE_SPRITE_BACKGROUND_DE,
IDCLS_DISABLE_SPRITE_BACKGROUND_FR,
IDCLS_DISABLE_SPRITE_BACKGROUND_HU,
IDCLS_DISABLE_SPRITE_BACKGROUND_IT,
IDCLS_DISABLE_SPRITE_BACKGROUND_NL,
IDCLS_DISABLE_SPRITE_BACKGROUND_PL,
IDCLS_DISABLE_SPRITE_BACKGROUND_SV,
IDCLS_DISABLE_SPRITE_BACKGROUND_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_ENABLE_SPRITE_SPRITE,
IDCLS_ENABLE_SPRITE_SPRITE_DA,
IDCLS_ENABLE_SPRITE_SPRITE_DE,
IDCLS_ENABLE_SPRITE_SPRITE_FR,
IDCLS_ENABLE_SPRITE_SPRITE_HU,
IDCLS_ENABLE_SPRITE_SPRITE_IT,
IDCLS_ENABLE_SPRITE_SPRITE_NL,
IDCLS_ENABLE_SPRITE_SPRITE_PL,
IDCLS_ENABLE_SPRITE_SPRITE_SV,
IDCLS_ENABLE_SPRITE_SPRITE_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_DISABLE_SPRITE_SPRITE,
IDCLS_DISABLE_SPRITE_SPRITE_DA,
IDCLS_DISABLE_SPRITE_SPRITE_DE,
IDCLS_DISABLE_SPRITE_SPRITE_FR,
IDCLS_DISABLE_SPRITE_SPRITE_HU,
IDCLS_DISABLE_SPRITE_SPRITE_IT,
IDCLS_DISABLE_SPRITE_SPRITE_NL,
IDCLS_DISABLE_SPRITE_SPRITE_PL,
IDCLS_DISABLE_SPRITE_SPRITE_SV,
IDCLS_DISABLE_SPRITE_SPRITE_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_USE_NEW_LUMINANCES,
IDCLS_USE_NEW_LUMINANCES_DA,
IDCLS_USE_NEW_LUMINANCES_DE,
IDCLS_USE_NEW_LUMINANCES_FR,
IDCLS_USE_NEW_LUMINANCES_HU,
IDCLS_USE_NEW_LUMINANCES_IT,
IDCLS_USE_NEW_LUMINANCES_NL,
IDCLS_USE_NEW_LUMINANCES_PL,
IDCLS_USE_NEW_LUMINANCES_SV,
IDCLS_USE_NEW_LUMINANCES_TR,

/* vicii/vicii-cmdline-options.c */
IDCLS_USE_OLD_LUMINANCES,
IDCLS_USE_OLD_LUMINANCES_DA,
IDCLS_USE_OLD_LUMINANCES_DE,
IDCLS_USE_OLD_LUMINANCES_FR,
IDCLS_USE_OLD_LUMINANCES_HU,
IDCLS_USE_OLD_LUMINANCES_IT,
IDCLS_USE_OLD_LUMINANCES_NL,
IDCLS_USE_OLD_LUMINANCES_PL,
IDCLS_USE_OLD_LUMINANCES_SV,
IDCLS_USE_OLD_LUMINANCES_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_DOUBLE_SIZE,
IDCLS_ENABLE_DOUBLE_SIZE_DA,
IDCLS_ENABLE_DOUBLE_SIZE_DE,
IDCLS_ENABLE_DOUBLE_SIZE_FR,
IDCLS_ENABLE_DOUBLE_SIZE_HU,
IDCLS_ENABLE_DOUBLE_SIZE_IT,
IDCLS_ENABLE_DOUBLE_SIZE_NL,
IDCLS_ENABLE_DOUBLE_SIZE_PL,
IDCLS_ENABLE_DOUBLE_SIZE_SV,
IDCLS_ENABLE_DOUBLE_SIZE_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_DOUBLE_SIZE,
IDCLS_DISABLE_DOUBLE_SIZE_DA,
IDCLS_DISABLE_DOUBLE_SIZE_DE,
IDCLS_DISABLE_DOUBLE_SIZE_FR,
IDCLS_DISABLE_DOUBLE_SIZE_HU,
IDCLS_DISABLE_DOUBLE_SIZE_IT,
IDCLS_DISABLE_DOUBLE_SIZE_NL,
IDCLS_DISABLE_DOUBLE_SIZE_PL,
IDCLS_DISABLE_DOUBLE_SIZE_SV,
IDCLS_DISABLE_DOUBLE_SIZE_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_DOUBLE_SCAN,
IDCLS_ENABLE_DOUBLE_SCAN_DA,
IDCLS_ENABLE_DOUBLE_SCAN_DE,
IDCLS_ENABLE_DOUBLE_SCAN_FR,
IDCLS_ENABLE_DOUBLE_SCAN_HU,
IDCLS_ENABLE_DOUBLE_SCAN_IT,
IDCLS_ENABLE_DOUBLE_SCAN_NL,
IDCLS_ENABLE_DOUBLE_SCAN_PL,
IDCLS_ENABLE_DOUBLE_SCAN_SV,
IDCLS_ENABLE_DOUBLE_SCAN_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_DOUBLE_SCAN,
IDCLS_DISABLE_DOUBLE_SCAN_DA,
IDCLS_DISABLE_DOUBLE_SCAN_DE,
IDCLS_DISABLE_DOUBLE_SCAN_FR,
IDCLS_DISABLE_DOUBLE_SCAN_HU,
IDCLS_DISABLE_DOUBLE_SCAN_IT,
IDCLS_DISABLE_DOUBLE_SCAN_NL,
IDCLS_DISABLE_DOUBLE_SCAN_PL,
IDCLS_DISABLE_DOUBLE_SCAN_SV,
IDCLS_DISABLE_DOUBLE_SCAN_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_HARDWARE_SCALING,
IDCLS_ENABLE_HARDWARE_SCALING_DA,
IDCLS_ENABLE_HARDWARE_SCALING_DE,
IDCLS_ENABLE_HARDWARE_SCALING_FR,
IDCLS_ENABLE_HARDWARE_SCALING_HU,
IDCLS_ENABLE_HARDWARE_SCALING_IT,
IDCLS_ENABLE_HARDWARE_SCALING_NL,
IDCLS_ENABLE_HARDWARE_SCALING_PL,
IDCLS_ENABLE_HARDWARE_SCALING_SV,
IDCLS_ENABLE_HARDWARE_SCALING_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_HARDWARE_SCALING,
IDCLS_DISABLE_HARDWARE_SCALING_DA,
IDCLS_DISABLE_HARDWARE_SCALING_DE,
IDCLS_DISABLE_HARDWARE_SCALING_FR,
IDCLS_DISABLE_HARDWARE_SCALING_HU,
IDCLS_DISABLE_HARDWARE_SCALING_IT,
IDCLS_DISABLE_HARDWARE_SCALING_NL,
IDCLS_DISABLE_HARDWARE_SCALING_PL,
IDCLS_DISABLE_HARDWARE_SCALING_SV,
IDCLS_DISABLE_HARDWARE_SCALING_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_SCALE2X,
IDCLS_ENABLE_SCALE2X_DA,
IDCLS_ENABLE_SCALE2X_DE,
IDCLS_ENABLE_SCALE2X_FR,
IDCLS_ENABLE_SCALE2X_HU,
IDCLS_ENABLE_SCALE2X_IT,
IDCLS_ENABLE_SCALE2X_NL,
IDCLS_ENABLE_SCALE2X_PL,
IDCLS_ENABLE_SCALE2X_SV,
IDCLS_ENABLE_SCALE2X_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_SCALE2X,
IDCLS_DISABLE_SCALE2X_DA,
IDCLS_DISABLE_SCALE2X_DE,
IDCLS_DISABLE_SCALE2X_FR,
IDCLS_DISABLE_SCALE2X_HU,
IDCLS_DISABLE_SCALE2X_IT,
IDCLS_DISABLE_SCALE2X_NL,
IDCLS_DISABLE_SCALE2X_PL,
IDCLS_DISABLE_SCALE2X_SV,
IDCLS_DISABLE_SCALE2X_TR,

/* video/video-cmdline-options.c */
IDCLS_USE_INTERNAL_CALC_PALETTE,
IDCLS_USE_INTERNAL_CALC_PALETTE_DA,
IDCLS_USE_INTERNAL_CALC_PALETTE_DE,
IDCLS_USE_INTERNAL_CALC_PALETTE_FR,
IDCLS_USE_INTERNAL_CALC_PALETTE_HU,
IDCLS_USE_INTERNAL_CALC_PALETTE_IT,
IDCLS_USE_INTERNAL_CALC_PALETTE_NL,
IDCLS_USE_INTERNAL_CALC_PALETTE_PL,
IDCLS_USE_INTERNAL_CALC_PALETTE_SV,
IDCLS_USE_INTERNAL_CALC_PALETTE_TR,

/* video/video-cmdline-options.c */
IDCLS_USE_EXTERNAL_FILE_PALETTE,
IDCLS_USE_EXTERNAL_FILE_PALETTE_DA,
IDCLS_USE_EXTERNAL_FILE_PALETTE_DE,
IDCLS_USE_EXTERNAL_FILE_PALETTE_FR,
IDCLS_USE_EXTERNAL_FILE_PALETTE_HU,
IDCLS_USE_EXTERNAL_FILE_PALETTE_IT,
IDCLS_USE_EXTERNAL_FILE_PALETTE_NL,
IDCLS_USE_EXTERNAL_FILE_PALETTE_PL,
IDCLS_USE_EXTERNAL_FILE_PALETTE_SV,
IDCLS_USE_EXTERNAL_FILE_PALETTE_TR,

/* video/video-cmdline-options.c */
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_DA,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_DE,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_FR,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_HU,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_IT,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_NL,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_PL,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_SV,
IDCLS_SPECIFY_EXTERNAL_PALETTE_NAME_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_FULLSCREEN_MODE,
IDCLS_ENABLE_FULLSCREEN_MODE_DA,
IDCLS_ENABLE_FULLSCREEN_MODE_DE,
IDCLS_ENABLE_FULLSCREEN_MODE_FR,
IDCLS_ENABLE_FULLSCREEN_MODE_HU,
IDCLS_ENABLE_FULLSCREEN_MODE_IT,
IDCLS_ENABLE_FULLSCREEN_MODE_NL,
IDCLS_ENABLE_FULLSCREEN_MODE_PL,
IDCLS_ENABLE_FULLSCREEN_MODE_SV,
IDCLS_ENABLE_FULLSCREEN_MODE_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_FULLSCREEN_MODE,
IDCLS_DISABLE_FULLSCREEN_MODE_DA,
IDCLS_DISABLE_FULLSCREEN_MODE_DE,
IDCLS_DISABLE_FULLSCREEN_MODE_FR,
IDCLS_DISABLE_FULLSCREEN_MODE_HU,
IDCLS_DISABLE_FULLSCREEN_MODE_IT,
IDCLS_DISABLE_FULLSCREEN_MODE_NL,
IDCLS_DISABLE_FULLSCREEN_MODE_PL,
IDCLS_DISABLE_FULLSCREEN_MODE_SV,
IDCLS_DISABLE_FULLSCREEN_MODE_TR,

/* video/video-cmdline-options.c */
IDCLS_P_DEVICE,
IDCLS_P_DEVICE_DA,
IDCLS_P_DEVICE_DE,
IDCLS_P_DEVICE_FR,
IDCLS_P_DEVICE_HU,
IDCLS_P_DEVICE_IT,
IDCLS_P_DEVICE_NL,
IDCLS_P_DEVICE_PL,
IDCLS_P_DEVICE_SV,
IDCLS_P_DEVICE_TR,

/* video/video-cmdline-options.c */
IDCLS_SELECT_FULLSCREEN_DEVICE,
IDCLS_SELECT_FULLSCREEN_DEVICE_DA,
IDCLS_SELECT_FULLSCREEN_DEVICE_DE,
IDCLS_SELECT_FULLSCREEN_DEVICE_FR,
IDCLS_SELECT_FULLSCREEN_DEVICE_HU,
IDCLS_SELECT_FULLSCREEN_DEVICE_IT,
IDCLS_SELECT_FULLSCREEN_DEVICE_NL,
IDCLS_SELECT_FULLSCREEN_DEVICE_PL,
IDCLS_SELECT_FULLSCREEN_DEVICE_SV,
IDCLS_SELECT_FULLSCREEN_DEVICE_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_DA,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_DE,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_FR,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_HU,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_IT,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_NL,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_PL,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_SV,
IDCLS_ENABLE_DOUBLE_SIZE_FULLSCREEN_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_DA,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_DE,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_FR,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_HU,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_IT,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_NL,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_PL,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_SV,
IDCLS_DISABLE_DOUBLE_SIZE_FULLSCREEN_TR,

/* video/video-cmdline-options.c */
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_DA,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_DE,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_FR,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_HU,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_IT,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_NL,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_PL,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_SV,
IDCLS_ENABLE_DOUBLE_SCAN_FULLSCREEN_TR,

/* video/video-cmdline-options.c */
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_DA,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_DE,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_FR,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_HU,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_IT,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_NL,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_PL,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_SV,
IDCLS_DISABLE_DOUBLE_SCAN_FULLSCREEN_TR,

/* video/video-cmdline-options.c */
IDCLS_P_MODE,
IDCLS_P_MODE_DA,
IDCLS_P_MODE_DE,
IDCLS_P_MODE_FR,
IDCLS_P_MODE_HU,
IDCLS_P_MODE_IT,
IDCLS_P_MODE_NL,
IDCLS_P_MODE_PL,
IDCLS_P_MODE_SV,
IDCLS_P_MODE_TR,

/* video/video-cmdline-options.c */
IDCLS_SELECT_FULLSCREEN_MODE,
IDCLS_SELECT_FULLSCREEN_MODE_DA,
IDCLS_SELECT_FULLSCREEN_MODE_DE,
IDCLS_SELECT_FULLSCREEN_MODE_FR,
IDCLS_SELECT_FULLSCREEN_MODE_HU,
IDCLS_SELECT_FULLSCREEN_MODE_IT,
IDCLS_SELECT_FULLSCREEN_MODE_NL,
IDCLS_SELECT_FULLSCREEN_MODE_PL,
IDCLS_SELECT_FULLSCREEN_MODE_SV,
IDCLS_SELECT_FULLSCREEN_MODE_TR,

/* aciacore.c */
IDCLS_SPECIFY_ACIA_RS232_DEVICE,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_DA,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_DE,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_FR,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_HU,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_IT,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_NL,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_PL,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_SV,
IDCLS_SPECIFY_ACIA_RS232_DEVICE_TR,

/* attach.c */
IDCLS_SET_DEVICE_TYPE_8,
IDCLS_SET_DEVICE_TYPE_8_DA,
IDCLS_SET_DEVICE_TYPE_8_DE,
IDCLS_SET_DEVICE_TYPE_8_FR,
IDCLS_SET_DEVICE_TYPE_8_HU,
IDCLS_SET_DEVICE_TYPE_8_IT,
IDCLS_SET_DEVICE_TYPE_8_NL,
IDCLS_SET_DEVICE_TYPE_8_PL,
IDCLS_SET_DEVICE_TYPE_8_SV,
IDCLS_SET_DEVICE_TYPE_8_TR,

/* attach.c */
IDCLS_SET_DEVICE_TYPE_9,
IDCLS_SET_DEVICE_TYPE_9_DA,
IDCLS_SET_DEVICE_TYPE_9_DE,
IDCLS_SET_DEVICE_TYPE_9_FR,
IDCLS_SET_DEVICE_TYPE_9_HU,
IDCLS_SET_DEVICE_TYPE_9_IT,
IDCLS_SET_DEVICE_TYPE_9_NL,
IDCLS_SET_DEVICE_TYPE_9_PL,
IDCLS_SET_DEVICE_TYPE_9_SV,
IDCLS_SET_DEVICE_TYPE_9_TR,

/* attach.c */
IDCLS_SET_DEVICE_TYPE_10,
IDCLS_SET_DEVICE_TYPE_10_DA,
IDCLS_SET_DEVICE_TYPE_10_DE,
IDCLS_SET_DEVICE_TYPE_10_FR,
IDCLS_SET_DEVICE_TYPE_10_HU,
IDCLS_SET_DEVICE_TYPE_10_IT,
IDCLS_SET_DEVICE_TYPE_10_NL,
IDCLS_SET_DEVICE_TYPE_10_PL,
IDCLS_SET_DEVICE_TYPE_10_SV,
IDCLS_SET_DEVICE_TYPE_10_TR,

/* attach.c */
IDCLS_SET_DEVICE_TYPE_11,
IDCLS_SET_DEVICE_TYPE_11_DA,
IDCLS_SET_DEVICE_TYPE_11_DE,
IDCLS_SET_DEVICE_TYPE_11_FR,
IDCLS_SET_DEVICE_TYPE_11_HU,
IDCLS_SET_DEVICE_TYPE_11_IT,
IDCLS_SET_DEVICE_TYPE_11_NL,
IDCLS_SET_DEVICE_TYPE_11_PL,
IDCLS_SET_DEVICE_TYPE_11_SV,
IDCLS_SET_DEVICE_TYPE_11_TR,

/* attach.c */
IDCLS_ATTACH_READ_ONLY_8,
IDCLS_ATTACH_READ_ONLY_8_DA,
IDCLS_ATTACH_READ_ONLY_8_DE,
IDCLS_ATTACH_READ_ONLY_8_FR,
IDCLS_ATTACH_READ_ONLY_8_HU,
IDCLS_ATTACH_READ_ONLY_8_IT,
IDCLS_ATTACH_READ_ONLY_8_NL,
IDCLS_ATTACH_READ_ONLY_8_PL,
IDCLS_ATTACH_READ_ONLY_8_SV,
IDCLS_ATTACH_READ_ONLY_8_TR,

/* attach.c */
IDCLS_ATTACH_READ_WRITE_8,
IDCLS_ATTACH_READ_WRITE_8_DA,
IDCLS_ATTACH_READ_WRITE_8_DE,
IDCLS_ATTACH_READ_WRITE_8_FR,
IDCLS_ATTACH_READ_WRITE_8_HU,
IDCLS_ATTACH_READ_WRITE_8_IT,
IDCLS_ATTACH_READ_WRITE_8_NL,
IDCLS_ATTACH_READ_WRITE_8_PL,
IDCLS_ATTACH_READ_WRITE_8_SV,
IDCLS_ATTACH_READ_WRITE_8_TR,

/* attach.c */
IDCLS_ATTACH_READ_ONLY_9,
IDCLS_ATTACH_READ_ONLY_9_DA,
IDCLS_ATTACH_READ_ONLY_9_DE,
IDCLS_ATTACH_READ_ONLY_9_FR,
IDCLS_ATTACH_READ_ONLY_9_HU,
IDCLS_ATTACH_READ_ONLY_9_IT,
IDCLS_ATTACH_READ_ONLY_9_NL,
IDCLS_ATTACH_READ_ONLY_9_PL,
IDCLS_ATTACH_READ_ONLY_9_SV,
IDCLS_ATTACH_READ_ONLY_9_TR,

/* attach.c */
IDCLS_ATTACH_READ_WRITE_9,
IDCLS_ATTACH_READ_WRITE_9_DA,
IDCLS_ATTACH_READ_WRITE_9_DE,
IDCLS_ATTACH_READ_WRITE_9_FR,
IDCLS_ATTACH_READ_WRITE_9_HU,
IDCLS_ATTACH_READ_WRITE_9_IT,
IDCLS_ATTACH_READ_WRITE_9_NL,
IDCLS_ATTACH_READ_WRITE_9_PL,
IDCLS_ATTACH_READ_WRITE_9_SV,
IDCLS_ATTACH_READ_WRITE_9_TR,

/* attach.c */
IDCLS_ATTACH_READ_ONLY_10,
IDCLS_ATTACH_READ_ONLY_10_DA,
IDCLS_ATTACH_READ_ONLY_10_DE,
IDCLS_ATTACH_READ_ONLY_10_FR,
IDCLS_ATTACH_READ_ONLY_10_HU,
IDCLS_ATTACH_READ_ONLY_10_IT,
IDCLS_ATTACH_READ_ONLY_10_NL,
IDCLS_ATTACH_READ_ONLY_10_PL,
IDCLS_ATTACH_READ_ONLY_10_SV,
IDCLS_ATTACH_READ_ONLY_10_TR,

/* attach.c */
IDCLS_ATTACH_READ_WRITE_10,
IDCLS_ATTACH_READ_WRITE_10_DA,
IDCLS_ATTACH_READ_WRITE_10_DE,
IDCLS_ATTACH_READ_WRITE_10_FR,
IDCLS_ATTACH_READ_WRITE_10_HU,
IDCLS_ATTACH_READ_WRITE_10_IT,
IDCLS_ATTACH_READ_WRITE_10_NL,
IDCLS_ATTACH_READ_WRITE_10_PL,
IDCLS_ATTACH_READ_WRITE_10_SV,
IDCLS_ATTACH_READ_WRITE_10_TR,

/* attach.c */
IDCLS_ATTACH_READ_ONLY_11,
IDCLS_ATTACH_READ_ONLY_11_DA,
IDCLS_ATTACH_READ_ONLY_11_DE,
IDCLS_ATTACH_READ_ONLY_11_FR,
IDCLS_ATTACH_READ_ONLY_11_HU,
IDCLS_ATTACH_READ_ONLY_11_IT,
IDCLS_ATTACH_READ_ONLY_11_NL,
IDCLS_ATTACH_READ_ONLY_11_PL,
IDCLS_ATTACH_READ_ONLY_11_SV,
IDCLS_ATTACH_READ_ONLY_11_TR,

/* attach.c */
IDCLS_ATTACH_READ_WRITE_11,
IDCLS_ATTACH_READ_WRITE_11_DA,
IDCLS_ATTACH_READ_WRITE_11_DE,
IDCLS_ATTACH_READ_WRITE_11_FR,
IDCLS_ATTACH_READ_WRITE_11_HU,
IDCLS_ATTACH_READ_WRITE_11_IT,
IDCLS_ATTACH_READ_WRITE_11_NL,
IDCLS_ATTACH_READ_WRITE_11_PL,
IDCLS_ATTACH_READ_WRITE_11_SV,
IDCLS_ATTACH_READ_WRITE_11_TR,

/* datasette.c */
IDCLS_ENABLE_AUTO_DATASETTE_RESET,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_DA,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_DE,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_FR,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_HU,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_IT,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_NL,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_PL,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_SV,
IDCLS_ENABLE_AUTO_DATASETTE_RESET_TR,

/* datasette.c */
IDCLS_DISABLE_AUTO_DATASETTE_RESET,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_DA,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_DE,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_FR,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_HU,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_IT,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_NL,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_PL,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_SV,
IDCLS_DISABLE_AUTO_DATASETTE_RESET_TR,

/* datasette.c */
IDCLS_SET_ZERO_TAP_DELAY,
IDCLS_SET_ZERO_TAP_DELAY_DA,
IDCLS_SET_ZERO_TAP_DELAY_DE,
IDCLS_SET_ZERO_TAP_DELAY_FR,
IDCLS_SET_ZERO_TAP_DELAY_HU,
IDCLS_SET_ZERO_TAP_DELAY_IT,
IDCLS_SET_ZERO_TAP_DELAY_NL,
IDCLS_SET_ZERO_TAP_DELAY_PL,
IDCLS_SET_ZERO_TAP_DELAY_SV,
IDCLS_SET_ZERO_TAP_DELAY_TR,

/* datasette.c */
IDCLS_SET_CYCLES_ADDED_GAP_TAP,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_DA,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_DE,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_FR,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_HU,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_IT,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_NL,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_PL,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_SV,
IDCLS_SET_CYCLES_ADDED_GAP_TAP_TR,

#ifdef DEBUG
/* debug.c */
IDCLS_TRACE_MAIN_CPU,
IDCLS_TRACE_MAIN_CPU_DA,
IDCLS_TRACE_MAIN_CPU_DE,
IDCLS_TRACE_MAIN_CPU_FR,
IDCLS_TRACE_MAIN_CPU_HU,
IDCLS_TRACE_MAIN_CPU_IT,
IDCLS_TRACE_MAIN_CPU_NL,
IDCLS_TRACE_MAIN_CPU_PL,
IDCLS_TRACE_MAIN_CPU_SV,
IDCLS_TRACE_MAIN_CPU_TR,

/* debug.c */
IDCLS_DONT_TRACE_MAIN_CPU,
IDCLS_DONT_TRACE_MAIN_CPU_DA,
IDCLS_DONT_TRACE_MAIN_CPU_DE,
IDCLS_DONT_TRACE_MAIN_CPU_FR,
IDCLS_DONT_TRACE_MAIN_CPU_HU,
IDCLS_DONT_TRACE_MAIN_CPU_IT,
IDCLS_DONT_TRACE_MAIN_CPU_NL,
IDCLS_DONT_TRACE_MAIN_CPU_PL,
IDCLS_DONT_TRACE_MAIN_CPU_SV,
IDCLS_DONT_TRACE_MAIN_CPU_TR,

/* debug.c */
IDCLS_TRACE_DRIVE0_CPU,
IDCLS_TRACE_DRIVE0_CPU_DA,
IDCLS_TRACE_DRIVE0_CPU_DE,
IDCLS_TRACE_DRIVE0_CPU_FR,
IDCLS_TRACE_DRIVE0_CPU_HU,
IDCLS_TRACE_DRIVE0_CPU_IT,
IDCLS_TRACE_DRIVE0_CPU_NL,
IDCLS_TRACE_DRIVE0_CPU_PL,
IDCLS_TRACE_DRIVE0_CPU_SV,
IDCLS_TRACE_DRIVE0_CPU_TR,

/* debug.c */
IDCLS_DONT_TRACE_DRIVE0_CPU,
IDCLS_DONT_TRACE_DRIVE0_CPU_DA,
IDCLS_DONT_TRACE_DRIVE0_CPU_DE,
IDCLS_DONT_TRACE_DRIVE0_CPU_FR,
IDCLS_DONT_TRACE_DRIVE0_CPU_HU,
IDCLS_DONT_TRACE_DRIVE0_CPU_IT,
IDCLS_DONT_TRACE_DRIVE0_CPU_NL,
IDCLS_DONT_TRACE_DRIVE0_CPU_PL,
IDCLS_DONT_TRACE_DRIVE0_CPU_SV,
IDCLS_DONT_TRACE_DRIVE0_CPU_TR,

/* debug.c */
IDCLS_TRACE_DRIVE1_CPU,
IDCLS_TRACE_DRIVE1_CPU_DA,
IDCLS_TRACE_DRIVE1_CPU_DE,
IDCLS_TRACE_DRIVE1_CPU_FR,
IDCLS_TRACE_DRIVE1_CPU_HU,
IDCLS_TRACE_DRIVE1_CPU_IT,
IDCLS_TRACE_DRIVE1_CPU_NL,
IDCLS_TRACE_DRIVE1_CPU_PL,
IDCLS_TRACE_DRIVE1_CPU_SV,
IDCLS_TRACE_DRIVE1_CPU_TR,

/* debug.c */
IDCLS_DONT_TRACE_DRIVE1_CPU,
IDCLS_DONT_TRACE_DRIVE1_CPU_DA,
IDCLS_DONT_TRACE_DRIVE1_CPU_DE,
IDCLS_DONT_TRACE_DRIVE1_CPU_FR,
IDCLS_DONT_TRACE_DRIVE1_CPU_HU,
IDCLS_DONT_TRACE_DRIVE1_CPU_IT,
IDCLS_DONT_TRACE_DRIVE1_CPU_NL,
IDCLS_DONT_TRACE_DRIVE1_CPU_PL,
IDCLS_DONT_TRACE_DRIVE1_CPU_SV,
IDCLS_DONT_TRACE_DRIVE1_CPU_TR,

#if DRIVE_NUM > 2
/* debug.c */
IDCLS_TRACE_DRIVE2_CPU,
IDCLS_TRACE_DRIVE2_CPU_DA,
IDCLS_TRACE_DRIVE2_CPU_DE,
IDCLS_TRACE_DRIVE2_CPU_FR,
IDCLS_TRACE_DRIVE2_CPU_HU,
IDCLS_TRACE_DRIVE2_CPU_IT,
IDCLS_TRACE_DRIVE2_CPU_NL,
IDCLS_TRACE_DRIVE2_CPU_PL,
IDCLS_TRACE_DRIVE2_CPU_SV,
IDCLS_TRACE_DRIVE2_CPU_TR,

/* debug.c */
IDCLS_DONT_TRACE_DRIVE2_CPU,
IDCLS_DONT_TRACE_DRIVE2_CPU_DA,
IDCLS_DONT_TRACE_DRIVE2_CPU_DE,
IDCLS_DONT_TRACE_DRIVE2_CPU_FR,
IDCLS_DONT_TRACE_DRIVE2_CPU_HU,
IDCLS_DONT_TRACE_DRIVE2_CPU_IT,
IDCLS_DONT_TRACE_DRIVE2_CPU_NL,
IDCLS_DONT_TRACE_DRIVE2_CPU_PL,
IDCLS_DONT_TRACE_DRIVE2_CPU_SV,
IDCLS_DONT_TRACE_DRIVE2_CPU_TR,
#endif   /* DRIVE_NUM > 2 */

#if DRIVE_NUM > 3
/* debug.c */
IDCLS_TRACE_DRIVE3_CPU,
IDCLS_TRACE_DRIVE3_CPU_DA,
IDCLS_TRACE_DRIVE3_CPU_DE,
IDCLS_TRACE_DRIVE3_CPU_FR,
IDCLS_TRACE_DRIVE3_CPU_HU,
IDCLS_TRACE_DRIVE3_CPU_IT,
IDCLS_TRACE_DRIVE3_CPU_NL,
IDCLS_TRACE_DRIVE3_CPU_PL,
IDCLS_TRACE_DRIVE3_CPU_SV,
IDCLS_TRACE_DRIVE3_CPU_TR,

/* debug.c */
IDCLS_DONT_TRACE_DRIVE3_CPU,
IDCLS_DONT_TRACE_DRIVE3_CPU_DA,
IDCLS_DONT_TRACE_DRIVE3_CPU_DE,
IDCLS_DONT_TRACE_DRIVE3_CPU_FR,
IDCLS_DONT_TRACE_DRIVE3_CPU_HU,
IDCLS_DONT_TRACE_DRIVE3_CPU_IT,
IDCLS_DONT_TRACE_DRIVE3_CPU_NL,
IDCLS_DONT_TRACE_DRIVE3_CPU_PL,
IDCLS_DONT_TRACE_DRIVE3_CPU_SV,
IDCLS_DONT_TRACE_DRIVE3_CPU_TR,
#endif   /* DRIVE_NUM > 3 */

/* debug.c */
IDCLS_TRACE_MODE,
IDCLS_TRACE_MODE_DA,
IDCLS_TRACE_MODE_DE,
IDCLS_TRACE_MODE_FR,
IDCLS_TRACE_MODE_HU,
IDCLS_TRACE_MODE_IT,
IDCLS_TRACE_MODE_NL,
IDCLS_TRACE_MODE_PL,
IDCLS_TRACE_MODE_SV,
IDCLS_TRACE_MODE_TR,
#endif   /* DEBUG */

/* event.c */
IDCLS_PLAYBACK_RECORDED_EVENTS,
IDCLS_PLAYBACK_RECORDED_EVENTS_DA,
IDCLS_PLAYBACK_RECORDED_EVENTS_DE,
IDCLS_PLAYBACK_RECORDED_EVENTS_FR,
IDCLS_PLAYBACK_RECORDED_EVENTS_HU,
IDCLS_PLAYBACK_RECORDED_EVENTS_IT,
IDCLS_PLAYBACK_RECORDED_EVENTS_NL,
IDCLS_PLAYBACK_RECORDED_EVENTS_PL,
IDCLS_PLAYBACK_RECORDED_EVENTS_SV,
IDCLS_PLAYBACK_RECORDED_EVENTS_TR,

/* monitor.c */
IDCLS_EXECUTE_MONITOR_FROM_FILE,
IDCLS_EXECUTE_MONITOR_FROM_FILE_DA,
IDCLS_EXECUTE_MONITOR_FROM_FILE_DE,
IDCLS_EXECUTE_MONITOR_FROM_FILE_FR,
IDCLS_EXECUTE_MONITOR_FROM_FILE_HU,
IDCLS_EXECUTE_MONITOR_FROM_FILE_IT,
IDCLS_EXECUTE_MONITOR_FROM_FILE_NL,
IDCLS_EXECUTE_MONITOR_FROM_FILE_PL,
IDCLS_EXECUTE_MONITOR_FROM_FILE_SV,
IDCLS_EXECUTE_MONITOR_FROM_FILE_TR,

/* monitor.c */
IDCLS_SET_INITIAL_BREAKPOINT,
IDCLS_SET_INITIAL_BREAKPOINT_DA,
IDCLS_SET_INITIAL_BREAKPOINT_DE,
IDCLS_SET_INITIAL_BREAKPOINT_FR,
IDCLS_SET_INITIAL_BREAKPOINT_HU,
IDCLS_SET_INITIAL_BREAKPOINT_IT,
IDCLS_SET_INITIAL_BREAKPOINT_NL,
IDCLS_SET_INITIAL_BREAKPOINT_PL,
IDCLS_SET_INITIAL_BREAKPOINT_SV,
IDCLS_SET_INITIAL_BREAKPOINT_TR,

/* monitor_network.c */
IDCLS_ENABLE_REMOTE_MONITOR,
IDCLS_ENABLE_REMOTE_MONITOR_DA,
IDCLS_ENABLE_REMOTE_MONITOR_DE,
IDCLS_ENABLE_REMOTE_MONITOR_FR,
IDCLS_ENABLE_REMOTE_MONITOR_HU,
IDCLS_ENABLE_REMOTE_MONITOR_IT,
IDCLS_ENABLE_REMOTE_MONITOR_NL,
IDCLS_ENABLE_REMOTE_MONITOR_PL,
IDCLS_ENABLE_REMOTE_MONITOR_SV,
IDCLS_ENABLE_REMOTE_MONITOR_TR,

/* monitor_network.c */
IDCLS_DISABLE_REMOTE_MONITOR,
IDCLS_DISABLE_REMOTE_MONITOR_DA,
IDCLS_DISABLE_REMOTE_MONITOR_DE,
IDCLS_DISABLE_REMOTE_MONITOR_FR,
IDCLS_DISABLE_REMOTE_MONITOR_HU,
IDCLS_DISABLE_REMOTE_MONITOR_IT,
IDCLS_DISABLE_REMOTE_MONITOR_NL,
IDCLS_DISABLE_REMOTE_MONITOR_PL,
IDCLS_DISABLE_REMOTE_MONITOR_SV,
IDCLS_DISABLE_REMOTE_MONITOR_TR,

/* monitor_network.c */
IDCLS_REMOTE_MONITOR_ADDRESS,
IDCLS_REMOTE_MONITOR_ADDRESS_DA,
IDCLS_REMOTE_MONITOR_ADDRESS_DE,
IDCLS_REMOTE_MONITOR_ADDRESS_FR,
IDCLS_REMOTE_MONITOR_ADDRESS_HU,
IDCLS_REMOTE_MONITOR_ADDRESS_IT,
IDCLS_REMOTE_MONITOR_ADDRESS_NL,
IDCLS_REMOTE_MONITOR_ADDRESS_PL,
IDCLS_REMOTE_MONITOR_ADDRESS_SV,
IDCLS_REMOTE_MONITOR_ADDRESS_TR,

/* fliplist.c */
IDCLS_SPECIFY_FLIP_LIST_NAME,
IDCLS_SPECIFY_FLIP_LIST_NAME_DA,
IDCLS_SPECIFY_FLIP_LIST_NAME_DE,
IDCLS_SPECIFY_FLIP_LIST_NAME_FR,
IDCLS_SPECIFY_FLIP_LIST_NAME_HU,
IDCLS_SPECIFY_FLIP_LIST_NAME_IT,
IDCLS_SPECIFY_FLIP_LIST_NAME_NL,
IDCLS_SPECIFY_FLIP_LIST_NAME_PL,
IDCLS_SPECIFY_FLIP_LIST_NAME_SV,
IDCLS_SPECIFY_FLIP_LIST_NAME_TR,

/* initcmdline.c */
IDCLS_SHOW_COMMAND_LINE_OPTIONS,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_DA,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_DE,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_FR,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_HU,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_IT,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_NL,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_PL,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_SV,
IDCLS_SHOW_COMMAND_LINE_OPTIONS_TR,

#if (!defined  __OS2__ && !defined __BEOS__)
/* initcmdline.c */
IDCLS_CONSOLE_MODE,
IDCLS_CONSOLE_MODE_DA,
IDCLS_CONSOLE_MODE_DE,
IDCLS_CONSOLE_MODE_FR,
IDCLS_CONSOLE_MODE_HU,
IDCLS_CONSOLE_MODE_IT,
IDCLS_CONSOLE_MODE_NL,
IDCLS_CONSOLE_MODE_PL,
IDCLS_CONSOLE_MODE_SV,
IDCLS_CONSOLE_MODE_TR,

/* initcmdline.c */
IDCLS_ALLOW_CORE_DUMPS,
IDCLS_ALLOW_CORE_DUMPS_DA,
IDCLS_ALLOW_CORE_DUMPS_DE,
IDCLS_ALLOW_CORE_DUMPS_FR,
IDCLS_ALLOW_CORE_DUMPS_HU,
IDCLS_ALLOW_CORE_DUMPS_IT,
IDCLS_ALLOW_CORE_DUMPS_NL,
IDCLS_ALLOW_CORE_DUMPS_PL,
IDCLS_ALLOW_CORE_DUMPS_SV,
IDCLS_ALLOW_CORE_DUMPS_TR,

/* initcmdline.c */
IDCLS_DONT_ALLOW_CORE_DUMPS,
IDCLS_DONT_ALLOW_CORE_DUMPS_DA,
IDCLS_DONT_ALLOW_CORE_DUMPS_DE,
IDCLS_DONT_ALLOW_CORE_DUMPS_FR,
IDCLS_DONT_ALLOW_CORE_DUMPS_HU,
IDCLS_DONT_ALLOW_CORE_DUMPS_IT,
IDCLS_DONT_ALLOW_CORE_DUMPS_NL,
IDCLS_DONT_ALLOW_CORE_DUMPS_PL,
IDCLS_DONT_ALLOW_CORE_DUMPS_SV,
IDCLS_DONT_ALLOW_CORE_DUMPS_TR,
#else
/* initcmdline.c */
IDCLS_DONT_CALL_EXCEPTION_HANDLER,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_DA,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_DE,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_FR,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_HU,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_IT,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_NL,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_PL,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_SV,
IDCLS_DONT_CALL_EXCEPTION_HANDLER_TR,

/* initcmdline.c */
IDCLS_CALL_EXCEPTION_HANDLER,
IDCLS_CALL_EXCEPTION_HANDLER_DA,
IDCLS_CALL_EXCEPTION_HANDLER_DE,
IDCLS_CALL_EXCEPTION_HANDLER_FR,
IDCLS_CALL_EXCEPTION_HANDLER_HU,
IDCLS_CALL_EXCEPTION_HANDLER_IT,
IDCLS_CALL_EXCEPTION_HANDLER_NL,
IDCLS_CALL_EXCEPTION_HANDLER_PL,
IDCLS_CALL_EXCEPTION_HANDLER_SV,
IDCLS_CALL_EXCEPTION_HANDLER_TR,
#endif  /* __OS2__ __BEOS__ */

/* initcmdline.c */
IDCLS_USE_VSID_MODE,
IDCLS_USE_VSID_MODE_DA,
IDCLS_USE_VSID_MODE_DE,
IDCLS_USE_VSID_MODE_FR,
IDCLS_USE_VSID_MODE_HU,
IDCLS_USE_VSID_MODE_IT,
IDCLS_USE_VSID_MODE_NL,
IDCLS_USE_VSID_MODE_PL,
IDCLS_USE_VSID_MODE_SV,
IDCLS_USE_VSID_MODE_TR,

/* initcmdline.c */
IDCLS_RESTORE_DEFAULT_SETTINGS,
IDCLS_RESTORE_DEFAULT_SETTINGS_DA,
IDCLS_RESTORE_DEFAULT_SETTINGS_DE,
IDCLS_RESTORE_DEFAULT_SETTINGS_FR,
IDCLS_RESTORE_DEFAULT_SETTINGS_HU,
IDCLS_RESTORE_DEFAULT_SETTINGS_IT,
IDCLS_RESTORE_DEFAULT_SETTINGS_NL,
IDCLS_RESTORE_DEFAULT_SETTINGS_PL,
IDCLS_RESTORE_DEFAULT_SETTINGS_SV,
IDCLS_RESTORE_DEFAULT_SETTINGS_TR,

/* initcmdline.c, c64/cart/mmcreplay.c */
IDCLS_P_FILE,
IDCLS_P_FILE_DA,
IDCLS_P_FILE_DE,
IDCLS_P_FILE_FR,
IDCLS_P_FILE_HU,
IDCLS_P_FILE_IT,
IDCLS_P_FILE_NL,
IDCLS_P_FILE_PL,
IDCLS_P_FILE_SV,
IDCLS_P_FILE_TR,

/* initcmdline.c */
IDCLS_SPECIFY_CONFIG_FILE,
IDCLS_SPECIFY_CONFIG_FILE_DA,
IDCLS_SPECIFY_CONFIG_FILE_DE,
IDCLS_SPECIFY_CONFIG_FILE_FR,
IDCLS_SPECIFY_CONFIG_FILE_HU,
IDCLS_SPECIFY_CONFIG_FILE_IT,
IDCLS_SPECIFY_CONFIG_FILE_NL,
IDCLS_SPECIFY_CONFIG_FILE_PL,
IDCLS_SPECIFY_CONFIG_FILE_SV,
IDCLS_SPECIFY_CONFIG_FILE_TR,

/* initcmdline.c */
IDCLS_ATTACH_AND_AUTOSTART,
IDCLS_ATTACH_AND_AUTOSTART_DA,
IDCLS_ATTACH_AND_AUTOSTART_DE,
IDCLS_ATTACH_AND_AUTOSTART_FR,
IDCLS_ATTACH_AND_AUTOSTART_HU,
IDCLS_ATTACH_AND_AUTOSTART_IT,
IDCLS_ATTACH_AND_AUTOSTART_NL,
IDCLS_ATTACH_AND_AUTOSTART_PL,
IDCLS_ATTACH_AND_AUTOSTART_SV,
IDCLS_ATTACH_AND_AUTOSTART_TR,

/* initcmdline.c */
IDCLS_ATTACH_AND_AUTOLOAD,
IDCLS_ATTACH_AND_AUTOLOAD_DA,
IDCLS_ATTACH_AND_AUTOLOAD_DE,
IDCLS_ATTACH_AND_AUTOLOAD_FR,
IDCLS_ATTACH_AND_AUTOLOAD_HU,
IDCLS_ATTACH_AND_AUTOLOAD_IT,
IDCLS_ATTACH_AND_AUTOLOAD_NL,
IDCLS_ATTACH_AND_AUTOLOAD_PL,
IDCLS_ATTACH_AND_AUTOLOAD_SV,
IDCLS_ATTACH_AND_AUTOLOAD_TR,

/* initcmdline.c */
IDCLS_ATTACH_AS_TAPE,
IDCLS_ATTACH_AS_TAPE_DA,
IDCLS_ATTACH_AS_TAPE_DE,
IDCLS_ATTACH_AS_TAPE_FR,
IDCLS_ATTACH_AS_TAPE_HU,
IDCLS_ATTACH_AS_TAPE_IT,
IDCLS_ATTACH_AS_TAPE_NL,
IDCLS_ATTACH_AS_TAPE_PL,
IDCLS_ATTACH_AS_TAPE_SV,
IDCLS_ATTACH_AS_TAPE_TR,

/* initcmdline.c */
IDCLS_ATTACH_AS_DISK_8,
IDCLS_ATTACH_AS_DISK_8_DA,
IDCLS_ATTACH_AS_DISK_8_DE,
IDCLS_ATTACH_AS_DISK_8_FR,
IDCLS_ATTACH_AS_DISK_8_HU,
IDCLS_ATTACH_AS_DISK_8_IT,
IDCLS_ATTACH_AS_DISK_8_NL,
IDCLS_ATTACH_AS_DISK_8_PL,
IDCLS_ATTACH_AS_DISK_8_SV,
IDCLS_ATTACH_AS_DISK_8_TR,

/* initcmdline.c */
IDCLS_ATTACH_AS_DISK_9,
IDCLS_ATTACH_AS_DISK_9_DA,
IDCLS_ATTACH_AS_DISK_9_DE,
IDCLS_ATTACH_AS_DISK_9_FR,
IDCLS_ATTACH_AS_DISK_9_HU,
IDCLS_ATTACH_AS_DISK_9_IT,
IDCLS_ATTACH_AS_DISK_9_NL,
IDCLS_ATTACH_AS_DISK_9_PL,
IDCLS_ATTACH_AS_DISK_9_SV,
IDCLS_ATTACH_AS_DISK_9_TR,

/* initcmdline.c */
IDCLS_ATTACH_AS_DISK_10,
IDCLS_ATTACH_AS_DISK_10_DA,
IDCLS_ATTACH_AS_DISK_10_DE,
IDCLS_ATTACH_AS_DISK_10_FR,
IDCLS_ATTACH_AS_DISK_10_HU,
IDCLS_ATTACH_AS_DISK_10_IT,
IDCLS_ATTACH_AS_DISK_10_NL,
IDCLS_ATTACH_AS_DISK_10_PL,
IDCLS_ATTACH_AS_DISK_10_SV,
IDCLS_ATTACH_AS_DISK_10_TR,

/* initcmdline.c */
IDCLS_ATTACH_AS_DISK_11,
IDCLS_ATTACH_AS_DISK_11_DA,
IDCLS_ATTACH_AS_DISK_11_DE,
IDCLS_ATTACH_AS_DISK_11_FR,
IDCLS_ATTACH_AS_DISK_11_HU,
IDCLS_ATTACH_AS_DISK_11_IT,
IDCLS_ATTACH_AS_DISK_11_NL,
IDCLS_ATTACH_AS_DISK_11_PL,
IDCLS_ATTACH_AS_DISK_11_SV,
IDCLS_ATTACH_AS_DISK_11_TR,

/* kbdbuf.c */
IDCLS_P_STRING,
IDCLS_P_STRING_DA,
IDCLS_P_STRING_DE,
IDCLS_P_STRING_FR,
IDCLS_P_STRING_HU,
IDCLS_P_STRING_IT,
IDCLS_P_STRING_NL,
IDCLS_P_STRING_PL,
IDCLS_P_STRING_SV,
IDCLS_P_STRING_TR,

/* kbdbuf.c */
IDCLS_PUT_STRING_INTO_KEYBUF,
IDCLS_PUT_STRING_INTO_KEYBUF_DA,
IDCLS_PUT_STRING_INTO_KEYBUF_DE,
IDCLS_PUT_STRING_INTO_KEYBUF_FR,
IDCLS_PUT_STRING_INTO_KEYBUF_HU,
IDCLS_PUT_STRING_INTO_KEYBUF_IT,
IDCLS_PUT_STRING_INTO_KEYBUF_NL,
IDCLS_PUT_STRING_INTO_KEYBUF_PL,
IDCLS_PUT_STRING_INTO_KEYBUF_SV,
IDCLS_PUT_STRING_INTO_KEYBUF_TR,

/* log.c */
IDCLS_SPECIFY_LOG_FILE_NAME,
IDCLS_SPECIFY_LOG_FILE_NAME_DA,
IDCLS_SPECIFY_LOG_FILE_NAME_DE,
IDCLS_SPECIFY_LOG_FILE_NAME_FR,
IDCLS_SPECIFY_LOG_FILE_NAME_HU,
IDCLS_SPECIFY_LOG_FILE_NAME_IT,
IDCLS_SPECIFY_LOG_FILE_NAME_NL,
IDCLS_SPECIFY_LOG_FILE_NAME_PL,
IDCLS_SPECIFY_LOG_FILE_NAME_SV,
IDCLS_SPECIFY_LOG_FILE_NAME_TR,

/* mouse.c */
IDCLS_ENABLE_MOUSE_GRAB,
IDCLS_ENABLE_MOUSE_GRAB_DA,
IDCLS_ENABLE_MOUSE_GRAB_DE,
IDCLS_ENABLE_MOUSE_GRAB_FR,
IDCLS_ENABLE_MOUSE_GRAB_HU,
IDCLS_ENABLE_MOUSE_GRAB_IT,
IDCLS_ENABLE_MOUSE_GRAB_NL,
IDCLS_ENABLE_MOUSE_GRAB_PL,
IDCLS_ENABLE_MOUSE_GRAB_SV,
IDCLS_ENABLE_MOUSE_GRAB_TR,

/* mouse.c */
IDCLS_DISABLE_MOUSE_GRAB,
IDCLS_DISABLE_MOUSE_GRAB_DA,
IDCLS_DISABLE_MOUSE_GRAB_DE,
IDCLS_DISABLE_MOUSE_GRAB_FR,
IDCLS_DISABLE_MOUSE_GRAB_HU,
IDCLS_DISABLE_MOUSE_GRAB_IT,
IDCLS_DISABLE_MOUSE_GRAB_NL,
IDCLS_DISABLE_MOUSE_GRAB_PL,
IDCLS_DISABLE_MOUSE_GRAB_SV,
IDCLS_DISABLE_MOUSE_GRAB_TR,

/* mouse.c */
IDCLS_SELECT_MOUSE_JOY_PORT,
IDCLS_SELECT_MOUSE_JOY_PORT_DA,
IDCLS_SELECT_MOUSE_JOY_PORT_DE,
IDCLS_SELECT_MOUSE_JOY_PORT_FR,
IDCLS_SELECT_MOUSE_JOY_PORT_HU,
IDCLS_SELECT_MOUSE_JOY_PORT_IT,
IDCLS_SELECT_MOUSE_JOY_PORT_NL,
IDCLS_SELECT_MOUSE_JOY_PORT_PL,
IDCLS_SELECT_MOUSE_JOY_PORT_SV,
IDCLS_SELECT_MOUSE_JOY_PORT_TR,

/* ps2mouse.c */
IDCLS_ENABLE_PS2MOUSE,
IDCLS_ENABLE_PS2MOUSE_DA,
IDCLS_ENABLE_PS2MOUSE_DE,
IDCLS_ENABLE_PS2MOUSE_FR,
IDCLS_ENABLE_PS2MOUSE_HU,
IDCLS_ENABLE_PS2MOUSE_IT,
IDCLS_ENABLE_PS2MOUSE_NL,
IDCLS_ENABLE_PS2MOUSE_PL,
IDCLS_ENABLE_PS2MOUSE_SV,
IDCLS_ENABLE_PS2MOUSE_TR,

/* ps2mouse.c */
IDCLS_DISABLE_PS2MOUSE,
IDCLS_DISABLE_PS2MOUSE_DA,
IDCLS_DISABLE_PS2MOUSE_DE,
IDCLS_DISABLE_PS2MOUSE_FR,
IDCLS_DISABLE_PS2MOUSE_HU,
IDCLS_DISABLE_PS2MOUSE_IT,
IDCLS_DISABLE_PS2MOUSE_NL,
IDCLS_DISABLE_PS2MOUSE_PL,
IDCLS_DISABLE_PS2MOUSE_SV,
IDCLS_DISABLE_PS2MOUSE_TR,

/* ram.c */
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_DA,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_DE,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_FR,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_HU,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_IT,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_NL,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_PL,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_SV,
IDCLS_SET_FIRST_RAM_ADDRESS_VALUE_TR,

/* mouse.c */
IDCLS_SELECT_MOUSE_TYPE,
IDCLS_SELECT_MOUSE_TYPE_DA,
IDCLS_SELECT_MOUSE_TYPE_DE,
IDCLS_SELECT_MOUSE_TYPE_FR,
IDCLS_SELECT_MOUSE_TYPE_HU,
IDCLS_SELECT_MOUSE_TYPE_IT,
IDCLS_SELECT_MOUSE_TYPE_NL,
IDCLS_SELECT_MOUSE_TYPE_PL,
IDCLS_SELECT_MOUSE_TYPE_SV,
IDCLS_SELECT_MOUSE_TYPE_TR,

/* ram.c */
IDCLS_P_NUM_OF_BYTES,
IDCLS_P_NUM_OF_BYTES_DA,
IDCLS_P_NUM_OF_BYTES_DE,
IDCLS_P_NUM_OF_BYTES_FR,
IDCLS_P_NUM_OF_BYTES_HU,
IDCLS_P_NUM_OF_BYTES_IT,
IDCLS_P_NUM_OF_BYTES_NL,
IDCLS_P_NUM_OF_BYTES_PL,
IDCLS_P_NUM_OF_BYTES_SV,
IDCLS_P_NUM_OF_BYTES_TR,

/* ram.c */
IDCLS_LENGTH_BLOCK_SAME_VALUE,
IDCLS_LENGTH_BLOCK_SAME_VALUE_DA,
IDCLS_LENGTH_BLOCK_SAME_VALUE_DE,
IDCLS_LENGTH_BLOCK_SAME_VALUE_FR,
IDCLS_LENGTH_BLOCK_SAME_VALUE_HU,
IDCLS_LENGTH_BLOCK_SAME_VALUE_IT,
IDCLS_LENGTH_BLOCK_SAME_VALUE_NL,
IDCLS_LENGTH_BLOCK_SAME_VALUE_PL,
IDCLS_LENGTH_BLOCK_SAME_VALUE_SV,
IDCLS_LENGTH_BLOCK_SAME_VALUE_TR,

/* ram.c */
IDCLS_LENGTH_BLOCK_SAME_PATTERN,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_DA,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_DE,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_FR,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_HU,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_IT,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_NL,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_PL,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_SV,
IDCLS_LENGTH_BLOCK_SAME_PATTERN_TR,

/* sound.c */
IDCLS_ENABLE_SOUND_PLAYBACK,
IDCLS_ENABLE_SOUND_PLAYBACK_DA,
IDCLS_ENABLE_SOUND_PLAYBACK_DE,
IDCLS_ENABLE_SOUND_PLAYBACK_FR,
IDCLS_ENABLE_SOUND_PLAYBACK_HU,
IDCLS_ENABLE_SOUND_PLAYBACK_IT,
IDCLS_ENABLE_SOUND_PLAYBACK_NL,
IDCLS_ENABLE_SOUND_PLAYBACK_PL,
IDCLS_ENABLE_SOUND_PLAYBACK_SV,
IDCLS_ENABLE_SOUND_PLAYBACK_TR,

/* sound.c */
IDCLS_DISABLE_SOUND_PLAYBACK,
IDCLS_DISABLE_SOUND_PLAYBACK_DA,
IDCLS_DISABLE_SOUND_PLAYBACK_DE,
IDCLS_DISABLE_SOUND_PLAYBACK_FR,
IDCLS_DISABLE_SOUND_PLAYBACK_HU,
IDCLS_DISABLE_SOUND_PLAYBACK_IT,
IDCLS_DISABLE_SOUND_PLAYBACK_NL,
IDCLS_DISABLE_SOUND_PLAYBACK_PL,
IDCLS_DISABLE_SOUND_PLAYBACK_SV,
IDCLS_DISABLE_SOUND_PLAYBACK_TR,

/* sound.c */
IDCLS_SET_SAMPLE_RATE_VALUE_HZ,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_DA,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_DE,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_FR,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_HU,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_IT,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_NL,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_PL,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_SV,
IDCLS_SET_SAMPLE_RATE_VALUE_HZ_TR,

/* sound.c */
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_DA,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_DE,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_FR,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_HU,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_IT,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_NL,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_PL,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_SV,
IDCLS_SET_SOUND_BUFFER_SIZE_MSEC_TR,

/* sound.c */
IDCLS_SET_SOUND_FRAGMENT_SIZE,
IDCLS_SET_SOUND_FRAGMENT_SIZE_DA,
IDCLS_SET_SOUND_FRAGMENT_SIZE_DE,
IDCLS_SET_SOUND_FRAGMENT_SIZE_FR,
IDCLS_SET_SOUND_FRAGMENT_SIZE_HU,
IDCLS_SET_SOUND_FRAGMENT_SIZE_IT,
IDCLS_SET_SOUND_FRAGMENT_SIZE_NL,
IDCLS_SET_SOUND_FRAGMENT_SIZE_PL,
IDCLS_SET_SOUND_FRAGMENT_SIZE_SV,
IDCLS_SET_SOUND_FRAGMENT_SIZE_TR,

/* sound.c */
IDCLS_SPECIFY_SOUND_DRIVER,
IDCLS_SPECIFY_SOUND_DRIVER_DA,
IDCLS_SPECIFY_SOUND_DRIVER_DE,
IDCLS_SPECIFY_SOUND_DRIVER_FR,
IDCLS_SPECIFY_SOUND_DRIVER_HU,
IDCLS_SPECIFY_SOUND_DRIVER_IT,
IDCLS_SPECIFY_SOUND_DRIVER_NL,
IDCLS_SPECIFY_SOUND_DRIVER_PL,
IDCLS_SPECIFY_SOUND_DRIVER_SV,
IDCLS_SPECIFY_SOUND_DRIVER_TR,

/* sound.c */
IDCLS_P_ARGS,
IDCLS_P_ARGS_DA,
IDCLS_P_ARGS_DE,
IDCLS_P_ARGS_FR,
IDCLS_P_ARGS_HU,
IDCLS_P_ARGS_IT,
IDCLS_P_ARGS_NL,
IDCLS_P_ARGS_PL,
IDCLS_P_ARGS_SV,
IDCLS_P_ARGS_TR,

/* sound.c */
IDCLS_SPECIFY_SOUND_DRIVER_PARAM,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_DA,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_DE,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_FR,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_HU,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_IT,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_NL,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_PL,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_SV,
IDCLS_SPECIFY_SOUND_DRIVER_PARAM_TR,

/* sound.c */
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_DA,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_DE,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_FR,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_HU,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_IT,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_NL,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_PL,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_SV,
IDCLS_SPECIFY_RECORDING_SOUND_DRIVER_TR,

/* sound.c */
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_DA,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_DE,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_FR,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_HU,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_IT,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_NL,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_PL,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_SV,
IDCLS_SPECIFY_REC_SOUND_DRIVER_PARAM_TR,

/* sound.c */
IDCLS_P_SYNC,
IDCLS_P_SYNC_DA,
IDCLS_P_SYNC_DE,
IDCLS_P_SYNC_FR,
IDCLS_P_SYNC_HU,
IDCLS_P_SYNC_IT,
IDCLS_P_SYNC_NL,
IDCLS_P_SYNC_PL,
IDCLS_P_SYNC_SV,
IDCLS_P_SYNC_TR,

/* sound.c */
IDCLS_SET_SOUND_SPEED_ADJUST,
IDCLS_SET_SOUND_SPEED_ADJUST_DA,
IDCLS_SET_SOUND_SPEED_ADJUST_DE,
IDCLS_SET_SOUND_SPEED_ADJUST_FR,
IDCLS_SET_SOUND_SPEED_ADJUST_HU,
IDCLS_SET_SOUND_SPEED_ADJUST_IT,
IDCLS_SET_SOUND_SPEED_ADJUST_NL,
IDCLS_SET_SOUND_SPEED_ADJUST_PL,
IDCLS_SET_SOUND_SPEED_ADJUST_SV,
IDCLS_SET_SOUND_SPEED_ADJUST_TR,

/* sysfile.c */
IDCLS_P_PATH,
IDCLS_P_PATH_DA,
IDCLS_P_PATH_DE,
IDCLS_P_PATH_FR,
IDCLS_P_PATH_HU,
IDCLS_P_PATH_IT,
IDCLS_P_PATH_NL,
IDCLS_P_PATH_PL,
IDCLS_P_PATH_SV,
IDCLS_P_PATH_TR,

/* sysfile.c */
IDCLS_DEFINE_SYSTEM_FILES_PATH,
IDCLS_DEFINE_SYSTEM_FILES_PATH_DA,
IDCLS_DEFINE_SYSTEM_FILES_PATH_DE,
IDCLS_DEFINE_SYSTEM_FILES_PATH_FR,
IDCLS_DEFINE_SYSTEM_FILES_PATH_HU,
IDCLS_DEFINE_SYSTEM_FILES_PATH_IT,
IDCLS_DEFINE_SYSTEM_FILES_PATH_NL,
IDCLS_DEFINE_SYSTEM_FILES_PATH_PL,
IDCLS_DEFINE_SYSTEM_FILES_PATH_SV,
IDCLS_DEFINE_SYSTEM_FILES_PATH_TR,

/* traps.c */
IDCLS_ENABLE_TRAPS_FAST_EMULATION,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_DA,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_DE,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_FR,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_HU,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_IT,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_NL,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_PL,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_SV,
IDCLS_ENABLE_TRAPS_FAST_EMULATION_TR,

/* traps.c */
IDCLS_DISABLE_TRAPS_FAST_EMULATION,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_DA,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_DE,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_FR,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_HU,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_IT,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_NL,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_PL,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_SV,
IDCLS_DISABLE_TRAPS_FAST_EMULATION_TR,

/* vsync.c */
IDCLS_LIMIT_SPEED_TO_VALUE,
IDCLS_LIMIT_SPEED_TO_VALUE_DA,
IDCLS_LIMIT_SPEED_TO_VALUE_DE,
IDCLS_LIMIT_SPEED_TO_VALUE_FR,
IDCLS_LIMIT_SPEED_TO_VALUE_HU,
IDCLS_LIMIT_SPEED_TO_VALUE_IT,
IDCLS_LIMIT_SPEED_TO_VALUE_NL,
IDCLS_LIMIT_SPEED_TO_VALUE_PL,
IDCLS_LIMIT_SPEED_TO_VALUE_SV,
IDCLS_LIMIT_SPEED_TO_VALUE_TR,

/* vsync.c */
IDCLS_UPDATE_EVERY_VALUE_FRAMES,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_DA,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_DE,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_FR,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_HU,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_IT,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_NL,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_PL,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_SV,
IDCLS_UPDATE_EVERY_VALUE_FRAMES_TR,

/* vsync.c */
IDCLS_ENABLE_WARP_MODE,
IDCLS_ENABLE_WARP_MODE_DA,
IDCLS_ENABLE_WARP_MODE_DE,
IDCLS_ENABLE_WARP_MODE_FR,
IDCLS_ENABLE_WARP_MODE_HU,
IDCLS_ENABLE_WARP_MODE_IT,
IDCLS_ENABLE_WARP_MODE_NL,
IDCLS_ENABLE_WARP_MODE_PL,
IDCLS_ENABLE_WARP_MODE_SV,
IDCLS_ENABLE_WARP_MODE_TR,

/* vsync.c */
IDCLS_DISABLE_WARP_MODE,
IDCLS_DISABLE_WARP_MODE_DA,
IDCLS_DISABLE_WARP_MODE_DE,
IDCLS_DISABLE_WARP_MODE_FR,
IDCLS_DISABLE_WARP_MODE_HU,
IDCLS_DISABLE_WARP_MODE_IT,
IDCLS_DISABLE_WARP_MODE_NL,
IDCLS_DISABLE_WARP_MODE_PL,
IDCLS_DISABLE_WARP_MODE_SV,
IDCLS_DISABLE_WARP_MODE_TR,

/* translate.c */
IDCLS_P_ISO_LANGUAGE_CODE,
IDCLS_P_ISO_LANGUAGE_CODE_DA,
IDCLS_P_ISO_LANGUAGE_CODE_DE,
IDCLS_P_ISO_LANGUAGE_CODE_FR,
IDCLS_P_ISO_LANGUAGE_CODE_HU,
IDCLS_P_ISO_LANGUAGE_CODE_IT,
IDCLS_P_ISO_LANGUAGE_CODE_NL,
IDCLS_P_ISO_LANGUAGE_CODE_PL,
IDCLS_P_ISO_LANGUAGE_CODE_SV,
IDCLS_P_ISO_LANGUAGE_CODE_TR,

/* translate.c */
IDCLS_SPECIFY_ISO_LANG_CODE,
IDCLS_SPECIFY_ISO_LANG_CODE_DA,
IDCLS_SPECIFY_ISO_LANG_CODE_DE,
IDCLS_SPECIFY_ISO_LANG_CODE_FR,
IDCLS_SPECIFY_ISO_LANG_CODE_HU,
IDCLS_SPECIFY_ISO_LANG_CODE_IT,
IDCLS_SPECIFY_ISO_LANG_CODE_NL,
IDCLS_SPECIFY_ISO_LANG_CODE_PL,
IDCLS_SPECIFY_ISO_LANG_CODE_SV,
IDCLS_SPECIFY_ISO_LANG_CODE_TR,

/* c64/plus60k.c */
IDCLS_ENABLE_PLUS60K_EXPANSION,
IDCLS_ENABLE_PLUS60K_EXPANSION_DA,
IDCLS_ENABLE_PLUS60K_EXPANSION_DE,
IDCLS_ENABLE_PLUS60K_EXPANSION_FR,
IDCLS_ENABLE_PLUS60K_EXPANSION_HU,
IDCLS_ENABLE_PLUS60K_EXPANSION_IT,
IDCLS_ENABLE_PLUS60K_EXPANSION_NL,
IDCLS_ENABLE_PLUS60K_EXPANSION_PL,
IDCLS_ENABLE_PLUS60K_EXPANSION_SV,
IDCLS_ENABLE_PLUS60K_EXPANSION_TR,

/* c64/plus60k.c */
IDCLS_DISABLE_PLUS60K_EXPANSION,
IDCLS_DISABLE_PLUS60K_EXPANSION_DA,
IDCLS_DISABLE_PLUS60K_EXPANSION_DE,
IDCLS_DISABLE_PLUS60K_EXPANSION_FR,
IDCLS_DISABLE_PLUS60K_EXPANSION_HU,
IDCLS_DISABLE_PLUS60K_EXPANSION_IT,
IDCLS_DISABLE_PLUS60K_EXPANSION_NL,
IDCLS_DISABLE_PLUS60K_EXPANSION_PL,
IDCLS_DISABLE_PLUS60K_EXPANSION_SV,
IDCLS_DISABLE_PLUS60K_EXPANSION_TR,

/* c64/plus60k.c */
IDCLS_SPECIFY_PLUS60K_NAME,
IDCLS_SPECIFY_PLUS60K_NAME_DA,
IDCLS_SPECIFY_PLUS60K_NAME_DE,
IDCLS_SPECIFY_PLUS60K_NAME_FR,
IDCLS_SPECIFY_PLUS60K_NAME_HU,
IDCLS_SPECIFY_PLUS60K_NAME_IT,
IDCLS_SPECIFY_PLUS60K_NAME_NL,
IDCLS_SPECIFY_PLUS60K_NAME_PL,
IDCLS_SPECIFY_PLUS60K_NAME_SV,
IDCLS_SPECIFY_PLUS60K_NAME_TR,

/* sid/sid-cmdline-options.c */
#ifdef HAVE_RESID
/* sid/sid-cmdline-options.c */
IDCLS_RESID_GAIN_PERCENTAGE,
IDCLS_RESID_GAIN_PERCENTAGE_DA,
IDCLS_RESID_GAIN_PERCENTAGE_DE,
IDCLS_RESID_GAIN_PERCENTAGE_FR,
IDCLS_RESID_GAIN_PERCENTAGE_HU,
IDCLS_RESID_GAIN_PERCENTAGE_IT,
IDCLS_RESID_GAIN_PERCENTAGE_NL,
IDCLS_RESID_GAIN_PERCENTAGE_PL,
IDCLS_RESID_GAIN_PERCENTAGE_SV,
IDCLS_RESID_GAIN_PERCENTAGE_TR,
#endif   /* HAVE_RESID */

/* c64/cart/c64cart.c */
IDCLS_ATTACH_RAW_STB_CART,
IDCLS_ATTACH_RAW_STB_CART_DA,
IDCLS_ATTACH_RAW_STB_CART_DE,
IDCLS_ATTACH_RAW_STB_CART_FR,
IDCLS_ATTACH_RAW_STB_CART_HU,
IDCLS_ATTACH_RAW_STB_CART_IT,
IDCLS_ATTACH_RAW_STB_CART_NL,
IDCLS_ATTACH_RAW_STB_CART_PL,
IDCLS_ATTACH_RAW_STB_CART_SV,
IDCLS_ATTACH_RAW_STB_CART_TR,

/* c64/plus60k.c */
IDCLS_PLUS60K_BASE,
IDCLS_PLUS60K_BASE_DA,
IDCLS_PLUS60K_BASE_DE,
IDCLS_PLUS60K_BASE_FR,
IDCLS_PLUS60K_BASE_HU,
IDCLS_PLUS60K_BASE_IT,
IDCLS_PLUS60K_BASE_NL,
IDCLS_PLUS60K_BASE_PL,
IDCLS_PLUS60K_BASE_SV,
IDCLS_PLUS60K_BASE_TR,

/* c64/c64_256k.c */
IDCLS_ENABLE_C64_256K_EXPANSION,
IDCLS_ENABLE_C64_256K_EXPANSION_DA,
IDCLS_ENABLE_C64_256K_EXPANSION_DE,
IDCLS_ENABLE_C64_256K_EXPANSION_FR,
IDCLS_ENABLE_C64_256K_EXPANSION_HU,
IDCLS_ENABLE_C64_256K_EXPANSION_IT,
IDCLS_ENABLE_C64_256K_EXPANSION_NL,
IDCLS_ENABLE_C64_256K_EXPANSION_PL,
IDCLS_ENABLE_C64_256K_EXPANSION_SV,
IDCLS_ENABLE_C64_256K_EXPANSION_TR,

/* c64/c64_256k.c */
IDCLS_DISABLE_C64_256K_EXPANSION,
IDCLS_DISABLE_C64_256K_EXPANSION_DA,
IDCLS_DISABLE_C64_256K_EXPANSION_DE,
IDCLS_DISABLE_C64_256K_EXPANSION_FR,
IDCLS_DISABLE_C64_256K_EXPANSION_HU,
IDCLS_DISABLE_C64_256K_EXPANSION_IT,
IDCLS_DISABLE_C64_256K_EXPANSION_NL,
IDCLS_DISABLE_C64_256K_EXPANSION_PL,
IDCLS_DISABLE_C64_256K_EXPANSION_SV,
IDCLS_DISABLE_C64_256K_EXPANSION_TR,

/* c64/c64_256k.c */
IDCLS_SPECIFY_C64_256K_NAME,
IDCLS_SPECIFY_C64_256K_NAME_DA,
IDCLS_SPECIFY_C64_256K_NAME_DE,
IDCLS_SPECIFY_C64_256K_NAME_FR,
IDCLS_SPECIFY_C64_256K_NAME_HU,
IDCLS_SPECIFY_C64_256K_NAME_IT,
IDCLS_SPECIFY_C64_256K_NAME_NL,
IDCLS_SPECIFY_C64_256K_NAME_PL,
IDCLS_SPECIFY_C64_256K_NAME_SV,
IDCLS_SPECIFY_C64_256K_NAME_TR,

/* c64/c64_256k.c */
IDCLS_C64_256K_BASE,
IDCLS_C64_256K_BASE_DA,
IDCLS_C64_256K_BASE_DE,
IDCLS_C64_256K_BASE_FR,
IDCLS_C64_256K_BASE_HU,
IDCLS_C64_256K_BASE_IT,
IDCLS_C64_256K_BASE_NL,
IDCLS_C64_256K_BASE_PL,
IDCLS_C64_256K_BASE_SV,
IDCLS_C64_256K_BASE_TR,

/* pet/petreu.c */
IDCLS_ENABLE_PETREU,
IDCLS_ENABLE_PETREU_DA,
IDCLS_ENABLE_PETREU_DE,
IDCLS_ENABLE_PETREU_FR,
IDCLS_ENABLE_PETREU_HU,
IDCLS_ENABLE_PETREU_IT,
IDCLS_ENABLE_PETREU_NL,
IDCLS_ENABLE_PETREU_PL,
IDCLS_ENABLE_PETREU_SV,
IDCLS_ENABLE_PETREU_TR,

/* pet/petreu.c */
IDCLS_DISABLE_PETREU,
IDCLS_DISABLE_PETREU_DA,
IDCLS_DISABLE_PETREU_DE,
IDCLS_DISABLE_PETREU_FR,
IDCLS_DISABLE_PETREU_HU,
IDCLS_DISABLE_PETREU_IT,
IDCLS_DISABLE_PETREU_NL,
IDCLS_DISABLE_PETREU_PL,
IDCLS_DISABLE_PETREU_SV,
IDCLS_DISABLE_PETREU_TR,

/* pet/petreu.c */
IDCLS_SPECIFY_PETREU_NAME,
IDCLS_SPECIFY_PETREU_NAME_DA,
IDCLS_SPECIFY_PETREU_NAME_DE,
IDCLS_SPECIFY_PETREU_NAME_FR,
IDCLS_SPECIFY_PETREU_NAME_HU,
IDCLS_SPECIFY_PETREU_NAME_IT,
IDCLS_SPECIFY_PETREU_NAME_NL,
IDCLS_SPECIFY_PETREU_NAME_PL,
IDCLS_SPECIFY_PETREU_NAME_SV,
IDCLS_SPECIFY_PETREU_NAME_TR,

/* pet/petreu.c */
IDCLS_PETREU_SIZE,
IDCLS_PETREU_SIZE_DA,
IDCLS_PETREU_SIZE_DE,
IDCLS_PETREU_SIZE_FR,
IDCLS_PETREU_SIZE_HU,
IDCLS_PETREU_SIZE_IT,
IDCLS_PETREU_SIZE_NL,
IDCLS_PETREU_SIZE_PL,
IDCLS_PETREU_SIZE_SV,
IDCLS_PETREU_SIZE_TR,

/* pet/petdww.c */
IDCLS_ENABLE_PETDWW,
IDCLS_ENABLE_PETDWW_DA,
IDCLS_ENABLE_PETDWW_DE,
IDCLS_ENABLE_PETDWW_FR,
IDCLS_ENABLE_PETDWW_HU,
IDCLS_ENABLE_PETDWW_IT,
IDCLS_ENABLE_PETDWW_NL,
IDCLS_ENABLE_PETDWW_PL,
IDCLS_ENABLE_PETDWW_SV,
IDCLS_ENABLE_PETDWW_TR,

/* pet/petdww.c */
IDCLS_DISABLE_PETDWW,
IDCLS_DISABLE_PETDWW_DA,
IDCLS_DISABLE_PETDWW_DE,
IDCLS_DISABLE_PETDWW_FR,
IDCLS_DISABLE_PETDWW_HU,
IDCLS_DISABLE_PETDWW_IT,
IDCLS_DISABLE_PETDWW_NL,
IDCLS_DISABLE_PETDWW_PL,
IDCLS_DISABLE_PETDWW_SV,
IDCLS_DISABLE_PETDWW_TR,

/* pet/petdww.c */
IDCLS_SPECIFY_PETDWW_NAME,
IDCLS_SPECIFY_PETDWW_NAME_DA,
IDCLS_SPECIFY_PETDWW_NAME_DE,
IDCLS_SPECIFY_PETDWW_NAME_FR,
IDCLS_SPECIFY_PETDWW_NAME_HU,
IDCLS_SPECIFY_PETDWW_NAME_IT,
IDCLS_SPECIFY_PETDWW_NAME_NL,
IDCLS_SPECIFY_PETDWW_NAME_PL,
IDCLS_SPECIFY_PETDWW_NAME_SV,
IDCLS_SPECIFY_PETDWW_NAME_TR,

/* c64/plus256k.c */
IDCLS_ENABLE_PLUS256K_EXPANSION,
IDCLS_ENABLE_PLUS256K_EXPANSION_DA,
IDCLS_ENABLE_PLUS256K_EXPANSION_DE,
IDCLS_ENABLE_PLUS256K_EXPANSION_FR,
IDCLS_ENABLE_PLUS256K_EXPANSION_HU,
IDCLS_ENABLE_PLUS256K_EXPANSION_IT,
IDCLS_ENABLE_PLUS256K_EXPANSION_NL,
IDCLS_ENABLE_PLUS256K_EXPANSION_PL,
IDCLS_ENABLE_PLUS256K_EXPANSION_SV,
IDCLS_ENABLE_PLUS256K_EXPANSION_TR,

/* c64/plus256k.c */
IDCLS_DISABLE_PLUS256K_EXPANSION,
IDCLS_DISABLE_PLUS256K_EXPANSION_DA,
IDCLS_DISABLE_PLUS256K_EXPANSION_DE,
IDCLS_DISABLE_PLUS256K_EXPANSION_FR,
IDCLS_DISABLE_PLUS256K_EXPANSION_HU,
IDCLS_DISABLE_PLUS256K_EXPANSION_IT,
IDCLS_DISABLE_PLUS256K_EXPANSION_NL,
IDCLS_DISABLE_PLUS256K_EXPANSION_PL,
IDCLS_DISABLE_PLUS256K_EXPANSION_SV,
IDCLS_DISABLE_PLUS256K_EXPANSION_TR,

/* c64/plus256k.c */
IDCLS_SPECIFY_PLUS256K_NAME,
IDCLS_SPECIFY_PLUS256K_NAME_DA,
IDCLS_SPECIFY_PLUS256K_NAME_DE,
IDCLS_SPECIFY_PLUS256K_NAME_FR,
IDCLS_SPECIFY_PLUS256K_NAME_HU,
IDCLS_SPECIFY_PLUS256K_NAME_IT,
IDCLS_SPECIFY_PLUS256K_NAME_NL,
IDCLS_SPECIFY_PLUS256K_NAME_PL,
IDCLS_SPECIFY_PLUS256K_NAME_SV,
IDCLS_SPECIFY_PLUS256K_NAME_TR,

/* plus4/plus4memcsory256k.c */
IDCLS_ENABLE_CS256K_EXPANSION,
IDCLS_ENABLE_CS256K_EXPANSION_DA,
IDCLS_ENABLE_CS256K_EXPANSION_DE,
IDCLS_ENABLE_CS256K_EXPANSION_FR,
IDCLS_ENABLE_CS256K_EXPANSION_HU,
IDCLS_ENABLE_CS256K_EXPANSION_IT,
IDCLS_ENABLE_CS256K_EXPANSION_NL,
IDCLS_ENABLE_CS256K_EXPANSION_PL,
IDCLS_ENABLE_CS256K_EXPANSION_SV,
IDCLS_ENABLE_CS256K_EXPANSION_TR,

/* plus4/plus4memhannes256k.c */
IDCLS_ENABLE_H256K_EXPANSION,
IDCLS_ENABLE_H256K_EXPANSION_DA,
IDCLS_ENABLE_H256K_EXPANSION_DE,
IDCLS_ENABLE_H256K_EXPANSION_FR,
IDCLS_ENABLE_H256K_EXPANSION_HU,
IDCLS_ENABLE_H256K_EXPANSION_IT,
IDCLS_ENABLE_H256K_EXPANSION_NL,
IDCLS_ENABLE_H256K_EXPANSION_PL,
IDCLS_ENABLE_H256K_EXPANSION_SV,
IDCLS_ENABLE_H256K_EXPANSION_TR,

/* plus4/plus4memhannes256k.c */
IDCLS_ENABLE_H1024K_EXPANSION,
IDCLS_ENABLE_H1024K_EXPANSION_DA,
IDCLS_ENABLE_H1024K_EXPANSION_DE,
IDCLS_ENABLE_H1024K_EXPANSION_FR,
IDCLS_ENABLE_H1024K_EXPANSION_HU,
IDCLS_ENABLE_H1024K_EXPANSION_IT,
IDCLS_ENABLE_H1024K_EXPANSION_NL,
IDCLS_ENABLE_H1024K_EXPANSION_PL,
IDCLS_ENABLE_H1024K_EXPANSION_SV,
IDCLS_ENABLE_H1024K_EXPANSION_TR,

/* plus4/plus4memhannes256k.c */
IDCLS_ENABLE_H4096K_EXPANSION,
IDCLS_ENABLE_H4096K_EXPANSION_DA,
IDCLS_ENABLE_H4096K_EXPANSION_DE,
IDCLS_ENABLE_H4096K_EXPANSION_FR,
IDCLS_ENABLE_H4096K_EXPANSION_HU,
IDCLS_ENABLE_H4096K_EXPANSION_IT,
IDCLS_ENABLE_H4096K_EXPANSION_NL,
IDCLS_ENABLE_H4096K_EXPANSION_PL,
IDCLS_ENABLE_H4096K_EXPANSION_SV,
IDCLS_ENABLE_H4096K_EXPANSION_TR,

/* plus4/digiblaster.c */
IDCLS_ENABLE_DIGIBLASTER,
IDCLS_ENABLE_DIGIBLASTER_DA,
IDCLS_ENABLE_DIGIBLASTER_DE,
IDCLS_ENABLE_DIGIBLASTER_FR,
IDCLS_ENABLE_DIGIBLASTER_HU,
IDCLS_ENABLE_DIGIBLASTER_IT,
IDCLS_ENABLE_DIGIBLASTER_NL,
IDCLS_ENABLE_DIGIBLASTER_PL,
IDCLS_ENABLE_DIGIBLASTER_SV,
IDCLS_ENABLE_DIGIBLASTER_TR,

/* plus4/digiblaster.c */
IDCLS_DISABLE_DIGIBLASTER,
IDCLS_DISABLE_DIGIBLASTER_DA,
IDCLS_DISABLE_DIGIBLASTER_DE,
IDCLS_DISABLE_DIGIBLASTER_FR,
IDCLS_DISABLE_DIGIBLASTER_HU,
IDCLS_DISABLE_DIGIBLASTER_IT,
IDCLS_DISABLE_DIGIBLASTER_NL,
IDCLS_DISABLE_DIGIBLASTER_PL,
IDCLS_DISABLE_DIGIBLASTER_SV,
IDCLS_DISABLE_DIGIBLASTER_TR,

/* plus4/sidcartjoy.c */
IDCLS_ENABLE_SIDCARTJOY,
IDCLS_ENABLE_SIDCARTJOY_DA,
IDCLS_ENABLE_SIDCARTJOY_DE,
IDCLS_ENABLE_SIDCARTJOY_FR,
IDCLS_ENABLE_SIDCARTJOY_HU,
IDCLS_ENABLE_SIDCARTJOY_IT,
IDCLS_ENABLE_SIDCARTJOY_NL,
IDCLS_ENABLE_SIDCARTJOY_PL,
IDCLS_ENABLE_SIDCARTJOY_SV,
IDCLS_ENABLE_SIDCARTJOY_TR,

/* plus4/sidcartjoy.c */
IDCLS_DISABLE_SIDCARTJOY,
IDCLS_DISABLE_SIDCARTJOY_DA,
IDCLS_DISABLE_SIDCARTJOY_DE,
IDCLS_DISABLE_SIDCARTJOY_FR,
IDCLS_DISABLE_SIDCARTJOY_HU,
IDCLS_DISABLE_SIDCARTJOY_IT,
IDCLS_DISABLE_SIDCARTJOY_NL,
IDCLS_DISABLE_SIDCARTJOY_PL,
IDCLS_DISABLE_SIDCARTJOY_SV,
IDCLS_DISABLE_SIDCARTJOY_TR,

/* plus4/plus4speech.c */
IDCLS_ENABLE_PLUS4SPEECH,
IDCLS_ENABLE_PLUS4SPEECH_DA,
IDCLS_ENABLE_PLUS4SPEECH_DE,
IDCLS_ENABLE_PLUS4SPEECH_FR,
IDCLS_ENABLE_PLUS4SPEECH_HU,
IDCLS_ENABLE_PLUS4SPEECH_IT,
IDCLS_ENABLE_PLUS4SPEECH_NL,
IDCLS_ENABLE_PLUS4SPEECH_PL,
IDCLS_ENABLE_PLUS4SPEECH_SV,
IDCLS_ENABLE_PLUS4SPEECH_TR,

/* plus4/plus4speech.c */
IDCLS_DISABLE_PLUS4SPEECH,
IDCLS_DISABLE_PLUS4SPEECH_DA,
IDCLS_DISABLE_PLUS4SPEECH_DE,
IDCLS_DISABLE_PLUS4SPEECH_FR,
IDCLS_DISABLE_PLUS4SPEECH_HU,
IDCLS_DISABLE_PLUS4SPEECH_IT,
IDCLS_DISABLE_PLUS4SPEECH_NL,
IDCLS_DISABLE_PLUS4SPEECH_PL,
IDCLS_DISABLE_PLUS4SPEECH_SV,
IDCLS_DISABLE_PLUS4SPEECH_TR,

/* plus4/plus4speech.c */
IDCLS_ATTACH_SPEECH_ROM_IMAGE,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_DA,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_DE,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_FR,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_HU,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_IT,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_NL,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_PL,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_SV,
IDCLS_ATTACH_SPEECH_ROM_IMAGE_TR,

/* c64/cart/digimax.c */
IDCLS_ENABLE_DIGIMAX,
IDCLS_ENABLE_DIGIMAX_DA,
IDCLS_ENABLE_DIGIMAX_DE,
IDCLS_ENABLE_DIGIMAX_FR,
IDCLS_ENABLE_DIGIMAX_HU,
IDCLS_ENABLE_DIGIMAX_IT,
IDCLS_ENABLE_DIGIMAX_NL,
IDCLS_ENABLE_DIGIMAX_PL,
IDCLS_ENABLE_DIGIMAX_SV,
IDCLS_ENABLE_DIGIMAX_TR,

/* c64/cart/digimax.c */
IDCLS_DISABLE_DIGIMAX,
IDCLS_DISABLE_DIGIMAX_DA,
IDCLS_DISABLE_DIGIMAX_DE,
IDCLS_DISABLE_DIGIMAX_FR,
IDCLS_DISABLE_DIGIMAX_HU,
IDCLS_DISABLE_DIGIMAX_IT,
IDCLS_DISABLE_DIGIMAX_NL,
IDCLS_DISABLE_DIGIMAX_PL,
IDCLS_DISABLE_DIGIMAX_SV,
IDCLS_DISABLE_DIGIMAX_TR,

/* c64/cart/digimax.c */
IDCLS_DIGIMAX_BASE,
IDCLS_DIGIMAX_BASE_DA,
IDCLS_DIGIMAX_BASE_DE,
IDCLS_DIGIMAX_BASE_FR,
IDCLS_DIGIMAX_BASE_HU,
IDCLS_DIGIMAX_BASE_IT,
IDCLS_DIGIMAX_BASE_NL,
IDCLS_DIGIMAX_BASE_PL,
IDCLS_DIGIMAX_BASE_SV,
IDCLS_DIGIMAX_BASE_TR,

/* c64/cart/sfx_soundexpander.c */
IDCLS_ENABLE_SFX_SE,
IDCLS_ENABLE_SFX_SE_DA,
IDCLS_ENABLE_SFX_SE_DE,
IDCLS_ENABLE_SFX_SE_FR,
IDCLS_ENABLE_SFX_SE_HU,
IDCLS_ENABLE_SFX_SE_IT,
IDCLS_ENABLE_SFX_SE_NL,
IDCLS_ENABLE_SFX_SE_PL,
IDCLS_ENABLE_SFX_SE_SV,
IDCLS_ENABLE_SFX_SE_TR,

/* c64/cart/sfx_soundexpander.c */
IDCLS_DISABLE_SFX_SE,
IDCLS_DISABLE_SFX_SE_DA,
IDCLS_DISABLE_SFX_SE_DE,
IDCLS_DISABLE_SFX_SE_FR,
IDCLS_DISABLE_SFX_SE_HU,
IDCLS_DISABLE_SFX_SE_IT,
IDCLS_DISABLE_SFX_SE_NL,
IDCLS_DISABLE_SFX_SE_PL,
IDCLS_DISABLE_SFX_SE_SV,
IDCLS_DISABLE_SFX_SE_TR,

/* c64/cart/sfx_soundexpander.c */
IDCLS_SET_YM_CHIP_TYPE,
IDCLS_SET_YM_CHIP_TYPE_DA,
IDCLS_SET_YM_CHIP_TYPE_DE,
IDCLS_SET_YM_CHIP_TYPE_FR,
IDCLS_SET_YM_CHIP_TYPE_HU,
IDCLS_SET_YM_CHIP_TYPE_IT,
IDCLS_SET_YM_CHIP_TYPE_NL,
IDCLS_SET_YM_CHIP_TYPE_PL,
IDCLS_SET_YM_CHIP_TYPE_SV,
IDCLS_SET_YM_CHIP_TYPE_TR,

/* c64/cart/sfx_soundsampler.c */
IDCLS_ENABLE_SFX_SS,
IDCLS_ENABLE_SFX_SS_DA,
IDCLS_ENABLE_SFX_SS_DE,
IDCLS_ENABLE_SFX_SS_FR,
IDCLS_ENABLE_SFX_SS_HU,
IDCLS_ENABLE_SFX_SS_IT,
IDCLS_ENABLE_SFX_SS_NL,
IDCLS_ENABLE_SFX_SS_PL,
IDCLS_ENABLE_SFX_SS_SV,
IDCLS_ENABLE_SFX_SS_TR,

/* c64/cart/sfx_soundsampler.c */
IDCLS_DISABLE_SFX_SS,
IDCLS_DISABLE_SFX_SS_DA,
IDCLS_DISABLE_SFX_SS_DE,
IDCLS_DISABLE_SFX_SS_FR,
IDCLS_DISABLE_SFX_SS_HU,
IDCLS_DISABLE_SFX_SS_IT,
IDCLS_DISABLE_SFX_SS_NL,
IDCLS_DISABLE_SFX_SS_PL,
IDCLS_DISABLE_SFX_SS_SV,
IDCLS_DISABLE_SFX_SS_TR,

/* c64dtv/c64dtv-cmdline-options.c */
IDCLS_SELECT_HUMMER_USERPORT_DEVICE,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_DA,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_DE,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_FR,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_HU,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_IT,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_NL,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_PL,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_SV,
IDCLS_SELECT_HUMMER_USERPORT_DEVICE_TR,

/* c64dtv/c64dtv-cmdline-options.c */
IDCLS_P_PORT,
IDCLS_P_PORT_DA,
IDCLS_P_PORT_DE,
IDCLS_P_PORT_FR,
IDCLS_P_PORT_HU,
IDCLS_P_PORT_IT,
IDCLS_P_PORT_NL,
IDCLS_P_PORT_PL,
IDCLS_P_PORT_SV,
IDCLS_P_PORT_TR,

/* c64dtv/c64dtv-cmdline-options.c */
IDCLS_HUMMER_JOY_PORT,
IDCLS_HUMMER_JOY_PORT_DA,
IDCLS_HUMMER_JOY_PORT_DE,
IDCLS_HUMMER_JOY_PORT_FR,
IDCLS_HUMMER_JOY_PORT_HU,
IDCLS_HUMMER_JOY_PORT_IT,
IDCLS_HUMMER_JOY_PORT_NL,
IDCLS_HUMMER_JOY_PORT_PL,
IDCLS_HUMMER_JOY_PORT_SV,
IDCLS_HUMMER_JOY_PORT_TR,

/* c64dtv/c64dtvblitter.c */
IDCLS_SPECIFY_DTV_REVISION,
IDCLS_SPECIFY_DTV_REVISION_DA,
IDCLS_SPECIFY_DTV_REVISION_DE,
IDCLS_SPECIFY_DTV_REVISION_FR,
IDCLS_SPECIFY_DTV_REVISION_HU,
IDCLS_SPECIFY_DTV_REVISION_IT,
IDCLS_SPECIFY_DTV_REVISION_NL,
IDCLS_SPECIFY_DTV_REVISION_PL,
IDCLS_SPECIFY_DTV_REVISION_SV,
IDCLS_SPECIFY_DTV_REVISION_TR,

/* c64dtv/c64dtvblitter.c */
IDCLS_ENABLE_DTV_BLITTER_LOG,
IDCLS_ENABLE_DTV_BLITTER_LOG_DA,
IDCLS_ENABLE_DTV_BLITTER_LOG_DE,
IDCLS_ENABLE_DTV_BLITTER_LOG_FR,
IDCLS_ENABLE_DTV_BLITTER_LOG_HU,
IDCLS_ENABLE_DTV_BLITTER_LOG_IT,
IDCLS_ENABLE_DTV_BLITTER_LOG_NL,
IDCLS_ENABLE_DTV_BLITTER_LOG_PL,
IDCLS_ENABLE_DTV_BLITTER_LOG_SV,
IDCLS_ENABLE_DTV_BLITTER_LOG_TR,

/* c64dtv/c64dtvblitter.c */
IDCLS_DISABLE_DTV_BLITTER_LOG,
IDCLS_DISABLE_DTV_BLITTER_LOG_DA,
IDCLS_DISABLE_DTV_BLITTER_LOG_DE,
IDCLS_DISABLE_DTV_BLITTER_LOG_FR,
IDCLS_DISABLE_DTV_BLITTER_LOG_HU,
IDCLS_DISABLE_DTV_BLITTER_LOG_IT,
IDCLS_DISABLE_DTV_BLITTER_LOG_NL,
IDCLS_DISABLE_DTV_BLITTER_LOG_PL,
IDCLS_DISABLE_DTV_BLITTER_LOG_SV,
IDCLS_DISABLE_DTV_BLITTER_LOG_TR,

/* c64dtv/c64dtvdma.c */
IDCLS_ENABLE_DTV_DMA_LOG,
IDCLS_ENABLE_DTV_DMA_LOG_DA,
IDCLS_ENABLE_DTV_DMA_LOG_DE,
IDCLS_ENABLE_DTV_DMA_LOG_FR,
IDCLS_ENABLE_DTV_DMA_LOG_HU,
IDCLS_ENABLE_DTV_DMA_LOG_IT,
IDCLS_ENABLE_DTV_DMA_LOG_NL,
IDCLS_ENABLE_DTV_DMA_LOG_PL,
IDCLS_ENABLE_DTV_DMA_LOG_SV,
IDCLS_ENABLE_DTV_DMA_LOG_TR,

/* c64dtv/c64dtvdma.c */
IDCLS_DISABLE_DTV_DMA_LOG,
IDCLS_DISABLE_DTV_DMA_LOG_DA,
IDCLS_DISABLE_DTV_DMA_LOG_DE,
IDCLS_DISABLE_DTV_DMA_LOG_FR,
IDCLS_DISABLE_DTV_DMA_LOG_HU,
IDCLS_DISABLE_DTV_DMA_LOG_IT,
IDCLS_DISABLE_DTV_DMA_LOG_NL,
IDCLS_DISABLE_DTV_DMA_LOG_PL,
IDCLS_DISABLE_DTV_DMA_LOG_SV,
IDCLS_DISABLE_DTV_DMA_LOG_TR,

/* c64dtv/c64dtvflash.c */
IDCLS_SPECIFY_C64DTVROM_NAME,
IDCLS_SPECIFY_C64DTVROM_NAME_DA,
IDCLS_SPECIFY_C64DTVROM_NAME_DE,
IDCLS_SPECIFY_C64DTVROM_NAME_FR,
IDCLS_SPECIFY_C64DTVROM_NAME_HU,
IDCLS_SPECIFY_C64DTVROM_NAME_IT,
IDCLS_SPECIFY_C64DTVROM_NAME_NL,
IDCLS_SPECIFY_C64DTVROM_NAME_PL,
IDCLS_SPECIFY_C64DTVROM_NAME_SV,
IDCLS_SPECIFY_C64DTVROM_NAME_TR,

/* c64dtv/c64dtvflash.c */
IDCLS_ENABLE_C64DTVROM_RW,
IDCLS_ENABLE_C64DTVROM_RW_DA,
IDCLS_ENABLE_C64DTVROM_RW_DE,
IDCLS_ENABLE_C64DTVROM_RW_FR,
IDCLS_ENABLE_C64DTVROM_RW_HU,
IDCLS_ENABLE_C64DTVROM_RW_IT,
IDCLS_ENABLE_C64DTVROM_RW_NL,
IDCLS_ENABLE_C64DTVROM_RW_PL,
IDCLS_ENABLE_C64DTVROM_RW_SV,
IDCLS_ENABLE_C64DTVROM_RW_TR,

/* c64dtv/c64dtvflash.c */
IDCLS_DISABLE_C64DTVROM_RW,
IDCLS_DISABLE_C64DTVROM_RW_DA,
IDCLS_DISABLE_C64DTVROM_RW_DE,
IDCLS_DISABLE_C64DTVROM_RW_FR,
IDCLS_DISABLE_C64DTVROM_RW_HU,
IDCLS_DISABLE_C64DTVROM_RW_IT,
IDCLS_DISABLE_C64DTVROM_RW_NL,
IDCLS_DISABLE_C64DTVROM_RW_PL,
IDCLS_DISABLE_C64DTVROM_RW_SV,
IDCLS_DISABLE_C64DTVROM_RW_TR,

/* c64dtv/flash-trap.c */
IDCLS_USE_AS_DIRECTORY_FLASH_FS,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_DA,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_DE,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_FR,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_HU,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_IT,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_NL,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_PL,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_SV,
IDCLS_USE_AS_DIRECTORY_FLASH_FS_TR,

/* c64dtv/flash-trap.c */
IDCLS_ENABLE_TRUE_FLASH_FS,
IDCLS_ENABLE_TRUE_FLASH_FS_DA,
IDCLS_ENABLE_TRUE_FLASH_FS_DE,
IDCLS_ENABLE_TRUE_FLASH_FS_FR,
IDCLS_ENABLE_TRUE_FLASH_FS_HU,
IDCLS_ENABLE_TRUE_FLASH_FS_IT,
IDCLS_ENABLE_TRUE_FLASH_FS_NL,
IDCLS_ENABLE_TRUE_FLASH_FS_PL,
IDCLS_ENABLE_TRUE_FLASH_FS_SV,
IDCLS_ENABLE_TRUE_FLASH_FS_TR,

/* c64dtv/flash-trap.c */
IDCLS_DISABLE_TRUE_FLASH_FS,
IDCLS_DISABLE_TRUE_FLASH_FS_DA,
IDCLS_DISABLE_TRUE_FLASH_FS_DE,
IDCLS_DISABLE_TRUE_FLASH_FS_FR,
IDCLS_DISABLE_TRUE_FLASH_FS_HU,
IDCLS_DISABLE_TRUE_FLASH_FS_IT,
IDCLS_DISABLE_TRUE_FLASH_FS_NL,
IDCLS_DISABLE_TRUE_FLASH_FS_PL,
IDCLS_DISABLE_TRUE_FLASH_FS_SV,
IDCLS_DISABLE_TRUE_FLASH_FS_TR,

/* midi.c */
IDCLS_ENABLE_MIDI_EMU,
IDCLS_ENABLE_MIDI_EMU_DA,
IDCLS_ENABLE_MIDI_EMU_DE,
IDCLS_ENABLE_MIDI_EMU_FR,
IDCLS_ENABLE_MIDI_EMU_HU,
IDCLS_ENABLE_MIDI_EMU_IT,
IDCLS_ENABLE_MIDI_EMU_NL,
IDCLS_ENABLE_MIDI_EMU_PL,
IDCLS_ENABLE_MIDI_EMU_SV,
IDCLS_ENABLE_MIDI_EMU_TR,

/* midi.c */
IDCLS_DISABLE_MIDI_EMU,
IDCLS_DISABLE_MIDI_EMU_DA,
IDCLS_DISABLE_MIDI_EMU_DE,
IDCLS_DISABLE_MIDI_EMU_FR,
IDCLS_DISABLE_MIDI_EMU_HU,
IDCLS_DISABLE_MIDI_EMU_IT,
IDCLS_DISABLE_MIDI_EMU_NL,
IDCLS_DISABLE_MIDI_EMU_PL,
IDCLS_DISABLE_MIDI_EMU_SV,
IDCLS_DISABLE_MIDI_EMU_TR,

/* c64/cart/c64-midi.c */
IDCLS_SPECIFY_C64_MIDI_TYPE,
IDCLS_SPECIFY_C64_MIDI_TYPE_DA,
IDCLS_SPECIFY_C64_MIDI_TYPE_DE,
IDCLS_SPECIFY_C64_MIDI_TYPE_FR,
IDCLS_SPECIFY_C64_MIDI_TYPE_HU,
IDCLS_SPECIFY_C64_MIDI_TYPE_IT,
IDCLS_SPECIFY_C64_MIDI_TYPE_NL,
IDCLS_SPECIFY_C64_MIDI_TYPE_PL,
IDCLS_SPECIFY_C64_MIDI_TYPE_SV,
IDCLS_SPECIFY_C64_MIDI_TYPE_TR,

/* monitor/mon_command.c */
IDGS_COMMAND_S_UNKNOWN,
IDGS_COMMAND_S_UNKNOWN_DA,
IDGS_COMMAND_S_UNKNOWN_DE,
IDGS_COMMAND_S_UNKNOWN_FR,
IDGS_COMMAND_S_UNKNOWN_HU,
IDGS_COMMAND_S_UNKNOWN_IT,
IDGS_COMMAND_S_UNKNOWN_NL,
IDGS_COMMAND_S_UNKNOWN_PL,
IDGS_COMMAND_S_UNKNOWN_SV,
IDGS_COMMAND_S_UNKNOWN_TR,

/* monitor/mon_command.c */
IDGS_NO_HELP_AVAILABLE_FOR_S,
IDGS_NO_HELP_AVAILABLE_FOR_S_DA,
IDGS_NO_HELP_AVAILABLE_FOR_S_DE,
IDGS_NO_HELP_AVAILABLE_FOR_S_FR,
IDGS_NO_HELP_AVAILABLE_FOR_S_HU,
IDGS_NO_HELP_AVAILABLE_FOR_S_IT,
IDGS_NO_HELP_AVAILABLE_FOR_S_NL,
IDGS_NO_HELP_AVAILABLE_FOR_S_PL,
IDGS_NO_HELP_AVAILABLE_FOR_S_SV,
IDGS_NO_HELP_AVAILABLE_FOR_S_TR,

/* monitor/mon_command.c */
IDGS_SYNTAX_S_S,
IDGS_SYNTAX_S_S_DA,
IDGS_SYNTAX_S_S_DE,
IDGS_SYNTAX_S_S_FR,
IDGS_SYNTAX_S_S_HU,
IDGS_SYNTAX_S_S_IT,
IDGS_SYNTAX_S_S_NL,
IDGS_SYNTAX_S_S_PL,
IDGS_SYNTAX_S_S_SV,
IDGS_SYNTAX_S_S_TR,

/* monitor/mon_command.c */
IDGS_ABBREVIATION_S,
IDGS_ABBREVIATION_S_DA,
IDGS_ABBREVIATION_S_DE,
IDGS_ABBREVIATION_S_FR,
IDGS_ABBREVIATION_S_HU,
IDGS_ABBREVIATION_S_IT,
IDGS_ABBREVIATION_S_NL,
IDGS_ABBREVIATION_S_PL,
IDGS_ABBREVIATION_S_SV,
IDGS_ABBREVIATION_S_TR,

/* monitor/mon_command.c */
IDGS_AVAILABLE_COMMANDS_ARE,
IDGS_AVAILABLE_COMMANDS_ARE_DA,
IDGS_AVAILABLE_COMMANDS_ARE_DE,
IDGS_AVAILABLE_COMMANDS_ARE_FR,
IDGS_AVAILABLE_COMMANDS_ARE_HU,
IDGS_AVAILABLE_COMMANDS_ARE_IT,
IDGS_AVAILABLE_COMMANDS_ARE_NL,
IDGS_AVAILABLE_COMMANDS_ARE_PL,
IDGS_AVAILABLE_COMMANDS_ARE_SV,
IDGS_AVAILABLE_COMMANDS_ARE_TR,

/* monitor/mon_command.c */
IDGS_MACHINE_STATE_COMMANDS,
IDGS_MACHINE_STATE_COMMANDS_DA,
IDGS_MACHINE_STATE_COMMANDS_DE,
IDGS_MACHINE_STATE_COMMANDS_FR,
IDGS_MACHINE_STATE_COMMANDS_HU,
IDGS_MACHINE_STATE_COMMANDS_IT,
IDGS_MACHINE_STATE_COMMANDS_NL,
IDGS_MACHINE_STATE_COMMANDS_PL,
IDGS_MACHINE_STATE_COMMANDS_SV,
IDGS_MACHINE_STATE_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_RP_MEMSPACE_R_BANKNAME,
IDGS_RP_MEMSPACE_R_BANKNAME_DA,
IDGS_RP_MEMSPACE_R_BANKNAME_DE,
IDGS_RP_MEMSPACE_R_BANKNAME_FR,
IDGS_RP_MEMSPACE_R_BANKNAME_HU,
IDGS_RP_MEMSPACE_R_BANKNAME_IT,
IDGS_RP_MEMSPACE_R_BANKNAME_NL,
IDGS_RP_MEMSPACE_R_BANKNAME_PL,
IDGS_RP_MEMSPACE_R_BANKNAME_SV,
IDGS_RP_MEMSPACE_R_BANKNAME_TR,

/* monitor/mon_command.c */
IDGS_MON_BANK_DESCRIPTION,
IDGS_MON_BANK_DESCRIPTION_DA,
IDGS_MON_BANK_DESCRIPTION_DE,
IDGS_MON_BANK_DESCRIPTION_FR,
IDGS_MON_BANK_DESCRIPTION_HU,
IDGS_MON_BANK_DESCRIPTION_IT,
IDGS_MON_BANK_DESCRIPTION_NL,
IDGS_MON_BANK_DESCRIPTION_PL,
IDGS_MON_BANK_DESCRIPTION_SV,
IDGS_MON_BANK_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_BACKTRACE_DESCRIPTION,
IDGS_MON_BACKTRACE_DESCRIPTION_DA,
IDGS_MON_BACKTRACE_DESCRIPTION_DE,
IDGS_MON_BACKTRACE_DESCRIPTION_FR,
IDGS_MON_BACKTRACE_DESCRIPTION_HU,
IDGS_MON_BACKTRACE_DESCRIPTION_IT,
IDGS_MON_BACKTRACE_DESCRIPTION_NL,
IDGS_MON_BACKTRACE_DESCRIPTION_PL,
IDGS_MON_BACKTRACE_DESCRIPTION_SV,
IDGS_MON_BACKTRACE_DESCRIPTION_TR,

IDGS_MON_CPU_DESCRIPTION,
IDGS_MON_CPU_DESCRIPTION_DA,
IDGS_MON_CPU_DESCRIPTION_DE,
IDGS_MON_CPU_DESCRIPTION_FR,
IDGS_MON_CPU_DESCRIPTION_HU,
IDGS_MON_CPU_DESCRIPTION_IT,
IDGS_MON_CPU_DESCRIPTION_NL,
IDGS_MON_CPU_DESCRIPTION_PL,
IDGS_MON_CPU_DESCRIPTION_SV,
IDGS_MON_CPU_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_COUNT,
IDGS_RP_COUNT_DA,
IDGS_RP_COUNT_DE,
IDGS_RP_COUNT_FR,
IDGS_RP_COUNT_HU,
IDGS_RP_COUNT_IT,
IDGS_RP_COUNT_NL,
IDGS_RP_COUNT_PL,
IDGS_RP_COUNT_SV,
IDGS_RP_COUNT_TR,

/* monitor/mon_command.c */
IDGS_MON_CPUHISTORY_DESCRIPTION,
IDGS_MON_CPUHISTORY_DESCRIPTION_DA,
IDGS_MON_CPUHISTORY_DESCRIPTION_DE,
IDGS_MON_CPUHISTORY_DESCRIPTION_FR,
IDGS_MON_CPUHISTORY_DESCRIPTION_HU,
IDGS_MON_CPUHISTORY_DESCRIPTION_IT,
IDGS_MON_CPUHISTORY_DESCRIPTION_NL,
IDGS_MON_CPUHISTORY_DESCRIPTION_PL,
IDGS_MON_CPUHISTORY_DESCRIPTION_SV,
IDGS_MON_CPUHISTORY_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME,
IDGS_QP_FILENAME_DA,
IDGS_QP_FILENAME_DE,
IDGS_QP_FILENAME_FR,
IDGS_QP_FILENAME_HU,
IDGS_QP_FILENAME_IT,
IDGS_QP_FILENAME_NL,
IDGS_QP_FILENAME_PL,
IDGS_QP_FILENAME_SV,
IDGS_QP_FILENAME_TR,

/* monitor/mon_command.c */
IDGS_MON_DUMP_DESCRIPTION,
IDGS_MON_DUMP_DESCRIPTION_DA,
IDGS_MON_DUMP_DESCRIPTION_DE,
IDGS_MON_DUMP_DESCRIPTION_FR,
IDGS_MON_DUMP_DESCRIPTION_HU,
IDGS_MON_DUMP_DESCRIPTION_IT,
IDGS_MON_DUMP_DESCRIPTION_NL,
IDGS_MON_DUMP_DESCRIPTION_PL,
IDGS_MON_DUMP_DESCRIPTION_SV,
IDGS_MON_DUMP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_ADDRESS,
IDGS_P_ADDRESS_DA,
IDGS_P_ADDRESS_DE,
IDGS_P_ADDRESS_FR,
IDGS_P_ADDRESS_HU,
IDGS_P_ADDRESS_IT,
IDGS_P_ADDRESS_NL,
IDGS_P_ADDRESS_PL,
IDGS_P_ADDRESS_SV,
IDGS_P_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_GOTO_DESCRIPTION,
IDGS_MON_GOTO_DESCRIPTION_DA,
IDGS_MON_GOTO_DESCRIPTION_DE,
IDGS_MON_GOTO_DESCRIPTION_FR,
IDGS_MON_GOTO_DESCRIPTION_HU,
IDGS_MON_GOTO_DESCRIPTION_IT,
IDGS_MON_GOTO_DESCRIPTION_NL,
IDGS_MON_GOTO_DESCRIPTION_PL,
IDGS_MON_GOTO_DESCRIPTION_SV,
IDGS_MON_GOTO_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_IO_DESCRIPTION,
IDGS_MON_IO_DESCRIPTION_DA,
IDGS_MON_IO_DESCRIPTION_DE,
IDGS_MON_IO_DESCRIPTION_FR,
IDGS_MON_IO_DESCRIPTION_HU,
IDGS_MON_IO_DESCRIPTION_IT,
IDGS_MON_IO_DESCRIPTION_NL,
IDGS_MON_IO_DESCRIPTION_PL,
IDGS_MON_IO_DESCRIPTION_SV,
IDGS_MON_IO_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_EXPORT_DESCRIPTION,
IDGS_MON_EXPORT_DESCRIPTION_DA,
IDGS_MON_EXPORT_DESCRIPTION_DE,
IDGS_MON_EXPORT_DESCRIPTION_FR,
IDGS_MON_EXPORT_DESCRIPTION_HU,
IDGS_MON_EXPORT_DESCRIPTION_IT,
IDGS_MON_EXPORT_DESCRIPTION_NL,
IDGS_MON_EXPORT_DESCRIPTION_PL,
IDGS_MON_EXPORT_DESCRIPTION_SV,
IDGS_MON_EXPORT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_NEXT_DESCRIPTION,
IDGS_MON_NEXT_DESCRIPTION_DA,
IDGS_MON_NEXT_DESCRIPTION_DE,
IDGS_MON_NEXT_DESCRIPTION_FR,
IDGS_MON_NEXT_DESCRIPTION_HU,
IDGS_MON_NEXT_DESCRIPTION_IT,
IDGS_MON_NEXT_DESCRIPTION_NL,
IDGS_MON_NEXT_DESCRIPTION_PL,
IDGS_MON_NEXT_DESCRIPTION_SV,
IDGS_MON_NEXT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_REG_NAME_P_NUMBER,
IDGS_RP_REG_NAME_P_NUMBER_DA,
IDGS_RP_REG_NAME_P_NUMBER_DE,
IDGS_RP_REG_NAME_P_NUMBER_FR,
IDGS_RP_REG_NAME_P_NUMBER_HU,
IDGS_RP_REG_NAME_P_NUMBER_IT,
IDGS_RP_REG_NAME_P_NUMBER_NL,
IDGS_RP_REG_NAME_P_NUMBER_PL,
IDGS_RP_REG_NAME_P_NUMBER_SV,
IDGS_RP_REG_NAME_P_NUMBER_TR,

/* monitor/mon_command.c */
IDGS_MON_REGISTERS_DESCRIPTION,
IDGS_MON_REGISTERS_DESCRIPTION_DA,
IDGS_MON_REGISTERS_DESCRIPTION_DE,
IDGS_MON_REGISTERS_DESCRIPTION_FR,
IDGS_MON_REGISTERS_DESCRIPTION_HU,
IDGS_MON_REGISTERS_DESCRIPTION_IT,
IDGS_MON_REGISTERS_DESCRIPTION_NL,
IDGS_MON_REGISTERS_DESCRIPTION_PL,
IDGS_MON_REGISTERS_DESCRIPTION_SV,
IDGS_MON_REGISTERS_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_TYPE,
IDGS_RP_TYPE_DA,
IDGS_RP_TYPE_DE,
IDGS_RP_TYPE_FR,
IDGS_RP_TYPE_HU,
IDGS_RP_TYPE_IT,
IDGS_RP_TYPE_NL,
IDGS_RP_TYPE_PL,
IDGS_RP_TYPE_SV,
IDGS_RP_TYPE_TR,

/* monitor/mon_command.c */
IDGS_MON_RESET_DESCRIPTION,
IDGS_MON_RESET_DESCRIPTION_DA,
IDGS_MON_RESET_DESCRIPTION_DE,
IDGS_MON_RESET_DESCRIPTION_FR,
IDGS_MON_RESET_DESCRIPTION_HU,
IDGS_MON_RESET_DESCRIPTION_IT,
IDGS_MON_RESET_DESCRIPTION_NL,
IDGS_MON_RESET_DESCRIPTION_PL,
IDGS_MON_RESET_DESCRIPTION_SV,
IDGS_MON_RESET_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_RETURN_DESCRIPTION,
IDGS_MON_RETURN_DESCRIPTION_DA,
IDGS_MON_RETURN_DESCRIPTION_DE,
IDGS_MON_RETURN_DESCRIPTION_FR,
IDGS_MON_RETURN_DESCRIPTION_HU,
IDGS_MON_RETURN_DESCRIPTION_IT,
IDGS_MON_RETURN_DESCRIPTION_NL,
IDGS_MON_RETURN_DESCRIPTION_PL,
IDGS_MON_RETURN_DESCRIPTION_SV,
IDGS_MON_RETURN_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_SCREEN_DESCRIPTION,
IDGS_MON_SCREEN_DESCRIPTION_DA,
IDGS_MON_SCREEN_DESCRIPTION_DE,
IDGS_MON_SCREEN_DESCRIPTION_FR,
IDGS_MON_SCREEN_DESCRIPTION_HU,
IDGS_MON_SCREEN_DESCRIPTION_IT,
IDGS_MON_SCREEN_DESCRIPTION_NL,
IDGS_MON_SCREEN_DESCRIPTION_PL,
IDGS_MON_SCREEN_DESCRIPTION_SV,
IDGS_MON_SCREEN_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_STEP_DESCRIPTION,
IDGS_MON_STEP_DESCRIPTION_DA,
IDGS_MON_STEP_DESCRIPTION_DE,
IDGS_MON_STEP_DESCRIPTION_FR,
IDGS_MON_STEP_DESCRIPTION_HU,
IDGS_MON_STEP_DESCRIPTION_IT,
IDGS_MON_STEP_DESCRIPTION_NL,
IDGS_MON_STEP_DESCRIPTION_PL,
IDGS_MON_STEP_DESCRIPTION_SV,
IDGS_MON_STEP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_UNDUMP_DESCRIPTION,
IDGS_MON_UNDUMP_DESCRIPTION_DA,
IDGS_MON_UNDUMP_DESCRIPTION_DE,
IDGS_MON_UNDUMP_DESCRIPTION_FR,
IDGS_MON_UNDUMP_DESCRIPTION_HU,
IDGS_MON_UNDUMP_DESCRIPTION_IT,
IDGS_MON_UNDUMP_DESCRIPTION_NL,
IDGS_MON_UNDUMP_DESCRIPTION_PL,
IDGS_MON_UNDUMP_DESCRIPTION_SV,
IDGS_MON_UNDUMP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_SYMBOL_TABLE_COMMANDS,
IDGS_SYMBOL_TABLE_COMMANDS_DA,
IDGS_SYMBOL_TABLE_COMMANDS_DE,
IDGS_SYMBOL_TABLE_COMMANDS_FR,
IDGS_SYMBOL_TABLE_COMMANDS_HU,
IDGS_SYMBOL_TABLE_COMMANDS_IT,
IDGS_SYMBOL_TABLE_COMMANDS_NL,
IDGS_SYMBOL_TABLE_COMMANDS_PL,
IDGS_SYMBOL_TABLE_COMMANDS_SV,
IDGS_SYMBOL_TABLE_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_DA,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_DE,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_FR,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_HU,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_IT,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_NL,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_PL,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_SV,
IDGS_RP_MEMSPACE_P_ADDRESS_P_LABEL_TR,

/* monitor/mon_command.c */
IDGS_MON_ADD_LABEL_DESCRIPTION,
IDGS_MON_ADD_LABEL_DESCRIPTION_DA,
IDGS_MON_ADD_LABEL_DESCRIPTION_DE,
IDGS_MON_ADD_LABEL_DESCRIPTION_FR,
IDGS_MON_ADD_LABEL_DESCRIPTION_HU,
IDGS_MON_ADD_LABEL_DESCRIPTION_IT,
IDGS_MON_ADD_LABEL_DESCRIPTION_NL,
IDGS_MON_ADD_LABEL_DESCRIPTION_PL,
IDGS_MON_ADD_LABEL_DESCRIPTION_SV,
IDGS_MON_ADD_LABEL_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_MEMSPACE_P_LABEL,
IDGS_RP_MEMSPACE_P_LABEL_DA,
IDGS_RP_MEMSPACE_P_LABEL_DE,
IDGS_RP_MEMSPACE_P_LABEL_FR,
IDGS_RP_MEMSPACE_P_LABEL_HU,
IDGS_RP_MEMSPACE_P_LABEL_IT,
IDGS_RP_MEMSPACE_P_LABEL_NL,
IDGS_RP_MEMSPACE_P_LABEL_PL,
IDGS_RP_MEMSPACE_P_LABEL_SV,
IDGS_RP_MEMSPACE_P_LABEL_TR,

/* monitor/mon_command.c */
IDGS_MON_DELETE_LABEL_DESCRIPTION,
IDGS_MON_DELETE_LABEL_DESCRIPTION_DA,
IDGS_MON_DELETE_LABEL_DESCRIPTION_DE,
IDGS_MON_DELETE_LABEL_DESCRIPTION_FR,
IDGS_MON_DELETE_LABEL_DESCRIPTION_HU,
IDGS_MON_DELETE_LABEL_DESCRIPTION_IT,
IDGS_MON_DELETE_LABEL_DESCRIPTION_NL,
IDGS_MON_DELETE_LABEL_DESCRIPTION_PL,
IDGS_MON_DELETE_LABEL_DESCRIPTION_SV,
IDGS_MON_DELETE_LABEL_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_MEMSPACE_QP_FILENAME,
IDGS_RP_MEMSPACE_QP_FILENAME_DA,
IDGS_RP_MEMSPACE_QP_FILENAME_DE,
IDGS_RP_MEMSPACE_QP_FILENAME_FR,
IDGS_RP_MEMSPACE_QP_FILENAME_HU,
IDGS_RP_MEMSPACE_QP_FILENAME_IT,
IDGS_RP_MEMSPACE_QP_FILENAME_NL,
IDGS_RP_MEMSPACE_QP_FILENAME_PL,
IDGS_RP_MEMSPACE_QP_FILENAME_SV,
IDGS_RP_MEMSPACE_QP_FILENAME_TR,

/* monitor/mon_command.c */
IDGS_MON_LOAD_LABELS_DESCRIPTION,
IDGS_MON_LOAD_LABELS_DESCRIPTION_DA,
IDGS_MON_LOAD_LABELS_DESCRIPTION_DE,
IDGS_MON_LOAD_LABELS_DESCRIPTION_FR,
IDGS_MON_LOAD_LABELS_DESCRIPTION_HU,
IDGS_MON_LOAD_LABELS_DESCRIPTION_IT,
IDGS_MON_LOAD_LABELS_DESCRIPTION_NL,
IDGS_MON_LOAD_LABELS_DESCRIPTION_PL,
IDGS_MON_LOAD_LABELS_DESCRIPTION_SV,
IDGS_MON_LOAD_LABELS_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_SAVE_LABELS_DESCRIPTION,
IDGS_MON_SAVE_LABELS_DESCRIPTION_DA,
IDGS_MON_SAVE_LABELS_DESCRIPTION_DE,
IDGS_MON_SAVE_LABELS_DESCRIPTION_FR,
IDGS_MON_SAVE_LABELS_DESCRIPTION_HU,
IDGS_MON_SAVE_LABELS_DESCRIPTION_IT,
IDGS_MON_SAVE_LABELS_DESCRIPTION_NL,
IDGS_MON_SAVE_LABELS_DESCRIPTION_PL,
IDGS_MON_SAVE_LABELS_DESCRIPTION_SV,
IDGS_MON_SAVE_LABELS_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_MEMSPACE,
IDGS_RP_MEMSPACE_DA,
IDGS_RP_MEMSPACE_DE,
IDGS_RP_MEMSPACE_FR,
IDGS_RP_MEMSPACE_HU,
IDGS_RP_MEMSPACE_IT,
IDGS_RP_MEMSPACE_NL,
IDGS_RP_MEMSPACE_PL,
IDGS_RP_MEMSPACE_SV,
IDGS_RP_MEMSPACE_TR,

/* monitor/mon_command.c */
IDGS_MON_SHOW_LABELS_DESCRIPTION,
IDGS_MON_SHOW_LABELS_DESCRIPTION_DA,
IDGS_MON_SHOW_LABELS_DESCRIPTION_DE,
IDGS_MON_SHOW_LABELS_DESCRIPTION_FR,
IDGS_MON_SHOW_LABELS_DESCRIPTION_HU,
IDGS_MON_SHOW_LABELS_DESCRIPTION_IT,
IDGS_MON_SHOW_LABELS_DESCRIPTION_NL,
IDGS_MON_SHOW_LABELS_DESCRIPTION_PL,
IDGS_MON_SHOW_LABELS_DESCRIPTION_SV,
IDGS_MON_SHOW_LABELS_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DA,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_DE,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_FR,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_HU,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_IT,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_NL,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_PL,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_SV,
IDGS_ASSEMBLER_AND_MEMORY_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_RP_ADDRESS_P_DATA_LIST,
IDGS_RP_ADDRESS_P_DATA_LIST_DA,
IDGS_RP_ADDRESS_P_DATA_LIST_DE,
IDGS_RP_ADDRESS_P_DATA_LIST_FR,
IDGS_RP_ADDRESS_P_DATA_LIST_HU,
IDGS_RP_ADDRESS_P_DATA_LIST_IT,
IDGS_RP_ADDRESS_P_DATA_LIST_NL,
IDGS_RP_ADDRESS_P_DATA_LIST_PL,
IDGS_RP_ADDRESS_P_DATA_LIST_SV,
IDGS_RP_ADDRESS_P_DATA_LIST_TR,

/* monitor/mon_command.c */
IDGS_MON_WRITE_DESCRIPTION,
IDGS_MON_WRITE_DESCRIPTION_DA,
IDGS_MON_WRITE_DESCRIPTION_DE,
IDGS_MON_WRITE_DESCRIPTION_FR,
IDGS_MON_WRITE_DESCRIPTION_HU,
IDGS_MON_WRITE_DESCRIPTION_IT,
IDGS_MON_WRITE_DESCRIPTION_NL,
IDGS_MON_WRITE_DESCRIPTION_PL,
IDGS_MON_WRITE_DESCRIPTION_SV,
IDGS_MON_WRITE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_ADDRESS_RP_INSTRUCTION,
IDGS_P_ADDRESS_RP_INSTRUCTION_DA,
IDGS_P_ADDRESS_RP_INSTRUCTION_DE,
IDGS_P_ADDRESS_RP_INSTRUCTION_FR,
IDGS_P_ADDRESS_RP_INSTRUCTION_HU,
IDGS_P_ADDRESS_RP_INSTRUCTION_IT,
IDGS_P_ADDRESS_RP_INSTRUCTION_NL,
IDGS_P_ADDRESS_RP_INSTRUCTION_PL,
IDGS_P_ADDRESS_RP_INSTRUCTION_SV,
IDGS_P_ADDRESS_RP_INSTRUCTION_TR,

/* monitor/mon_command.c */
IDGS_MON_ASSEMBLE_DESCRIPTION,
IDGS_MON_ASSEMBLE_DESCRIPTION_DA,
IDGS_MON_ASSEMBLE_DESCRIPTION_DE,
IDGS_MON_ASSEMBLE_DESCRIPTION_FR,
IDGS_MON_ASSEMBLE_DESCRIPTION_HU,
IDGS_MON_ASSEMBLE_DESCRIPTION_IT,
IDGS_MON_ASSEMBLE_DESCRIPTION_NL,
IDGS_MON_ASSEMBLE_DESCRIPTION_PL,
IDGS_MON_ASSEMBLE_DESCRIPTION_SV,
IDGS_MON_ASSEMBLE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_ADDRESS_RANGE_P_ADDRESS,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_DA,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_DE,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_FR,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_HU,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_IT,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_NL,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_PL,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_SV,
IDGS_P_ADDRESS_RANGE_P_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_COMPARE_DESCRIPTION,
IDGS_MON_COMPARE_DESCRIPTION_DA,
IDGS_MON_COMPARE_DESCRIPTION_DE,
IDGS_MON_COMPARE_DESCRIPTION_FR,
IDGS_MON_COMPARE_DESCRIPTION_HU,
IDGS_MON_COMPARE_DESCRIPTION_IT,
IDGS_MON_COMPARE_DESCRIPTION_NL,
IDGS_MON_COMPARE_DESCRIPTION_PL,
IDGS_MON_COMPARE_DESCRIPTION_SV,
IDGS_MON_COMPARE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_CHECKNUM,
IDGS_P_CHECKNUM_DA,
IDGS_P_CHECKNUM_DE,
IDGS_P_CHECKNUM_FR,
IDGS_P_CHECKNUM_HU,
IDGS_P_CHECKNUM_IT,
IDGS_P_CHECKNUM_NL,
IDGS_P_CHECKNUM_PL,
IDGS_P_CHECKNUM_SV,
IDGS_P_CHECKNUM_TR,

/* monitor/mon_command.c */
IDGS_MON_DELETE_DESCRIPTION,
IDGS_MON_DELETE_DESCRIPTION_DA,
IDGS_MON_DELETE_DESCRIPTION_DE,
IDGS_MON_DELETE_DESCRIPTION_FR,
IDGS_MON_DELETE_DESCRIPTION_HU,
IDGS_MON_DELETE_DESCRIPTION_IT,
IDGS_MON_DELETE_DESCRIPTION_NL,
IDGS_MON_DELETE_DESCRIPTION_PL,
IDGS_MON_DELETE_DESCRIPTION_SV,
IDGS_MON_DELETE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_ADDRESS_RP_ADDRESS,
IDGS_RP_ADDRESS_RP_ADDRESS_DA,
IDGS_RP_ADDRESS_RP_ADDRESS_DE,
IDGS_RP_ADDRESS_RP_ADDRESS_FR,
IDGS_RP_ADDRESS_RP_ADDRESS_HU,
IDGS_RP_ADDRESS_RP_ADDRESS_IT,
IDGS_RP_ADDRESS_RP_ADDRESS_NL,
IDGS_RP_ADDRESS_RP_ADDRESS_PL,
IDGS_RP_ADDRESS_RP_ADDRESS_SV,
IDGS_RP_ADDRESS_RP_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_DISASS_DESCRIPTION,
IDGS_MON_DISASS_DESCRIPTION_DA,
IDGS_MON_DISASS_DESCRIPTION_DE,
IDGS_MON_DISASS_DESCRIPTION_FR,
IDGS_MON_DISASS_DESCRIPTION_HU,
IDGS_MON_DISASS_DESCRIPTION_IT,
IDGS_MON_DISASS_DESCRIPTION_NL,
IDGS_MON_DISASS_DESCRIPTION_PL,
IDGS_MON_DISASS_DESCRIPTION_SV,
IDGS_MON_DISASS_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_ADDRESS_RANGE_P_DATA_LIST,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_DA,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_DE,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_FR,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_HU,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_IT,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_NL,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_PL,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_SV,
IDGS_P_ADDRESS_RANGE_P_DATA_LIST_TR,

/* monitor/mon_command.c */
IDGS_MON_FILL_DESCRIPTION,
IDGS_MON_FILL_DESCRIPTION_DA,
IDGS_MON_FILL_DESCRIPTION_DE,
IDGS_MON_FILL_DESCRIPTION_FR,
IDGS_MON_FILL_DESCRIPTION_HU,
IDGS_MON_FILL_DESCRIPTION_IT,
IDGS_MON_FILL_DESCRIPTION_NL,
IDGS_MON_FILL_DESCRIPTION_PL,
IDGS_MON_FILL_DESCRIPTION_SV,
IDGS_MON_FILL_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_HUNT_DESCRIPTION,
IDGS_MON_HUNT_DESCRIPTION_DA,
IDGS_MON_HUNT_DESCRIPTION_DE,
IDGS_MON_HUNT_DESCRIPTION_FR,
IDGS_MON_HUNT_DESCRIPTION_HU,
IDGS_MON_HUNT_DESCRIPTION_IT,
IDGS_MON_HUNT_DESCRIPTION_NL,
IDGS_MON_HUNT_DESCRIPTION_PL,
IDGS_MON_HUNT_DESCRIPTION_SV,
IDGS_MON_HUNT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_ADDRESS_OPT_RANGE,
IDGS_P_ADDRESS_OPT_RANGE_DA,
IDGS_P_ADDRESS_OPT_RANGE_DE,
IDGS_P_ADDRESS_OPT_RANGE_FR,
IDGS_P_ADDRESS_OPT_RANGE_HU,
IDGS_P_ADDRESS_OPT_RANGE_IT,
IDGS_P_ADDRESS_OPT_RANGE_NL,
IDGS_P_ADDRESS_OPT_RANGE_PL,
IDGS_P_ADDRESS_OPT_RANGE_SV,
IDGS_P_ADDRESS_OPT_RANGE_TR,

/* monitor/mon_command.c */
IDGS_MON_I_DESCRIPTION,
IDGS_MON_I_DESCRIPTION_DA,
IDGS_MON_I_DESCRIPTION_DE,
IDGS_MON_I_DESCRIPTION_FR,
IDGS_MON_I_DESCRIPTION_HU,
IDGS_MON_I_DESCRIPTION_IT,
IDGS_MON_I_DESCRIPTION_NL,
IDGS_MON_I_DESCRIPTION_PL,
IDGS_MON_I_DESCRIPTION_SV,
IDGS_MON_I_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_II_DESCRIPTION,
IDGS_MON_II_DESCRIPTION_DA,
IDGS_MON_II_DESCRIPTION_DE,
IDGS_MON_II_DESCRIPTION_FR,
IDGS_MON_II_DESCRIPTION_HU,
IDGS_MON_II_DESCRIPTION_IT,
IDGS_MON_II_DESCRIPTION_NL,
IDGS_MON_II_DESCRIPTION_PL,
IDGS_MON_II_DESCRIPTION_SV,
IDGS_MON_II_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_DA,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_DE,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_FR,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_HU,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_IT,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_NL,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_PL,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_SV,
IDGS_RP_DATA_TYPE_RP_ADDRESS_OPT_RANGE_TR,

/* monitor/mon_command.c */
IDGS_MON_MEM_DESCRIPTION,
IDGS_MON_MEM_DESCRIPTION_DA,
IDGS_MON_MEM_DESCRIPTION_DE,
IDGS_MON_MEM_DESCRIPTION_FR,
IDGS_MON_MEM_DESCRIPTION_HU,
IDGS_MON_MEM_DESCRIPTION_IT,
IDGS_MON_MEM_DESCRIPTION_NL,
IDGS_MON_MEM_DESCRIPTION_PL,
IDGS_MON_MEM_DESCRIPTION_SV,
IDGS_MON_MEM_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_MEMCHAR_DESCRIPTION,
IDGS_MON_MEMCHAR_DESCRIPTION_DA,
IDGS_MON_MEMCHAR_DESCRIPTION_DE,
IDGS_MON_MEMCHAR_DESCRIPTION_FR,
IDGS_MON_MEMCHAR_DESCRIPTION_HU,
IDGS_MON_MEMCHAR_DESCRIPTION_IT,
IDGS_MON_MEMCHAR_DESCRIPTION_NL,
IDGS_MON_MEMCHAR_DESCRIPTION_PL,
IDGS_MON_MEMCHAR_DESCRIPTION_SV,
IDGS_MON_MEMCHAR_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME_P_FORMAT,
IDGS_QP_FILENAME_P_FORMAT_DA,
IDGS_QP_FILENAME_P_FORMAT_DE,
IDGS_QP_FILENAME_P_FORMAT_FR,
IDGS_QP_FILENAME_P_FORMAT_HU,
IDGS_QP_FILENAME_P_FORMAT_IT,
IDGS_QP_FILENAME_P_FORMAT_NL,
IDGS_QP_FILENAME_P_FORMAT_PL,
IDGS_QP_FILENAME_P_FORMAT_SV,
IDGS_QP_FILENAME_P_FORMAT_TR,

/* monitor/mon_command.c */
IDGS_MON_MEMMAPSAVE_DESCRIPTION,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_DA,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_DE,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_FR,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_HU,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_IT,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_NL,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_PL,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_SV,
IDGS_MON_MEMMAPSAVE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_DA,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_DE,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_FR,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_HU,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_IT,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_NL,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_PL,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_SV,
IDGS_RP_MASK_RP_ADDRESS_OPT_RANGE_TR,

/* monitor/mon_command.c */
IDGS_MON_MEMMAPSHOW_DESCRIPTION,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_DA,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_DE,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_FR,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_HU,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_IT,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_NL,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_PL,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_SV,
IDGS_MON_MEMMAPSHOW_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_MEMMAPZAP_DESCRIPTION,
IDGS_MON_MEMMAPZAP_DESCRIPTION_DA,
IDGS_MON_MEMMAPZAP_DESCRIPTION_DE,
IDGS_MON_MEMMAPZAP_DESCRIPTION_FR,
IDGS_MON_MEMMAPZAP_DESCRIPTION_HU,
IDGS_MON_MEMMAPZAP_DESCRIPTION_IT,
IDGS_MON_MEMMAPZAP_DESCRIPTION_NL,
IDGS_MON_MEMMAPZAP_DESCRIPTION_PL,
IDGS_MON_MEMMAPZAP_DESCRIPTION_SV,
IDGS_MON_MEMMAPZAP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_MEMSPRITE_DESCRIPTION,
IDGS_MON_MEMSPRITE_DESCRIPTION_DA,
IDGS_MON_MEMSPRITE_DESCRIPTION_DE,
IDGS_MON_MEMSPRITE_DESCRIPTION_FR,
IDGS_MON_MEMSPRITE_DESCRIPTION_HU,
IDGS_MON_MEMSPRITE_DESCRIPTION_IT,
IDGS_MON_MEMSPRITE_DESCRIPTION_NL,
IDGS_MON_MEMSPRITE_DESCRIPTION_PL,
IDGS_MON_MEMSPRITE_DESCRIPTION_SV,
IDGS_MON_MEMSPRITE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_MOVE_DESCRIPTION,
IDGS_MON_MOVE_DESCRIPTION_DA,
IDGS_MON_MOVE_DESCRIPTION_DE,
IDGS_MON_MOVE_DESCRIPTION_FR,
IDGS_MON_MOVE_DESCRIPTION_HU,
IDGS_MON_MOVE_DESCRIPTION_IT,
IDGS_MON_MOVE_DESCRIPTION_NL,
IDGS_MON_MOVE_DESCRIPTION_PL,
IDGS_MON_MOVE_DESCRIPTION_SV,
IDGS_MON_MOVE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_CHECKPOINT_COMMANDS,
IDGS_CHECKPOINT_COMMANDS_DA,
IDGS_CHECKPOINT_COMMANDS_DE,
IDGS_CHECKPOINT_COMMANDS_FR,
IDGS_CHECKPOINT_COMMANDS_HU,
IDGS_CHECKPOINT_COMMANDS_IT,
IDGS_CHECKPOINT_COMMANDS_NL,
IDGS_CHECKPOINT_COMMANDS_PL,
IDGS_CHECKPOINT_COMMANDS_SV,
IDGS_CHECKPOINT_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_RP_ADDRESS_RP_COND_EXPR,
IDGS_RP_ADDRESS_RP_COND_EXPR_DA,
IDGS_RP_ADDRESS_RP_COND_EXPR_DE,
IDGS_RP_ADDRESS_RP_COND_EXPR_FR,
IDGS_RP_ADDRESS_RP_COND_EXPR_HU,
IDGS_RP_ADDRESS_RP_COND_EXPR_IT,
IDGS_RP_ADDRESS_RP_COND_EXPR_NL,
IDGS_RP_ADDRESS_RP_COND_EXPR_PL,
IDGS_RP_ADDRESS_RP_COND_EXPR_SV,
IDGS_RP_ADDRESS_RP_COND_EXPR_TR,

/* monitor/mon_command.c */
IDGS_MON_BREAK_DESCRIPTION,
IDGS_MON_BREAK_DESCRIPTION_DA,
IDGS_MON_BREAK_DESCRIPTION_DE,
IDGS_MON_BREAK_DESCRIPTION_FR,
IDGS_MON_BREAK_DESCRIPTION_HU,
IDGS_MON_BREAK_DESCRIPTION_IT,
IDGS_MON_BREAK_DESCRIPTION_NL,
IDGS_MON_BREAK_DESCRIPTION_PL,
IDGS_MON_BREAK_DESCRIPTION_SV,
IDGS_MON_BREAK_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_CHECKNUM_QP_COMMAND,
IDGS_P_CHECKNUM_QP_COMMAND_DA,
IDGS_P_CHECKNUM_QP_COMMAND_DE,
IDGS_P_CHECKNUM_QP_COMMAND_FR,
IDGS_P_CHECKNUM_QP_COMMAND_HU,
IDGS_P_CHECKNUM_QP_COMMAND_IT,
IDGS_P_CHECKNUM_QP_COMMAND_NL,
IDGS_P_CHECKNUM_QP_COMMAND_PL,
IDGS_P_CHECKNUM_QP_COMMAND_SV,
IDGS_P_CHECKNUM_QP_COMMAND_TR,

/* monitor/mon_command.c */
IDGS_MON_COMMAND_DESCRIPTION,
IDGS_MON_COMMAND_DESCRIPTION_DA,
IDGS_MON_COMMAND_DESCRIPTION_DE,
IDGS_MON_COMMAND_DESCRIPTION_FR,
IDGS_MON_COMMAND_DESCRIPTION_HU,
IDGS_MON_COMMAND_DESCRIPTION_IT,
IDGS_MON_COMMAND_DESCRIPTION_NL,
IDGS_MON_COMMAND_DESCRIPTION_PL,
IDGS_MON_COMMAND_DESCRIPTION_SV,
IDGS_MON_COMMAND_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_CHECKNUM_IF_P_COND_EXPR,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_DA,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_DE,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_FR,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_HU,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_IT,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_NL,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_PL,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_SV,
IDGS_P_CHECKNUM_IF_P_COND_EXPR_TR,

/* monitor/mon_command.c */
IDGS_MON_CONDITION_DESCRIPTION,
IDGS_MON_CONDITION_DESCRIPTION_DA,
IDGS_MON_CONDITION_DESCRIPTION_DE,
IDGS_MON_CONDITION_DESCRIPTION_FR,
IDGS_MON_CONDITION_DESCRIPTION_HU,
IDGS_MON_CONDITION_DESCRIPTION_IT,
IDGS_MON_CONDITION_DESCRIPTION_NL,
IDGS_MON_CONDITION_DESCRIPTION_PL,
IDGS_MON_CONDITION_DESCRIPTION_SV,
IDGS_MON_CONDITION_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_DISABLE_DESCRIPTION,
IDGS_MON_DISABLE_DESCRIPTION_DA,
IDGS_MON_DISABLE_DESCRIPTION_DE,
IDGS_MON_DISABLE_DESCRIPTION_FR,
IDGS_MON_DISABLE_DESCRIPTION_HU,
IDGS_MON_DISABLE_DESCRIPTION_IT,
IDGS_MON_DISABLE_DESCRIPTION_NL,
IDGS_MON_DISABLE_DESCRIPTION_PL,
IDGS_MON_DISABLE_DESCRIPTION_SV,
IDGS_MON_DISABLE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_ENABLE_DESCRIPTION,
IDGS_MON_ENABLE_DESCRIPTION_DA,
IDGS_MON_ENABLE_DESCRIPTION_DE,
IDGS_MON_ENABLE_DESCRIPTION_FR,
IDGS_MON_ENABLE_DESCRIPTION_HU,
IDGS_MON_ENABLE_DESCRIPTION_IT,
IDGS_MON_ENABLE_DESCRIPTION_NL,
IDGS_MON_ENABLE_DESCRIPTION_PL,
IDGS_MON_ENABLE_DESCRIPTION_SV,
IDGS_MON_ENABLE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_CHECKNUM_RP_COUNT,
IDGS_P_CHECKNUM_RP_COUNT_DA,
IDGS_P_CHECKNUM_RP_COUNT_DE,
IDGS_P_CHECKNUM_RP_COUNT_FR,
IDGS_P_CHECKNUM_RP_COUNT_HU,
IDGS_P_CHECKNUM_RP_COUNT_IT,
IDGS_P_CHECKNUM_RP_COUNT_NL,
IDGS_P_CHECKNUM_RP_COUNT_PL,
IDGS_P_CHECKNUM_RP_COUNT_SV,
IDGS_P_CHECKNUM_RP_COUNT_TR,

/* monitor/mon_command.c */
IDGS_MON_IGNORE_DESCRIPTION,
IDGS_MON_IGNORE_DESCRIPTION_DA,
IDGS_MON_IGNORE_DESCRIPTION_DE,
IDGS_MON_IGNORE_DESCRIPTION_FR,
IDGS_MON_IGNORE_DESCRIPTION_HU,
IDGS_MON_IGNORE_DESCRIPTION_IT,
IDGS_MON_IGNORE_DESCRIPTION_NL,
IDGS_MON_IGNORE_DESCRIPTION_PL,
IDGS_MON_IGNORE_DESCRIPTION_SV,
IDGS_MON_IGNORE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_ADDRESS,
IDGS_RP_ADDRESS_DA,
IDGS_RP_ADDRESS_DE,
IDGS_RP_ADDRESS_FR,
IDGS_RP_ADDRESS_HU,
IDGS_RP_ADDRESS_IT,
IDGS_RP_ADDRESS_NL,
IDGS_RP_ADDRESS_PL,
IDGS_RP_ADDRESS_SV,
IDGS_RP_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_UNTIL_DESCRIPTION,
IDGS_MON_UNTIL_DESCRIPTION_DA,
IDGS_MON_UNTIL_DESCRIPTION_DE,
IDGS_MON_UNTIL_DESCRIPTION_FR,
IDGS_MON_UNTIL_DESCRIPTION_HU,
IDGS_MON_UNTIL_DESCRIPTION_IT,
IDGS_MON_UNTIL_DESCRIPTION_NL,
IDGS_MON_UNTIL_DESCRIPTION_PL,
IDGS_MON_UNTIL_DESCRIPTION_SV,
IDGS_MON_UNTIL_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_DA,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_DE,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_FR,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_HU,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_IT,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_NL,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_PL,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_SV,
IDGS_R_LOADSTORE_R_ADDRESS_R_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_WATCH_DESCRIPTION,
IDGS_MON_WATCH_DESCRIPTION_DA,
IDGS_MON_WATCH_DESCRIPTION_DE,
IDGS_MON_WATCH_DESCRIPTION_FR,
IDGS_MON_WATCH_DESCRIPTION_HU,
IDGS_MON_WATCH_DESCRIPTION_IT,
IDGS_MON_WATCH_DESCRIPTION_NL,
IDGS_MON_WATCH_DESCRIPTION_PL,
IDGS_MON_WATCH_DESCRIPTION_SV,
IDGS_MON_WATCH_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_R_ADDRESS_R_ADDRESS,
IDGS_R_ADDRESS_R_ADDRESS_DA,
IDGS_R_ADDRESS_R_ADDRESS_DE,
IDGS_R_ADDRESS_R_ADDRESS_FR,
IDGS_R_ADDRESS_R_ADDRESS_HU,
IDGS_R_ADDRESS_R_ADDRESS_IT,
IDGS_R_ADDRESS_R_ADDRESS_NL,
IDGS_R_ADDRESS_R_ADDRESS_PL,
IDGS_R_ADDRESS_R_ADDRESS_SV,
IDGS_R_ADDRESS_R_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_TRACE_DESCRIPTION,
IDGS_MON_TRACE_DESCRIPTION_DA,
IDGS_MON_TRACE_DESCRIPTION_DE,
IDGS_MON_TRACE_DESCRIPTION_FR,
IDGS_MON_TRACE_DESCRIPTION_HU,
IDGS_MON_TRACE_DESCRIPTION_IT,
IDGS_MON_TRACE_DESCRIPTION_NL,
IDGS_MON_TRACE_DESCRIPTION_PL,
IDGS_MON_TRACE_DESCRIPTION_SV,
IDGS_MON_TRACE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MONITOR_STATE_COMMANDS,
IDGS_MONITOR_STATE_COMMANDS_DA,
IDGS_MONITOR_STATE_COMMANDS_DE,
IDGS_MONITOR_STATE_COMMANDS_FR,
IDGS_MONITOR_STATE_COMMANDS_HU,
IDGS_MONITOR_STATE_COMMANDS_IT,
IDGS_MONITOR_STATE_COMMANDS_NL,
IDGS_MONITOR_STATE_COMMANDS_PL,
IDGS_MONITOR_STATE_COMMANDS_SV,
IDGS_MONITOR_STATE_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_MON_DEVICE_DESCRIPTION,
IDGS_MON_DEVICE_DESCRIPTION_DA,
IDGS_MON_DEVICE_DESCRIPTION_DE,
IDGS_MON_DEVICE_DESCRIPTION_FR,
IDGS_MON_DEVICE_DESCRIPTION_HU,
IDGS_MON_DEVICE_DESCRIPTION_IT,
IDGS_MON_DEVICE_DESCRIPTION_NL,
IDGS_MON_DEVICE_DESCRIPTION_PL,
IDGS_MON_DEVICE_DESCRIPTION_SV,
IDGS_MON_DEVICE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_EXIT_DESCRIPTION,
IDGS_MON_EXIT_DESCRIPTION_DA,
IDGS_MON_EXIT_DESCRIPTION_DE,
IDGS_MON_EXIT_DESCRIPTION_FR,
IDGS_MON_EXIT_DESCRIPTION_HU,
IDGS_MON_EXIT_DESCRIPTION_IT,
IDGS_MON_EXIT_DESCRIPTION_NL,
IDGS_MON_EXIT_DESCRIPTION_PL,
IDGS_MON_EXIT_DESCRIPTION_SV,
IDGS_MON_EXIT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_QUIT_DESCRIPTION,
IDGS_MON_QUIT_DESCRIPTION_DA,
IDGS_MON_QUIT_DESCRIPTION_DE,
IDGS_MON_QUIT_DESCRIPTION_FR,
IDGS_MON_QUIT_DESCRIPTION_HU,
IDGS_MON_QUIT_DESCRIPTION_IT,
IDGS_MON_QUIT_DESCRIPTION_NL,
IDGS_MON_QUIT_DESCRIPTION_PL,
IDGS_MON_QUIT_DESCRIPTION_SV,
IDGS_MON_QUIT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_RADIX_DESCRIPTION,
IDGS_MON_RADIX_DESCRIPTION_DA,
IDGS_MON_RADIX_DESCRIPTION_DE,
IDGS_MON_RADIX_DESCRIPTION_FR,
IDGS_MON_RADIX_DESCRIPTION_HU,
IDGS_MON_RADIX_DESCRIPTION_IT,
IDGS_MON_RADIX_DESCRIPTION_NL,
IDGS_MON_RADIX_DESCRIPTION_PL,
IDGS_MON_RADIX_DESCRIPTION_SV,
IDGS_MON_RADIX_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_R_ON_R_OFF_R_TOGGLE,
IDGS_R_ON_R_OFF_R_TOGGLE_DA,
IDGS_R_ON_R_OFF_R_TOGGLE_DE,
IDGS_R_ON_R_OFF_R_TOGGLE_FR,
IDGS_R_ON_R_OFF_R_TOGGLE_HU,
IDGS_R_ON_R_OFF_R_TOGGLE_IT,
IDGS_R_ON_R_OFF_R_TOGGLE_NL,
IDGS_R_ON_R_OFF_R_TOGGLE_PL,
IDGS_R_ON_R_OFF_R_TOGGLE_SV,
IDGS_R_ON_R_OFF_R_TOGGLE_TR,

/* monitor/mon_command.c */
IDGS_MON_SIDEFX_DESCRIPTION,
IDGS_MON_SIDEFX_DESCRIPTION_DA,
IDGS_MON_SIDEFX_DESCRIPTION_DE,
IDGS_MON_SIDEFX_DESCRIPTION_FR,
IDGS_MON_SIDEFX_DESCRIPTION_HU,
IDGS_MON_SIDEFX_DESCRIPTION_IT,
IDGS_MON_SIDEFX_DESCRIPTION_NL,
IDGS_MON_SIDEFX_DESCRIPTION_PL,
IDGS_MON_SIDEFX_DESCRIPTION_SV,
IDGS_MON_SIDEFX_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_DISK_COMMANDS,
IDGS_DISK_COMMANDS_DA,
IDGS_DISK_COMMANDS_DE,
IDGS_DISK_COMMANDS_FR,
IDGS_DISK_COMMANDS_HU,
IDGS_DISK_COMMANDS_IT,
IDGS_DISK_COMMANDS_NL,
IDGS_DISK_COMMANDS_PL,
IDGS_DISK_COMMANDS_SV,
IDGS_DISK_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_P_DISK_COMMAND,
IDGS_P_DISK_COMMAND_DA,
IDGS_P_DISK_COMMAND_DE,
IDGS_P_DISK_COMMAND_FR,
IDGS_P_DISK_COMMAND_HU,
IDGS_P_DISK_COMMAND_IT,
IDGS_P_DISK_COMMAND_NL,
IDGS_P_DISK_COMMAND_PL,
IDGS_P_DISK_COMMAND_SV,
IDGS_P_DISK_COMMAND_TR,

/* monitor/mon_command.c */
IDGS_MON_AT_DESCRIPTION,
IDGS_MON_AT_DESCRIPTION_DA,
IDGS_MON_AT_DESCRIPTION_DE,
IDGS_MON_AT_DESCRIPTION_FR,
IDGS_MON_AT_DESCRIPTION_HU,
IDGS_MON_AT_DESCRIPTION_IT,
IDGS_MON_AT_DESCRIPTION_NL,
IDGS_MON_AT_DESCRIPTION_PL,
IDGS_MON_AT_DESCRIPTION_SV,
IDGS_MON_AT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_FILENAME_P_DEVICE,
IDGS_P_FILENAME_P_DEVICE_DA,
IDGS_P_FILENAME_P_DEVICE_DE,
IDGS_P_FILENAME_P_DEVICE_FR,
IDGS_P_FILENAME_P_DEVICE_HU,
IDGS_P_FILENAME_P_DEVICE_IT,
IDGS_P_FILENAME_P_DEVICE_NL,
IDGS_P_FILENAME_P_DEVICE_PL,
IDGS_P_FILENAME_P_DEVICE_SV,
IDGS_P_FILENAME_P_DEVICE_TR,

/* monitor/mon_command.c */
IDGS_MON_ATTACH_DESCRIPTION,
IDGS_MON_ATTACH_DESCRIPTION_DA,
IDGS_MON_ATTACH_DESCRIPTION_DE,
IDGS_MON_ATTACH_DESCRIPTION_FR,
IDGS_MON_ATTACH_DESCRIPTION_HU,
IDGS_MON_ATTACH_DESCRIPTION_IT,
IDGS_MON_ATTACH_DESCRIPTION_NL,
IDGS_MON_ATTACH_DESCRIPTION_PL,
IDGS_MON_ATTACH_DESCRIPTION_SV,
IDGS_MON_ATTACH_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_DA,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_DE,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_FR,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_HU,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_IT,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_NL,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_PL,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_SV,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_BLOAD_DESCRIPTION,
IDGS_MON_BLOAD_DESCRIPTION_DA,
IDGS_MON_BLOAD_DESCRIPTION_DE,
IDGS_MON_BLOAD_DESCRIPTION_FR,
IDGS_MON_BLOAD_DESCRIPTION_HU,
IDGS_MON_BLOAD_DESCRIPTION_IT,
IDGS_MON_BLOAD_DESCRIPTION_NL,
IDGS_MON_BLOAD_DESCRIPTION_PL,
IDGS_MON_BLOAD_DESCRIPTION_SV,
IDGS_MON_BLOAD_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_DA,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_DE,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_FR,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_HU,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_IT,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_NL,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_PL,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_SV,
IDGS_P_TRACK_P_SECTOR_RP_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_BLOCK_READ_DESCRIPTION,
IDGS_MON_BLOCK_READ_DESCRIPTION_DA,
IDGS_MON_BLOCK_READ_DESCRIPTION_DE,
IDGS_MON_BLOCK_READ_DESCRIPTION_FR,
IDGS_MON_BLOCK_READ_DESCRIPTION_HU,
IDGS_MON_BLOCK_READ_DESCRIPTION_IT,
IDGS_MON_BLOCK_READ_DESCRIPTION_NL,
IDGS_MON_BLOCK_READ_DESCRIPTION_PL,
IDGS_MON_BLOCK_READ_DESCRIPTION_SV,
IDGS_MON_BLOCK_READ_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_DA,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_DE,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_FR,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_HU,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_IT,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_NL,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_PL,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_SV,
IDGS_QP_FILENAME_P_DEVICE_P_ADDRESS1_P_ADDRESS2_TR,

/* monitor/mon_command.c */
IDGS_MON_BSAVE_DESCRIPTION,
IDGS_MON_BSAVE_DESCRIPTION_DA,
IDGS_MON_BSAVE_DESCRIPTION_DE,
IDGS_MON_BSAVE_DESCRIPTION_FR,
IDGS_MON_BSAVE_DESCRIPTION_HU,
IDGS_MON_BSAVE_DESCRIPTION_IT,
IDGS_MON_BSAVE_DESCRIPTION_NL,
IDGS_MON_BSAVE_DESCRIPTION_PL,
IDGS_MON_BSAVE_DESCRIPTION_SV,
IDGS_MON_BSAVE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_TRACK_P_SECTOR_P_ADDRESS,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_DA,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_DE,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_FR,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_HU,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_IT,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_NL,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_PL,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_SV,
IDGS_P_TRACK_P_SECTOR_P_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_BLOCK_WRITE_DESCRIPTION,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_DA,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_DE,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_FR,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_HU,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_IT,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_NL,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_PL,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_SV,
IDGS_MON_BLOCK_WRITE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_DIRECTORY,
IDGS_P_DIRECTORY_DA,
IDGS_P_DIRECTORY_DE,
IDGS_P_DIRECTORY_FR,
IDGS_P_DIRECTORY_HU,
IDGS_P_DIRECTORY_IT,
IDGS_P_DIRECTORY_NL,
IDGS_P_DIRECTORY_PL,
IDGS_P_DIRECTORY_SV,
IDGS_P_DIRECTORY_TR,

/* monitor/mon_command.c */
IDGS_MON_CD_DESCRIPTION,
IDGS_MON_CD_DESCRIPTION_DA,
IDGS_MON_CD_DESCRIPTION_DE,
IDGS_MON_CD_DESCRIPTION_FR,
IDGS_MON_CD_DESCRIPTION_HU,
IDGS_MON_CD_DESCRIPTION_IT,
IDGS_MON_CD_DESCRIPTION_NL,
IDGS_MON_CD_DESCRIPTION_PL,
IDGS_MON_CD_DESCRIPTION_SV,
IDGS_MON_CD_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_DETACH_DESCRIPTION,
IDGS_MON_DETACH_DESCRIPTION_DA,
IDGS_MON_DETACH_DESCRIPTION_DE,
IDGS_MON_DETACH_DESCRIPTION_FR,
IDGS_MON_DETACH_DESCRIPTION_HU,
IDGS_MON_DETACH_DESCRIPTION_IT,
IDGS_MON_DETACH_DESCRIPTION_NL,
IDGS_MON_DETACH_DESCRIPTION_PL,
IDGS_MON_DETACH_DESCRIPTION_SV,
IDGS_MON_DETACH_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_DIRECTORY,
IDGS_RP_DIRECTORY_DA,
IDGS_RP_DIRECTORY_DE,
IDGS_RP_DIRECTORY_FR,
IDGS_RP_DIRECTORY_HU,
IDGS_RP_DIRECTORY_IT,
IDGS_RP_DIRECTORY_NL,
IDGS_RP_DIRECTORY_PL,
IDGS_RP_DIRECTORY_SV,
IDGS_RP_DIRECTORY_TR,

/* monitor/mon_command.c */
IDGS_RP_DEVICE,
IDGS_RP_DEVICE_DA,
IDGS_RP_DEVICE_DE,
IDGS_RP_DEVICE_FR,
IDGS_RP_DEVICE_HU,
IDGS_RP_DEVICE_IT,
IDGS_RP_DEVICE_NL,
IDGS_RP_DEVICE_PL,
IDGS_RP_DEVICE_SV,
IDGS_RP_DEVICE_TR,

/* monitor/mon_command.c */
IDGS_MON_DIR_DESCRIPTION,
IDGS_MON_DIR_DESCRIPTION_DA,
IDGS_MON_DIR_DESCRIPTION_DE,
IDGS_MON_DIR_DESCRIPTION_FR,
IDGS_MON_DIR_DESCRIPTION_HU,
IDGS_MON_DIR_DESCRIPTION_IT,
IDGS_MON_DIR_DESCRIPTION_NL,
IDGS_MON_DIR_DESCRIPTION_PL,
IDGS_MON_DIR_DESCRIPTION_SV,
IDGS_MON_DIR_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_LIST_DESCRIPTION,
IDGS_MON_LIST_DESCRIPTION_DA,
IDGS_MON_LIST_DESCRIPTION_DE,
IDGS_MON_LIST_DESCRIPTION_FR,
IDGS_MON_LIST_DESCRIPTION_HU,
IDGS_MON_LIST_DESCRIPTION_IT,
IDGS_MON_LIST_DESCRIPTION_NL,
IDGS_MON_LIST_DESCRIPTION_PL,
IDGS_MON_LIST_DESCRIPTION_SV,
IDGS_MON_LIST_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_DA,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_DE,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_FR,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_HU,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_IT,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_NL,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_PL,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_SV,
IDGS_QP_FILENAME_P_DEVICE_RP_ADDRESS_TR,

/* monitor/mon_command.c */
IDGS_MON_LOAD_DESCRIPTION,
IDGS_MON_LOAD_DESCRIPTION_DA,
IDGS_MON_LOAD_DESCRIPTION_DE,
IDGS_MON_LOAD_DESCRIPTION_FR,
IDGS_MON_LOAD_DESCRIPTION_HU,
IDGS_MON_LOAD_DESCRIPTION_IT,
IDGS_MON_LOAD_DESCRIPTION_NL,
IDGS_MON_LOAD_DESCRIPTION_PL,
IDGS_MON_LOAD_DESCRIPTION_SV,
IDGS_MON_LOAD_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_PWD_DESCRIPTION,
IDGS_MON_PWD_DESCRIPTION_DA,
IDGS_MON_PWD_DESCRIPTION_DE,
IDGS_MON_PWD_DESCRIPTION_FR,
IDGS_MON_PWD_DESCRIPTION_HU,
IDGS_MON_PWD_DESCRIPTION_IT,
IDGS_MON_PWD_DESCRIPTION_NL,
IDGS_MON_PWD_DESCRIPTION_PL,
IDGS_MON_PWD_DESCRIPTION_SV,
IDGS_MON_PWD_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_SAVE_DESCRIPTION,
IDGS_MON_SAVE_DESCRIPTION_DA,
IDGS_MON_SAVE_DESCRIPTION_DE,
IDGS_MON_SAVE_DESCRIPTION_FR,
IDGS_MON_SAVE_DESCRIPTION_HU,
IDGS_MON_SAVE_DESCRIPTION_IT,
IDGS_MON_SAVE_DESCRIPTION_NL,
IDGS_MON_SAVE_DESCRIPTION_PL,
IDGS_MON_SAVE_DESCRIPTION_SV,
IDGS_MON_SAVE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_OTHER_COMMANDS,
IDGS_OTHER_COMMANDS_DA,
IDGS_OTHER_COMMANDS_DE,
IDGS_OTHER_COMMANDS_FR,
IDGS_OTHER_COMMANDS_HU,
IDGS_OTHER_COMMANDS_IT,
IDGS_OTHER_COMMANDS_NL,
IDGS_OTHER_COMMANDS_PL,
IDGS_OTHER_COMMANDS_SV,
IDGS_OTHER_COMMANDS_TR,

/* monitor/mon_command.c */
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DA,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_DE,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_FR,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_HU,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_IT,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_NL,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_PL,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_SV,
IDGS_MON_DISPLAY_NUMBER_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_CARTFREEZE_DESCRIPTION,
IDGS_MON_CARTFREEZE_DESCRIPTION_DA,
IDGS_MON_CARTFREEZE_DESCRIPTION_DE,
IDGS_MON_CARTFREEZE_DESCRIPTION_FR,
IDGS_MON_CARTFREEZE_DESCRIPTION_HU,
IDGS_MON_CARTFREEZE_DESCRIPTION_IT,
IDGS_MON_CARTFREEZE_DESCRIPTION_NL,
IDGS_MON_CARTFREEZE_DESCRIPTION_PL,
IDGS_MON_CARTFREEZE_DESCRIPTION_SV,
IDGS_MON_CARTFREEZE_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_RP_COMMAND,
IDGS_RP_COMMAND_DA,
IDGS_RP_COMMAND_DE,
IDGS_RP_COMMAND_FR,
IDGS_RP_COMMAND_HU,
IDGS_RP_COMMAND_IT,
IDGS_RP_COMMAND_NL,
IDGS_RP_COMMAND_PL,
IDGS_RP_COMMAND_SV,
IDGS_RP_COMMAND_TR,

/* monitor/mon_command.c */
IDGS_MON_HELP_DESCRIPTION,
IDGS_MON_HELP_DESCRIPTION_DA,
IDGS_MON_HELP_DESCRIPTION_DE,
IDGS_MON_HELP_DESCRIPTION_FR,
IDGS_MON_HELP_DESCRIPTION_HU,
IDGS_MON_HELP_DESCRIPTION_IT,
IDGS_MON_HELP_DESCRIPTION_NL,
IDGS_MON_HELP_DESCRIPTION_PL,
IDGS_MON_HELP_DESCRIPTION_SV,
IDGS_MON_HELP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_STRING,
IDGS_QP_STRING_DA,
IDGS_QP_STRING_DE,
IDGS_QP_STRING_FR,
IDGS_QP_STRING_HU,
IDGS_QP_STRING_IT,
IDGS_QP_STRING_NL,
IDGS_QP_STRING_PL,
IDGS_QP_STRING_SV,
IDGS_QP_STRING_TR,

/* monitor/mon_command.c */
IDGS_MON_KEYBUF_DESCRIPTION,
IDGS_MON_KEYBUF_DESCRIPTION_DA,
IDGS_MON_KEYBUF_DESCRIPTION_DE,
IDGS_MON_KEYBUF_DESCRIPTION_FR,
IDGS_MON_KEYBUF_DESCRIPTION_HU,
IDGS_MON_KEYBUF_DESCRIPTION_IT,
IDGS_MON_KEYBUF_DESCRIPTION_NL,
IDGS_MON_KEYBUF_DESCRIPTION_PL,
IDGS_MON_KEYBUF_DESCRIPTION_SV,
IDGS_MON_KEYBUF_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_PLAYBACK_DESCRIPTION,
IDGS_MON_PLAYBACK_DESCRIPTION_DA,
IDGS_MON_PLAYBACK_DESCRIPTION_DE,
IDGS_MON_PLAYBACK_DESCRIPTION_FR,
IDGS_MON_PLAYBACK_DESCRIPTION_HU,
IDGS_MON_PLAYBACK_DESCRIPTION_IT,
IDGS_MON_PLAYBACK_DESCRIPTION_NL,
IDGS_MON_PLAYBACK_DESCRIPTION_PL,
IDGS_MON_PLAYBACK_DESCRIPTION_SV,
IDGS_MON_PLAYBACK_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_EXPRESSION,
IDGS_P_EXPRESSION_DA,
IDGS_P_EXPRESSION_DE,
IDGS_P_EXPRESSION_FR,
IDGS_P_EXPRESSION_HU,
IDGS_P_EXPRESSION_IT,
IDGS_P_EXPRESSION_NL,
IDGS_P_EXPRESSION_PL,
IDGS_P_EXPRESSION_SV,
IDGS_P_EXPRESSION_TR,

/* monitor/mon_command.c */
IDGS_MON_PRINT_DESCRIPTION,
IDGS_MON_PRINT_DESCRIPTION_DA,
IDGS_MON_PRINT_DESCRIPTION_DE,
IDGS_MON_PRINT_DESCRIPTION_FR,
IDGS_MON_PRINT_DESCRIPTION_HU,
IDGS_MON_PRINT_DESCRIPTION_IT,
IDGS_MON_PRINT_DESCRIPTION_NL,
IDGS_MON_PRINT_DESCRIPTION_PL,
IDGS_MON_PRINT_DESCRIPTION_SV,
IDGS_MON_PRINT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_RECORD_DESCRIPTION,
IDGS_MON_RECORD_DESCRIPTION_DA,
IDGS_MON_RECORD_DESCRIPTION_DE,
IDGS_MON_RECORD_DESCRIPTION_FR,
IDGS_MON_RECORD_DESCRIPTION_HU,
IDGS_MON_RECORD_DESCRIPTION_IT,
IDGS_MON_RECORD_DESCRIPTION_NL,
IDGS_MON_RECORD_DESCRIPTION_PL,
IDGS_MON_RECORD_DESCRIPTION_SV,
IDGS_MON_RECORD_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_RESOURCE,
IDGS_QP_RESOURCE_DA,
IDGS_QP_RESOURCE_DE,
IDGS_QP_RESOURCE_FR,
IDGS_QP_RESOURCE_HU,
IDGS_QP_RESOURCE_IT,
IDGS_QP_RESOURCE_NL,
IDGS_QP_RESOURCE_PL,
IDGS_QP_RESOURCE_SV,
IDGS_QP_RESOURCE_TR,

/* monitor/mon_command.c */
IDGS_MON_RESOURCEGET_DESCRIPTION,
IDGS_MON_RESOURCEGET_DESCRIPTION_DA,
IDGS_MON_RESOURCEGET_DESCRIPTION_DE,
IDGS_MON_RESOURCEGET_DESCRIPTION_FR,
IDGS_MON_RESOURCEGET_DESCRIPTION_HU,
IDGS_MON_RESOURCEGET_DESCRIPTION_IT,
IDGS_MON_RESOURCEGET_DESCRIPTION_NL,
IDGS_MON_RESOURCEGET_DESCRIPTION_PL,
IDGS_MON_RESOURCEGET_DESCRIPTION_SV,
IDGS_MON_RESOURCEGET_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_RESOURCE_QP_VALUE,
IDGS_QP_RESOURCE_QP_VALUE_DA,
IDGS_QP_RESOURCE_QP_VALUE_DE,
IDGS_QP_RESOURCE_QP_VALUE_FR,
IDGS_QP_RESOURCE_QP_VALUE_HU,
IDGS_QP_RESOURCE_QP_VALUE_IT,
IDGS_QP_RESOURCE_QP_VALUE_NL,
IDGS_QP_RESOURCE_QP_VALUE_PL,
IDGS_QP_RESOURCE_QP_VALUE_SV,
IDGS_QP_RESOURCE_QP_VALUE_TR,

/* monitor/mon_command.c */
IDGS_MON_RESOURCESET_DESCRIPTION,
IDGS_MON_RESOURCESET_DESCRIPTION_DA,
IDGS_MON_RESOURCESET_DESCRIPTION_DE,
IDGS_MON_RESOURCESET_DESCRIPTION_FR,
IDGS_MON_RESOURCESET_DESCRIPTION_HU,
IDGS_MON_RESOURCESET_DESCRIPTION_IT,
IDGS_MON_RESOURCESET_DESCRIPTION_NL,
IDGS_MON_RESOURCESET_DESCRIPTION_PL,
IDGS_MON_RESOURCESET_DESCRIPTION_SV,
IDGS_MON_RESOURCESET_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_MON_STOP_DESCRIPTION,
IDGS_MON_STOP_DESCRIPTION_DA,
IDGS_MON_STOP_DESCRIPTION_DE,
IDGS_MON_STOP_DESCRIPTION_FR,
IDGS_MON_STOP_DESCRIPTION_HU,
IDGS_MON_STOP_DESCRIPTION_IT,
IDGS_MON_STOP_DESCRIPTION_NL,
IDGS_MON_STOP_DESCRIPTION_PL,
IDGS_MON_STOP_DESCRIPTION_SV,
IDGS_MON_STOP_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_QP_FILENAME_RP_FORMAT,
IDGS_QP_FILENAME_RP_FORMAT_DA,
IDGS_QP_FILENAME_RP_FORMAT_DE,
IDGS_QP_FILENAME_RP_FORMAT_FR,
IDGS_QP_FILENAME_RP_FORMAT_HU,
IDGS_QP_FILENAME_RP_FORMAT_IT,
IDGS_QP_FILENAME_RP_FORMAT_NL,
IDGS_QP_FILENAME_RP_FORMAT_PL,
IDGS_QP_FILENAME_RP_FORMAT_SV,
IDGS_QP_FILENAME_RP_FORMAT_TR,

/* monitor/mon_command.c */
IDGS_MON_SCREENSHOT_DESCRIPTION,
IDGS_MON_SCREENSHOT_DESCRIPTION_DA,
IDGS_MON_SCREENSHOT_DESCRIPTION_DE,
IDGS_MON_SCREENSHOT_DESCRIPTION_FR,
IDGS_MON_SCREENSHOT_DESCRIPTION_HU,
IDGS_MON_SCREENSHOT_DESCRIPTION_IT,
IDGS_MON_SCREENSHOT_DESCRIPTION_NL,
IDGS_MON_SCREENSHOT_DESCRIPTION_PL,
IDGS_MON_SCREENSHOT_DESCRIPTION_SV,
IDGS_MON_SCREENSHOT_DESCRIPTION_TR,

/* monitor/mon_command.c */
IDGS_P_COMMAND,
IDGS_P_COMMAND_DA,
IDGS_P_COMMAND_DE,
IDGS_P_COMMAND_FR,
IDGS_P_COMMAND_HU,
IDGS_P_COMMAND_IT,
IDGS_P_COMMAND_NL,
IDGS_P_COMMAND_PL,
IDGS_P_COMMAND_SV,
IDGS_P_COMMAND_TR,

/* monitor/mon_command.c */
IDGS_MON_TAPECTRL_DESCRIPTION,
IDGS_MON_TAPECTRL_DESCRIPTION_DA,
IDGS_MON_TAPECTRL_DESCRIPTION_DE,
IDGS_MON_TAPECTRL_DESCRIPTION_FR,
IDGS_MON_TAPECTRL_DESCRIPTION_HU,
IDGS_MON_TAPECTRL_DESCRIPTION_IT,
IDGS_MON_TAPECTRL_DESCRIPTION_NL,
IDGS_MON_TAPECTRL_DESCRIPTION_PL,
IDGS_MON_TAPECTRL_DESCRIPTION_SV,
IDGS_MON_TAPECTRL_DESCRIPTION_TR,

/* lightpen.c */
IDCLS_ENABLE_LIGHTPEN_EMULATION,
IDCLS_ENABLE_LIGHTPEN_EMULATION_DA,
IDCLS_ENABLE_LIGHTPEN_EMULATION_DE,
IDCLS_ENABLE_LIGHTPEN_EMULATION_FR,
IDCLS_ENABLE_LIGHTPEN_EMULATION_HU,
IDCLS_ENABLE_LIGHTPEN_EMULATION_IT,
IDCLS_ENABLE_LIGHTPEN_EMULATION_NL,
IDCLS_ENABLE_LIGHTPEN_EMULATION_PL,
IDCLS_ENABLE_LIGHTPEN_EMULATION_SV,
IDCLS_ENABLE_LIGHTPEN_EMULATION_TR,

/* lightpen.c */
IDCLS_DISABLE_LIGHTPEN_EMULATION,
IDCLS_DISABLE_LIGHTPEN_EMULATION_DA,
IDCLS_DISABLE_LIGHTPEN_EMULATION_DE,
IDCLS_DISABLE_LIGHTPEN_EMULATION_FR,
IDCLS_DISABLE_LIGHTPEN_EMULATION_HU,
IDCLS_DISABLE_LIGHTPEN_EMULATION_IT,
IDCLS_DISABLE_LIGHTPEN_EMULATION_NL,
IDCLS_DISABLE_LIGHTPEN_EMULATION_PL,
IDCLS_DISABLE_LIGHTPEN_EMULATION_SV,
IDCLS_DISABLE_LIGHTPEN_EMULATION_TR,

/* lightpen.c */
IDCLS_SET_LIGHTPEN_TYPE,
IDCLS_SET_LIGHTPEN_TYPE_DA,
IDCLS_SET_LIGHTPEN_TYPE_DE,
IDCLS_SET_LIGHTPEN_TYPE_FR,
IDCLS_SET_LIGHTPEN_TYPE_HU,
IDCLS_SET_LIGHTPEN_TYPE_IT,
IDCLS_SET_LIGHTPEN_TYPE_NL,
IDCLS_SET_LIGHTPEN_TYPE_PL,
IDCLS_SET_LIGHTPEN_TYPE_SV,
IDCLS_SET_LIGHTPEN_TYPE_TR,

/* c64/cart/easyflash.c */
IDCLS_ENABLE_EASYFLASH_JUMPER,
IDCLS_ENABLE_EASYFLASH_JUMPER_DA,
IDCLS_ENABLE_EASYFLASH_JUMPER_DE,
IDCLS_ENABLE_EASYFLASH_JUMPER_FR,
IDCLS_ENABLE_EASYFLASH_JUMPER_HU,
IDCLS_ENABLE_EASYFLASH_JUMPER_IT,
IDCLS_ENABLE_EASYFLASH_JUMPER_NL,
IDCLS_ENABLE_EASYFLASH_JUMPER_PL,
IDCLS_ENABLE_EASYFLASH_JUMPER_SV,
IDCLS_ENABLE_EASYFLASH_JUMPER_TR,

/* c64/cart/easyflash.c */
IDCLS_DISABLE_EASYFLASH_JUMPER,
IDCLS_DISABLE_EASYFLASH_JUMPER_DA,
IDCLS_DISABLE_EASYFLASH_JUMPER_DE,
IDCLS_DISABLE_EASYFLASH_JUMPER_FR,
IDCLS_DISABLE_EASYFLASH_JUMPER_HU,
IDCLS_DISABLE_EASYFLASH_JUMPER_IT,
IDCLS_DISABLE_EASYFLASH_JUMPER_NL,
IDCLS_DISABLE_EASYFLASH_JUMPER_PL,
IDCLS_DISABLE_EASYFLASH_JUMPER_SV,
IDCLS_DISABLE_EASYFLASH_JUMPER_TR,

/* c64/cart/easyflash.c */
IDCLS_ENABLE_EASYFLASH_CRT_WRITING,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_DA,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_DE,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_FR,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_HU,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_IT,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_NL,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_PL,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_SV,
IDCLS_ENABLE_EASYFLASH_CRT_WRITING_TR,

/* c64/cart/lash.c */
IDCLS_DISABLE_EASYFLASH_CRT_WRITING,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_DA,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_DE,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_FR,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_HU,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_IT,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_NL,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_PL,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_SV,
IDCLS_DISABLE_EASYFLASH_CRT_WRITING_TR,
};
#endif
