/*
 * uijoystick2.c
 *
 * Written by
 *  Ettore Perazzoli <ettore@comm2000.it>
 *  Andreas Boose <viceteam@t-online.de>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#include <stdio.h>

#include "joy.h"
#include "joystick.h"
#include "resources.h"
#include "uiapi.h"
#include "uimenu.h"
#include "vsync.h"
#include "uijoystickkeys.h"

static UI_CALLBACK(set_joystick_device_1)
{
    int tmp;

    if (!CHECK_MENUS) {
        resources_set_int("JoyDevice1", vice_ptr_to_int(UI_MENU_CB_PARAM));
        ui_update_menus();
    } else {
        resources_get_int("JoyDevice1", &tmp);
        ui_menu_set_tick(w, tmp == vice_ptr_to_int(UI_MENU_CB_PARAM));
    }
}

static UI_CALLBACK(set_joystick_device_2)
{
    int tmp;

    if (!CHECK_MENUS) {
        resources_set_int("JoyDevice2", vice_ptr_to_int(UI_MENU_CB_PARAM));
        ui_update_menus();
    } else {
        resources_get_int("JoyDevice2", &tmp);
        ui_menu_set_tick(w, tmp == vice_ptr_to_int(UI_MENU_CB_PARAM));
    }
}

static UI_CALLBACK(set_joystick_device_3)
{
    int tmp;

    if (!CHECK_MENUS) {
        resources_set_int("JoyDevice3", vice_ptr_to_int(UI_MENU_CB_PARAM));
        ui_update_menus();
    } else {
        resources_get_int("JoyDevice3", &tmp);
        ui_menu_set_tick(w, tmp == vice_ptr_to_int(UI_MENU_CB_PARAM));
    }
}

static UI_CALLBACK(set_joystick_device_4)
{
    int tmp;

    if (!CHECK_MENUS) {
        resources_set_int("JoyDevice4", vice_ptr_to_int(UI_MENU_CB_PARAM));
        ui_update_menus();
    } else {
        resources_get_int("JoyDevice4", &tmp);
        ui_menu_set_tick(w, tmp == vice_ptr_to_int(UI_MENU_CB_PARAM));
    }
}

static UI_CALLBACK(swap_joystick_ports)
{
    int tmp1, tmp2;

    if (w != NULL) {
        vsync_suspend_speed_eval();
    }
    resources_get_int("JoyDevice1", &tmp1);
    resources_get_int("JoyDevice2", &tmp2);
    resources_set_int("JoyDevice1", tmp2);
    resources_set_int("JoyDevice2", tmp1);
    ui_update_menus();
}

static UI_CALLBACK(swap_userport_joystick_ports)
{
    int tmp3, tmp4;

    if (w != NULL) {
        vsync_suspend_speed_eval();
    }
    resources_get_int("JoyDevice3", &tmp3);
    resources_get_int("JoyDevice4", &tmp4);
    resources_set_int("JoyDevice3", tmp4);
    resources_set_int("JoyDevice4", tmp3);
    ui_update_menus();
}

UI_MENU_DEFINE_TOGGLE(KeySetEnable)
UI_MENU_DEFINE_TOGGLE(JoyOpposite)
UI_MENU_DEFINE_TOGGLE(ExtraJoy)
UI_MENU_DEFINE_TOGGLE(SIDCartJoy)
UI_MENU_DEFINE_RADIO(ExtraJoyType)

static ui_menu_entry_t userport_joystick_type_c64_submenu[] = {
    { N_("*CGA userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_CGA, NULL },
    { N_("*PET userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_PET, NULL },
    { N_("*Hummer userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_HUMMER, NULL },
    { N_("*OEM userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_OEM, NULL },
    { N_("*HIT userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_HIT, NULL },
    { NULL }
};

static ui_menu_entry_t userport_joystick_type_submenu[] = {
    { N_("*CGA userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_CGA, NULL },
    { N_("*PET userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_PET, NULL },
    { N_("*Hummer userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_HUMMER, NULL },
    { N_("*OEM userport joystick adapter"), (ui_callback_t)radio_ExtraJoyType,
      (ui_callback_data_t)EXTRA_JOYSTICK_OEM, NULL },
    { NULL }
};

static ui_menu_entry_t set_joystick_device_1_submenu[] = {
    { N_("*None"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_NONE, NULL },
    { N_("*Numpad"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_NUMPAD, NULL },
    { N_("*Keyset 1"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_KEYSET1, NULL },
    { N_("*Keyset 2"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_KEYSET2, NULL },
#ifdef HAS_JOYSTICK
    { N_("*Analog Joystick 0"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_0, NULL },
    { N_("*Analog Joystick 1"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_1, NULL },
    { N_("*Analog Joystick 2"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_2, NULL },
    { N_("*Analog Joystick 3"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_3, NULL },
    { N_("*Analog Joystick 4"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_4, NULL },
    { N_("*Analog Joystick 5"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_ANALOG_5, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { N_("*Digital Joystick 0"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_DIGITAL_0, NULL },
    { N_("*Digital Joystick 1"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_DIGITAL_1, NULL },
#endif
#ifdef HAS_USB_JOYSTICK
    { N_("*USB Joystick 0"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_USB_0, NULL },
    { N_("*USB Joystick 1"),
      (ui_callback_t)set_joystick_device_1,
      (ui_callback_data_t)JOYDEV_USB_1, NULL },
#endif
#endif
    { NULL }
};

static ui_menu_entry_t set_joystick_device_2_submenu[] = {
    { N_("*None"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_NONE, NULL },
    { N_("*Numpad"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_NUMPAD, NULL },
    { N_("*Keyset 1"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_KEYSET1, NULL },
    { N_("*Keyset 2"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_KEYSET2, NULL },
#ifdef HAS_JOYSTICK
    { N_("*Analog Joystick 0"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_0, NULL },
    { N_("*Analog Joystick 1"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_1, NULL },
    { N_("*Analog Joystick 2"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_2, NULL },
    { N_("*Analog Joystick 3"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_3, NULL },
    { N_("*Analog Joystick 4"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_4, NULL },
    { N_("*Analog Joystick 5"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_ANALOG_5, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { N_("*Digital Joystick 0"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_DIGITAL_0, NULL },
    { N_("*Digital Joystick 1"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_DIGITAL_1, NULL },
#endif
#ifdef HAS_USB_JOYSTICK
    { N_("*USB Joystick 0"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_USB_0, NULL },
    { N_("*USB Joystick 1"),
      (ui_callback_t)set_joystick_device_2,
      (ui_callback_data_t)JOYDEV_USB_1, NULL },
#endif
#endif /* HAS_JOYSTICK */
    { NULL }
};

static ui_menu_entry_t set_joystick_device_3_submenu[] = {
    { N_("*None"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_NONE, NULL },
    { N_("*Numpad"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_NUMPAD, NULL },
    { N_("*Keyset 1"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_KEYSET1, NULL },
    { N_("*Keyset 2"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_KEYSET2, NULL },
#ifdef HAS_JOYSTICK
    { N_("*Analog Joystick 0"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_0, NULL },
    { N_("*Analog Joystick 1"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_1, NULL },
    { N_("*Analog Joystick 2"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_2, NULL },
    { N_("*Analog Joystick 3"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_3, NULL },
    { N_("*Analog Joystick 4"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_4, NULL },
    { N_("*Analog Joystick 5"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_ANALOG_5, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { N_("*Digital Joystick 0"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_DIGITAL_0, NULL },
    { N_("*Digital Joystick 1"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_DIGITAL_1, NULL },
#endif
#ifdef HAS_USB_JOYSTICK
    { N_("*USB Joystick 0"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_USB_0, NULL },
    { N_("*USB Joystick 1"),
      (ui_callback_t)set_joystick_device_3,
      (ui_callback_data_t)JOYDEV_USB_1, NULL },
#endif
#endif
    { NULL }
};

static ui_menu_entry_t set_joystick_device_4_submenu[] = {
    { N_("*None"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_NONE, NULL },
    { N_("*Numpad"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_NUMPAD, NULL },
    { N_("*Keyset 1"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_KEYSET1, NULL },
    { N_("*Keyset 2"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_KEYSET2, NULL },
#ifdef HAS_JOYSTICK
    { N_("*Analog Joystick 0"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_0, NULL },
    { N_("*Analog Joystick 1"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_1, NULL },
    { N_("*Analog Joystick 2"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_2, NULL },
    { N_("*Analog Joystick 3"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_3, NULL },
    { N_("*Analog Joystick 4"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_4, NULL },
    { N_("*Analog Joystick 5"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_ANALOG_5, NULL },
#ifdef HAS_DIGITAL_JOYSTICK
    { N_("*Digital Joystick 0"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_DIGITAL_0, NULL },
    { N_("*Digital Joystick 1"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_DIGITAL_1, NULL },
#endif
#ifdef HAS_USB_JOYSTICK
    { N_("*USB Joystick 0"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_USB_0, NULL },
    { N_("*USB Joystick 1"),
      (ui_callback_t)set_joystick_device_4,
      (ui_callback_data_t)JOYDEV_USB_1, NULL },
#endif
#endif /* HAS_JOYSTICK */
    { NULL }
};

static ui_menu_entry_t joystick_settings_c64_submenu[] = {
    { N_("Joystick device in port 1"),
      NULL, NULL, set_joystick_device_1_submenu },
    { N_("Joystick device in port 2"),
      NULL, NULL, set_joystick_device_2_submenu },
    { "--" },
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { N_("Swap joystick ports"),
      (ui_callback_t)swap_joystick_ports, NULL, NULL, KEYSYM_j, UI_HOTMOD_META },
    { "--" },
    { N_("*Userport Joystick Interface"),
      (ui_callback_t)toggle_ExtraJoy, NULL, NULL },
    { N_("*Userport Joystick Interface Type"),
      NULL, NULL, userport_joystick_type_c64_submenu },
    { N_("Joystick device in extra port 1"),
      NULL, NULL, set_joystick_device_3_submenu },
    { N_("Joystick device in extra port 2"),
      NULL, NULL, set_joystick_device_4_submenu },
    { N_("Swap userport joystick ports"),
      (ui_callback_t)swap_userport_joystick_ports, NULL, NULL, KEYSYM_u, UI_HOTMOD_META },
    { NULL }
};

static ui_menu_entry_t joystick_settings_c64dtv_submenu[] = {
    { N_("Joystick device in port 1"),
      NULL, NULL, set_joystick_device_1_submenu },
    { N_("Joystick device in port 2"),
      NULL, NULL, set_joystick_device_2_submenu },
    { "--" },
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { N_("Swap joystick ports"),
      (ui_callback_t)swap_joystick_ports, NULL, NULL, KEYSYM_j, UI_HOTMOD_META },
    { "--" },
    { N_("*Userport Joystick Interface"),
      (ui_callback_t)toggle_ExtraJoy, NULL, NULL },
    { N_("*Userport Joystick Interface Type"),
      NULL, NULL, userport_joystick_type_submenu },
    { N_("Joystick device in extra port 1"),
      NULL, NULL, set_joystick_device_3_submenu },
    { N_("Joystick device in extra port 2"),
      NULL, NULL, set_joystick_device_4_submenu },
    { N_("Swap userport joystick ports"),
      (ui_callback_t)swap_userport_joystick_ports, NULL, NULL, KEYSYM_u, UI_HOTMOD_META },
    { NULL }
};

static ui_menu_entry_t joystick_settings_cbm5x0_submenu[] = {
    { N_("Joystick device in port 1"),
      NULL, NULL, set_joystick_device_1_submenu },
    { N_("Joystick device in port 2"),
      NULL, NULL, set_joystick_device_2_submenu },
    { "--" },
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { N_("Swap joystick ports"),
      (ui_callback_t)swap_joystick_ports, NULL, NULL, KEYSYM_j, UI_HOTMOD_META },
    { NULL }
};

static ui_menu_entry_t joystick_settings_pet_submenu[] = {
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { "--" },
    { N_("*Userport Joystick Interface"),
      (ui_callback_t)toggle_ExtraJoy, NULL, NULL },
    { N_("*Userport Joystick Interface Type"),
      NULL, NULL, userport_joystick_type_submenu },
    { N_("Joystick device in extra port 1"),
      NULL, NULL, set_joystick_device_3_submenu },
    { N_("Joystick device in extra port 2"),
      NULL, NULL, set_joystick_device_4_submenu },
    { N_("Swap userport joystick ports"),
      (ui_callback_t)swap_userport_joystick_ports, NULL, NULL, KEYSYM_u, UI_HOTMOD_META },
    { NULL }
};

static ui_menu_entry_t joystick_settings_vic20_submenu[] = {
    { N_("Joystick device in port 1"),
      NULL, NULL, set_joystick_device_1_submenu },
    { "--" },
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { "--" },
    { N_("*Userport Joystick Interface"),
      (ui_callback_t)toggle_ExtraJoy, NULL, NULL },
    { N_("*Userport Joystick Interface Type"),
      NULL, NULL, userport_joystick_type_submenu },
    { N_("Joystick device in extra port 1"),
      NULL, NULL, set_joystick_device_3_submenu },
    { N_("Joystick device in extra port 2"),
      NULL, NULL, set_joystick_device_4_submenu },
    { N_("Swap userport joystick ports"),
      (ui_callback_t)swap_userport_joystick_ports, NULL, NULL, KEYSYM_u, UI_HOTMOD_META },
    { NULL }
};

static ui_menu_entry_t joystick_settings_plus4_submenu[] = {
    { N_("Joystick device in port 1"),
      NULL, NULL, set_joystick_device_1_submenu },
    { N_("Joystick device in port 2"),
      NULL, NULL, set_joystick_device_2_submenu },
    { "--" },
#ifdef USE_GNOMEUI
    { N_("Define keysets"),
      (ui_callback_t)ui_keyset_dialog },
    { "--" },
#endif
    { N_("*Allow opposite directions"),
      (ui_callback_t)toggle_JoyOpposite, NULL, NULL },
    { N_("*Allow keyset joystick"),
      (ui_callback_t)toggle_KeySetEnable, NULL, NULL, KEYSYM_J, UI_HOTMOD_META | UI_HOTMOD_SHIFT },
    { N_("Swap joystick ports"),
      (ui_callback_t)swap_joystick_ports, NULL, NULL, KEYSYM_j, UI_HOTMOD_META },
    { "--" },
    { N_("*SIDcart Joystick"),
      (ui_callback_t)toggle_SIDCartJoy, NULL, NULL },
    { N_("Joystick device in extra port 1"),
      NULL, NULL, set_joystick_device_3_submenu },
    { NULL }
};

ui_menu_entry_t joystick_options_submenu[] = {
    { N_("Swap joystick ports"),
      (ui_callback_t)swap_joystick_ports, NULL, NULL, KEYSYM_j, UI_HOTMOD_META },
    { NULL }
};

ui_menu_entry_t joystick_settings_c64_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_c64_submenu },
    { NULL }
};

ui_menu_entry_t joystick_settings_c64dtv_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_c64dtv_submenu },
    { NULL }
};

ui_menu_entry_t joystick_settings_cbm5x0_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_cbm5x0_submenu },
    { NULL }
};

ui_menu_entry_t joystick_settings_pet_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_pet_submenu },
    { NULL }
};

ui_menu_entry_t joystick_settings_vic20_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_vic20_submenu },
    { NULL }
};

ui_menu_entry_t joystick_settings_plus4_menu[] = {
    { N_("Joystick settings"),
      NULL, NULL, joystick_settings_plus4_submenu },
    { NULL }
};
