/*
 * emulator.h
 *
 *  Created on: Oct 11, 2010
 *      Author: halsafar
 *      Edited: Squarepusher2 (Oct 15, 2010)
 */

#ifndef EMULATOR_H_
#define EMULATOR_H_

#define MAKE_BUTTON(pad, btn) (((pad)<<4)|(btn))

#define AUDIO_BLOCK_COUNT 16
#define AUDIO_CHANNEL_COUNT 2
#define AUDIO_INPUT_RATE (48000)
#define AUDIO_BUFFER_SAMPLES (4096)

#include "cellframework/input/cellInput.h"
#include "PS3Graphics.h"

extern "C" {
#include "ui.h"
}

void Emulator_RequestLoadROM(char* rom, bool forceReboot=false, bool warpmode=false);

bool Emulator_IsROMLoaded();
void Emulator_SwitchMode(Emulator_Modes);
extern "C" void Emulator_Shutdown(void);
extern "C" Emulator_Modes Emulator_GetMode(void);
char * Emulator_GetROM();
void Emulator_StartROMRunning();
void Emulator_SetDebugMessage(const char * value);
bool Emulator_ROMRunning();

extern CellInputFacade* CellInput;
extern PS3Graphics* Graphics;
float Emulator_GetFontSize();


#ifdef __cplusplus
extern "C" {
int menu (void);
void sysutil_callback_redraw(void);
}
#endif

unsigned char * load_screenshot(const char *filename, long *bytes);

#endif /* EMULATOR_H_ */
