#include "boot.h"

//#define GPIO1_PORT		0x0078
//#define GPIO2_PORT		0x0079

#define GPIO2_N_LED1_DIAG	0x10	/* diagnostic led mask */

#define	HARI2_N_LED1		0x01
#define	HARI2_N_LED2		0x02
#define	HARI2_N_LED3		0x04
#define	HARI2_N_LED4		0x08

/*
 * National Semiconductor PC87306 Super I/O
 */
enum {
	Index=		0x398,	/* sio configuration index register */
	Data=		0x399,	/* sio configuration data register */
};


// byte flip table for Puma SuperIO port permuted as 76543210 -> 01234567
unsigned char
byteflip[] = {
	0x00,0x80,0x40,0xC0,0x20,0xA0,0x60,0xE0,0x10,0x90,0x50,0xD0,0x30,0xB0,0x70,0xF0,
	0x08,0x88,0x48,0xC8,0x28,0xA8,0x68,0xE8,0x18,0x98,0x58,0xD8,0x38,0xB8,0x78,0xF8,
	0x04,0x84,0x44,0xC4,0x24,0xA4,0x64,0xE4,0x14,0x94,0x54,0xD4,0x34,0xB4,0x74,0xF4,
	0x0C,0x8C,0x4C,0xCC,0x2C,0xAC,0x6C,0xEC,0x1C,0x9C,0x5C,0xDC,0x3C,0xBC,0x7C,0xFC,
	0x02,0x82,0x42,0xC2,0x22,0xA2,0x62,0xE2,0x12,0x92,0x52,0xD2,0x32,0xB2,0x72,0xF2,
	0x0A,0x8A,0x4A,0xCA,0x2A,0xAA,0x6A,0xEA,0x1A,0x9A,0x5A,0xDA,0x3A,0xBA,0x7A,0xFA,
	0x06,0x86,0x46,0xC6,0x26,0xA6,0x66,0xE6,0x16,0x96,0x56,0xD6,0x36,0xB6,0x76,0xF6,
	0x0E,0x8E,0x4E,0xCE,0x2E,0xAE,0x6E,0xEE,0x1E,0x9E,0x5E,0xDE,0x3E,0xBE,0x7E,0xFE,
	0x01,0x81,0x41,0xC1,0x21,0xA1,0x61,0xE1,0x11,0x91,0x51,0xD1,0x31,0xB1,0x71,0xF1,
	0x09,0x89,0x49,0xC9,0x29,0xA9,0x69,0xE9,0x19,0x99,0x59,0xD9,0x39,0xB9,0x79,0xF9,
	0x05,0x85,0x45,0xC5,0x25,0xA5,0x65,0xE5,0x15,0x95,0x55,0xD5,0x35,0xB5,0x75,0xF5,
	0x0D,0x8D,0x4D,0xCD,0x2D,0xAD,0x6D,0xED,0x1D,0x9D,0x5D,0xDD,0x3D,0xBD,0x7D,0xFD,
	0x03,0x83,0x43,0xC3,0x23,0xA3,0x63,0xE3,0x13,0x93,0x53,0xD3,0x33,0xB3,0x73,0xF3,
	0x0B,0x8B,0x4B,0xCB,0x2B,0xAB,0x6B,0xEB,0x1B,0x9B,0x5B,0xDB,0x3B,0xBB,0x7B,0xFB,
	0x07,0x87,0x47,0xC7,0x27,0xA7,0x67,0xE7,0x17,0x97,0x57,0xD7,0x37,0xB7,0x77,0xF7,
	0x0F,0x8F,0x4F,0xCF,0x2F,0xAF,0x6F,0xEF,0x1F,0x9F,0x5F,0xDF,0x3F,0xBF,0x7F,0xFF
};

int
sio_inb(int port)
{
	unsigned char b = *(uchar *)IOBADDR(port);
//	b = byteflip[b];
	return b&0xff;
}

void
sio_outb(int port, int data)
{
//	data = byteflip[data];
	*(uchar *)IOBADDR(port) = data;
}

static void
siocfg(int r, int v, int rsv)
{
	sio_outb(Index, r);
	if(rsv)
		v = (sio_inb(Data)&rsv) | (v&~rsv);
	sio_outb(Data, v);
	sio_outb(Data, v);	/* ``write data twice'' */
}

void
sioinit(void)
{
	/* determine which byte flip is required ... */

	siocfg(SIO_CONFIG_FAR, FAR_LPT_LPTA | FAR_UART1_COM1 | FAR_UART2_COM2, 0);
	siocfg(SIO_CONFIG_FER,	FER_LPT_ENABLE | FER_UART1_ENABLE | FER_UART2_ENABLE | FER_IDE_ENABLE, 0);
	siocfg(SIO_CONFIG_KRR,	KRR_KBC_ENABLE | KRR_KBC_MUST_BE_1 | KRR_RTC_ENABLE, 0x50);
	siocfg(SIO_CONFIG_SCF0,SCF0_GPIO_PORT1_ENABLE | SCF0_GPIO_PORT2_ENABLE, 0xC0);

	/* force UART interrupt pins low, not tristate by setting ienable in MCR (!) */
	sio_outb(COM1_PORT+UART_MCR, sio_inb(COM1_PORT+UART_MCR)|(1<<3));
	sio_outb(COM2_PORT+UART_MCR, sio_inb(COM2_PORT+UART_MCR)|(1<<3));
}

void
led(int on)
{
	int gpio, hari, hbits;
	int s;

	s = splhi();

	gpio = sio_inb(GPIO2_PORT);
	if (on)
		gpio &= ~GPIO2_N_LED1_DIAG;
	else
		gpio |= GPIO2_N_LED1_DIAG;
	sio_outb(GPIO2_PORT, gpio);

	hari = HARI2_INIT;
	hbits = HARI2_N_LED1|HARI2_N_LED2|HARI2_N_LED3|HARI2_N_LED4;
	if (on)
		hari &= ~hbits;
	else
		hari |= hbits;
	*(uchar *)HARI2 = hari;

	
	splx(s);

}

void
pumainit(void)
{
	/*
	 * Initialise HARI2 for:
	 * a) Leds off
	 * b) No Timer2 aborts
	 * c) Ethernet on IRQ
	 */
	*(uchar *)HARI2 = HARI2_INIT|HARI2_N_LED1|HARI2_N_LED2|HARI2_N_LED3|HARI2_N_LED4;
	sioinit();
}

