implement Limbo;

#line	2	"limbo.y"
include "limbo.m";
include "draw.m";

Limbo: module {

	init:		fn(ctxt: ref Draw->Context, argv: list of string);

	YYSTYPE: adt{
		tok:	Tok;
		ids:	ref Decl;
		node:	ref Node;
		ty:	ref Type;
		types:	ref Typelist;
	};

	YYLEX: adt {
		lval: YYSTYPE;
		lex: fn(nil: self ref YYLEX): int;
		error: fn(nil: self ref YYLEX, err: string);
	};
Landeq: con	57346;
Loreq: con	57347;
Lxoreq: con	57348;
Llsheq: con	57349;
Lrsheq: con	57350;
Laddeq: con	57351;
Lsubeq: con	57352;
Lmuleq: con	57353;
Ldiveq: con	57354;
Lmodeq: con	57355;
Lexpeq: con	57356;
Ldeclas: con	57357;
Lload: con	57358;
Loror: con	57359;
Landand: con	57360;
Lcons: con	57361;
Leq: con	57362;
Lneq: con	57363;
Lleq: con	57364;
Lgeq: con	57365;
Llsh: con	57366;
Lrsh: con	57367;
Lexp: con	57368;
Lcomm: con	57369;
Linc: con	57370;
Ldec: con	57371;
Lof: con	57372;
Lref: con	57373;
Lif: con	57374;
Lelse: con	57375;
Lfn: con	57376;
Lexcept: con	57377;
Lraises: con	57378;
Lmdot: con	57379;
Lto: con	57380;
Lor: con	57381;
Lrconst: con	57382;
Lconst: con	57383;
Lid: con	57384;
Ltid: con	57385;
Lsconst: con	57386;
Llabs: con	57387;
Lnil: con	57388;
Llen: con	57389;
Lhd: con	57390;
Ltl: con	57391;
Ltagof: con	57392;
Limplement: con	57393;
Limport: con	57394;
Linclude: con	57395;
Lcon: con	57396;
Ltype: con	57397;
Lmodule: con	57398;
Lcyclic: con	57399;
Ladt: con	57400;
Larray: con	57401;
Llist: con	57402;
Lchan: con	57403;
Lself: con	57404;
Ldo: con	57405;
Lwhile: con	57406;
Lfor: con	57407;
Lbreak: con	57408;
Lalt: con	57409;
Lcase: con	57410;
Lpick: con	57411;
Lcont: con	57412;
Lreturn: con	57413;
Lexit: con	57414;
Lspawn: con	57415;
Lraise: con	57416;
Lfix: con	57417;
Ldynamic: con	57418;

};

#line	27	"limbo.y"
	#
	# lex.b
	#
	signdump:	string;			# name of function for sig debugging
	superwarn:	int;
	debug:		array of int;
	noline:		Line;
	nosrc:		Src;
	arrayz:		int;
	emitcode:	string;			# emit stub routines for system module functions
	emitdyn: int;				# emit as above but for dynamic modules
	emitsbl:	string;			# emit symbol file for sysm modules
	emitstub:	int;			# emit type and call frames for system modules
	emittab:	string;			# emit table of runtime functions for this module
	errors:		int;
	mustcompile:	int;
	dontcompile:	int;
	asmsym:		int;			# generate symbols in assembly language?
	bout:		ref Bufio->Iobuf;	# output file
	bsym:		ref Bufio->Iobuf;	# symbol output file; nil => no sym out
	gendis:		int;			# generate dis or asm?
	fixss:		int;
	newfnptr:	int;		# ISELF and -ve indices
	optims: int;

	#
	# decls.b
	#
	scope:		int;
	# impmod:		ref Sym;		# name of implementation module
	impmods:		ref Decl;		# name of implementation module(s)
	nildecl:	ref Decl;		# declaration for limbo's nil
	selfdecl:	ref Decl;		# declaration for limbo's self

	#
	# types.b
	#
	tany:		ref Type;
	tbig:		ref Type;
	tbyte:		ref Type;
	terror:		ref Type;
	tint:		ref Type;
	tnone:		ref Type;
	treal:		ref Type;
	tstring:	ref Type;
	texception:	ref Type;
	tunknown:	ref Type;
	tfnptr:	ref Type;
	rtexception:	ref Type;
	descriptors:	ref Desc;		# list of all possible descriptors
	tattr:		array of Tattr;

	#
	# nodes.b
	#
	opcommute:	array of int;
	oprelinvert:	array of int;
	isused:		array of int;
	casttab:	array of array of int;	# instruction to cast from [1] to [2]

	nfns:		int;			# functions defined
	nfnexp:		int;
	fns:		array of ref Decl;	# decls for fns defined
	tree:		ref Node;		# root of parse tree

	parset:		int;			# time to parse
	checkt:		int;			# time to typecheck
	gent:		int;			# time to generate code
	writet:		int;			# time to write out code
	symt:		int;			# time to write out symbols
YYEOFCODE: con 1;
YYERRCODE: con 2;
YYMAXDEPTH: con 200;

#line	1631	"limbo.y"


include "keyring.m";

sys:	Sys;
	print, fprint, sprint: import sys;

bufio:	Bufio;
	Iobuf: import bufio;

str:		String;

keyring:Keyring;
	md5: import keyring;

math:	Math;
	import_real, export_real, isnan: import math;

yyctxt: ref YYLEX;

canonnan: real;

debug	= array[256] of {* => 0};

noline	= -1;
nosrc	= Src(-1, -1);

infile:	string;

# front end
include "arg.m";
include "lex.b";
include "types.b";
include "nodes.b";
include "decls.b";

include "typecheck.b";

# back end
include "gen.b";
include "ecom.b";
include "asm.b";
include "dis.b";
include "sbl.b";
include "stubs.b";
include "com.b";
include "optim.b";

init(nil: ref Draw->Context, argv: list of string)
{
	s: string;

	sys = load Sys Sys->PATH;
	keyring = load Keyring Keyring->PATH;
	math = load Math Math->PATH;
	bufio = load Bufio Bufio->PATH;
	if(bufio == nil){
		sys->print("can't load %s: %r\n", Bufio->PATH);
		raise("fail:bad module");
	}
	str = load String String->PATH;
	if(str == nil){
		sys->print("can't load %s: %r\n", String->PATH);
		raise("fail:bad module");
	}

	stderr = sys->fildes(2);
	yyctxt = ref YYLEX;

	math->FPcontrol(0, Math->INVAL|Math->ZDIV|Math->OVFL|Math->UNFL|Math->INEX);
	na := array[1] of {0.};
	import_real(array[8] of {byte 16r7f, * => byte 16rff}, na);
	canonnan = na[0];
	if(!isnan(canonnan))
		fatal("bad canonical NaN");

	lexinit();
	typeinit();
	optabinit();

	gendis = 1;
	asmsym = 0;
	maxerr = 20;
	ofile := "";
	ext := "";

	arg := Arg.init(argv);
	while(c := arg.opt()){
		case c{
		'Y' =>
			emitsbl = arg.arg();
			if(emitsbl == nil)
				usage();
		'C' =>
			dontcompile = 1;
		'D' =>
			#
			# debug flags:
			#
			# a	alt compilation
			# A	array constructor compilation
			# b	boolean and branch compilation
			# c	case compilation
			# d	function declaration
			# D	descriptor generation
			# e	expression compilation
			# E	addressable expression compilation
			# f	print arguments for compiled functions
			# F	constant folding
			# g	print out globals
			# m	module declaration and type checking
			# n	nil references
			# s	print sizes of output file sections
			# S	type signing
			# t	type checking function bodies
			# T	timing
			# v	global var and constant compilation
			# x	adt verification
			# Y	tuple compilation
			# z Z	bug fixes
			#
			s = arg.arg();
			for(i := 0; i < len s; i++){
				c = s[i];
				if(c < len debug)
					debug[c] = 1;
			}
		'I' =>
			s = arg.arg();
			if(s == "")
				usage();
			addinclude(s);
		'G' =>
			asmsym = 1;
		'S' =>
			gendis = 0;
		'a' =>
			emitstub = 1;
		'A' =>
			emitstub = emitdyn = 1;
		'c' =>
			mustcompile = 1;
		'e' =>
			maxerr = 1000;
		'f' =>
			fabort = 1;
		'F' =>
			newfnptr = 1;
		'g' =>
			dosym = 1;
		'i' =>
			dontinline = 1;
		'o' =>
			ofile = arg.arg();
		'O' =>
			optims = 1;
		's' =>
			s = arg.arg();
			if(s != nil)
				fixss = int s;
		't' =>
			emittab = arg.arg();
			if(emittab == nil)
				usage();
		'T' =>
			emitcode = arg.arg();
			if(emitcode == nil)
				usage();
		'd' =>
			emitcode = arg.arg();
			if(emitcode == nil)
				usage();
			emitdyn = 1;
		'w' =>
			superwarn = dowarn;
			dowarn = 1;
		'x' =>
			ext = arg.arg();
		'X' =>
			signdump = arg.arg();
		'z' =>
			arrayz = 1;
		* =>
			usage();
		}
	}

	addinclude("/module");

	argv = arg.argv;
	arg = nil;

	if(argv == nil){
		usage();
	}else if(ofile != nil){
		if(len argv != 1)
			usage();
		translate(hd argv, ofile, mkfileext(ofile, ".dis", ".sbl"));
	}else{
		pr := len argv != 1;
		if(ext == ""){
			ext = ".s";
			if(gendis)
				ext = ".dis";
		}
		for(; argv != nil; argv = tl argv){
			file := hd argv;
			(nil, s) = str->splitr(file, "/");
			if(pr)
				print("%s:\n", s);
			out := mkfileext(s, ".b", ext);
			translate(file, out, mkfileext(out, ext, ".sbl"));
		}
	}
	if (toterrors > 0)
		raise("fail:errors");
}

usage()
{
	fprint(stderr, "usage: limbo [-GSagwe] [-I incdir] [-o outfile] [-{T|t|d} module] [-D debug] file ...\n");
	raise("fail:usage");
}

mkfileext(file, oldext, ext: string): string
{
	n := len file;
	n2 := len oldext;
	if(n >= n2 && file[n-n2:] == oldext)
		file = file[:n-n2];
	return file + ext;
}

translate(in, out, dbg: string)
{
	infile = in;
	outfile = out;
	errors = 0;
	bins[0] = bufio->open(in, Bufio->OREAD);
	if(bins[0] == nil){
		fprint(stderr, "can't open %s: %r\n", in);
		toterrors++;
		return;
	}
	doemit := emitcode != "" || emitstub || emittab != "" || emitsbl != "";
	if(!doemit){
		bout = bufio->create(out, Bufio->OWRITE, 8r666);
		if(bout == nil){
			fprint(stderr, "can't open %s: %r\n", out);
			toterrors++;
			bins[0].close();
			return;
		}
		if(dosym){
			bsym = bufio->create(dbg, Bufio->OWRITE, 8r666);
			if(bsym == nil)
				fprint(stderr, "can't open %s: %r\n", dbg);
		}
	}

	lexstart(in);

	popscopes();
	typestart();
	declstart();
	nfnexp = 0;

	parset = sys->millisec();
	yyparse(yyctxt);
	parset = sys->millisec() - parset;

	checkt = sys->millisec();
	entry := typecheck(!doemit);
	checkt = sys->millisec() - checkt;

	modcom(entry);

	fns = nil;
	nfns = 0;
	descriptors = nil;

	if(debug['T'])
		print("times: parse=%d type=%d: gen=%d write=%d symbols=%d\n",
			parset, checkt, gent, writet, symt);

	if(bout != nil)
		bout.close();
	if(bsym != nil)
		bsym.close();
	toterrors += errors;
	if(errors && bout != nil)
		sys->remove(out);
	if(errors && bsym != nil)
		sys->remove(dbg);
}

pwd(): string
{
	workdir := load Workdir Workdir->PATH;
	if(workdir == nil)
		cd := "/";
	else
		cd = workdir->init();
	# sys->print("pwd: %s\n", cd);
	return cd;
}

cleanname(s: string): string
{
	ls, path: list of string;

	if(s == nil)
		return nil;
	if(s[0] != '/' && s[0] != '\\')
		(nil, ls) = sys->tokenize(pwd(), "/\\");
	for( ; ls != nil; ls = tl ls)
		path = hd ls :: path;
	(nil, ls) = sys->tokenize(s, "/\\");
	for( ; ls != nil; ls = tl ls){
		n := hd ls;
		if(n == ".")
			;
		else if (n == ".."){
			if(path != nil)
				path = tl path;
		}
		else
			path = n :: path;
	}
	p := "";
	for( ; path != nil; path = tl path)
		p = "/" + hd path + p;
	if(p == nil)
		p = "/";
	# sys->print("cleanname: %s\n", p);
	return p;
}

srcpath(): string
{
	srcp := cleanname(infile);
	# sys->print("srcpath: %s\n", srcp);
	return srcp;
}
yyexca := array[] of {-1, 1,
	1, -1,
	-2, 0,
-1, 3,
	1, 3,
	-2, 0,
-1, 17,
	39, 88,
	50, 62,
	54, 88,
	99, 62,
	-2, 252,
-1, 211,
	59, 29,
	71, 29,
	-2, 0,
-1, 230,
	1, 2,
	-2, 0,
-1, 273,
	50, 176,
	-2, 257,
-1, 308,
	59, 41,
	71, 41,
	91, 41,
	-2, 0,
-1, 310,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 380,
	50, 62,
	99, 62,
	-2, 252,
-1, 381,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 387,
	53, 71,
	54, 71,
	-2, 110,
-1, 389,
	53, 72,
	54, 72,
	-2, 112,
-1, 421,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 428,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 443,
	53, 71,
	54, 71,
	-2, 111,
-1, 444,
	53, 72,
	54, 72,
	-2, 113,
-1, 452,
	71, 279,
	99, 279,
	-2, 163,
-1, 469,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 486,
	50, 126,
	99, 126,
	-2, 239,
-1, 491,
	71, 276,
	-2, 0,
-1, 503,
	59, 47,
	71, 47,
	-2, 0,
-1, 508,
	59, 41,
	71, 41,
	91, 41,
	-2, 0,
-1, 514,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 548,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 554,
	71, 154,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 562,
	56, 59,
	62, 59,
	-2, 62,
-1, 568,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 573,
	71, 157,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 577,
	72, 176,
	-2, 163,
-1, 596,
	71, 160,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 602,
	71, 168,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 606,
	72, 175,
	85, 150,
	86, 150,
	87, 150,
	89, 150,
	90, 150,
	91, 150,
	-2, 0,
-1, 609,
	50, 62,
	56, 171,
	62, 171,
	99, 62,
	-2, 252,
};
YYNPROD: con 284;
YYPRIVATE: con 57344;
yytoknames: array of string;
yystates: array of string;
yydebug: con 0;
YYLAST:	con 2727;
yyact := array[] of {
 379, 591, 453, 364, 505, 384, 412, 310, 369, 314,
 359, 451, 449, 185,  84,  83, 432, 298, 270,  15,
   8,  49, 213, 102, 320,  12,  42, 110,  48,  78,
  79,  80,   4,  35, 198,  51,  23, 544, 363,   6,
 423,   3,   6, 486, 459, 382, 365,  14, 458,  21,
  14, 353, 350, 293, 285, 491, 118, 225, 400, 330,
 286, 226,  31, 223,  46, 112, 465,  11, 105, 517,
 420, 419, 418, 186, 164, 165, 166, 167, 168, 169,
 170, 171, 172, 173, 174, 175, 176,  43, 117, 422,
 182, 183, 184, 599,  71,  10, 286, 205,  10, 208,
  93, 349, 286, 601, 119, 349,  32, 114,  40, 349,
 294,  32, 294, 286,  44, 119, 428, 427, 426, 308,
 430, 429, 431, 585, 231, 232, 233, 234, 235, 236,
 237, 238, 239, 240, 241, 242, 309, 244, 245, 246,
 247, 248, 249, 250, 251, 252, 253, 254, 255, 256,
 257, 258, 259, 260, 261, 262, 263, 264, 265, 186,
   6, 547, 273, 230,  37,  22, 194, 195,  14,  22,
 271, 485, 267, 210,   5, 483, 482, 565, 279, 481,
 513, 410, 284,  87, 438, 559, 424, 228, 409, 288,
  85, 407,  94,  90, 289,  99, 269, 415, 217, 202,
   5, 415,  47,  92,  82,  22, 209,  26, 303,  25,
 212,  19,  24, 218, 229, 566,  10, 354,  96, 595,
  98,  95, 100, 572, 101,  88,  89,  86, 557, 194,
 195,  17,  87, 312, 311,  18, 297,  19, 187,  85,
 553,  77,  90, 313, 326, 305, 536,  13, 512, 112,
 323, 318,  92,  82, 525, 207, 490,  17,  87, 468,
 399,  18, 383,  23, 508,  85, 316, 215,  90,   6,
 498,   2, 500,  13,  88,  89,  86,  14,  92,  82,
 194, 195, 479, 186,  43, 467, 398, 340, 194, 195,
  77, 114, 193, 361, 282, 499, 338, 182, 500, 535,
  88,  89,  86, 336, 194, 195, 219, 530,  87, 211,
 341,  44,  87, 324, 580,  85,  77, 325,  90,  85,
 381, 348,  90, 206,  19,  10, 358, 357,  92,  82,
 579, 393,  92,  82, 604, 214, 389, 387, 391, 448,
 614, 194, 195, 402,  45, 539, 194, 195,  18, 392,
  88,  89,  86, 356,  88,  89,  86, 321, 194, 195,
 192, 385,  72, 403, 404, 495,  77,  33, 317, 108,
  77, 416,  73,  19,  19, 421, 436, 301, 281, 186,
  76,  75,  45, 435,  74, 437,  18, 216, 487, 493,
 434, 441, 439, 115, 115, 612, 564, 116, 116, 452,
 488, 340, 183, 444, 443, 507, 414,  45, 316, 604,
 562,  18, 493, 543, 493, 603, 336, 493, 600,  70,
 597, 493,  63, 588, 504,  73, 473, 574, 469,  22,
 478, 442, 476,  76,  75,  69,  68,  74, 480,  18,
  54,  55,  62,  60,  61,  64,  87, 433, 291, 452,
 290,  91, 268,  85,  91, 157,  90,  65,  66,  67,
 120, 489, 493, 104, 497, 493,  92,  82, 555, 540,
 594, 494, 186,  77, 159, 477, 168, 194, 195, 103,
 523, 507, 522, 515, 516, 511, 406, 510,  88,  89,
  86,  87, 452, 527, 523, 529, 528, 487,  85, 518,
 533,  90, 593, 526,  77,  91,  39,  91, 532, 537,
 466,  92,  82, 417, 545,  91, 408, 568, 546, 541,
 523,  36, 552, 329, 224, 556,  91, 592, 299, 554,
 106, 300,  34,  88,  89,  86, 158, 401, 161, 397,
 162, 163, 560, 563, 441, 316, 335, 332, 201,  77,
 160, 159, 570, 200, 197, 577, 569, 575, 571, 573,
  81, 477, 177,  97, 181, 179, 331, 523, 180, 583,
 446, 177, 584, 445, 577, 178, 587, 141, 142, 138,
 139, 140, 137, 135, 561, 328, 227, 346, 414, 345,
 596,  41, 203, 606, 598, 477, 586, 577, 602, 605,
  91, 548, 386, 327, 607, 222, 611, 221, 549, 475,
 613, 474, 471, 425, 196, 477, 199,  91, 137, 135,
  91,  91,  39,  91, 204, 138, 139, 140, 137, 135,
  91, 183, 168, 188,  19, 220,  29,  27, 524, 243,
 360, 538, 307, 287,  91,  91, 368, 121,  30,  28,
   1, 464, 272, 477, 123, 124, 125, 126, 127, 128,
 129, 130, 131, 132, 133, 134, 136, 274, 156, 155,
 154, 153, 152, 151, 149, 150, 145, 146, 147, 148,
 144, 143, 141, 142, 138, 139, 140, 137, 135, 315,
 343, 542, 582, 581, 413, 503, 502, 590,  91, 144,
 143, 141, 142, 138, 139, 140, 137, 135, 589, 283,
  16, 411, 306, 355,  91,   9, 551,  87, 550, 521,
  91, 520,   7, 450,  85, 337, 292,  90, 266, 295,
 296, 506, 371, 109, 107,  87, 113,  92,  82, 199,
 111,  91,  85,  20,  38,  90,   0,  99, 282, 342,
   0,  91,  91, 319, 322,  92,  82,   0,   0,  88,
  89,  86,   0,   0,   0,  91,  91,   0,   0,  91,
  96,   0,  98,  95,   0,  77,  87,  88,  89,  86,
   0,   0,   0,  85,   0,   0,  90,   0,   0,   0,
   0,   0,   0,  77,   0,   0,  92,  82,   0,   0,
   0,   0,   0,   0,   0,   0,   0, 333,  91,   0,
 455,   0,   0,   0,   0,   0,   0,  91,  88,  89,
  86,  91,   0, 347,   0,  50,  91,   0,  91, 351,
   0,   0,   0,   0,  77,   0,   0,  91,   0,   0,
  52,  53, 454,  91,   0,   0,  59,  72,   0,   0,
 390,  57,  58,   0,  63,   0,   0,  73,   0,   0,
 395, 396,   0,   0,   0,  76,  75,  69,  68,  74,
   0,  18,  54,  55,  62,  60,  61,  64, 405,   0,
   0,   0,  91,   0,   0,   0,  91,   0,   0,  65,
  66,  67, 145, 146, 147, 148, 144, 143, 141, 142,
 138, 139, 140, 137, 135,  77,   0,  91,   0,   0,
   0,   0,   0, 366,   0,   0,   0, 196,   0,   0,
  91,   0,   0,   0,   0,   0, 447,   0,  50,   0,
 456,   0,   0,   0,   0, 460,   0, 461,   0,   0,
   0,   0,   0,  52,  53,  56,  97,   0,   0,  59,
 378,   0, 472,   0,  57,  58,   0,  63, 370,   0,
  73,   0,   0,   0,   0,   0,   0,   0,  76,  75,
 380,  68,  74,   0,  18,  54,  55,  62,  60,  61,
  64, 367, 509, 366,   0,   0,  13,   0,   0,   0,
   0, 496,  65,  66,  67, 501,   0,   0,  50, 372,
   0,   0,   0, 373, 374, 377, 375, 376,  77,   0,
   0,   0,   0,  52,  53,  56, 501,   0,   0,  59,
 378,   0,   0,   0,  57,  58,   0,  63, 370, 534,
  73,   0,   0,   0,   0,   0,   0,   0,  76,  75,
 380,  68,  74,   0,  18,  54,  55,  62,  60,  61,
  64, 367, 470, 366,   0,   0,  13,   0,   0,   0,
   0,   0,  65,  66,  67,   0,   0,   0,  50, 372,
   0,   0,   0, 373, 374, 377, 375, 376,  77,   0,
   0,   0,   0,  52,  53,  56,   0,   0,   0,  59,
 378,   0,   0,   0,  57,  58,   0,  63, 370,   0,
  73,   0,   0,   0,   0,   0,   0,   0,  76,  75,
 380,  68,  74,   0,  18,  54,  55,  62,  60,  61,
  64, 367, 440, 366,   0,   0,  13,   0,   0,   0,
   0,   0,  65,  66,  67,   0,   0,   0,  50, 372,
   0,   0,   0, 373, 374, 377, 375, 376,  77,   0,
   0,   0,   0,  52,  53,  56,   0,   0,   0,  59,
 378,   0,   0,   0,  57,  58,   0,  63, 370,   0,
  73,   0,   0,   0,   0,   0,   0,   0,  76,  75,
 380,  68,  74,   0,  18,  54,  55,  62,  60,  61,
  64, 367, 362, 608,   0,   0,  13,   0,   0,   0,
   0,   0,  65,  66,  67,   0,   0,   0,  50, 372,
   0,   0,   0, 373, 374, 377, 375, 376,  77,   0,
   0,   0,   0,  52,  53, 610,   0,   0,   0,  59,
 378,   0,   0,   0,  57,  58,   0,  63, 370,   0,
  73,   0,   0,   0,   0,   0,   0,   0,  76,  75,
 609,  68,  74,   0,  18,  54,  55,  62,  60,  61,
  64, 367, 576,   0,   0,   0,  13,   0,   0,   0,
   0,   0,  65,  66,  67,   0,   0,  50,   0, 372,
   0,   0,   0, 373, 374, 377, 375, 376,  77,   0,
   0,   0,  52,  53, 454,   0,   0,   0,  59, 378,
   0,   0,   0,  57,  58,   0,  63, 370,   0,  73,
   0,   0,   0,   0,   0,   0,   0,  76,  75, 380,
  68,  74,   0,  18,  54,  55,  62,  60,  61,  64,
 367, 366,   0,   0,   0,  13,   0,   0,   0,   0,
   0,  65,  66,  67,   0,   0,  50,   0, 372,   0,
   0,   0, 373, 374, 377, 375, 376,  77,   0,   0,
   0,  52,  53,  56,   0,   0,   0,  59, 378,   0,
   0,   0,  57,  58,   0,  63, 370,   0,  73,   0,
   0,   0,   0,   0,   0,   0,  76,  75, 380,  68,
  74,   0,  18,  54,  55,  62,  60,  61,  64, 367,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  65,  66,  67,  50,   0,   0,   0, 372,   0,   0,
   0, 373, 374, 377, 375, 376,  77,   0,  52,  53,
  56,   0,   0,   0,  59,  72,   0,   0,   0,  57,
  58,   0,  63,   0,   0,  73,   0,   0,   0,   0,
   0,   0,   0,  76,  75,  69, 275,  74,   0,  18,
  54,  55,  62,  60,  61,  64,   0,   0,   0,  50,
   0,   0,   0,   0,   0, 278,   0, 276, 277,  67,
   0,   0,   0,   0,  52,  53,  56,   0,   0,   0,
  59,  72,   0,  77, 280,  57,  58,   0,  63,   0,
   0,  73,   0,   0,   0,   0,   0,   0,   0,  76,
  75,  69,  68,  74,   0,  18,  54,  55,  62,  60,
  61,  64,   0,   0,  50,   0,   0,   0,   0,   0,
   0,   0,   0,  65,  66,  67,   0,   0,   0,  52,
  53,  56,   0,   0,   0,  59,  72,   0,   0,  77,
  57,  58,   0,  63,   0,   0,  73,   0,   0,   0,
   0,   0,   0,   0,  76,  75,  69,  68,  74,   0,
  18,  54,  55,  62,  60,  61,  64,   0,   0,   0,
  52,  53,  56,   0,   0,   0,  59,  72,  65,  66,
  67,  57,  58,   0,  63,   0,   0,  73,   0,   0,
   0,   0,   0,   0,  77,  76,  75,  69,  68,  74,
   0,  18,  54,  55,  62,  60,  61,  64,   0,   0,
   0,   0,   0,   0,   0,   0,  87,   0,   0,  65,
  66,  67,   0,  85,   0,   0,  90,   0,  99,   0,
   0,   0,   0,   0,   0,  77,  92,  82, 149, 150,
 145, 146, 147, 148, 144, 143, 141, 142, 138, 139,
 140, 137, 135, 463, 462,   0,   0, 101,  88,  89,
  86, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136,  77, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 567,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135, 154, 153, 152, 151, 149, 150, 145, 146, 147,
 148, 144, 143, 141, 142, 138, 139, 140, 137, 135,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 558, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135, 152, 151, 149, 150,
 145, 146, 147, 148, 144, 143, 141, 142, 138, 139,
 140, 137, 135,   0,   0,   0, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 531,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135, 151, 149, 150, 145, 146, 147, 148, 144, 143,
 141, 142, 138, 139, 140, 137, 135,   0,   0,   0,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 484, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 352,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 344, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 304,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 302, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 191,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 190, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0, 123, 124, 125, 126,
 127, 128, 129, 130, 131, 132, 133, 134, 136, 189,
 156, 155, 154, 153, 152, 151, 149, 150, 145, 146,
 147, 148, 144, 143, 141, 142, 138, 139, 140, 137,
 135,   0,  87,   0,   0,   0,  87,   0,   0,  85,
   0,   0,  90, 388,   0,   0,  90,   0,   0,   0,
   0,   0,  92, 394,   0,   0,  92,  82,   0,   0,
   0,   0,   0,   0, 122,   0,   0,   0,   0,   0,
   0,   0,   0,   0,  88,  89,  86,   0,  88,  89,
  86,   0,   0,   0,   0,   0,   0,   0,   0,   0,
  77,   0,   0,   0,  77, 123, 124, 125, 126, 127,
 128, 129, 130, 131, 132, 133, 134, 136,   0, 156,
 155, 154, 153, 152, 151, 149, 150, 145, 146, 147,
 148, 144, 143, 141, 142, 138, 139, 140, 137, 135,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 123, 124,
 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
 136, 578, 156, 155, 154, 153, 152, 151, 149, 150,
 145, 146, 147, 148, 144, 143, 141, 142, 138, 139,
 140, 137, 135,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136, 519, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135,   0,   0,   0, 123,
 124, 125, 126, 127, 128, 129, 130, 131, 132, 133,
 134, 136, 492, 156, 155, 154, 153, 152, 151, 149,
 150, 145, 146, 147, 148, 144, 143, 141, 142, 138,
 139, 140, 137, 135,   0,   0,   0, 339, 123, 124,
 125, 126, 127, 128, 129, 130, 131, 132, 133, 134,
 136,   0, 156, 155, 154, 153, 152, 151, 149, 150,
 145, 146, 147, 148, 144, 143, 141, 142, 138, 139,
 140, 137, 135,   0,   0,   0, 334, 123, 124, 125,
 126, 127, 128, 129, 130, 131, 132, 133, 134, 136,
   0, 156, 155, 154, 153, 152, 151, 149, 150, 145,
 146, 147, 148, 144, 143, 141, 142, 138, 139, 140,
 137, 135,   0, 514, 123, 124, 125, 126, 127, 128,
 129, 130, 131, 132, 133, 134, 136,   0, 156, 155,
 154, 153, 152, 151, 149, 150, 145, 146, 147, 148,
 144, 143, 141, 142, 138, 139, 140, 137, 135,   0,
 457, 123, 124, 125, 126, 127, 128, 129, 130, 131,
 132, 133, 134, 136,   0, 156, 155, 154, 153, 152,
 151, 149, 150, 145, 146, 147, 148, 144, 143, 141,
 142, 138, 139, 140, 137, 135, 156, 155, 154, 153,
 152, 151, 149, 150, 145, 146, 147, 148, 144, 143,
 141, 142, 138, 139, 140, 137, 135,
};
yypact := array[] of {
 198,-1000, 370, 172,-1000, 140,-1000,-1000, 137, 135,
 633, 632,  12, 306, 482,-1000, 467, 550,-1000, 285,
 -35, 130,-1000,-1000,-1000,-1000,-1000,1507,1507,1507,
1507, 737, 595, 120, 144, 427, 404, -19, 480, 335,
-1000, 370,  16,-1000,-1000,-1000, 401,-1000,2272,-1000,
 396, 497,1548,1548,1548,1548,1548,1548,1548,1548,
1548,1548,1548,1548,1548, 530, 520, 523,1548, 376,
1548,-1000,1507, 583,-1000,-1000,-1000, 594,2217,2162,
2107, 288,-1000,-1000,-1000, 737, 509, 737, 508, 503,
 550,-1000, 551,-1000,-1000, 737,1507, 251,1507, 134,
 239, 550, 265, 348, 550, 236, 737, 567, 565, -36,
-1000, 474,   7, -38,-1000,-1000,-1000, 544,-1000, 285,
-1000, 172,-1000,1507,1507,1507,1507,1507,1507,1507,
1507,1507,1507,1507,1507, 635,1507,1507,1507,1507,
1507,1507,1507,1507,1507,1507,1507,1507,1507,1507,
1507,1507,1507,1507,1507,1507,1507,1507,1507, 393,
 323,1396,-1000,-1000,-1000,-1000,-1000,-1000,-1000,-1000,
-1000,-1000,-1000,-1000,-1000,-1000,-1000,1452, 318, 224,
 737,1507,-1000,-1000,-1000,  14,2667,-1000,1507,-1000,
-1000,-1000,-1000,1507, 391, 389, 424, 737,  13, 424,
 737, 737, 583, 452, 305,2052,-1000,1507,1997,-1000,
 737, 640,  49,-1000,-1000, 163, 285,-1000,-1000, 370,
 424,-1000,-1000, 334, 273, 273, 254,-1000,-1000,-1000,
 172,2667,2667,2667,2667,2667,2667,2667,2667,2667,
2667,2667,2667,1507,2667, 581, 581, 581, 581, 591,
 591, 545, 545, 669, 669, 669, 669, 866, 866,1624,
1848,1794,1741,1741,1687,2688, 563, -39,-1000, 420,
 543, 473, -40,2667,-1000,1548, 521, 502, 737,2554,
 501,1548,1507, 424,2515,-1000,1507, 265, 650,1942,
 548, 546, 424,-1000, 737, 424, 424, 427,  10, 424,
 737,-1000,-1000,1887,-1000,  11, 146,-1000, 638, 223,
1121,-1000,-1000,   5, 191,-1000, 299, 562,-1000, 424,
-1000,2277, 424,-1000,-1000,-1000,2667,-1000,-1000,1507,
1396,2273, 678, 424, 494, 216,-1000, 189, -41, 492,
2667,-1000,1507,-1000,-1000, 452, 452, 424,-1000, 407,
-1000, 424,-1000, 119,-1000,-1000, 466, 116,-1000, 110,
-1000, 370,-1000,-1000,-1000, 463,   0,-1000, -10, 114,
 574,  31, 388, 388,1507,1507,1507, 112,1507,2667,
 376,1051,-1000,-1000, 370,-1000,-1000,-1000, 737,-1000,
 424, 531, 528,2667,1548, 424, 424, 269, 808,-1000,
1507, 737,2630,   6,   2, 424, 737,-1000,1587,-1000,
 -21,-1000,-1000,-1000, 460, 215, 188, 696,-1000,-1000,
-1000, 981, 573, 737,-1000,1507, 572, 570,1329,1507,
 212, 379, 107,-1000, 104, 103,1832,  99,-1000,   3,
-1000,-1000, 338,-1000,-1000,-1000,-1000, 424, 808, 185,
 -44,-1000,2477, 409,1548,-1000, 424,-1000,-1000,-1000,
 424, 293, 737,1507,-1000, 200, 219, 422, 194, 911,
 436,1507, 176,2593,1507,1507, -17, 449,2424, 808,
 622,-1000,-1000,-1000,-1000,-1000,-1000, 193,-1000, 183,
-1000, 808,1507, 808,1507,-1000, 235,1777, 370,1507,
 737, 227, 175, 639,-1000, 283, 413,-1000, 638,-1000,
 354,  -3,-1000,1507,1329,  89, 561, 569,-1000, 808,
 169,-1000, 406,2477,1507,-1000,-1000,2667,-1000,2667,
-1000,-1000, 157,1722, 113,-1000,-1000, 351, 346,-1000,
 337, 106, 145,-1000,-1000,1667, 469,1507,1329,1507,
 152,-1000, 365,-1000,1260,-1000,2371,-1000,-1000,-1000,
 268, 447,-1000, 252,-1000,-1000, 808,-1000,1329,  51,
-1000, 556,-1000,1260,-1000, 361,   0,2477, 468,-1000,
-1000, 148,-1000, 358,-1000,1507,  21, 356,-1000,  32,
-1000, 353,-1000,-1000,-1000,-1000,1260,-1000, 553,-1000,
-1000,-1000,1191,-1000, 468, 333,1329, 278,   0, 376,
1548,-1000,-1000,-1000,-1000,
};
yypgo := array[] of {
   0, 528, 744, 164,  33,  24, 419,  15,  14,  46,
 743, 740, 736,  34, 734, 733,  27, 732,  16,   4,
 731, 108,   8,   0,  21,  35,  13, 728, 725,  94,
  25,  67,  26,  12, 723,  11,   2,  38,  41,  32,
 722,  22,   3,   7, 721, 719, 718, 716, 715,  20,
 713, 712, 711,  10, 710, 708, 697,   1, 696, 695,
 694,   6,   5, 693, 692, 691,  19,  23, 689,   9,
 667,  18, 652, 651,  17, 650, 647, 646, 643,
};
yyr1 := array[] of {
   0,  76,  75,  75,  38,  38,  39,  39,  39,  39,
  39,  39,  39,  39,  39,  39,  39,  30,  30,  37,
  37,  37,  37,  37,  37,  37,  66,  66,  48,  51,
  51,  51,  50,  50,  50,  50,  50,  49,  49,  73,
  73,  53,  53,  53,  52,  52,  52,  62,  62,  61,
  61,  60,  58,  58,  58,  59,  59,  59,  19,  20,
  20,   9,  10,  10,   6,   6,  74,  74,  74,  74,
   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,
   1,   1,   7,   7,   8,   8,  13,  13,  21,  21,
   2,   2,   2,   3,   3,   4,   4,  14,  14,  15,
  15,  16,  16,  16,  16,  11,  12,  12,  12,  12,
   5,   5,   5,   5,  40,  67,  67,  67,  41,  41,
  41,  54,  54,  43,  43,  43,  77,  77,  42,  42,
  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
  42,  42,  42,  42,  42,  42,  42,  42,  42,  42,
  17,  17,  18,  18,  44,  45,  45,  46,  47,  47,
  63,  64,  64,  36,  36,  36,  36,  36,  55,  56,
  56,  57,  57,  57,  57,  22,  22,  23,  23,  23,
  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,
  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,
  23,  23,  23,  23,  23,  23,  23,  23,  23,  23,
  23,  23,  23,  24,  24,  24,  24,  24,  24,  24,
  24,  24,  24,  24,  24,  24,  24,  24,  24,  24,
  24,  24,  24,  24,  24,  24,  24,  25,  25,  25,
  78,  25,  25,  25,  25,  25,  25,  25,  25,  25,
  25,  25,  29,  29,  31,  72,  72,  71,  71,  70,
  70,  70,  70,  65,  65,  32,  32,  32,  32,  27,
  27,  28,  28,  26,  26,  33,  33,  34,  34,  35,
  35,  69,  68,  68,
};
yyr2 := array[] of {
   0,   0,   5,   1,   1,   2,   2,   1,   1,   2,
   2,   4,   4,   4,   4,   4,   6,   1,   3,   3,
   5,   5,   4,   6,   5,   1,   4,   7,   6,   0,
   2,   1,   4,   2,   5,   5,   1,   8,  11,   0,
   4,   0,   2,   1,   1,   1,   5,   0,   2,   5,
   4,   4,   2,   2,   1,   2,   4,   4,   1,   1,
   3,   1,   1,   3,   6,   4,   1,   2,   3,   4,
   1,   1,   1,   3,   6,   2,   3,   3,   3,   3,
   4,   1,   1,   4,   3,   6,   1,   3,   0,   3,
   3,   3,   5,   1,   3,   1,   5,   0,   1,   1,
   3,   3,   3,   3,   3,   1,   1,   1,   3,   3,
   2,   3,   2,   3,   4,   4,   2,   0,   3,   2,
   4,   2,   4,   0,   2,   2,   3,   5,   2,   2,
   4,   3,   4,   6,   2,   5,   7,  10,   6,   8,
   3,   3,   3,   3,   3,   6,   5,   8,   2,   8,
   0,   2,   0,   1,   2,   2,   4,   2,   2,   4,
   2,   2,   4,   1,   3,   1,   3,   1,   2,   2,
   4,   1,   1,   3,   1,   0,   1,   1,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   4,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   1,   2,   2,   2,   2,   2,   2,
   2,   2,   2,   2,   2,   2,   2,   6,   8,   7,
   5,   3,   6,   4,   2,   2,   2,   1,   4,   3,
   0,   4,   3,   3,   4,   6,   2,   2,   1,   1,
   1,   6,   1,   1,   3,   1,   3,   1,   1,   1,
   3,   3,   2,   1,   0,   1,   1,   3,   3,   0,
   1,   1,   2,   1,   3,   1,   2,   1,   3,   1,
   3,   2,   2,   4,
};
yychk := array[] of {
-1000, -75,  73, -38, -39,   2, -37, -40, -49, -48,
 -29, -31, -30,  75,  -9, -66, -54,  59,  63,  39,
 -10,  -9,  59, -39,  72,  72,  72,   4,  16,   4,
  16,  50,  99,  61,  50,  -4,  54,  -3,  -2,  39,
 -21,  41, -32, -31, -29,  59,  99,  72, -23, -24,
  17, -25,  32,  33,  64,  65,  34,  43,  44,  38,
  67,  68,  66,  46,  69,  81,  82,  83,  60,  59,
  -6, -29,  39,  49,  61,  58,  57,  97, -23, -23,
 -23,  -1,  60,  -7,  -8,  46,  83,  39,  81,  82,
  49,  -6,  59, -31,  72,  77,  74,  -1,  76,  51,
  78,  80, -67,  52,  59,  87,  50, -14,  34, -15,
 -16, -11, -30, -12, -31,  59,  63,  -9,  40,  99,
  59, -76,  72,   4,   5,   6,   7,   8,   9,  10,
  11,  12,  13,  14,  15,  38,  16,  37,  34,  35,
  36,  32,  33,  31,  30,  26,  27,  28,  29,  24,
  25,  23,  22,  21,  20,  19,  18,  59,  39,  54,
  53,  41,  43,  44, -24, -24, -24, -24, -24, -24,
 -24, -24, -24, -24, -24, -24, -24,  41,  45,  45,
  45,  41, -24, -24, -24, -26, -23,  -3,  39,  72,
  72,  72,  72,   4,  53,  54,  -1,  45, -13,  -1,
  45,  45, -21,  41,  -1, -23,  72,   4, -23,  72,
  39,  70, -21, -41,  70,   2,  39, -29, -21,  70,
  -1,  40,  40,  99,  50,  50,  99,  42, -31, -29,
 -38, -23, -23, -23, -23, -23, -23, -23, -23, -23,
 -23, -23, -23,   4, -23, -23, -23, -23, -23, -23,
 -23, -23, -23, -23, -23, -23, -23, -23, -23, -23,
 -23, -23, -23, -23, -23, -23, -27, -26,  59, -25,
 -71, -22, -72, -23, -70,  60,  81,  82,  79, -23,
  42,  60,  70,  -1, -23,  40,  99, -78, -23, -23,
  59,  59,  -1,  40,  99,  -1,  -1,  -4, -74,  -1,
  79,  72,  72, -23,  72, -13, -51,   2,  70,  87,
 -43,  71,  70, -32, -69, -68,  -9,  34, -16,  -1,
  -5,  84,  -1,  -5,  59,  63, -23,  40,  42,  50,
  99,  45,  45,  -1,  42,  45, -24, -28, -26,  42,
 -23, -41,  99,  40,  72,  41,  41,  -1, -67,  99,
  42,  -1,  72,  40,  71, -50,  -9, -49, -66, -53,
   2,  70,  71, -37, -42,  -9,   2,  70, -77, -22,
  47, -17,  88,  92,  93,  95,  96,  94,  39, -23,
  59, -43,  40,  71, -62,  62,  40,  -7,  46,  -8,
  -1, -22, -71, -23,  60,  -1,  -1,  45,  70,  71,
  99,  45, -23, -74, -74,  -1,  79,  72,  50,  72,
  71, -52, -61, -60,  -9,  91, -69,  50,  72,  71,
  70, -43,  99,  50,  72,  39,  87,  86,  85,  90,
  89,  91, -18,  59, -18, -22, -23, -22,  72, -26,
  71, -61,  -9,  -7,  -8,  42,  42,  -1,  70, -33,
 -34, -35, -23, -36,  34,   2,  -1,  40,  42,  42,
  -1,  -1,  77,  76, -73,  87,  50,  70,  71, -43,
  71,  39,  -1, -23,  39,  39, -42,  -9, -23,  70,
  59,  72,  72,  72,  72,  72,  40,  50,  62, -33,
  71,  99,  55,  56,  62,  72,  -1, -23,  70,  76,
  79,  -1, -58, -59,   2, -19, -20,  59,  70,  71,
  51, -26,  72,   4,  40, -22, -22,  86,  50,  70,
 -44, -45, -36, -23,  16,  71, -35, -23, -36, -23,
  72,  72, -69, -23,  -1,  72,  71, -62,   2,  62,
  56, -53, -65,  59,  40, -23, -42,  72,  40,  39,
 -46, -47, -36,  71, -43,  62, -23,  71,  72,  72,
 -19,  -9,  59, -19,  59,  71,  70,  72,  48, -22,
 -42, -22,  71, -43,  62, -36,   2, -23,  70,  62,
  62, -63, -64, -36, -42,  72,  40, -36,  62, -55,
 -56, -57,  59,  34,   2,  71, -43,  62, -22,  72,
  62,  71, -43,  62,  56, -36,  40, -57,   2,  59,
  34, -57,  62, -42,  62,
};
yydef := array[] of {
   0,  -2,   0,  -2,   4,   0,   7,   8,   0,   0,
   0,  17,   0,   0,   0,  25,   0,  -2, 253,   0,
  61,   0,  62,   5,   6,   9,  10,   0,   0,   0,
   0,   0,   0,   0,   0, 117,   0,  95,  93,  97,
 121,   0,   0, 265, 266, 252,   0,   1,   0, 177,
   0, 213,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0, 252,
   0, 237,   0,   0, 248, 249, 250,   0,   0,   0,
   0,   0,  70,  71,  72,   0,   0,   0,   0,   0,
  88,  81,  82,  18,  19,   0,   0,   0,   0,   0,
   0,  88,   0,   0,  88,   0,   0,   0,   0,  98,
  99,   0,   0, 105,  17, 106, 107,   0, 254,   0,
  63,   0,  11,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
   0,   0,   0,   0,   0,   0,   0,   0, 269,   0,
   0, 175, 246, 247, 214, 215, 216, 217, 218, 219,
 220, 221, 222, 223, 224, 225, 226,   0,   0,   0,
   0,   0, 234, 235, 236,   0, 273, 240,   0,  13,
  12,  14,  15,   0,   0,   0,  75,   0,   0,  86,
   0,   0,   0,   0,   0,   0,  22,   0,   0,  26,
   0,  -2,   0, 114, 123,   0,   0, 116, 122,   0,
  94,  90,  91,   0,   0,   0,   0,  89, 267, 268,
  -2, 178, 179, 180, 181, 182, 183, 184, 185, 186,
 187, 188, 189,   0, 191, 193, 194, 195, 196, 197,
 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
 208, 209, 210, 211, 212, 192,   0, 270, 242, 243,
 255,   0,   0,  -2, 258, 259,   0,   0,   0,   0,
   0,   0,   0, 231,   0, 239,   0,   0,   0,   0,
  73,  84,  76,  77,   0,  78,  79, 117,   0,  66,
   0,  20,  21,   0,  24,   0,   0,  31,  -2,   0,
  -2, 119, 123,   0,   0,  47,   0,   0, 100, 101,
 102,   0, 103, 104, 108, 109, 190, 238, 244, 175,
   0,   0,   0, 262,   0,   0, 233,   0, 271,   0,
 274, 241,   0,  65,  16,   0,   0,  87,  80,   0,
  83,  67,  23,   0,  28,  30,   0,   0,  36,   0,
  43,   0, 118, 124, 125,   0,   0, 123,   0,   0,
   0,   0, 152, 152, 175,   0, 175,   0,   0, 176,
  -2,  -2, 115,  96, 281, 282,  92,  -2,   0,  -2,
   0,   0, 256, 257,  70, 260, 261,   0,   0, 230,
 272,   0,   0,   0,   0,  68,   0,  27,   0,  33,
  39,  42,  44,  45,   0,   0,   0, 151, 128, 129,
 123,  -2,   0,   0, 134,   0,   0,   0,  -2,   0,
   0,   0,   0, 153,   0,   0,   0,   0, 148,   0,
 120,  48,   0,  -2,  -2, 245, 251, 227,   0,   0,
 275, 277,  -2,   0, 165, 167, 232,  64,  74,  85,
  69,   0,   0,   0,  37,   0,   0,   0,   0,  -2,
 131,   0,   0,   0, 175, 175,   0,   0,   0,   0,
   0, 140, 141, 142, 143, 144,  -2,   0, 283,   0,
 229,  -2,   0,   0,   0,  32,   0,   0,   0,   0,
   0,   0,   0,  -2,  54,   0,  58,  59,  -2, 130,
 264,   0, 132,   0,  -2,   0,   0,   0, 151,   0,
   0, 123,   0, 163,   0, 228, 278, 164, 166, 280,
  34,  35,   0,   0,   0,  50,  51,  52,  53,  55,
   0,   0,   0, 263, 127,   0, 135, 175,  -2, 175,
   0, 123,   0, 146,  -2, 155,   0,  40,  46,  49,
   0,   0,  -2,   0,  60,  38,   0, 133,  -2,   0,
 138,   0, 145,  -2, 158,   0, 167,  -2,   0,  56,
  57,   0, 123,   0, 136, 175,   0,   0, 156,   0,
 123,   0, 171, 172, 174, 149,  -2, 161,   0, 139,
 159, 147,  -2, 169,   0,   0,  -2,   0, 174,  -2,
 172, 173, 162, 137, 170,
};
yytok1 := array[] of {
   1,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,  64,   3,   3,   3,  36,  23,   3,
  39,  40,  34,  32,  99,  33,  54,  35,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,  50,  72,
  26,   4,  27,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,  41,   3,  42,  22,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,   3,   3,   3,   3,   3,   3,   3,
   3,   3,   3,  70,  21,  71,  65,
};
yytok2 := array[] of {
   2,   3,   5,   6,   7,   8,   9,  10,  11,  12,
  13,  14,  15,  16,  17,  18,  19,  20,  24,  25,
  28,  29,  30,  31,  37,  38,  43,  44,  45,  46,
  47,  48,  49,  51,  52,  53,  55,  56,  57,  58,
  59,  60,  61,  62,  63,  66,  67,  68,  69,  73,
  74,  75,  76,  77,  78,  79,  80,  81,  82,  83,
  84,  85,  86,  87,  88,  89,  90,  91,  92,  93,
  94,  95,  96,  97,  98,
};
yytok3 := array[] of {
   0
};

YYSys: module
{
	FD: adt
	{
		fd:	int;
	};
	fildes:		fn(fd: int): ref FD;
	fprint:		fn(fd: ref FD, s: string, *): int;
};

yysys: YYSys;
yystderr: ref YYSys->FD;

YYFLAG: con -1000;

# parser for yacc output

yytokname(yyc: int): string
{
	if(yyc > 0 && yyc <= len yytoknames && yytoknames[yyc-1] != nil)
		return yytoknames[yyc-1];
	return "<"+string yyc+">";
}

yystatname(yys: int): string
{
	if(yys >= 0 && yys < len yystates && yystates[yys] != nil)
		return yystates[yys];
	return "<"+string yys+">\n";
}

yylex1(yylex: ref YYLEX): int
{
	c : int;
	yychar := yylex.lex();
	if(yychar <= 0)
		c = yytok1[0];
	else if(yychar < len yytok1)
		c = yytok1[yychar];
	else if(yychar >= YYPRIVATE && yychar < YYPRIVATE+len yytok2)
		c = yytok2[yychar-YYPRIVATE];
	else{
		n := len yytok3;
		c = 0;
		for(i := 0; i < n; i+=2) {
			if(yytok3[i+0] == yychar) {
				c = yytok3[i+1];
				break;
			}
		}
		if(c == 0)
			c = yytok2[1];	# unknown char
	}
	if(yydebug >= 3)
		yysys->fprint(yystderr, "lex %.4ux %s\n", yychar, yytokname(c));
	return c;
}

YYS: adt
{
	yyv: YYSTYPE;
	yys: int;
};

yyparse(yylex: ref YYLEX): int
{
	if(yydebug >= 1 && yysys == nil) {
		yysys = load YYSys "$Sys";
		yystderr = yysys->fildes(2);
	}

	yys := array[YYMAXDEPTH] of YYS;

	yyval: YYSTYPE;
	yystate := 0;
	yychar := -1;
	yynerrs := 0;		# number of errors
	yyerrflag := 0;		# error recovery flag
	yyp := -1;
	yyn := 0;

yystack:
	for(;;){
		# put a state and value onto the stack
		if(yydebug >= 4)
			yysys->fprint(yystderr, "char %s in %s", yytokname(yychar), yystatname(yystate));

		yyp++;
		if(yyp >= len yys)
			yys = (array[len yys * 2] of YYS)[0:] = yys;
		yys[yyp].yys = yystate;
		yys[yyp].yyv = yyval;

		for(;;){
			yyn = yypact[yystate];
			if(yyn > YYFLAG) {	# simple state
				if(yychar < 0)
					yychar = yylex1(yylex);
				yyn += yychar;
				if(yyn >= 0 && yyn < YYLAST) {
					yyn = yyact[yyn];
					if(yychk[yyn] == yychar) { # valid shift
						yychar = -1;
						yyp++;
						if(yyp >= len yys)
							yys = (array[len yys * 2] of YYS)[0:] = yys;
						yystate = yyn;
						yys[yyp].yys = yystate;
						yys[yyp].yyv = yylex.lval;
						if(yyerrflag > 0)
							yyerrflag--;
						if(yydebug >= 4)
							yysys->fprint(yystderr, "char %s in %s", yytokname(yychar), yystatname(yystate));
						continue;
					}
				}
			}
		
			# default state action
			yyn = yydef[yystate];
			if(yyn == -2) {
				if(yychar < 0)
					yychar = yylex1(yylex);
		
				# look through exception table
				for(yyxi:=0;; yyxi+=2)
					if(yyexca[yyxi] == -1 && yyexca[yyxi+1] == yystate)
						break;
				for(yyxi += 2;; yyxi += 2) {
					yyn = yyexca[yyxi];
					if(yyn < 0 || yyn == yychar)
						break;
				}
				yyn = yyexca[yyxi+1];
				if(yyn < 0){
					yyn = 0;
					break yystack;
				}
			}

			if(yyn != 0)
				break;

			# error ... attempt to resume parsing
			if(yyerrflag == 0) { # brand new error
				yylex.error("syntax error");
				yynerrs++;
				if(yydebug >= 1) {
					yysys->fprint(yystderr, "%s", yystatname(yystate));
					yysys->fprint(yystderr, "saw %s\n", yytokname(yychar));
				}
			}

			if(yyerrflag != 3) { # incompletely recovered error ... try again
				yyerrflag = 3;
	
				# find a state where "error" is a legal shift action
				while(yyp >= 0) {
					yyn = yypact[yys[yyp].yys] + YYERRCODE;
					if(yyn >= 0 && yyn < YYLAST) {
						yystate = yyact[yyn];  # simulate a shift of "error"
						if(yychk[yystate] == YYERRCODE)
							continue yystack;
					}
	
					# the current yyp has no shift onn "error", pop stack
					if(yydebug >= 2)
						yysys->fprint(yystderr, "error recovery pops state %d, uncovers %d\n",
							yys[yyp].yys, yys[yyp-1].yys );
					yyp--;
				}
				# there is no state on the stack with an error shift ... abort
				yyn = 1;
				break yystack;
			}

			# no shift yet; clobber input char
			if(yydebug >= 2)
				yysys->fprint(yystderr, "error recovery discards %s\n", yytokname(yychar));
			if(yychar == YYEOFCODE) {
				yyn = 1;
				break yystack;
			}
			yychar = -1;
			# try again in the same state
		}
	
		# reduction by production yyn
		if(yydebug >= 2)
			yysys->fprint(yystderr, "reduce %d in:\n\t%s", yyn, yystatname(yystate));
	
		yypt := yyp;
		yyp -= yyr2[yyn];
#		yyval = yys[yyp+1].yyv;
		yym := yyn;
	
		# consult goto table to find next state
		yyn = yyr1[yyn];
		yyg := yypgo[yyn];
		yyj := yyg + yys[yyp].yys + 1;
	
		if(yyj >= YYLAST || yychk[yystate=yyact[yyj]] != -yyn)
			yystate = yyact[yyg];
		case yym {
			
1=>
#line	152	"limbo.y"
{
		impmods = yys[yypt-1].yyv.ids;
	}
2=>
#line	155	"limbo.y"
{
		tree = rotater(yys[yypt-0].yyv.node);
	}
3=>
#line	159	"limbo.y"
{
		impmods = nil;
		tree = rotater(yys[yypt-0].yyv.node);
	}
4=>
yyval.node = yys[yyp+1].yyv.node;
5=>
#line	167	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else if(yys[yypt-0].yyv.node == nil)
			yyval.node = yys[yypt-1].yyv.node;
		else
			yyval.node = mkbin(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
6=>
#line	178	"limbo.y"
{
		yyval.node = nil;
	}
7=>
yyval.node = yys[yyp+1].yyv.node;
8=>
yyval.node = yys[yyp+1].yyv.node;
9=>
yyval.node = yys[yyp+1].yyv.node;
10=>
yyval.node = yys[yyp+1].yyv.node;
11=>
#line	186	"limbo.y"
{
		yyval.node = mkbin(Oas, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
	}
12=>
#line	190	"limbo.y"
{
		yyval.node = mkbin(Oas, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
	}
13=>
#line	194	"limbo.y"
{
		yyval.node = mkbin(Odas, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
	}
14=>
#line	198	"limbo.y"
{
		yyval.node = mkbin(Odas, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
	}
15=>
#line	202	"limbo.y"
{
		yyerror("illegal declaration");
		yyval.node = nil;
	}
16=>
#line	207	"limbo.y"
{
		yyerror("illegal declaration");
		yyval.node = nil;
	}
17=>
yyval.node = yys[yyp+1].yyv.node;
18=>
#line	215	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
19=>
#line	221	"limbo.y"
{
		includef(yys[yypt-1].yyv.tok.v.idval);
		yyval.node = nil;
	}
20=>
#line	226	"limbo.y"
{
		yyval.node = typedecl(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.ty);
	}
21=>
#line	230	"limbo.y"
{
		yyval.node = importdecl(yys[yypt-1].yyv.node, yys[yypt-4].yyv.ids);
		yyval.node.src.start = yys[yypt-4].yyv.ids.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
22=>
#line	236	"limbo.y"
{
		yyval.node = vardecl(yys[yypt-3].yyv.ids, yys[yypt-1].yyv.ty);
	}
23=>
#line	240	"limbo.y"
{
		yyval.node = mkbin(Ovardecli, vardecl(yys[yypt-5].yyv.ids, yys[yypt-3].yyv.ty), varinit(yys[yypt-5].yyv.ids, yys[yypt-1].yyv.node));
	}
24=>
#line	244	"limbo.y"
{
		yyval.node = condecl(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.node);
	}
25=>
yyval.node = yys[yyp+1].yyv.node;
26=>
#line	251	"limbo.y"
{
		yyval.node = exdecl(yys[yypt-3].yyv.ids, nil);
	}
27=>
#line	255	"limbo.y"
{
		yyval.node = exdecl(yys[yypt-6].yyv.ids, revids(yys[yypt-2].yyv.ids));
	}
28=>
#line	261	"limbo.y"
{
		yys[yypt-5].yyv.ids.src.stop = yys[yypt-0].yyv.tok.src.stop;
		yyval.node = moddecl(yys[yypt-5].yyv.ids, rotater(yys[yypt-1].yyv.node));
	}
29=>
#line	268	"limbo.y"
{
		yyval.node = nil;
	}
30=>
#line	272	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else if(yys[yypt-0].yyv.node == nil)
			yyval.node = yys[yypt-1].yyv.node;
		else
			yyval.node = mkn(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
31=>
#line	281	"limbo.y"
{
		yyval.node = nil;
	}
32=>
#line	287	"limbo.y"
{
		yyval.node = fielddecl(Dglobal, typeids(yys[yypt-3].yyv.ids, yys[yypt-1].yyv.ty));
	}
33=>
yyval.node = yys[yyp+1].yyv.node;
34=>
#line	292	"limbo.y"
{
		yyval.node = typedecl(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.ty);
	}
35=>
#line	296	"limbo.y"
{
		yyval.node = condecl(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.node);
	}
36=>
yyval.node = yys[yyp+1].yyv.node;
37=>
#line	303	"limbo.y"
{
		yys[yypt-7].yyv.ids.src.stop = yys[yypt-1].yyv.tok.src.stop;
		yyval.node = adtdecl(yys[yypt-7].yyv.ids, rotater(yys[yypt-2].yyv.node));
		yyval.node.ty.polys = yys[yypt-4].yyv.ids;
		yyval.node.ty.val = rotater(yys[yypt-0].yyv.node);
	}
38=>
#line	310	"limbo.y"
{
		yys[yypt-10].yyv.ids.src.stop = yys[yypt-0].yyv.tok.src.stop;
		yyval.node = adtdecl(yys[yypt-10].yyv.ids, rotater(yys[yypt-1].yyv.node));
		yyval.node.ty.polys = yys[yypt-7].yyv.ids;
		yyval.node.ty.val = rotater(yys[yypt-4].yyv.node);
	}
39=>
#line	319	"limbo.y"
{
		yyval.node = nil;
	}
40=>
#line	323	"limbo.y"
{
		yyval.node = yys[yypt-1].yyv.node;
	}
41=>
#line	329	"limbo.y"
{
		yyval.node = nil;
	}
42=>
#line	333	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else if(yys[yypt-0].yyv.node == nil)
			yyval.node = yys[yypt-1].yyv.node;
		else
			yyval.node = mkn(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
43=>
#line	342	"limbo.y"
{
		yyval.node = nil;
	}
44=>
yyval.node = yys[yyp+1].yyv.node;
45=>
yyval.node = yys[yyp+1].yyv.node;
46=>
#line	350	"limbo.y"
{
		yyval.node = condecl(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.node);
	}
47=>
#line	356	"limbo.y"
{
		yyval.node = nil;
	}
48=>
#line	360	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else if(yys[yypt-0].yyv.node == nil)
			yyval.node = yys[yypt-1].yyv.node;
		else
			yyval.node = mkn(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
49=>
#line	371	"limbo.y"
{
		for(d := yys[yypt-4].yyv.ids; d != nil; d = d.next)
			d.cyc = byte 1;
		yyval.node = fielddecl(Dfield, typeids(yys[yypt-4].yyv.ids, yys[yypt-1].yyv.ty));
	}
50=>
#line	377	"limbo.y"
{
		yyval.node = fielddecl(Dfield, typeids(yys[yypt-3].yyv.ids, yys[yypt-1].yyv.ty));
	}
51=>
#line	383	"limbo.y"
{
		yyval.node = yys[yypt-1].yyv.node;
	}
52=>
#line	389	"limbo.y"
{
		yys[yypt-1].yyv.node.right.right = yys[yypt-0].yyv.node;
		yyval.node = yys[yypt-1].yyv.node;
	}
53=>
#line	394	"limbo.y"
{
		yyval.node = nil;
	}
54=>
#line	398	"limbo.y"
{
		yyval.node = nil;
	}
55=>
#line	404	"limbo.y"
{
		yyval.node = mkn(Opickdecl, nil, mkn(Oseq, fielddecl(Dtag, yys[yypt-1].yyv.ids), nil));
		typeids(yys[yypt-1].yyv.ids, mktype(yys[yypt-1].yyv.ids.src.start, yys[yypt-1].yyv.ids.src.stop, Tadtpick, nil, nil));
	}
56=>
#line	409	"limbo.y"
{
		yys[yypt-3].yyv.node.right.right = yys[yypt-2].yyv.node;
		yyval.node = mkn(Opickdecl, yys[yypt-3].yyv.node, mkn(Oseq, fielddecl(Dtag, yys[yypt-1].yyv.ids), nil));
		typeids(yys[yypt-1].yyv.ids, mktype(yys[yypt-1].yyv.ids.src.start, yys[yypt-1].yyv.ids.src.stop, Tadtpick, nil, nil));
	}
57=>
#line	415	"limbo.y"
{
		yyval.node = mkn(Opickdecl, nil, mkn(Oseq, fielddecl(Dtag, yys[yypt-1].yyv.ids), nil));
		typeids(yys[yypt-1].yyv.ids, mktype(yys[yypt-1].yyv.ids.src.start, yys[yypt-1].yyv.ids.src.stop, Tadtpick, nil, nil));
	}
58=>
#line	422	"limbo.y"
{
		yyval.ids = revids(yys[yypt-0].yyv.ids);
	}
59=>
#line	428	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, nil);
	}
60=>
#line	432	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, yys[yypt-2].yyv.ids);
	}
61=>
#line	438	"limbo.y"
{
		yyval.ids = revids(yys[yypt-0].yyv.ids);
	}
62=>
#line	444	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, nil);
	}
63=>
#line	448	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, yys[yypt-2].yyv.ids);
	}
64=>
#line	454	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-5].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tfix, nil, nil);
		yyval.ty.val = mkbin(Oseq, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
	}
65=>
#line	459	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-3].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tfix, nil, nil);
		yyval.ty.val = yys[yypt-1].yyv.node;
	}
66=>
#line	466	"limbo.y"
{
		yyval.types = addtype(yys[yypt-0].yyv.ty, nil);
	}
67=>
#line	470	"limbo.y"
{
		yyval.types = addtype(yys[yypt-0].yyv.ty, nil);
		yys[yypt-0].yyv.ty.flags |= CYCLIC;
	}
68=>
#line	475	"limbo.y"
{
		yyval.types = addtype(yys[yypt-0].yyv.ty, yys[yypt-2].yyv.types);
	}
69=>
#line	479	"limbo.y"
{
		yyval.types = addtype(yys[yypt-0].yyv.ty, yys[yypt-3].yyv.types);
		yys[yypt-0].yyv.ty.flags |= CYCLIC;
	}
70=>
#line	486	"limbo.y"
{
		yyval.ty = mkidtype(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
71=>
#line	490	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
72=>
#line	494	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
73=>
#line	498	"limbo.y"
{
		yyval.ty = mkarrowtype(yys[yypt-2].yyv.ty.src.start, yys[yypt-0].yyv.tok.src.stop, yys[yypt-2].yyv.ty, yys[yypt-0].yyv.tok.v.idval);
	}
74=>
#line	502	"limbo.y"
{
		yyval.ty = mkarrowtype(yys[yypt-5].yyv.ty.src.start, yys[yypt-3].yyv.tok.src.stop, yys[yypt-5].yyv.ty, yys[yypt-3].yyv.tok.v.idval);
		yyval.ty = mkinsttype(yys[yypt-5].yyv.ty.src, yyval.ty, yys[yypt-1].yyv.types);
	}
75=>
#line	507	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-1].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tref, yys[yypt-0].yyv.ty, nil);
	}
76=>
#line	511	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tchan, yys[yypt-0].yyv.ty, nil);
	}
77=>
#line	515	"limbo.y"
{
		if(yys[yypt-1].yyv.ids.next == nil)
			yyval.ty = yys[yypt-1].yyv.ids.ty;
		else
			yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Ttuple, nil, revids(yys[yypt-1].yyv.ids));
	}
78=>
#line	522	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tarray, yys[yypt-0].yyv.ty, nil);
	}
79=>
#line	526	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tlist, yys[yypt-0].yyv.ty, nil);
	}
80=>
#line	530	"limbo.y"
{
		yys[yypt-1].yyv.ty.src.start = yys[yypt-3].yyv.tok.src.start;
		yys[yypt-1].yyv.ty.polys = yys[yypt-2].yyv.ids;
		yys[yypt-1].yyv.ty.eraises = yys[yypt-0].yyv.node;
		yyval.ty = yys[yypt-1].yyv.ty;
	}
81=>
yyval.ty = yys[yyp+1].yyv.ty;
82=>
#line	550	"limbo.y"
{
		yyval.ty = mkidtype(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
83=>
#line	554	"limbo.y"
{
		yyval.ty = mkinsttype(yys[yypt-3].yyv.tok.src, mkidtype(yys[yypt-3].yyv.tok.src, yys[yypt-3].yyv.tok.v.idval), yys[yypt-1].yyv.types);
	}
84=>
#line	560	"limbo.y"
{
		yyval.ty = mkdottype(yys[yypt-2].yyv.ty.src.start, yys[yypt-0].yyv.tok.src.stop, yys[yypt-2].yyv.ty, yys[yypt-0].yyv.tok.v.idval);
	}
85=>
#line	564	"limbo.y"
{
		yyval.ty = mkdottype(yys[yypt-5].yyv.ty.src.start, yys[yypt-3].yyv.tok.src.stop, yys[yypt-5].yyv.ty, yys[yypt-3].yyv.tok.v.idval);
		yyval.ty = mkinsttype(yys[yypt-5].yyv.ty.src, yyval.ty, yys[yypt-1].yyv.types);
	}
86=>
#line	571	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.ty.src, nil, yys[yypt-0].yyv.ty, nil);
	}
87=>
#line	575	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-2].yyv.ids.src, nil, yys[yypt-0].yyv.ty, yys[yypt-2].yyv.ids);
	}
88=>
#line	581	"limbo.y"
{
		yyval.ids = nil;
	}
89=>
#line	585	"limbo.y"
{
		yyval.ids = polydecl(yys[yypt-1].yyv.ids);
	}
90=>
#line	591	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tfn, tnone, yys[yypt-1].yyv.ids);
	}
91=>
#line	595	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tfn, tnone, nil);
		yyval.ty.varargs = byte 1;
	}
92=>
#line	600	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-4].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tfn, tnone, yys[yypt-3].yyv.ids);
		yyval.ty.varargs = byte 1;
	}
93=>
#line	607	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
94=>
#line	611	"limbo.y"
{
		yys[yypt-2].yyv.ty.tof = yys[yypt-0].yyv.ty;
		yys[yypt-2].yyv.ty.src.stop = yys[yypt-0].yyv.ty.src.stop;
		yyval.ty = yys[yypt-2].yyv.ty;
	}
95=>
#line	619	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
96=>
#line	623	"limbo.y"
{
		yyval.ty = yys[yypt-4].yyv.ty;
		yyval.ty.val = rotater(yys[yypt-1].yyv.node);
	}
97=>
#line	630	"limbo.y"
{
		yyval.ids = nil;
	}
98=>
yyval.ids = yys[yyp+1].yyv.ids;
99=>
yyval.ids = yys[yyp+1].yyv.ids;
100=>
#line	638	"limbo.y"
{
		yyval.ids = appdecls(yys[yypt-2].yyv.ids, yys[yypt-0].yyv.ids);
	}
101=>
#line	644	"limbo.y"
{
		yyval.ids = typeids(yys[yypt-2].yyv.ids, yys[yypt-0].yyv.ty);
	}
102=>
#line	648	"limbo.y"
{
		yyval.ids = typeids(yys[yypt-2].yyv.ids, yys[yypt-0].yyv.ty);
		for(d := yyval.ids; d != nil; d = d.next)
			d.implicit = byte 1;
	}
103=>
#line	654	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-2].yyv.node.src, enter("junk", 0), yys[yypt-0].yyv.ty, nil);
		yyval.ids.store = Darg;
		yyerror("illegal argument declaraion");
	}
104=>
#line	660	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-2].yyv.node.src, enter("junk", 0), yys[yypt-0].yyv.ty, nil);
		yyval.ids.store = Darg;
		yyerror("illegal argument declaraion");
	}
105=>
#line	668	"limbo.y"
{
		yyval.ids = revids(yys[yypt-0].yyv.ids);
	}
106=>
#line	674	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, nil);
		yyval.ids.store = Darg;
	}
107=>
#line	679	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, nil, nil, nil);
		yyval.ids.store = Darg;
	}
108=>
#line	684	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, yys[yypt-2].yyv.ids);
		yyval.ids.store = Darg;
	}
109=>
#line	689	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, nil, nil, yys[yypt-2].yyv.ids);
		yyval.ids.store = Darg;
	}
110=>
#line	696	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
111=>
#line	700	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-1].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tref, yys[yypt-0].yyv.ty, nil);
	}
112=>
#line	704	"limbo.y"
{
		yyval.ty = yys[yypt-0].yyv.ty;
	}
113=>
#line	708	"limbo.y"
{
		yyval.ty = mktype(yys[yypt-1].yyv.tok.src.start, yys[yypt-0].yyv.tok.src.stop, Tref, yys[yypt-0].yyv.ty, nil);
	}
114=>
#line	714	"limbo.y"
{
		yyval.node = fndecl(yys[yypt-3].yyv.node, yys[yypt-2].yyv.ty, yys[yypt-0].yyv.node);
		nfns++;
		# patch up polydecs
		if(yys[yypt-3].yyv.node.op == Odot){
			if(yys[yypt-3].yyv.node.right.left != nil){
				yys[yypt-2].yyv.ty.polys = yys[yypt-3].yyv.node.right.left.decl;
				yys[yypt-3].yyv.node.right.left = nil;
			}
			if(yys[yypt-3].yyv.node.left.op == Oname && yys[yypt-3].yyv.node.left.left != nil){
				yyval.node.decl = yys[yypt-3].yyv.node.left.left.decl;
				yys[yypt-3].yyv.node.left.left = nil;
			}
		}
		else{
			if(yys[yypt-3].yyv.node.left != nil){
				yys[yypt-2].yyv.ty.polys = yys[yypt-3].yyv.node.left.decl;
				yys[yypt-3].yyv.node.left = nil;
			}
		}
		yys[yypt-2].yyv.ty.eraises = yys[yypt-1].yyv.node;
		yyval.node.src = yys[yypt-3].yyv.node.src;
	}
115=>
#line	740	"limbo.y"
{
		yyval.node = mkn(Otuple, rotater(yys[yypt-1].yyv.node), nil);
		yyval.node.src.start = yys[yypt-3].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
116=>
#line	746	"limbo.y"
{
		yyval.node = mkn(Otuple, mkunary(Oseq, yys[yypt-0].yyv.node), nil);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.node.src.stop;
	}
117=>
#line	752	"limbo.y"
{
		yyval.node = nil;
	}
118=>
#line	758	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil){
			yys[yypt-1].yyv.node = mkn(Onothing, nil, nil);
			yys[yypt-1].yyv.node.src.start = curline();
			yys[yypt-1].yyv.node.src.stop = yys[yypt-1].yyv.node.src.start;
		}
		yyval.node = rotater(yys[yypt-1].yyv.node);
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
119=>
#line	769	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
	}
120=>
#line	773	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
	}
121=>
#line	779	"limbo.y"
{
		yyval.node = mkname(yys[yypt-1].yyv.tok.src, yys[yypt-1].yyv.tok.v.idval);
		if(yys[yypt-0].yyv.ids != nil){
			yyval.node.left = mkn(Onothing, nil ,nil);
			yyval.node.left.decl = yys[yypt-0].yyv.ids;
		}
	}
122=>
#line	787	"limbo.y"
{
		yyval.node = mkbin(Odot, yys[yypt-3].yyv.node, mkname(yys[yypt-1].yyv.tok.src, yys[yypt-1].yyv.tok.v.idval));
		if(yys[yypt-0].yyv.ids != nil){
			yyval.node.right.left = mkn(Onothing, nil ,nil);
			yyval.node.right.left.decl = yys[yypt-0].yyv.ids;
		}
	}
123=>
#line	797	"limbo.y"
{
		yyval.node = nil;
	}
124=>
#line	801	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else if(yys[yypt-0].yyv.node == nil)
			yyval.node = yys[yypt-1].yyv.node;
		else
			yyval.node = mkbin(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
125=>
#line	810	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil)
			yyval.node = yys[yypt-0].yyv.node;
		else
			yyval.node = mkbin(Oseq, yys[yypt-1].yyv.node, yys[yypt-0].yyv.node);
	}
128=>
#line	823	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
129=>
#line	829	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
130=>
#line	835	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
131=>
#line	841	"limbo.y"
{
		if(yys[yypt-1].yyv.node == nil){
			yys[yypt-1].yyv.node = mkn(Onothing, nil, nil);
			yys[yypt-1].yyv.node.src.start = curline();
			yys[yypt-1].yyv.node.src.stop = yys[yypt-1].yyv.node.src.start;
		}
		yyval.node = mkscope(rotater(yys[yypt-1].yyv.node));
	}
132=>
#line	850	"limbo.y"
{
		yyerror("illegal declaration");
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
133=>
#line	857	"limbo.y"
{
		yyerror("illegal declaration");
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
134=>
#line	864	"limbo.y"
{
		yyval.node = yys[yypt-1].yyv.node;
	}
135=>
#line	868	"limbo.y"
{
		yyval.node = mkn(Oif, yys[yypt-2].yyv.node, mkunary(Oseq, yys[yypt-0].yyv.node));
		yyval.node.src.start = yys[yypt-4].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.node.src.stop;
	}
136=>
#line	874	"limbo.y"
{
		yyval.node = mkn(Oif, yys[yypt-4].yyv.node, mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node));
		yyval.node.src.start = yys[yypt-6].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.node.src.stop;
	}
137=>
#line	880	"limbo.y"
{
		yyval.node = mkunary(Oseq, yys[yypt-0].yyv.node);
		if(yys[yypt-2].yyv.node.op != Onothing)
			yyval.node.right = yys[yypt-2].yyv.node;
		yyval.node = mkbin(Ofor, yys[yypt-4].yyv.node, yyval.node);
		yyval.node.decl = yys[yypt-9].yyv.ids;
		if(yys[yypt-6].yyv.node.op != Onothing)
			yyval.node = mkbin(Oseq, yys[yypt-6].yyv.node, yyval.node);
	}
138=>
#line	890	"limbo.y"
{
		yyval.node = mkn(Ofor, yys[yypt-2].yyv.node, mkunary(Oseq, yys[yypt-0].yyv.node));
		yyval.node.src.start = yys[yypt-4].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.node.src.stop;
		yyval.node.decl = yys[yypt-5].yyv.ids;
	}
139=>
#line	897	"limbo.y"
{
		yyval.node = mkn(Odo, yys[yypt-2].yyv.node, yys[yypt-5].yyv.node);
		yyval.node.src.start = yys[yypt-6].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-1].yyv.tok.src.stop;
		yyval.node.decl = yys[yypt-7].yyv.ids;
	}
140=>
#line	904	"limbo.y"
{
		yyval.node = mkn(Obreak, nil, nil);
		yyval.node.decl = yys[yypt-1].yyv.ids;
		yyval.node.src = yys[yypt-2].yyv.tok.src;
	}
141=>
#line	910	"limbo.y"
{
		yyval.node = mkn(Ocont, nil, nil);
		yyval.node.decl = yys[yypt-1].yyv.ids;
		yyval.node.src = yys[yypt-2].yyv.tok.src;
	}
142=>
#line	916	"limbo.y"
{
		yyval.node = mkn(Oret, yys[yypt-1].yyv.node, nil);
		yyval.node.src = yys[yypt-2].yyv.tok.src;
		if(yys[yypt-1].yyv.node.op == Onothing)
			yyval.node.left = nil;
		else
			yyval.node.src.stop = yys[yypt-1].yyv.node.src.stop;
	}
143=>
#line	925	"limbo.y"
{
		yyval.node = mkn(Ospawn, yys[yypt-1].yyv.node, nil);
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-1].yyv.node.src.stop;
	}
144=>
#line	931	"limbo.y"
{
		yyval.node = mkn(Oraise, yys[yypt-1].yyv.node, nil);
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-1].yyv.node.src.stop;
	}
145=>
#line	937	"limbo.y"
{
		yyval.node = mkn(Ocase, yys[yypt-3].yyv.node, caselist(yys[yypt-1].yyv.node, nil));
		yyval.node.src = yys[yypt-3].yyv.node.src;
		yyval.node.decl = yys[yypt-5].yyv.ids;
	}
146=>
#line	943	"limbo.y"
{
		yyval.node = mkn(Oalt, caselist(yys[yypt-1].yyv.node, nil), nil);
		yyval.node.src = yys[yypt-3].yyv.tok.src;
		yyval.node.decl = yys[yypt-4].yyv.ids;
	}
147=>
#line	949	"limbo.y"
{
		yyval.node = mkn(Opick, mkbin(Odas, mkname(yys[yypt-5].yyv.tok.src, yys[yypt-5].yyv.tok.v.idval), yys[yypt-3].yyv.node), caselist(yys[yypt-1].yyv.node, nil));
		yyval.node.src.start = yys[yypt-5].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-3].yyv.node.src.stop;
		yyval.node.decl = yys[yypt-7].yyv.ids;
	}
148=>
#line	956	"limbo.y"
{
		yyval.node = mkn(Oexit, nil, nil);
		yyval.node.src = yys[yypt-1].yyv.tok.src;
	}
149=>
#line	961	"limbo.y"
{
		if(yys[yypt-6].yyv.node == nil){
			yys[yypt-6].yyv.node = mkn(Onothing, nil, nil);
			yys[yypt-6].yyv.node.src.start = yys[yypt-6].yyv.node.src.stop = curline();
		}
		yys[yypt-6].yyv.node = mkscope(rotater(yys[yypt-6].yyv.node));
		yyval.node = mkbin(Oexstmt, yys[yypt-6].yyv.node, mkn(Oexcept, yys[yypt-3].yyv.node, caselist(yys[yypt-1].yyv.node, nil)));
	}
150=>
#line	976	"limbo.y"
{
		yyval.ids = nil;
	}
151=>
#line	980	"limbo.y"
{
		if(yys[yypt-1].yyv.ids.next != nil)
			yyerror("only one identifier allowed in a label");
		yyval.ids = yys[yypt-1].yyv.ids;
	}
152=>
#line	988	"limbo.y"
{
		yyval.ids = nil;
	}
153=>
#line	992	"limbo.y"
{
		yyval.ids = mkids(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval, nil, nil);
	}
154=>
#line	998	"limbo.y"
{
		yys[yypt-1].yyv.node.left.right.right = yys[yypt-0].yyv.node;
		yyval.node = yys[yypt-1].yyv.node;
	}
155=>
#line	1005	"limbo.y"
{
		yyval.node = mkunary(Oseq, mkscope(mkunary(Olabel, rotater(yys[yypt-1].yyv.node))));
	}
156=>
#line	1009	"limbo.y"
{
		yys[yypt-3].yyv.node.left.right.right = yys[yypt-2].yyv.node;
		yyval.node = mkbin(Oseq, mkscope(mkunary(Olabel, rotater(yys[yypt-1].yyv.node))), yys[yypt-3].yyv.node);
	}
157=>
#line	1016	"limbo.y"
{
		yys[yypt-1].yyv.node.left.right = mkscope(yys[yypt-0].yyv.node);
		yyval.node = yys[yypt-1].yyv.node;
	}
158=>
#line	1023	"limbo.y"
{
		yyval.node = mkunary(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)));
	}
159=>
#line	1027	"limbo.y"
{
		yys[yypt-3].yyv.node.left.right = mkscope(yys[yypt-2].yyv.node);
		yyval.node = mkbin(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)), yys[yypt-3].yyv.node);
	}
160=>
#line	1034	"limbo.y"
{
		yys[yypt-1].yyv.node.left.right = mkscope(yys[yypt-0].yyv.node);
		yyval.node = yys[yypt-1].yyv.node;
	}
161=>
#line	1041	"limbo.y"
{
		yyval.node = mkunary(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)));
	}
162=>
#line	1045	"limbo.y"
{
		yys[yypt-3].yyv.node.left.right = mkscope(yys[yypt-2].yyv.node);
		yyval.node = mkbin(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)), yys[yypt-3].yyv.node);
	}
163=>
yyval.node = yys[yyp+1].yyv.node;
164=>
#line	1053	"limbo.y"
{
		yyval.node = mkbin(Orange, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
165=>
#line	1057	"limbo.y"
{
		yyval.node = mkn(Owild, nil, nil);
		yyval.node.src = yys[yypt-0].yyv.tok.src;
	}
166=>
#line	1062	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
167=>
#line	1066	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
168=>
#line	1074	"limbo.y"
{
		yys[yypt-1].yyv.node.left.right = mkscope(yys[yypt-0].yyv.node);
		yyval.node = yys[yypt-1].yyv.node;
	}
169=>
#line	1081	"limbo.y"
{
		yyval.node = mkunary(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)));
	}
170=>
#line	1085	"limbo.y"
{
		yys[yypt-3].yyv.node.left.right = mkscope(yys[yypt-2].yyv.node);
		yyval.node = mkbin(Oseq, mkunary(Olabel, rotater(yys[yypt-1].yyv.node)), yys[yypt-3].yyv.node);
	}
171=>
#line	1092	"limbo.y"
{
		yyval.node = mkname(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
172=>
#line	1096	"limbo.y"
{
		yyval.node = mkn(Owild, nil, nil);
		yyval.node.src = yys[yypt-0].yyv.tok.src;
	}
173=>
#line	1101	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
174=>
#line	1105	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
175=>
#line	1113	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = curline();
		yyval.node.src.stop = yyval.node.src.start;
	}
176=>
yyval.node = yys[yyp+1].yyv.node;
177=>
yyval.node = yys[yyp+1].yyv.node;
178=>
#line	1123	"limbo.y"
{
		yyval.node = mkbin(Oas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
179=>
#line	1127	"limbo.y"
{
		yyval.node = mkbin(Oandas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
180=>
#line	1131	"limbo.y"
{
		yyval.node = mkbin(Ooras, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
181=>
#line	1135	"limbo.y"
{
		yyval.node = mkbin(Oxoras, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
182=>
#line	1139	"limbo.y"
{
		yyval.node = mkbin(Olshas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
183=>
#line	1143	"limbo.y"
{
		yyval.node = mkbin(Orshas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
184=>
#line	1147	"limbo.y"
{
		yyval.node = mkbin(Oaddas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
185=>
#line	1151	"limbo.y"
{
		yyval.node = mkbin(Osubas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
186=>
#line	1155	"limbo.y"
{
		yyval.node = mkbin(Omulas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
187=>
#line	1159	"limbo.y"
{
		yyval.node = mkbin(Odivas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
188=>
#line	1163	"limbo.y"
{
		yyval.node = mkbin(Omodas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
189=>
#line	1167	"limbo.y"
{
		yyval.node = mkbin(Oexpas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
190=>
#line	1171	"limbo.y"
{
		yyval.node = mkbin(Osnd, yys[yypt-3].yyv.node, yys[yypt-0].yyv.node);
	}
191=>
#line	1175	"limbo.y"
{
		yyval.node = mkbin(Odas, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
192=>
#line	1179	"limbo.y"
{
		yyval.node = mkn(Oload, yys[yypt-0].yyv.node, nil);
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.node.src.stop;
		yyval.node.ty = mkidtype(yys[yypt-1].yyv.tok.src, yys[yypt-1].yyv.tok.v.idval);
	}
193=>
#line	1186	"limbo.y"
{
		yyval.node = yyval.node = mkbin(Oexp, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
194=>
#line	1190	"limbo.y"
{
		yyval.node = mkbin(Omul, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
195=>
#line	1194	"limbo.y"
{
		yyval.node = mkbin(Odiv, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
196=>
#line	1198	"limbo.y"
{
		yyval.node = mkbin(Omod, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
197=>
#line	1202	"limbo.y"
{
		yyval.node = mkbin(Oadd, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
198=>
#line	1206	"limbo.y"
{
		yyval.node = mkbin(Osub, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
199=>
#line	1210	"limbo.y"
{
		yyval.node = mkbin(Orsh, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
200=>
#line	1214	"limbo.y"
{
		yyval.node = mkbin(Olsh, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
201=>
#line	1218	"limbo.y"
{
		yyval.node = mkbin(Olt, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
202=>
#line	1222	"limbo.y"
{
		yyval.node = mkbin(Ogt, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
203=>
#line	1226	"limbo.y"
{
		yyval.node = mkbin(Oleq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
204=>
#line	1230	"limbo.y"
{
		yyval.node = mkbin(Ogeq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
205=>
#line	1234	"limbo.y"
{
		yyval.node = mkbin(Oeq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
206=>
#line	1238	"limbo.y"
{
		yyval.node = mkbin(Oneq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
207=>
#line	1242	"limbo.y"
{
		yyval.node = mkbin(Oand, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
208=>
#line	1246	"limbo.y"
{
		yyval.node = mkbin(Oxor, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
209=>
#line	1250	"limbo.y"
{
		yyval.node = mkbin(Oor, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
210=>
#line	1254	"limbo.y"
{
		yyval.node = mkbin(Ocons, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
211=>
#line	1258	"limbo.y"
{
		yyval.node = mkbin(Oandand, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
212=>
#line	1262	"limbo.y"
{
		yyval.node = mkbin(Ooror, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
213=>
yyval.node = yys[yyp+1].yyv.node;
214=>
#line	1269	"limbo.y"
{
		yys[yypt-0].yyv.node.src.start = yys[yypt-1].yyv.tok.src.start;
		yyval.node = yys[yypt-0].yyv.node;
	}
215=>
#line	1274	"limbo.y"
{
		yyval.node = mkunary(Oneg, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
216=>
#line	1279	"limbo.y"
{
		yyval.node = mkunary(Onot, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
217=>
#line	1284	"limbo.y"
{
		yyval.node = mkunary(Ocomp, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
218=>
#line	1289	"limbo.y"
{
		yyval.node = mkunary(Oind, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
219=>
#line	1294	"limbo.y"
{
		yyval.node = mkunary(Opreinc, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
220=>
#line	1299	"limbo.y"
{
		yyval.node = mkunary(Opredec, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
221=>
#line	1304	"limbo.y"
{
		yyval.node = mkunary(Orcv, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
222=>
#line	1309	"limbo.y"
{
		yyval.node = mkunary(Ohd, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
223=>
#line	1314	"limbo.y"
{
		yyval.node = mkunary(Otl, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
224=>
#line	1319	"limbo.y"
{
		yyval.node = mkunary(Olen, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
225=>
#line	1324	"limbo.y"
{
		yyval.node = mkunary(Oref, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
226=>
#line	1329	"limbo.y"
{
		yyval.node = mkunary(Otagof, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
	}
227=>
#line	1334	"limbo.y"
{
		yyval.node = mkn(Oarray, yys[yypt-3].yyv.node, nil);
		yyval.node.ty = mktype(yys[yypt-5].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tarray, yys[yypt-0].yyv.ty, nil);
		yyval.node.src = yyval.node.ty.src;
	}
228=>
#line	1340	"limbo.y"
{
		yyval.node = mkn(Oarray, yys[yypt-5].yyv.node, yys[yypt-1].yyv.node);
		yyval.node.src.start = yys[yypt-7].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
229=>
#line	1346	"limbo.y"
{
		yyval.node = mkn(Onothing, nil, nil);
		yyval.node.src.start = yys[yypt-5].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-4].yyv.tok.src.stop;
		yyval.node = mkn(Oarray, yyval.node, yys[yypt-1].yyv.node);
		yyval.node.src.start = yys[yypt-6].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
230=>
#line	1355	"limbo.y"
{
		yyval.node = etolist(yys[yypt-1].yyv.node);
		yyval.node.src.start = yys[yypt-4].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
231=>
#line	1361	"limbo.y"
{
		yyval.node = mkn(Ochan, nil, nil);
		yyval.node.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tchan, yys[yypt-0].yyv.ty, nil);
		yyval.node.src = yyval.node.ty.src;
	}
232=>
#line	1367	"limbo.y"
{
		yyval.node = mkn(Ochan, yys[yypt-3].yyv.node, nil);
		yyval.node.ty = mktype(yys[yypt-5].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tchan, yys[yypt-0].yyv.ty, nil);
		yyval.node.src = yyval.node.ty.src;
	}
233=>
#line	1373	"limbo.y"
{
		yyval.node = mkunary(Ocast, yys[yypt-0].yyv.node);
		yyval.node.ty = mktype(yys[yypt-3].yyv.tok.src.start, yys[yypt-0].yyv.node.src.stop, Tarray, mkidtype(yys[yypt-1].yyv.tok.src, yys[yypt-1].yyv.tok.v.idval), nil);
		yyval.node.src = yyval.node.ty.src;
	}
234=>
#line	1379	"limbo.y"
{
		yyval.node = mkunary(Ocast, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
		yyval.node.ty = mkidtype(yyval.node.src, yys[yypt-1].yyv.tok.v.idval);
	}
235=>
#line	1385	"limbo.y"
{
		yyval.node = mkunary(Ocast, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
		yyval.node.ty = mkidtype(yyval.node.src, yys[yypt-1].yyv.tok.v.idval);
	}
236=>
#line	1391	"limbo.y"
{
		yyval.node = mkunary(Ocast, yys[yypt-0].yyv.node);
		yyval.node.src.start = yys[yypt-1].yyv.tok.src.start;
		yyval.node.ty = yys[yypt-1].yyv.ty;
	}
237=>
yyval.node = yys[yyp+1].yyv.node;
238=>
#line	1400	"limbo.y"
{
		yyval.node = mkn(Ocall, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
		yyval.node.src.start = yys[yypt-3].yyv.node.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
239=>
#line	1406	"limbo.y"
{
		yyval.node = yys[yypt-1].yyv.node;
		if(yys[yypt-1].yyv.node.op == Oseq)
			yyval.node = mkn(Otuple, rotater(yys[yypt-1].yyv.node), nil);
		else
			yyval.node.flags |= byte PARENS;
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
240=>
#line	1416	"limbo.y"
{
#		n := mkdeclname($1, mkids($1, enter(".fn"+string nfnexp++, 0), nil, nil));
#		$<node>$ = fndef(n, $2);
#		nfns++;
	}
241=>
#line	1421	"limbo.y"
{
#		$$ = fnfinishdef($<node>3, $4);
#		$$ = mkdeclname($1, $$.left.decl);
		yyerror("urt unk");
		yyval.node = nil;
	}
242=>
#line	1428	"limbo.y"
{
		yyval.node = mkbin(Odot, yys[yypt-2].yyv.node, mkname(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval));
	}
243=>
#line	1432	"limbo.y"
{
		yyval.node = mkbin(Omdot, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
244=>
#line	1436	"limbo.y"
{
		yyval.node = mkbin(Oindex, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node);
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
245=>
#line	1441	"limbo.y"
{
		if(yys[yypt-3].yyv.node.op == Onothing)
			yys[yypt-3].yyv.node.src = yys[yypt-2].yyv.tok.src;
		if(yys[yypt-1].yyv.node.op == Onothing)
			yys[yypt-1].yyv.node.src = yys[yypt-2].yyv.tok.src;
		yyval.node = mkbin(Oslice, yys[yypt-5].yyv.node, mkbin(Oseq, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node));
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
246=>
#line	1450	"limbo.y"
{
		yyval.node = mkunary(Oinc, yys[yypt-1].yyv.node);
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
247=>
#line	1455	"limbo.y"
{
		yyval.node = mkunary(Odec, yys[yypt-1].yyv.node);
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
248=>
#line	1460	"limbo.y"
{
		yyval.node = mksconst(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
249=>
#line	1464	"limbo.y"
{
		yyval.node = mkconst(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.ival);
		if(yys[yypt-0].yyv.tok.v.ival > big 16r7fffffff || yys[yypt-0].yyv.tok.v.ival < big -16r7fffffff)
			yyval.node.ty = tbig;
	}
250=>
#line	1470	"limbo.y"
{
		yyval.node = mkrconst(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.rval);
	}
251=>
#line	1474	"limbo.y"
{
		yyval.node = mkbin(Oindex, yys[yypt-5].yyv.node, rotater(mkbin(Oseq, yys[yypt-3].yyv.node, yys[yypt-1].yyv.node)));
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
252=>
#line	1481	"limbo.y"
{
		yyval.node = mkname(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
253=>
#line	1485	"limbo.y"
{
		yyval.node = mknil(yys[yypt-0].yyv.tok.src);
	}
254=>
#line	1491	"limbo.y"
{
		yyval.node = mkn(Otuple, rotater(yys[yypt-1].yyv.node), nil);
		yyval.node.src.start = yys[yypt-2].yyv.tok.src.start;
		yyval.node.src.stop = yys[yypt-0].yyv.tok.src.stop;
	}
255=>
yyval.node = yys[yyp+1].yyv.node;
256=>
#line	1500	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
257=>
yyval.node = yys[yyp+1].yyv.node;
258=>
yyval.node = yys[yyp+1].yyv.node;
259=>
#line	1510	"limbo.y"
{
		yyval.node = mkn(Otype, nil, nil);
		yyval.node.ty = mkidtype(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
		yyval.node.src = yyval.node.ty.src;
	}
260=>
#line	1516	"limbo.y"
{
		yyval.node = mkn(Otype, nil, nil);
		yyval.node.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tarray, yys[yypt-0].yyv.ty, nil);
		yyval.node.src = yyval.node.ty.src;
	}
261=>
#line	1522	"limbo.y"
{
		yyval.node = mkn(Otype, nil, nil);
		yyval.node.ty = mktype(yys[yypt-2].yyv.tok.src.start, yys[yypt-0].yyv.ty.src.stop, Tlist, yys[yypt-0].yyv.ty, nil);
		yyval.node.src = yyval.node.ty.src;
	}
262=>
#line	1528	"limbo.y"
{
		yyval.node = mkn(Otype, nil ,nil);
		yyval.node.ty = yys[yypt-0].yyv.ty;
		yyval.node.ty.flags |= CYCLIC;
		yyval.node.src = yyval.node.ty.src;
	}
263=>
#line	1537	"limbo.y"
{
		yyval.node = mkname(yys[yypt-0].yyv.tok.src, yys[yypt-0].yyv.tok.v.idval);
	}
264=>
#line	1541	"limbo.y"
{
		yyval.node = nil;
	}
265=>
yyval.node = yys[yyp+1].yyv.node;
266=>
yyval.node = yys[yyp+1].yyv.node;
267=>
#line	1549	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
268=>
#line	1553	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
269=>
#line	1559	"limbo.y"
{
		yyval.node = nil;
	}
270=>
#line	1563	"limbo.y"
{
		yyval.node = rotater(yys[yypt-0].yyv.node);
	}
271=>
yyval.node = yys[yyp+1].yyv.node;
272=>
yyval.node = yys[yyp+1].yyv.node;
273=>
yyval.node = yys[yyp+1].yyv.node;
274=>
#line	1574	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
275=>
#line	1580	"limbo.y"
{
		yyval.node = rotater(yys[yypt-0].yyv.node);
	}
276=>
#line	1584	"limbo.y"
{
		yyval.node = rotater(yys[yypt-1].yyv.node);
	}
277=>
yyval.node = yys[yyp+1].yyv.node;
278=>
#line	1591	"limbo.y"
{
		yyval.node = mkbin(Oseq, yys[yypt-2].yyv.node, yys[yypt-0].yyv.node);
	}
279=>
#line	1597	"limbo.y"
{
		yyval.node = mkn(Oelem, nil, yys[yypt-0].yyv.node);
		yyval.node.src = yys[yypt-0].yyv.node.src;
	}
280=>
#line	1602	"limbo.y"
{
		yyval.node = mkbin(Oelem, rotater(yys[yypt-2].yyv.node), yys[yypt-0].yyv.node);
	}
281=>
#line	1608	"limbo.y"
{
		if(yys[yypt-1].yyv.node.op == Oseq)
			yys[yypt-1].yyv.node.right.left = rotater(yys[yypt-0].yyv.node);
		else
			yys[yypt-1].yyv.node.left = rotater(yys[yypt-0].yyv.node);
		yyval.node = yys[yypt-1].yyv.node;
	}
282=>
#line	1618	"limbo.y"
{
		yyval.node = typedecl(yys[yypt-1].yyv.ids, mktype(yys[yypt-1].yyv.ids.src.start, yys[yypt-0].yyv.tok.src.stop, Tpoly, nil, nil));
	}
283=>
#line	1622	"limbo.y"
{
		if(yys[yypt-3].yyv.node.op == Oseq)
			yys[yypt-3].yyv.node.right.left = rotater(yys[yypt-2].yyv.node);
		else
			yys[yypt-3].yyv.node.left = rotater(yys[yypt-2].yyv.node);
		yyval.node = mkbin(Oseq, yys[yypt-3].yyv.node, typedecl(yys[yypt-1].yyv.ids, mktype(yys[yypt-1].yyv.ids.src.start, yys[yypt-0].yyv.tok.src.stop, Tpoly, nil, nil)));
	}
		}
	}

	return yyn;
}
