# warning: autogenerated code; don't bother to change this, change mktypeset.b or grid.b instead
implement Grid;
include "sys.m";
	sys: Sys;
include "draw.m";
include "sh.m";
include "alphabet/reports.m";
include "alphabet/endpoints.m";
include "grid.m";
endpoints: Endpoints;

valuec := array[] of {
	tagof(Value.Vb) => 'b',
	tagof(Value.Ve) => 'e',
	tagof(Value.Vw) => 'w',
	tagof(Value.Vc) => 'c',
	tagof(Value.Vr) => 'r',
	tagof(Value.Vf) => 'f',
	tagof(Value.Vs) => 's',
};

init()
{
	sys = load Sys Sys->PATH;
	endpoints = load Endpoints Endpoints->PATH;
	endpoints->init();
}

Value.type2s(c: int): string
{
	case c {
	'b' =>
		return "records";
	'e' =>
		return "endpoint";
	'w' =>
		return "wfd";
	'c' =>
		return "cmd";
	'r' =>
		return "status";
	'f' =>
		return "fd";
	's' =>
		return "string";
	* =>
		return sys->sprint("unknowntype('%c')", c);
	}
}

typeerror(tc: int, v: ref Value): string
{
	sys->fprint(sys->fildes(2), "fs: bad type conversion, expected %s, was actually %s\n", Value.type2s(tc), Value.type2s(valuec[tagof v]));
	return "type conversion error";
}

Value.b(v: self ref Value): ref Value.Vb
{
	pick xv := v {Vb => return xv;}
	raise typeerror('b', v);
}

Value.e(v: self ref Value): ref Value.Ve
{
	pick xv := v {Ve => return xv;}
	raise typeerror('e', v);
}

Value.w(v: self ref Value): ref Value.Vw
{
	pick xv := v {Vw => return xv;}
	raise typeerror('w', v);
}

Value.c(v: self ref Value): ref Value.Vc
{
	pick xv := v {Vc => return xv;}
	raise typeerror('c', v);
}

Value.r(v: self ref Value): ref Value.Vr
{
	pick xv := v {Vr => return xv;}
	raise typeerror('r', v);
}

Value.f(v: self ref Value): ref Value.Vf
{
	pick xv := v {Vf => return xv;}
	raise typeerror('f', v);
}

Value.s(v: self ref Value): ref Value.Vs
{
	pick xv := v {Vs => return xv;}
	raise typeerror('s', v);
}

Value.typec(v: self ref Value): int
{
	return valuec[tagof v];
}

Value.dup(xv: self ref Value): ref Value
{
	if(xv == nil)
		return nil;
	pick v := xv {
	Vb =>
		v = nil;
		xv = v;
	Ve =>
		v = nil;
		xv = v;
	Vw =>
		v = nil;
		xv = v;
	Vr =>
		v = nil;
		xv = v;
	Vf =>
		v = nil;
		xv = v;
	}
	return xv;
}

Value.free(xv: self ref Value, used: int)
{
	if(xv == nil)
		return;
	pick v := xv {
	Vb =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	Ve =>
		if(!used){
			ep := <-v.i;
			if(ep.addr != nil)
				endpoints->open(nil, ep);		# open and discard
		}
	Vw =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	Vr =>
		if(!used){
			v.i <-= "stop";
		}
	Vf =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	}
}

