# warning: autogenerated code; don't bother to change this, change mktypeset.b or fs.b instead
implement Fs;
include "sys.m";
	sys: Sys;
include "draw.m";
include "sh.m";
include "alphabet/reports.m";
include "fs.m";
sendnulldir(c: Fschan): int
{
	reply := chan of int;
	c <-= ((ref Sys->nulldir, nil), reply);
	if((r := <-reply) == Down){
		c <-= ((nil, nil), reply);
		if(<-reply != Quit)
			return Quit;
		return Next;
	}
	return r;
}
# copy the contents (not the entry itself) of a directory from src to dst.
copy(src, dst: Fschan): int
{
	indent := 1;
	myreply := chan of int;
	for(;;){
		(d, reply) := <-src;
		dst <-= (d, myreply);
		r := <-myreply;
		case reply <-= r {
		Quit =>
			return Quit;
		Next =>
			if(d.dir == nil && d.data == nil)
				if(--indent == 0)
					return Next;
		Skip =>
			if(--indent == 0)
				return Next;
		Down =>
			if(d.dir != nil || d.data != nil)
				indent++;
		}
	}
}

valuec := array[] of {
	tagof(Value.Vr) => 'r',
	tagof(Value.Vd) => 'd',
	tagof(Value.Vc) => 'c',
	tagof(Value.Vf) => 'f',
	tagof(Value.Vs) => 's',
	tagof(Value.Vm) => 'm',
	tagof(Value.Vp) => 'p',
	tagof(Value.Vt) => 't',
	tagof(Value.Vx) => 'x',
};

init()
{
	sys = load Sys Sys->PATH;
}

Value.type2s(c: int): string
{
	case c {
	'r' =>
		return "status";
	'd' =>
		return "data";
	'c' =>
		return "command";
	'f' =>
		return "fd";
	's' =>
		return "string";
	'm' =>
		return "selector";
	'p' =>
		return "gate";
	't' =>
		return "entries";
	'x' =>
		return "fs";
	* =>
		return sys->sprint("unknowntype('%c')", c);
	}
}

typeerror(tc: int, v: ref Value): string
{
	sys->fprint(sys->fildes(2), "fs: bad type conversion, expected %s, was actually %s\n", Value.type2s(tc), Value.type2s(valuec[tagof v]));
	return "type conversion error";
}

Value.r(v: self ref Value): ref Value.Vr
{
	pick xv := v {Vr => return xv;}
	raise typeerror('r', v);
}

Value.d(v: self ref Value): ref Value.Vd
{
	pick xv := v {Vd => return xv;}
	raise typeerror('d', v);
}

Value.c(v: self ref Value): ref Value.Vc
{
	pick xv := v {Vc => return xv;}
	raise typeerror('c', v);
}

Value.f(v: self ref Value): ref Value.Vf
{
	pick xv := v {Vf => return xv;}
	raise typeerror('f', v);
}

Value.s(v: self ref Value): ref Value.Vs
{
	pick xv := v {Vs => return xv;}
	raise typeerror('s', v);
}

Value.m(v: self ref Value): ref Value.Vm
{
	pick xv := v {Vm => return xv;}
	raise typeerror('m', v);
}

Value.p(v: self ref Value): ref Value.Vp
{
	pick xv := v {Vp => return xv;}
	raise typeerror('p', v);
}

Value.t(v: self ref Value): ref Value.Vt
{
	pick xv := v {Vt => return xv;}
	raise typeerror('t', v);
}

Value.x(v: self ref Value): ref Value.Vx
{
	pick xv := v {Vx => return xv;}
	raise typeerror('x', v);
}

Value.typec(v: self ref Value): int
{
	return valuec[tagof v];
}

Value.dup(xv: self ref Value): ref Value
{
	if(xv == nil)
		return nil;
	pick v := xv {
	Vr =>
		v = nil;
		xv = v;
	Vd =>
		v = nil;
		xv = v;
	Vf =>
		v = nil;
		xv = v;
	Vm =>
		v = nil;
		xv = v;
	Vp =>
		v = nil;
		xv = v;
	Vt =>
		v = nil;
		xv = v;
	Vx =>
		v = nil;
		xv = v;
	}
	return xv;
}

Value.free(xv: self ref Value, used: int)
{
	if(xv == nil)
		return;
	pick v := xv {
	Vr =>
		if(!used){
			v.i <-= "stop";
		}
	Vd =>
		if(!used){
			alt{
			v.i.stop <-= 1 =>
				;
			* =>
				;
			}
		}
	Vf =>
		if(!used){
			<-v.i;
			v.i <-= nil;
		}
	Vm =>
		if(!used){
			v.i <-= (nil, nil, nil);
		}
	Vp =>
		if(!used){
			v.i <-= (Nilentry, nil);
		}
	Vt =>
		if(!used){
			v.i.sync <-= 0;
		}
	Vx =>
		if(!used){
			(<-v.i).t1 <-= Quit;
		}
	}
}

