
FunctionMax = 6 					  ;
;=======================================================  ;
;  int_40h                              ( int functions)  ;
;                                                         ;
;=======================================================  ;
int_40h:						  ;
	cmp	ebx,0					  ;
	jne	Not_Zero				  ;
	mov	esi,FunctionTable			  ;
	jmp	int40hOK				  ;
  Not_Zero:						  ;
	cmp	ebx,FunctionMax 			  ;
	ja	int40hError				  ;
	shl	ebx,2					  ;
	add	ebx,FunctionTable			  ;                     
	call	dword[ebx]				  ;
	jc	int40hError				  ;
  int40hOK:						  ;
	and	byte [esp+8],not 1			  ; 
	iret						  ;
							  ;
int40hError:						  ; 
	or	byte [esp+8],1				  ; 
	iret						  ;

OldIn40hAddress  dd  0					  ;
;=======================================================  ;
;  Hook_int40h                                            ;
;=======================================================  ;
Hook_int40h:						  ;
	pushad						  ;
	mov	eax,40h 				  ; put interrupt number in AL
	call	[GetIntVector]				  ; New function to get int vector
	mov	[OldIn40hAddress],edx			  ; The offset is returned in EDX, CX = selector (BUT WE DO NOT CHANGE selector)
							  ;
	mov	edx,int_40h				  ; EDX = interrupt handler address
	mov	eax,40h 				  ; put interrupt number in AL
	call	[SetIntVector]				  ; New function to set int vector
	popad						  ;
	ret						  ;

;=======================================================  ;
;  UnHook_int40h                                          ;
;=======================================================  ;
UnHook_int40h:						  ;
	pushad						  ;
	mov	edx,[OldIn40hAddress]			  ; EDX = old interrupt handler address
	mov	eax,40h 				  ; put interrupt number in AL
	call	[SetIntVector]				  ; New function to set int vector
	popad						  ;
	ret						  ;

;=======================================================  ;
;  Test function                                          ;
;=======================================================  ;
Test_function:						  ;
	ret						  ;

;=======================================================  ;
;  UnHook_int40h                                          ;
;=======================================================  ;
FunctionTable:						  ;
Function0   dd FunctionTable				  ; Address of this FunctionTable.
Function1   dd VesaBufferGetM2D				  ; Get bufer address
Function2   dd DeCodeJpeg				  ; deCode jpeg
Function3   dd DIFdecoder                                 ; decodes a dex image format
Function4   dd DIFdecoder                                 ; decodes a dex font format
Function5   dd PutImage32				  ; Draw image to screen xy offset
Function6   dd PutImageAlpha32                            ; Draw image to screen xy offset with alpha blending
Function7   dd Test_function				  ; spair function
