;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                                  ;;
;; Project          :   DexOS                                                       ;;
;; Ver              :   00.05                                                       ;;
;; Author           :   Craig Bamford (a.k.a Dex)                                   ;;
;; Website          :   www.dex-os.com                                              ;;
;; Forum            :   http://dex.7.forumer.com                                    ;;
;; Date             :   Mar 29, 2011                                                ;;
;; Filename         :   Dash.inc                                                    ;;
;; Copy Right Owner :   Craig Bamford                                               ;;
;;                                                                                  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                                  ;;
;; Disclaimer       :                                                               ;;
;; This software is provided "AS IS" without warranty of any kind, either           ;;
;; expressed or implied, including, but not limited to, the implied                 ;;
;; warranties of merchantability and fitness for a particular purpose. The          ;;
;; entire risk as to the quality and performance of this software is with           ;;
;; you.                                                                             ;;
;; In no event will the author's, distributor or any other party be liable to       ;;
;; you for damages, including any general, special, incidental or                   ;;
;; consequential damages arising out of the use, misuse or inability to use         ;;
;; this software (including but not limited to loss of data or losses               ;;
;; sustained by you or third parties or a failure of this software to operate       ;;
;; with any other software), even if such party has been advised of the             ;;
;; possibility of such damages.                                                     ;;
;;                                                                                  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;                                                                                  ;;
;; Thanks to Alexei Frounze, Tomasz Grysztar, Pype.Clicker.                         ;;
;;                                                                                  ;;
;; Also a thanks to  the many forums i am a member of, i would like to thank anyone ;;
;; who  has helped me, by answering my ? (too many too list).                       ;;
;;                                                                                  ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

TestBGLoaded  db  0					  ;
align 4 						  ;
;=======================================================  ;
;  DrawBackGround                                         ;
;=======================================================  ;
DrawBackGround: 					  ;
	pushad						  ;
	mov	eax,BackGroundImage			  ;
	cmp	eax,1					  ;
	je	LoadBgImage				  ;
  Fade_the_background:					  ;
;=======================================================  ;
;  Fade the background                                    ;
;=======================================================  ;
	call	Fade_screen				  ;
	jmp	DrawBackGroundExit			  ;
  LoadBgImage:						  ;
	cmp	byte[TestBGLoaded],1			  ;
	je	BGLoaded				  ;
;=======================================================  ;
;  Decode jpeg                                            ;
;=======================================================  ;
	mov	edi,BackGroundBuffer			  ; Image dest (uncompressed)
	mov	esi,file_area				  ; Image source (compressed)
	mov	ecx,FileEnd-file_area			  ; Image size (compressed)
	call	DeCodeJpeg				  ; call function
	jc	Fade_the_background			  ; CF flag set on error
	mov	byte[TestBGLoaded],1			  ; Set BG loaded OK flag
  BGLoaded:						  ;
;=======================================================  ;
;  PutImage                                               ;
;=======================================================  ;
	mov	ecx,0x00ffffff				  ; fill color
	mov	edi,VesaBuffer				  ; dest buff
	mov	esi,BackGroundBuffer			  ; souce buff
	call	PutImageFill32				  ; call put image
DrawBackGroundExit:					  ;
	popad						  ;
	ret						  ;

MenuBarBG_X  = 800					  ;
MenuBarBG_Y  = 100					  ;
;=======================================================  ;
;  SaveMenuBarBG                                          ;
;=======================================================  ;
SaveMenuBarBG:						  ;
	pushad						  ;
	xor	eax,eax 				  ; boxX
	mov	ebx,MenuStart				  ; boxY
	mov	edi,MenBar800_Store_Buffer		  ;
	mov	ecx,MenuBarBG_Y 			  ; hight
	mov	edx,MenuBarBG_X 			  ; width
	call	SaveFilledBoxVesa			  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  RestoreMenuBarBG                                       ;
;=======================================================  ;
RestoreMenuBarBG:					  ;
	pushad						  ;
	xor	eax,eax 				  ; boxX
	mov	ebx,MenuStart				  ; boxY
	mov	esi,MenBar800_Store_Buffer		  ;
	mov	ecx,MenuBarBG_Y 			  ; hight
	mov	edx,MenuBarBG_X 			  ; width
	call	ReStoreFilledBoxVesa			  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  DrawMainMenu.                                          ;
;=======================================================  ;
DrawMainMenu:						  ;
	pushad						  ;
	call	DrawBackGround				  ;
	call	SaveMenuBarBG				  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  BottomMenu.                                            ;
;=======================================================  ;
BottomMenu:						  ;
	pushad						  ;
;=======================================================  ;
;  Decode jpeg                                            ;
;=======================================================  ;
	mov	edi,BottonMenu_Buffer			  ; Image dest (uncompressed)
	mov	esi,file_area_BottomMenu		  ; Image source (compressed)
	mov	ecx,FileEnd_BottomMenu-file_area_BottomMenu  ; Image size (compressed)
	call	DeCodeJpeg				  ; call function
	popad						  ;
	ret						  ;

MenuBAR db 1						  ;
;=======================================================  ;
;  DrawMenuBar                                            ;
;=======================================================  ;
DrawMenuBar:						  ;
	pushad						  ;
	cmp    [MenuBAR],1				  ;
	jne    Bar2					  ;
  Bar1: 						  ;
	call   RestoreMenuBarBG 			  ;
	jmp    DrawMenuBarExit				  ;
  Bar2: 						  ;
	cmp    [MenuBAR],2				  ;
	jne    DrawMenuBarExit				  ;
	call   SaveMenuBarBG				  ;
	mov    edi,VesaBuffer				  ;
	mov    esi,BottonMenu_Buffer			  ;
	xor    eax,eax					  ;
	mov    ecx,500					  ;
	call   PutImage32				  ;
	jmp    DrawMenuBarExit				  ;
DrawMenuBarExit:					  ;
	popad						  ;
	ret						  ;
;=======================================================  ;
;  SetFolder.                                             ;
;=======================================================  ;
SetFolder:
;=======================================================  ;
;  Decode jpeg                                            ;
;=======================================================  ;
	pushad						  ;
	mov	edi,Arrow_Buffer			  ; Image dest (uncompressed)
	mov	esi,file_area_arrow			  ; Image source (compressed)
	mov	ecx,FileEnd_arrow-file_area_arrow	  ; Image size (compressed)
	call	DeCodeJpeg				  ; call function
							  ;
	mov	edi,Folder_Buffer			  ; Image dest (uncompressed)
	mov	esi,file_area_folder			  ; Image source (compressed)
	mov	ecx,FileEnd_folder-file_area_folder	  ; Image size (compressed)
	call	DeCodeJpeg				  ; call function
							  ;
	mov	edi,App_Buffer				  ; Image dest (uncompressed)
	mov	esi,file_area_App			  ; Image source (compressed)
	mov	ecx,FileEnd_App-file_area_App		  ; Image size (compressed)
	call	DeCodeJpeg				  ; call function
	popad						  ;
	ret						  ;

BlackMenuStartX = 202					  ;
BlackMenuStartY = 90					  ;
MenuBG_Y	= 384					  ;
MenuBG_X	= 400					  ;
GetListBufferAddress	   dd 0 			  ;
GetListBufferAddressAddOn  dd 0 			  ;
GetListFile_Count	   dd 0 			  ;
DrawFolderX		   dd 0 			  ;
DrawFolderY		   dd 0 			  ;
;=======================================================  ;
;   LoadMenu.                                             ;
;=======================================================  ;       
LoadMenu:						  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; start X
	mov	ecx,BlackMenuStartY			  ; start Y 
	mov	esi,Menu_Buffer 			  ; source image
	mov	edi,VesaBuffer				  ; dest image
	call	PutImageAlpha32 			  ; call function
	call	GetList 				  ;
	jc	GetList_Error				  ;
  GetList_OK:						  ;
	mov	word[MainWindowX],0			  ;                 
	mov	word[MainWindowY],0			  ;
	mov	dword[GetListBufferAddressAddOn],0	  ;
	add	esi,dword[BarAddOn_3]			  ;
	mov	dword[GetListBufferAddress],esi 	  ;
	mov	dword[GetListFile_Count],ebx		  ;
	mov	bx,250					  ;
	shl	ebx,16					  ;
	mov	dword[DrawFolderX],250-16		  ;
	mov	bx,110					  ;
	mov	ecx,16					  ;
	mov	dword[DrawFolderY],109			  ;
align 4 						  ;
  GetListLoop:						  ;
	push	ecx					  ;
	mov	ecx,0x005d6864				  ;
	mov	edx,dword[GetListBufferAddress] 	  ;
	add	edx,dword[GetListBufferAddressAddOn]	  ;
	mov	eax,2					  ;
	add	bx,20					  ;
	add	dword[DrawFolderY],20			  ;
	cmp	byte[edx],18h				  ;
	jne	Try_Folder				  ;
	call	DrawArrow				  ;
	jmp	ItsAfolder				  ;
  Try_Folder:						  ;
	cmp	byte[edx],9h				  ;
	jne	ItsAapp 				  ;
	call	DrawFolder				  ;
	jmp	ItsAfolder				  ;
  ItsAapp:						  ;
	cmp	byte[edx],7h				  ;
	jne	ItsAfolder				  ;
	call	DrawApp 				  ;
  ItsAfolder:						  ;
	call	WRITE_TEXT_TO_WINDOW_04 		  ;
	add	dword[GetListBufferAddressAddOn],15	  ;
	pop	ecx					  ;
	loop	GetListLoop				  ;
GetList_Error:						  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  DrawFolder                                             ;
;=======================================================  ;       
DrawFolder:						  ;
	pushad						  ;
	mov    edi,VesaBuffer				  ;
	mov    esi,Folder_Buffer			  ;
	mov    eax,dword[DrawFolderX]			  ;
	mov    ecx,dword[DrawFolderY]			  ;
	call   PutImage32				  ;
	popad						  ;
	ret						  ;
;=======================================================  ;
;  DrawApp                                                ;
;=======================================================  ;   
DrawApp:						  ;
	pushad						  ;
	mov    edi,VesaBuffer				  ;
	mov    esi,App_Buffer				  ;
	mov    eax,dword[DrawFolderX]			  ;
	mov    ecx,dword[DrawFolderY]			  ;
	call   PutImage32				  ;
	popad						  ;
	ret						  ;
;=======================================================  ;
;  DrawArrow                                              ;
;=======================================================  ; 
DrawArrow:						  ;
	pushad						  ;
	mov    edi,VesaBuffer				  ;
	mov    esi,Arrow_Buffer 			  ;
	mov    eax,dword[DrawFolderX]			  ;
	mov    ecx,dword[DrawFolderY]			  ;
	call   PutImage32				  ;
	popad						  ;
	ret						  ;

BarAddOn	 dd 0					  ;
BarAddOn_1	 dd 0					  ;
BarAddOn_2	 dd 0					  ;
BarAddOn_3	 dd 0					  ;
List_Menu_Number dd 0					  ;
;=======================================================  ;
;  DrawMenu_Bar                                           ;
;=======================================================  ;  
DrawMenu_Bar:						  ;
	pushad						  ;
	mov	eax,250-20				  ; start X
	mov	ecx,122 				  ; start Y 
	add	ecx,dword[BarAddOn]			  ;
	mov	esi,Bar_Buffer				  ; source image
	mov	edi,VesaBuffer				  ; dest image
	call	PutImageAlpha32 			  ; call function
	popad						  ;
	ret						  ;

DefaultListNumber = 1024				  ;
;=======================================================  ;
;  File data                                      *New*   ;
;=======================================================  ;
    drive	   db 0 				  ;
    DriveNew	   db 0 				  ;
		   db ' is $'				  ;
    Drive2	   db 0 				  ;
		   db ':\$'				  ;
ChangeDirTest	   db 0 				  ;
ListBufferAddOn    dd 0 				  ;
File_Count	   dd 0 				  ;
 FileNames1	   db '*.*',0				  ; file name
FileNames	   db '*',0				  ; file name
;=======================================================  ;
;  DTA Buffer                                             ;
;=======================================================  ;
    DTAbuffer:	   db 22 dup(?) 			  ; header info - not used
    fileTime:	   dw 0 				  ; time
    fileDate:	   dw 0 				  ; date
    fileSize:	   dd 0 				  ; size
    fileName:	   db 14 dup(0) 			  ; name
    EndOfString:   db 0,0, '$'				  ;
    TempBuff1:	   db 68 dup(' ')			  ;
		   db 0 				  ;
ErrorCode db 0
;=======================================================  ;
;  GetList.                                               ;
;=======================================================  ;
GetList:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;
	mov	es,ax					  ;
	mov	edi,ListBuffer				  ;
	mov	ecx,15*DefaultListNumber		  ;
	mov	al,0					  ;
	rep	stosb					  ;
	mov	ecx,DefaultListNumber			  ;
	mov	edi,ListBuffer				  ;
	xor	eax,eax 				  ;
	mov	ax,'GE' 				  ; just load gex files (0 for all files)
	call	[DirFileList]				  ;
	jc	GetListError				  ;
	mov	dword[File_Count],ecx			  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	esi,ListBuffer				  ;
	mov	edi,ListBuffer				  ;
	mov	ebx,dword[File_Count]			  ;
	clc						  ;
	ret						  ;
GetListError:						  ;
	;mov     byte[ErrorCode],al                       ; error
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	;mov     al,byte[ErrorCode]                       ;
	stc						  ;
	ret						  ;

;=======================================================  ;
;  SaveBackGroundMenu.                                    ;
;=======================================================  ;     
SaveBackGroundMenu:					  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; boxX
	mov	ebx,BlackMenuStartY			  ; boxY
	mov	edi,Menu_Store_Buffer			  ;
	mov	ecx,MenuBG_Y				  ; hight
	mov	edx,MenuBG_X				  ; width
	call	SaveFilledBoxVesa			  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  RestoreBackGroundMenu.                                 ;
;=======================================================  ;        
RestoreBackGroundMenu:					  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; boxX
	mov	ebx,BlackMenuStartY			  ; boxY
	mov	esi,Menu_Store_Buffer			  ;
	mov	ecx,MenuBG_Y				  ; hight
	mov	edx,MenuBG_X				  ; width
	call	ReStoreFilledBoxVesa			  ;
	call	BuffToScreen				  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  RestoreBackGroundMenu No buffer to screen.             ;
;=======================================================  ;        
RestoreBackGroundMenuNB:				  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; boxX
	mov	ebx,BlackMenuStartY			  ; boxY
	mov	esi,Menu_Store_Buffer			  ;
	mov	ecx,MenuBG_Y				  ; hight
	mov	edx,MenuBG_X				  ; width
	call	ReStoreFilledBoxVesa			  ;
	popad						  ;
	ret						  ;
    
;=======================================================  ;
;  SaveMenulist.                                          ;
;=======================================================  ;            
SaveMenulist:						  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; boxX
	mov	ebx,BlackMenuStartY			  ; boxY
	mov	edi,Menu_List_Buffer			  ;
	mov	ecx,MenuBG_Y				  ; hight
	mov	edx,MenuBG_X				  ; width
	call	SaveFilledBoxVesa			  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  RestoreMenuList.                                       ;
;=======================================================  ;        
RestoreMenuList:					  ;
	pushad						  ;
	mov	eax,BlackMenuStartX			  ; boxX
	mov	ebx,BlackMenuStartY			  ; boxY
	mov	esi,Menu_List_Buffer			  ;
	mov	ecx,MenuBG_Y				  ; hight
	mov	edx,MenuBG_X				  ; width
	call	ReStoreFilledBoxVesa			  ;
	popad						  ;
	ret						  ;

ChangeOK db 0						  ;
;=======================================================  ;
; ChangeDirLoad.                                          ;
;=======================================================  ;
ChangeDirLoad:						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error.                                            ;
;=======================================================  ;
FddLoadError:						  ;
	;mov   byte[ErrorCode],al                         ;
	pop   ds					  ;
	pop   es					  ;
	popad						  ;
	;mov   al,byte[ErrorCode]                         ;
	stc						  ;
	ret						  ;

;=======================================================  ;
;  SpeedUpKeyBoard.                                       ;
;=======================================================  ;
SpeedUpKeyBoard:					  ;
	push	eax					  ;
	mov	al,0xf3 				  ;          
	out	0x60,al 				  ;           
KeyBoardWait:						  ;
	in	al,0x64 				  ;
	test	al,10b					  ;           
	jne	KeyBoardWait				  ;           
	mov	al,1					  ;
	and	al,111b 				  ;
	out	0x60,al 				  ;                   
	pop	eax					  ;
	ret						  ;

