;=========================================================;
; Cli Functions                                01/01/2011 ;
;---------------------------------------------------------;
;                                                         ;
; (c) by Craig & Ben Bamford, All rights reserved.        ;
;=========================================================;

;=======================================================  ;
;  variables.                                             ;
;=======================================================  ; 
     screen_rows     =	 25			          ; all comments assume
     screen_cols     =	 80			          ; that this is 25 & 80
     screen_rows1    =	 screen_rows-1                    ;
     screen_cols1    =	 screen_cols-1                    ;
     cursor_pos      dw   0                               ;
                                                          ;
;=======================================================  ;
;  gets the text pos                                      ;
;=======================================================  ; 
get_text_pos:                                             ;
	mov	al,[screen_x]                             ;
	mov	ah,[screen_y]                             ;
	ret                                               ;
                                                         
;=======================================================  ;
;  Sets the text pos                                      ;
;=======================================================  ; 
set_text_pos:                                             ;
	mov	[screen_x],al                             ;
	mov	[screen_y],ah                             ;
	ret                                               ;

;=======================================================  ;
;  TextColor                                              ;
;=======================================================  ; 
TextColor:                                                ;
	mov	byte[textcolor],al                        ;
	ret                                               ;

;=======================================================  ;
;  GetTextColor                                           ;
;=======================================================  ; 
GetTextColor:                                             ;
	mov	al,byte[textcolor]                        ;
	ret   

;=======================================================  ;
;  change cursor attribs                                  ;
;             in: bx = cursor attribs                     ;
;=======================================================  ;                                             ;
changecursor:                                             ;
	  push	  ax                                      ;
	  push	  dx                                      ;
                                                          ;
	  mov	  dx, 0x3D4                               ;
	  mov	  al, 0x0A                                ;
	  mov	  ah, bh                                  ;
	  out	  dx, ax                                  ;
	  inc	  ax                                      ;
	  mov	  ah, bl                                  ;
	  out	  dx, ax                                  ;
                                                          ;
	  pop	  dx                                      ;
	  pop	  ax                                      ;
	  ret                                             ;

;=======================================================  ;
;  updates the xy cursors vars                            ;
;             out: [screen_x] = x                         ;
;                  [screen_y] = y                         ;
;=======================================================  ;      
 UpDateCursorVarXY:                                       ;
	  push	 ebx                                      ;
	  call	 GetCursorXY                              ;
	  mov	 [screen_x], bh                           ;
	  mov	 [screen_y],bl                            ;
	  pop	 ebx                                      ;
	  ret                                             ;

;=======================================================  ;
;  get the cursor pos                                     ;
;             out: bh = x   bl = y                        ;
;=======================================================  ;
GetCursorXY:                                              ;
	  push	  ax                                      ;
	  call	  GetCursor                               ;
	  mov	  ax, bx                                  ;
	  mov	  bl, screen_cols                         ;
	  div	  bl                                      ;
	  mov	  bl, al                                  ;
	  mov	  bh, ah                                  ;
                                                          ;
	  pop	  ax                                      ;
	  ret                                             ;

;=======================================================  ;
;  get the cursor pos                                     ;
;              out: bx = offset                           ;
;=======================================================  ;
GetCursor:                                                ;
	  push	  ax                                      ;
	  push	  dx                                      ;
                                                          ;
	  mov	  dx, 0x3D4                               ;
	  mov	  al, 0x0E                                ;
	  out	  dx, al                                  ;
	  inc	  dx                                      ;
	  in	  al, dx                                  ;
	  mov	  bh, al                                  ;
	  mov	  al, 0x0F                                ;
	  dec	  dx                                      ;
	  out	  dx, al                                  ;
	  inc	  dx                                      ;
	  in	  al, dx                                  ;
	  mov	  bl, al                                  ;
                                                          ;
	  pop	  dx                                      ;
	  pop	  ax                                      ;
	  ret                                             ;

;=======================================================  ;
;  SetCursorPos                                           ;
;=======================================================  ; 
SetCursorPos:                                             ;
	cmp	al,screen_cols                            ;
	jnb	@f                                        ;
	cmp	ah,screen_rows		                  ;
	jnb	@f                                        ;
	call	set_text_pos                              ;
	call	set_cursor_pos                            ;
	mov	ah,0                                      ;
	ret                                               ;
@@:                                                       ;
	stc                                               ;
	ret                                               ;

;=======================================================  ;
;  Prints char               ; print's a char from al     ;
;-------------------------------------------------------  ;
;                                                         ;
;  Input:                                                 ;
;      Al Ascii character to write.                       ;
;                                                         ;
; Output:                                                 ;
;      None.                                              ;
;=======================================================  ;
print_char:                                               ;
	pushad					          ;
	push	es                                        ;
	push	ds                                        ;
	push	ax                                        ;
	mov	ax,8h			                  ;
	mov	es,ax			                  ;
	pop	ax	                                  ;
	mov	edi,0xb8000                               ;
	call	get_scr_pointer                           ;
	mov	ah,[textcolor]                            ;
	mov	[es:edi],ax		                  ;
	call	inc_scr_pointer                           ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  Prints char cursor pos    ; print's a char from al     ;
;-------------------------------------------------------  ;
;                                                         ;
;  Input:                                                 ;
;      Al Ascii character to write.                       ;
; Output:                                                 ;
;      None.                                              ;
; NOTES:                                                  ;
;       Prints char from al, also moves cursor.           ;
;=======================================================  ;
PrintCharCursorPos:                                       ;
	pushad					          ;
	push	es                                        ;
	push	ds                                        ;
	push	ax                                        ;
	mov	ax,8h			                  ;
	mov	es,ax			                  ;
	pop	ax	                                  ;
	mov	edi,0xb8000                               ;
	call	get_scr_pointer                           ;
	mov	ah,[textcolor]                            ;
	mov	[es:edi],ax		                  ;
	call	inc_scr_pointer                           ;
	call	set_cursor_pos                            ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  print_char_cr_lf          ; print's a char from al     ;
;-------------------------------------------------------  ;
;                                                         ;
;                                                         ;
;  Input:                                                 ;
;      Al Ascii character to write.                       ;
;                                                         ;
; Output:                                                 ;
;      None.                                              ;
;=======================================================  ;
print_char_cr_lf:                                         ;
	pushad				                  ;	 
	push	es                                        ;
	push	ds                                        ;
	push	ax                                        ;
	mov	ax,8h			                  ;                 
	mov	es,ax			                  ;    
	pop	ax                                        ;
	cmp	al,0x0d 				  ; 13 = CR ( = \n )
	jne	no_cr_char                                ;
	mov	[screen_x],0                              ;
	jmp	print_char_cr_lf_exit                     ;
no_cr_char:                                               ;
	cmp	al,0x0a                                   ;
	jne	no_lf_char				  ; is lf ?
        call    Line_feed                                 ;
	jmp	print_char_cr_lf_exit                     ;
no_lf_char:                                               ;
	cmp	al,20h					  ; is it a control code?
	jb	print_char_cr_lf_exit1                    ;
	mov	edi,0xb8000                               ;
	call	get_scr_pointer                           ;
	mov	ah,[textcolor]                            ;
	mov	[es:edi],ax		                  ;
	call	inc_scr_pointer                           ;
print_char_cr_lf_exit:                                    ;
	call	set_cursor_pos                            ;
print_char_cr_lf_exit1:                                   ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;
	                                                  ;

;=======================================================  ;
;  Prints string      ; does what it say's on the box     ;
;-------------------------------------------------------  ;
;                                                         ;
;                                                         ;
;  Input:                                                 ;
;      es:esi points to $ ending string.                  ;
;                                                         ;
; Output:                                                 ;
;      None.                                              ;
;=======================================================  ;
print_string:                                             ;
	pushad					          ;
	push	es                                        ;
	push	ds                                        ;
aloop:                                                    ;
	mov	al,[esi]                                  ;
	cmp	al,'$'					  ; 0x00 = end of string
	je	gend                                      ;
	cmp	al,0xd2 				  ; 0xd2 = next byte is color byte
	je	ColorChange                               ;
	cmp	al,0x0d 				  ; 0x0d = CR ( = \n )
	jne	no_cr                                     ;
	mov	[screen_x],0                              ;
	jmp	a1                                        ;
ColorChange:                                              ;
	inc	esi                                       ;
	mov	al,[esi]                                  ;
	mov	byte[textcolor],al                        ;
	inc	esi                                       ;
	jmp	aloop                                     ;
no_cr:                                                    ;
	cmp	al,0x0a                                   ;
	jne	no_lf                                     ;
        call	Line_feed                                 ;
	jmp	a1                                        ;
no_lf:                                                    ;
	call	print_char                                ;
a1:	inc	esi                                       ;
	jmp	aloop                                     ;
gend:                                                     ;
	call	set_cursor_pos                            ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  print_string_zero  ; does what it say's on the box     ;
;-------------------------------------------------------  ;
;                                                         ;
;                                                         ;
;  Input:                                                 ;
;      es:esi points to asciiz string to write.           ;
;                                                         ;
; Output:                                                 ;
;      None.                                              ;
;=======================================================  ;
print_string_zero:                                        ;
	pushad			                          ;		 
	push	es                                        ;
	push	ds                                        ;
  print_string_zero_loop:                                 ;
	mov	al,[esi]                                  ;
	cmp	al,0					  ; 0x00 = end of string
	je	gend_zero                                 ;
	cmp	al,'$'					  ; 0x00 = end of string
	je	gend_zero                                 ;
	cmp	al,0xd2 				  ; 0xd2 = next byte is color byte
	je	ColorChange_zero                          ;
	cmp	al,0x0d 				  ; 0x0d = CR ( = \n )
	jne	no_cr_zero                                ;
	mov	[screen_x],0	                          ;
	jmp	a1_zero                                   ;
  ColorChange_zero:                                       ;
	inc	esi                                       ;
	mov	al,[esi]                                  ;
	mov	byte[textcolor],al                        ;
	inc	esi                                       ;
	jmp	print_string_zero_loop                    ;
  no_cr_zero:                                             ;
	cmp	al,0x0a                                   ;
	jne	no_lf_zero                                ;
        call	Line_feed                                 ;
	jmp	a1_zero                                   ;
  no_lf_zero:                                             ;
	call	print_char                                ;
  a1_zero:	                                          ;
	inc	esi                                       ;
	jmp	print_string_zero_loop                    ;
  gend_zero:                                              ;
	call	set_cursor_pos                            ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  Line_feed                                              ;   
;=======================================================  ; 
Line_feed:                                                ;
	push	eax                                       ;
	mov	ah,[screen_y]	                          ;
	cmp	ah,screen_rows1 		          ;		  
	jb	no_scroll                                 ;
	call	scroll                                    ;
	jmp	cend                                      ;
no_scroll:                                                ;
	inc	ah                                        ;
	mov	[screen_y],ah	                          ;
cend:	pop	eax                                       ;
	ret                                               ;

;=======================================================  ;
;  Line_feed plus zero X                                  ;   
;=======================================================  ; 
Line_feedZeroX:                                           ;
	push	eax                                       ;
	mov	[screen_x],0                              ;
	mov	ah,[screen_y]	                          ;
	cmp	ah,screen_rows1                           ;				  
	jb	no_scrollZeroX                            ;
	call	scroll                                    ;
	jmp	cendZeroX                                 ;
no_scrollZeroX:                                           ;
	inc	ah                                        ;
	mov	[screen_y],ah	                          ;
cendZeroX:	pop	eax                               ;
	ret                                               ;


;=======================================================  ;
; Scroll                                                  ;
;-------------------------------------------------------  ;
;                                                         ;
;                                                         ;
;   Input:                                                ;
;          none.                                          ;
;  Output:                                                ;
;          none.                                          ;
;=======================================================  ;
scroll:                                                   ;
	pushad                                            ;
	push	fs                                        ;
	push	es                                        ;
	push	ds                                        ;
	mov	ax,8h                                     ;
	mov	fs,ax                                     ;
	mov	al,0                                      ;
	mov	ah,screen_rows1                           ;
	call	set_text_pos                              ;
	mov	edi,0xb8000		                  ;                 
	mov	esi,0xb8000                               ;
	add	esi,screen_cols*2		          ;     
	mov	ecx,screen_cols*2*screen_rows/4           ;	     
mloop:	                                                  ;
	mov	eax,[fs:esi]                              ;
	add	esi,4                                     ;
	mov	[fs:edi],eax                              ;
	add	edi,4                                     ;
	dec	ecx                                       ;
	jnz	mloop                                     ;
	call	set_cursor_pos                            ;
	pop	ds                                        ;
	pop	es                                        ;
	pop	fs                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
; cls_text                        ; clear's full screen   ;
;-------------------------------------------------------  ;
;                                                         ;
;                                                         ;
;   Input:                                                ;
;          none.                                          ;
;  Output:                                                ;
;          none.                                          ;
;=======================================================  ;
cls_text:                                                 ;                              
	push	eax                                       ;
	push	ecx                                       ;
	push	esi                                       ;
	push	edi                                       ;
	push	fs                                        ;
	mov	ax,8h                                     ;
	mov	fs,ax                                     ;
	mov	ecx,screen_cols*screen_rows 	          ;		       
	mov	edi,0B8000h                               ;
	mov	al," "		                          ;
	mov	bl,0Fh		                          ;
cls_loop:                                                 ;
	mov	byte [fs:edi],al                          ;
	inc	edi                                       ;
	mov	byte [fs:edi],bl                          ;
	inc	edi                                       ;
	dec	ecx                                       ;
	jnz	cls_loop                                  ;
	mov	[screen_x],byte 0                         ;
	mov	[screen_y],byte 0                         ;
	call	set_cursor_pos		                  ;	       
	pop	fs                                        ;
	pop	edi                                       ;
	pop	esi                                       ;
	pop	ecx                                       ;
	pop	eax                                       ;
	ret                                               ;

;=======================================================  ;
; Sets cursor pos                                         ;
;-------------------------------------------------------  ;
;                                                         ;
;  Input:                                                 ;
;     [screen_x]    points to X                           ;
;                                                         ;
;     [screen_Y]    points to Y                           ;
;                                                         ;
; Output:                                                 ;
;      None.                                              ;
;=======================================================  ;
set_cursor_pos:                                           ;
	push	eax                                       ;
	push	ebx                                       ;
	push	ecx                                       ;
	push	edx                                       ;
	xor	ebx,ebx                                   ;
	mov	bl,[screen_x]				  ;     
	mov	ecx,ebx                                   ;
	mov	bl,[screen_y]				  ;      
	mov	eax,screen_cols                           ;
	mul	bx                                        ;
	add	eax,ecx 				  ;  
	mov	edx,0x3d4                                 ;
	mov	ecx,eax                                   ;
	mov	al,0x0f                                   ;
	out	dx,al                                     ;
	mov	eax,ecx                                   ;
	inc	edx                                       ;
	out	dx,al                                     ;
	mov	al,0x0e                                   ;
	dec	edx                                       ;
	out	dx,al                                     ;
	mov	eax,ecx                                   ;
	mov	al,ah                                     ;
	inc	edx                                       ;
	out	dx,al					  ;     
	pop	edx                                       ;
	pop	ecx                                       ;
	pop	ebx                                       ;
	pop	eax                                       ;
	ret                                               ;

;=======================================================  ;
;  Inc screen pointer                                     ;   
;=======================================================  ; 
inc_scr_pointer:                                          ;
	push	eax                                       ;
	cld                                               ;
	mov	al,[screen_x]                             ;
	cmp	al,screen_cols1                           ;
	jb	no_incy                                   ;
	call	Line_feedZeroX                            ;
	jmp	dend                                      ;
no_incy:                                                  ;
	inc	al                                        ;
	mov	[screen_x],al                             ;
dend:	pop	eax                                       ;
	ret                                               ;

;=======================================================  ;
;  Gets screen pointer                                    ;   
;=======================================================  ; 
get_scr_pointer:                                          ;
	push	eax					  ;   
	push	ebx                                       ;
	xor	ebx,ebx                                   ;
	mov	bl,[screen_x]                             ;
	shl	ebx,1                                     ;
	add	edi, ebx                                  ;
	mov	bl,[screen_y]                             ;
	mov	eax,0xa0                                  ;
	mul	bx                                        ;
	add	edi,eax                                   ;
	pop	ebx                                       ;
	pop	eax                                       ;
	ret                                               ;

;=======================================================  ;
; CompearString                                           ;
;-------------------------------------------------------  ;
;                                                         ;
;  Input:                                                 ;
;     es:edi = string1 buffer (0 termanated)              ;
;     ds:esi = string2 buffer (0 termanated)              ;
;        ecx = string size                                ;
;                                                         ;
; Output:                                                 ;
;      set CF1 on error (jc on error)                     ;
;.......................................................  ;
; NOTE: I left this in as a joke,                         ;
; So no comments on compear                               ;
;=======================================================  ;
CompearString:                                            ;
	pushad                                            ;
	push	es                                        ;
	push	ds                                        ;
	mov	ax,18h                                    ;
	mov	ds,ax			                  ;	     
	mov	es,ax                                     ;
	cmp	ecx,0                                     ;
	je	CmpNameFailed                             ;
	cld			                          ;		
	repe	cmpsb                                     ;
	jne	CmpNameFailed                             ;
	jmp	CmpNameFound                              ;
CmpNameFailed:                                            ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	stc                                               ;
	ret                                               ;
                                                          ;
CmpNameFound:                                             ;
	pop	ds                                        ;
	pop	es                                        ;
	popad                                             ;
	clc                                               ;
	ret                                               ;

;=======================================================  ;
;  write hex 32                                           ;   
;=======================================================  ; 
write_hex32:                                              ;
	pushad                                            ;
	mov     ebx,eax                                   ;
	mov     ecx,4                                     ;
loop1:                                                    ;
	rol     eax,8		                          ;			   
	call    write_hex8                                ;
	loop    loop1                                     ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  write hex16                                            ;   
;=======================================================  ; 
write_hex16:                                              ;
	pushad                                            ;
	mov     ebx,eax                                   ;
	shr     eax,8                                     ;
	call    write_hex8                                ;
	mov     eax,ebx                                   ;
	call    write_hex8                                ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  write hex                                              ;   
;=======================================================  ; 
write_hex8:                                               ;
	push    eax                                       ;
	push    eax                                       ;
	shr     al,4					  ;   
	call    hexget					  ; 
	call    print_char                                ;
	pop     eax                                       ;
	call    hexget					  ;  
	call    print_char                                ;
	pop     eax                                       ;
	ret                                               ;

;=======================================================  ;
;  hexget           convers from ASCII to hexadecimal.    ;   
;=======================================================  ; 
hexget:                                                   ;
	and     eax,0x0000000f                            ;
	or      eax,0x00000030                            ;
	cmp     eax,0x39                                  ;
	ja      add7                                      ;
	ret                                               ;
add7:	add     eax,7		                          ;
	ret                                               ;

;=======================================================  ;
; UpperCase.       ; converts a string to uppercase.      ;
;-------------------------------------------------------  ;
;                                                         ;
; es:edi = string buffer (0 termanated)                   ;
;=======================================================  ;
UpperCase:                                                ;
	pushad                                            ;
	push	es                                        ;
	mov	ax,sys_data				  ;
	mov	es,ax	                                  ;
UcaseNextChar:                                            ;
	mov	al,byte[es:edi]                           ;
	cmp	al,0                                      ;
	je	UcaseDone                                 ;
	cmp	al,0x61                                   ;
	jb	DontUcaseChar                             ;
	cmp	al,0x7a                                   ;
	ja	DontUcaseChar                             ;
	sub	al,0x20                                   ;
	mov	byte[es:edi],al                           ;
DontUcaseChar:                                            ;
	inc	edi                                       ;
	jmp	UcaseNextChar                             ;
UcaseDone:                                                ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
; LowerCase.       ; converts a string to lowercase.      ;
;-------------------------------------------------------  ;
;                                                         ;
; es:edi = string buffer (0 termanated)                   ;
;=======================================================  ;
LowerCase:                                                ;
	pushad                                            ;
	push	es                                        ;
	mov	ax,sys_data				  ;
	mov	es,ax	                                  ;
LcaseNextChar:                                            ;
	mov	al,byte[es:edi]                           ;
	cmp	al,0                                      ;
	je	LcaseDone                                 ;
	cmp	al,0x41                                   ;
	jb	DontLcaseChar                             ;
	cmp	al,0x5c                                   ;
	ja	DontLcaseChar                             ;
	add	al,0x20                                   ;
	mov	byte[es:edi],al                           ;
DontLcaseChar:                                            ;
	inc	edi                                       ;
	jmp	LcaseNextChar                             ;
LcaseDone:                                                ;
	pop	es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  GetCommandUser                                         ;   
;=======================================================  ; 
GetCommandUser:                                           ;
	pushad                                            ;
	push    es                                        ;
	cmp     bx,100                                    ;
	je      @f                                        ;
	mov     dx,CmdSizeUser                            ;
@@:                                                       ;
	push    es                                        ;
	pushad                                            ;
	mov     ax,18h				          ;
	mov     es,ax	                                  ;
	mov     edi,CommandBufferUser                     ;
	mov     cx,128                                    ;
	mov     al,' '                                    ;
	rep     stosb                                     ;
	popad	                                          ;
	pop     es			                  ;
	mov     edi,CommandBufferUser                     ;
	call    GetStringUser                             ;
	jc      EscPressed                                ;
	pop     es                                        ;
	popad                                             ;
	mov     edi,CommandBufferUser                     ;
	mov     cx,word[UserCount]                        ;
	clc                                               ;
	ret                                               ;
EscPressed:                                               ;
	pop     es                                        ;
	popad                                             ;
	stc                                               ;
	ret                                               ;

;=======================================================  ;
;  GetStringUser                                          ;   
;=======================================================  ; 
GetStringUser:                                            ;
	pushad                                            ;
	push    es                                        ;
	mov     ax,sys_data	                          ;			 
	mov     es,ax                                     ;
	mov     edi,CommandBufferUser                     ;
	mov     ecx,0                                     ;
	cmp     dx,1			                  ;		 
	jbe     EmptyBufferUser                           ;
	dec     dx				          ;	 
@@:                                                       ;
	call    WaitForKeyPress                           ;
	cmp     [keybuffer],0                             ;
	je      @b                                        ;
	mov     al,[keybuffer]                            ;
	mov     [keybuffer],0                             ;
	cmp     al,13			                  ;		 
	jz      ExitUser                                  ;
	cmp     al,27			                  ;		 
	jz      ExitEsc                                   ;
	cmp     al, 8				          ;	 
	jne     AddToBufferUser                           ;
	jcxz    @b				          ;	 
	cmp     [screen_x],0                              ;
	je      @b                                        ;
	dec     cx                                        ;
	dec     edi                                       ;
	dec     [screen_x]                                ;
	mov     al,' '                                    ;
	call    print_char                                ;
	dec     [screen_x]                                ;
	call    set_cursor_pos                            ;
	jmp     @b                                        ;
AddToBufferUser:                                          ;
	cmp     cx,dx					  ; 
	jae     @b					  ;  
	stosb                                             ;
	inc     cx                                        ;
	call    PrintCharCursorPos                        ;
	jmp     @b                                        ;
ExitUser:                                                 ;
	mov     byte [es:edi],0			          ;	 
EmptyBufferUser:                                          ;
	mov     [UserCount],cx                            ;
	clc                                               ;
	pop     es                                        ;
	popad                                             ;
	ret                                               ;
ExitEsc:                                                  ;
	stc                                               ;
	pop     es                                        ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
; Get Command NEW.                                        ;
;=======================================================  ;
GetCommandNEW:                                            ;
	mov     dx,74 ;32 ;CmdSizeNEW                     ;
	mov     edi,CommandBufferNEW                      ;
	call    GetStringNEW                              ;
	jc      GetCommandNEWesc                          ;
	mov     edi,CommandBuffer2NEW                     ;
	mov     cx,word[CliBuffcountNEW]                  ;
	clc                                               ;
	ret                                               ;
                                                          ;
GetCommandNEWesc:                                         ;
	stc                                               ;
	ret                                               ;

;=======================================================  ;
; Get String NEW                                28/02/11  ;
;-------------------------------------------------------  ;
; Get string from user, the received string is            ;
; written to buffer                                       ;
; at    ES:EDI, buffer size should be in DX.              ;
;                                                         ;                                                             
;=======================================================  ;
GetStringNEW:                                             ;
	pushad                                            ;
	push    es                                        ;
	mov     ax,sys_data	                          ;			 
	mov     es,ax                                     ;
	mov     edi,CommandBufferNEW                      ;
	mov     ecx,0                                     ;
	cmp     dx,1			                  ;		 
	jbe     EmptyBufferNEW                            ;
	dec     dx			                  ;		 
@@:                                                       ;
	call    WaitForKeyPress                           ;
	mov     al,[keybuffer]                            ;
	mov     ah,[ScanCode]                             ;
	mov     [ScanCode],0                              ;
	mov     [keybuffer],0                             ;
	cmp     al,13			                  ;		 
	jz      ExitNEW                                   ;
	cmp     al,27                                     ;
	jz      ExitEscGetStringNEW                       ;
	cmp     ah,0x4d                                   ;
	jne     La1NEW                                    ;
	cmp     [CliBuffcountNEW],0                       ;
	jbe     @b                                        ;
	cmp     cx,[CliBuffcountNEW]                      ;
	jae     @b                                        ;
	mov     esi,CommandBuffer2NEW                     ;
	push    eax                                       ;
	xor     eax,eax                                   ;
	add     ax,cx                                     ;
	add     esi,eax                                   ;
	pop     eax                                       ;
	lodsb                                             ;
	jmp     AddToBufferNEW                            ;
La1NEW:                                                   ;
	cmp     ah,0x4b                                   ;
	je      La2NEW                                    ;
	cmp     al, 0                                     ;
	je      @b                                        ;
	cmp     al, 8			                  ;		 
	jne     AddToBufferNEW                            ;
La2NEW:                                                   ;
	jcxz    @b		                          ;			 
	;cmp     [screen_x],20                             ;
	;je      @b                                        ;
	dec     cx                                        ;
	dec     edi                                       ;
	dec     [screen_x]                                ;
	mov     al,' '                                    ;
	call    print_char                                ;
	dec     [screen_x]                                ;
	call    set_cursor_pos                            ;
	jmp     @b                                        ;
AddToBufferNEW:                                           ;
	cmp     cx,dx		                          ;			 
	jae     @b                                        ;
AddToBuffer1NEW:                                          ;
	stosb                                             ;
	inc     cx                                        ;
	call    PrintCharCursorPos                        ;
	jmp     @b                                        ;
ExitNEW:                                                  ;
	mov     byte [es:edi],0		                  ;		  
EmptyBufferNEW:                                           ;
	mov     [craicountNEW],cx                         ;
	mov     [CliBuffcountNEW],cx                      ;
	mov     edi,CommandBuffer2NEW                     ;
	mov     esi,CommandBufferNEW                      ;
	mov     cx,128                                    ;
	rep     movsb                                     ;
	pop     es                                        ;
	popad                                             ;
	clc                                               ;
	ret                                               ;
                                                          ;
ExitEscGetStringNEW:                                      ;
	pop     es                                        ;
	popad                                             ;
	stc                                               ;
	ret                                               ;

;=======================================================  ;
;  Get string no echo                                     ;
;-------------------------------------------------------  ;
; Get string from user, the received string is            ;
; written to buffer                                       ;
; at    ES:EDI, buffer size should be in DX.              ;
;                                                         ;                                                             
;=======================================================  ;
Get_string:                                               ;
	pushad				                  ;
	push	es			                  ;
	mov     ax,sys_data		                  ;
	mov	es,ax			                  ;
	call	UpDateCursorVarXY	                  ;
	mov	byte [NoFastReTurnVar],0                  ;
	mov	edi,edx 		                  ;
	mov	cl,byte [edi]		                  ;
	cmp	cl,0			                  ;
	jne	NoFastReTurn		                  ;
	mov	byte [NoFastReTurnVar],1                  ;
  NoFastReTurn: 			                  ;
	dec	cl			                  ;
	inc	edi			                  ;
	mov	dword[BuffReTurnAddress],edi              ;
	inc	edi			                  ;
	mov	byte[NumberCountChar],0                   ;
	mov	[WaitKPressed],0	                  ;
  @@:                                                     ;
	hlt				                  ;
	cmp	[WaitKPressed],1	                  ;
	jne	@b			                  ;
	mov	[WaitKPressed],0	                  ;
	cmp	byte [FastReTurnVar],1	                  ;
	je	FastReTurnExit		                  ;
	mov	al,[keybuffer]		                  ;
	cmp	al,0dh			                  ;
	je	Get_string_no_echo_exit                   ;
	cmp	al,0x08 		                  ;
	jne	NoBackKey		                  ;
	cmp	byte[NumberCountChar],0                   ;
	je	@b			                  ;
	dec	byte[NumberCountChar]	                  ;
	push	eax			                  ;
	dec	byte[screen_x]		                  ;
	mov	al,' '			                  ;
	dec	edi			                  ;
	call	print_char		                  ;
	dec	[screen_x]		                  ;
	call	set_cursor_pos		                  ;
	pop	eax			                  ;
	jmp	@b			                  ;
  NoBackKey:				                  ;
	cmp	cl,byte[NumberCountChar]                  ;
	jbe	@b			                  ;
	inc	byte [NumberCountChar]	                  ;
	stosb				                  ;
	push	eax			                  ;
	call	PrintCharCursorPos	                  ;
	pop	eax			                  ;
	jmp	@b			                  ;
  Get_string_no_echo_exit:		                  ;
	stosb				                  ;
	mov	edi,dword[BuffReTurnAddress]              ;
	mov	al,byte [NumberCountChar]                 ;
	stosb				                  ;
	pop	es			                  ;
	popad				                  ;
	ret				                  ;
  FastReTurnExit:			                  ;
	pop	es			                  ;
	popad				                  ;
	ret				                  ;

;=======================================================  ;
;  Data                                                   ;
;=======================================================  ;
BuffReTurnAddress  dd 0                                   ;
NumberCountChar    db 0                                   ;
NoFastReTurnVar    db 0                                   ;
FastReTurnVar	   db 0                                   ;
UserCount	   dw 0                                   ;
CmdSizeUser =	      0x80                                ;
CliBuffcountNEW    dw 0                                   ;
craicountNEW	   dw 0                                   ;
CommandBufferUser: times   128	db 0                      ;
CommandBufferNEW:  times   128	db 0                      ;
CommandBuffer2NEW: times   128	db 0                      ;

