;=========================================================;
; Terminal                                     01/04/2010 ;
;---------------------------------------------------------;
;                                                         ;
;                                                         ;
; (c)Craig & Ben Bamford, All rights reserved.            ;
;=========================================================;

;=======================================================  ;
;  Ready prompt.                                          ;
;=======================================================  ; 
ReadyPrompt:                                              ;
        call    SetPalette                                ;
	mov     [textcolor],0x07                          ;
	mov	[screen_x],0                              ;
	mov	[screen_y],1	                          ;
	call	set_cursor_pos                            ;
	mov	esi,StartMsg                              ;
	call	print_string                              ;
	ret                                               ;
 
;=======================================================  ;
;  Prompt.                                                ;
;=======================================================  ; 
Prompt:                                                   ;
	pushad                                            ;
	mov	al,[textcolor]                            ;
	mov	[textcolorsave],al                        ;
	mov	[textcolor],0x09                          ;
	mov	al,byte[BootDrive]                        ;
	mov	byte[CliPrompt],al                        ;
	mov	esi,CliPrompt                             ;
	call	print_string                              ;
	mov	esi,CliPrompt2                            ;
	call	print_string                              ;
	mov	al,[textcolorsave]                        ;
	mov	[textcolor],al                            ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  PALETTE                                                ;
;=======================================================  ; 
Palette:                                                  ;
	pushad                                            ;
	mov     dx,3c8h		                          ;			 
	out     dx,al                                     ;
	inc     dx		                          ;			
	mov     al,bl		                          ;			 
	out     dx,al                                     ;
	mov     al,bh	                                  ;				 
	out     dx,al                                     ;
	mov     al,cl	                                  ;				 
	out     dx,al                                     ;
	popad                                             ;
	ret                                               ;

;=======================================================  ;
;  Set a nifty color palette.                             ;
;=======================================================  ; 
SetPalette:                                               ;
	mov     al,2                                      ;
	mov     bx,0x3f3f                                 ;
	mov     cl,43                                     ;
	call    Palette		                          ;			    
	mov     al,4                                      ;
	mov     cl,63                                     ;
	call    Palette		                          ;			      
	mov     al,5                                      ;
	mov     bx,0x3228                                 ;
	call    Palette		                          ;			       
	mov     al,7                                      ;
	call    Palette		                          ;		       
	mov     al,5                                      ;
	mov     bx,0x0032                                 ;
	mov     cl,0                                      ;
	call    Palette	                                  ;
	mov     al,58                                     ;
	mov     bx,0x0A00                                 ;
	call    Palette	                                  ;
	inc     al                                        ;
	mov     bh,40                                     ;
	call    Palette	                                  ;
	mov     al,56                                     ;
	mov     bx,0x1010                                 ;
	mov     cl,32                                     ;
	call    Palette                                   ;
	mov     al,60                                     ;
	mov     bx,0x1818                                 ;
	mov     cl,48                                     ;
	call    Palette                                   ;
	ret                                               ;

;=======================================================  ;
;  Data.                                                  ;
;=======================================================  ; 
    CliPrompt	      db 0                                ;
		      db ':\$'                            ;
    CliPrompt2	      db '>$'                             ;
                                                          ;
StartMsg:	   db 13,10,0xd2,0x09,'DexOS',13,10
		   db '  (',0xd2,0x01,'C',0xd2,0x09,')Copyright Craig Bamford 2001-2011.',0xd2,0x07,13,13,10,'$'
