;=========================================================;
; RmInt                                        01/04/2011 ;
;---------------------------------------------------------;
;                                                         ;
; (c) Craig Bamford, All rights reserved.                 ;
;=========================================================;
align 4

;=======================================================  ;
; RealModeInt10h.                                         ;
; Action:                                                 ;
;       Call realmode int 10h.                            ;
;=======================================================  ;
; IN:   AX,BX,CX,DX = same as int 10H function            ;
;                                                         ;
; OUT:  Carry set on error                                ;
;       Carry cleared = OK                                ;
;       Rest same as int 10H function                     ;
;=======================================================  ;
RealModeInt10h: 					  ;
	pushad						  ;
	push	es					  ;
	mov	byte[RealModeError],0			  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	call	remap_pic_realmode			  ;
	jmp	0x20:RealModeInt10h16pm 		  ;
use16							  ;
  RealModeInt10h16pm:					  ;
	mov	ax,0x28 				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	bx,[RealModeCS] 			  ;
	push	bx					  ;
	lea	bx,[GoToRmInt10h]			  ;
	push	bx					  ;
	mov	eax,cr0 				  ;
	and	al,0xFE 				  ;
	mov	cr0,eax 				  ;
	retf						  ;
  GoToRmInt10h: 					  ;
	mov	ax,cs					  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
	lidt	[ridtr] 				  ;
	push	cs					  ;
	pop	ds					  ;
	push	ds					  ;
	pop	es					  ;
	call	unmask_irqs				  ;
	mov	ax,word[RealModeAX]			  ;
	mov	bx,word[RealModeBX]			  ;
	mov	cx,word[RealModeCX]			  ;
	mov	dx,word[RealModeDX]			  ;
	int	10h					  ;
	jnc	@f					  ;
	mov	byte[RealModeError],1			  ;
@@:							  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	cli						  ;
	lgdt	[gdtr]					  ;
	lidt	[idtr]					  ;
	mov	eax,cr0 				  ;                       
	or	al,1					  ;
	mov	cr0,eax 				  ;
	jmp	sys_code:GoToPmInt10h			  ;
use32							  ;
  GoToPmInt10h: 					  ;
	mov	ax,sys_data				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	es,ax					  ;
	mov	gs,ax					  ;
	mov	ax,8h					  ;
	mov	fs,ax					  ;
	call	remap_pic				  ;
	call	unmask_irqs				  ;
	in	al,60h					  ;
	pop	es					  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
; VesaRmInt.                                              ;
; Action:                                                 ;
;       Sets vesa mode.                                   ;
;=======================================================  ;
; IN:   BX = mode number.                                 ;
;                                                         ;
; OUT:  Carry set on error                                ;
;       Carry cleared = OK                                ;
;                                                         ;
; Notes:                                                  ;
; Need vesa info structure filling out after calling.     ;
;=======================================================  ;
VesaRmInt:						  ;
	pushad						  ;
	push	es					  ;
	mov	word[RealModeBX],bx			  ;
	mov	byte[vesaRmError],0			  ;
	call	remap_pic_realmode			  ;
	jmp	0x20:VesaRmInt16PM			  ;
use16							  ;
  VesaRmInt16PM:					  ;
	mov	ax,0x28 				  ;                                 
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	bx,[RealModeCS] 			  ;
	push	bx					  ;
	lea	bx,[VesaRmInt16RM]			  ;
	push	bx					  ;
	mov	eax,cr0 				  ;
	and	al,0xFE 				  ;
	mov	cr0,eax 				  ;
	retf						  ;
  VesaRmInt16RM:					  ;
	mov	ax,cs					  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
	lidt	[ridtr] 				  ;
	push	cs					  ;
	pop	ds					  ;
	push	ds					  ;
	pop	es					  ;
	call	unmask_irqs				  ;
	mov	byte[vesaRmError],0			  ;
	mov	cx,word[RealModeBX]			  ;
	mov	ax,4f01h				  ;
	mov	di,Mode_Info				  ;
	and	cx,0xfff				  ;
	int	10h					  ;
	cmp	[VESAInfo_Version],0x200		  ;
	jb	NoVesaMode				  ;
	mov	ax,[ModeInfo_ModeAttributes]		  ;
	and	al,00000001b				  ;
	cmp	al,1					  ;
	jne	NoVesaMode				  ;
	mov	ax,[ModeInfo_ModeAttributes]		  ;
	and	al,10000000b				  ;
	cmp	al,10000000b				  ;
	jne	NoVesaMode				  ;
	mov	byte[NoVesa],0				  ;
	mov	ax,0x4f02				  ;
	mov	bx,word[RealModeBX]			  ;
	int	10h					  ;
	cmp	ax,004Fh				  ;
	je	VesaOK					  ;
  NoVesaMode:						  ;
	mov	byte[vesaRmError],1			  ;
  VesaOK:						  ;
	cli						  ;
	lgdt	[gdtr]					  ;
	lidt	[idtr]					  ;
	mov	eax,cr0 				  ;                       
	or	al,1					  ;
	mov	cr0,eax 				  ;
	jmp	sys_code:GoToPmVesaRmInt		  ;
use32							  ;
  GoToPmVesaRmInt:					  ;
	mov	ax,sys_data				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
	mov	ax,8h					  ;
	mov	fs,ax					  ;
	call	remap_pic				  ;
	call	unmask_irqs				  ;
	in	al,60h					  ;
	pop	es					  ;
	popad						  ;
	mov	ah,0					  ;
	cmp	byte[vesaRmError],0			  ;
	je	@f					  ;
	mov	ah,1					  ;
@@:							  ;
	ret						  ;

;=======================================================  ;
; RealModeRegs.                                           ;
; Action:                                                 ;
;       Fills in AX,BX,CX,DX with result from int's       ;
;=======================================================  ;
; IN:                                                     ;
;       Nothing                                           ;
;                                                         ;
; OUT:                                                    ;
;       Fills in AX,BX,CX,DX with result from int's       ;
;=======================================================  ;
RealModeRegs:						  ;
	mov	ax,word[RealModeAX]			  ;
	mov	bx,word[RealModeBX]			  ;
	mov	cx,word[RealModeCX]			  ;
	mov	dx,word[RealModeDX]			  ;
	cmp	[RealModeError],0			  ;
	je	@f					  ;
	stc						  ;
	ret						  ;
@@:							  ;
	clc						  ;
	ret						  ;

align 4 						  ;
;=======================================================  ;
; FddReadB.                                               ;
; Action:                                                 ;
;       read sector using BIOS                            ;
;=======================================================  ;
;   Input:                                                ;
;       ES:BX  = Buffer address                           ;
;          CH  = Track/cylinder                           ;
;          CL  = Sector                                   ;
;          DH  = Head                                     ;
;          DL  = Drive                                    ;
;          AL  = Number of sectors (normaly 1)            ;
;          AH  = ReadSector(02h)                          ;
;                                                         ;
;  Output:                                                ;
;          AH  = Status                                   ;
;          AL  = Sector number read                       ;
;          CF  = 0 If successful                          ;
;              = 1 If error                               ;
;=======================================================  ;
FddReadB:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	[FloppyTestRMI],0			  ;
	mov	[FddErrorStatus],0x04			  ;                                         
	mov	al,01					  ;
	mov	byte[RealModeError],0			  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	call	remap_pic_realmode			  ;
	jmp	0x20:do_16Int13h			  ;
use16							  ;
  do_16Int13h:						  ;
	mov	ax,0x28 				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
;=======================================================  ;
;   push real-mode CS:IP.                                 ;
;=======================================================  ;
	mov	bx,[RealModeCS] 			  ;
	push	bx					  ;
	lea	bx,[do_rmInt13h]			  ;
	push	bx					  ;
;=======================================================  ;
;   clear PE [pmode enable] bit and return to Rmode.      ;
;=======================================================  ;
	mov	eax,cr0 				  ;
	and	al,0xFE 				  ;
	mov	cr0,eax 				  ;
	retf						  ;
;=======================================================  ;
;   16-bit real mode again.                               ;
;=======================================================  ;                                 
do_rmInt13h:						  ;
	mov	ax,cs					  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
;=======================================================  ;
;   point to real-mode IDTR.                              ;
;=======================================================  ;  
	lidt	[ridtr] 				  ;
	push	cs					  ;
	pop	ds					  ;
	push	ds					  ;
	pop	es					  ;
	call	unmask_irqs				  ;
;=======================================================  ;
;  Do real mode interrupts                                ;
;=======================================================  ;  
  TryReadFloppyAgainRM: 				  ;
	mov	ax,word[RealModeAX]			  ;
	mov	bx,word[RealModeBX]			  ;
	mov	cx,word[RealModeCX]			  ;
	mov	dx,word[RealModeDX]			  ;  
	mov	bx,OffsetDma2Buffer			  ;
	mov	ah,02h					  ;
	int	13h					  ;
	jnc	@f					  ;
	mov	dx,word[RealModeDX]			  ;
	cmp	dl,0					  ;
	jne	RmFddRReadError 			  ;
	inc	[FloppyTestRMI] 			  ;
	cmp	[FloppyTestRMI],4			  ;
	jae	RmFddRReadError 			  ;
	mov	dx,word[RealModeDX]			  ;
	mov	ah,00					  ;
	int	13h					  ;
	jmp	TryReadFloppyAgainRM			  ;
  RmFddRReadError:					  ;
	mov	byte[RealModeError],1			  ;
@@:							  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	cli						  ;
;=======================================================  ;
;  Lets go back to pmode.                                 ;
;=======================================================  ;  
	lgdt	[gdtr]					  ;                       
	lidt	[idtr]					  ;
	mov	eax,cr0 				  ;                       
	or	al,1					  ;
	mov	cr0,eax 				  ;
;=======================================================  ;
;  jumps to do_pm.                                        ;
;=======================================================  ; 
	jmp	sys_code:do_pmInt13h			  ;
;=======================================================  ;
;  32-bit protected mode.                                 ;
;=======================================================  ; 
use32							  ;
  do_pmInt13h:						  ;
	mov	ax,sys_data				  ;
	mov	ds,ax					  ;        
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
	mov	ax,8h					  ;
	mov	fs,ax					  ;
	call	remap_pic				  ;
	call	unmask_irqs				  ;
	in	al,60h					  ;
	cmp	[RealModeError],1			  ;
	je	FddReadError1				  ;
;=======================================================  ;
;  Exit OK.                                               ;
;=======================================================  ; 
  FddReadSuccsess:					  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;                  
	mov	ax,word[RealModeAX]			  ;
	mov	esi,OffsetDma2Buffer			  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error1.                                           ;
;=======================================================  ; 
FddReadError:						  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ah,[FddErrorStatus]			  ;             
	stc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error2.                                           ;
;=======================================================  ; 
FddReadError1:						  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ax,word[RealModeAX]			  ;
	stc						  ;
	ret						  ;

align 4 						  ;
;=======================================================  ;
; FddWriteB.                                              ;
; Action:                                                 ;
;       Write sector using BIOS                           ;
;=======================================================  ;
;   Input:                                                ;
;       ES:BX  = Buffer address                           ;
;          CH  = Track/cylinder                           ;
;          CL  = Sector                                   ;
;          DH  = Head                                     ;
;          DL  = Drive                                    ;
;          AL  = Number of sectors (normaly 1)            ;
;          AH  = ReadSector(03h)                          ;
;                                                         ;
;  Output:                                                ;
;          AH  = Status                                   ;
;          AL  = Sector number writen                     ;
;          CF  = 0 If successful                          ;
;              = 1 If error                               ;
;=======================================================  ;
FddWriteB:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	[FloppyTestRMI],0			  ;
	mov	[FddErrorStatus],0x04			  ;             
	mov	al,01					  ;
	mov	byte[RealModeError],0			  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	call	remap_pic_realmode			  ;
	jmp	0x20:do_16Int13hWrite			  ;
use16							  ;
  do_16Int13hWrite:					  ;
	mov	ax,0x28 				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
;=======================================================  ;
;  push real-mode CS:IP.                                  ;
;=======================================================  ; 
	mov	bx,[RealModeCS] 			  ;
	push	bx					  ;
	lea	bx,[do_rmInt13hWrite]			  ;
	push	bx					  ;
;=======================================================  ;
;  clear PE [pmode enable] bit and return to Rmode.       ;
;=======================================================  ; 
	mov	eax,cr0 				  ;
	and	al,0xFE 				  ;
	mov	cr0,eax 				  ;
	retf						  ;
;=======================================================  ;
;  16-bit real mode again.                                ;
;=======================================================  ;                                 
do_rmInt13hWrite:					  ;
	mov	ax,cs					  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
;=======================================================  ;
;  point to real-mode IDTR.                               ;
;=======================================================  ;   
	lidt	[ridtr] 				  ;
	push	cs					  ;
	pop	ds					  ;
	push	ds					  ;
	pop	es					  ;
	call	unmask_irqs				  ;
;=======================================================  ;
;  Do real mode interrupts.                               ;
;=======================================================  ;   
  TryWriteFloppyAgainRM:				  ;
	mov	ax,word[RealModeAX]			  ;
	mov	bx,word[RealModeBX]			  ;
	mov	cx,word[RealModeCX]			  ;
	mov	dx,word[RealModeDX]			  ;   
	mov	bx,OffsetDma2Buffer1			  ;
	mov	ah,03h					  ;
	int	13h					  ;
	jnc	@f					  ;
	mov	dx,word[RealModeDX]			  ;
	cmp	dl,0					  ;
	jne	RmFddError				  ;
	inc	[FloppyTestRMI] 			  ;
	cmp	[FloppyTestRMI],4			  ;
	jae	RmFddError				  ;
	mov	dx,word[RealModeDX]			  ;
	mov	ah,00					  ;
	int	13h					  ;
	jmp	TryWriteFloppyAgainRM			  ;
  RmFddError:						  ;
	mov	byte[RealModeError],1			  ;
@@:							  ;
	mov	word[RealModeAX],ax			  ;
	mov	word[RealModeBX],bx			  ;
	mov	word[RealModeCX],cx			  ;
	mov	word[RealModeDX],dx			  ;
	cli						  ;
;=======================================================  ;
;  Lets go back to pmode.                                 ;
;=======================================================  ;       
	lgdt	[gdtr]					  ;                       
	lidt	[idtr]					  ;
	mov	eax,cr0 				  ;                               
	or	al,1					  ;
	mov	cr0,eax 				  ;
;=======================================================  ;
;  jumps to do_pm.                                        ;
;=======================================================  ;  
	jmp	sys_code:do_pmInt13hWrite		  ;
;=======================================================  ;
;  32-bit protected mode.                                 ;
;=======================================================  ;  
use32							  ;
  do_pmInt13hWrite:					  ;
	mov	ax,sys_data				  ;
	mov	ds,ax					  ;
	mov	ss,ax					  ;
	nop						  ;
	mov	es,ax					  ;
	mov	fs,ax					  ;
	mov	gs,ax					  ;
	mov	ax,8h					  ;
	mov	fs,ax					  ;
	call	remap_pic				  ;
	call	unmask_irqs				  ;
	in	al,60h					  ;
	cmp	[RealModeError],1			  ;
	je	FddWriteError1				  ;
;=======================================================  ;
;  Exit OK.                                               ;
;=======================================================  ; 
FddWriteSuccsess:					  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;                  
	mov	ax,word[RealModeAX]			  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error1.                                           ;
;=======================================================  ; 
FddWriteError:						  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ah,[FddErrorStatus]			  ;                     
	stc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error2.                                           ;
;=======================================================  ; 
FddWriteError1: 					  ;
	cmp	byte[FileSysTypeNew],12                   ;
        jne     @f                                        ;
        cli                                               ;
        mov     [FddTimer],36                             ;
        mov     [FddTimerOn],1                            ;
        sti	                                          ;
@@:                                                       ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ax,word[RealModeAX]			  ;
	stc						  ;
	ret						  ;

align 4 						  ;
;=======================================================  ;
;  Data.                                                  ;
;=======================================================  ; 
RealModeError	      db 0				  ;
vesaRmError	      db 0				  ;
RealModeAX	      dw 0				  ;
RealModeBX	      dw 0				  ;
RealModeCX	      dw 0				  ;
RealModeDX	      dw 0				  ;
RealModeDI	      dw 0				  ;
RealModeSI	      dw 0				  ;
BiosIntNumber	      dw 0				  ;
;=======================================================  ;
;  Data  floppy                                           ;
;=======================================================  ; 
FddErrorStatus	      db 0				  ; this the error code 00 = no error
FloppyTestRMI	      db 0				  ;
Head		      db 0				  ; store the head/side.
DriveHead	      db 0				  ; store head + drive.
cTrack		      db 0				  ; store track/cylinder
Sector		      db 0				  ; store Sector
FddDrive	      db 0				  ;
