;=========================================================;
; RmMouse                                      01/05/2011 ;
;---------------------------------------------------------;
;                                                         ;
; (c) Craig Bamford, All rights reserved.                 ;
;=========================================================;
					
;=======================================================  ;
; kb_read.                                                ;
;=======================================================  ;  
kb_read:						  ;
	push	ecx edx 				  ;
	mov	ecx,0xffff				  ;
  kr_loop:						  ;
	in	al,0x64 				  ;
	test	al,1					  ;
	jnz	kr_ready				  ;
	loop	kr_loop 				  ;
	mov	ah,1					  ;
	jmp	kr_exit 				  ;
  kr_ready:						  ;
	push	ecx					  ;
	mov	ecx,32					  ;
  kr_delay:						  ;
	loop	kr_delay				  ;
	pop	ecx					  ;
	in	al,0x60 				  ;
	xor	ah,ah					  ;
  kr_exit:						  ;
	pop	edx ecx 				  ;
	ret						  ;

;=======================================================  ;
; kb_write.                                               ;
;=======================================================  ;  
kb_write:						  ;
	push	ecx edx 				  ;
	mov	dl,al					  ;
	mov	ecx,0xffff				  ;
  kw_loop1:						  ;                  
	in	al,0x64 				  ;
	test	al,0x20 				  ;
	jz	kw_ok1					  ;
	loop	kw_loop1				  ;
	mov	ah,1					  ;
	jmp	kw_exit 				  ;
  kw_ok1:						  ;
	in	al,0x60 				  ;
	mov	ecx,0xffff				  ;
  kw_loop:						  ;
	in	al,0x64 				  ;
	test	al,2					  ;
	jz	kw_ok					  ;
	loop	kw_loop 				  ;
	mov	ah,1					  ;
	jmp	kw_exit 				  ;
  kw_ok:						  ;
	mov	al,dl					  ;
	out	0x60,al 				  ;
	mov	ecx,0xffff				  ;
  kw_loop3:						  ;
	in	al,0x64 				  ;
	test	al,2					  ;
	jz	kw_ok3					  ;
	loop	kw_loop3				  ;
	mov	ah,1					  ;
	jmp	kw_exit 				  ;
  kw_ok3:						  ;
	mov	ah,8					  ;
  kw_loop4:						  ;
	mov	ecx,0xffff				  ;
  kw_loop5:						  ;
	in	al,0x64 				  ;
	test	al,1					  ;
	jnz	kw_ok4					  ;
	loop	kw_loop5				  ;
	dec	ah					  ;
	jnz	kw_loop4				  ;
  kw_ok4:						  ;
	xor	ah,ah					  ;
  kw_exit:						  ;
	pop	edx ecx 				  ;
	ret						  ;

;=======================================================  ;
; kb_cmd.                                                 ;
;=======================================================  ;  
kb_cmd: 						  ;
	mov	ecx,0xffff				  ;
  c_wait:						  ;
	in	al,0x64 				  ;
	test	al,2					  ;
	jz	c_send					  ;
	loop	c_wait					  ;
	jmp	c_error 				  ;
  c_send:						  ;
	mov	al,bl					  ;
	out	0x64,al 				  ;
	mov	ecx,0xffff				  ;
  c_accept:						  ;
	in	al,0x64 				  ;
	test	al,2					  ;
	jz	c_ok					  ;
	loop	c_accept				  ;
  c_error:						  ;
	mov	ah,1					  ;
	jmp	c_exit					  ;
  c_ok: 						  ;
	xor	ah,ah					  ;
  c_exit:						  ;
	ret						  ;

;=======================================================  ;
; setmouse.                                               ;
; set mousepicture -pointer                               ;
; ps2 mouse enable                                        ;
;=======================================================  ;  
setmouse:						  ;
	cli						  ;
	mov	bl,0xa8 				  ; enable mouse cmd
	call	kb_cmd					  ;
	call	kb_read 				  ; read status
							  ;
	mov	bl,0x20 				  ; get command byte
	call	kb_cmd					  ;
	call	kb_read 				  ;
	or	al,3					  ; enable interrupt
	mov	bl,0x60 				  ; write command
	push	eax					  ;
	call	kb_cmd					  ;
	pop	eax					  ;
	call	kb_write				  ;
							  ;
	mov	bl,0xd4 				  ; for mouse
	call	kb_cmd					  ;
	mov	al,0xf4 				  ; enable mouse device
	call	kb_write				  ;
	call	kb_read 				  ; read status return
	mov	[PS2Mouse],1				  ;
	ret						  ;