;=========================================================;
; FunctinPM                                    01/04/2011 ;
;---------------------------------------------------------;
;                                                         ;
; (c) Craig Bamford, All rights reserved.                 ;
;=========================================================;

RunCommandSectorsCount dd  0				  ;
NameOfFileToLoadFat    dd  0				  ;
FileSizeInByteS        dd  0                              ;
ErrorRunCommand        dw  0                              ;
ErrorWriteFileFat      dw  0                              ;
;=======================================================  ;
;  RunCommand                                             ;
;=======================================================  ; 
RunCommand:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;             
	mov	ds,ax					  ;     
	mov	es,ax					  ;
	mov	dword[NameOfFileToLoadFat],edi		  ;
	call	ConvertFileNameFat			  ;
	mov	edi,ConvertedNameOfFile 		  ;
	call	UpperCase				  ;
	cmp	byte[BootDrive],'C'			  ;
	je	Fat16Hdd				  ;
	cmp	byte[BootDrive],'A'			  ;
	jne	RunCommandError 			  ;
	call	RunCommand12				  ;
	jc	RunCommandError 			  ;
	jmp	RunCommandExit				  ;
Fat16Hdd:						  ;
	call	RunCommand16				  ;
	jc	RunCommandError 			  ;
;=======================================================  ;
;  Exit OK                                                ;
;=======================================================  ; 
RunCommandExit: 					  ;
	mov	[RunCommandSectorsCount],ebx		  ;
	mov	[FileSizeInByteS],ecx                     ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ebx,[RunCommandSectorsCount]		  ;
	mov	ecx,[FileSizeInByteS]                     ;
	clc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error                                             ;
;=======================================================  ; 
RunCommandError:					  ;
        cmp     ah,0xfc                                   ; Is it a no file name found error ?
        je      RunCommandErrorNFNF                       ; If so jump over print error code
        mov     word[ErrorRunCommand],ax                  ;
        call    write_hex16			          ;
        mov     al,' '                                    ;
	call    PrintCharCursorPos                        ;
RunCommandErrorNFNF:                                      ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
        mov     ax,word[ErrorRunCommand]                  ;
	stc						  ;
	ret						  ;

WritefileSize	      dd 0				  ;
WriteName	      dd 0				  ;
WriteBufferAddress    dd 0				  ;
;=======================================================  ;
;  WriteFileFat                                           ;
;=======================================================  ; 
WriteFileFat:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	dword[WritefileSize],eax		  ;
	mov	dword[WriteName],esi			  ;
	mov	dword[WriteBufferAddress],edi		  ;
	mov	ax,18h					  ;             
	mov	ds,ax					  ;     
	mov	es,ax					  ;
	mov	esi,dword[WriteName]			  ;
	mov	eax,dword[WritefileSize]		  ;
	mov	edi,dword[WriteBufferAddress]		  ;
	cmp	byte[BootDrive],'C'			  ;
	je	Fat16HddWrite				  ;
	cmp	byte[BootDrive],'A'			  ;
	jne	RunCommandErrorWrite			  ;
	call	WriteCommandFat16			  ;
	jc	RunCommandErrorWrite			  ;
	jmp	RunCommandExitWrite			  ;
Fat16HddWrite:						  ;
	call	WriteCommandFat16			  ;
	jc	RunCommandErrorWrite			  ;
;=======================================================  ;
;  Exit OK                                                ;
;=======================================================  ; 
RunCommandExitWrite:					  ;
	mov	dword[FatUpDateY_N],0			  ;
	mov	[RunCommandSectorsCount],ebx		  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ebx,[RunCommandSectorsCount]		  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
;  Exit Error                                             ;
;=======================================================  ; 
RunCommandErrorWrite:                                     ;
        mov     word[ErrorWriteFileFat],ax                ;
        call    write_hex16			          ;
        mov     al,' '                                    ;
	call    PrintCharCursorPos                        ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
        mov     ax,word[ErrorWriteFileFat]                ;
	stc						  ;
	ret						  ;

;=======================================================  ;
;  ConvertFileNameFat                                     ;
;=======================================================  ; 
ConvertFileNameFat:					  ; 
	pushad						  ; 
	mov	esi,[NameOfFileToLoadFat]		  ; 
	mov	edi,ConvertedNameOfFile 		  ; 
	mov	ecx,8					  ; 
ConvertCliFileNameUFat: 				  ; 
	cmp	byte [ds:esi],'.'			  ; 
	je	@f					  ; 
	cld						  ; 
	movsb						  ; 
	dec	ecx					  ; 
	jnz	ConvertCliFileNameUFat			  ; 
	jmp	FinConertCliFnameUFat			  ; 
@@:							  ;  
	mov	al,0x20 				  ; 
	cld						  ; 
	rep	stosb					  ; 
FinConertCliFnameUFat:					  ; 
	cmp	byte [ds:esi],'.'			  ; 
	jne	@f					  ; 
	inc	esi					  ; 
@@:							  ; 
	mov	ecx,3					  ; 
	cld						  ; 
	rep	movsb					  ; 
	mov	al,0					  ; 
	stosb						  ; 
	popad						  ; 
	ret						  ; 

DorReg = 0x3f2						  ; 
MotorOn db 0						  ;
;=======================================================  ;
;  Fdd motor off    (TURNS MOTOR OFF WITH DELAY.)         ;
;=======================================================  ; 
Fdd_motor_off:						  ;
	push	edx					  ;
	push	eax					  ;
	mov	dx,DorReg				  ;                     
	mov	al,0					  ;
	out	dx,al					  ;
	mov	[MotorOn],0				  ;
	pop	eax					  ;
	pop	edx					  ;                  
	ret						  ;

;=======================================================  ;
;  Wait Key Pressed   wait's for any key to bepressed.    ;
;=======================================================  ; 
WaitForKeyPress:					  ;
	mov	[WaitKPressed],0			  ;
@@:							  ;
	hlt						  ;
	cmp	[WaitKPressed],1			  ;
	jne	@b					  ;
	mov	[WaitKPressed],0			  ;
	ret						  ;

;=======================================================  ;
;  WaitKeyPressed INT46      wait's key to bepressed.     ;
;=======================================================  ; 
WaitForKeyPressInt46OOH:				  ;
@@:							  ;
	call	WaitForKeyPress 			  ;
	cmp	[keybuffer],-1				  ;
	je	@b					  ;
	mov	al,[keybuffer]				  ;
	mov	ah,[ScanCode]				  ;
	mov	byte[KeyCode],al			  ;
	mov	[keybuffer],0				  ;
	mov	[ScanCode],0				  ;
	ret						  ;

;=======================================================  ;
; KeyPressedNoWait.                                       ;
;=======================================================  ; 
KeyPressedNoWait:					  ;
	cmp	[WaitKPressed],1			  ;
	je	YkeyExit				  ;
  NkeyExit:						  ;
	mov	byte[KeyCode],0 			  ;
	xor	ax,ax					  ;
	ret						  ;
  YkeyExit:						  ;
	xor	ax,ax					  ;
	mov	byte[KeyCode],1 			  ;
	mov	al,byte[KeyCode]			  ;
	mov	[WaitKPressed],0			  ;
	ret						  ;

;=======================================================  ;
; Conventional Memory   ;puts conmemory in kb in eax      ;
;=======================================================  ; 
ConventionalMemory:					  ;
	mov	eax,dword[ConvMemorySize]		  ;
	ret						  ;

;=======================================================  ;
; ExtMemory       ;puts extended memory in kb in eax      ;
;=======================================================  ; 
ExtMemory:						  ;
       mov	eax,dword[ExtMemorySize]		  ;
       mov	ebx,dword[TotalMemoryMB]		  ;
       cmp	eax,0					  ;
       jne	@f					  ;
       stc						  ;
@@:							  ;
       ret						  ;

;=======================================================  ;
; SetTimer.                 delay for a number of ms      ;
;=======================================================  ; 
SetTimer:						  ;
	cmp	ax,0					  ;
	jbe	Time2Exit				  ;
	mov	word[Timer],ax				  ;
	mov	[TimerOn],1				  ;       
	call	Wait_Timer				  ;
Time2Exit:						  ;
	ret						  ;

;=======================================================  ;
; Wait Timer.            ;waits for timer to finish.      ;
;=======================================================  ; 
Wait_Timer:						  ;
	push	eax					  ;
Wait_Timer_Loop:					  ;
	mov	al,[TimerOn]				  ;
	or	al,al					  ;
	jnz	Wait_Timer_Loop 			  ;
	pop	eax					  ;
	ret						  ;

;=======================================================  ;
; TimerNoWait.                                            ;
;=======================================================  ; 
TimerNoWait:						  ;
	cmp	ax,0					  ;
	je	@f					  ;
	mov	word[TimerNw],ax			  ;
	mov	[TimerOnNw],1				  ;
@@:							  ;
	mov	al,[TimerOnNw]				  ;
	or	al,al					  ;
	jnz	NotReadyYet				  ;
	mov	al,0					  ;
	ret						  ;
;=======================================================  ;
; NotReadyYet.                                            ;
;=======================================================  ; 
NotReadyYet:						  ;
	mov	al,1					  ;
	ret						  ;

;=======================================================  ;
; DetectPciBus1           ;Detect if Pci bus present      ;
;=======================================================  ; 
DetectPciBus1:						  ;
       clc						  ;
       cmp	byte[PciBusPresent],1			  ;
       je	@f					  ;
       stc						  ;
@@:							  ;
       ret						  ;

;=======================================================  ;
; ProgramInterruptTimer.                                  ;
;=======================================================  ; 
InterruptTimer: 					  ;
	pushad						  ;
	mov	[DivNumber],cx				  ;
	cmp	[DivNumber],0				  ;
	jne	IntTimerNot0				  ;
	mov	[ClockTiKs],18				  ;
	jmp	@f					  ;
  IntTimerNot0: 					  ;
	mov	dx,0x0012				  ;
	cmp	dx,[DivNumber]				  ;
	jnb	ExitPitError				  ;
	mov	ax,0x34dd				  ;
	mov	cx,[DivNumber]				  ;
	mov	[ClockTiKs],cx				  ;
	div	cx					  ;
	mov	[DivNumber],ax				  ;
  @@:							  ;
	cli						  ;
	mov	al,00110100b				  ;
	mov	dx,0x43 				  ;
	out	dx,al					  ;
	mov	ax,[DivNumber]				  ;
	mov	dx,0x40 				  ;
	out	dx,al					  ;
	mov	al,ah					  ;
	out	dx,al					  ;
	sti						  ;
	popad						  ;
	ret						  ;
;=======================================================  ;
; Exit Error                                              ;
;=======================================================  ; 
ExitPitError:						  ;
	popad						  ;
	mov	al,1					  ;
	ret						  ;

;=======================================================  ;
; LoadVesaInfo.                                           ;
;=======================================================  ; 
LoadVesaInfo:						  ;
	mov	esi,VESA_Info				  ;
	mov	dword[EsiPointer],esi			  ;
	ret						  ;

;=======================================================  ;
; GameKeyBoardOn.                                         ;
;=======================================================  ; 
GameKeyBoardOn2:					  ;
	mov	[GameKeyBoardOn],1			  ;
	mov	esi,KeyDown				  ;
	ret						  ;

;=======================================================  ;
; GameKeyBoardOff.                                        ;
;=======================================================  ; 
GameKeyBoardOff:					  ;
	pushad						  ;
	push	es					  ;
	mov	ax,18h					  ;
	mov	es,ax					  ;
	mov	[GameKeyBoardOn],0			  ;
	mov	edi,KeyDown				  ;
	mov	al,0					  ;
	mov	cx,128					  ;
	rep	stosb					  ;
	pop	es					  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
; GetTime.                                                ;
;=======================================================  ; 
GetTime:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;                             
	mov	es,ax					  ;
	call	time					  ;
	xor	eax,eax 				  ;
	mov	al,[hour]				  ;
	shl	eax,16					  ;
	mov	ch,[minute]				  ;
	mov	cl,[second]				  ;
	mov	ax,cx					  ;
	mov	[TimeVar],eax				  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	eax,[TimeVar]				  ;
	ret						  ;

;=======================================================  ;
; GetDate.                                                ;
;=======================================================  ; 
GetDate:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;             
	mov	es,ax					  ;
	call	date					  ;
	xor	eax,eax 				  ;
	mov	ah,[century]				  ;
	mov	al,[year]				  ;
	shl	eax,16					  ;
	mov	ch,[month]				  ;
	mov	cl,[day]				  ;
	mov	ax,cx					  ;
	mov	[DateVar],eax				  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	eax,[DateVar]				  ;
	ret						  ;

;=======================================================  ;
; GetClockTicks                                           ;
;=======================================================  ;
GetClockTicks:						  ;
	cmp	ecx,1					  ;
	jne	GetTimePast				  ;
	mov	[TimerProgOn],1 			  ;
	mov	[TimerProg],0				  ;
	ret						  ;
  GetTimePast:						  ;
	mov	[TimerProgOn],0 			  ;
	mov	eax,[TimerProg] 			  ;
	ret						  ;

;=======================================================  ;
; ModService.                                             ;
;=======================================================  ;
ModService:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;                     
	mov	es,ax					  ;
	mov	[ModServiceErrorCode],1 		  ;
	mov	[ModID123],esi				  ;
	mov	ebx,[ModListNumbers]			  ;
	cmp	ebx,1					  ;
	jbe	ModServiceError 			  ;
	mov	edi,ModListStruct			  ;
	add	edi,32					  ;
	mov	esi,[ModID123]				  ;
	dec	ebx					  ;
  MachModIDLoop1:					  ;
	mov	ecx,8					  ;
	call	CompearString				  ;
	jnc	FoundMod				  ;
	add	edi,32					  ;
	dec	ebx					  ;
	cmp	ebx,0					  ;
	jne	MachModIDLoop1				  ;
	jmp	ModServiceError 			  ;
  FoundMod:						  ;
	mov	[ModAddress],edi			  ;
	mov	eax,dword[es:edi+8]			  ;
	mov	[SizeOfModule],eax			  ;
	mov	eax,dword[es:edi+12]			  ;
	mov	[ModLoad],eax				  ;
	mov	eax,dword[es:edi+16]			  ;
	mov	[ModunLoad],eax 			  ;
	mov	eax,dword[es:edi+20]			  ;
	mov	[NumberOfModFunctions],eax		  ;
	mov	eax,dword[es:edi+24]			  ;
	mov	[AbsolModAddress],eax			  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	eax,[ModLoad]				  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
; ModService Error.                                       ;
;=======================================================  ;
ModServiceError:					  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	ah,[ModServiceErrorCode]		  ;
	stc						  ;
	ret						  ;

;=======================================================  ;
; KeyPressedNoWaitScanCodes.                              ;
;=======================================================  ;
KeyPressedNoWaitScanCodes:				  ;
	cmp	[WaitKPressed],1			  ;
	je	YkeyExitScanCodes			  ; 
  NkeyExitScanCodes:					  ;            
	mov	byte[KeyCode],0 			  ;
	xor	ax,ax					  ;
	ret						  ;
YkeyExitScanCodes:					  ;
	mov	[WaitKPressed],0			  ;
	xor	ax,ax					  ;
	cmp	[keybuffer],-1				  ;
	je	NkeyExitScanCodes			  ;
	mov	al,[keybuffer]				  ;
	mov	ah,[ScanCode]				  ;
	mov	[keybuffer],0				  ;
	mov	[ScanCode],0				  ;
	ret						  ;

;=======================================================  ;
; Get the load address add on.                            ;
;=======================================================  ;
GetBaseAddOn:						  ;
	mov	eax,[BaseAddOn] 			  ;
	ret						  ;

;=======================================================  ;
; CountTicks.                                             ;
;=======================================================  ;
CountTicks:						  ;
	cmp	[Tick18],1				  ;
	jne	Waiting4tick				  ;
	mov	[Tick18],0				  ;
	stc						  ;
	ret						  ;
Waiting4tick:						  ;
	clc						  ;
	ret						  ;

;=======================================================  ;
; TimerSecondCount.                                       ;
;=======================================================  ;
TimerSecondCount:					  ;
	mov	eax,[NumberOfTicks]			  ;
	ret						  ;

;=======================================================  ;
; Top of memory                                           ;
;=======================================================  ;
TopOfMemory:						  ;
	mov	eax,dword[TopOfFreeMemoryWithBase]	  ;
	ret						  ;

;=======================================================  ;
; Gets the Dma floppy buffers address                     ;
;=======================================================  ;
GetDMAbufferaddress:					  ;
	mov	esi,OffsetDma2Buffer			  ; Read
	mov	edi,OffsetDma2Buffer1			  ; write
	ret						  ;

;=======================================================  ;
; KeyBoardLanguage.                                       ;
;-------------------------------------------------------  ;
; Return:                                                 ;
;        EAX = 'KEYB'                                     ;
;        EDI = Pointer to keyMap                          ;
;                                                         ;
;        KeyMap size = 1024 bytes                         ;
;=======================================================  ;
KeyBoardLanguage:					  ;
	mov	edi,normal_keymap			  ;
	mov	eax,'KEYB'				  ;
	ret						  ;

;=======================================================  ;
; Get Boot Drive.                                         ;
;=======================================================  ;
Get_Boot_Drive: 					  ;
	mov	al,byte[BootDrive]			  ;
	ret						  ;

;=======================================================  ;
; Get Params.                                             ;
;=======================================================  ;
GetParams:						  ;
	mov    esi,CommandBuffer2NEW			  ;
	ret						  ;

;=======================================================  ;
; Any Fat Update ?.                                       ;
;=======================================================  ;
AnyFatUpdate:						  ;
	mov     eax,dword[FatUpDateY_N]			  ;
	mov     dword[FatUpDateY_N],1			  ;
	ret                                               ;

;=======================================================  ;
; ReMountFdd.                                             ;
;=======================================================  ;
ReMountFdd:                                               ;
        mov     [count],0				  ;
        ret                                               ;

;=======================================================  ;
; Empty Function.                                         ;
;=======================================================  ;
Play_cd:						  ;                        
Stop_cd:						  ;          
Eject_cd:						  ;  
Close_cd:						  ;
RebootSystem:						  ;
ExitDOS:						  ;
Pause_cd:						  ;
PlayAllTracks:						  ;
PlayTrack:						  ;         
WaitUnitReadyNoWait:					  ;     
ReadSubChannal: 					  ;    
TrackInFo:						  ;
;=======================================================  ;
; Empty Function.                                         ;
;=======================================================  ;
EmptyFunction:						  ;
	nop						  ;
	call	WaitForKeyPressInt46OOH 		  ;
	ret						  ;

;=======================================================  ;
; Data.                                                   ;
;=======================================================  ;
;CXbackup            dw 0                                 ;
EDXbackup	     dd 0				  ;
ModServiceErrorCode  db 0				  ;
ModServiceTable1     dd 0				  ;
NumberOfModFunctions dd 0				  ;
ModLoad 	     dd 0				  ;
ModunLoad	     dd 0				  ;
AbsolModAddress      dd 0				  ;
ModAddress	     dd 0				  ;
ModID123	     dd 0				  ;
ModfunctionN	     db 0				  ;
SizeOfModule	     dd 0				  ;
ClockTiKs	     dw 18				  ;
TimerBU 	     dw 0				  ;
TimeVar 	     dd 0				  ;
DateVar 	     dd 0				  ;
KeyCode 	     db 0				  ;
DivNumber	     dw 0				  ;
TempStore	     dd 0				  ;
FatUpDateY_N	     dd 0                                 ;
ConvertedNameOfFile  rb 16				  ; 
