;=========================================================;
; Command                                      01/05/2011 ;
;---------------------------------------------------------;
;                                                         ;
; (c) Craig Bamford, All rights reserved.                 ;
;=========================================================;

;=======================================================  ;
;  Ready prompt                                           ;
;=======================================================  ; 
ReadyPrompt:						  ;
	call	SetPalette				  ;
	call	[GetBootDrive]				  ;
	mov	byte[PromptLetter],al			  ;
	mov	[textcolor],0x07			  ;
	mov	al,0x07 				  ;
	call	[TextColor]				  ;
	mov	esi,StartMsg				  ;
	call	[PrintString_$] 			  ;
	ret						  ;

;=======================================================  ;
;  Ready prompt                                           ;
;=======================================================  ; 
Prompt: 						  ;
	pushad						  ;
	mov	al,[textcolor]				  ;
	mov	[textcolorsave],al			  ;
	mov	[textcolor],0x09			  ;
	mov	al,0x09 				  ;
	call	[TextColor]				  ;
	cmp	[PromptLetter],'A'			  ;
	jne	@f					  ;
	mov	esi,Aprompt				  ;
	call	[PrintString_$] 			  ;
	jmp	ItsTheAdir				  ;
@@:							  ;
	mov	esi,Cprompt				  ;
	call	[PrintString_$] 			  ;
ItsTheAdir:						  ;
	mov	esi,promptEnd				  ;
	call	[PrintString_$] 			  ;
	mov	al,[textcolorsave]			  ;
	mov	[textcolor],al				  ;
	call	[TextColor]				  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
;  print_time1                                            ;
;=======================================================  ; 
print_time1:						  ;
	pushad						  ;
	call	 [print_time]				  ;
	popad						  ;
	ret						  ; 
   
;=======================================================  ;
;  print_date1                                            ;
;=======================================================  ; 
print_date1:						  ;
	pushad						  ;
	call	 [print_date]				  ;
	popad						  ;
	ret						  ;

GetListBufferAddress	 dd 0				  ;
GetListFile_Count	 dd 0				  ;
GetListBufferAddrAddOn	 dd 0				  ;
ListSet 		 db 0				  ;
;=======================================================  ;
;  DirFunction                                            ;
;=======================================================  ; 
DirFunction:						  ; 
	pushad						  ;
	mov	dword[GetListBufferAddrAddOn],0 	  ;
        call    [AnyFatUpdate]                            ;
	cmp	eax,0 			                  ;
	jne	ListAsBeenSet				  ;
	call	GetList 				  ;
	jc	DirFunctionExitError			  ;
	mov	dword[GetListBufferAddress],esi 	  ;
	mov	dword[GetListFile_Count],ebx		  ;
ListAsBeenSet:						  ;
	mov	esi,DirString				  ;
	call	[PrintString_$] 			  ;
	mov	al,[textcolor]				  ;
	mov	[textcolorsave],al			  ;
	mov	[textcolor],0x02			  ;
	mov	al,0x02 				  ;
	call	[TextColor]				  ;
	mov	esi,ListBuffer				  ;
	mov	ecx,dword[GetListFile_Count]		  ;
	cmp	ecx,0					  ;
	je	NoDexFILEfound				  ;
MainListLoop:						  ;
	pushad						  ;
	call	[PrintString_0] 			  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	popad						  ;
	add	esi,15					  ;
	loop	MainListLoop				  ;
	mov	al,[textcolorsave]			  ;
	mov	[textcolor],al				  ;
	call	[TextColor]				  ;
;=======================================================  ;
; DirFunctionExitOK                                       ;
;=======================================================  ; 
DirFunctionExitOK:					  ;
	popad						  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
; NoDexFILEfound.                                         ;
;=======================================================  ; 
NoDexFILEfound: 					  ;
	mov	esi,NoDexFMessage			  ;
	call	[PrintString_0] 			  ;
	mov	al,[textcolorsave]			  ;
	mov	[textcolor],al				  ;
	call	[TextColor]				  ;
	popad						  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
; DirFunctionExitError                                    ;
;=======================================================  ; 
DirFunctionExitError:					  ;
	popad						  ;
	stc						  ;
	ret						  ;

ImageLoadAddrVar  = 0x400000				  ;
;=======================================================  ;
;  RunExeCommand                                          ;
;=======================================================  ; 
RunExeCommand:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;     
	mov	es,ax					  ;
;=======================================================  ;
;  Clear buffer 1                                         ;
;=======================================================  ; 
	mov	al,' '					  ;
	mov	ecx,64					  ;
	mov	edi,TempBuff1				  ;
	rep	stosb					  ;
;=======================================================  ;
;  Convert file name                                      ;
;=======================================================  ; 
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	edi,TempBuff1				  ;
	mov	ecx,60					  ; 
SetExtLoop:						  ;
	lodsb						  ;
	cmp	al,'.'					  ;
	je	extOK2					  ;
	cmp	al,' '					  ;
	je	extOK1					  ;
	cmp	al,0					  ;
	je	extOK1					  ;
	stosb						  ;
	loop	SetExtLoop				  ;
;=======================================================  ;
;  add file ext.                                          ;
;=======================================================  ; 
  extOK1:						  ;
	mov	al,'.'					  ;
	stosb						  ;
	mov	al,'D'					  ;
	stosb						  ;
	mov	al,'E'					  ;
	stosb						  ;
	mov	al,'X'					  ;
	stosb						  ;
	mov	al,0					  ;
	stosb						  ;
	jmp	TryOpenFile				  ;
  extOK2:						  ;
	stosb						  ;
	mov	ecx,3					  ;
	rep	movsb					  ;
	mov	al,0					  ;
	stosb						  ;
;=======================================================  ;
;  Try to open file.                                      ;
;=======================================================  ; 
TryOpenFile:						  ; 
	mov	edi,TempBuff1				  ;
	mov	edx,ImageLoadAddrVar			  ;
	call	[ReadFileFat]				  ;
	jc	RunExeCommandExitError			  ;
	mov	esi,ImageLoadAddrVar			  ;
	add	esi,2					  ;
	cmp	dword[ds:esi],'DEX5'			  ;
	je	ItsaDexProg				  ;
	add	esi,3					  ;
	cmp	dword[ds:esi],'DEX5'			  ;
	jne	NotaDexProg				  ;
ItsaDexProg:						  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;
	mov	es,ax					  ;
	xor	eax,eax 				  ;
	mov	ebx,eax 				  ;
	mov	ecx,eax 				  ;
	mov	edx,eax 				  ;
	mov	esi,eax 				  ;
	mov	edi,eax 				  ;
	call	ImageLoadAddrVar			  ;                                    
	mov	ax,18h					  ;                             
	mov	ds,ax					  ;
	mov	es,ax					  ;
	xor	eax,eax 				  ;
	mov	ebx,eax 				  ;
	mov	ecx,eax 				  ;
	mov	edx,eax 				  ;
	mov	esi,eax 				  ;
	mov	edi,eax 				  ;
	call	SetPalette				  ;            
;=======================================================  ;
; RunExeCommandExitOK                                     ;
;=======================================================  ;
RunExeCommandExitOK:					  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	clc						  ; 
	ret						  ;
;=======================================================  ;
; NotaDexProg                                             ;
;=======================================================  ;
NotaDexProg:						  ;
	mov	esi,NotADexProg 			  ;
	call	[PrintString_$] 			  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	clc						  ; 
	ret						  ;
;=======================================================  ;
; RunExeCommandExitError                                  ;
;=======================================================  ;
RunExeCommandExitError: 				  ;
	pop    ds					  ;
	pop    es					  ;    
	popad						  ;
	stc						  ;
	ret						  ;

DefaultListNumber = 1024				  ;
File_Count	  dd 0					  ;
;=======================================================  ;
;  GetList.                                               ;
;=======================================================  ;
GetList:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;
	mov	es,ax					  ;
	mov	edi,ListBuffer				  ;
	mov	ecx,15*DefaultListNumber		  ;
	mov	al,0					  ;
	rep	stosb					  ;
	mov	ecx,DefaultListNumber			  ;
	mov	edi,ListBuffer				  ;
	xor	eax,eax 				  ;
	mov	ax,'DE' 				  ; just load dex files (0 for all files)
	call	[DirFileList]				  ;
	jc	GetListError				  ;
;=======================================================  ;
; GetListExitOK                                           ;
;=======================================================  ;
	mov	dword[File_Count],ecx			  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	mov	esi,ListBuffer				  ;
	mov	edi,ListBuffer				  ;
	mov	ebx,dword[File_Count]			  ;
	clc						  ;
	ret						  ;
;=======================================================  ;
; GetListExitError                                        ;
;=======================================================  ;
GetListError:						  ;
	pop	ds					  ;
	pop	es					  ;
	popad						  ;
	stc						  ;
	ret						  ;

;=======================================================  ;
; RenDirFile                                              ;
;=======================================================  ;
RenDirFile:						  ;
	pushad						  ;
	push	es					  ;
	push	ds					  ;
	mov	ax,18h   				  ;     
	mov	es,ax					  ;
	mov	al,' '					  ;
	mov	ecx,64					  ;
	mov	edi,TempBuff1a				  ;
	rep	stosb					  ;
	mov	al,' '					  ;
	mov	ecx,64					  ;
	mov	edi,TempBuff2a				  ;
	rep	stosb					  ;
	mov	esi,dword[CommandBufferAddress]		  ;
        add     esi,4
	mov	edi,TempBuff1a				  ;
	mov	ecx,64					  ;
  RenDirFileLoop1:					  ;
	lodsb						  ;
	cmp	al,' '					  ;
	je	FillBuffer2				  ;
	stosb						  ;
	loop	RenDirFileLoop1 			  ;
  FillBuffer2:						  ;
	mov	al,0					  ;
	stosb						  ;
	mov	edi,TempBuff2a				  ;
	mov	ecx,64					  ;
  RenDirFileLoop2:					  ;
	lodsb						  ;
	cmp	al,0					  ;
	je	Buff2Filled				  ;
	stosb						  ;
	loop	RenDirFileLoop2 			  ;
	mov	al,0					  ;
  Buff2Filled:						  ;
	stosb						  ;
	mov	esi,TempBuff1a				  ;
	mov	edi,TempBuff2a				  ;
	call	[ReNameFile] 				  ;
	jc	RenDirFileError 			  ;
  RenDirFileOk: 					  ;
	pop    ds					  ;
	pop    es					  ;
	popad						  ;
	clc						  ;
	ret						  ;
							  ;
  RenDirFileError:					  ;
	mov    word[RNFErrorCode],ax			  ; save ax error code
	pop    ds					  ;
	pop    es					  ;
	popad						  ;
	mov    ax,word[RNFErrorCode]			  ; save ax error code
	stc						  ;
	ret						  ;


;=======================================================  ;
; PALETTE.                                                ;
;=======================================================  ;
Palette:						  ;
	pushad						  ;
	mov	dx,3c8h 				  ;                      
	out	dx,al					  ;
	inc	dx					  ;             
	mov	al,bl					  ;                              
	out	dx,al					  ;
	mov	al,bh					  ;                      
	out	dx,al					  ;
	mov	al,cl					  ;                              
	out	dx,al					  ;
	popad						  ;
	ret						  ;

;=======================================================  ;
; SetPalette                                              ;
;=======================================================  ;
SetPalette:						  ;
	mov	al,2					  ;
	mov	bx,0x3f3f				  ;
	mov	cl,43					  ;
	call	Palette 				  ;                         
	mov	al,4					  ;
	mov	cl,63					  ;
	call	Palette 				  ;                           
	mov	al,5					  ;
	mov	bx,0x3228				  ;
	call	Palette 				  ;                            
	mov	al,7					  ;
	call	Palette 				  ;                    
	mov	al,5					  ;
	mov	bx,0x0032				  ;
	mov	cl,0					  ;
	call	Palette 				  ;
	mov	al,58					  ;
	mov	bx,0x0A00				  ;
	call	Palette 				  ;
	inc	al					  ;
	mov	bh,40					  ;
	call	Palette 				  ;
	mov	al,56					  ;
	mov	bx,0x1010				  ;
	mov	cl,32					  ;
	call	Palette 				  ;
	mov	al,60					  ;
	mov	bx,0x1818				  ;
	mov	cl,48					  ;
	call	Palette 				  ;
	ret						  ;

;=======================================================  ;
; Data.                                                   ;
;=======================================================  ;
RNFErrorCode  dw 0
textcolor     db 0					  ;
textcolorsave db 0					  ;
                                                          ;
DelErrorMes   db 'Error deleting file.',13,10,0           ;
                                                          ;
RenErrorMes   db 'Error renaming file.',13,10,0           ;
                                                          ;
DelMessage1   db 'Are you sure you want delete ','$'      ;
DelMessage2   db ' Y/N ?.',13,10,'$'                      ;
							  ;
NoDexFMessage db 'No .dex files found on drive.',13,10,0  ;                                                         ;
NotADexProg   db 'Not a valid DexOS program',13,10,'$'	  ;
							  ;
DirString     db 13,10,'Root dir of '			  ;
PromptLetter  db 0					  ;
PromptNL      db  ':\',13,10,'$'			  ;
							  ;
Aprompt       db 'A:\$' 				  ;
Cprompt       db 'C:\$' 				  ;
promptEnd     db '>$'					  ;
							  ;
TempBuff1a:   db 68 dup(' ')			          ;
	      db 0 				          ;
                                                          ;
TempBuff2a:   db 64 dup(' ')			          ;
	      db 0 				          ;
                                                          ;
TempBuff1:    db 68 dup(' ')				  ;
	      db 0					  ;
