;=========================================================;
; Command                                      12/01/2011 ;
;---------------------------------------------------------;
; Checks for command.                                     ;
;                                                         ;
; (c) Craig Bamford, All rights reserved.                 ;
;=========================================================;
use32
	ORG	0x3e00000				  ;
	jmp	start					  ;
	db	'DEX4'					  ;
;=======================================================  ;
;  Start.                                                 ;
;=======================================================  ; 
start:							  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;
	mov	es,ax					  ;
;=======================================================  ;
; Get calltable address.                                  ;
;=======================================================  ;
	mov	edi,Functions				  ; fill the function table
	mov	al,0					  ; so we have some usefull functions
	mov	ah,0x0a 				  ;
	int	50h					  ;
;=======================================================  ;
;  Command.                                               ;
;=======================================================  ; 
StartCommand:						  ;
	mov	byte[GuiVer],0				  ;
	call	[Clstext]				  ;
	call	ReadyPrompt				  ;
  DisplayPrompt:					  ;
	call	Prompt					  ;
	xor	ecx,ecx 				  ;
	xor	edx,edx 				  ;
  CheckForKey:						  ;
	call	GetCommand				  ;
	call	ProcessCmd				  ;
	cmp	byte[GuiVer],1				  ;
	je	Return2GUI				  ;
	jmp	CheckForKey				  ;
Return2GUI:						  ;
	ret
;=======================================================  ;
; Process Command.                                        ;
;=======================================================  ;
ProcessCmd:						  ;
	pushad						  ;
	push	es					  ;
	mov	ax,18h					  ;
	mov	es,ax					  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	mov	edi,dword[CommandBufferAddress] 	  ;
	call	[UpperCase]				  ;
;=======================================================  ;
;  CLS.                                                   ;                 
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,4					  ;
	mov	edi,cCLS				  ;
	repe	cmpsb					  ;
	jne	not_cls 				  ;
	call	[Clstext]				  ;
	jmp	ExitFoundCls				  ;
  not_cls:						  ;
;=======================================================  ;
;  TIME.                                                  ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,5					  ;     
	mov	edi,cTIME				  ;
	repe	cmpsb					  ;
	jne	not_time				  ;
	call	print_time1				  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	jmp	ExitFound				  ;
  not_time:						  ;
;=======================================================  ;
;  DATE.                                                  ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,5					  ;     
	mov	edi,cDATE				  ;
	repe	cmpsb					  ;
	jne	not_date				  ;
	call	print_date1				  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	jmp	ExitFound				  ;
  not_date:						  ;
;=======================================================  ;
;  HELP.                                                  ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,5					  ;     
	mov	edi,cHELP				  ;
	repe	cmpsb					  ;
	jne	not_help				  ;
	mov	esi,HelpMsg				  ;
	call	[PrintString_$] 			  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	jmp	ExitFound				  ;
  not_help:						  ;
;=======================================================  ;
;  DIR.                                                   ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,4					  ;     
	mov	edi,cDIR				  ;
	repe	cmpsb					  ;
	jne	not_dir 				  ;
  YesDirFunction:					  ;
	call	DirFunction				  ;
	jc	ExitNotFound				  ;
	jmp	ExitFound				  ;
  not_dir:						  ;
;=======================================================  ;
; Del.                                                    ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,4					  ;            
	mov	edi,cDEL				  ;
	repe	cmpsb					  ;
	jne	not_del 				  ;
	mov	esi,DelMessage1 			  ;
	call	[PrintString_$] 			  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	add	esi,4					  ;
	call	[PrintString_0] 			  ;
	mov	esi,DelMessage2 			  ;
	call	[PrintString_$] 			  ;
  DelMessageLoop:					  ;       
	call	[WaitForKeyPress]			  ;
	cmp	al,'y'					  ;
	je	DoDeleteFile				  ;
	cmp	al,'Y'					  ;
	je	DoDeleteFile				  ;
	cmp	al,'n'					  ;
	je	ExitFound				  ;
	cmp	al,'N'					  ;
	je	ExitFound				  ;
	jmp	DelMessageLoop				  ;
  DoDeleteFile: 					  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	add	esi,4					  ;
	mov	al,0					  ;
	call	[DeleteFile]				  ;
	jnc	ExitFound				  ;
	mov	esi,DelErrorMes 			  ;
	call	[PrintString_0] 			  ;
	jmp	ExitFound				  ;
  not_del:						  ;
;=======================================================  ;
;  REN.                                                   ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,4					  ;     
	mov	edi,cREN				  ;
	repe	cmpsb					  ;
	jne	not_ren 				  ;
	call	RenDirFile				  ;
	jnc	ExitFound				  ;
	mov	esi,RenErrorMes 			  ;
	call	[PrintString_0] 			  ;
	jmp	ExitFound				  ;
  not_ren:						  ;
;=======================================================  ;
;  RMF.                                                   ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,3					  ;     
	mov	edi,cRMF				  ;
	repe	cmpsb					  ;
	jne	not_rmf 				  ;
	call	[ReMountFdd]				  ;
	jmp	ExitFound				  ;
  not_rmf:						  ;
;=======================================================  ;
;  VER.                                                   ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,3					  ;     
	mov	edi,cVER				  ;
	repe	cmpsb					  ;
	jne	not_ver 				  ;
	mov	esi,VerMessage				  ;
	call	[PrintString_$] 			  ;
	jmp	ExitFound				  ;
  not_ver:						  ;
;=======================================================  ;
;  GUI.                                                   ;
;=======================================================  ;
	mov	esi,dword[CommandBufferAddress] 	  ;
	mov	cx,3					  ;     
	mov	edi,cGUI				  ;
	repe	cmpsb					  ;
	jne	not_gui 				  ;
	mov	byte[GuiVer],1				  ;
	jmp	ExitFound				  ;
  not_gui:						  ;
;=======================================================  ;
;  Check for EXE.                                         ;
;=======================================================  ;
	call	RunExeCommand				  ;
	jc	ExitNotFound				  ;
	jmp	ExitFound				  ;
;=======================================================  ;
;  Exit no command or file found.                         ;
;=======================================================  ;
  ExitNotFound: 					  ;
	mov	esi,BadCommand				  ;
	call	[PrintString_$] 			  ;
;=======================================================  ;
;  Exit  command or file found.                           ;
;=======================================================  ;
  ExitFound:						  ;
  ExitFoundCls: 					  ;
	mov	esi,nextline				  ;
	call	[PrintString_$] 			  ;
	call	Prompt					  ;
	pop	es					  ;
	popad						  ;
	ret						  ;
;=======================================================  ;
; Get Command.                                            ;
;=======================================================  ;
GetCommand:						  ;
	call	[GetCommandStored]			  ;
	mov	dword[CommandBufferAddress],edi 	  ;
	ret						  ;

;=======================================================  ;
;  Data.                                                  ;
;=======================================================  ;
    craicount	       dw  0				  ;    
    CliBuffcount       dw  0				  ;
    CdCount	       db  0				  ;
    GuiVer	       db  0
    CmdSize = 0x80					  ;
    CommandBuffer:     times  128	db 0		  ;
    CommandBuffer2:    times  128	db 0		  ;
    CommandBufferAddress dd 0				  ;
;=======================================================  ;
; commands.                                               ;
;=======================================================  ;           
    cCLS	       db 'CLS',0			  ;
    cTIME	       db 'TIME',0			  ;
    cDATE	       db 'DATE',0			  ;
    cDIR	       db 'DIR',0			  ;
    cDEL	       db 'DEL ',0			  ;
    cREN	       db 'REN ',0
    cHELP	       db 'HELP',0			  ;
    cVER	       db 'VER',0			  ;
    cRMF	       db 'RMF',0			  ;
    cGUI	       db 'GUI',0			  ;
;=======================================================  ;
; Strings.                                                ;
;=======================================================  ;      
nextline:	       db  13,10,'$'			  ;
BadCommand:	       db 'Bad command or file name',13,10,'$'

StartMsg:	   db 13,10,0xd2,0x09,'DexOS',13,10
		   db '  (',0xd2,0x01,'C',0xd2,0x09,')Copyright Craig Bamford 2001-2012.',0xd2,0x07,13,13,10,'$'

HelpMsg:	   db 13, 10
		   db 'List of supported DexOS commands:                               ', 13, 10  
		   db 0xd2,0x02,' HELP        ',0xd2,0x07,'- Print out this list.                                ', 13, 10  
		   db 0xd2,0x02,' CLS         ',0xd2,0x07,'- Clear the screen.                                   ', 13, 10 
		   db 0xd2,0x02,' TIME        ',0xd2,0x07,'- Displays current time.                              ', 13, 10	
		   db 0xd2,0x02,' DATE        ',0xd2,0x07,'- Displays current date.                              ', 13, 10 
		   db 0xd2,0x02,' VER         ',0xd2,0x07,'- Prints the kernel ver & assembly date.              ', 13, 10  
		   db 0xd2,0x02,' DIR         ',0xd2,0x07,'- List all files on drive.                            ', 13, 10
		   db 0xd2,0x02,' DEL [f]     ',0xd2,0x07,'- Delete the file [f].                                ', 13, 10
		   db 0xd2,0x02,' REN [f] [f] ',0xd2,0x07,'- Rename file [f] to [f].                             ', 13, 10
		   db 0xd2,0x02,' RMF         ',0xd2,0x07,'- Remounts root dir.                                  ', 13, 10
		   db 0xd2,0x02,' GUI         ',0xd2,0x07,'- Returns to the gui.                                 ', 13, 10
		   db 'more to come! $'

;=======================================================  ;
; include.                                                ;
;=======================================================  ;
include 'Commands.inc'					  ;
include 'Ver.inc'					  ;
align 4 						  ;
ListBuffer:				rb  1024*15	  ;
include 'Dex.inc'					  ;

