;=========================================================;
; Screensaver v1.13m                           01/04/2011 ;
;---------------------------------------------------------;
; Crown_s Soft(c) Screensaver v1.13m.                     ;
; www.crown-s-soft.com                                    ;
;                                                         ;
; Converted to DexOS, by Craig Bamford (Dex).             ;
; DexOS V0.05                                             ;                         
;=========================================================;
fullscreen =   1					  ;
n_points   =   0x1800					  ;
delay	   =   2					  ;
speed	   equ 0.004					  ;
format binary as 'gex'					  ;
use32							  ;
	ORG   0x800000					  ; where our program is loaded to
	jmp   start					  ; jump to the start of program.
	db    'DEX4'					  ; We check for this, to make shore it a valid Dex4u file.
;=======================================================  ;
; Include the main file.                                  ;
;=======================================================  ;
include "FIGURESI.INC"					  ;
;=======================================================  ;
; Start of program.                                       ;
;=======================================================  ;
start:							  ;
	mov	ax,18h					  ;
	mov	ds,ax					  ;
	mov	es,ax					  ;
;=======================================================  ;
; Get call table address.                                 ;
;=======================================================  ;
	mov	edi,Functions				  ; fill the function table
	mov	al,0					  ; so we have some usefull functions
	mov	ah,0x0a 				  ;
	int	50h					  ;
;=======================================================  ;
; Load vesa info.                                         ;
;=======================================================  ;
	call	[LoadVesaInfo]				  ;
	mov	edi,VESA_Info				  ;
	mov	ecx,193 				  ;
	cld						  ;
	cli						  ;
	rep	movsd					  ;
	sti						  ;
;=======================================================  ;
; Decode Dif                                              ;
;=======================================================  ;
	mov	esi,file_area_Menu			  ;
	mov	edi,Menu_Buffer 			  ;
	mov	ecx,VesaBuffer				  ;
	mov	ebx,3					  ;
	int	40h					  ;
	jc	ExitError				  ;
;=======================================================  ;
; get menu buffer address                                 ;
;=======================================================  ;
	mov	ebx,1					  ; 
	int	40h					  ;                                       
	mov	dword[MenuBuffer],esi			  ;
;=======================================================  ;
; Move the background image to our buffer                 ;
;=======================================================  ;
	call	MoveBuffer				  ;
;=======================================================  ;
; Draw the main box alpha image                           ;
;=======================================================  ;
	mov	edi,VesaBuffer				  ;
	mov	esi,Menu_Buffer 			  ;
	mov	eax,128 				  ;
	mov	ecx,2					  ;3
	mov	ebx,6					  ; 
	int	40h					  ;
;=======================================================  ;
; Write buffer to screen                                  ;
;=======================================================  ;
	call	BuffToScreenScr 			  ;
;=======================================================  ;
; Set int timer to 100 ticks a second                     ;
;=======================================================  ;      
	mov	ecx,100 				  ;
	call	[InterruptTimer]			  ;
;=======================================================  ;
; Set some vars up                                        ;
;=======================================================  ;
	xor	eax,eax 				  ;
	mov	ax,[ModeInfo_XResolution]		  ;
	shr	ax,1					  ;
	sub	ax,240					  ;
	mov	[WinStartX],eax 			  ;
	xor	eax,eax 				  ;
	mov	ax,[ModeInfo_YResolution]		  ;
	shr	ax,1					  ;
	sub	ax,285					  ;
	mov	[WinStartY],eax 			  ;
	call	GetWinBufferPointer			  ;
	cld						  ;
	finit						  ;
	call	filling_alfbet				  ; fill table alfbet by casual numbers
	mov	eax,[tabl_calls]			  ;
	mov	[pp1adr],eax				  ;
;=======================================================  ;
; Main loop                                               ;
;=======================================================  ;
MainLoop:						  ;
	hlt						  ;
	call	calcframe				  ;
	mov	edx,dword [posy]			  ; edx=image position in window [x]*65536+[y]
	mov	ecx,[outsize]				  ; ecx=image position in window [x]*65536+[y]
	call	BuffToScreen				  ;
	call	[KeyPressedNoWait]			  ;
	cmp	al,1					  ;
	jne	MainLoop				  ;
;=======================================================  ;
; Exit screen saver.                                      ;
;=======================================================  ;
	mov	ecx,0					  ;
	call	[InterruptTimer]			  ;
ExitError:						  ;
	ret						  ;
;=======================================================  ;
; BuffToScreen.                                           ;
;=======================================================  ;
BuffToScreenScr:					  ; test for 24bit or 32bit vesa
	cmp	[ModeInfo_BitsPerPixel],24		  ;
	jne	Try32Scr				  ;
	call	BuffToScreen24Scr			  ;
	jmp	wehavedone24Scr 			  ;
Try32Scr:						  ;
	cmp	[ModeInfo_BitsPerPixel],32		  ;
	jne	wehavedone24Scr 			  ;
	call	BuffToScreen32Scr			  ;
wehavedone24Scr:					  ;
@@:							  ;
	ret						  ;

;=======================================================  ;
; BuffToScreen32 (32bpp)                                  ;
;=======================================================  ;
BuffToScreen32Scr:					  ;
	 pushad 					  ;
	 push	 es					  ;
	 mov	 ax,8h					  ;
	 mov	 es,ax					  ;
	 mov	 edi,[ModeInfo_PhysBasePtr]		  ;
	 mov	 esi,VesaBuffer 			  ;
	 xor	 eax,eax				  ;
	 mov	 ecx,eax				  ;
	 mov	 ax,[ModeInfo_XResolution]		  ;
	 mov	 cx,[ModeInfo_YResolution]		  ;
	 mul	 ecx					  ;
	 mov	 ecx,eax				  ;
	 cld						  ;
	 cli						  ;
	 rep	 movsd					  ;
	 sti						  ;
	 pop	 es					  ;
	 popad						  ;
	 ret						  ;

;=======================================================  ;
; BuffToScreen24 (24bpp)                                  ;
;=======================================================  ;
BuffToScreen24Scr:					  ;
	 pushad 					  ;
	 push	 es					  ;
	 mov	 ax,8h					  ;
	 mov	 es,ax					  ;
	 xor	 eax,eax				  ;
	 mov	 ecx,eax				  ;
	 mov	 ebx,eax				  ;
	 mov	 ax,[ModeInfo_YResolution]		  ;
	 mov	 ebp,eax				  ;
	 lea	 eax,[ebp*2+ebp]			  ;
	 mov	 edi,[ModeInfo_PhysBasePtr]		  ;
	 mov	 esi,VesaBuffer 			  ;
	 cld						  ;
.l1:							  ;
	 mov	 cx,[ModeInfo_XResolution]		  ;
	 shr	 ecx,2					  ;
.l2:							  ;
	 mov	 eax,[esi]				  ;
	 mov	 ebx,[esi+4]				  ;
	 shl	 eax,8					  ;
	 shrd	 eax,ebx,8				  ;
	 stosd						  ;
							  ;
	 mov	 ax,[esi+8]				  ;
	 shr	 ebx,8					  ;
	 shl	 eax,16 				  ;
	 or	 eax,ebx				  ;
	 stosd						  ;
							  ;
	 mov	 bl,[esi+10]				  ;
	 mov	 eax,[esi+12]				  ;
	 shl	 eax,8					  ;
	 mov	 al,bl					  ;
	 stosd						  ;
							  ;
	 add	 esi,16 				  ;
	 loop	 .l2					  ;
							  ;
	 sub	 ebp,1					  ;
	 ja	.l1					  ;
							  ;
	 pop	 es					  ;
	 popad						  ;
	 ret						  ;

;=======================================================  ;
; Move buffer                                             ;
;=======================================================  ;
MoveBuffer:						  ;
	 pushad 					  ;
	 mov	esi,[MenuBuffer]			  ;
	 mov	edi,VesaBuffer				  ;
	 mov	ecx,800*600				  ;
	 rep	movsd					  ;
	 popad						  ;
	 ret						  ;

;=======================================================  ;
; Data                                                    ;
;=======================================================  ;
MenuBuffer  dd	 0					  ;
include "Crown.inc"					  ;
WinStartX   dd	 0					  ;
WinStartY   dd	 0					  ;
align 2 						  ;
  frame     dd	 0					  ;
  mp	    dd	 0.00390625				  ;
  n_r	    dd	 0.00390625				  ;
  mal_r     dd	 6.28318530717958648			  ;
  mbt_r     dd	 6.28318530717958648			  ;
  const3    dd	 3					  ;
  const6    dw	 6					  ;
  const480  dd	 480					  ;
  mFl	    dd	 n_points				  ;
  pp1	    dw	 0					  ;
  Zdepth    dd	 0.3					  ;
  Zcolor    dw	 140					  ;
  mid	    dd	 240					  ; centre of screen
  speed1    dd	 speed					  ;
  flscr     db	 fullscreen				  ;
  align 4						  ;
  outsize   dd	 ?					  ;
  posy	    dw	 ?					  ;
  posx	    dw	 ?					  ;
  maxy	    dw	 ?					  ;
  maxx	    dw	 ?					  ;
  Fl	    dd	 ?					  ;
  p	    dd	 ?					  ;
  al_r	    dd	 ?					  ;
  bt_r	    dd	 ?					  ;
  pp0adr    dd	 ?					  ;
  pp1adr    dd	 ?					  ;
  z_w	    dw	 ?					  ;
  x1	    dd	 ?					  ;
  y1	    dd	 ?					  ;
  z1	    dd	 ?					  ;
return	    dd	 0					  ;
align 4 						  ;
file_area_Menu: 					  ;
file   'ScrMenu\ScrMenu.dif'				  ;
file_area_Menu_FileEnd: 				  ;
rd 1							  ;
align 4 						  ;
include 'Dex.inc'					  ;
align 4 						  ;
Menu_Buffer: rd  544*512+2				  ;
VesaBuffer:  rd  800*600				  ;
align 16						  ;
alfbet:      rd 0x1800					  ; alfbet  db  n_points*4  dup (?)
scr = alfbet+n_points*4 				  ; scr     db  480*480*3+1 dup (?)
i_end = scr+480*480*3+1 				  ; i_param db  256         dup (?)
