﻿# You can place the script of your game in this file.

init:
    # Declare images below this line, using the image statement.
    # eg. image eileen happy = "eileen_happy.png"
    
    image bg snow = Animation("images/bg_snow1.png", 0.2,
                                                "images/bg_snow2.png", 0.2,
                                                "images/bg_snow3.png", 0.2)
    image bg snow2 = Animation("images/bg_snow2_1.png", 0.2,
                                                "images/bg_snow2_2.png", 0.2,
                                                "images/bg_snow2_3.png", 0.2)
    image bg snow3 = Animation("images/bg_snow3_1.png", 0.2,
                                                "images/bg_snow3_2.png", 0.2,
                                                "images/bg_snow3_3.png", 0.2)
    image bg snow4 = Animation("images/bg_snow4_1.png", 0.2,
                                                "images/bg_snow4_2.png", 0.2,
                                                "images/bg_snow4_3.png", 0.2)
    
    image white = Solid("#ffffff")
    
    image bg gate1 = ConditionSwitch(
        "door1 == 'none'", "images/bg_gate1.png",
        "door1 == 'lance'", "images/bg_gate1lance.png",
        "door1 == 'shield'", "images/bg_gate1shield.png")
    
    image bg gate2 = ConditionSwitch(
        "door2 == 'none'", "images/bg_gate2.png",
        "door2 == 'mouse'", "images/bg_gate2mouse.png",
        "door2 == 'snake'", "images/bg_gate2snake.png")
    
    image bg gate3 = ConditionSwitch(
        "door3 == 'none'", "images/bg_gate3.png",
        "door3 == 'kitten'", "images/bg_gate3kitten.png",
        "door3 == 'tiger'", "images/bg_gate3tiger.png")
    
    image bg cabin = ConditionSwitch(
        "chair == 'middle'", "images/bg_cabin.png",
        "chair == 'lance'", "images/bg_cabinlance.png",
        "chair == 'shield'", "images/bg_cabinshield.png")
    
    image bg cave = ConditionSwitch(
        "item == 'water'", "images/bg_cavebucket.png",
        "item != 'water'", "images/bg_cave.png")
    
    image bg fount = ConditionSwitch(
        "fountain == False", "images/bg_fount.png",
        "bird == True", "images/bg_fountwater.png",
        "bird == False", "images/bg_fountbirds.png",
        "fountain == True", "images/bg_fountbirds.png")
    
    image bg field = ConditionSwitch(
        "corn == False", "images/bg_field.png",
        "mice == True", "images/bg_fieldmouse.png",
        "corn == True, mice == False", "images/bg_fieldcorn.png")
    
    image bg plain = ConditionSwitch(
        "cactus == False", "images/bg_plain.png",
        "snake == True", "images/bg_plainsnake.png",
        "cactus == True, snake == False", "images/bg_plainbird.png")
    
    
    image bg grave = ConditionSwitch(
        "item == 'moon'", "images/bg_gravesmoon.png",
        "item == 'flower'", "images/bg_gravesflower.png",
        "item != 'moon', item != 'flower'", "images/bg_graves.png")
    
    image bg underwater = ConditionSwitch(
        "item == 'fish'", "images/bg_underwaterfish.png",
        "item != 'fish'", "images/bg_underwater.png")
    
    image bg waterfall = ConditionSwitch(
        "key_tiger == False", "images/bg_waterfall.png",
        "key_tiger == True", "images/bg_waterfalltiger.png")
    
    image bg library = ConditionSwitch(
        "key_kitten == False", "images/bg_library.png",
        "key_kitten == True", "images/bg_librarykitten.png")
    
    image bg path = ConditionSwitch(
        "item == 'rabbit'", "images/bg_pathflower.png",
        "item =='rabbit', flower == True", "images/bg_pathflower.png",
        "rabbit == True", "images/bg_pathrabbit.png",
        "flower == False", "images/bg_path.png")
    
    image char girl = ConditionSwitch(
        "eyes == 0", "images/girl0.png",
        "eyes == 1", "images/girl1.png",
        "eyes == 2", "images/girl2.png",
        "eyes == 3", "images/girl3.png")
    
    
    image splash ="images/logo.png"
    image bg end ="images/end.png"

    # Declare characters used by this game.
    
    $ n = Character(what_color="#73acff", what_italic = True)
    $ pc = Character(what_color="#ffffff")
    $ girl = Character('Girl', color="#73acff", what_color="#ffffff", who_bold = False)
    $ gk = Character('Gate Keeper', color="#73acff", what_color="#ffffff", who_bold = False)
    
    
    $_game_menu_screen = "_quit_prompt"


# The game starts here.

label splashscreen:
    $ renpy.pause(0)
    scene black
    with Pause(0.5)

    show splash
    with fade
    with Pause(2.0)

    scene black
    with fade
    with Pause(0.5)

    return
    
    
label start:
    
    $ item = "none"
    $ key_lance = False
    $ key_shield = False
    $ key_snake = False
    $ key_mouse = False
    $ key_tiger = False
    $ key_kitten = False
    
    $ door1 = "none"
    $ door2 = "none"
    $ door3 = "none"

    
    $ room1_1 = False
    $ room2_1 = False
    $ room3_1= False
    
    
    $ chair = "middle"
    $ flower = False
    $ rabbit = False
    $ fountain = False
    $ bird = False
    $ corn = False
    $ mice = False
    $ cactus = False
    $ snake = False
    $ eyes = 0


    
    scene black with pixellate
    with Pause(0.5)
    scene bg snow with pixellate
    with Pause(3.0)
    n "...I'm glad you're here."
    $ config.rollback_enabled = False
    with Pause(1.0)
    scene black with pixellate
    with Pause(0.5)
    
label room1_1:
    scene bg cabin with pixellate
    $ chair = "middle"
   
    if room1_1 == False:
        $ room1_1 = True
        show char girl
        girl "Are you really?"
        pc "Huh? Did I say something?"
        girl "You said you were glad..."
        pc "Oh..."
        girl "Haha, well, it's not much, but make yourself at home here."
        pc "Thanks."
        girl "Glad I can help."
        girl "You shouldn't be out in the cold alone."
        pc "..."
        girl "You'll be safe here.{w} I'll see you later."
        hide char girl
        with pixellate
        n "Let's see..."
        
    n "I'm in an unfamiliar room."
label room1_1hub: 
    menu:
        n "What should I do?"
        "Examine.":
            menu:
                n "What should I examine?"
                "Lance":
                    if key_lance == False:
                        
                        if chair == "lance":
                            n "I can reach the lance now."
                            menu:
                                n "Should I check it?"
                                "Yes.":
                                    $ key_lance = True
                                    n "I find a key."
                                    jump room1_1hub
                                "No.":
                                    n "I'll leave it alone."
                                    jump room1_1hub
                                    
                        else:
                            n "There's a lance on the wall, but I can't reach it."
                            jump room1_1hub
                        
                    else:
                        n "I already have the key."
                        jump room1_1hub
                "Shield":
                    if key_shield == False:
                        
                        if chair == "shield":
                            n "I can reach the shield now."
                            menu:
                                n "Should I check it?"
                                "Yes.":
                                    $ key_shield = True
                                    n "I find a key."
                                    jump room1_1hub
                                "No.":
                                    n "I'll leave it alone."
                                    jump room1_1hub
                        else:
                            n "There's a shield on the wall, but I can't reach it."
                            jump room1_1hub
                        
                    else:
                        n "I already have the key."
                        jump room1_1hub
                        
                "Chair":
                    n "It's a simple wooden chair."
                    menu:
                        n "Should I move the chair?"
                        "No":
                            n "No, I'll leave it where it is"
                            jump room1_1hub
                        "To the lance":
                            $ chair = "lance"
                            n "...There."
                            jump room1_1hub
                        "To the shield":
                            $ chair = "shield"
                            n "...There."
                            jump room1_1hub
        "Talk.":
            pc "Hello???"
            n "...{p}Nothing."
            jump room1_1hub
        "Move.":
            menu:
                n "Where shall I go?"
                "North.":
                    scene black with pixellate
                    with Pause(0.5)
                    jump room1_2
                    
#############################################################
#############################################################
                    
label room1_2:
    scene bg gate1 with pixellate
    n "There's a pair of ornate doors in this room."
label room1_2hub:
    menu:
        n "What should I do?"
        "Examine.":
            n "The doors are made of stone, and won't budge."
            n "There's a carving of a lance on one, and a shield on the other."
            n "Maybe there's a trick to opening them."
            jump room1_2hub
        "Talk.":
            if door1 == "none":
                if key_lance == False:
                    if key_shield == False:
                        pc "Hello?"
                        gk "What do you require?"
                        pc "Can I go through these doors?"
                        gk "Return with the key, talk to me, and the doors will open."
                        pc "Okay."
                        n "Better search around for a key then."
                        jump room1_2hub
                    
                if key_lance == True:
                    if key_shield == True:
                        pc "I have the keys."
                        gk "You can only open one door. You must choose which to open."
                        n "Hmm..."
                        menu:
                            n "Which should I open?"
                            "Shield door.":
                                pc "I'll open the shield door."
                                gk "So it shall be."
                                $ door1 = "shield"
                                $ eyes += 1
                                jump room1_2hub
                                
                            "Lance door.":
                                pc "I'll open the lance door."
                                gk "So it shall be."
                                $ door1 = "lance"
                                jump room1_2hub
                    
                    if key_shield == False:
                        pc "I have the key."
                        menu:
                            gk "Would you like to open the \nlance door?"
                            "Yes":
                                gk "So it shall be."
                                $ door1 = "lance"
                                jump room1_2hub
                                
                            "No":
                                gk "So it shall be."
                                jump room1_2hub
                    
                if key_shield == True:
                    pc "I have the key."
                    menu:
                        gk "Would you like to open the \nshield door?"
                        "Yes":
                            gk "So it shall be."
                            $ door1 = "shield"
                            $ eyes += 1
                            jump room1_2hub
                            
                        "No":
                            gk "So it shall be."
                            jump room1_2hub
                    
            if door1 == "shield":
                gk "You made your choice. The way is open."
                jump room1_2hub
            
            if door1 == "lance":
                gk "You made your choice. The way is open."
                jump room1_2hub
        "Move.":
            menu:
                n "Where should I go?"
                "North" if door1 == "shield":
                    scene black with pixellate
                    with Pause(0.5)
                    jump room2_1
                "North" if door1 == "lance":
                    scene black with pixellate
                    with Pause(0.5)
                    jump room2_1
                "South":
                    scene black with pixellate
                    with Pause(0.5)
                    jump room1_1
    
