import ddf.minim.*;

Minim minim;

void stop(){
  // always close Minim audio classes when you are done with them :-)
  closeSounds();
  minim.stop();
  super.stop();
}

AudioPlayer music;
AudioSnippet click;
AudioSnippet whistle;
AudioSnippet inwhoosh;
AudioSnippet outwoosh;


int SAMPLECOUNT = 4;

AudioSnippet[] scratch = new AudioSnippet[SAMPLECOUNT];

void loadSounds(){
  minim = new Minim(this);
  music = minim.loadFile("trains_short.mp3");
 click = minim.loadSnippet("click.wav");
 whistle = minim.loadSnippet("whistle.mp3");
 inwhoosh = minim.loadSnippet("inwhoosh.mp3");
 outwoosh = minim.loadSnippet("outwoosh.mp3");
 
  for(int i = 0; i < SAMPLECOUNT; i++){
    scratch[i] = minim.loadSnippet("click.wav");  
  }
}
boolean musicPlaying;
void startMusic(){
   music.loop();
  musicPlaying = true; 
}
void stopMusic(){
   music.pause(); 
   music.rewind();
   musicPlaying = false;
}

void fx_click() { fx(click); }
void fx_whistle() { fx(whistle); }
void fx_inwhoosh() { fx(inwhoosh); }
void fx_outwoosh() { fx(outwoosh); }
void fx(AudioSnippet a){
   a.pause();a.rewind();a.play(); 
}

int scratchPtr = 0;
void fx_scratch(){
  AudioSnippet s = scratch[scratchPtr % SAMPLECOUNT];
  scratchPtr++;
  s.pause();
  s.rewind();
  s.play();
}

void closeSounds(){
  click.close();
  whistle.close();
  inwhoosh.close();
  outwoosh.close();
  music.close();


   for(int i = 0; i < SAMPLECOUNT; i++){
    scratch[i].close();
  }
  
}




