
class ParentPuzzle extends Puzzle{
  
  ArrayList<KidPuzzle> kids = new ArrayList<KidPuzzle>();
  
  ParentPuzzle(String s){
    super(s);
    scaleBase = 300;
    recalcScale();
  /*
    kids.add(new KidPuzzle( text3[int(random(text3.length))],0,1,this,nodes[1][0]));
    //5s:
    kids.add(new KidPuzzle( text3[int(random(text3.length))],1,0,this,nodes[0][1]));
    kids.add(new KidPuzzle( text3[int(random(text3.length))],1,1,this,nodes[1][1]));
    kids.add(new KidPuzzle( text3[int(random(text3.length))],1,2,this,nodes[2][1]));
    //7s:
    kids.add(new KidPuzzle( text3[int(random(text3.length))],2,0,this,nodes[0][2]));
    kids.add(new KidPuzzle( text3[int(random(text3.length))],2,1,this,nodes[1][2]));
    kids.add(new KidPuzzle( text3[int(random(text3.length))],2,2,this,nodes[2][2]));
*/

    kids.add(new KidPuzzle( text3[int(random(text3.length))],1,0,this,nodes[0][1]));

    kids.add(new KidPuzzle( text5[int(random(text5.length))],2,0,this,nodes[0][2]));


    kids.add(new KidPuzzle( text5[int(random(text5.length))],0,1,this,nodes[1][0]));
    //5s:

    kids.add(new KidPuzzle( text5[int(random(text5.length))],1,1,this,nodes[1][1]));
    //7s:
    kids.add(new KidPuzzle( text7[int(random(text7.length))],1,2,this,nodes[2][1]));
    kids.add(new KidPuzzle( text7[int(random(text7.length))],2,1,this,nodes[1][2]));
    kids.add(new KidPuzzle( text7[int(random(text7.length))],2,2,this,nodes[2][2]));
}
  
  int howManyHints(){
    int hints = 0;
       for(KidPuzzle kid : kids){
          hints+= kid.hintCount;   
       }
       return hints;
  }
  
  
void drawNodes(){
//make sure we draw any zooming kid last
   KidPuzzle zoomingKid = null;
   for(KidPuzzle kid : kids){
     if(kid.zooming > 0) zoomingKid = kid;
      else kid.drawKid(checkHoverKid(kid));
   }   
   if(zoomingKid != null) zoomingKid.drawKid(false);
   if(!true){
     int nodeX = getNodeXFromName(startingNodeName);     
     int nodeY = getNodeYFromName(startingNodeName);     
     float nodeScreenX = getScreenX(nodeX,nodeY);
     float nodeScreenY = getScreenY(nodeX,nodeY);
   stroke(0);
     line(0,0,nodeScreenX,nodeScreenY);
     
   }
   
   
}

void checkClick(){
  super.checkClick();
  for(KidPuzzle kid : kids){
    //println( getScreenX(kid.x, kid.y)+"--"+);
     if(checkHoverKid(kid)){
        currentPuzzle = kid;
        seenClickHere = true;
        currentPuzzle.startZoom(kid.centerX,kid.centerY,250,250,kid.scaleBase,120);
        fx_inwhoosh();
        doBackArrow = true;
     } 
  }
}

boolean checkHoverKid(KidPuzzle kid){
  return dist(mouseX,mouseY, getScreenX(kid.x, kid.y),getScreenY(kid.x, kid.y)) <  kid.scaleBase*.6*ROWS;
}

//so this is to enforce how the parent has different rules, only connected nodes are allowed....
boolean areLiveNodes(int x,int y,int ex,int ey){
    int startNodeContent = nodes[y][x];  
    int endNodeContent = nodes[ey][ex];  
    if(!isNotDeadNode(startNodeContent)) return false;
    if(!isNotDeadNode(endNodeContent)) return false;
    //So both aren't zeros, but one end needs to be a solved puzzle 
    
    if(isConnectedNode(startNodeContent) || isConnectedNode(endNodeContent) ) return true;
    //OR this node needs to be a fixed node...
    int n1 = getNodeName(x,y);
     int n2 = getNodeName(ex,ey);
    if(fixedLinks.get(n1+"_"+n2)!= null) return true;
    
    return false;
}

boolean isConnectedNode(int content){
   return  content == SOLVENODE;
}
boolean isNotDeadNode(int content){
   return content != DEADNODE; 
}

}


class KidPuzzle extends Puzzle{
    int x,y;
    ParentPuzzle parent;
    boolean isEndpoint = false;
    boolean isStartingEndpoint = false;

    KidPuzzle(String s,int px,int py,ParentPuzzle pp, int pNodeType){
       super(s); 
      x = px;
      y = py;
      scaleBase = 30;
      recalcScale();
      parent = pp;
      
      if(pNodeType >  1) isEndpoint = true;
      if(pNodeType ==  STARTNODE) isStartingEndpoint = true;
      
      nodeTag = getNodeName(x,y);
      //println("I AM "+nodeTag);
      
      centerX = parent.getScreenX(x,y);
      centerY = parent.getScreenY(x,y);
      
    }
    
    void drawKid(boolean hiLite){
      if(isEndpoint) fill(80,160,160);
             else fill(80,160,80);
      noStroke();
       strokeWeight(2);
      if(hiLite){
          stroke(128);
          doHand = true;
                 strokeWeight(4);
          line(centerX,centerY, centerX + scaleBase*.5*ROWS,centerY + scaleBase*.5*ROWS);
                 strokeWeight(3);
      } else {
          if(trainMoving) stroke(GOLD);
      }
      ellipse(centerX,centerY , scaleBase*.6*ROWS,scaleBase*.6 * ROWS);  
      draw();
      if(isStartingEndpoint && ! seenClickHere){
           drawClickHere();
      }


    }
    
    void drawClickHere(){
      stroke(GOLD);
      float top = centerY + (scaleBase*.6 * ROWS)/2 + 10;
      
      line(centerX,top,centerX,top+20);
      line(centerX,top,centerX-10,top+10);
      line(centerX,top,centerX+10,top+10);
      fill(GOLD);
      textAlign(CENTER);
      text("CLICK HERE\nTO START\nMICROTOWN",centerX,top+40);
      
    }
    
    
}
