/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import ddf.minim.AudioSnippet;
import ddf.minim.Minim;
import java.util.ArrayList;
import java.util.HashMap;
import processing.core.PApplet;
import processing.core.PImage;

public class microrail
extends PApplet {
    int GAME_TITLE = 1;
    int GAME_PLAY = 2;
    int gameMode = this.GAME_TITLE;
    boolean wonIt = false;
    boolean doBackArrow = false;
    int GOLD = this.color(255, 212, 0);
    int SCREENCENTER = 250;
    boolean hintShowing;
    Puzzle currentPuzzle;
    ParentPuzzle parentPuzzle;
    String[] text3_parent;
    String[] text3;
    String[] text5;
    String[] text7;
    PImage titleart;
    boolean doHand;
    boolean seenClickHere;
    boolean seenInstructions;
    boolean seenArrowHint;
    boolean showArrowHint;
    int DEADNODE = 0;
    int LIVENODE = 1;
    int STARTNODE = 2;
    int ENDNODE = 3;
    int SOLVENODE = 4;
    Minim minim;
    AudioPlayer music;
    AudioSnippet click;
    AudioSnippet whistle;
    AudioSnippet inwhoosh;
    AudioSnippet outwoosh;
    int SAMPLECOUNT = 4;
    AudioSnippet[] scratch = new AudioSnippet[this.SAMPLECOUNT];
    boolean musicPlaying;
    int scratchPtr = 0;

    public void setup() {
        this.titleart = this.loadImage("microrail.png");
        this.frameRate(20.0f);
        this.smooth();
        this.size(500, 500);
        this.loadSounds();
        this.startMusic();
        this.text3_parent = this.loadStrings("3x3_parent.txt");
        this.text3 = this.loadStrings("3x3.txt");
        this.text5 = this.loadStrings("5x5.txt");
        this.text7 = this.loadStrings("7x7.txt");
        this.resetPuzzle();
    }

    public void draw() {
        this.doHand = false;
        this.background(100.0f, 200.0f, 100.0f);
        if (this.doBackArrow && this.isInArrow()) {
            this.doHand = true;
        }
        if (this.gameMode == this.GAME_PLAY) {
            this.currentPuzzle.draw();
        } else {
            this.doTitle();
        }
        this.stroke(0);
        if (this.doBackArrow) {
            this.noStroke();
            if (this.currentPuzzle.trainMoving) {
                float f = microrail.lerp((float)200.0f, (float)255.0f, (float)(0.5f + this.currentPuzzle.moveVal / 2.0f));
                float f2 = microrail.lerp((float)200.0f, (float)215.0f, (float)(0.5f + this.currentPuzzle.moveVal / 2.0f));
                float f3 = microrail.lerp((float)200.0f, (float)0.0f, (float)(0.5f + this.currentPuzzle.moveVal / 2.0f));
                this.fill(f, f2, f3);
            } else {
                this.fill(200);
            }
            this.rect(40.0f, 40.0f, 20.0f, 20.0f);
            this.triangle(40.0f, 30.0f, 40.0f, 70.0f, 20.0f, 50.0f);
            if (this.showArrowHint) {
                this.fill(this.GOLD);
                this.textAlign(37);
                this.text("CLICK TO RETURN", 70.0f, 55.0f);
            }
        }
        if (this.currentPuzzle != this.parentPuzzle && !this.seenInstructions) {
            this.textAlign(37);
            this.fill(0);
            this.text("MICROTOWN MICRORAIL NEEDS YOU! CLICK ON THE GRAY LINES TO LAY TRACK BETWEEN NODES. CLICK AGAIN TO REMOVE.\n\nTHE GOAL IS TO CONSTRUCT A SINGLE RAIL LINE PASSING THROUGH ALL THE STATIONS, WITH THE BLUE DOTS AS ENDS OF THE LINE. [I.E. WHEN SOLVED, EVERY WHITE STATION WILL HAVE 2 RAILS CONNECTED TO IT, AND THE BLUE STATIONS WILL HAVE ONLY A SINGLE RAIL EACH]\n\nCLICK 'HINT' FOR SUGGESTIONS.", 20.0f, 335.0f, 440.0f, 150.0f);
        }
        if (this.currentPuzzle != this.parentPuzzle && this.gameMode == this.GAME_PLAY) {
            this.textAlign(3);
            this.fill(200);
            this.rect(210.0f, 475.0f, 80.0f, 20.0f);
            this.fill(0);
            this.text("HINT", 250.0f, 490.0f);
            if (this.overHint()) {
                this.doHand = true;
            }
        }
        if (this.mousePressed && this.overHint() && this.gameMode == this.GAME_PLAY && this.currentPuzzle != this.parentPuzzle) {
            this.currentPuzzle.showHint();
            if (!this.hintShowing) {
                ++this.currentPuzzle.hintCount;
            }
            this.hintShowing = true;
        } else {
            this.hintShowing = false;
        }
        if (this.doHand) {
            this.cursor(12);
        } else {
            this.cursor(0);
        }
        if (this.wonIt && this.gameMode == this.GAME_PLAY) {
            this.fill(this.GOLD);
            this.textAlign(3);
            this.text("EXCELLENT! YOU ARE THE KING OF THE MICRORAIL!\n(You used " + this.parentPuzzle.howManyHints() + " hints)\nPRESS SPACE TO PLAY AGAIN", 250.0f, 30.0f);
        }
    }

    public boolean overHint() {
        return this.mouseX >= 210 && this.mouseX <= 290 && this.mouseY >= 475 && this.mouseY <= 495;
    }

    public boolean isInArrow() {
        return this.mouseX > 20 && this.mouseX < 60 && this.mouseY > 30 && this.mouseY < 70;
    }

    public void restoreParent() {
        KidPuzzle kidPuzzle = (KidPuzzle)this.currentPuzzle;
        this.currentPuzzle.startZoom(this.SCREENCENTER, this.SCREENCENTER, this.parentPuzzle.getScreenX(kidPuzzle.x, kidPuzzle.y), this.parentPuzzle.getScreenY(kidPuzzle.x, kidPuzzle.y), 120.0f, 30.0f);
        this.currentPuzzle = this.parentPuzzle;
        this.doBackArrow = false;
        this.showArrowHint = false;
    }

    public void mousePressed() {
        if (this.gameMode == this.GAME_TITLE) {
            this.gameMode = this.GAME_PLAY;
            this.stopMusic();
            this.startGame();
            return;
        }
        boolean bl = false;
        if (this.doBackArrow && this.isInArrow()) {
            this.restoreParent();
            this.fx_outwoosh();
            bl = true;
            this.seenInstructions = true;
        }
        if (!bl) {
            this.currentPuzzle.checkClick();
        }
    }

    public void doTitle() {
        this.image(this.titleart, 0.0f, 0.0f);
        this.textAlign(39);
    }

    public void keyPressed() {
        if (this.key == ' ') {
            this.gameMode = this.GAME_TITLE;
            this.resetPuzzle();
            if (!this.musicPlaying) {
                this.startMusic();
            }
        }
    }

    public void resetPuzzle() {
        this.parentPuzzle = new ParentPuzzle(this.text3_parent[PApplet.parseInt((float)this.random(this.text3_parent.length))]);
        this.currentPuzzle = this.parentPuzzle;
    }

    public void startGame() {
        this.seenClickHere = false;
        this.seenInstructions = false;
        this.seenArrowHint = false;
        this.wonIt = false;
        this.showArrowHint = false;
    }

    public void stop() {
        this.closeSounds();
        this.minim.stop();
        super.stop();
    }

    public void loadSounds() {
        this.minim = new Minim((PApplet)this);
        this.music = this.minim.loadFile("trains_short.mp3");
        this.click = this.minim.loadSnippet("click.wav");
        this.whistle = this.minim.loadSnippet("whistle.mp3");
        this.inwhoosh = this.minim.loadSnippet("inwhoosh.mp3");
        this.outwoosh = this.minim.loadSnippet("outwoosh.mp3");
        int n = 0;
        while (n < this.SAMPLECOUNT) {
            this.scratch[n] = this.minim.loadSnippet("click.wav");
            ++n;
        }
    }

    public void startMusic() {
        this.music.loop();
        this.musicPlaying = true;
    }

    public void stopMusic() {
        this.music.pause();
        this.music.rewind();
        this.musicPlaying = false;
    }

    public void fx_click() {
        this.fx(this.click);
    }

    public void fx_whistle() {
        this.fx(this.whistle);
    }

    public void fx_inwhoosh() {
        this.fx(this.inwhoosh);
    }

    public void fx_outwoosh() {
        this.fx(this.outwoosh);
    }

    public void fx(AudioSnippet audioSnippet) {
        audioSnippet.pause();
        audioSnippet.rewind();
        audioSnippet.play();
    }

    public void fx_scratch() {
        AudioSnippet audioSnippet = this.scratch[this.scratchPtr % this.SAMPLECOUNT];
        ++this.scratchPtr;
        audioSnippet.pause();
        audioSnippet.rewind();
        audioSnippet.play();
    }

    public void closeSounds() {
        this.click.close();
        this.whistle.close();
        this.inwhoosh.close();
        this.outwoosh.close();
        this.music.close();
        int n = 0;
        while (n < this.SAMPLECOUNT) {
            this.scratch[n].close();
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        PApplet.main((String[])new String[]{"--bgcolor=#F0F0F0", "microrail"});
    }

    class KidPuzzle
    extends Puzzle {
        int x;
        int y;
        ParentPuzzle parent;
        boolean isEndpoint;
        boolean isStartingEndpoint;

        KidPuzzle(String string, int n, int n2, ParentPuzzle parentPuzzle, int n3) {
            super(string);
            this.isEndpoint = false;
            this.isStartingEndpoint = false;
            this.x = n;
            this.y = n2;
            this.scaleBase = 30.0f;
            this.recalcScale();
            this.parent = parentPuzzle;
            if (n3 > 1) {
                this.isEndpoint = true;
            }
            if (n3 == microrail.this.STARTNODE) {
                this.isStartingEndpoint = true;
            }
            this.nodeTag = this.getNodeName(this.x, this.y);
            this.centerX = this.parent.getScreenX(this.x, this.y);
            this.centerY = this.parent.getScreenY(this.x, this.y);
        }

        public void drawKid(boolean bl) {
            if (this.isEndpoint) {
                microrail.this.fill(80.0f, 160.0f, 160.0f);
            } else {
                microrail.this.fill(80.0f, 160.0f, 80.0f);
            }
            microrail.this.noStroke();
            microrail.this.strokeWeight(2.0f);
            if (bl) {
                microrail.this.stroke(128);
                microrail.this.doHand = true;
                microrail.this.strokeWeight(4.0f);
                microrail.this.line(this.centerX, this.centerY, this.centerX + this.scaleBase * 0.5f * (float)this.ROWS, this.centerY + this.scaleBase * 0.5f * (float)this.ROWS);
                microrail.this.strokeWeight(3.0f);
            } else if (this.trainMoving) {
                microrail.this.stroke(microrail.this.GOLD);
            }
            microrail.this.ellipse(this.centerX, this.centerY, this.scaleBase * 0.6f * (float)this.ROWS, this.scaleBase * 0.6f * (float)this.ROWS);
            this.draw();
            if (this.isStartingEndpoint && !microrail.this.seenClickHere) {
                this.drawClickHere();
            }
        }

        public void drawClickHere() {
            microrail.this.stroke(microrail.this.GOLD);
            float f = this.centerY + this.scaleBase * 0.6f * (float)this.ROWS / 2.0f + 10.0f;
            microrail.this.line(this.centerX, f, this.centerX, f + 20.0f);
            microrail.this.line(this.centerX, f, this.centerX - 10.0f, f + 10.0f);
            microrail.this.line(this.centerX, f, this.centerX + 10.0f, f + 10.0f);
            microrail.this.fill(microrail.this.GOLD);
            microrail.this.textAlign(3);
            microrail.this.text("CLICK HERE\nTO START\nMICROTOWN", this.centerX, f + 40.0f);
        }
    }

    class ParentPuzzle
    extends Puzzle {
        ArrayList<KidPuzzle> kids;

        ParentPuzzle(String string) {
            super(string);
            this.kids = new ArrayList();
            this.scaleBase = 300.0f;
            this.recalcScale();
            this.kids.add(new KidPuzzle(microrail.this.text3[PApplet.parseInt((float)microrail.this.random(microrail.this.text3.length))], 1, 0, this, this.nodes[0][1]));
            this.kids.add(new KidPuzzle(microrail.this.text5[PApplet.parseInt((float)microrail.this.random(microrail.this.text5.length))], 2, 0, this, this.nodes[0][2]));
            this.kids.add(new KidPuzzle(microrail.this.text5[PApplet.parseInt((float)microrail.this.random(microrail.this.text5.length))], 0, 1, this, this.nodes[1][0]));
            this.kids.add(new KidPuzzle(microrail.this.text5[PApplet.parseInt((float)microrail.this.random(microrail.this.text5.length))], 1, 1, this, this.nodes[1][1]));
            this.kids.add(new KidPuzzle(microrail.this.text7[PApplet.parseInt((float)microrail.this.random(microrail.this.text7.length))], 1, 2, this, this.nodes[2][1]));
            this.kids.add(new KidPuzzle(microrail.this.text7[PApplet.parseInt((float)microrail.this.random(microrail.this.text7.length))], 2, 1, this, this.nodes[1][2]));
            this.kids.add(new KidPuzzle(microrail.this.text7[PApplet.parseInt((float)microrail.this.random(microrail.this.text7.length))], 2, 2, this, this.nodes[2][2]));
        }

        public int howManyHints() {
            int n = 0;
            for (KidPuzzle kidPuzzle : this.kids) {
                n += kidPuzzle.hintCount;
            }
            return n;
        }

        public void drawNodes() {
            KidPuzzle kidPuzzle = null;
            for (KidPuzzle kidPuzzle2 : this.kids) {
                if (kidPuzzle2.zooming > 0.0f) {
                    kidPuzzle = kidPuzzle2;
                    continue;
                }
                kidPuzzle2.drawKid(this.checkHoverKid(kidPuzzle2));
            }
            if (kidPuzzle != null) {
                kidPuzzle.drawKid(false);
            }
        }

        public void checkClick() {
            super.checkClick();
            for (KidPuzzle kidPuzzle : this.kids) {
                if (!this.checkHoverKid(kidPuzzle)) continue;
                microrail.this.currentPuzzle = kidPuzzle;
                microrail.this.seenClickHere = true;
                microrail.this.currentPuzzle.startZoom(kidPuzzle.centerX, kidPuzzle.centerY, 250.0f, 250.0f, kidPuzzle.scaleBase, 120.0f);
                microrail.this.fx_inwhoosh();
                microrail.this.doBackArrow = true;
            }
        }

        public boolean checkHoverKid(KidPuzzle kidPuzzle) {
            return microrail.dist((float)microrail.this.mouseX, (float)microrail.this.mouseY, (float)this.getScreenX(kidPuzzle.x, kidPuzzle.y), (float)this.getScreenY(kidPuzzle.x, kidPuzzle.y)) < kidPuzzle.scaleBase * 0.6f * (float)this.ROWS;
        }

        public boolean areLiveNodes(int n, int n2, int n3, int n4) {
            int n5 = this.nodes[n2][n];
            int n6 = this.nodes[n4][n3];
            if (!this.isNotDeadNode(n5)) {
                return false;
            }
            if (!this.isNotDeadNode(n6)) {
                return false;
            }
            if (this.isConnectedNode(n5) || this.isConnectedNode(n6)) {
                return true;
            }
            int n7 = this.getNodeName(n, n2);
            int n8 = this.getNodeName(n3, n4);
            return this.fixedLinks.get(String.valueOf(n7) + "_" + n8) != null;
        }

        public boolean isConnectedNode(int n) {
            return n == microrail.this.SOLVENODE;
        }

        public boolean isNotDeadNode(int n) {
            return n != microrail.this.DEADNODE;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Puzzle {
        int COLS;
        int ROWS;
        float scaleBase = 100.0f;
        float xgapMUL = 0.6f;
        float ygapMUL = 0.5f;
        float nodesizeMUL = 0.2f;
        float xgap = this.xgapMUL * this.scaleBase;
        float ygap = this.ygapMUL * this.scaleBase;
        float nodesize = this.nodesizeMUL * this.scaleBase;
        int startingNodeName = -1;
        int endingNodeName = -1;
        int hintCount = 0;
        ArrayList<Link> links = new ArrayList();
        HashMap<String, Link> allLinkMap = new HashMap();
        HashMap<String, Link> fixedLinks = new HashMap();
        HashMap<String, Link> solveLinks = new HashMap();
        int[][] nodes;
        int[][] fixed;
        int[][] solve;
        float centerX = 250.0f;
        float centerY = 250.0f;
        int nodeTag;
        float zooming = 0.0f;
        float startZoomX;
        float startZoomY;
        float endZoomX;
        float endZoomY;
        float startZoom;
        float endZoom;
        Link trainLink = null;
        int trainStartNode = -1;
        int trainEndNode = -1;
        float moveVal;
        boolean trainMoving = false;
        int trainReverseNodeName = -1;
        float[] oldTrainX;
        float[] oldTrainY;
        int TRAINHISTORY = 10;
        int POSSIBLE = 1;
        int FIXED = 2;
        int SOLVE = 3;
        int PICKED = 4;

        public Link findSolveLinkForNode(int n) {
            for (String string : this.solveLinks.keySet()) {
                String[] stringArray = string.split("_");
                int n2 = microrail.parseInt((String)stringArray[0]);
                int n3 = microrail.parseInt((String)stringArray[1]);
                if (n != n2 && n != n3) continue;
                return this.solveLinks.get(string);
            }
            return null;
        }

        public Link findOtherSolveLink(int n, Link link) {
            for (String string : this.solveLinks.keySet()) {
                String[] stringArray = string.split("_");
                int n2 = microrail.parseInt((String)stringArray[0]);
                int n3 = microrail.parseInt((String)stringArray[1]);
                if (n != n2 && n != n3 || this.solveLinks.get(string) == link) continue;
                return this.solveLinks.get(string);
            }
            return null;
        }

        Puzzle(String string) {
            this.readPuzzle(string);
            this.store(this.fixed, this.fixedLinks);
            this.store(this.solve, this.solveLinks);
            this.addLinks();
        }

        public void draw() {
            if (this.zooming > 0.0f) {
                this.zooming -= 0.075f;
                this.scaleBase = microrail.lerp((float)this.endZoom, (float)this.startZoom, (float)this.zooming);
                this.centerX = microrail.lerp((float)this.endZoomX, (float)this.startZoomX, (float)this.zooming);
                this.centerY = microrail.lerp((float)this.endZoomY, (float)this.startZoomY, (float)this.zooming);
            } else {
                this.zooming = 0.0f;
            }
            this.recalcScale();
            this.drawLinks();
            this.drawNodes();
            this.animateTrain();
            if (this == microrail.this.currentPuzzle && this.hintCount != 0) {
                microrail.this.textAlign(3);
                microrail.this.fill(0);
                microrail.this.text("HINTS USED: " + this.hintCount, 250.0f, 15.0f);
            }
        }

        public void startZoom(float f, float f2, float f3, float f4, float f5, float f6) {
            this.startZoomX = f;
            this.startZoomY = f2;
            this.endZoomX = f3;
            this.endZoomY = f4;
            this.startZoom = f5;
            this.endZoom = f6;
            this.zooming = 1.0f;
        }

        public void readPuzzle(String string) {
            int n;
            String[] stringArray = string.split(" ");
            int n2 = 0;
            this.ROWS = microrail.parseInt((String)stringArray[n2++]);
            this.COLS = microrail.parseInt((String)stringArray[n2++]);
            microrail.parseInt((String)stringArray[n2++]);
            this.nodes = new int[this.ROWS][];
            int n3 = 0;
            while (n3 < this.ROWS) {
                this.nodes[n3] = new int[this.COLS];
                n = 0;
                while (n < this.COLS) {
                    this.nodes[n3][n] = microrail.parseInt((String)stringArray[n2++]);
                    if (this.nodes[n3][n] == microrail.this.STARTNODE) {
                        this.startingNodeName = this.getNodeName(n, n3);
                    }
                    if (this.nodes[n3][n] == microrail.this.ENDNODE) {
                        this.endingNodeName = this.getNodeName(n, n3);
                    }
                    ++n;
                }
                ++n3;
            }
            n3 = microrail.parseInt((String)stringArray[n2++]);
            this.fixed = new int[n3 / 2][];
            n = 0;
            while (n < n3 / 2) {
                this.fixed[n] = new int[2];
                this.fixed[n][0] = microrail.parseInt((String)stringArray[n2++]);
                this.fixed[n][1] = microrail.parseInt((String)stringArray[n2++]);
                ++n;
            }
            n = microrail.parseInt((String)stringArray[n2++]);
            this.solve = new int[n / 2][];
            int n4 = 0;
            while (n4 < n / 2) {
                this.solve[n4] = new int[2];
                this.solve[n4][0] = microrail.parseInt((String)stringArray[n2++]);
                this.solve[n4][1] = microrail.parseInt((String)stringArray[n2++]);
                ++n4;
            }
        }

        public void drawNodes() {
            int n = 0;
            while (n < this.ROWS) {
                microrail.this.noStroke();
                int n2 = 0;
                while (n2 < this.COLS) {
                    int n3 = this.nodes[n][n2];
                    if (n3 != 0) {
                        if (n3 > 1) {
                            microrail.this.fill(64.0f, 64.0f, 200.0f);
                        } else {
                            microrail.this.fill(255);
                        }
                        microrail.this.ellipse(this.getScreenX(n2, n), this.getScreenY(n2, n), this.nodesize, this.nodesize);
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public void printNodes() {
            int n = 0;
            while (n < this.ROWS) {
                if (n % 2 == 1) {
                    microrail.print((String)" ");
                }
                int n2 = 0;
                while (n2 < this.COLS) {
                    microrail.print((String)(String.valueOf(this.nodes[n][n2]) + " "));
                    ++n2;
                }
                microrail.println((String)"");
                ++n;
            }
        }

        public float getScreenX(float f, float f2) {
            float f3 = this.centerX - this.xgap * (float)this.COLS / 2.0f;
            if (f2 % 2.0f == 1.0f) {
                f3 += this.xgap / 2.0f;
            }
            f3 += f * this.xgap;
            if (this.COLS == 5 || this.COLS == 9) {
                f3 += this.xgap / 2.0f;
            }
            return f3;
        }

        public float getScreenY(float f, float f2) {
            float f3 = this.centerY - this.ygap * (float)this.ROWS / 2.0f;
            return f3 += f2 * this.ygap + this.ygap / 2.0f;
        }

        public void addLinks() {
            microrail.this.stroke(128);
            microrail.this.strokeWeight(2.0f);
            int n = 0;
            while (n < this.ROWS) {
                int n2 = 0;
                while (n2 < this.COLS) {
                    if (this.nodes[n][n2] != 0) {
                        int n3 = n2 + 1;
                        int n4 = n;
                        this.tryToAddLink(n2, n, n3, n4);
                        n4 = n + 1;
                        n3 = n2;
                        if (n % 2 == 1) {
                            ++n3;
                        }
                        this.tryToAddLink(n2, n, n3, n4);
                        n3 = n2 - 1;
                        if (n % 2 == 1) {
                            ++n3;
                        }
                        this.tryToAddLink(n2, n, n3, n4);
                    }
                    ++n2;
                }
                ++n;
            }
        }

        public boolean areLiveNodes(int n, int n2, int n3, int n4) {
            int n5 = this.nodes[n2][n];
            int n6 = this.nodes[n4][n3];
            return n5 != microrail.this.DEADNODE && n6 != microrail.this.DEADNODE;
        }

        public void tryToAddLink(int n, int n2, int n3, int n4) {
            String string;
            int n5;
            int n6 = this.getNodeName(n, n2);
            if (n6 >= (n5 = this.getNodeName(n3, n4))) {
                microrail.println((String)("ERROR IN TRYTOADDLINK, NO *YOURE* OUT OF ORDER::" + n6 + " " + n5));
            }
            if (this.allLinkMap.get(string = String.valueOf(n6) + "_" + n5) != null) {
                return;
            }
            if (n3 >= 0 && n4 >= 0 && n3 < this.COLS && n4 < this.ROWS && this.areLiveNodes(n, n2, n3, n4)) {
                Link link = new Link(n, n2, n3, n4);
                link.checkIfFixed(this.fixedLinks);
                this.links.add(link);
                this.allLinkMap.put(link.name, link);
            }
        }

        public void drawLinks() {
            for (Link link : this.links) {
                link.draw(this == microrail.this.currentPuzzle);
            }
        }

        public void checkClick() {
            boolean bl = false;
            for (Link link : this.links) {
                if (!link.checkClick(this == microrail.this.currentPuzzle)) continue;
                bl = true;
            }
            if (bl && this.checkSolve()) {
                this.startTrain(this.startingNodeName);
                this.puzzleWon();
            }
        }

        public void puzzleWon() {
            microrail.this.fx_whistle();
            if (!microrail.this.seenArrowHint) {
                microrail.this.seenArrowHint = true;
                microrail.this.showArrowHint = true;
            }
            if (microrail.this.currentPuzzle != microrail.this.parentPuzzle) {
                int n = microrail.this.currentPuzzle.nodeTag;
                microrail.this.parentPuzzle.nodes[this.getNodeYFromName((int)n)][this.getNodeXFromName((int)n)] = microrail.this.SOLVENODE;
                microrail.this.parentPuzzle.printNodes();
                microrail.this.parentPuzzle.addLinks();
            } else {
                microrail.this.startMusic();
                microrail.this.wonIt = true;
            }
        }

        public void startTrain(int n) {
            this.trainLink = this.findSolveLinkForNode(n);
            this.moveVal = 0.0f;
            this.trainMoving = true;
            this.trainStartNode = n;
            this.trainEndNode = this.trainLink.getOtherNode(this.trainStartNode);
            this.trainReverseNodeName = this.findOtherGoalPoint(n);
        }

        public int findOtherGoalPoint(int n) {
            if (n == this.endingNodeName) {
                return this.startingNodeName;
            }
            return this.endingNodeName;
        }

        public void animateTrain() {
            if (this.trainMoving) {
                this.moveVal += 0.08f;
                if (this.moveVal >= 1.0f) {
                    this.moveVal = 0.0f;
                    if (this.trainEndNode != this.trainReverseNodeName) {
                        this.trainLink = this.findOtherSolveLink(this.trainEndNode, this.trainLink);
                        this.trainStartNode = this.trainEndNode;
                        this.trainEndNode = this.trainLink.getOtherNode(this.trainStartNode);
                    } else {
                        this.trainMoving = false;
                    }
                }
                if (!this.trainMoving) {
                    this.startTrain(this.trainReverseNodeName);
                }
                float f = microrail.lerp((float)this.getScreenX(this.getNodeXFromName(this.trainStartNode), this.getNodeYFromName(this.trainStartNode)), (float)this.getScreenX(this.getNodeXFromName(this.trainEndNode), this.getNodeYFromName(this.trainEndNode)), (float)this.moveVal);
                float f2 = microrail.lerp((float)this.getScreenY(this.getNodeXFromName(this.trainStartNode), this.getNodeYFromName(this.trainStartNode)), (float)this.getScreenY(this.getNodeXFromName(this.trainEndNode), this.getNodeYFromName(this.trainEndNode)), (float)this.moveVal);
                if (this.oldTrainX == null) {
                    this.oldTrainX = new float[this.TRAINHISTORY];
                    this.oldTrainY = new float[this.TRAINHISTORY];
                    int n = 0;
                    while (n < this.TRAINHISTORY) {
                        this.oldTrainX[n] = f;
                        this.oldTrainY[n] = f2;
                        ++n;
                    }
                } else {
                    int n = this.TRAINHISTORY - 2;
                    while (n >= 0) {
                        this.oldTrainX[n + 1] = this.oldTrainX[n];
                        this.oldTrainY[n + 1] = this.oldTrainY[n];
                        --n;
                    }
                    this.oldTrainX[0] = f;
                    this.oldTrainY[0] = f2;
                }
                microrail.this.fill(210.0f, 175.0f, 0.0f);
                microrail.this.ellipse(this.oldTrainX[6], this.oldTrainY[6], this.scaleBase * 0.3f, this.scaleBase * 0.3f);
                microrail.this.fill(230.0f, 195.0f, 0.0f);
                microrail.this.ellipse(this.oldTrainX[3], this.oldTrainY[3], this.scaleBase * 0.3f, this.scaleBase * 0.3f);
                microrail.this.fill(255.0f, 215.0f, 0.0f);
                microrail.this.ellipse(this.oldTrainX[0], this.oldTrainY[0], this.scaleBase * 0.3f, this.scaleBase * 0.3f);
            }
        }

        public void showHint() {
            Link object = null;
            for (Link object2 : this.links) {
                if (object2.mode != this.PICKED || this.solveLinks.get(object2.name) != null) continue;
                object = object2;
            }
            if (object != null) {
                object.xOut();
                return;
            }
            for (String string : this.solveLinks.keySet()) {
                Link link = this.solveLinks.get(string);
                Link link2 = this.allLinkMap.get(link.name);
                if (link2.mode == this.PICKED || this.fixedLinks.get(link.name) != null) continue;
                object = link2;
            }
            if (object != null) {
                object.oUp();
                return;
            }
        }

        public boolean checkSolve() {
            ArrayList<Link> arrayList = new ArrayList<Link>();
            boolean bl = true;
            for (Link link : this.links) {
                if (link.mode != this.PICKED && link.mode != this.FIXED) continue;
                arrayList.add(link);
                if (this.solveLinks.get(link.name) != null) continue;
                bl = false;
            }
            return bl && arrayList.size() == this.solveLinks.size();
        }

        public void store(int[][] nArray, HashMap<String, Link> hashMap) {
            int[][] nArray2 = nArray;
            int n = nArray.length;
            int n2 = 0;
            while (n2 < n) {
                int[] nArray3 = nArray2[n2];
                Link link = new Link(nArray3[0], nArray3[1]);
                hashMap.put(link.name, link);
                ++n2;
            }
        }

        public int getNodeName(int n, int n2) {
            return n + n2 * this.COLS;
        }

        public int getNodeXFromName(int n) {
            return n % this.COLS;
        }

        public int getNodeYFromName(int n) {
            return n / this.COLS;
        }

        public void recalcScale() {
            this.xgap = this.xgapMUL * this.scaleBase;
            this.ygap = this.ygapMUL * this.scaleBase;
            this.nodesize = this.nodesizeMUL * this.scaleBase;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Link {
            int mode;
            String name;
            int x;
            int y;
            int ex;
            int ey;
            float hoverRadius;
            float cx;
            float cy;

            Link(int n, int n2, int n3, int n4) {
                this.mode = Puzzle.this.POSSIBLE;
                this.x = n;
                this.y = n2;
                this.ex = n3;
                this.ey = n4;
                int n5 = Puzzle.this.getNodeName(this.x, this.y);
                int n6 = Puzzle.this.getNodeName(this.ex, this.ey);
                this.name = String.valueOf(n5) + "_" + n6;
                this.calcCenter();
            }

            public void checkIfFixed(HashMap<String, Link> hashMap) {
                if (hashMap.get(this.name) != null) {
                    this.mode = Puzzle.this.FIXED;
                }
            }

            public int getOtherNode(int n) {
                String[] stringArray = this.name.split("_");
                int n2 = microrail.parseInt((String)stringArray[0]);
                int n3 = microrail.parseInt((String)stringArray[1]);
                if (n == n2) {
                    return n3;
                }
                return n2;
            }

            Link(int n, int n2) {
                this(puzzle.getNodeXFromName(n), puzzle.getNodeYFromName(n), puzzle.getNodeXFromName(n2), puzzle.getNodeYFromName(n2));
            }

            public boolean matches(Link link) {
                return this.name.equals(link.name);
            }

            public void xOut() {
                this.cx = (Puzzle.this.getScreenX(this.x, this.y) + Puzzle.this.getScreenX(this.ex, this.ey)) / 2.0f;
                this.cy = (Puzzle.this.getScreenY(this.x, this.y) + Puzzle.this.getScreenY(this.ex, this.ey)) / 2.0f;
                microrail.this.strokeWeight(6.0f);
                microrail.this.stroke(200.0f, 30.0f, 30.0f);
                microrail.this.line(this.cx - 15.0f, this.cy - 15.0f, this.cx + 15.0f, this.cy + 15.0f);
                microrail.this.line(this.cx + 15.0f, this.cy - 15.0f, this.cx - 15.0f, this.cy + 15.0f);
            }

            public void oUp() {
                this.cx = (Puzzle.this.getScreenX(this.x, this.y) + Puzzle.this.getScreenX(this.ex, this.ey)) / 2.0f;
                this.cy = (Puzzle.this.getScreenY(this.x, this.y) + Puzzle.this.getScreenY(this.ex, this.ey)) / 2.0f;
                microrail.this.strokeWeight(6.0f);
                microrail.this.stroke(200.0f, 30.0f, 30.0f);
                microrail.this.noFill();
                microrail.this.ellipse(this.cx, this.cy, 30.0f, 30.0f);
            }

            public void draw(boolean bl) {
                this.calcCenter();
                microrail.this.strokeWeight(2.0f);
                microrail.this.stroke(200);
                if (this.mode == Puzzle.this.FIXED) {
                    microrail.this.stroke(0);
                }
                float f = Puzzle.this.getScreenX(this.x, this.y);
                float f2 = Puzzle.this.getScreenY(this.x, this.y);
                float f3 = Puzzle.this.getScreenX(this.ex, this.ey);
                float f4 = Puzzle.this.getScreenY(this.ex, this.ey);
                if (!this.isMouseOver(bl) && this.mode == Puzzle.this.POSSIBLE) {
                    microrail.this.strokeWeight(2.0f);
                    microrail.this.line(f, f2, f3, f4);
                } else {
                    float f5 = 255.0f;
                    if (this.isMouseOver(bl) && this.mode == Puzzle.this.POSSIBLE) {
                        f5 = 100.0f;
                        ((Puzzle)Puzzle.this).microrail.this.doHand = true;
                    }
                    microrail.this.pushMatrix();
                    float f6 = microrail.atan2((float)(f4 - f2), (float)(f3 - f));
                    microrail.this.translate(f, f2);
                    microrail.this.rotate(f6);
                    float f7 = Puzzle.this.scaleBase * 0.6f;
                    if (this.mode == Puzzle.this.FIXED) {
                        microrail.this.strokeWeight(4.0f);
                    } else {
                        microrail.this.strokeWeight(2.0f);
                    }
                    microrail.this.stroke(120.0f, 120.0f, 0.0f, f5);
                    int n = 7;
                    int n2 = 1;
                    while (n2 < n) {
                        float f8 = (float)n2 * f7 / (float)n;
                        microrail.this.line(f8, -f7 / 14.0f, f8, f7 / 14.0f);
                        ++n2;
                    }
                    if (this.mode == Puzzle.this.FIXED) {
                        microrail.this.strokeWeight(3.0f);
                    } else {
                        microrail.this.strokeWeight(1.0f);
                    }
                    microrail.this.stroke(50, f5);
                    microrail.this.line(0.0f, -f7 / 20.0f, f7, -f7 / 20.0f);
                    microrail.this.line(0.0f, f7 / 20.0f, f7, f7 / 20.0f);
                    microrail.this.popMatrix();
                }
            }

            public void calcCenter() {
                this.cx = (Puzzle.this.getScreenX(this.x, this.y) + Puzzle.this.getScreenX(this.ex, this.ey)) / 2.0f;
                this.cy = (Puzzle.this.getScreenY(this.x, this.y) + Puzzle.this.getScreenY(this.ex, this.ey)) / 2.0f;
                this.hoverRadius = (Puzzle.this.xgap + Puzzle.this.ygap) / 8.0f;
            }

            public void drawCenter() {
                microrail.this.strokeWeight(1.0f);
                microrail.this.stroke(0);
                microrail.this.noFill();
                microrail.this.ellipse(this.cx, this.cy, this.hoverRadius * 2.0f, this.hoverRadius * 2.0f);
            }

            public boolean checkClick(boolean bl) {
                if (Puzzle.this.trainMoving) {
                    return false;
                }
                if (this.isMouseOver(bl)) {
                    if (this.mode == Puzzle.this.POSSIBLE) {
                        microrail.this.fx_scratch();
                        this.mode = Puzzle.this.PICKED;
                        return true;
                    }
                    if (this.mode == Puzzle.this.PICKED) {
                        this.mode = Puzzle.this.POSSIBLE;
                        return true;
                    }
                }
                return false;
            }

            public boolean isMouseOver(boolean bl) {
                if (!bl) {
                    return false;
                }
                if (Puzzle.this.trainMoving) {
                    return false;
                }
                return microrail.dist((float)((Puzzle)Puzzle.this).microrail.this.mouseX, (float)((Puzzle)Puzzle.this).microrail.this.mouseY, (float)this.cx, (float)this.cy) < this.hoverRadius;
            }
        }
    }
}

