// --- help ---

const char *wormdes = 
  "These huge monsters normally live below the sand, but your movements have "
  "disturbed them. They are too big to be slain with your "
  "weapons, but you can defeat them by making them unable to move. "
  "This also produces some Spice. They move two times slower than you.";

const char *tentdes = 
  "The tentacles of Cthulhu are like sandworms, but longer.";

const char *ivydes = 
  "A huge plant growing in the Jungle. Each Ivy has many branches, "
  "and one branch grows per each of your moves. Branches grow in a clockwise "
  "order. The root itself is vulnerable.";

const char *slimehelp =
  "The Alchemists produce magical potions from pools of blue and red slime. You "
  "can go through these pools, but you cannot move from a blue pool to a red "
  "pool, or vice versa. Slime beasts also have to keep to their own color, "
  "but when they are killed, they explode, and change the color of the slime "
  "around them.";

const char *trollhelp =
  "A big monster from the Living Caves. A dead Troll will be reunited "
  "with the rocks, causing some walls to grow around its body.";

const char *barrierhelp = 
  "Huge, impassable walls which separate various lands.";

const char *cavehelp =
  "This cave contains walls which are somehow living. After each turn, each cell "
  "counts the number of living wall and living floor cells around it, and if it is "
  "currently of a different type than the majority of cells around it, it switches. "
  "Gold counts as two floor cells, and dead Trolls count as five wall cells.";

// --- monsters ---

const int motypes = 42;

struct monstertype {
  char  glyph;
  int   color;
  const char *name;
  const char *help;
  };

monstertype minf[motypes] = {
  { 0,   0,        "none"       , NULL},
  { 'Y', 0x4040FF, "Yeti"       ,
    "A big and quite intelligent monster living in the Icy Lands."
  },
  { 'W', 0xD08040, "Icewolf"    ,
    "A nasty predator from the Icy Lands. Contrary to other monsters, "
    "it tracks its prey by their heat."
  },
  { 'W', 0xD08040, "Icewolf"    , ""},
  { 'R', 0xFF8000, "Ranger"     ,
    "Crossroad Rangers normally protect the Crossroads from being overrun by monsters. "
    "However, they consider YOU more dangerous, so they will attack you instead. "
    "Rangers also protect the magic mirrors in the Land of Mirrors."
    },
  { 'T', 0xD0D0D0, "Rock Troll", trollhelp},
  { 'G', 0x20D020, "Goblin",     
    "A nasty creature native to the Living Caves. They don't like you "
    "for some reason."
    },
  { 'S', 0xE0E040, "Sand Worm", wormdes },
  { 's', 0x808000, "Sand Worm Tail", wormdes },
  { 'S', 0x808000, "Sand Worm W", wormdes },
  { 'z', 0x808000, "Sand Worm M", wormdes },
  { 'M', 0x505050, "Desert Man",
    "A tribe of men native to the Desert. They have even tamed the huge Sandworms, who won't attack them."},
  { 'C', 0x00FFFF, "Ivy Root", ivydes},
  { 'C', 0xFFFF00, "Active Ivy", ivydes},
  { 'C', 0x40FF00, "Ivy Branch", ivydes},
  { 'C', 0x006030, "Dormant Ivy", ivydes},
  { 'C', 0x800000, "Ivy N", ivydes},
  { 'C', 0x800000, "Ivy D", ivydes},
  { 'M', 0x804000, "Giant Ape",
    "This giant ape thinks that you are an enemy."},
  { 'B', 0x909000, "Slime Beast", slimehelp},
  { '@', 0x8080FF, "Mirror Image",
    "A magical being which copies your movements."
    },
  { '@', 0xFF8080, "Mirage",
    "A magical being which copies your movements. "
    "You feel that it would be much more useful in an Euclidean space."
    },
  { '@', 0x509050, "Golem",
    "You can summon these friendly constructs with a magical process."
    },
  { '@', 0x509050, "Golem",
    "You can summon these friendly constructs with a magical process."
    },
  { 'E', 0xD09050, "Eagle",
    "A majestic bird, who is able to fly very fast."
    },
  { 'S', 0xFF8080, "Seep",
    "A monster who is able to live inside the living cave wall."
    },
  { 'Z', 0x804000, "Zombie",
    "A typical Graveyard monster."
    },
  { 'G', 0xFFFFFF, "Ghost",
    "A typical monster from the Graveyard, who moves through walls."
    },
  { 'N', 0x404040, "Necromancer",
    "Necromancers can raise zombies from graves."
    },
  { 'S', 0x404040, "Shadow",
    "A creepy monster who follows you everywhere in the Graveyard."
    },
  { 'T', 0x40E040, "Tentacle", tentdes },
  { 't', 0x008000, "Tentacle Tail", tentdes },
  { 'T', 0x008000, "Tentacle W", tentdes },
  { 'z', 0x008000, "Tentacle M", tentdes },
  { 'P', 0xFF8000, "Cultist", 
    "People worshipping Cthulhu. They are very dangerous." 
    },
  { 'P', 0xFFFF00, "Fire Cultist", 
    "People worshipping Cthulhu. This one is especially dangerous, as he is armed with a weapon which launches "
    "fire from afar.\n"
    },
  { 'D', 0xFF0000, "Greater Demon", 
    "These creatures are slow, but very powerful. You need some experience in demon fighting to slay them." },
  { 'D', 0x800000, "Greater Demon", 
    "These creatures are slow, but very powerful. You need some experience in demon fighting to slay them." },
  { 'd', 0xFF2020, "Lesser Demon", 
    "These creatures are slow, but they often appear in large numbers."
    },
  { 'd', 0x802020, "Lesser Demon", 
    "These creatures are slow, but they often appear in large numbers."
    },
  { 'S', 0xC000C0, "Demon Shark", 
    "Dangerous predator living in the waters of Cocytus."
    },
  { 'W', 0xFFFFFF, "Running Dog", 
    "This white dog is able to run all the time. It is the only creature "
    "able to survive and breed in the Land of Eternal Motion."
    }
  };

enum eMonster { 
  moNone, 
  moYeti, moWolf, moWolfMoved, 
  moRanger, 
  moTroll, moGoblin, 
  moWorm, moWormtail, moWormwait, moWormMoved, 
  moDesertman, 
  moIvyRoot, moIvyHead, moIvyBranch, moIvyWait, moIvyNext, moIvyDead,
  moMonkey,
  moSlime,
  moMirror, moMimic, moGolem, moGolemMoved,
  moEagle, moSeep,
  moZombie, moGhost, moNecromancer, moShadow,
  moTentacle, moTentacletail, moTentaclewait, moTentacleMoved, 
  moCultist, moPyroCultist,
  moGreater, moGreaterM, moLesser, moLesserM,
  moShark, moRunDog
  };

// --- items ----

const int ittypes = 23;

struct itemtype {
  char  glyph;
  int   color;
  const char *name;
  const char *help;
  };

itemtype iinf[ittypes] = {
  { 0,   0,        "none",       NULL},
  { '*', 0xFFFFFF, "Ice Diamond", 
    "Cold blue gems, found in the Icy Lands."
    },
  { '$', 0xFFD700, "Gold",       
    "An expensive metal from the Living Caves. For some reason "
    "gold prevents the living walls from growing close to it."
    },
  { ';', 0xFF4000, "Spice",      
    "A rare and expensive substance found in the Desert. "
    "It is believed to extend life and raise special psychic powers."
    },
  { '*', 0xC00000, "Ruby",
    "A beautiful gem from the Jungle."
    },
  { '!', 0xFFFF00, "Elixir of Life",
    "A wonderful beverage, apparently obtained by mixing red and blue slime. You feel definitely better more "
    "healthy after drinking it, but you still fell that one hit of a monster is enough to kill you."},
  { '%', 0xFF00FF, "Shard",
    "A piece of a magic mirror. Can be used for magical purposes."},
  { '/', 0xFF8000, "Necromancer's Totem",
    "These sinister totems contain valuable gems."},
  { '%', 0x00D000, "Demon Daisy",
    "These star-shaped flowers native to Hell are a valuable alchemical component."},
  { '/', 0x00FF00, "Statue of Cthulhu",
    "This statue is made of materials which cannot be found in your world."},
  { '*', 0x8080FF, "Ice Sapphire", 
    "Cold blue gems, found in the Cocytus."
    },
  { '*', 0xFF8000, "Phoenix Feather", 
    "The only thing that does not cause the floor in the Land of Motion to collapse. Obviously they are quite valuable."
    },
  { '[', 0x8080FF, "Key", 
    "That's all you need to unlock the Orb of Yendor!"
    },
  { 'o', 0x306030, "Dead Orb",
    "These orbs can be found in the Graveyard. You think that they were once powerful magical orbs, but by now, their "
    "power is long gone. No way to use them, you could as well simply drop them...\n\n"
#ifdef ANDROID
    "You can touch the Dead Orb in your inventory to drop it."
#else
    "You can press 'g' or click them in the list to drop a Dead Orb."
#endif
    },
  { 'o', 0xFFFF00, "Orb of Lightning",
    "This orb can be used to invoke the lightning spell, which causes lightning bolts to shoot from you in all directions."},
  { 'o', 0xFFFFFF, "Orb of Flash",
    "This orb can be used to invoke a flash spell, which destroys almost everything in radius of 2."},
  { 'o', 0x8080FF, "Orb of Winter",
    "This orb can be used to invoke a wall of ice. Only works in the Icy Lands."},
  { 'o', 0xFF6060, "Orb of Speed",
    "This orb can be used to move faster for some time."},
  { 'o', 0x90A090, "Orb of Life",
    "This orb can be used to summon friendly golems."},
  { 'o', 0x60D760, "Orb of Shielding",
    "This orb can be protect you from damage."},
  { 'o', 0x606060, "Orb of Digging",
    "This orb lets you go through the living wall. Only works in the Living Caves."},
  { 'o', 0x20FFFF, "Orb of Teleport",
    "This orb lets you instantly move to another location on the map. Just click a location which "
    "is not next to you to teleport there."},
  { 'o', 0xFF20FF, "Orb of Yendor",
    "This wonderful Orb can only be collected by those who have truly mastered this hyperbolic universe, "
    "as you need a key to unlock it. Luckily, your psychic abilities will let you know "
    "where the key is after you touch the Orb." }
  };

enum eItem { itNone, itDiamond, itGold, itSpice, itEmerald, itElixir, itShard, itBone, itHell, itStatue,
  itSapphire, itFeather, itKey,
  itGreenStone,
  itOrbLightning, itOrbFlash, itOrbWinter, itOrbSpeed, itOrbLife, itOrbShield, itOrbDigging,
  itOrbTeleport, itOrbYendor
  };

eItem firstorb = itOrbLightning;

// --- wall types ---

const int walltypes = 23;

struct walltype {
  char  glyph;
  int   color;
  const char *name;
  const char *help;
  };

const char *lakeDesc = "Hell has these lakes everywhere... They are shaped like evil stars, and filled with burning sulphur.";

walltype winf[walltypes] = {
  { '.', 0xFF00FF, "none",        NULL},
  { '#', 0x8080FF, "ice wall",    "Ice Walls melt after some time has passed."},
  { '#', 0xC06000, "great wall",  barrierhelp},
  { '+', 0x900030, "red slime",  slimehelp },
  { '+', 0x300090, "blue slime",   slimehelp },
  { '#', 0xA0D0A0, "living wall", cavehelp},
  { '.', 0x306060, "living floor",cavehelp},
  { '#', 0xD03030, "dead troll",  trollhelp},
  { '#', 0xCDA98F, "sand dune",   "A natural terrain feature of the Desert."},
  { '%', 0xC0C0FF, "Magic Mirror","You can go inside the Magic Mirror, and produce some mirror images to help you."},
  { '%', 0xFFC0C0, "Cloud of Mirage",
    "Tiny droplets of magical water. You see images of yourself inside them. Go inside the cloud, to make these "
    "images help you."},
  { '^', 0x8D694F, "Thumper",
     "A device that attracts sandworms and other enemies. You need to activate it."},
  { '^', 0x804000, "Bonfire",
    "A heap of wood that can be used to start a fire. Everything is already here, you just need to touch it to fire it."},
  { '+', 0xC0C0C0, "ancient grave", "An ancient grave." },
  { '+', 0xD0D080, "fresh grave", "A fresh grave." },
  { '#', 0x00FFFF, "column", "A piece of architecture typical to R'Lyeh." },
  { '=', 0xFFFF00, "lake of sulphur", lakeDesc },
  { '=', 0xFFFF00, "lake of sulphur", lakeDesc },
  { '=', 0x000080, "lake", "An impassable lake in Cocytus." },
  { '_', 0x000080, "frozen lake", "You can walk on it... but beware." },
  { '>', 0x101010, "chasm", "It was a floor..." },
  { '>', 0x101010, "chasmD", "It was a floor..." }
  };

enum eWall { waNone, waIcewall, waBarrier, waFloorA, waFloorB, waCavewall, waCavefloor, waDeadTroll, waDune,
  waMirror, waCloud, waThumper, waBonfire, waAncientGrave, waFreshGrave, waColumn, waSulphurC, waSulphur,
  waLake, waFrozenLake, waChasm, waChasmD };

// --- land types ---

const int numLands = 12;
const int landtypes = numLands + 2;

struct landtype {
  int color;
  const char *name;
  const char *help;
  };

landtype linf[landtypes] = {
  { 0xFF00FF, "???"          , ""},
  { 0xC06000, "Great Wall"   , ""},
  { 0xFF0000, "Crossroads"   , 
    "This land is a quick gateway to other lands. It is very easy to find other six types of lands "
    "from the Crossroads. Beware the Crossroad Rangers!\n\n"
    "As long as you have found enough treasure in their native lands, you can "
    "find magical items in the Crossroads. Mirror Land brings mirrors and clouds, "
    "and other land types bring magical orbs. Living Caves and Icy Lands contain "
    "two types of orbs each, but only one of them appears on the Crossroads, "
    "since the other one only makes sense in its native land."
    },
  { 0xCDA98F, "Desert",
    "A hot land, full of sand dunes, mysterious Spice, and huge and dangerous sand worms."
    },
  { 0x8080FF, "Icy Lands",
    "A very cold land, full of ice walls. Your mere presence will cause these ice walls to "
    "melt, even if you don't want it."
    },
  { 0x306060, "Living Caves", cavehelp},
  { 0x00C000, "Jungle",
    "It might look like a huge grassland at first, but once you start gathering its "
    "rubies, you will find yourself surrounded by huge ivy plants."
    },
  { 0x900090, "Alchemist Lab", slimehelp},
  { 0x704070, "Mirror Land",
    "A strange land which contains mirrors and mirages, protected by Mirror Rangers."},
  { 0x404070, "Graveyard",
    "All the monsters you kill are carried to this strange land, and buried."
    },
  { 0x00FF00, "R'Lyeh",
    "An ancient sunken city which can be reached only when the stars are right."
    },
  { 0xC00000, "Hell",
    "A land filled with demons and molten sulphur. Abandon all hope ye who enter here!"
    },
  { 0x00FF00, "Cocytus",
    "A hellish version of the Icy Lands. Now, your body heat melts the floor, not the walls."
    },
  { 0xFFFF00, "Land of Eternal Motion",
    "A land where you cannot stop, because every piece of floor is extremely unstable. Only monsters who "
    "can run forever are able to survive there, and only phoenix feathers are so light that they do not disturb "
    "the floor.\n"
    }
  };

enum eLand { laNone, laBarrier, laCrossroads, laDesert, laIce, laCaves, laJungle, laAlchemist, laMirror, laGraveyard,
  laRlyeh, laHell, laCocytus, laMotion };

// cell information for the game

struct gcell {
  eWall wall : 5;
  eItem item : 5;
  eLand land : 4;
  eMonster monst : 6;
  eLand barleft : 4, barright : 4;
  unsigned cpdist : 5, mpdist : 5, pathdist : 10;
  unsigned bardir : 3;
  unsigned mondir : 3;
  unsigned ligon : 1;
  short tmp;
  float heat;
  };

#define NODIR 7
