// Hyperbolic Rogue
// Copyright (C) 2011-2012 Zeno Rogue, see 'hyper.cpp' for details

#define DEB(x) // printf("%s\n", x);

// game state
int items[ittypes], kills[motypes], explore[10];
bool playerdead = false;
bool playermoved = false; // center on the PC?

#define INF  9999
#define INFD 20

void initcell(cell *c) {
  c->mpdist = INFD;   // minimum distance from the player, ever
  c->cpdist = INFD;   // current distance from the player
  c->pathdist = INFD; // current distance from the player, along paths (used by yetis)
  c->heat = 0;
  c->wall  = waNone;
  c->item  = itNone;
  c->monst = moNone;
  c->bardir = NODIR;
  c->land = laNone;
  c->tmp = -1;
  c->ligon = 0;
  }

int gold() {
  return 
    items[itDiamond] + items[itGold] + items[itSpice] + items[itEmerald] + items[itElixir] +
    items[itShard];
  }

int tkills() {
  return 
    kills[moYeti] + kills[moWolf] + 
    kills[moRanger] + kills[moTroll] + kills[moGoblin] +
    kills[moWorm] + kills[moDesertman] + kills[moIvyRoot] +
    kills[moMonkey] + kills[moEagle] + kills[moSlime] + kills[moSeep];
  }
  
cellwalker cwt; // player character position

bool passable(cell *w) {
  return 
    w->wall == waNone || 
    w->wall == waFloorA || w->wall == waFloorB || 
    w->wall == waCavefloor || 
    w->wall == waMirror || w->wall == waCloud;
  }

bool alblocked(cell *c, cell *from = NULL) {
  if(c->wall == waFloorA && from && from->wall == waFloorB)
    return true;
  if(c->wall == waFloorB && from && from->wall == waFloorA)
    return true;
  return false;
  }

bool cblocked(cell *c) {
  return c->monst || !passable(c) || c->wall == waMirror || c->wall == waCloud;
  }

bool isActiv(cell *c) {
  return c->wall == waThumper || c->wall == waBonfire;
  }

bool isMimic(cell *c) {
  return c->monst == moMirror || c->monst == moMimic;
  }

bool isFriendly(cell *c) {
  return c->monst == moMirror || c->monst == moMimic || c->monst == moGolem || c->monst == moGolemMoved;
  }

bool isIvy(cell *c) {
  return c->monst == moIvyRoot || c->monst == moIvyHead || c->monst == moIvyBranch || c->monst == moIvyWait ||
    c->monst == moIvyNext;
  }

bool isWorm(cell *c) {
  return c->monst == moWorm || c->monst == moWormtail || c->monst == moWormwait || c->monst == moWormMoved;
  }

void useup(cell *c) {
  c->tmp--;
  if(c->tmp == 0) c->wall = waNone;
  }

bool enemy(cell *w, cell *killed) {
  if(w == killed) return false;
  if(isFriendly(w)) return false;
  if(w->monst == moNone || w->monst == moWormtail || w->monst == moWormwait)
    return false;
  if(w->monst == moIvyRoot || w->monst == moIvyWait || w->monst == moIvyNext || w->monst == moIvyDead)
    return false;
  if(w->monst == moIvyHead || w->monst == moIvyBranch) {
    while(w != killed && w->mondir != NODIR) w = w->mov[w->mondir];
    return w != killed;
    }
  return true;
  }

// how many monsters are near
eMonster which;

bool mirrorkill(cell *c) {
  for(int t=0; t<c->type; t++) 
    if(c->mov[t] && isMimic(c->mov[t]) && c->mov[t]->mov[c->mov[t]->mondir] == c)
      return true;
  return false;
  }

int monstersnear(cell *c, cell *nocount = NULL, bool shielded = true) {
  int res = 0;
  if(shielded) {
    if(items[itOrbShield] > 1) return 0;
    if(items[itOrbSpeed]  && !(items[itOrbSpeed] & 1)) return 0;
    }
  for(int t=0; t<c->type; t++) 
    if(c->mov[t] && enemy(c->mov[t], nocount) && !(nocount && mirrorkill(c->mov[t])))
      res++, which = c->mov[t]->monst;
  return res;
  }

// reduce c->mpdist to d; also generate the landscape

bool checkBarriersBack(cellwalker& bb);

bool checkBarriersFront(cellwalker& bb) {
  if(bb.c->mpdist < 10) return false;
  if(bb.c->bardir != NODIR) return false;
  if(bb.spin == 0) return true;

  if(1) for(int i=0; i<7; i++) {
    cellwalker bb2 = bb;
    cwspin(bb2, i); cwstep(bb2); cwspin(bb2, 4); cwstep(bb2);
    if(bb2.c->bardir != NODIR) return false;
    }

  cwstep(bb); cwspin(bb, 3); cwstep(bb); cwspin(bb, 3); cwstep(bb);
  return checkBarriersBack(bb);
  }

bool checkBarriersBack(cellwalker& bb) {
  if(bb.c->mpdist < 10) return false;
  if(bb.c->bardir != NODIR) return false;
  if(bb.spin == 0 && bb.c->mpdist == INFD) return true;
  
  if(1) for(int i=0; i<7; i++) {
    cellwalker bb2 = bb;
    cwspin(bb2, i); cwstep(bb2); cwspin(bb2, 4); cwstep(bb2);
    if(bb2.c->bardir != NODIR) return false;
    }

  cwspin(bb, 3); cwstep(bb); cwspin(bb, 4); cwstep(bb); cwspin(bb, 3); 
  return checkBarriersFront(bb);
  }

void setbarrier(cell *c) {
  c->wall = waBarrier;
  c->land = laBarrier;
  }

void buildIvy(cell *c, int qty) {
  c->mondir = NODIR;
  c->monst = moIvyRoot;

  int leaf = 0;
  for(int i=0; i<c->type; i++) {
    createMov(c, i);
    if(!cblocked(c->mov[i])) {
      if(qty) buildIvy(c->mov[i], qty-1), qty = 0;
      else 
        c->mov[i]->monst = (leaf++) ? moIvyWait : moIvyHead,
        c->mov[i]->mondir = c->spn[i];
      }
    }
  if(!leaf) c->monst = moMonkey;
  }

bool isIcy(cell *c) {
  return c->wall == waNone || c->wall == waIcewall;
  }

void killIvy(cell *c) {
  for(int i=0; i<c->type; i++)
    if(c->mov[i]->mondir == c->spn[i] && isIvy(c->mov[i]))
      killIvy(c->mov[i]);
  c->monst = moIvyDead;
  }

void spill(cell* c, eWall t, int rad) {
  if(c->land != laAlchemist) return;
  c->wall = t;
  if(rad) for(int i=0; i<c->type; i++) if(c->mov[i])
    spill(c->mov[i], t, rad-1);
  }

void killMonster(cell *c) {
  DEB("killmonster");
  if(!c->monst) return;
  if(isWorm(c)) return;
  kills[c->monst]++;

  if(c->monst == moTroll) c->wall = waDeadTroll, c->item = itNone;
  if(c->monst == moSlime) spill(c, c->wall, 2);
  if(isIvy(c)) {
    eMonster m = c->monst;
    /*if((m == moIvyBranch || m == moIvyHead) && c->mov[c->mondir]->monst == moIvyRoot)
      ivynext(c, moIvyNext); */
    killIvy(c);
    if(m == moIvyBranch || m == moIvyHead || m == moIvyNext) {
      if(c->mov[c->mondir]->monst == moIvyRoot) 
        c->monst = moIvyNext;
      else
        c->mov[c->mondir]->monst = moIvyHead;
      }
    }
  else c->monst = moNone;

  }

bool orbChance(cell *c, eLand usual, int chthere, int chcross) {
  if(c->land == usual) return rand() % chthere == 0;
  if(chcross && c->land == laCrossroads) return rand() % chcross == 0;
  return false;
  }

void buildBarrier(cell *c) {
  if(c->wall == waBarrier) return;
  if(c->mpdist == INFD) return;

  cellwalker bb(c, c->bardir); setbarrier(bb.c);
  cwstep(bb); setbarrier(bb.c);
  cwspin(bb, 2); cwstep(bb); bb.c->land = c->barleft; cwstep(bb);
  cwspin(bb, 2); cwstep(bb); bb.c->land = c->barright; cwstep(bb);
  cwspin(bb, 2); 
  
  cwspin(bb, 3); cwstep(bb); setbarrier(bb.c);
  cwspin(bb, 3); cwstep(bb);
  
  bb.c->bardir = bb.spin;
  bb.c->barleft = c->barright;
  bb.c->barright = c->barleft;
  buildBarrier(c);
  
  for(int a=-3; a<=3; a++) if(a) {
    bb.c = c; bb.spin = c->bardir; cwspin(bb, a); cwstep(bb); 
    bb.c->land = a > 0 ? c->barright : c->barleft;
    }

  bb.c = c; bb.spin = c->bardir;
  cwspin(bb, 3); cwstep(bb); cwspin(bb, 4); bb.c->land = c->barright; cwstep(bb); cwspin(bb, 3);
  bb.c->bardir = bb.spin;
  bb.c->barleft = c->barright;
  bb.c->barright = c->barleft;
  buildBarrier(c);
  }

void setdist(cell *c, int d, cell *from) {
  if(signed(c->mpdist) <= d) return;
  c->mpdist = d;
  
  if(d == 10) {
    if(!c->land) c->land = from->land;
    
    if(c->type == 7 && rand() % 10000 < (c->land == laCrossroads ? 5000 : 50)) {
    
      int bd = 2 + (rand() % 2) * 3;
      
      cellwalker bb(c, bd);
      cellwalker bb2 = bb;

      if(checkBarriersFront(bb) && checkBarriersBack(bb2)) {
        c->bardir = bd;
        eLand oldland = c->land;
        eLand newland = oldland;
        while(newland == oldland)
          newland = eLand(2 + rand() % numLands);

        if(bd == 5) c->barleft = oldland, c->barright = newland;
        else c->barleft = newland, c->barright = oldland;
        }
      }
    
    if(c->bardir != NODIR) 
      buildBarrier(c);    
    }
  
  if(d < 10) {
    explore[d]++;
    for(int i=0; i<c->type; i++) {
      createMov(c, i);
      setdist(c->mov[i], d+1, c);
      }
    
    if(d == 9) {
    
      if(c->land == laIce) if(rand() % 100 < 5 && c->wall != waBarrier) {
        c->wall = waIcewall;
        for(int i=0; i<c->type; i++) if(rand() % 100 < 50) {
          createMov(c, i);
          cell *c2 = c->mov[i];
          if(c2->wall == waBarrier || c2->land != laIce) continue;
          c2->wall = waIcewall;
          for(int j=0; j<c2->type; j++) if(rand() % 100 < 20) {
            createMov(c2, j);
            cell *c3 = c2->mov[j];
            if(c3->wall == waBarrier || c2->land != laIce) continue;
            c3->wall = waIcewall;
            }
          }
        }

      if(c->land == laIce) if(c->wall == waIcewall && items[itDiamond] >= 5 && rand() % 200 == 1)
        c->wall = waBonfire;

      if(c->land == laCaves) 
        c->wall = rand() % 100 < 55 ? waCavewall : waCavefloor;
      
      if(c->land == laAlchemist) 
        c->wall = rand() % 2 ? waFloorA : waFloorB;
      
      if(c->land == laDesert) {
        if(rand() % 100 < 5) {
          for(int i=0; i<c->type; i++)
            if(c->mov[i] && c->mov[i]->land == laDesert)
              c->mov[i]->wall = waDune;
          
          for(int j=0; j<2; j++) {
            int i = rand() % c->type;
            if(c->mov[i] && c->mov[i]->land == laDesert)
              c->mov[i]->wall = waNone;
            }
          }

        if(rand() % 300 == 1 && items[itSpice] >= 5) c->wall = waThumper;
        }
      }
    
    if(d == 7 && c->wall == waCavewall && rand() % 5000 < items[itGold])
      c->monst = moSeep;
    
    if(d == 7 && passable(c)) {
      if(c->land == laBarrier) c->wall = waBarrier;
      if(c->land == laIce) {
        if(rand() % 5000 < 100 + 2 * (kills[moYeti] + kills[moWolf]))
          c->item = itDiamond;
        if(rand() % 5000 < 2 * items[itDiamond])
          c->monst = rand() % 2 ? moYeti : moWolf;
        }
      if(c->land == laCrossroads) {
        if(rand() % 5000 < gold())
          c->monst = moRanger;
        if(c->type == 6 && rand() % 5000 < 120 && items[itShard] >= 5)
          c->wall = rand() % 2 ? waMirror : waCloud;
        }
      if(c->land == laCaves) {
        if(rand() % 5000 < 100 + 2 * (kills[moTroll] + kills[moGoblin]))
          c->item = itGold;
        if(rand() % 5000 < 10 + 2 * items[itGold])
          c->monst = rand() % 2 ? moTroll : moGoblin;
        }
      if(c->land == laDesert) {
        if(rand() % 5000 < 100 + 2 * (kills[moWorm] + kills[moDesertman]))
          c->item = itSpice;
        if(rand() % 5000 < 10 + 2 * items[itSpice])
          c->monst = rand() % 2 ? moWorm : moDesertman;
        }
      if(c->land == laJungle) {
        if(rand() % 5000 < 25 + 2 * (kills[moIvyRoot] + kills[moMonkey]))
          c->item = itEmerald;
        if(rand() % 10000 < 10 + 2 * items[itEmerald])
          c->monst = moMonkey;
        else if(rand() % 30000 < 5 + items[itEmerald])
          c->monst = moEagle;
        else if(c->type == 7 && rand() % 4000 < 2 * items[itEmerald]) 
          buildIvy(c, 1);
        }
      if(c->land == laAlchemist) {
        if(rand() % 5000 < 25 + kills[moSlime])
          c->item = itElixir;
        else if(rand() % 2500 < 10 + items[itElixir])
          c->monst = moSlime;
        }
      if(c->land == laMirror) {
        if(c->type == 6 && rand() % 5000 < 120)
          c->wall = rand() % 2 ? waMirror : waCloud;
        if(rand() % 4000 < 5 + items[itShard])
          c->monst = moRanger;
        else if(rand() % 30000 < 5 + items[itShard])
          c->monst = moEagle;
        }
      if(!c->item) {
        if(orbChance(c, laJungle, 2500, 400) && items[itEmerald] >= 10)
          c->item = itOrbLightning;
        if(orbChance(c, laIce, 2500, 400) && items[itDiamond] >= 10)
          c->item = itOrbFlash;
        if(orbChance(c, laCaves, 1800, 2000) && items[itGold] >= 10)
          c->item = itOrbLife;
        if(orbChance(c, laAlchemist, 500, 400) && items[itElixir] >= 10)
          c->item = itOrbSpeed;
        if(orbChance(c, laDesert, 2500, 400) && items[itSpice] >= 10)
          c->item = itOrbShield;

        if(orbChance(c, laIce, 1500, 0) && items[itDiamond] >= 10)
          c->item = itOrbWinter;
        if(orbChance(c, laCaves, 1200, 0) && items[itGold] >= 10)
          c->item = itOrbDigging;
        }
      }

    }
  }

vector<cell*> dcal;  // queue for cpdist
vector<cell*> pathq; // queue for pathdist

vector<cell*> mirrorlist;  // mirror list

// calculate cpdist and pathdist
void bfs() {
  
  for(int i=0; i<size(dcal); i++) dcal[i]->cpdist = INFD;
  dcal.clear();
  mirrorlist.clear();
  
  for(int i=0; i<size(pathq); i++) pathq[i]->pathdist = INFD;
  pathq.clear();
  pathq.push_back(cwt.c);
  cwt.c->pathdist = 0;

  dcal.push_back(cwt.c);
  cwt.c->cpdist = 0;
  int qb = 0;
  while(qb < size(dcal)) {
    cell *c = dcal[qb++];
    if(isMimic(c)) mirrorlist.push_back(c);
    if(c->wall == waThumper && c->tmp > 0) {
      useup(c);
      c->pathdist = 1; pathq.push_back(c);
      }
    int d = c->cpdist;
    if(d == 9) break;
    for(int i=0; i<c->type; i++) if(c->mov[i]) {
      // printf("i=%d cd=%d\n", i, c->mov[i]->cpdist);
      if(signed(c->mov[i]->cpdist) > d+1) {
        c->mov[i]->cpdist = d+1;
        c->mov[i]->ligon = 0;
        dcal.push_back(c->mov[i]);
        }
      }
    }

  qb = 0;
  while(qb < size(pathq)) {
    cell *c = pathq[qb++];
    if(c->cpdist > 7) continue;
    int d = c->pathdist;
    if(cblocked(c) && !(c->wall == waThumper && c->tmp > 0)) continue;
    for(int i=0; i<c->type; i++) {
      // printf("i=%d cd=%d\n", i, c->mov[i]->cpdist);
      if(c->mov[i] && c->mov[i]->pathdist == INFD) {
        c->mov[i]->pathdist = d+1;
        pathq.push_back(c->mov[i]);
        }
      }
    }
  }

void moveNormal(cell *c) {
  bool repeat = true;
  eMonster m = c->monst;
  int nc = 0;
  
  again:

  for(int j=0; j<c->type; j++) 
    if(c->mov[j] && isFriendly(c->mov[j])) {
      addMessage(s0 + "The " + minf[m].name + " destroys the " + minf[c->mov[j]->monst].name + "!");
      c->mov[j]->monst = moNone;
      return;
      }

  for(int j=0; j<c->type; j++) 
    if(c->mov[j] && c->mov[j]->pathdist < c->pathdist && !cblocked(c->mov[j])) 
    nc++;
  if(!nc) return;
  nc = rand() % nc;
  for(int j=0; j<c->type; j++) if(c->mov[j] && c->mov[j]->pathdist < c->pathdist && !cblocked(c->mov[j])) {
    if(!nc) {
      c->mov[j]->monst = m, c->monst = moNone;
      if(m == moEagle && repeat && c->mov[j]->pathdist > 1) { repeat = false; c = c->mov[j]; goto again; }
      break;
      }
    nc--;
    }
  }

void moveWorm(cell *c) {
  int ncg = 0, ncb = 0;
  cell *gmov[7], *bmov[7];
  
  for(int j=0; j<c->type; j++) {
    if(c->mov[j] && isFriendly(c->mov[j])) {
      addMessage(s0 + "The sandworm eats the " + minf[c->mov[j]->monst].name + "!");
      ncg = 1; gmov[0] = c->mov[j];
      break;
      }
    if(c->mov[j] && c->mov[j]->land == laDesert && !cblocked(c->mov[j]) && c->mov[j] != cwt.c) {
      if(c->mov[j]->pathdist < c->pathdist) gmov[ncg++] = c->mov[j]; else bmov[ncb++] = c->mov[j];
      }
    }

  if(ncg == 0 && ncb == 0) {
    addMessage("The sandworm explodes in a cloud of Spice!");
    kills[moWorm]++;
    c->item = itSpice;
    while(c->monst == moWorm || c->monst == moWormtail) {
      c->monst = moNone;
      if(c->mondir != NODIR) c = c->mov[c->mondir];
      }
    return;
    }
  
  cell* goal;
  if(ncg) goal = gmov[rand() % ncg];
  else goal = bmov[rand() % ncb];
  
  for(int j=0; j<c->type; j++) if(c->mov[j] == goal) {
    goal->monst = moWormMoved;
      
    c->monst = moWormtail;
    goal->mondir = c->spn[j];
    
    cell *c2 = c, *c3 = c2;
    for(int a=0; a<15; a++)
      if(c2->monst == moWormtail) {
        if(c2->mondir == NODIR) return;
        c3 = c2, c2 = c3->mov[c2->mondir];
        }
    
    if(c2->monst == moWormtail) c2->monst = moNone, c3->mondir = NODIR;
    }

  }

void ivynext(cell *c, eMonster what = moIvyHead) {
  cellwalker cw(c, c->mondir);
  cw.c->monst = moIvyWait;
  bool findleaf = false;
  while(true) {
    cwspin(cw, 1);
    if(cw.spin == signed(cw.c->mondir)) {
      if(findleaf && (cw.c->cpdist < 8 || cw.c == c)) { cw.c->monst = what; break; }
      cw.c->monst = moIvyWait;
      cwstep(cw);
      continue;
      }
    cwstep(cw);
    if(cw.c->monst == moIvyWait && signed(cw.c->mondir) == cw.spin) {
      cw.c->monst = moIvyBranch;
      findleaf = true; continue;
      }
    cwstep(cw);
    }
  }

void moveivy() {
  vector<cell*> ivy;
  for(int i=0; i<size(dcal); i++) {
    if(dcal[i]->monst == moIvyHead)
      ivy.push_back(dcal[i]);
    }
  for(int i=0; i<size(ivy); i++) {
    cell *c = ivy[i];
    ivynext(c);

    cell *mto = NULL;
    int pd = c->pathdist;
    int sp = 0;
    
    while(c->monst != moIvyRoot) {
      for(int j=0; j<c->type; j++) {
        if(c->mov[j] && isFriendly(c->mov[j])) {
          addMessage(s0 + "The ivy destroys the " + minf[c->mov[j]->monst].name + "!");
          c->mov[j]->monst = moNone;
          continue;
          }
        if(c->mov[j] && signed(c->mov[j]->pathdist) < pd && !cblocked(c->mov[j]))
          mto = c->mov[j], pd = mto->pathdist, sp = c->spn[j];
        }
      c = c->mov[c->mondir];
      }

    if(!mto) return;
    mto->monst = moIvyWait, mto->mondir = sp;
    }
  }

// move slimes, and also seeps

int sval = 1;
vector<cell*> slimedfs;

void slimevisit(cell *c, cell *from) {
  if(c->tmp == sval) return;
  if(c->land != laAlchemist && c->wall != waCavewall) return;
  if(c->wall != from->wall && from != cwt.c) return;
  if(c->monst == moSlime && from->monst == moSlime) return;
  if(c->item) return;
  c->tmp = sval;
  if(size(slimedfs) < 1000) slimedfs.push_back(c);
  if(c->monst == moSlime || c->monst == moSeep)
    from->monst = c->monst, c->monst = moNone;
  for(int i=0; i<c->type; i++) if(c->mov[i] == from)
    c->mondir = i;
  }

void moveslimes() {
  sval++;
  slimedfs.clear();
  slimedfs.push_back(cwt.c);
  for(int i=0; i<size(slimedfs); i++) {
    cell *c = slimedfs[i];
    for(int t=0; t<c->type; t++)
      slimevisit(c->mov[t], c);
    }
  }

void movegolems() {
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->monst == moGolem) {
      int bestv = 100, bq = 0, bdirs[7];
      for(int k=0; k<c->type; k++) if(c->mov[k]) {
        int val;
        if(c->mov[k] == cwt.c) val = 0;
        else if(enemy(c->mov[k], NULL) && !isWorm(c->mov[k])) val = 12000;
        else if(isIvy(c->mov[k])) val = 8000;
        else if(monstersnear(c->mov[k], NULL, false)) val = 0;
        else if(alblocked(c, c->mov[k])) val = 0;
        else if(!cblocked(c->mov[k])) val = 4000;
        else val = 0;
        val -= c->mov[k]->pathdist;
        if(val > bestv) bestv = val, bq = 0;
        if(val == bestv) bdirs[bq++] = k;
        }
      if(bestv <= 100) continue;
      int dir = bdirs[rand() % bq];
      cell *c2 = c->mov[dir];
      if(c2->monst) {
        addMessage(s0 + "The golem destroys the " + minf[c2->monst].name + "!");
        killMonster(c2);
        }
      else {
        c2->monst = moGolemMoved;
        c->monst = moNone;
        }
      }
    }
  }

void movemonsters() {
  DEB("golems");
  movegolems();
  
  DEB("normal");
  for(int i=0; i<size(pathq); i++) {
    cell *c = pathq[i];
    eMonster m = c->monst;
    
    if(enemy(c, NULL)) {
      if(c->pathdist == 1) {
        // c->iswall = true; c->ismon = false;
        if(items[itOrbShield]) continue;

        addMessage(s0 + "The " + minf[m].name + " is confused!");
        // playerdead = true;
        break;
        }
      
      if(c->monst == moWolf) {
        int bhd = NODIR;
        ld besth = c->heat;
        for(int j=0; j<c->type; j++) if(c->mov[j]->heat > besth && !cblocked(c->mov[j]))
          besth = c->mov[j]->heat, bhd = j;
        if(bhd != NODIR) {
          // printf("wolf moved from %Lf (%p) to %Lf (%p)\n", c->heat, c, besth, c->mov[bhd]);
          c->mov[bhd]->monst = moWolfMoved, c->monst = moNone;
          }
        }
      
      else if(m == moYeti || m == moRanger || m == moGoblin || m == moTroll || m == moDesertman || m == moMonkey ||
        m == moEagle)
        moveNormal(c);
      }
    }

  DEB("worm");
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->monst == moWorm)
      moveWorm(c);
    }

  DEB("ivy");
  moveivy();
  DEB("slimes");
  moveslimes();

  DEB("fresh");
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    
    if(c->monst == moWolfMoved) c->monst = moWolf;
    if(c->monst == moWormwait) c->monst = moWorm;
    if(c->monst == moWormMoved) c->monst = moWormwait;
    if(c->monst == moIvyNext) c->monst = moIvyHead;
    if(c->monst == moIvyDead) c->monst = moNone;
    if(c->monst == moGolemMoved) c->monst = moGolem;
    }
  }

// move heat
void heat() {
  int oldmelt = kills[0];

  /* if(cwt.c->heat > .5)  cwt.c->heat += .3;
  if(cwt.c->heat > 1.)  cwt.c->heat += .3;
  if(cwt.c->heat > 1.4) cwt.c->heat += .5; */
  cwt.c->heat += 1.2;
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->cpdist > 8) break;
    if(c->land != laIce) continue;
    if(c->monst == moRanger) c->heat += 3;
    if(c->monst == moDesertman) c->heat += 4;
    if(c->monst == moMonkey) c->heat ++;
    if(c->wall == waDeadTroll) c->heat -= 2;
    if(c->wall == waBonfire && c->tmp > 0) c->heat += 4, useup(c);
    
    ld hmod = 0;
    
    for(int j=0; j<c->type; j++) if(c->mov[j]) {
      if(c->mov[j]->land != laIce) {
        if(c->mov[j] == cwt.c) hmod += 1.2;
        continue;
        }
      ld hdiff = c->mov[j]->heat - c->heat;
      hdiff /= 10;
      if(c->mov[j]->cpdist <= 8)
        c->mov[j]->heat -= hdiff;
      else
        hdiff = -c->heat / 250;
      hmod += hdiff;
      }
    
    c->heat += hmod;
    }
  
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->wall == waIcewall && c->heat > .4) c->wall = waNone, kills[0]++;
    }

  if(kills[0] != oldmelt) bfs();
  }

void livecaves() {
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->cpdist > 8) break;
    if(c->land != laCaves) continue;
    
    if(c->wall == waThumper) continue;
    c->tmp = 0;
    if(c->item || c->monst || c->cpdist == 0 || c->wall == waDeadTroll) continue;
    for(int j=0; j<c->type; j++) if(c->mov[j]) {
      if(c->mov[j]->wall == waCavefloor) c->tmp++;
      else if(c->mov[j]->wall == waCavewall) c->tmp--;
      else if(c->mov[j]->wall == waDeadTroll) c->tmp -= 5;
      else if(c->mov[j]->wall != waBarrier) c->tmp += 5;      
      if(c->mov[j]->cpdist == 0 && items[itOrbDigging]) c->tmp+=100;
      if(c->mov[j]->wall == waThumper && c->mov[j]->tmp > 0) c->tmp+=100;
      if(c->mov[j]->item) c->tmp++;
      // if(c->mov[j]->monst) c->tmp++;
      // if(c->mov[j]->monst == moTroll) c->tmp -= 3;
      }
    }

  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->cpdist > 8) break;
    if(c->land != laCaves) continue;
    if(c->wall == waThumper) continue;
    
    if(c->tmp > 0) c->wall = waCavefloor;
    if(c->tmp < 0) c->wall = waCavewall;
    }
  
  }

// mirror management

void createMirrors(cell *c, int dir, eMonster type) {
  cellwalker C(c, dir);
  
  if(type == moMirror) type = moMimic;
  else type = moMirror;

  for(int i=0; i<6; i++) {
    cwstep(C);
    if(C.c->type == 6) {
      cwspin(C, i);
      if(C.c->monst == moNone && C.c->wall == waNone) {
        C.c->monst = type;
        C.c->mondir = C.spin;
        }
      cwspin(C, -i);
      }
    cwstep(C);
    cwspin(C, 1);
    }
  }

void createMimics(cell *c, int dir, eMonster type) {
  cellwalker C(c, dir);
  for(int i=0; i<6; i++) {
    cwstep(C);
    if(C.c->type == 6) {
      cwspin(C, 2);
      cwstep(C);
      cwspin(C, 4-i);
      if(C.c->monst == moNone && C.c->wall == waNone) {
        C.c->monst = type;
        C.c->mondir = C.spin;
        }
      cwspin(C, 6-4+i);
      cwstep(C);
      cwspin(C, 2);
      cwstep(C);
      cwspin(C, 2-i);
      if(C.c->monst == moNone && C.c->wall == waNone) {
        C.c->monst = type;
        C.c->mondir = C.spin;
        }
      cwspin(C, 6-2+i);
      cwstep(C);
      cwspin(C, 2);
      }
    cwstep(C);
    cwspin(C, 1);
    }
  }

void spinmirrors(int d) {

  for(int i=0; i<size(mirrorlist); i++) {
    cell *c = mirrorlist[i];
    if(c->monst == moMirror) 
      mirrorlist[i]->mondir = (mirrorlist[i]->mondir - d + 42) % mirrorlist[i]->type;
    if(c->monst == moMimic)
      mirrorlist[i]->mondir = (mirrorlist[i]->mondir + d + 42) % mirrorlist[i]->type;
    }

  }

void gomirrors(bool go) {
  for(int i=0; i<size(mirrorlist); i++) {
    cell *c = mirrorlist[i];
    eMonster m = c->monst;
    if(m == moMirror || m == moMimic) {
      cell *c2 = c->mov[c->mondir];
      if(c2 && c2->monst != moNone && !isMimic(c2) && !isWorm(c2)) {
        addMessage(s0 + "The " + minf[m].name + " destroys the " + minf[c2->monst].name + "!");
        killMonster(c2);
        }
      if(!go) continue;
      c->monst = moNone;
      if(!c2) continue;
      if(c2->wall == waBarrier)  continue;
      if(c2->wall == waFloorA)   continue;
      if(c2->wall == waFloorB)   continue;
      if(c2->wall == waCavewall) continue;
      if(c2->wall == waDune)     continue;
      if(isWorm(c2)) return;
      if(c2 == cwt.c) {
        addMessage(s0 + "You join the " + minf[m].name + ".");
        continue;
        }
      if(isMimic(c2)) {
        addMessage("Two of your images crash and disappear!");
        c2->monst = moNone;
        continue;
        }
      if(isIvy(c2)) killIvy(c2);
      c2->monst = m;
      c2->mondir = c->spn[c->mondir];
      if(c2->wall == waMirror) {
        addMessage(s0 + "The " + minf[m].name + " breaks the mirror!");
        createMirrors(c2, c2->mondir, m);
        }
      if(c2->wall == waCloud) {
        addMessage(s0 + "The " + minf[m].name + " disperses the cloud!");
        createMimics(c2, c2->mondir, m);
        }
      c2->wall = waNone;
      }
    }
  }

void reduceOrbPowers() {
  if(items[itOrbLightning]) items[itOrbLightning]--;
  if(items[itOrbSpeed]) items[itOrbSpeed]--;
  if(items[itOrbFlash]) items[itOrbFlash]--;
  if(items[itOrbShield]) items[itOrbShield]--;
  if(items[itOrbWinter]) items[itOrbWinter]--;
  if(items[itOrbDigging]) items[itOrbDigging]--;
  }

void activateFlash() {
  extern void drawFlash();
  drawFlash();
  addMessage("You activate the Flash spell!");
  items[itOrbFlash] = 0;
  for(int i=0; i<size(dcal); i++) {
    cell *c = dcal[i];
    if(c->cpdist > 2) break;
    killMonster(c);
    c->heat += 2;
    if(c->wall == waCavewall)  c->wall = waCavefloor;
    if(c->wall == waDeadTroll) c->wall = waCavefloor;
    if(c->wall == waMirror)    c->wall = waNone;
    if(c->wall == waCloud)     c->wall = waNone;
    if(c->wall == waDune)      c->wall = waNone;
    if(isActiv(c))             c->tmp = 77;
    }
  }

bool barrierAt(cellwalker& c, int d) {
  if(d >= 7) return true;
  if(d <= -7) return true;
  d = c.spin + d + 42;
  d%=c.c->type;
  if(!c.c->mov[d]) return true;
  if(c.c->mov[d]->wall == waBarrier) return true;
  return false;
  }

void activateLightning() {
  extern void drawLightning();
  drawLightning();
  addMessage("You activate the Lightning spell!");
  items[itOrbLightning] = 0;
  for(int i=0; i<cwt.c->type; i++) {
    cellwalker lig(cwt.c, i);
    int bnc = 0;
    while(true) {
      // printf("at: %p i=%d d=%d\n", lig.c, i, lig.spin);
      if(lig.c->mov[lig.spin] == 0) break;
      cwstep(lig);
      
      cell *c = lig.c;
      killMonster(c);
      c->heat += 2;
      c->ligon = 1;
      
      bool brk = false;
      if(c->wall == waCavewall)  c->wall = waCavefloor, brk = true;
      if(c->wall == waDeadTroll) c->wall = waCavefloor, brk = true;
      if(c->wall == waFloorA)    c->wall = waFloorB;
      else if(c->wall == waFloorB)    c->wall = waFloorA;
      if(c->wall == waMirror)    c->wall = waNone;
      if(c->wall == waCloud)     c->wall = waNone;
      if(c->wall == waDune)      c->wall = waNone, brk = true;
      if(c->wall == waIcewall)   c->wall = waNone, brk = true;
      if(c == cwt.c)             brk = true;
      if(isActiv(c))             c->tmp = 77;
      
      if(brk) break;
      
      if(c->wall == waBarrier)   {
        int left = -1;
        int right = 1;
        while(barrierAt(lig, left)) left--;
        while(barrierAt(lig, right)) right++;
        cwspin(lig, -(right + left));
        bnc++; if(bnc > 10) break;
        }
      else {
        cwspin(lig, 3);
        if(c->type == 7) cwspin(lig, rand() % 2);
        }
      }
    }
  }

// move the PC in direction d (or stay in place for d == -1)

bool canmove = true;

bool movepcto(int d, bool checkonly = false) {
  if(!checkonly) DEB("movepc");
  if(d >= 0) {
    cwspin(cwt, d);
    spinmirrors(d);
    d = cwt.spin;
    }
  playermoved = true;
  if(d >= 0) {
    cell *c2 = cwt.c->mov[d];
    
    if(cblocked(c2) && items[itOrbFlash]) {
      if(checkonly) return true;
      activateFlash();
      return true;
      }

    if(cblocked(c2) && items[itOrbLightning]) {
      if(checkonly) return true;
      activateLightning();
      return true;
      }

    if(isActiv(c2) && c2->tmp == -1) {
      if(checkonly) return true;
      addMessage(s0 + "You activate the " + winf[c2->wall].name + ".");
      c2->tmp = 100;
      return true;
      }
    if(c2->wall == waThumper && !monstersnear(c2)) {
      cellwalker push = cwt;
      cwstep(push);
      cwspin(push, 3);
      cwstep(push);
      if((cblocked(push.c) || push.c->item) && c2->type == 7) {
        cwstep(push);
        cwspin(push, 1);
        cwstep(push);
        }
      if(cblocked(push.c) || push.c->item) {
        if(checkonly) return false;
        addMessage("No room to push the Thumper!");
        return false;
        }
      if(checkonly) return true;
      addMessage("You push the Thumper.");
      push.c->tmp = c2->tmp;
      push.c->wall = c2->wall;
      c2->wall = waNone;
      }

    if(c2->monst) {
      if(c2->monst == moWorm || c2->monst == moWormtail || c2->monst == moWormwait) {
        if(checkonly) return false;
        addMessage(s0 + "You cannot attack Sandworms directly!");
        return false;
        }
      
      if(monstersnear(cwt.c, c2)) {
        if(checkonly) return false;
        addMessage(s0 + "You would be killed by the " + minf[which].name + "!");
        return false;
        }

      if(checkonly) return true;
      addMessage(s0 + "You kill the " + minf[c2->monst].name + ".");

      killMonster(c2);
      gomirrors(0);
      }
    else if(!passable(c2)) {
      if(checkonly) return false;
      addMessage(s0 + "You cannot move through the " + winf[c2->wall].name + "!");
      return false;
      }
    else {
      if(monstersnear(c2)) {
        if(checkonly) return false;
        addMessage(s0 + "The " + minf[which].name + " would kill you there!");
        return false;
        }
      if(alblocked(cwt.c, c2) && !c2->item) {
        if(checkonly) return false;
        addMessage("Wrong color!");
        return false;
        }
      if(checkonly) return true;
      if(c2->item && c2->land == laAlchemist) c2->wall = cwt.c->wall;
      if(c2->item) addMessage(s0 + "You collect the " + iinf[c2->item].name + "!");
      
      if(c2->item == itOrbSpeed) {
        items[c2->item] += 31;
        if(items[c2->item] > 77) items[c2->item] = 77;
        }
      else if(c2->item == itOrbLife) {
        cwt.c->monst = moGolem;
        }
      else if(c2->item == itOrbLightning) {
        items[c2->item] += 78;
        if(items[c2->item] > 777) items[c2->item] = 777;
        }
      else if(c2->item == itOrbFlash) {
        items[c2->item] += 78;
        if(items[c2->item] > 777) items[c2->item] = 777;
        }
      else if(c2->item == itOrbShield) {
        items[c2->item] += 16;
        if(items[c2->item] > 77) items[c2->item] = 77;
        }
      else if(c2->item == itOrbWinter) {
        items[c2->item] += 31;
        if(items[c2->item] > 77) items[c2->item] = 77;
        }
      else if(c2->item == itOrbDigging) {
        items[c2->item] += 78;
        if(items[c2->item] > 101) items[c2->item] = 101;
        }
      else 
        if(c2->item) items[c2->item]++;
      c2->item = itNone;
      
      if(items[itOrbWinter] && cwt.c->land == laIce)
        cwt.c->wall = waIcewall, cwt.c->heat = -1;
      
      cwstep(cwt);
      gomirrors(1);

      if(c2->wall == waMirror) {
        addMessage("The mirror shatters!");
        if(c2->land == laMirror) items[itShard]++;
        c2->wall = waNone;
        createMirrors(cwt.c, cwt.spin, moMimic);
        }

      if(c2->wall == waCloud) {
        addMessage("The cloud turns into a bunch of images!");
        if(c2->land == laMirror) items[itShard]++;
        c2->wall = waNone;
        createMimics(cwt.c, cwt.spin, moMimic);
        }

      setdist(cwt.c, 0, NULL);
      }
    }
  else {
    if(monstersnear(cwt.c)) {
      if(checkonly) return false;
      addMessage(s0 + "The " + minf[which].name + " would get you!");
      return false;
      }
    if(checkonly) return true;
    }
  DEB("bfs");
  bfs();
  DEB("heat");
  heat();
  DEB("rop");
  reduceOrbPowers();
  DEB("mmo");
  if(!(1 & items[itOrbSpeed])) movemonsters();
  DEB("lc");
  livecaves();
  DEB("check");
  canmove = false;
  if(movepcto(-1, true)) canmove = true;
  for(int i=0; i<cwt.c->type; i++) 
    if(movepcto(1, true)) canmove = true;
  DEB("done");
  return true;
  }

// initialize the game
void initgame() {
  cwt.c = origin.c7; cwt.spin = 0;
  cwt.c->land = laIce;

  for(int i=9; i>=0; i--) {
    setdist(cwt.c, i, NULL);
    verifycells(&origin);
    }
  cwt.c->wall = waNone;
  cwt.c->item = itNone;
  cwt.c->monst = moNone;

  /*
  items[itGold] = 20;
  items[itDiamond] = 20;
  items[itSpice] = 20;
  items[itEmerald] = 20;
  items[itElixir] = 20;
  */
  
  /*
  items[itOrbShield]    = 100;
  items[itOrbSpeed]     = 100;
  items[itOrbWinter]    = 100;
  items[itOrbLightning] = 100;
  */
  
  // items[itOrbLightning]    = 100;
  // items[itEmerald]      = 100;
  
  bfs();
  }

void saveStats() {
  FILE *f = fopen(scorefile, "at");
  if(!f) {
    printf("Could not open the score file '%s'!\n", scorefile);
    addMessage(s0 + "Could not open the score file: " + scorefile);
    return;
    }
  
  time_t timer;
  timer = time(NULL);
  char buf[128]; strftime(buf, 128, "%c", localtime(&timer));
  
  fprintf(f, "HyperRogue II: game statistics (version 2.1)\n");
  fprintf(f, "Played on: %s\n", buf);
  fprintf(f, "Total wealth: %d\n", gold());
  fprintf(f, "Total enemies killed: %d\n", tkills());
  fprintf(f, "cells generated: %d\n", cellcount);
  fprintf(f, "Number of cells explored, by distance from the player:\n"); 
  for(int i=0; i<10; i++) fprintf(f, " %d", explore[i]); fprintf(f, "\n");
  if(kills[0]) fprintf(f, "walls melted: %d\n", kills[0]);
  fprintf(f, "heptagons travelled: %d\n", celldist(cwt.c));
  
  fprintf(f, "\n");

  for(int i=0; i<firstorb; i++) if(items[i])  
    fprintf(f, "%4dx %s\n", items[i], iinf[i].name);
    
  fprintf(f, "\n");
  
  for(int i=1; i<motypes; i++) if(kills[i])  
    fprintf(f, "%4dx %s\n", kills[i], minf[i].name);
  
  fprintf(f, "\n\n\n");
  
  printf("Game statistics saved to %s\n", scorefile);
  addMessage(s0 + "Game statistics saved to " + scorefile);
  fclose(f);
  }

void restartGame() {
  DEB("savestats");
  saveStats();
  DEB("clear");
  pathq.clear();
  dcal.clear();
  for(int i=0; i<ittypes; i++) items[i] = 0;
  for(int i=0; i<motypes; i++) kills[i] = 0;
  for(int i=0; i<10; i++) explore[i] = 0;
  cellcount = 0;
  DEB("clearmem");
  clearMemory();
  DEB("initc");
  initcells();
  DEB("initg");
  initgame();
  canmove = true;
  DEB("restg");
  extern void restartGraph();
  restartGraph();  
  }

void cheat() {
  if(cwt.c->type == 6) 
    createMirrors(cwt.c, cwt.spin, moMimic),
    createMimics(cwt.c, cwt.spin, moMimic);
  else
    for(int i=0; i<7; i++) if(!cblocked(cwt.c->mov[i]))
      cwt.c->mov[i]->monst = moGolem;
  for(int i=1; i<firstorb; i++) items[i]++;
  for(int i=firstorb; i<ittypes; i++) items[i] = 0;
  items[firstorb + rand() % (ittypes - firstorb)] = 100;
  }
