class tileset {
  PImage tileset_image; 
  PImage[] tile;
  int tile_width, tile_height, tile_number, tiles_per_row;
  
  tileset(String file, int temp_tile_width, int temp_tile_height, int temp_tile_number, int temp_tiles_per_row) {
    tileset_image = loadImage(file);
    tile_width = temp_tile_width;
    tile_height = temp_tile_height;
    tile_number = temp_tile_number;
    tiles_per_row = temp_tiles_per_row;
    
    tileset_image.loadPixels();
    
    tile = new PImage[tile_number];
    int k = 0;
    for (int i=0; i<tile_number; i++) {
      if (i == tiles_per_row) k++;
      tile[i] = createImage(tile_width, tile_height, ARGB);
      tile[i].loadPixels();
      for (int y=0; y<tile_height; y++){
        for (int x=0; x<tile_width; x++){
          int pixel_index = (k*tile_height + y) * tile_width*tiles_per_row
                          + (i-k*tiles_per_row) * tile_width +x;

          tile[i].pixels[y*tile_width+x] = tileset_image.pixels[pixel_index];
//          print(str(pixel_index)+" ");
        }
      }      
    }
  }
  
  void draw(int x, int y, int index) {
    surface.beginDraw();
    surface.pushMatrix();
    surface.translate(x, y);
    surface.image(tile[index], 0, 0);
    surface.popMatrix();
    surface.endDraw();
  }
  
  void draw_color(int x, int y, int index, color c) {
    surface.tint(c);
    draw(x,y,index);
    surface.tint(255);
  }
  
  void draw_on_surface(int x, int y, int index, color c, PGraphics surface) { 
    surface.tint(c);
    surface.beginDraw();
    surface.pushMatrix();
    surface.translate(x, y);
    surface.image(tile[index], 0, 0);
    surface.popMatrix();
    surface.endDraw();
    surface.tint(255);
  }
  
}
  
