/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.view.View;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.ViewMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class ViewMatcherTest {
    private View view;
    private ViewMatcher<View, ?> matcher;

    @Before
    public void setup() throws Exception {
        this.view = new View(null);
        this.matcher = this.newViewMatcher(this.view);
    }

    @Test
    public void toBeVisible_shouldReturnTrueOnlyForVisibleViews() throws Exception {
        this.view.setVisibility(0);
        Expect.expect(this.matcher.toBeVisible()).toBeTrue();
        this.view.setVisibility(4);
        Expect.expect(this.matcher.toBeVisible()).toBeFalse();
        this.view.setVisibility(8);
        Expect.expect(this.matcher.toBeVisible()).toBeFalse();
    }

    @Test
    public void toBeInvisible_shouldReturnTrueOnlyForInvisibleViews() throws Exception {
        this.view.setVisibility(0);
        Expect.expect(this.matcher.toBeInvisible()).toBeFalse();
        this.view.setVisibility(4);
        Expect.expect(this.matcher.toBeInvisible()).toBeTrue();
        this.view.setVisibility(8);
        Expect.expect(this.matcher.toBeInvisible()).toBeFalse();
    }

    @Test
    public void toBeGone_shouldReturnTrueOnlyForGoneViews() throws Exception {
        this.view.setVisibility(0);
        Expect.expect(this.matcher.toBeGone()).toBeFalse();
        this.view.setVisibility(4);
        Expect.expect(this.matcher.toBeGone()).toBeFalse();
        this.view.setVisibility(8);
        Expect.expect(this.matcher.toBeGone()).toBeTrue();
    }

    @Test
    public void test_toHaveVisibility() throws Exception {
        this.view.setVisibility(0);
        Expect.expect(this.matcher.toHaveVisibility(0)).toBeTrue();
        Expect.expect(this.matcher.toHaveVisibility(4)).toBeFalse();
        Expect.expect(this.matcher.toHaveVisibility(8)).toBeFalse();
        this.view.setVisibility(4);
        Expect.expect(this.matcher.toHaveVisibility(0)).toBeFalse();
        Expect.expect(this.matcher.toHaveVisibility(4)).toBeTrue();
        Expect.expect(this.matcher.toHaveVisibility(8)).toBeFalse();
        this.view.setVisibility(8);
        Expect.expect(this.matcher.toHaveVisibility(0)).toBeFalse();
        Expect.expect(this.matcher.toHaveVisibility(4)).toBeFalse();
        Expect.expect(this.matcher.toHaveVisibility(8)).toBeTrue();
    }

    @Test
    public void test_toHaveVisibility_failureMessages() throws Exception {
        this.view.setVisibility(0);
        this.matcher.toHaveVisibility(0);
        Expect.expect(this.matcher.getDescriptionOfExpected()).toEqual((Object)"View.VISIBLE");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"View[visibility=View.VISIBLE]");
        this.view.setVisibility(4);
        this.matcher.toHaveVisibility(4);
        Expect.expect(this.matcher.getDescriptionOfExpected()).toEqual((Object)"View.INVISIBLE");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"View[visibility=View.INVISIBLE]");
        this.view.setVisibility(8);
        this.matcher.toHaveVisibility(8);
        Expect.expect(this.matcher.getDescriptionOfExpected()).toEqual((Object)"View.GONE");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"View[visibility=View.GONE]");
    }

    @Test(expected=IllegalArgumentException.class)
    public void toHaveVisibility_throwsException() throws Exception {
        this.matcher.toHaveVisibility(12);
    }

    @Test
    public void test_toBeEnabled() throws Exception {
        this.view.setEnabled(true);
        Expect.expect(this.matcher.toBeEnabled()).toBeTrue();
        this.view.setEnabled(false);
        Expect.expect(this.matcher.toBeEnabled()).toBeFalse();
    }

    private <T extends View> ViewMatcher<T, ?> newViewMatcher(T value) {
        ViewMatcher matcher = new ViewMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }
}

