/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.view.View;
import com.pivotallabs.greatexpectations.MatcherOf;
import com.pivotallabs.robolectricgem.matchers.AndroidMatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MatcherOf(value={View.class})
public class ViewMatcher<T extends View, M extends ViewMatcher<T, M>>
extends AndroidMatcher<T, M> {
    public boolean toBeVisible() {
        return ((View)this.actual).getVisibility() == 0;
    }

    public boolean toBeInvisible() {
        return ((View)this.actual).getVisibility() == 4;
    }

    public boolean toBeGone() {
        return ((View)this.actual).getVisibility() == 8;
    }

    public boolean toHaveVisibility(int expectedVisibility) {
        switch (expectedVisibility) {
            case 0: 
            case 4: 
            case 8: {
                this.setDescriptionOfActual("visibility", this.visibilityToString(((View)this.actual).getVisibility()));
                this.descriptionOfExpected = this.visibilityToString(expectedVisibility);
                return ((View)this.actual).getVisibility() == expectedVisibility;
            }
        }
        throw new IllegalArgumentException("expected argument View.VISIBLE, View.INVISIBLE, or View.GONE");
    }

    public boolean toBeEnabled() {
        return ((View)this.actual).isEnabled();
    }

    private String visibilityToString(int visibility) {
        switch (visibility) {
            case 0: {
                return "View.VISIBLE";
            }
            case 4: {
                return "View.INVISIBLE";
            }
            case 8: {
                return "View.GONE";
            }
        }
        return null;
    }
}

