/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.widget.EditText;
import android.widget.TextView;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.TextViewMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class TextViewMatcherTest {
    private TextView textView;
    private TextViewMatcher<TextView, ?> matcher;

    @Before
    public void setUp() throws Exception {
        this.textView = new TextView(null);
        this.matcher = this.newTextViewMatcher(this.textView);
    }

    @Test
    public void test_toHaveText() throws Exception {
        this.textView.setText((CharSequence)"Hello World");
        Expect.expect(this.matcher.toHaveText("Hello World")).toBeTrue();
        Expect.expect(this.matcher.toHaveText("Good Day")).toBeFalse();
    }

    @Test
    public void test_editTextToHaveText() throws Exception {
        EditText editText = new EditText(null);
        editText.setText((CharSequence)"Hello World");
        TextViewMatcher<EditText, ?> editTextMatcher = this.newTextViewMatcher(editText);
        Expect.expect(editTextMatcher.toHaveText("Hello World")).toBeTrue();
        Expect.expect(editTextMatcher.toHaveText("Good Day")).toBeFalse();
    }

    @Test
    public void test_toHaveText_failureMessages() throws Exception {
        this.textView.setText((CharSequence)"Hello World");
        this.matcher.toHaveText("hi");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"TextView[text=Hello World]");
    }

    @Test
    public void test_toHaveHint() throws Exception {
        this.textView.setHint((CharSequence)"hint");
        Expect.expect(this.matcher.toHaveHint("hint")).toBeTrue();
        Expect.expect(this.matcher.toHaveHint("other hint")).toBeFalse();
        this.textView.setHint(null);
        Expect.expect(this.matcher.toHaveHint(null)).toBeTrue();
        Expect.expect(this.matcher.toHaveHint("")).toBeFalse();
        Expect.expect(this.matcher.toHaveHint("hint")).toBeFalse();
    }

    @Test
    public void test_toHaveHint_failureMessages() throws Exception {
        this.textView.setHint((CharSequence)"actual hint");
        this.matcher.toHaveHint("expected hint");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"TextView[hint=actual hint]");
        this.matcher.toHaveHint("actual hint");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"TextView[hint=actual hint]");
    }

    private <T extends TextView> TextViewMatcher<T, ?> newTextViewMatcher(T value) {
        TextViewMatcher matcher = new TextViewMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }
}

