/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.ImageViewMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class ImageViewMatcherTest {
    private ImageView imageView;
    private ImageViewMatcher<ImageView, ?> matcher;

    @Before
    public void setup() throws Exception {
        this.imageView = new ImageView((Context)new Activity());
        this.matcher = this.newImageViewMatcher(this.imageView);
    }

    @Test
    public void test_toBeLoadedFromResource() throws Exception {
        Expect.expect(this.matcher.toBeLoadedFromResource(2130837504)).toBeFalse();
        this.imageView.setImageResource(2130837504);
        Expect.expect(this.matcher.toBeLoadedFromResource(2130837504)).toBeTrue();
        Expect.expect(this.matcher.toBeLoadedFromResource(17301511)).toBeFalse();
    }

    @Test
    public void test_toBeLoadedFromResource_failureMessages() throws Exception {
        this.matcher.toBeLoadedFromResource(2130837504);
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"ImageView[drawable=null]");
        this.imageView.setImageResource(2130837504);
        this.matcher.toBeLoadedFromResource(2130837504);
        Expect.expect(this.matcher.getDescriptionOfActual()).toMatch("ImageView\\[drawableResourceId=[0-9]+\\]");
        this.matcher.toBeLoadedFromResource(17301511);
        Expect.expect(this.matcher.getDescriptionOfActual()).toMatch("ImageView\\[drawableResourceId=[0-9]+\\]");
    }

    @Test
    public void test_toBeLoadedFromSource() throws Exception {
        Expect.expect(this.matcher.toBeLoadedFromSource("source sting")).toBeFalse();
        this.setSourceOnImageView("source string", this.imageView);
        Expect.expect(this.matcher.toBeLoadedFromSource("source string")).toBeTrue();
        Expect.expect(this.matcher.toBeLoadedFromSource("not the source string")).toBeFalse();
        this.setSourceOnImageView(null, this.imageView);
        Expect.expect(this.matcher.toBeLoadedFromSource(null)).toBeTrue();
        Expect.expect(this.matcher.toBeLoadedFromSource("source string")).toBeFalse();
    }

    @Test
    public void test_toBeLoadedFromSource_failureMessages() throws Exception {
        this.matcher.toBeLoadedFromSource("a source");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"ImageView[drawable=null]");
        this.setSourceOnImageView("source string", this.imageView);
        this.matcher.toBeLoadedFromSource("source string");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"ImageView[source=source string]");
        this.matcher.toBeLoadedFromSource("not the same source string");
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"ImageView[source=source string]");
    }

    private void setSourceOnImageView(String source, ImageView imageView) {
        ByteArrayInputStream emptyInputStream = new ByteArrayInputStream("".getBytes());
        BitmapDrawable drawable = (BitmapDrawable)Drawable.createFromStream((InputStream)emptyInputStream, (String)source);
        imageView.setImageDrawable((Drawable)drawable);
    }

    private <T extends ImageView> ImageViewMatcher<T, ?> newImageViewMatcher(T value) {
        ImageViewMatcher matcher = new ImageViewMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }
}

