/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.widget.ImageView;
import com.pivotallabs.greatexpectations.MatcherOf;
import com.pivotallabs.robolectricgem.matchers.ViewMatcher;
import com.xtremelabs.robolectric.Robolectric;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MatcherOf(value={ImageView.class})
public class ImageViewMatcher<T extends ImageView, M extends ImageViewMatcher<T, M>>
extends ViewMatcher<T, M> {
    public boolean toBeLoadedFromResource(int expectedResourceId) {
        BitmapDrawable actualDrawable = (BitmapDrawable)((ImageView)this.actual).getDrawable();
        if (actualDrawable == null) {
            this.setDescriptionOfActual("drawable", null);
            return false;
        }
        int actualResourceId = Robolectric.shadowOf((Bitmap)actualDrawable.getBitmap()).getLoadedFromResourceId();
        this.setDescriptionOfActual("drawableResourceId", actualResourceId);
        return actualResourceId == expectedResourceId;
    }

    public boolean toBeLoadedFromSource(String expectedSource) {
        BitmapDrawable actualDrawable = (BitmapDrawable)((ImageView)this.actual).getDrawable();
        if (actualDrawable == null) {
            this.setDescriptionOfActual("drawable", null);
            return false;
        }
        String actualSource = Robolectric.shadowOf((BitmapDrawable)actualDrawable).getSource();
        this.setDescriptionOfActual("source", actualSource);
        return this.equalsAllowingNull(actualSource, expectedSource);
    }
}

