/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.FakeHttpLayerMatcher;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import com.xtremelabs.robolectric.tester.org.apache.http.FakeHttpLayer;
import com.xtremelabs.robolectric.tester.org.apache.http.RequestMatcher;
import java.io.IOException;
import org.apache.http.Header;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class FakeHttpLayerMatcherTest {
    private FakeHttpLayerMatcher<FakeHttpLayer, ?> matcher;
    private HttpClient httpClient = new DefaultHttpClient();

    @Before
    public void setup() throws Exception {
        this.matcher = this.newFakeHttpLayerMatcher(Robolectric.getFakeHttpLayer());
    }

    @Test
    public void test_toHaveMadeAnyRequest() throws Exception {
        Expect.expect(this.matcher.toHaveMadeAnyRequest()).toBeFalse();
        this.makeHttpGetRequest("http://localhost/foo.txt");
        Expect.expect(this.matcher.toHaveMadeAnyRequest()).toBeTrue();
    }

    @Test
    public void test_toHaveMadeAnyRequest_failureMessages() throws Exception {
        this.matcher.toHaveMadeAnyRequest();
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"FakeHttpLayer[numRequests=0]");
        this.makeHttpGetRequest("http://localhost/foo.txt");
        this.matcher.toHaveMadeAnyRequest();
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"FakeHttpLayer[numRequests=1]");
    }

    @Test
    public void test_toHaveMadeRequestMatching() throws Exception {
        FakeHttpLayer.UriRequestMatcher requestMatcher = new FakeHttpLayer.UriRequestMatcher("http://example.com");
        Expect.expect(this.matcher.toHaveMadeRequestMatching((RequestMatcher)requestMatcher)).toBeFalse();
        this.makeHttpGetRequest("http://does-not-match.com");
        Expect.expect(this.matcher.toHaveMadeRequestMatching((RequestMatcher)requestMatcher)).toBeFalse();
        this.makeHttpGetRequest("http://example.com");
        Expect.expect(this.matcher.toHaveMadeRequestMatching((RequestMatcher)requestMatcher)).toBeTrue();
    }

    @Test
    public void test_toHaveMadeRequestMatching_failureMessages() throws Exception {
        FakeHttpLayer.UriRequestMatcher requestMatcher = new FakeHttpLayer.UriRequestMatcher("http://example.com");
        this.matcher.toHaveMadeRequestMatching((RequestMatcher)requestMatcher);
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"FakeHttpLayer[numRequests=0]");
        this.makeHttpGetRequest("http://localhost/foo.txt");
        this.matcher.toHaveMadeRequestMatching((RequestMatcher)requestMatcher);
        Expect.expect(this.matcher.getDescriptionOfActual()).toEqual((Object)"FakeHttpLayer[numRequests=1]");
    }

    private void makeHttpGetRequest(String uri) throws IOException {
        this.allowOneRequest();
        this.httpClient.execute((HttpUriRequest)new HttpGet(uri));
    }

    private void allowOneRequest() {
        Robolectric.addPendingHttpResponse((int)200, (String)"response body", (Header[])new Header[0]);
    }

    private <T extends FakeHttpLayer> FakeHttpLayerMatcher<T, ?> newFakeHttpLayerMatcher(T value) {
        FakeHttpLayerMatcher matcher = new FakeHttpLayerMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }
}

