/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import com.pivotallabs.greatexpectations.MatcherOf;
import com.pivotallabs.robolectricgem.matchers.AndroidMatcher;
import com.xtremelabs.robolectric.Robolectric;
import com.xtremelabs.robolectric.tester.org.apache.http.FakeHttpLayer;
import com.xtremelabs.robolectric.tester.org.apache.http.HttpRequestInfo;
import com.xtremelabs.robolectric.tester.org.apache.http.RequestMatcher;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MatcherOf(value={FakeHttpLayer.class})
public class FakeHttpLayerMatcher<T extends FakeHttpLayer, M extends FakeHttpLayerMatcher<T, M>>
extends AndroidMatcher<T, M> {
    public boolean toHaveMadeAnyRequest() {
        int numberOfRequests = Robolectric.getFakeHttpLayer().getSentHttpRequestInfos().size();
        this.setDescriptionOfActual("numRequests", numberOfRequests);
        return ((FakeHttpLayer)this.actual).hasRequestInfos();
    }

    public boolean toHaveMadeRequestMatching(RequestMatcher requestMatcher) {
        List requestInfos = Robolectric.getFakeHttpLayer().getSentHttpRequestInfos();
        this.setDescriptionOfActual("numRequests", requestInfos.size());
        for (HttpRequestInfo info : requestInfos) {
            if (!requestMatcher.matches(info.getHttpRequest())) continue;
            return true;
        }
        return false;
    }
}

