/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.matchers;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import com.pivotallabs.greatexpectations.GreatExpectations;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.ActivityMatcher;
import com.xtremelabs.robolectric.RobolectricTestRunner;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=RobolectricTestRunner.class)
public class ActivityMatcherTest {
    private Activity activity;
    private ActivityMatcher<Activity, ?> matcher;

    @Before
    public void setup() throws Exception {
        this.activity = new Activity();
        this.matcher = this.newActivityMatcher(this.activity);
    }

    @Test
    public void test_toBeFinishing() throws Exception {
        Expect.expect(this.matcher.toBeFinishing()).toBeFalse();
        this.activity.finish();
        Expect.expect(this.matcher.toBeFinishing()).toBeTrue();
    }

    @Test
    public void test_toHaveStarted() throws Exception {
        Expect.expect(this.matcher.toHaveStarted(FooActivity.class)).toBeFalse();
        this.activity.startActivity(new Intent((Context)this.activity, FooActivity.class));
        Expect.expect(this.matcher.toHaveStarted(FooActivity.class)).toBeTrue();
    }

    private <T extends Activity> ActivityMatcher<T, ?> newActivityMatcher(T value) {
        ActivityMatcher matcher = new ActivityMatcher();
        GreatExpectations.setActual(matcher, value);
        return matcher;
    }

    private class FooActivity
    extends Activity {
        private FooActivity() {
        }
    }
}

