/*
 * Decompiled with CFR 0.152.
 */
package com.pivotallabs.robolectricgem.expect;

import com.pivotallabs.greatexpectations.BaseMatcher;
import com.pivotallabs.greatexpectations.ExpectGenerator;
import com.pivotallabs.robolectricgem.expect.Expect;
import com.pivotallabs.robolectricgem.matchers.ActivityMatcher;
import com.pivotallabs.robolectricgem.matchers.AlertDialogMatcher;
import com.pivotallabs.robolectricgem.matchers.CompoundButtonMatcher;
import com.pivotallabs.robolectricgem.matchers.DialogMatcher;
import com.pivotallabs.robolectricgem.matchers.FakeHttpLayerMatcher;
import com.pivotallabs.robolectricgem.matchers.ImageViewMatcher;
import com.pivotallabs.robolectricgem.matchers.TextViewMatcher;
import com.pivotallabs.robolectricgem.matchers.ViewMatcher;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RunnableExpectGenerator
extends ExpectGenerator {
    private String packageName;
    protected static final Class<? extends BaseMatcher>[] CUSTOM_MATCHER_CLASSES = new Class[]{ActivityMatcher.class, AlertDialogMatcher.class, CompoundButtonMatcher.class, DialogMatcher.class, FakeHttpLayerMatcher.class, ImageViewMatcher.class, TextViewMatcher.class, ViewMatcher.class};

    public RunnableExpectGenerator(String packageName) {
        super(packageName);
        this.packageName = packageName;
    }

    public static void main(String[] args) throws IOException {
        new RunnableExpectGenerator(RunnableExpectGenerator.getExpectClassPackageName()).generateCustomExpect();
    }

    protected static String getExpectClassPackageName() {
        return Expect.class.getPackage().getName();
    }

    protected String getPackageName() {
        return this.packageName;
    }

    public void generateCustomExpect() throws FileNotFoundException {
        String packageName = this.getPackageName();
        String path = this.getExpectClassFilePath();
        System.out.println("path = " + path);
        System.out.println("packagename = " + packageName);
        RunnableExpectGenerator expectGenerator = new RunnableExpectGenerator(packageName);
        expectGenerator.setOut(new PrintStream(new File(path)));
        expectGenerator.generate();
    }

    public List<Class<? extends BaseMatcher>> matcherClasses() {
        List classes = super.matcherClasses();
        classes.addAll(Arrays.asList(CUSTOM_MATCHER_CLASSES));
        return classes;
    }

    protected String getExpectClassFilePrefix() {
        return "src" + File.separator + "robolectricgem" + File.separator;
    }

    protected String getExpectClassFilePath() {
        return this.getExpectClassFilePrefix() + this.getPackageName().replace(".", File.separator) + File.separator + "Expect.java";
    }
}

