
.include	"pmio.asm"

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM
.orgfill 0x1800
there:
.dw	0

curmap:
.dw 0

movedelay:
.db	0

oldx:
.db	0
oldxp:
.db	0
oldy:
.db	0
oldyp:
.db	0
oldbgv:
.db	0
oldbgh:
.db	0

curx:
.db 0
cury:
.db 0

gametime:
.db 0

fc:
.db 0

### these are used for input debouncing and delay (count up when input -> overflow = action)
.equ		DELAYTIME		3

.equ		DELAYMOVE		3
.equ		PLAYERRADIUS	4

debouncers:
.db 0
.db 0
.db 0
.db 0
.db 0
.db 0
.db 0

### if a key was pressed long enough the flag is set here (needs to be cleaned after key was processed)
keystates:
.db 0




f:
.db			0

c:
.dw			0


prevtune:
.dw			0

tune:
.dw			0 ##pointer to current tune

tuneend:
.dw			0

nl:
.db			0

nl2:
.db			0


mainvector:
.dw			0


#--------------------------------- HARDWARE REGS ----------------------------
.orgfill 0x2000
hwregs:    

#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp int_vbl
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp dosound
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp unhandled_interrupt
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp unhandled_interrupt
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
## 0
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "LUPI"             # game code - 4 byte
.db "MINI ZELDA__"     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0



unhandled_interrupt:
    reti

int_power:
    movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
    test	[nn+REG_KEYPAD],KEY_POWER
    jnz		noturnoff
    cint	$24
noturnoff:
    reti

    
dosound:
		push	a
		push	HL
		push	x1
		
		movb 	[nn+REG_INT_FLAG1],IF_TIMER2OVERFLOW
		
		movb	a, [nl]
		inc		a
  	movb	[nl], a
  	cmp		a, 8
		jnz		wait
	
		movb	a, 0
		movb	[nl], a
	
		##load current tune position
		movw	HL, [tune]
	
		movb	a, [HL]
		andb	a, $3
		movb	[REG_BASE+REG_VOLUME], a
	
		mov		a, [HL]
		shr		a
		shr		a
		movb	[nl2], a
	
		inc		HL
	
		movw	x1, [HL]
		movw	[REG_BASE+REG_TIMER3_PRESET], x1
	
		inc		HL
		inc		HL
	
		movw	x1, [HL]
		movw	[REG_BASE+REG_TIMER3_PIVOT], x1
	
		inc		HL
		inc		HL
	
		movw	x1, [tuneend]
		cmp		HL, x1
		jnz		nomod
		movw	HL, [prevtune]
nomod:

  	movw	[tune], HL
		pop		x1
		pop		HL
		pop		a
    reti

wait:
		movb	b, [nl2]
		cmp		a, b
		jnz		nomute
		movb	a, 0
		movb	[REG_BASE+REG_VOLUME], a
nomute:
		pop		x1
		pop		HL
		pop		a
    reti
    

int_vbl:
		movb	[nn+REG_INT_FLAG1],IF_VBLANK
		call doinputs
		call	[mainvector]
		reti

game_main:
		mov		a, [curx]
		mov		[oldx], a
		mov		a, [cury]
		mov		[oldy], a
		mov		a, [OAM+0]
		mov		[oldxp], a
		mov		a, [OAM+1]
		mov		[oldyp], a
		mov		a, [REG_BASE+REG_BGMOV_V]
		mov		[oldbgv], a
		mov		a, [REG_BASE+REG_BGMOV_H]
		mov		[oldbgh], a

		mov		a, [movedelay]
		inc		a
		mov		[movedelay], a
		cmp		a, DELAYMOVE
		jnz		nomove
		mov		a, 0
		mov		[movedelay], a


		mov		b, [keystates]


		test	b, KEY_LEFT
		jz		left_not_pressed
		mov		a, [OAM+0] 
    sub		a, PLAYERRADIUS+1
    mov		l, a
    mov		a, [OAM+1] 
    sub		a, PLAYERRADIUS
    mov		h, a
		call	docol
		cmp		l, 1
		jz		left_not_pressed #got a col there!
		
		
		mov		a, [OAM+0] 
    sub		a, PLAYERRADIUS+1
    mov		l, a
    mov		a, [OAM+1] 
    add		a, PLAYERRADIUS
    mov		h, a
		call	docol
		cmp		l, 1
		jz		left_not_pressed #got a col there!
		
		
		
		mov		nn, OAM
		mov		a, [gametime]
		test	a, (1<<3)
		jnz		_lf1
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
    mov		[nn+2], a
    jmp		_lf2
_lf1:
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 2			 #sprite 2 auswlen
    mov		[nn+2], a
_lf2:
    mov		a, [nn+0] 
    dec		a
    cmp		a, 16+16
    jl		domovebg_left
    mov		[nn+0], a
    mov		a, [nn+2]
		xor		a, 1
		mov		[nn+2], a
		mov		nn, REG_BASE
		jmp		left_not_pressed

domovebg_left:
		mov		nn, REG_BASE

		
		mov		a, [REG_BASE+REG_BGMOV_H]
		dec		a
		mov		[REG_BASE+REG_BGMOV_H], a
		cmp		a,0
		
		jz		do_move_left

		mov		a, [fc]
		inc		a
		mov		[fc], a
		
		jmp		left_not_pressed

do_move_left:
		mov		a, [curx]	
		cmp		a, 0
		jnz		mmleft
		mov		[nn+REG_BGMOV_H], 1
		jmp		left_not_pressed
mmleft:
		dec		a
		mov		[curx], a
		mov		a, 16
		mov		[REG_BASE+REG_BGMOV_H], a
		mov		a, [fc]
		inc		a
		mov		[fc], a

left_not_pressed:



		test	b, KEY_RIGHT
		jz		right_not_pressed
		mov		a, [OAM+0] 
    add		a, PLAYERRADIUS+1
    mov		l, a
    mov		a, [OAM+1] 
    sub		a, PLAYERRADIUS
    mov		h, a
		call	docol
		cmp		l, 1
		jz		right_not_pressed #got a col there!
		
		
		mov		a, [OAM+0] 
    add		a, PLAYERRADIUS+1
    mov		l, a
    mov		a, [OAM+1] 
    add		a, PLAYERRADIUS
    mov		h, a
		call	docol
		cmp		l, 1
		jz		right_not_pressed #got a col there!
		
		mov		nn, OAM
		mov		a, [gametime]
		test	a, (1<<3)
		jnz		_lf1
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 4
    mov		[nn+2], a
    jmp		_lf2
_lf1:
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 6			 #sprite 2 auswlen
    mov		[nn+2], a
_lf2:
    mov		a, [nn+0] 
    inc		a
    cmp		a, 16+96-16-16
    jg		domovebg_right
    mov		[nn+0], a
    mov		a, [nn+2]
		xor		a, 1
		mov		[nn+2], a
		mov		nn, REG_BASE
		jmp		right_not_pressed
		
domovebg_right:
		mov		nn, REG_BASE
		
		mov		a, [REG_BASE+REG_BGMOV_H]
		inc		a
		mov		[REG_BASE+REG_BGMOV_H], a
		cmp		a,32
		
		jz		do_move_right

		mov		a, [fc]
		inc		a
		mov		[fc], a
		
		jmp		right_not_pressed

do_move_right:
		mov		a, [curx]
		cmp		a, MAP_WIDTH-8
		jnz		mmright
		mov		[nn+REG_BGMOV_H], 31
		jmp		right_not_pressed
mmright:
		inc		a
		mov		[curx], a
		mov		a, 16
		mov		[REG_BASE+REG_BGMOV_H], a
		mov		a, [fc]
		inc		a
		mov		[fc], a

right_not_pressed:



		test	b, KEY_UP
		jz		up_not_pressed
		mov		a, [OAM+0] 
    add		a, PLAYERRADIUS
    mov		l, a
    mov		a, [OAM+1] 
    sub		a, PLAYERRADIUS+1
    mov		h, a
		call	docol
		cmp		l, 1
		jz		up_not_pressed #got a col there!
		
		
		mov		a, [OAM+0] 
    sub		a, PLAYERRADIUS
    mov		l, a
    mov		a, [OAM+1] 
    sub		a, PLAYERRADIUS+1
    mov		h, a
		call	docol
		cmp		l, 1
		jz		up_not_pressed #got a col there!
		
		mov		nn, OAM
		mov		a, [gametime]
		test	a, (1<<3)
		jnz		_lf1
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 8
    mov		[nn+2], a
    jmp		_lf2
_lf1:
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 10			 #sprite 2 auswlen
    mov		[nn+2], a
_lf2:
    mov		a, [nn+1] 
    dec		a
    cmp		a, 16+16
    jl		domovebg_up
    mov		[nn+1], a
    mov		a, [nn+2]
		xor		a, 1
		mov		[nn+2], a
    mov		nn, REG_BASE
    jmp		up_not_pressed

domovebg_up:
		mov		nn, REG_BASE
		
		mov		a, [REG_BASE+REG_BGMOV_V]
		dec		a
		cmp		a,0
		mov		[REG_BASE+REG_BGMOV_V], a
		jz		do_move_up

		mov		a, [fc]
		inc		a
		mov		[fc], a
		
		jmp		up_not_pressed

do_move_up:
		mov		a, [cury]
		cmp		a, 1
		jnz		mmup
		mov		[nn+REG_BGMOV_V], 1
		jmp		up_not_pressed
mmup:
		dec		a
		mov		[cury], a
		mov		a, 16
		mov		[REG_BASE+REG_BGMOV_V], a
		mov		a, [fc]
		inc		a
		mov		[fc], a

up_not_pressed:


		test	b, KEY_DOWN
		jz		down_not_pressed
		mov		a, [OAM+0] 
    add		a, PLAYERRADIUS
    mov		l, a
    mov		a, [OAM+1] 
    add		a, PLAYERRADIUS+1
    mov		h, a
		call	docol
		cmp		l, 1
		jz		down_not_pressed #got a col there!
		
		
		mov		a, [OAM+0] 
    sub		a, PLAYERRADIUS
    mov		l, a
    mov		a, [OAM+1] 
    add		a, PLAYERRADIUS+1
    mov		h, a
		call	docol
		cmp		l, 1
		jz		down_not_pressed #got a col there!
		
		mov		nn, OAM
		mov		a, [gametime]
		test	a, (1<<3)
		jnz		_lf1
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 12
    mov		[nn+2], a
    jmp		_lf2
_lf1:
		mov		a, [nn+2]
		andb	a, 1       #unterstes bit beibehalten
		add		a, 14			 #sprite 2 auswlen
    mov		[nn+2], a
_lf2:
    mov		a, [nn+1] 
    inc		a
    cmp		a, 16+64-16-16 #-16 for sprite height, -16 for space
    jg		domovebg_down
    mov		[nn+1], a
    mov		a, [nn+2]
		xor		a, 1
		mov		[nn+2], a
		mov		nn, REG_BASE
		jmp		down_not_pressed
		
domovebg_down:
		mov		nn, REG_BASE
		
		mov		a, [REG_BASE+REG_BGMOV_V]
		inc		a
		cmp		a,32
		mov		[REG_BASE+REG_BGMOV_V], a
		jz		do_move_down

		mov		a, [fc]
		inc		a
		mov		[fc], a
		
		jmp		down_not_pressed

do_move_down:
		mov		a, [cury]
		cmp		a, MAP_HEIGHT-5
		jnz		mmdown
		mov		[nn+REG_BGMOV_V], 31
		jmp		down_not_pressed
mmdown:
		inc		a
		mov		[cury], a
		mov		a, 16
		mov		[REG_BASE+REG_BGMOV_V], a
		mov		a, [fc]
		inc		a
		mov		[fc], a

down_not_pressed:



nomove:

		call	dogray
		call	loadmap
		ret
	

title_screen:
		mov		b, [keystates]

		test	b, KEY_A
		jz		a_not_pressed
		mov		a, OAM_ENABLE
		mov		[OAM+3], a
		mov		x1, game_main
		mov		[mainvector], x1
a_not_pressed:

		mov		a, [fc]
		inc		a
		mov		[fc], a
		
		test	a, 1
		jnz		_t2
    mov		x1, title1
    jmp		_t1
_t2:
    mov		x1, title2
_t1:
		mov		[REG_BASE+REG_LCD_TILEBGMEM], x1
		
		mov		x1, TILEMAP+2+32
		mov		b, 8
		mov		a, 0
nextrow:
		mov		l, 12
nextcol:
		mov		[x1], a
		inc		x1
		inc		a
		dec		l
		jnz		nextcol
		add		x1, 4

		jdbnz	nextrow
				
		ret
	
start:


    mov   sp, $2000    # set SP
    movw  nn, REG_BASE           # NN reg always point to hardware regs
    
    ### setup DISPLAY
    movb  [nn+REG_LCD_CNT0], (LCD0_TILEBG|LCD0_RENDER|LCD0_MAP16x12|LCD0_SPRITES)     # set tiled mode 12x8, non-inverted
    movb  [nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1        # enable video
    
		
		### setup TIMERS
		mov		[nn+REG_TIMER_CONTROL], TIMERS_ON

		mov		[nn+REG_TIMER2_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_62500HZ
		mov		[nn+REG_TIMER2_CNT1], TIMER_ENABLE | TIMER_PRESET
		mov		[nn+REG_TIMER2_CNT2], 0

		mov		[nn+REG_TIMER3_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ
		mov		[nn+REG_TIMER3_CNT1], TIMER_ENABLE | TIMER_PRESET
		mov		[nn+REG_TIMER3_CNT2], 0

		movw	x1, 0
		movw	[REG_BASE+REG_TIMER3_PRESET], x1
		movw	[REG_BASE+REG_TIMER3_PIVOT], x1

    movw	x1, [music]
		movw	[REG_BASE+REG_TIMER2_PRESET], x1
		mov		[nn+REG_VOLUME], 3


		### SETUP SOUND STUFFS
		movw	x1, music+2
		movw	[tune], x1
		movw	[prevtune], x1
		
		movw	x1, music_e
		movw	[tuneend], x1

		movb	a, 7
		movb	[nl], a
			
			
		### SETUP MAP STUFFS
		mov		[nn+REG_BGMOV_V], 16
		mov		[nn+REG_BGMOV_H], 16
		mov		x1, map001
		mov		[curmap], x1
		mov		a, 4
		mov		[curx], a
		mov		[cury], a


		### setup SPRITES
		mov		nn, OAM
		mov		[nn+0], 16+48-8
    mov		[nn+1], 16+32-8
    mov		[nn+2], 0
    mov		[nn+3], OAM_DISABLE
    mov		nn, REG_BASE
    
    mov		x1, player
    mov		[REG_BASE+REG_LCD_SPRITEMEM], x1
		

		### setup VARIOUS
		mov		a, 1
		mov		[debouncers+0], a
		mov		[debouncers+1], a
		mov		[debouncers+2], a
		mov		[debouncers+3], a
		mov		[debouncers+4], a
		mov		[debouncers+5], a
		mov		[debouncers+6], a

		mov		x1, title_screen
		mov		[mainvector], x1


		### setup INTERRUPTS
    mov   [nn+REG_EVENT2S],INT2S_KEY_POWER	# Interrupt Enable
    mov   [nn+REG_EVENT2P],INT2P_KEYPAD	# Master Enable
	
		mov		[nn+REG_EVENT1P],INT1P_TIMER2OVERFLOW|INT1P_V
		mov		[nn+REG_EVENT1S],INT1S_TIMER2OVERFLOW|INT1S_VBLANK
	

		### get irqs working in minimon
		mov   flags,0			

main_game:
	#	call doinputs
	#	call	[mainvector]
	#	call waitsync
    jmp main_game


.equ		MAP_WIDTH		16
.equ		MAP_HEIGHT  16
        
loadmap:
		push	x1
		push	x2
		push	HL
		push	BA
		
    mov 	x1,[curmap]
       
    mov		BA, 0
    mov		a, [curx]
    add		x1, BA
    
    mov		b, [cury]
    mov		HL, -MAP_WIDTH
multiplier:
		add		HL, MAP_WIDTH
		jdbnz multiplier
    add		x1, HL
    
    mov 	x2,TILEMAP
    mov		HL,$0
    
copy_level:
		push	BA
		mov		BA, [there]
		cmp	BA, x1
		jz		laaaaaaaal
		
		pop		ba
		
    mov a,[x1]
    inc x1
    mov [x2],a
    inc a
    mov [x2+1],a
    add a, 15
    mov [x2+16],a
    inc a
    mov [x2+17],a
    jmp lewl
    
laaaaaaaal:
		pop		ba
		mov	a, 10
    inc x1
    mov [x2],a
    inc a
    mov [x2+1],a
    add a, 15
    mov [x2+16],a
    inc a
    mov [x2+17],a
lewl:
    
    add x2, 2
    inc l
    cmp l, 8
    jnz	dontnextrow
		add x1, MAP_WIDTH-8
		add x2, 16
		mov l, 0
		inc h
dontnextrow:
    cmp h,12
    jnz copy_level
 
 		pop		BA
 		pop		HL
 		pop		x2
 		pop		x1
    ret


#========================= DOCOL ========================= 
# Check for collision with map
#=========================================================
# l = x
# h = y
docol:
		push	x1
		push	BA
	
		#test for collision
		mov		x1, map001
		mov		b, 0
		mov		a, [curx]
		add		x1, BA
		mov		b, [nn+REG_BGMOV_H]
		mov		a, l
		sub		a, 32-8
		add		a, b
		mov		b, 0
		shr		a
		shr		a
		shr		a
		shr		a
		
		add		x1, BA
		
		
		mov		b, [nn+REG_BGMOV_V]
		mov		a, h
		sub		a, 32-8
		add		a, b
		mov		b, 0
		shr		a
		shr		a
		shr		a
		shr		a
		
		mov		h, 0
		mov		l, [cury]
		
		add		BA, HL
		
		
		shl a
	  rolc b
		shl a
	  rolc b
	  shl a
	  rolc b
	  shl a
	  rolc b
	  
		add		x1, BA
		#mov		[there], x1
	
		inc		x1
		mov		a, [x1]
		test	a, 128
		jnz		_col
		

		mov		l, 0
		jmp		_nocol
_col:
		#mov		[there], x1
		mov		l, 1

_nocol:

		pop		BA
		pop		x1
		ret


#========================= DOGRAY ========================= 
# Flips the sprites and tile background
#==========================================================
dogray:
		push 	a
		push 	x1
		
		mov	a, [gametime]
		inc	a
		mov	[gametime], a
		
		mov	a, [fc]
		inc	a
		mov	[fc], a
		
		test	a, 1
		jnz		_t2
    mov		x1, tiles1
    jmp		_t1
_t2:
    mov		x1, tiles2
_t1:
		mov		[REG_BASE+REG_LCD_TILEBGMEM], x1
		
		mov		x1, OAM+2
_donextspr:
		
		mov		a, [x1]
		xor		a, 1
		mov		[x1], a
		add		x1,4
		
		cmp		x1, OAM+2+23*4
		jnz		_donextspr
		
		pop		x1
		pop 	a
		ret


doinputs:
		push	BA
		mov		b, 0

	  mov		a, [debouncers+0]
	  test	[nn+REG_KEYPAD],KEY_UP
    jnz		_up_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl		_up_handled
    orb   b, KEY_UP
    mov		a, DELAYTIME-1
    jmp		_up_handled
_up_not_pressed:
    dec		a
    jnz		_up_handled
    mov		a, 1
_up_handled:
		mov		[debouncers+0], a


		mov		a, [debouncers+1]
	  test	[nn+REG_KEYPAD],KEY_DOWN
    jnz		_down_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl		_down_handled
    orb   b, KEY_DOWN
    mov		a, DELAYTIME-1
    jmp		_down_handled
_down_not_pressed:
    dec		a
    jnz		_down_handled
    mov		a, 1
_down_handled:
		mov		[debouncers+1], a
		
		
		mov		a, [debouncers+2]
	  test	[nn+REG_KEYPAD],KEY_LEFT
    jnz		_left_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl		_left_handled
    orb   b, KEY_LEFT
    mov		a, DELAYTIME-1
    jmp		_left_handled
_left_not_pressed:
    dec		a
    jnz		_left_handled
    mov		a, 1
_left_handled:
		mov		[debouncers+2], a
		
		
		mov		a, [debouncers+3]
	  test	[nn+REG_KEYPAD],KEY_RIGHT
    jnz		_right_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl   _right_handled
    orb   b, KEY_RIGHT
    mov		a, DELAYTIME-1
    jmp		_right_handled
_right_not_pressed:
    dec		a
    jnz		_right_handled
    mov		a, 1
_right_handled:
		mov		[debouncers+3], a
		
		
		mov		a, [debouncers+4]
	  test	[nn+REG_KEYPAD],KEY_A
    jnz		_a_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl   _a_handled
    orb   b, KEY_A
    mov		a, DELAYTIME-1
    jmp		_a_handled
_a_not_pressed:
    dec		a
    jnz		_a_handled
    mov		a, 1
_a_handled:
		mov		[debouncers+4], a


		mov		a, [debouncers+5]
	  test	[nn+REG_KEYPAD],KEY_B
    jnz		_b_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl   _b_handled
    orb   b, KEY_B
    mov		a, DELAYTIME-1
    jmp		_b_handled
_b_not_pressed:
    dec		a
    jnz		_b_handled
    mov		a, 1
_b_handled:
		mov		[debouncers+5], a


		mov		a, [debouncers+6]
	  test	[nn+REG_KEYPAD],KEY_C
    jnz		_c_not_pressed
    inc		a
    cmp		a, DELAYTIME
    jl   _c_handled
    orb   b, KEY_C
    mov		a, DELAYTIME-1
    jmp		_c_handled
_c_not_pressed:
    dec		a
    jnz		_c_handled
    mov		a, 1
_c_handled:
		mov		[debouncers+6], a

		mov		[keystates], b
		pop		BA
		ret

### waitsync
# this function checks the VBLANK IRQ bit in the interrupt register
waitsync: 
    # clear interrupt flag
    mov		[nn+REG_INT_FLAG1], IF_VBLANK
_waitsyncloop:
    # cheack if interrupt flag got set again (vblank IRQ occoured)
    test	[nn+REG_INT_FLAG1], IF_VBLANK
    # check again if no vblank IRQ occoured
    jz		_waitsyncloop
    # return from function
    ret


.align 8
title1:
.incbin title1.bin
title2:
.incbin title2.bin

map001:
.incbin test.bin

### tile data (align 8 bytes)
.align	8
tiles1:
.incbin tiles1.bin
tiles2:
.incbin tiles2.bin

.align 64
player:
.incbin player.bin

music:
.incbin zelda.sfx
music_e: