;------------------------------------------------------------
; TeamPokeme Logo (Non-BIOS Version)
;
; Created by PokeSlap on 2004
; Please, don't change this file without notice me
;
;------------------------------------------------------------

	.org 0x009A
	jmp start

	.org 0x2100
	.db "MN"

	.org 0x2102
	jmp start
	.org 0x2108	; 0x01CF			; interrupt vectors...
	jmp unknown
	.org 0x210E	; 0x01E0
	jmp unknown
	.org 0x2114	; 0x01F1
	jmp unknown
	.org 0x211A	; 0x0202
	jmp unknown
	.org 0x2120	; 0x0213
	jmp unknown
	.org 0x2126	; 0x0224
	jmp unknown
	.org 0x212C	; 0x0235
	jmp unknown
	.org 0x2132	; 0x0246
	jmp unknown
	.org 0x2138	; 0x025A
	jmp unknown
	.org 0x213E	; 0x026D
	jmp unknown
	.org 0x2144	; 0x027C
	jmp unknown
	.org 0x214A	; 0x028D
	jmp unknown
	.org 0x2150	; 0x029E
	jmp unknown
	.org 0x2156	; 0x02AF
	jmp unknown
	.org 0x215C	; 0x02C0
	jmp unknown
	.org 0x2162	; 0x02D1
	jmp unknown
	.org 0x2168	; 0x02E2
	jmp unknown
	.org 0x216E	; 0x02F3
	jmp unknown
	.org 0x2174	; 0x0304
	jmp unknown
	.org 0x217A	; 0x0315
	jmp unknown
	.org 0x2180	; 0x0326
	jmp unknown
	.org 0x2186	; 0x0337
	jmp unknown
	.org 0x218C	; 0x0348
	jmp unknown
	.org 0x2192	; 0x035C
	jmp unknown
	.org 0x2198	; 0x036D
	jmp unknown

	.org 0x21A4
	.db "NINTENDO"
	.db "MUTE"               ; Mini UnTitled English
	.db "Untitled    "
	.db "2P"
	
	.org	0x21D0

unknown:
	jmp unknown              ; Unhandled calls

start:	
	; Set SP
	mov sp, $2000            ; Put stack on top of RAM
	; Init CPU
	movx hl, $00             ; Keep HL[23:16] to 0x00
	mov nn, $2000            ; Point NN into Pokemon-mini IO area
	orb [nn+$08], $00        ; Disable Seconds-Timer
	; Set Up Graphics
	mov [nn+$80], $00        ; Disable Display
	mov [nn+$81], $00        ; Disable Display
        ; Draw graphics
	mov x1, image            ; Image area
	mov x2, $1000            ; Tiledata Area when Reallocable-Tileset isn't selected
	mov hl, 768              ; Size of Image (96 x 64 = 6144 Bits = 768 Bytes)
loop_linear:
	mov a, [x1]
	mov [x2],a               ; Copy Src to Dest
	inc x1
	inc x2                   ; Increment Src & Dst
	dec hl                   ; 1 Byte as been trasnfered!
	jnz loop_linear          ; If it didnt transfered 768 Bytes, keep looping
        ; Enable Display
	or [nn+$80], $08         ; Enable Display
	or [nn+$81], $01         ; Enable Display & Non-Reallocable-Tileset
loop:
	mov b, [nn+$52]          ; Put keys information into register B
	test b, $80              ; Test if Power button is pressed
	jz poweroff              ; Jump to "poweroff" if is pressed
	jmp loop                 ; Loop forever

poweroff:
	cint $21
	cint $24
	jmp poweroff

image:
	.include teampokemel.inc ; Image Data
