#############################################################################
#                            SOKOMINI 1.0                                   #
#                           (C) DaveX, 2004                                 #
#############################################################################
#
# You have in your hands the first homebrew Pokemon Mini game ! It works
# in the Pokemon Channel emulator, and probably on hardware too ! 
# One week ago I didn't know what a pokemon mini was. This is the result
# of one week of hardcore reverse-engineering. Not only hardware registers, 
# but I also reverse-engineered the CPU using an emulator in the Pokemon
# Channel gamecube game... for all the info i've gathered look for a file named 
# "mindx.txt" ! Have pokefun! ;-)
#
# GAME KEYS: direction pad to move
#            B to restart current level (you'll need it! ;-)
#            C to go back to splash screen
# 
#                                                    -- DaveX 2 june 2004
# Use the mindx assembler/disassembler to assemble
#   mindx a soka.asm soka.min
# 
# greets to p0p, Dark Fader (i used your bmp2min program ;), JustBurn,
# Mr. spiv, Costis and the PM freaks I forgot ;)
#
#(small fixes for real hw by p0p - I am not worthy ;P)

#
#-------------------------------------- BIOS --------------------------------
.org 0
bios:

# If you don't have PM BIOS, just comment the ".incbin bios.min" line and 
# uncomment the following lines, it will work without the real bios!

#.incbin bios.min

# .dw bios_entrypoint   # reset vector
# .dw unhandled_interrupt
# .dw unhandled_interrupt
# .db "DaveX-2004"
# .orgfill 0x9a
# bios_entrypoint:
# jmp $2102            

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM
.orgfill 0x1800
position:
    .db 0
newposition:
    .db 0
levelnb:
    .db 0
levelptr:
    .dw 0

#--------------------------------- HARDWARE REGS ----------------------------
.orgfill 0x2000
hwregs:    

#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
.orgfill 0x2102   # int 0
    jmp start
.orgfill 0x2108   # 
    jmp unhandled_interrupt
.orgfill 0x210E   # 
    jmp unhandled_interrupt
.orgfill 0x2114   # 
    jmp unhandled_interrupt
.orgfill 0x211A   # 
    jmp unhandled_interrupt
.orgfill 0x2120   # 
    jmp unhandled_interrupt
.orgfill 0x2126   # 
    jmp unhandled_interrupt
.orgfill 0x212C   # 
    jmp unhandled_interrupt
.orgfill 0x2132   # 
    jmp unhandled_interrupt
.orgfill 0x2138   # 
    jmp unhandled_interrupt
.orgfill 0x213E   # 
    jmp unhandled_interrupt
.orgfill 0x2144   # 
    jmp unhandled_interrupt
.orgfill 0x214A   # 
    jmp unhandled_interrupt
.orgfill 0x2150   # 
    jmp unhandled_interrupt
.orgfill 0x2156   # 
    jmp unhandled_interrupt
.orgfill 0x215C   # 
    jmp unhandled_interrupt
.orgfill 0x2162   # 
    jmp unhandled_interrupt
.orgfill 0x2168   # 
    jmp unhandled_interrupt
.orgfill 0x216E   # 
    jmp unhandled_interrupt
.orgfill 0x2174   # 
    jmp unhandled_interrupt
.orgfill 0x217A   # 
    jmp unhandled_interrupt
.orgfill 0x2180   # 
    jmp unhandled_interrupt
.orgfill 0x2186   # 
    jmp unhandled_interrupt
.orgfill 0x218C   # 
    jmp unhandled_interrupt
.orgfill 0x2192   # 
    jmp unhandled_interrupt
.orgfill 0x2198   # 
    jmp unhandled_interrupt
.orgfill 0x219E   # 
    jmp unhandled_interrupt
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "DAVEX_SOKOMINI"   # name of rom, 16 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0

unhandled_interrupt:
    reti

start:
    mov   sp, $2000    # set SP
    call  init_system_and_video

title_screen:

    xor  a,a
    mov  [levelnb],a   # we start from 1st level!

    call  video_linear_mode   # switch to "linear" mode

grayscale_title:
    mov  x1, splash_screen               # set tiles graphix base
    mov [$2082],x1
    call waitsync    
    mov  x1, splash_screen+$300           # set tiles graphix base
    mov [$2082],x1
    call waitsync
    test   [nn+$52],1    # "A" key pressed ?    
    jnz  grayscale_title


    
main_game:
    mov  x1, tiles           # set tiles graphix base
    mov [$2082],x1

nextlevel:
    mov b,0
    mov a,[levelnb]
    add a,a
    mov x1,levels
    add x1,ba
    mov a,[x1]
    mov b,[x1+1]
    mov [levelptr],ba
    
    
restartlevel:
#   mov x1,level+1
    mov x1,[levelptr]
    inc x1
    mov x2,$1360      # we copy the first level
    mov l,$0          
copy_level:
    mov a,[x1+l]
    mov [x2+l],a
    inc l    
    cmp l,$60
    jnz copy_level
    
    mov x1,[levelptr]   
    mov a,[x1]
    mov [position],a
    

levelloop:
waitkey:
    mov x1,$1360
    mov l,[position]
    mov a,[$2009]  # change the sprite in fonction of the second counter
    and a,$3
    add a,4
    mov [x1+l],a
     
    mov a,[position]
    mov b,[nn+$52]     # read key pressed in B register
    
    test b,2
    jz   key_b
    test b,4
    jz   key_c
    test b,8
    jz   key_up
    test b,$10
    jz   key_down
    test b,$20
    jz   key_left
    test b,$40
    jz   key_right
    test b,$80
    jz   key_power
    
    jmp  waitkey
    
key_b:
    jmp  restartlevel

key_c:
    jmp  title_screen

    
key_up:
    sub a,12
    jmp afterkey
key_down:
    add a,12
    jmp afterkey
key_right:
   inc a
   jmp afterkey
key_left:
    dec a
    jmp afterkey
key_power:
    int $21         # standby :)
    jmp levelloop
 
afterkey:    
    mov [newposition],a
waitkeyrelease:
    mov b,[nn+$52]
    cmp b,$ff
    jnz waitkeyrelease

# check for wall
    mov l,a
    mov x1,$1360
    mov b,[x1+l]
    cmp b,1          # wall 
    jz waitkey       # we don't move
    
# check for boxes
    mov l,a
    mov x1,$1360
    mov b,[x1+l]
    cmp b,2          # wall 
    jnz notbox    
box:    # ok we have a box...
    mov a,[newposition]
    sub a,[position] 
    add a,a             #  we do two times the same displacement
    add a,[position]    # a = new position of the box
    mov l,a
    mov a,[x1+l]
    cmp a,1        # wall ?
    jz  waitkey    # we don't move
    cmp a,2        # box ?
    jz  waitkey    # we don't move
    mov a,2
    mov [x1+l],a   # we move
    
        
notbox:
#    mov x2,level+1
    mov x2,[levelptr]
    inc x2
    mov x1,$1360
    mov l,[position]
    mov a,[x2+l]       # we erase the floor with the old tile
    cmp a,3
    jz  erasefloor
    mov a,0
erasefloor:
    mov [x1+l],a    
    mov l,[newposition]
    mov [position],l

    mov x1,$1360       # that's us!
    mov l,[position]
    mov a,[$2009]  # change the sprite in fonction of the second counter
    and a,$3
    add a,4
    mov [x1+l],a
    
# let's check if we finished the level !
#    mov x2,level+1
    mov x2,[levelptr]
    inc x2
    mov x1,$1360
    mov l,0
    mov h,0  # flag
loopcheck:    
    mov a,[x1+l]
    mov b,[x2+l]
    cmp b,3  
    jnz checknotbase
    cmp a,2
    jz  checkokbox
    mov h,1
checkokbox:
checknotbase:    
    inc l
    cmp l,$60
    jnz loopcheck    
    cmp h,0
    jz  level_cleared
    
    
    jmp levelloop
    
level_cleared:
    mov a,[levelnb]
    inc a
    mov [levelnb],a
    jmp nextlevel

inf:
    jmp inf
    
#############################################################################
waitsync:
    test [nn+$8A], 1<<4
    jnz waitsync
waitsync2:
    test [nn+$8A], 1<<4
    jz waitsync2
    ret
  
#############################################################################
init_system_and_video:
 
 movx  hl, $00             # important also for NN addressing!
 movw  nn, $2000           # NN reg always point to hardware regs
 movb  [nn+$08], $02       # reset second counter
 orb  [nn+$08], $01        # start second counter

 movb  [nn+$80], $02+8     # set tiled mode 12x8, non-inverted
 movb  [nn+$81], $9        # enable video
 movw  x1, $4000           
 movw [$2082],x1           # set tiles graphix base
    
 ret
 
#############################################################################
video_linear_mode:

    mov x2,$1360      # we stay in tiled mode, but we put tile 0,1,2,3,4,etc
    mov l,$0          # on screen
loop_linear:
    mov a,l
    mov [x2+l],a
    inc l    
    cmp l,$60
    jnz loop_linear
    ret

#############################################################################
#level:   ; 0 = free, 1 = wall, 2 = box, 3 = destination place, 4 = you!

levels:
   .dw level1
   .dw level5
   .dw level2
   .dw level3
   .dw level6
   .dw level4
   .dw level7
   .dw levelend

#level:
level0:
 .db 14  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,4,0,2,0,3,0,0,1,0,1
 .db 1,0,0,0,0,0,0,0,0,1,0,1
 .db 1,0,0,0,0,0,0,1,0,1,0,1
 .db 1,0,0,1,1,1,1,1,0,1,0,1
 .db 1,0,0,0,1,0,0,0,0,0,0,1
 .db 1,0,0,0,0,0,0,1,0,0,0,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level1:
 .db 58  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,0,1,1,0,0,0,0,1,3,1
 .db 1,0,0,0,0,0,0,0,0,1,3,1
 .db 1,0,0,0,0,0,0,1,0,1,0,1
 .db 1,0,0,1,1,1,1,1,0,1,4,1
 .db 1,0,2,0,1,0,0,0,2,0,0,1
 .db 1,0,0,0,0,0,0,1,0,0,0,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level2:
 .db 12  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 4,0,0,0,0,0,0,1,0,0,1,1
 .db 0,0,1,0,1,0,0,0,0,0,0,1
 .db 0,0,2,2,2,0,0,0,1,0,1,1
 .db 1,1,1,0,0,1,1,0,0,0,1,3
 .db 1,0,0,0,1,1,1,1,0,0,0,3
 .db 1,0,0,0,0,0,0,0,0,0,0,3
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level3:
 .db 73  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,3,3,0,0,0,0,0,0,1,0,1
 .db 1,3,3,1,0,0,1,0,0,1,0,1
 .db 1,0,0,1,1,0,1,0,0,2,0,1
 .db 1,0,0,0,0,0,0,0,1,1,0,1
 .db 1,0,2,1,1,2,0,2,0,0,0,1
 .db 1,4,0,0,0,0,1,0,0,0,0,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level4:
 .db 73  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,0,1,0,0,0,0,0,0,0,1
 .db 1,0,0,0,2,0,1,2,1,1,0,1
 .db 1,0,0,1,0,0,0,2,0,1,0,1
 .db 1,1,0,2,0,1,0,0,0,0,0,1
 .db 1,0,0,0,1,1,0,1,1,0,1,1
 .db 1,0,1,0,0,0,0,3,3,3,3,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level5:
 .db 27  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,0,0,0,1,0,1,0,0,0,1
 .db 1,0,2,4,1,0,0,0,0,0,0,1
 .db 1,0,0,0,1,0,0,1,0,1,0,1
 .db 1,1,1,0,0,1,0,1,0,1,0,1
 .db 1,0,0,0,0,2,0,0,0,1,3,1
 .db 1,0,0,0,0,0,0,1,0,1,3,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level6:
 .db 33  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,0,0,0,0,0,1,0,0,0,1
 .db 1,0,1,0,1,0,1,3,3,4,0,1
 .db 1,0,0,0,1,2,0,1,1,0,0,1
 .db 1,0,0,2,0,0,0,2,0,0,0,1
 .db 1,0,2,1,1,1,0,0,1,2,0,1
 .db 1,0,0,0,3,3,0,0,0,0,3,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

level7:
 .db 17  ; startpos
 .db 1,1,1,1,1,1,1,1,1,1,1,1
 .db 1,0,0,0,1,0,0,1,0,0,0,1
 .db 1,0,0,0,1,3,3,0,2,2,0,1
 .db 1,0,2,0,0,3,3,0,0,0,0,1
 .db 1,0,2,1,0,3,3,1,1,2,0,1
 .db 1,0,0,2,2,3,3,0,2,0,0,1
 .db 1,0,1,0,0,0,0,0,0,0,0,1
 .db 1,1,1,1,1,1,1,1,1,1,1,1

levelend:
 .db 33+12  ; startpos
 .db 3,2,0,0,0,0,0,0,0,0,2,3
 .db 0,1,1,0,1,1,0,0,1,1,0,0
 .db 0,1,0,0,1,0,1,0,1,0,1,0
 .db 0,1,1,0,1,0,1,0,1,4,1,0
 .db 0,1,0,0,1,0,1,0,1,0,1,0
 .db 0,1,0,0,1,0,1,0,1,0,1,0
 .db 0,1,1,0,1,0,1,0,1,1,0,0
 .db 3,2,0,0,0,0,0,0,0,0,2,3

.orgfill 0x5000
splash_screen:
.incbin sm1.lin
.orgfill 0x5300
.incbin sm2.lin
.orgfill 0x6000
tiles:
.incbin smtiles.lin

