
.include	"pmio.asm"

#-------------------------------------- RAM ---------------------------------
.orgfill 0x1000   # first part of RAM is VRAM
.orgfill 0x1460
delta:
dy:
.db		0
dx:
.db     0

position:
px:
.db     0
py:
.db     0

scurl:
.db		0

smaxl:
.db     0

snake:
.ds		(256*2) ## 512 bytes array - address & 8 bit tile value

sap:
.db		0

seed:
.db		0

foody:
.db		0
foodx:
.db		0

score:
.dw		0

speed:
.db		0

speed2:
.db		0

vblank:
.dw		0

frame:
.db		0

#---------------------------- CART INTERRUPT HANDLERS -----------------------
.orgfill 0x2100   # "MN" ID
.db "MN"
#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
	mov	HL, [vblank]
    jmp HL
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp unhandled_interrupt
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp int_key_right
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp int_key_left
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp int_key_down
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp int_key_up
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
.orgfill 0x219E   
## 0
    
#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"         # magic signature checked by the BIOS
.db "LUPI"             # game code - 4 byte
.db "PokeSnake   "     # name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0

unhandled_interrupt:
    reti
    
        
int_key_up:
    movb	[nn+REG_INT_FLAG2],IF_KEY_UP
    movw	HL, [delta]
    cmp		HL, $0001
    jz		nochng1
    movw	HL, $00FF
    movw    [delta], HL
nochng1:    
	reti

int_key_down:
    movb	[nn+REG_INT_FLAG2],IF_KEY_DOWN
    movw	HL, [delta]
    cmp		HL, $00FF
    jz		nochng2
    movw	HL, $0001
    movw    [delta], HL
nochng2:    
	reti

int_key_left:
    movb	[nn+REG_INT_FLAG2],IF_KEY_LEFT
    movw	HL, [delta]
    cmp		HL, $0100
    jz		nochng3
    movw	HL, $FF00
    movw    [delta], HL
nochng3:    
	reti

int_key_right:
    movb	[nn+REG_INT_FLAG2],IF_KEY_RIGHT
    movw	HL, [delta]
    cmp		HL, $FF00
    jz		nochng4
    movw	HL, $0100
    movw    [delta], HL
nochng4:
	reti

int_power_key:
	movb	[nn+REG_INT_FLAG2],IF_KEY_POWER
	test	[nn+$52],$80		# Power key
	jnz		noturnoff
	cint	$24			# bye bye
noturnoff:
	reti

###############################
### TITLE SCREEN # VBLANK IRQ #
###############################
titlescreen:
	movb	[nn+REG_INT_FLAG1],IF_VBLANK
	
	### increment frame counter
	mov		a, [frame]
	inc		a
	mov		[frame], a
	
	test	a, 1
	jnz		t2__
	mov  	x1, title1           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
	jmp		t1__
t2__:
	mov  	x1, title2           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
t1__:
	
    movb	b, [REG_BASE+REG_KEYPAD]
    test	b, KEY_A
    jnz		notpressed
    
    mov		a, [sap]
    cmp		a, 1
    jz		notreleased
    
    call	loadmap
	call	placefood
    call	startgame
    
notpressed:
	mov		a, 0
	mov		[sap], a
notreleased:
    
	reti

#################################
# GAME OVER SCREEN # VBLANK IRQ #
#################################
goscreen:
	movb	[nn+REG_INT_FLAG1],IF_VBLANK
	
	### increment frame counter
	mov		a, [frame]
	inc		a
	mov		[frame], a
	
	test	a, 1
	jnz		t2_
	mov  	x1, go1           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
	jmp		t1_
t2_:
	mov  	x1, go2           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
t1_:

    movb	b, [REG_BASE+REG_KEYPAD]
    test	b, KEY_A
    jnz		notitlescreen
    call	bglinear
    mov		a, 1
    mov		[sap], a
    mov		x1, titlescreen
    mov		[vblank], x1
notitlescreen:
	reti


############################
### MAIN GAME # VBLANK IRQ #
############################
main_game:
	movb	[nn+REG_INT_FLAG1],IF_VBLANK
	
	### increment frame counter
	mov		a, [frame]
	inc		a
	mov		[frame], a
	
	test	a, 1
	jnz		t2
	mov  	x1, tiles1           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
	jmp		t1
t2:
	mov  	x1, tiles2           # set tiles graphix base
    mov 	[REG_BASE+REG_LCD_TILEBGMEM],x1
t1:

	mov		b, [speed]
	cmp		a, b
	jnz		noaction  ##exit vblank directly, this round was just for flickering
	mov		[nn+$61],$64		#stop rumbler :)
	
	and		b, 1
	mov		[frame], b
	
	

    ### CHECK FOR FOOD
    mov		a, [px]
    mov		b, [foodx]
    cmp		a, b       #check X
    jnz		nofood
    
    mov		a, [py]
    mov		b, [foody]
    cmp		a, b       #check Y
    jnz		nofood
    
    mov		a, [smaxl]
    inc		a
    mov		[smaxl], a #snake 1 brick longer
    call	placefood
    
    movw	BA, [score] #Add 50 score
    add		BA, 50
    movw	[score], BA

	mov		[nn+$61],$10		#RUMBLE!

	mov		a, [speed2]  #Make the game faster
	inc		a
	cmp		a, 16
	jnz		nsb
	mov		b, [speed]
	dec		b
	cmp		b, 2
	jnz		nsb2
	mov		b, 3
nsb2:
	mov		[speed], b
	xor		a, a
nsb:	
	mov		[speed2], a

nofood:
    
    

    ### increment player position
    movw	BA, [position]
	add     a, [dx]
	xchg    a, b
	add     a, [dy]
	xchg    a, b
	movw    [position], BA


	
	## draw
	#a * 12
	movb	a, [py]
	shr		a  ## needed
	shl		a
	shl		a  
	mov     b, a  ## HL = py * 4
	shl     a     ## a = py * 8 
	add     a, b  ## BA = py*8 + py*4

    mov		b, [px]
    shr		b   ## needed
        
	add     a, b  ## py*12 + px
	
	mov		b, 0
	
    mov		x2, TILEMAP
    add		x2, BA
    mov 	l, a

   
    ## calculate tile ID
    mov		a, [px]
    andb	a, 1
    inc     a
    
    mov		b, [py]
    test	b, 1
    jz      firstrow
    shl		a
    shl		a
firstrow:


    
    
    ## Get current tile in b
    mov		x1, [delta]
    cmp		x1, 0
    jz		noaction  ## if no delta set dont check wall hit

    #######################
    ## HANDLE SNAKE TAIL ##
    #######################
	mov		h, a          ### store a (ID of new tile)
	
    mov		x1, snake     ### load snake array
    
    mov		a, [sap]      ### load current index in array
    inc		a			  ### sap + 1
    mov		[sap], a	  ### sap = sap +1
    dec     a             ### sap - 1
    mov		b,0
    add		BA, BA        ### sap * 2 (snake info is 2 bytes)
    add		x1, BA        ### snake[sap]
    
    movw	[x1], HL      ### store snake info l is address, h is ID

	mov		a, h          ### a got corrupted, restore
   
   
   
    ### CHECK WALL HIT
    mov		b, [x2]         ### load old tile
    xchg	a, b
    test	a, b			### check if b is already set
    xchg    a, b
    jz		notgameover		### Game Over if set (hit another tile)
    call	gameover
    mov		x1, goscreen
    mov		[vblank], x1
    reti					### exit IRQ
notgameover:
    
    orb		a, b			### OR the tile and old tile together
    mov     [x2], a         ### store new tile


    
    ##############################
    ## snake got 1 brick longer ##
    ##############################
    mov		a, [scurl]
    inc		a
    mov		[scurl], a

    ### compare current snake length with max snake length
	mov		b, [smaxl]
	cmp		a, b
	jnz		noaction
	### delete 1 brick of snake
	
	### we are deleting one brick, the snake gets shorter
	dec		a
	mov		[scurl], a
    
    ### Get brick information of the tail
    mov		a, [sap]
    mov		b, [smaxl]
    sub		a, b
    mov		b,0
 	add		BA, BA  ### snake info is 2 bytes long
	
	### load array address
	mov		x1, snake
    add		x1, BA  ### add index
    
    mov		a, [x1+1] ### load tile
    mov		l, [x1]   ### load address
    mov     h, 0

	notb	a         ### create mask
	
    mov		x1, TILEMAP
    add		HL, x1
    andb	[HL], a

noaction:    
    reti



##########################
# START # GAME START IRQ #
##########################
start:
    mov		sp, $2000
    movw	nn, REG_BASE           # NN reg always point to hardware regs
    
    ### set up LCD
    movb	[nn+REG_LCD_CNT0], (LCD0_TILEBG|LCD0_RENDER|LCD0_SPRITES)     # set tiled mode 12x8, non-inverted
    movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1        # enable video
    
    ### activate input events
    mov		[nn+REG_EVENT2S],INT2S_KEY_UP|INT2S_KEY_DOWN|INT2S_KEY_LEFT|INT2S_KEY_RIGHT|INT2S_KEY_POWER	# Interrupt Enable
    mov		[nn+REG_EVENT2P],INT2P_KEYPAD	# Master Enable
    
	### activate timer
	mov		[nn+REG_TIMER256_CNT], 0b011

	### set sprite memory
    mov		x1, food
    mov		[REG_BASE+REG_LCD_SPRITEMEM],x1

    ### activate sprite
	mov		nn, OAM
	mov		x1, 0
	movw	[OAM+0], x1
    movb	[nn+2], 0
    movb	[nn+3], 0b00001000
	mov		nn, REG_BASE

	### set up background to linear mode
    call	bglinear
    
    ### set vblank interrupt to title screen
    mov		x1, titlescreen
    mov		[vblank], x1
    mov		[nn+REG_EVENT1S],INT1S_VBLANK
    mov		[nn+REG_EVENT1P],INT1P_V	# Master Enable
    
    mov		flags,0			# get irqs working in minimon
	
endless:
	jmp		endless	

###############################
# START GAME # SETUP FUNCTION #
###############################
startgame:
	mov		a, 12
	mov		[px], a
	mov		a, 8
	mov		[py], a
	mov		a, 4
	mov		[smaxl], a
	mov		a, 10
	mov		[speed], a
	mov		a, [REG_BASE+REG_TIMER256_COUNT]
	mov		[seed], a
	movw	BA, 0
	mov		[speed2], a
	mov		[scurl], a
	movw	[delta], BA
	movw	[score], BA
	mov		[sap], a
	mov		[frame], a
	
	mov		x1, main_game
	mov		[vblank], x1
	ret
	
##############################
# GAME OVER # SETUP FUNCTION #
##############################
gameover:
	call	bglinear  #setup "pseudo linear mode"
	mov		x1, 0
	movw	[OAM], x1 #hide sprite
	
	
	mov		x2, TILEMAP
	add		x2, 75
	mov		[x2], 96
	inc		x2
	mov		BA, [score]
	
	mov		l, 0	
checkdiv1:
	cmp		BA, 10000
	jl		nosub1
	
	sub		BA, 10000
	inc		l
	jmp		checkdiv1
nosub1:
	
	xchg	BA, HL
	add		a, 96
	mov		[x2], a
	inc		x2
	xchg	BA, HL
	
	mov		l, 0	
checkdiv2:
	cmp		BA, 1000
	jl		nosub2
	
	sub		BA, 1000
	inc		l
	jmp		checkdiv2
nosub2:
	
	xchg	BA, HL
	add		a, 96
	mov		[x2], a
	inc		x2
	xchg	BA, HL
	
	mov		l, 0	
checkdiv3:
	cmp		BA, 100
	jl		nosub3
	
	sub		BA, 100
	inc		l
	jmp		checkdiv3
nosub3:
	
	xchg	BA, HL
	add		a, 96
	mov		[x2], a
	inc		x2
	xchg	BA, HL
	
	mov		l, 0	
checkdiv4:
	cmp		BA, 10
	jl		nosub4
	
	sub		BA, 10
	inc		l
	jmp		checkdiv4
nosub4:
	
	xchg	BA, HL
	add		a, 96
	mov		[x2], a
	inc		x2
	xchg	BA, HL
	
	mov		l, 0	
checkdiv5:
	cmp		BA, 1
	jl		nosub5
	
	sub		BA, 1
	inc		l
	jmp		checkdiv5
nosub5:
	
	xchg	BA, HL
	add		a, 96
	mov		[x2], a
	
	ret
	
##############################
# PLACE FOOD # GAME FUNCTION #
##############################
placefood:
    ### generate random number
	mov		a, [nn+REG_TIMER256_COUNT]
	mov		b, [seed]
	add		a, b
	add		a, $A5
	mov		[seed], a
	
	
	and		a, $F
	mov		[foody], a
	
	shl		a
	shl		a
	add		a, 16
	movb	[OAM+1], a  #write Y

	### generate random number
	mov		a, [nn+REG_TIMER256_COUNT]
	mov		b, [seed]
	add		a, b
	add		a, $A5
	mov		[seed], a
	
	mov		b, a
	and		b, $F0
	shr		b
	shr		b
	shr		b
	shr		b
	and     a, $7
	add		a, b
	mov		[foodx], a
	
	shl		a
	shl		a
	add		a, 16
	movb	[OAM], a
	
	
		## draw
	#a * 12
	movb	a, [foody]
	shr		a  ## needed
	shl		a
	shl		a  
	mov     b, a  ## HL = py * 4
	shl     a     ## a = py * 8 
	add     a, b  ## BA = py*8 + py*4

    mov		b, [foodx]
    shr		b   ## needed
        
	add     a, b  ## py*12 + px
	
	mov		b, 0
	
    mov		x2, TILEMAP
    add		x2, BA
    mov 	l, a

   
    ## calculate tile ID
    mov		a, [foodx]
    andb	a, 1
    inc     a
    
    mov		b, [foody]
    test	b, 1
    jz      firstrow2
    shl		a
    shl		a
firstrow2:
	
	    ## CHECK WALL HIT
    mov		b, [x2]
    xchg	a, b
    test	a, b    ### check if b is already set
    xchg    a, b
    jnz		placefood ### Game Over if set (hit another tile)
	
	
	ret	

##############################
# LOAD MAP # HELPER FUNCTION #
##############################
loadmap:
    mov		x1,mdat
    mov		x2,TILEMAP      # we copy the first level
    mov		l,$0
copy_level:
    mov		a,[x1+l]
    mov		[x2+l],a
    inc		l
    cmp		l,96
    jnz		copy_level

    ret


##################################
# BG LINEAR # PSEUDO LINEAR MODE #
##################################
bglinear:
    mov x2,TILEMAP      # we stay in tiled mode, but we put tile 0,1,2,3,4,etc
    mov l,$0            # on screen
loop_linear:
    mov [x2+l],l
    inc l    
    cmp l,96
    jnz loop_linear
    ret


# not needed because of IRQ usage
################################
# WAIT VSYNC # SYSTEM FUNCTION #
################################
#waitsync: 
#	mov		[nn+0x27], 0x80
#_waitsyncloop: 
#	test	[nn+0x27], 0x80
#	jz		_waitsyncloop
#	ret


    

mdat:
.incbin level.bin

### tile data (align 8 bytes)
.align	8
tiles1:
.incbin tiles1.bin
tiles2:
.incbin tiles2.bin

title1:
.incbin title1.bin
title2:
.incbin title2.bin

.align 8
go1:
.incbin go1.bin
.align 8
go2:
.incbin go2.bin


### SPRITE DATA
.align 64
food:
.incbin food.bin