### simple Pokemon Mini framework ###

# pmio.asm is the include file that defines hardware register names 
# the file is included in the tutorial zip file
.include	"pmio.asm"

.orgfill 0x1460
cmap: #current map, points to map
.db 0,0

curx:
.db 0
cury:
.db 0
mapw:
.db 0
maph:
.db 0
sp:
.db 0
cntr:
.db 0
stp:
.db 0
cursrp:
.db 0

facing:
.db 0

teleptr: #Pointer to teleports array
.db 0,0  #x,y, map id, starting x, starting y

npcptr: #Pointer to NPC array
.db 0,0 #left,top,right,bottom,string id[2]

trspptr: #Pointer to Trainer Spaces array
.db 0,0  #string id[2], trainer id[2]

hiditmptr: #Pointer to Hidden Items spaces array
.db 0,0    #x,y, item id

#Current signs
signlen: #Amount of signs on the map/in memory
.db 0
signdat:
.db 0,0, 0,0 #x,y, string id[2]

.orgfill 0x2100
#0x2100 is the start of the ROM space that is available to us

# ROM ID (part of ROM header, this is needed or the ROM won't run)
.db "MN"


### interrupt vector table
#whenever an interrupt occours the PM will jump here to execute the
#interrupt handling routine

#INT #0
.orgfill 0x2102   #GAME START
    #the game start IRQ is fired up when the PM is turned on and the bios
    #finished initialization. We will just jump to the start of our code
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt # not handled
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
    jmp unhandled_interrupt
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
    jmp unhandled_interrupt
#INT #6
.orgfill 0x2126   # 
    jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    jmp unhandled_interrupt
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp unhandled_interrupt
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp unhandled_interrupt
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp unhandled_interrupt
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp unhandled_interrupt
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp unhandled_interrupt
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
### Pokemon Mini game header
.orgfill 0x219E 
.orgfill 0x21A4 
.db "NINTENDO"
.db "PMNO"
.db "PkMnOrange "
.orgfill 0x21Bc
.db "2P"

.orgfill 0x21D0

unhandled_interrupt:
    reti


start:
    movw	sp,REG_BASE
    movw	nn,REG_BASE

    movb	[nn+REG_EVENT2P],INT2P_KEYPAD
    movb	[nn+REG_EVENT2S],INT2S_KEY_POWER

    # Activate all interrupts
    mov		flags, 0

    movb	[nn+REG_LCD_CNT0], LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16|LCD0_SPRITES
    movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1

    movb	b, 95
    movw	HL, TILEMAP+95
bglinear:
    movb	[HL], b   ### write the counter variable to the map
    dec		HL        ### decrease map address
    jdbnz       bglinear

	movw x1,mainchar1
	movw [REG_BASE+REG_LCD_SPRITEMEM],x1

	mov nn,OAM
	mov [nn+0],56 #Character
	mov [nn+1],40
	mov [nn+2],0
	mov [nn+3],OAM_DISABLE

	mov [nn+4],84 #Menu cursor
	mov [nn+5],23
	mov [nn+6],10
	mov [nn+7],OAM_DISABLE

	#mov [nn+8],56 #Above charcter
	#mov [nn+9],40
	#mov [nn+10],11
	#mov [nn+11],OAM_ENABLE
	mov nn,REG_BASE

	mov a,8
	mov [curx],a
	mov a,8
	mov [cury],a

	#jmp skip_intros
#Pokemon Mini logo
	mov x1,pmintro
	mov [REG_BASE+REG_LCD_TILEBGMEM],x1
	mov b,80
pmilp:
	call sync
	jdbnz pmilp
#Gamefreak logo
	mov x1,gfintro
	mov [REG_BASE+REG_LCD_TILEBGMEM],x1
	mov b,80
gfilp:
	call sync
	jdbnz gfilp
#PkMn Orange Intro
	mov x1,pkmnointro
	mov [REG_BASE+REG_LCD_TILEBGMEM],x1

game_end:
	test [nn+REG_KEYPAD],KEY_POWER
	jnz noturnoff
	cint $24
noturnoff:
	call sync
	test [nn+REG_KEYPAD],KEY_A
	jnz game_end
skip_intros:
	#How to set up a map... x.x
	mov x1,map1
	call load_map_x1
	
	mov x1,tiles
	mov [REG_BASE+REG_LCD_TILEBGMEM],x1
	mov nn,OAM
	mov [nn+3],OAM_ENABLE
	mov nn,REG_BASE
	call draw_cmap
new_loop:
	test [nn+REG_KEYPAD],KEY_POWER
	jnz _noturnoff
	cint $24
_noturnoff:
	test [nn+REG_KEYPAD],KEY_C
	jz dspmnu
	mov l,0
	test [nn+REG_KEYPAD],KEY_LEFT
	jnz notl
	mov a,[curx]
	mov l,1
	mov b,[stp]
	cmp b,1
	jnc notl
	cmp a,2 #chara limit
	jnc _noset
	mov a,2
_noset:
	dec a        #Arg1: Possible new x
	push a
	mov b,[cury] #Arg2: Current y
	call get_solid_ab #return solidity in h
	pop a
	mov b,h
	test b,1
	jnz _stillwalk #is solid (h == 1)
	mov [curx],a
	#choose walking sprite
_stillwalk:
	mov nn,OAM
	mov a,[cntr]
_back:
	cmp a,1
	jnc _not0
	mov [nn+2],3
	jmp _draw
_not0:
	cmp a,2
	jnc _not1
	mov [nn+2],4
	jmp _draw
_not1:
	mov a,0
	mov [cntr],a
	jmp _back
_draw:
	mov nn,REG_BASE
	call draw_cmap
	mov b,2
	mov [facing],b
	jmp ttetl
notl:
	test [nn+REG_KEYPAD],KEY_RIGHT
	jnz notr
	mov a,[curx]
	mov l,1
	mov b,[stp]
	cmp b,1
	jnc notr
	cmp a,39 #chara limit
	jc _noset
	mov a,39
_noset:
	inc a        #Arg1: Possible new x
	push a
	mov b,[cury] #Arg2: Current y
	call get_solid_ab #return solidity in h
	pop a
	mov b,h
	test b,1
	jnz _stillwalk #is solid (h >= 1)
	mov [curx],a
	#choose walking sprite
_stillwalk:
	mov nn,OAM
	mov a,[cntr]
_back:
	cmp a,1
	jnc _not0
	mov [nn+2],5
	jmp _draw
_not0:
	cmp a,2
	jnc _not1
	mov [nn+2],9 #oops
	jmp _draw
_not1:
	mov a,0
	mov [cntr],a
	jmp _back
_draw:
	mov nn,REG_BASE
	call draw_cmap
	mov b,0
	mov [facing],b
	jmp ttetl
notr:
	test [nn+REG_KEYPAD],KEY_UP
	jnz notu
	mov a,[cury]
	cmp a,1 #chara limit
	jnc _noset
	mov a,1
_noset:
	mov l,1
	mov b,[stp]
	cmp b,1
	jnc notu
	dec a        #Arg2: Possible new y
	push a
	mov b,a
	mov a,[curx] #Arg1: Current x
	call get_solid_ab #return solidity in h
	pop a
	mov b,h
	test b,1
	jnz _stillwalk #is solid (h >= 1)
	mov [cury],a
	#choose walking sprite
_stillwalk:
	mov nn,OAM
	mov a,[cntr]
_back:
	cmp a,1
	jnc _not0
	mov [nn+2],6
	jmp _draw
_not0:
	cmp a,2
	jnc _not1
	mov [nn+2],7
	jmp _draw
_not1:
	cmp a,3
	jnc _not2
	mov [nn+2],6
	jmp _draw
_not2:
	cmp a,4
	jnc _not3
	mov [nn+2],8
	jmp _draw
_not3:
	mov a,0
	mov [cntr],a
	jmp _back
_draw:
	mov nn,REG_BASE
	call draw_cmap
	mov b,1
	mov [facing],b
	jmp ttetl
notu:
	test [nn+REG_KEYPAD],KEY_DOWN
	jnz notd
	mov a,[cury]
	cmp a,39 #chara limit
	jc _noset
	mov a,39
_noset:
	mov l,1
	mov b,[stp]
	cmp b,1
	jnc notd
	inc a        #Arg2: Possible new y
	push a
	mov b,a
	mov a,[curx] #Arg1: Current x
	call get_solid_ab #return solidity in h
	pop a
	mov b,h
	test b,1
	jnz _stillwalk #is solid (h >= 1)
	mov [cury],a
	#choose walking sprite
_stillwalk:
	mov nn,OAM
	mov a,[cntr]
_back:
	cmp a,1
	jnc _not0
	mov [nn+2],0
	jmp _draw
_not0:
	cmp a,2
	jnc _not1
	mov [nn+2],1
	jmp _draw
_not1:
	cmp a,3
	jnc _not2
	mov [nn+2],0
	jmp _draw
_not2:
	cmp a,4
	jnc _not3
	mov [nn+2],2
	jmp _draw
_not3:
	mov a,0
	mov [cntr],a
	jmp _back
_draw:
	mov nn,REG_BASE
	call draw_cmap
	mov b,3
	mov [facing],b
	jmp ttetl
notd:
	test [nn+REG_KEYPAD],KEY_A
	jnz nota
	call signbox

nota:
ttetl: #Time to end the loop :P
	mov a,l
	cmp a,1 #if the character walked this run
	jz isl1
	mov a,0
	mov [cntr],a
	mov [stp],a
	
	jmp notl1
isl1:
	#Check teleports
	mov x1,[teleptr]
	mov b,[x1] #b is the amount of teleport spaces
	cmp b,0
	jz _hiddens
	inc x1
_tloop:
	mov a,[x1]
	cmp a,[curx]
	jnz _tloopback
	mov a,[x1+1]
	cmp a,[cury]
	jnz _tloopback
	add x1,2
	mov a,[x1] #cmap ID
	inc x1
	mov b,[x1]
	mov [curx],b
	inc x1
	mov b,[x1]
	mov [cury],b
	call set_cmap_a
	call draw_cmap
	jmp notl1 #can only be one teleport per space of course..
_tloopback:
	add x1,5
	jdbnz _tloop

_hiddens:
	#Check hiddens
_trainers:
	#Check trainer spots
_rest:
	mov a,[stp]
	inc a
	mov [stp],a
	cmp a,5
	jc notl1
	mov a,[cntr]
	inc a
	mov [cntr],a
	mov a,0
	mov [stp],a
notl1:
	call flicker_and_sync
	jmp new_loop

load_map_x1:
	push hl
	push ba
	mov l,[x1+0]
	mov [mapw],l
	mov a,[x1+1]
	mov [maph],a
	add x1,2
	mov [cmap],x1
	#Read signs (l is mapw a is maph)
	mov h,0
	mul l,a
	add hl,x1
	#hl is the start of the map's signdat
	mov b,[hl]
	mov [signlen],b

	#Set teleports array loc
	push hl
	push ba
	mov hl,4
	mov a,b
	mul l,a
	mov ba,signdat
	add hl,ba
	movw [teleptr],hl
	pop ba
	pop hl
	
	cmp b,0
	jz _noloop
	mov x1,signdat
_loop:
	push b
	mov b,4
_inloop: #x,y,id1,id2
	inc hl
	mov a,[hl]
	mov [x1],a
	inc x1
	jdbnz _inloop
	pop b
	jdbnz _loop
_noloop:

	inc hl
	#Load teleports
	movb b,[hl]
	mov x1,[teleptr]
	mov [x1],b

	#Set NPCs array loc
	push hl
	push ba
	mov hl,5
	mov a,b
	mul l,a
	mov ba,signdat
	add hl,ba
	movw [npcptr],hl
	pop ba
	pop hl

	cmp b,0
	jz _notloop
	inc x1
_teleloop:
	push b
	mov b,5
_intloop: #x,y,id1,id2
	inc hl
	mov a,[hl]
	mov [x1],a
	inc x1
	jdbnz _intloop
	pop b
	jdbnz _teleloop
_notloop:

	pop ba
	pop hl
	ret

draw_cmap:
#ok notes
#12x8 tiles
	push hl
	push ba
	push x1
	movw x1,TILEMAP+95
	mov a,[curx]
	cmp a,7
	jnc _checkx2
	cmp a,2       #Walk to edge
	jc _nowalkx1   #Why here? Why not?
	mov l,9
	mul l,a
	mov a,l
	movw nn,OAM
	mov [nn+0],a
	movw nn,REG_BASE
_nowalkx1:
	mov a,6
	jmp _xnorstpos
_checkx2:
	mov b,a
	mov a,[mapw]
	sub a,6
	xchg a,b
	cmp a,b #check if you're mapw-6
	jc _checky
	xchg a,b
	add a,6
	xchg a,b
	cmp a,b      #Walk to edge
	jnc _nowalkx2
	mov b,a
	mov a,[mapw]
	sub a,b
	mov b,a
	mov a,6
	sub a,b
	mov l,9
	mul l,a
	mov a,56
	mov b,l
	add a,b
	movw nn,OAM
	mov [nn+0],a
	movw nn,REG_BASE
_nowalkx2:
	mov a,[mapw]
	sub a,6
	jmp _xnorstpos
_checky:
	push a
	mov a,56
	mov [OAM+0],a
	pop a
_xnorstpos:
	add a,5
	mov h,a
	mov a,[cury]
	cmp a,5
	jnc _checky2
	cmp a,1       #Walk to edge
	jc _nowalky1
	push h
	mov l,10
	mul l,a
	mov a,l
	movw nn,OAM
	mov [nn+1],a
	movw nn,REG_BASE
	pop h
_nowalky1:
	mov a,4
	jmp _ynorstpos
_checky2:
	mov b,a
	mov a,[maph]
	sub a,4
	xchg a,b
	cmp a,b #check if you're maph-4
	jc _checkova
	xchg a,b
	add a,3
	xchg a,b
	cmp a,b      #Walk to edge
	jnc _nowalky2
	push h
	mov b,a
	mov a,[maph]
	sub a,b
	mov b,a
	mov a,4
	sub a,b
	mov l,10
	mul l,a
	mov a,40
	mov b,l
	add a,b
	movw nn,OAM
	mov [nn+1],a
	movw nn,REG_BASE
	pop h
_nowalky2:
	mov a,[maph]
	sub a,4
	jmp _ynorstpos
_checkova:
	push a
	mov a,40
	mov [OAM+1],a
	pop a
_ynorstpos:
	add a,4
	mov l,a
	mov b,8
_st:
	push b
	push hl
	mov a,[mapw]
	mov h,0
	dec l
	mul l,a
	mov ba,hl
	pop hl
	push x1
	mov x1,hl
	mov l,h
	mov h,0
	add ba,hl
	mov hl,x1
	pop x1
	push hl
	mov hl,ba
	mov ba,[cmap]
	add hl,ba
	mov b,12
_f12:
	mov [x1],[hl]
	dec x1
	dec hl
	jdbnz _f12
	pop hl
	dec l
	pop b
	jdbnz _st
	#Map drawn
	#Set above hero sprite
	mov nn,OAM
	mov a,[nn+0]
	mov [nn+8],a
	mov a,[nn+1]
	mov [nn+9],a
	mov nn,REG_BASE

	jmp _ret #DO NOT WANT I'll do above hero later
	#check your position
	mov a,[curx]
	mov b,[cury]
	call get_solid_ab
	mov a,h
	cmp a,2         #Check if it is above hero
	jnz _check_2nd_tl #It isn't check the tile above you
	mov a,[curx]
	call draw_tile_to_screen_ab

_check_2nd_tl:
	mov a,[curx]
	mov b,[cury]
	cmp b,1
	jz _ret #You're on the top tile, nothing to check
	dec b
	call get_solid_ab
	mov a,h
	cmp a,2         #Check if it is above hero
	jnz _ret        #Nope, goto ret
	mov a,[curx]
	call draw_tile_to_screen_ab

_ret:
	pop x1
	pop ba
	pop hl
	ret

flicker_and_sync:
	push x1
	push ba
	mov a,[sp]
	test a,1
	jnz _img1
	mov a,1
	mov x1,mainchar1
	jmp _imgdn
_img1:
	mov a,0
	mov x1,mainchar2
_imgdn:
	mov [sp],a
	mov [REG_BASE+REG_LCD_SPRITEMEM],x1
	mov a,[curx]
	call sync
	pop ba
	pop x1
	ret

sync:
	mov [nn+REG_INT_FLAG1], IF_VBLANK
_sloop: 
	test [nn+REG_INT_FLAG1], IF_VBLANK
	jz _sloop
	ret

get_solid_ab: #a,b: tile x,tile y
	push l
	#push b
	push a
#First get absolute y*width+x
	mov l,b
	mov h,0
	mov a,[mapw]
	mul l,a #now contains correct y absolute
	mov b,0 #v
	pop a   #Set up ba for addition
	add ba,hl #Full absolute in ba
	dec ba
#Then get tile id
	mov hl,[cmap] #Offset of current map
	add hl,ba #Offset of tile in data..
	mov a,[hl] #Tile ID in a
	#push a
	mov b,0   #v
	mov hl,ba #v
	mov a,4   #v
	div hl,a  #h contains remainder
	cmp h,1
	jc _is0 #if h < 1
	cmp h,2
	jc _is1 #else h < 2
	cmp h,3
	jc _is2 #else h < 3
	jmp _is3 #else
_is0:
	mov a,0b11000000
	jmp _isX
_is1:
	mov a,0b00110000
	jmp _isX
_is2:
	mov a,0b00001100
	jmp _isX
_is3:
	mov a,0b00000011
	jmp _isX
_isX: #a contains &able location
	#pop a #Tile ID
#Now get the corresponding state byte (l) and compare
	mov x1,states
	push h
	mov h,0
	add x1,hl #Byte Container location in ROM
	and a,[x1] #Get the particular bits into a
	pop h #Time to shift..
	cmp h,1
	jc _is0_1 #if h < 1
	cmp h,2
	jc _is1_1 #else h < 2
	cmp h,3
	jc _is2_1 #else h < 3
	jmp _isX_1 #else
_is0_1:
	shr a
	shr a
	shr a
	shr a
	shr a
	shr a
	jmp _isX_1
_is1_1:
	shr a
	shr a
	shr a
	shr a
	jmp _isX_1
_is2_1:
	shr a
	shr a
	jmp _isX_1
_isX_1: #a contains correct two solidity bits
	mov h,a
	cmp a,3
	jc _ret #if a >= 3 (0b11)
	mov h,0 #Set to below hero
_ret:
	pop l
	ret #h

dspmnu:
	#First set up tiles.
	movw x1,TILEMAP+8
	mov hl,(menu_tl-tiles)/8
	mov b,7
	mov [x1],l
	#jmp _loop
_bfloop:
	push b
	mov b,4
_mklp:
	mov [x1],l
	inc x1
	inc hl
	jdbnz _mklp
	pop b
	add x1,8
	jdbnz _bfloop

	mov nn,OAM
	mov [nn+7],OAM_ENABLE
	mov nn,REG_BASE
_loop:
	mov l,[cursrp] #8*cursrp+23
	mov a,7
	mul l,a
	mov a,23
	mov b,l
	add a,b               #^

	mov nn,OAM
	mov [nn+5],a #cursor y
	mov nn,REG_BASE

	mov a,[cursrp]
	test [nn+REG_KEYPAD],KEY_DOWN
	jnz _not_down
	cmp a,5   #if(a >= 5)
	jc _anot5 
	mov a,0    #  a = 0;
	jmp _setdown
_anot5:            #else
	inc a      #  a++
_setdown:
	mov [cursrp],a
_key_up_DOWN:
	call flicker_and_sync
	test [nn+REG_KEYPAD],KEY_DOWN
	jz _key_up_DOWN

_not_down:
	test [nn+REG_KEYPAD],KEY_UP
	jnz _not_up
	cmp a,1   #if(a < 1)
	jnc _anot0
	mov a,5    #  a = 5;
	jmp _setup
_anot0:            #else
	dec a      #  a--
_setup:
	mov [cursrp],a
_key_up_UP:
	call flicker_and_sync
	test [nn+REG_KEYPAD],KEY_UP
	jz _key_up_UP

_not_up:
	test [nn+REG_KEYPAD],KEY_B
	jnz _not_b #Cancel/Quit
_exit_menu:
	mov nn,OAM
	mov [nn+7],OAM_DISABLE
	mov nn,REG_BASE
	call draw_cmap
	jmp new_loop
_not_b:
	test [nn+REG_KEYPAD],KEY_A
	jnz _end_loop #Perform action
	mov a,[cursrp]
	cmp a,1
	jc _opt_PkDEX
	cmp a,2
	jc _opt_PkMn
	cmp a,3
	jc _opt_ITEM
	cmp a,4
	jc _opt_YOU
	cmp a,5
	jc _opt_SAVE
	cmp a,6
	jc _opt_EXIT
	jmp _end_loop
_opt_PkDEX:
	jmp _end_loop
_opt_PkMn:
	jmp _end_loop
_opt_ITEM:
	jmp _end_loop
_opt_YOU:
	jmp _end_loop
_opt_SAVE:
	jmp _end_loop
_opt_EXIT:
	jmp _exit_menu
_end_loop:
#Flicker and sync
	call flicker_and_sync
	jmpw _loop

signbox:
	push hl
	mov b,[signlen]
	cmp b,0
	jz nota
	mov x1,signdat
_loop:
	mov a,[x1]    #a = sign[b].x
	inc x1
	cmp a,[curx]  #if(a != [curx])
	jnz _jumpback #goto _loop
	mov a,[x1]    #a = sign[b].y
	cmp a,[cury]  #if(a != [cury])
	jnz _jumpback #goto _loop
	jmp _display  #else _display
_jumpback:
	add x1,3
	jdbnz _loop
	jmp _ret #Nothing found in the array
_display:
	
_notpa: #Make sure user stops pressing a
	call flicker_and_sync
	test [nn+REG_KEYPAD],KEY_A
	jz _notpa 

	inc x1
	mov a,[x1] #a = sign[b].id[0]
	and a,0b11000000
	shr a #b01100000
	shr a #b00110000
	shr a #b00011000
	shr a #b00001100
	shr a #b00000110
	shr a #b00000011
	#Now we check the direction he is facing
	mov b,[facing]
	cmp a,b
	jnzw _ret
	mov b,[x1] #b = sign[b].id[0]
	and b,0b00111111
	inc x1
	mov a,[x1] #a = sign[b].id[1]
	mov hl,ba
	#hl is now the sign ID
	call textbox
_ret:
	pop hl
	ret

textbox: #HL contains the string ID, A contains the line number
	push hl
	#Set up the tiles.
	mov a,[OAM+3]
	mov b, OAM_DISABLE
	mov [OAM+3],b
	mov hl,dialog_tl
	mov [REG_BASE+REG_LCD_TILEBGMEM],hl
	mov l,0
	mov x2,TILEMAP
	mov [x2],l #Upper Left
	mov b,10
	inc x2
	inc l
_gfx_top: #Upper
	mov [x2],l
	inc x2
	jdbnz _gfx_top
	inc l        #Upper Right
	mov [x2],l #Upper Right
	inc x2
	inc l        #Left
	mov b,6
_middle_loop:
	push b
	mov [x2],l #Left 1
	mov b,10
	inc x2
_gfx_ln1: #Middle
	mov [x2],17
	inc x2
	jdbnz _gfx_ln1
	inc l        #Right
	mov [x2],l #Right 1
	dec l        #Left
	inc x2
	pop b
	jdbnz _middle_loop
	mov l,5        #Lower Left
	mov [x2],l #Lower Left
	mov b,10
	inc x2
	inc l
_gfx_low: #Lower
	mov [x2],l
	inc x2
	jdbnz _gfx_low
	inc l        #Lower Right
	mov [x2],l #Lower Right
	#Text box is drawn
	pop hl #hl is the string ID
	#mov x1,13 #Beginning of first line
	mov a,0
	mov [cursrp],a

_parseline:
	push a
	mov a,h
	and a,0b00111111
	mov h,a #Removed the write method
	dec hl #1 is the minimum ID
	mov x1,strings
	mov b,12
_mulloop: #One for each character in the string + 2 for the next ID
	add x1,hl
	jdbnz _mulloop
	mov b,10 #Draw the ten characters
	mov l,12
	pop a
	inc a
	mov [cursrp],a # will max out at 5
	mul l,a
	inc l
	add hl,TILEMAP
_drawline:
	mov a,[x1]
	sub a,15
	mov [hl],a
	inc x1
	inc hl
	call flicker_and_sync
	push b
	mov b,5
_wait2:
	jdbnz _wait2
	pop b
	jdbnz _drawline
	mov b,20
_wait1:
	jdbnz _wait1
	movb h,[x1] #Get next ID
	inc x1
	movb l,[x1]
	mov a,h #a = id[0]
	push hl
	test a,0b10000000 #if(a&0b10000000)
	jz _rnowait
_rwaitfora:
	call flicker_and_sync
	test [nn+REG_KEYPAD],KEY_A
	jnz _rwaitfora
_rnowait:
	test a,0b01000000 #if(a&0b01000000)
	jz _chklineup
#_cls
	mov hl,TILEMAP+13 #write to
	mov b,5
_lineloop:
	push b
	mov b,10
_charloop:
	movb [hl],17
	inc hl
	jdbnz _charloop
	add hl,2
	pop b
	jdbnz _lineloop
	mov a,0
	mov [cursrp],a
	jmp _justredraw
	
_chklineup:
	mov a,[cursrp]
	cmp a,6
	jc _justredraw
#_move up
	mov hl,TILEMAP+13 #write to
	mov x1,TILEMAP+25 #write from
	mov b,5
_lineloop2:
	push b
	mov b,10
_charloop2:
	movb [hl],[x1]
	inc hl
	inc x1
	jdbnz _charloop2
	add hl,2
	add x1,2
	pop b
	jdbnz _lineloop2
	mov a,5
	mov [cursrp],a
	
_justredraw:
	pop hl
	mov a,h
	and a,0b00111111
	mov h,a
	mov a,[cursrp]
	cmp hl,1 #if(id > 0)
	jncw _parseline
	
_notpa2: #Make sure user stops pressing a
	call flicker_and_sync
	test [nn+REG_KEYPAD],KEY_A
	jz _notpa2
	mov hl,tiles
	mov a,OAM_ENABLE
	mov [OAM+3],a
	mov [REG_BASE+REG_LCD_TILEBGMEM],hl
_ret:
	call draw_cmap
	ret

set_cmap_a: #a is the ID
	push x1
	cmp a,0
	jnz _map2
	mov x1,map1
	mov [cmap],x1
	jmp _bret
_map2:
	cmp a,1
	jnz _map3
	mov x1,map2
	mov [cmap],x1
	jmp _bret
_map3:
	jmp _ret
_bret:
	call load_map_x1
_ret:
	pop x1
	ret
draw_tile_to_screen_ab: #a = tile x, b = tile y
	push hl

	push ba
	mov b,[curx]
	#First find the screen position
	mov a,[mapw]
	sub a,6
	cmp a,b
	jnc _clsd
	sub a,6
	mov l,a
	jmp _cy
_clsd: #Check Left SiDe
	cmp b,7
	jnc _neitherx
	mov l,1
	jmp _cy
_neitherx:
	mov a,b
	sub a,6
	mov l,a
_cy: #l contains the left of the screen
	mov b,[cury]
	mov a,[maph]
	sub a,4
	cmp a,b
	jnc _ctsd
	sub a,4
	mov h,a
	jmp _draw
_ctsd:
	cmp b,5
	jnc _neithery
	mov h,1
	jmp _draw
_neithery:
	mov a,b
	sub a,4
	mov h,a
_draw: #h contains the top of the screen
	pop ba
	push ba
	#Now we have to find where the tile is located on the screen
	push b
	mov b,l
	sub a,b
	cmp a,12
	jnc _pop_ba_ret #Tile isn't on the screen
	pop b
	mov l,a
	mov a,b
	mov b,h
	sub a,b
	cmp a,8
	jnc _pop_ba_ret #Tile isn't on the screen
	mov h,a
	mov a,8
	mul l,a
	mov b,l
	mov l,h
	mul l,a
	mov h,l
	mov l,b
	#l contains left pixel of drawing point on screen, h contains the top, width/height is 8/8 of course
	pop ba
	#Get the sprite and the mask of the tile and draw in the screen
	
_pop_ba_ret:
	pop ba
_ret:
	pop hl
	ret
	
map1:
.db 40,40, #Map width, height
#tiles
.db 39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,$1,$1,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,
.db 41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,$1,$1,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,
.db 39,40,$1,$1,25,28,31,31,31,31,33,36,$1,$1,$1,$9,$9,$9,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,26,29,32,32,32,32,34,37,$1,$1,$1,$9,$9,$9,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,27,30,21,19,21,21,35,38,$1,$1,$1,$1,$9,$9,$9,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,22,23,23,23,23,23,23,24,$1,$1,$1,$1,$2,$9,$9,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$2,$1,18,19,13,14,21,21,19,20,$1,$2,$1,$3,$3,$3,$3,$3,$3,$3,$3,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$2,$1,10,12,15,16,11,12,12,17,$1,$2,$1,86,$4,$4,$4,$4,$4,$4,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,86,$9,$9,$9,$9,$9,$9,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$3,$3,$3,$3,$3,$3,$5,$6,$1,$1,$1,86,$9,$9,$9,$9,$9,$9,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$2,$1,$4,$4,$4,$4,$4,$4,$7,$8,$1,$2,$1,86,$9,$9,$5,$6,$9,$9,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$2,$1,$9,$9,$9,$9,$9,$9,$9,$9,$1,$2,$1,86,$9,$9,$7,$8,$9,$9,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$9,$9,$9,$9,$2,$9,$9,$9,$1,$1,$1,86,$3,$3,$1,$1,$3,$3,86,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$9,$9,$9,$9,$9,$1,$1,$1,$1,$1,$4,$4,$4,$1,$1,$4,$4,$4,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$9,$9,$9,$1,$1,$9,$9,$9,$1,$1,$2,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,82,83,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,84,85,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,102, 99, 99, 99, 99, 99, 99, 99,105,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,103,100,100,100,100,100,100,100,103,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,104,101,101,101,101,101,101,101,106,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1, 18,111,111,111, 44, 44,111,111, 20,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1, 18, 44, 44, 44, 44, 44, 44, 44, 20,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1, 18, 44, 44,107,108,111, 44, 44, 20,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1, 10, 12, 12,109,110, 12, 12, 12, 17,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,39,40,
.db 41,42,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,$1,41,42,
.db 39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,39,40,
.db 41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,41,42,
#Signs x,y, 0bWWZZZZZZ,$ZZ; W:Facing Z:id
.db $4, 11,11,0b01000000,$1, 12,11,0b01000000,$1
.db 19,12,0b01000000,$3, 20,12,0b01000000,$3
#Teleports x,y, map id, destination x,y
.db $2, 7,7, 1, 10,15, 8,7, 1, 11,15
#NPCs
#Hidden items

map2:
.db 20,20
#tiles
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.db $00,$00,$00,$01, 76, 77,$01,$01,$01,$01,$01,$01, 80, 80,$01,$01,$01,$00,$00,$00
.db $00,$00,$00,$01, 78, 79,$01,$01,$01,$01,$01,$01, 81, 81,$01,$01,$01,$00,$00,$00
.db $00,$00,$00,117,117,117,117,117,117,117,117,117,117,117,117,117,117,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 45, 46, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 47, 48, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01, 01,$00,$00,$00
.db $00,$00,$00, 01, 72, 73, 01, 01, 01, 01, 01, 01, 01, 01, 01, 64, 65,$00,$00,$00
.db $00,$00,$00, 01, 74, 75, 01, 01, 01, 01, 01, 01, 01, 01, 01, 66, 67,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 62, 62, 62, 62, 01, 01, 01, 68, 69,$00,$00,$00
.db $00,$00,$00, 01, 01, 01, 01, 01, 63, 63, 63, 63, 01, 01, 01, 70, 71,$00,$00,$00
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
#Signs x,y, 0bWWZZZZZZ,$ZZ; W:Facing Z:id
.db $0
#Teleports x,y, map id, destination x,y
.db $2, 10,16, 0, 7,8, 11,16, 0, 8,8
#NPCs
#Hidden items

.align 64
mainchar1:
.incbin chara1.bin
.incbin cursor.bin #10
#invispr1:
#.incbin invisible.bin #11
mainchar2:
.incbin chara2.bin
.incbin cursor.bin #10
#invispr2:
#.incbin invisible.bin #11

.align 8
#bg:
#.incbin pkmno.bin

pmintro:
.incbin pmlogo.bin

gfintro:
.incbin PkMnscr1.bin

pkmnointro:
.incbin PkMnscr2.bin

.include "tiles.asm"

strings:
#Text strings
#Starts at ID 1, 0 is "break"
#First two bits determine how to continue to the next screen.
#X0 Lines moves up (if any exist), next line is drawn
#X1 clear lines, draw next line on the first
#0X do not wait for a
#1X Wait for a
#Special characters
## $17, Male
## $18, Female
## $19, 
## $1A, Pk (Poke)
## $1B, Mn (Mon)
## $1C, Multiplication
## $1D, Pokeball
## $1E, ED (End)
.db "Welcome to",$0,$2, $1A,$1B," Orange!",$80,$0

.db "Hey there!",$0,$4, "Welcome to",$0,$5, "the world ",$0,$6, "of POK",$19,"MON",$80,$7
.db "My name is",$0,$8, "IVY! They ",$0,$9, "call me a ",$0,$A, $1A,$1B," PROF!  ",$C0,$0

#[prof. ivy]
#Hello there!
#Welcome to the
#world of POKMON!
#My name is IVY!
#People call me
#the POKMON PROF!
#[switch to pkmn]
#This world is
#inhabited by
#creatures called
#POKMON!
#For some people,
#POKMON are
#pets. Others use
#them for fights.
#Myself...
#I study POKMON
#as a profession.
#[switch to character]
#First, what is
#your name?
#*=NAME==*
#|NEW    |
#|ORANGE |
#|TRACEY |
#|GERALD |
#*=======*
#Right! So your
#name is ____!
#[introduce to rival]
#____!
#Your very own
#POKMON legend is
#about to unfold!
#A world of dreams
#and adventures
#with POKMON
#awaits! Let's go!