### Pokemon Mini TV remote for Thomson TVs and others (Telefunken?) - rct100 ###

.include	"pmio.asm"

.orgfill 0x1460
#General Purpose RAM

#current position on grid
gridsel:
.db		0


#make a little buffer for remote codes
remotecode:
.ds		256



.orgfill 0x2100
#0x2100 is the start of the ROM space that is available to us

# ROM ID (part of ROM header, this is needed or the ROM won't run)
.db "MN"


### interrupt vector table
#whenever an interrupt occours the PM will jump here to execute the
#interrupt handling routine

#INT #0
.orgfill 0x2102   #GAME START
    jmp start
#INT #1    
.orgfill 0x2108   #V-BLANK
    jmp unhandled_interrupt # not handled
#INT #2
.orgfill 0x210E   #V-DRAW
    jmp unhandled_interrupt
#INT #3
.orgfill 0x2114   #TIMER 2 OVERFLOW
	jmp	sendpulse
#INT #4
.orgfill 0x211A   # 
    jmp unhandled_interrupt
#INT #5
.orgfill 0x2120   #TIMER 1 OVERFLOW
	#this timer interrupt generates the carrier frequency
	#i wanted it to make it as fast/small as possible so i
	#put it here instead of jumping to another code section
	mov		[nn+REG_INT_FLAG1], IF_TIMER1OVERFLOW
   	xorb	[nn+0x61], 0x2	
	reti
#INT #6
.orgfill 0x2126   # 
    #jmp unhandled_interrupt
#INT #7
.orgfill 0x212C   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #8
.orgfill 0x2132   #TIMER 3 OVERFLOW
    jmp unhandled_interrupt
#INT #9
.orgfill 0x2138   # 
    jmp unhandled_interrupt
#INT #10
.orgfill 0x213E   # 
    jmp unhandled_interrupt
#INT #11
.orgfill 0x2144   # 
    jmp unhandled_interrupt
#INT #12
.orgfill 0x214A   # 
    jmp unhandled_interrupt
#INT #13
.orgfill 0x2150   #IR RECEIVE LOW TO HIGH
    jmp unhandled_interrupt
#INT #14
.orgfill 0x2156   #SHOCK DETECTOR
    jmp unhandled_interrupt
#INT #15
.orgfill 0x215C   #KEY PRESS: POWER BUTTON
    # when the power button is pressed we want to turn off the device
    # that's why we handle this IRQ and jump to the power button IRQ handler
    jmp int_power_key
#INT #16
.orgfill 0x2162   #KEY PRESS: D-PAD RIGHT
    jmp int_right
#INT #17
.orgfill 0x2168   #KEY PRESS: D-PAD LEFT
    jmp int_left
#INT #18
.orgfill 0x216E   #KEY PRESS: D-PAD DOWN
    jmp int_down
#INT #19
.orgfill 0x2174   #KEY PRESS: D-PAD UP
    jmp int_up
#INT #20
.orgfill 0x217A   #KEY PRESS: C KEY
    jmp unhandled_interrupt
#INT #21
.orgfill 0x2180   #KEY PRESS: B KEY
    jmp int_b
#INT #22
.orgfill 0x2186   #KEY PRESS: A KEY
    jmp unhandled_interrupt
#INT #23
.orgfill 0x218C   # 
    jmp unhandled_interrupt
#INT #24
.orgfill 0x2192   # 
    jmp unhandled_interrupt
#INT #25
.orgfill 0x2198   # 
    jmp unhandled_interrupt
    
### Pokemon Mini game header
.orgfill 0x219E 
.orgfill 0x21A4 
.db "NINTENDO"     # magic signature checked by the BIOS
.db "LUPI"         # game code - 4 byte
.db "PokeRemote  " # name of ROM, 12 chars max
.orgfill 0x21Bc
.db "2P"

# end of rom header, start of program code
.orgfill 0x21D0

# dummy functions for all unhandled interrupts
# this function will just return from the interrupt
unhandled_interrupt:
    reti   #reti - return from interrupt


### The main function for infrared transfer, this enables/disables the modulation timer 
### which will generate the carrier frequency.
sendpulse:
	push	a
	
	mov		a, [x2]
	cmp		a, 1
	jnz		isnotone

	#activate modulation timer	
	orb		[nn+REG_EVENT1P],INT1P_TIMER1OVERFLOW
	orb		[nn+REG_EVENT1S],INT1S_TIMER1OVERFLOW
	jmp		chkdone
isnotone:

	cmp		a, 255
	jnz		ncodefin
	#send complete!
	#turn off all timers
	mov		[nn+REG_EVENT1P],0
	mov		[nn+REG_EVENT1S],0
	#turn on drawing - note: don't turn the LCD off in REG_LCD_CNT1 because it will actually cut down power for the
	#LCD and the IR transfer will be interrupted because re-initializing the LCD 2000 times a second is a 
	#bit too much for the PM and the PM will reboot
	movb	[nn+REG_LCD_CNT0], LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16|LCD0_SPRITES
	jmp		codefin
ncodefin:
	
	#deactivate modulation timer
	andb	[nn+REG_EVENT1P],~INT1P_TIMER1OVERFLOW
	andb	[nn+REG_EVENT1S],~INT1S_TIMER1OVERFLOW
	#turn off IR diode
	mov		[nn+0x61], 0x44
	
chkdone:
	
	#advance the cursor to next pulse
	inc		x2
	
codefin:

	pop		a
	#this works best... i think this way we can make sure that the pulse interrupt won't be interrupted by the 
	#modulation interrupt.
	mov		[nn+REG_INT_FLAG1], IF_TIMER2OVERFLOW
	reti


#cursor up
int_up:
	push	a
	movb	[nn+REG_INT_FLAG2],IF_KEY_UP

	movb	a, [gridsel]
    andb	a, 0x18
    cmp		a, 0
    jz		_dunsub

    movb	a, [OAM+1]
    sub		a, 12
    movb	[OAM+1], a
    
    movb	a, [gridsel]
    sub		a, 0x8
    movb	[gridsel], a
    
_dunsub:
	pop		a
	reti

#cursor down
int_down:
	push	a
	movb	[nn+REG_INT_FLAG2],IF_KEY_DOWN

	movb	a, [gridsel]
    andb	a, 0x18
    cmp		a, 0x18
    jz		_dunadd

    movb	a, [OAM+1]
    add		a, 12
    movb	[OAM+1], a
    
    movb	a, [gridsel]
    add		a, 0x8
    movb	[gridsel], a

_dunadd:
	pop		a
	reti

#cursor left
int_left:
	push	a
	movb	[nn+REG_INT_FLAG2],IF_KEY_LEFT
	
	movb	a, [gridsel]
    andb	a, 0x7
    cmp		a, 0
    jz		_dunsub
	
    movb	a, [OAM+0]
    sub		a, 19
    movb	[OAM+0], a

	movb	a, [gridsel]
    dec		a
    movb	[gridsel], a

_dunsub:
	pop		a
	reti

#cursor right
int_right:
	push	a
	movb	[nn+REG_INT_FLAG2],IF_KEY_RIGHT
	
	movb	a, [gridsel]
    andb	a, 0x7
    cmp		a, 0x4
    jz		_dunadd
	
    movb	a, [OAM+0]
    add		a, 19
    movb	[OAM+0], a
    
    movb	a, [gridsel]
    inc		a
    movb	[gridsel], a

_dunadd:
	pop		a
	reti


#key b handler - debug only
int_b:
	movb	[nn+REG_INT_FLAG2],IF_KEY_B
	push	x1
	movw	x1, [REG_BASE+REG_TIMER1_PRESET]
	sub		x1,2
	movw	[REG_BASE+REG_TIMER1_PRESET], x1
	pop		x1
	reti

#power key handler - turn off
int_power_key:
    orb		[nn+REG_INT_FLAG2],IF_KEY_POWER
    test	[nn+REG_KEYPAD],KEY_POWER
    jnz		noturnoff
    cint	$24
noturnoff:
    reti

############################## code entry point ######################################
start:

    # set SP to end of general purpose RAM (stack grows downwards)
    movw	sp, 0x2000
    # NN register points to hardware registers
    movw	nn, 0x2000


    movb	[nn+REG_EVENT2P],INT2P_KEYPAD
    movb	[nn+REG_EVENT2S],INT2S_KEY_POWER|INT2S_KEY_UP|INT2S_KEY_DOWN|INT2S_KEY_LEFT|INT2S_KEY_RIGHT #|INT2S_KEY_B #for debug


    movb	[nn+REG_LCD_CNT0], LCD0_RENDER|LCD0_TILEBG|LCD0_MAP12x16|LCD0_SPRITES
    movb	[nn+REG_LCD_CNT1], LCD1_ENABLE|LCD1_REFRESH1

	#setup screen
    movb	b, 96
    movw	HL, TILEMAP+96
bglinear:
    movb	[HL], b
    dec		HL
    jdbnz       bglinear

	#set gfx bases
    mov		x1, scrremote
    mov		[REG_BASE+REG_LCD_TILEBGMEM], x1
    movw	x1, cursor
    movw	[REG_BASE+REG_LCD_SPRITEMEM], x1

	#set up cursor
	movw	nn, OAM
    movb	[nn+0], 18
    movb	[nn+1], 28
    movb	[nn+2], 0
    movb	[nn+3], OAM_ENABLE
    movw	nn, REG_BASE

	# enable IR circuit
	movb	[nn+0x60], 0x22
	movb	[nn+0x61], 0x44 #this is the default value anyways

	#x2 is pointer to remote code
	mov		x2, remotecode
	mov		[x2], 255

	#set up modulation timer (should run at 38Khz)
	movw	x1, 52 #38 KHz
	movw	[REG_BASE+REG_TIMER1_PRESET], x1

	mov		[nn+REG_TIMER1_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ

	mov		[nn+REG_TIMER1_CNT1], $02 | TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER1_CNT2], $02

	#set up pulse timer (should run at 2000 Hz - 0.5ms per pulse)
	movw	x1, 1000 #2000 Hz
	movw	[REG_BASE+REG_TIMER2_PRESET], x1

	mov		[nn+REG_TIMER2_PRESCALE], PRESCALE_ENABLE | PRESCALE_FREQ_2MHZ

	mov		[nn+REG_TIMER2_CNT1], $02 | TIMER_ENABLE | TIMER_PRESET
	mov		[nn+REG_TIMER2_CNT2], $02

	#make sure no timer interrupts are activated
	mov		[nn+REG_EVENT1P],0
	mov		[nn+REG_EVENT1S],0
			
	mov		[nn+REG_TIMER_CONTROL], TIMERS_ON

    # Activate all interrupts
    mov		flags, 0
    
    ### endless loop - check for input
game_end:
	push	BA

	#check for key down	
	mov		a, [nn+REG_KEYPAD]
	test	a, KEY_A
	jnz		int_a_exit

	#key is down, check if a code is currently played
	mov		a, [x2]
	cmp		a, 255
	jnz		int_a_exit
	
	mov			x1, lewkup
	mov			a, [gridsel]
	mov			b, 0
	add			BA, BA
	add			x1, BA
	mov			x1, [x1]
	cmp			x1, 0
	jz			int_a_exit #no code maped to selection
	
	movb		[nn+REG_LCD_CNT0], 0
	call		loadcode
	movw		x2, remotecode
	mov			[nn+REG_EVENT1P],INT1P_TIMER2OVERFLOW
	mov			[nn+REG_EVENT1S],INT1S_TIMER2OVERFLOW
    
int_a_exit:
	pop		BA
	
	jmp		game_end

#############################################################################################
# loadcode function - converts the "bit-code" to 0.5ms pulses and stores them into a buffer #
#############################################################################################
loadcode:
	push	b
	push	x2
	#x1 = code to load

	#load up pointer
	mov		x2, remotecode
	movb	[x2], 0 #this improves signal quality for first pulse because timers are a bit fucked up
	inc		x2
	
	#set counter value
	mov		b, 13

_copyloop:

	mov		a, [x1]
	cmp		a, 1
	jnz		_not1
	
	
	#store the sequence of 1,0,0,0,0,0,0,0,0,0 - each element is 0.5 ms long
	
	#store code for 1
	movb	[x2], 1
	mov		a, 0
	movb	[x2+1], a
	movb	[x2+2], a
	movb	[x2+3], a
	movb	[x2+4], a
	movb	[x2+5], a
	movb	[x2+6], a
	movb	[x2+7], a
	movb	[x2+8], a
	movb	[x2+9], a
	add		x2, 10
	
	jmp		_escape
_not1:

	#store the sequence of 1,0,0,0,0 - each element is 0.5 ms long

	#store code	for 0
	movb	[x2], 1
	mov		a, 0
	movb	[x2+1], a
	movb	[x2+2], a
	movb	[x2+3], a
	movb	[x2+4], a
	add		x2, 5
	
_escape:

	inc		x1
	jdbnz	_copyloop

	#b=255-(x2-remotecode)
	mov		BA, x2
	sub		BA, remotecode
	xchg	a, b
	mov		a, 255
	sub		a, b
	mov		b, a
	
_fill:
	mov		[x2], 0
	inc		x2
	jdbnz	_fill

	#stop byte
	mov		[x2], 255

	pop		x2
	pop		b
	ret


#gfx
.align 8
scrremote:
.incbin	scrremote.bin

.align 64
cursor:
.incbin	cursor.bin



#This is a table used to look up the code of the selected operation
lewkup:
.dw		code_1,		code_2,		code_3,		code_4,		code_5,		0,			0,			0
.dw		code_6,		code_7,		code_8,		code_9,		code_0,		0,			0,			0
.dw		code_vp,	code_vm,	code_pp,	code_pm,	code_mute,	0,			0,			0
.dw		code_off,	0,			0,			0,			0,			0,			0,			0

#these are the remote codes of my rct100 remote control (thomson)
#the first 4 bits are for synchronization, the last bit is a stop bit
code_1:
.db		0,0,1,1, 1,0,0,0,0,0,0,0 ,1

code_2:
.db		0,0,1,1, 0,0,0,0,1,0,0,0 ,1

code_3:
.db		0,0,1,1, 1,0,0,1,0,0,0,0 ,1

code_4:
.db		0,0,1,1, 0,0,0,0,0,0,0,1 ,1

code_5:
.db		0,0,1,1, 1,0,0,0,1,0,0,1 ,1

code_6:
.db		0,0,1,1, 0,0,0,1,0,0,0,1 ,1

code_7:
.db		0,0,1,1, 1,0,0,0,0,0,1,0 ,1

code_8:
.db		0,0,1,1, 0,0,0,0,1,0,1,0 ,1

code_9:
.db		0,0,1,1, 1,0,0,1,0,0,1,0 ,1

code_0:
.db		0,0,1,1, 0,0,0,0,1,1,1,0 ,1


code_vp:
.db		0,0,1,1, 1,0,1,0,1,0,0,1 ,1

code_vm:
.db		0,0,1,1, 0,0,1,0,1,0,1,0 ,1

code_pp:
.db		0,0,1,1, 1,0,1,0,0,1,0,1 ,1

code_pm:
.db		0,0,1,1, 0,0,1,0,0,1,1,1 ,1

code_mute:
.db		0,0,1,1, 0,0,0,0,0,1,0,1 ,1

code_off:
.db		0,0,1,1, 1,0,0,1,1,1,0,1 ,1
