.orgfill 0x1800

charcnt:	.db	0			#only accepts 0
charpos:	.dw	0
textpos:	.dw	0

.include irqstuff.asm

#-------------------------------- CART HEADER -------------------------------
.orgfill 0x21A4 
.db "NINTENDO"					#signature checked by the BIOS
.db "DEMO"
.db "POPSCROL"					#name of rom, 12 chars max
.orgfill 0x21Bc
.db "2P"               

#--------------------------------- CART MAIN --------------------------------
.orgfill 0x21D0
.equ		tilemap	$1360

unhandled_interrupt:
		reti


start:		mov	sp,$2000		#set SP

		movx	hl,0			# important also for NN addressing!
		movw	nn,$2000		# NN reg always points to hardware regs
		movb	[nn+$80],8+2		# set tiled mode 12x8, non-inverted
		movb	[nn+$81],9		# set gfx mode fast
  
		mov	x1, poptiles		# set tiles graphix base
		mov	[$2082],x1

		mov	x1,tilemap		#heres the tilemap
		mov	b,$60-1
clear_map:	movb	[x1],0
		jdbnz	clear_map

loop:		movb	b,6
		movb	[charcnt],b		#reset pixel count

		mov	x1,scrtext
		mov	hl,[textpos]
		add	x1,hl
		movb	a,[x1]			#get letter with correct offset
		cmp	a,$5b			#[ means end of text
		jz	textwrap
		cmp	a,$20			#got a space ?
		jz	norumble
		mov	[nn+$61],$10		#RUMBLE!
	
norumble:	subb	a,$20			#first char=space
		mov	l,48			#6*8 is char size
		mul	l,a


wait:		mov	x1,3			#slow it down
wait1:		test	[nn+$8a], $10		#wait vsync
		jz	wait1
wait2:		test	[nn+$8a], $10
		jnz	wait2
		dec	x1
		jnz	wait1


		mov	[nn+$61],$64		#stop rumbler :)
keyloop:	mov	b,[nn+$52]
		test	b,$80			#test if power button is pressed
		jz	poweroff		#if yes then power off
		test	b,1			#button A
		jz	keyloop
		
		
		mov	x1,tilemap
		mov	x2,tilemap+1
		mov	b,12*8-1		#12*8 tiles on screen
scrolloop:	movb	[x1],[x2]
		inc	x1
		inc	x2
		jdbnz	scrolloop


		mov	x1,popchars
		add	x1,hl			#offset (includes pixel offset)
		mov	x2,tilemap+11
		mov	b,8
charloop:	movb	[x2],[x1]		#copy one char line (vertical)
		add	x1,6
		add	x2,12
		jdbnz	charloop

		movb	a,[charcnt]
		decb	a
		jz	nextchar		#if already copied 6 lines, next char
		movb	[charcnt],a		#if not, store pixelcount
		inc	hl			#increase pixel count
		jmp	wait
    

nextchar:	mov	hl,[textpos]
		incw	hl			#move to next letter
		mov	[textpos],hl
		jmp	loop

textwrap:	mov	hl,0
		mov	[textpos],hl		#reset text position
		jmp	loop

poweroff:	cint	$24			#bye bye



scrtext:
 .db	"HELLO IT",$27,"S P0P FROM TEAM POKEME SPEAKING :) THIS IS MY FIRST (LAME) CODE "
 .db	"ON NINTENDO",$27,"S POKEMON MINI CONSOLE ... AFTER ABOUT 3 MONTHS OF HACKING, TEAM "
 .db	"POKEME ARCHIVED A GREAT VICTORY OVER THIS LITTLE SYSTEM ... TO CHECK OUT OUR "
 .db	"STUFF VISIT HTTP://POKEME.SHIZZLE.IT ! NOW THE BEST PART, THE GR33T1NG5 =) "
 .db	"FUNKY MINI-GREETS GO TO JUSTBURN, DAVEX, DARKFADER, COSTIS, MR.SPIV, BOSLEY, "
 .db	"ASTERICK, PH0X, ORION, LAMEBOYADVANCE AND ALL THE OTHERS IN #PMDEV ......... "
 .db	"REAL-LIFE FRIENDS THAT CONTRIBUTED TO THE PM PROJECT: BUSTA, SNITZER, WALD1"
 .db	" & GURU .................. WRAP! .......... ["

.include popfont.asm

.orgfill 0x5000
poptiles:
 .db $81,$00,$00,$00,$00,$00,$00,$81
 .db $7e,$ff,$ff,$ff,$ff,$ff,$ff,$7e
 
 
;.orgfill 512*1024-19
;.db "programmed by p0ppy"

